ncbi_mult_taxo_gbnm_info(source, 'https://ftp.ncbi.nih.gov/pub/taxonomy/taxdmp.zip').
ncbi_mult_taxo_gbnm_info(datetime, datetime(2025, 9, 26, 20, 3, 5)).
ncbi_mult_taxo_gbnm_info(header, row(taxo, gbnm)).
ncbi_mult_taxo_gbnm_info(data_types, data_types(integer, atom)).
ncbi_mult_taxo_gbnm_info(unique_lengths, unique_lengths(32118, 31844, 32118)).
ncbi_mult_taxo_gbnm_info(relation_type, relation_type(1, 1)).

ncbi_mult_taxo_gbnm(2, bacteria).

ncbi_mult_taxo_gbnm(29, 'fruiting gliding bacteria').
ncbi_mult_taxo_gbnm(72, 'Scheibenbakterien Muller 1911').
ncbi_mult_taxo_gbnm(139, 'Lyme disease spirochete').
ncbi_mult_taxo_gbnm(161, 'syphilis treponeme').
ncbi_mult_taxo_gbnm(168, 'yaws treponeme').
ncbi_mult_taxo_gbnm(543, enterobacteria).
ncbi_mult_taxo_gbnm(566, 'CDC Enteric Group 1').
ncbi_mult_taxo_gbnm(638, 'son-killer infecting Nasonia vitripennis').
ncbi_mult_taxo_gbnm(766, rickettsias).
ncbi_mult_taxo_gbnm(779, 'heartwater rickettsia').
ncbi_mult_taxo_gbnm(786, 'agent of rickettsialpox').
ncbi_mult_taxo_gbnm(950, 'Potomac horse fever agent').
ncbi_mult_taxo_gbnm(976, 'CFB group bacteria').
ncbi_mult_taxo_gbnm(1035, 'cat scratch disease bacillus').
ncbi_mult_taxo_gbnm(1090, 'green sulfur bacteria').
ncbi_mult_taxo_gbnm(1106, 'filamentous anoxygenic phototrophic bacteria').
ncbi_mult_taxo_gbnm(1117, cyanobacteria).
ncbi_mult_taxo_gbnm(1224, proteobacteria).
ncbi_mult_taxo_gbnm(1236, 'g-proteobacteria').
ncbi_mult_taxo_gbnm(1239, firmicutes).
ncbi_mult_taxo_gbnm(1357, 'lactic streptococci').
ncbi_mult_taxo_gbnm(1392, 'anthrax bacterium').
ncbi_mult_taxo_gbnm(1524, 'Tyzzer\'s bacillus').
ncbi_mult_taxo_gbnm(1568, 'Quin\'s oval').
ncbi_mult_taxo_gbnm(1653, 'Coryneform bacteria').
ncbi_mult_taxo_gbnm(1760, 'high G+C Gram-positive bacteria').
ncbi_mult_taxo_gbnm(2709, 'Ichang papeda').
ncbi_mult_taxo_gbnm(2711, 'sweet orange').
ncbi_mult_taxo_gbnm(2759, eukaryotes).
ncbi_mult_taxo_gbnm(2763, 'red algae').
ncbi_mult_taxo_gbnm(2769, carragheen).
ncbi_mult_taxo_gbnm(2785, 'asakusa nori').
ncbi_mult_taxo_gbnm(2786, laver).
ncbi_mult_taxo_gbnm(2788, 'susabi-nori').
ncbi_mult_taxo_gbnm(2822, 'Dulse').
ncbi_mult_taxo_gbnm(2825, 'golden algae').
ncbi_mult_taxo_gbnm(2830, haptophytes).
ncbi_mult_taxo_gbnm(2833, 'yellow-green algae').
ncbi_mult_taxo_gbnm(2836, diatoms).
ncbi_mult_taxo_gbnm(2864, dinoflagellates).
ncbi_mult_taxo_gbnm(2870, 'brown algae').
ncbi_mult_taxo_gbnm(2889, 'Atlantic wakame').
ncbi_mult_taxo_gbnm(3027, cryptomonads).
ncbi_mult_taxo_gbnm(3035, euglenoids).
ncbi_mult_taxo_gbnm(3041, 'green algae').
ncbi_mult_taxo_gbnm(3116, 'hollow green seaweed').
ncbi_mult_taxo_gbnm(3119, 'sea lettuce').
ncbi_mult_taxo_gbnm(3193, 'land plants').
ncbi_mult_taxo_gbnm(3195, liverworts).
ncbi_mult_taxo_gbnm(3197, liverwort).
ncbi_mult_taxo_gbnm(3208, mosses).
ncbi_mult_taxo_gbnm(3244, 'spike mosses').
ncbi_mult_taxo_gbnm(3247, 'Martens\'s spike moss').
ncbi_mult_taxo_gbnm(3250, 'clubmoss family').
ncbi_mult_taxo_gbnm(3252, 'stag\'s-horn clubmoss').
ncbi_mult_taxo_gbnm(3255, horsetails).
ncbi_mult_taxo_gbnm(3257, horstails).
ncbi_mult_taxo_gbnm(3258, 'field horsetail').
ncbi_mult_taxo_gbnm(3260, 'giant horsetail').
ncbi_mult_taxo_gbnm(3262, 'Dutch rush').
ncbi_mult_taxo_gbnm(3267, 'turnip fern').
ncbi_mult_taxo_gbnm(3277, 'ostrich fern').
ncbi_mult_taxo_gbnm(3279, 'western swordfern').
ncbi_mult_taxo_gbnm(3284, 'cinnamon fern').
ncbi_mult_taxo_gbnm(3296, cycads).
ncbi_mult_taxo_gbnm(3300, 'Altenstein\'s bread tree').
ncbi_mult_taxo_gbnm(3311, 'maidenhair tree').
ncbi_mult_taxo_gbnm(3316, 'western redcedar').
ncbi_mult_taxo_gbnm(3319, 'fir trees').
ncbi_mult_taxo_gbnm(3320, 'California red fir').
ncbi_mult_taxo_gbnm(3322, 'deodar cedar').
ncbi_mult_taxo_gbnm(3325, larches).
ncbi_mult_taxo_gbnm(3326, tamarack).
ncbi_mult_taxo_gbnm(3327, 'western larch').
ncbi_mult_taxo_gbnm(3329, 'Norway spruce').
ncbi_mult_taxo_gbnm(3330, 'white spruce').
ncbi_mult_taxo_gbnm(3331, 'Colorado spruce').
ncbi_mult_taxo_gbnm(3332, 'Sitka spruce').
ncbi_mult_taxo_gbnm(3334, 'Engelmann\'s spruce').
ncbi_mult_taxo_gbnm(3338, 'foxtail pine').
ncbi_mult_taxo_gbnm(3339, 'lodgepole pine').
ncbi_mult_taxo_gbnm(3340, pinyon).
ncbi_mult_taxo_gbnm(3341, 'Bhutan pine').
ncbi_mult_taxo_gbnm(3342, 'Krempf\'s pine').
ncbi_mult_taxo_gbnm(3343, 'sugar pine').
ncbi_mult_taxo_gbnm(3344, 'western bristlecone pine').
ncbi_mult_taxo_gbnm(3345, 'Western white pine').
ncbi_mult_taxo_gbnm(3346, 'stone pine').
ncbi_mult_taxo_gbnm(3347, 'Monterey pine').
ncbi_mult_taxo_gbnm(3348, 'Eastern white pine').
ncbi_mult_taxo_gbnm(3349, 'Scots pine').
ncbi_mult_taxo_gbnm(3350, 'Japanese black pine').
ncbi_mult_taxo_gbnm(3351, 'Coulter pine').
ncbi_mult_taxo_gbnm(3352, 'loblolly pine').
ncbi_mult_taxo_gbnm(3357, 'Douglas-fir').
ncbi_mult_taxo_gbnm(3358, hemlocks).
ncbi_mult_taxo_gbnm(3359, 'western hemlock').
ncbi_mult_taxo_gbnm(3366, 'Henkel\'s yellowwood').
ncbi_mult_taxo_gbnm(3369, 'Japanese cedar').
ncbi_mult_taxo_gbnm(3387, jointfirs).
ncbi_mult_taxo_gbnm(3398, 'flowering plants').
ncbi_mult_taxo_gbnm(3404, 'cucumber-tree').
ncbi_mult_taxo_gbnm(3407, 'saucer magnolia').
ncbi_mult_taxo_gbnm(3426, 'wild cinnamon').
ncbi_mult_taxo_gbnm(3429, 'eastern sweetshrub').
ncbi_mult_taxo_gbnm(3430, 'western sweetshrub').
ncbi_mult_taxo_gbnm(3435, avocado).
ncbi_mult_taxo_gbnm(3438, 'California bay').
ncbi_mult_taxo_gbnm(3442, 'Japanese goldthread').
ncbi_mult_taxo_gbnm(3444, 'love-in-a-mist').
ncbi_mult_taxo_gbnm(3445, buttercups).
ncbi_mult_taxo_gbnm(3447, 'tall buttercup').
ncbi_mult_taxo_gbnm(3452, 'virgin\'s bower').
ncbi_mult_taxo_gbnm(3457, 'serendipity berry').
ncbi_mult_taxo_gbnm(3464, 'pink corydalis').
ncbi_mult_taxo_gbnm(3467, 'California poppy').
ncbi_mult_taxo_gbnm(3469, 'opium poppy').
ncbi_mult_taxo_gbnm(3471, bloodroots).
ncbi_mult_taxo_gbnm(3472, 'red puccoon').
ncbi_mult_taxo_gbnm(3481, 'hemp family').
ncbi_mult_taxo_gbnm(3485, 'Japanese hop').
ncbi_mult_taxo_gbnm(3486, 'European hop').
ncbi_mult_taxo_gbnm(3489, jackfruit).
ncbi_mult_taxo_gbnm(3490, chempedak).
ncbi_mult_taxo_gbnm(3493, figs).
ncbi_mult_taxo_gbnm(3494, 'common fig').
ncbi_mult_taxo_gbnm(3496, 'Osage orange').
ncbi_mult_taxo_gbnm(3497, mulberries).
ncbi_mult_taxo_gbnm(3498, 'white mulberry').
ncbi_mult_taxo_gbnm(3501, 'great nettle').
ncbi_mult_taxo_gbnm(3505, 'European white birch').
ncbi_mult_taxo_gbnm(3507, 'paper birch').
ncbi_mult_taxo_gbnm(3508, 'river birch').
ncbi_mult_taxo_gbnm(3510, 'wax myrtle').
ncbi_mult_taxo_gbnm(3512, 'northern red oak').
ncbi_mult_taxo_gbnm(3513, 'white oak').
ncbi_mult_taxo_gbnm(3522, 'swamp oak').
ncbi_mult_taxo_gbnm(3527, 'American pokeweed').
ncbi_mult_taxo_gbnm(3528, 'food pokeweed').
ncbi_mult_taxo_gbnm(3538, 'garden four-o\'clock').
ncbi_mult_taxo_gbnm(3544, 'common iceplant').
ncbi_mult_taxo_gbnm(3555, 'sugar beet').
ncbi_mult_taxo_gbnm(3559, 'lamb\'s quarters').
ncbi_mult_taxo_gbnm(3560, 'red goosefoot').
ncbi_mult_taxo_gbnm(3562, spinach).
ncbi_mult_taxo_gbnm(3565, 'smooth pigweed').
ncbi_mult_taxo_gbnm(3567, amaranth).
ncbi_mult_taxo_gbnm(3570, 'clove pink').
ncbi_mult_taxo_gbnm(3571, soapwort).
ncbi_mult_taxo_gbnm(3572, 'common soapwort').
ncbi_mult_taxo_gbnm(3573, campions).
ncbi_mult_taxo_gbnm(3595, 'false Christmas cactus').
ncbi_mult_taxo_gbnm(3600, 'snake-eyes').
ncbi_mult_taxo_gbnm(3607, 'Virginia creeper').
ncbi_mult_taxo_gbnm(3617, 'common buckwheat').
ncbi_mult_taxo_gbnm(3619, 'bitter dock').
ncbi_mult_taxo_gbnm(3621, 'garden rhubarb').
ncbi_mult_taxo_gbnm(3625, 'golden kiwifruit').
ncbi_mult_taxo_gbnm(3627, kiwifruit).
ncbi_mult_taxo_gbnm(3631, 'China jute').
ncbi_mult_taxo_gbnm(3634, 'sea-island cotton').
ncbi_mult_taxo_gbnm(3635, cotton).
ncbi_mult_taxo_gbnm(3641, cacao).
ncbi_mult_taxo_gbnm(3645, 'Brazil nut').
ncbi_mult_taxo_gbnm(3649, papaya).
ncbi_mult_taxo_gbnm(3652, 'red bryony').
ncbi_mult_taxo_gbnm(3654, watermelon).
ncbi_mult_taxo_gbnm(3656, muskmelon).
ncbi_mult_taxo_gbnm(3657, 'oriental pickling melon').
ncbi_mult_taxo_gbnm(3658, cantaloupe).
ncbi_mult_taxo_gbnm(3659, cucumber).
ncbi_mult_taxo_gbnm(3660, marrows).
ncbi_mult_taxo_gbnm(3661, 'winter squash').
ncbi_mult_taxo_gbnm(3662, 'crookneck pumpkin').
ncbi_mult_taxo_gbnm(3664, 'vegetable marrow').
ncbi_mult_taxo_gbnm(3668, 'white-flowered gourd').
ncbi_mult_taxo_gbnm(3670, 'smooth loofah').
ncbi_mult_taxo_gbnm(3672, 'balsam apple').
ncbi_mult_taxo_gbnm(3673, 'bitter melon').
ncbi_mult_taxo_gbnm(3674, 'spiny bitter cucumber').
ncbi_mult_taxo_gbnm(3677, 'Chinese cucumber').
ncbi_mult_taxo_gbnm(3679, 'jumping cucumber').
ncbi_mult_taxo_gbnm(3684, passionflowers).
ncbi_mult_taxo_gbnm(3685, granadilla).
ncbi_mult_taxo_gbnm(3689, poplars).
ncbi_mult_taxo_gbnm(3690, 'hybrid black poplar').
ncbi_mult_taxo_gbnm(3691, 'black poplar').
ncbi_mult_taxo_gbnm(3693, 'quaking aspen').
ncbi_mult_taxo_gbnm(3694, 'black cottonwood').
ncbi_mult_taxo_gbnm(3700, 'mustard family').
ncbi_mult_taxo_gbnm(3702, 'thale cress').
ncbi_mult_taxo_gbnm(3707, 'brown mustard').
ncbi_mult_taxo_gbnm(3708, rape).
ncbi_mult_taxo_gbnm(3709, rutabaga).
ncbi_mult_taxo_gbnm(3710, 'black mustard').
ncbi_mult_taxo_gbnm(3711, 'field mustard').
ncbi_mult_taxo_gbnm(3712, 'wild cabbage').
ncbi_mult_taxo_gbnm(3713, kale).
ncbi_mult_taxo_gbnm(3714, 'Chinese kale').
ncbi_mult_taxo_gbnm(3716, cabbage).
ncbi_mult_taxo_gbnm(3719, 'shepherd\'s purse').
ncbi_mult_taxo_gbnm(3721, 'Abyssinian crambe').
ncbi_mult_taxo_gbnm(3724, 'common stock').
ncbi_mult_taxo_gbnm(3726, radish).
ncbi_mult_taxo_gbnm(3728, 'white mustard').
ncbi_mult_taxo_gbnm(3735, 'horseradish tree').
ncbi_mult_taxo_gbnm(3741, sapodilla).
ncbi_mult_taxo_gbnm(3743, 'miracle fruit').
ncbi_mult_taxo_gbnm(3747, strawberry).
ncbi_mult_taxo_gbnm(3750, apple).
ncbi_mult_taxo_gbnm(3752, 'European crab apple').
ncbi_mult_taxo_gbnm(3755, almond).
ncbi_mult_taxo_gbnm(3756, 'bitter almond').
ncbi_mult_taxo_gbnm(3758, plum).
ncbi_mult_taxo_gbnm(3759, 'Yoshino cherry').
ncbi_mult_taxo_gbnm(3760, peach).
ncbi_mult_taxo_gbnm(3766, pears).
ncbi_mult_taxo_gbnm(3802, 'American black currant').
ncbi_mult_taxo_gbnm(3806, 'camel\'s foot tree').
ncbi_mult_taxo_gbnm(3811, 'bead tree').
ncbi_mult_taxo_gbnm(3813, 'silk tree').
ncbi_mult_taxo_gbnm(3816, 'Indian licorice').
ncbi_mult_taxo_gbnm(3818, peanut).
ncbi_mult_taxo_gbnm(3821, 'pigeon pea').
ncbi_mult_taxo_gbnm(3823, 'jack bean').
ncbi_mult_taxo_gbnm(3824, 'sword bean').
ncbi_mult_taxo_gbnm(3827, chickpea).
ncbi_mult_taxo_gbnm(3829, 'sunn hemp').
ncbi_mult_taxo_gbnm(3830, 'smooth rattlebox').
ncbi_mult_taxo_gbnm(3832, guar).
ncbi_mult_taxo_gbnm(3837, mucana).
ncbi_mult_taxo_gbnm(3844, 'coral bean').
ncbi_mult_taxo_gbnm(3845, 'Indian coral tree').
ncbi_mult_taxo_gbnm(3847, soybean).
ncbi_mult_taxo_gbnm(3852, 'Scotch laburnum').
ncbi_mult_taxo_gbnm(3854, 'yellow vetchling').
ncbi_mult_taxo_gbnm(3856, 'flat-pod pea').
ncbi_mult_taxo_gbnm(3857, 'rough pea').
ncbi_mult_taxo_gbnm(3858, 'yellow-flowered pea').
ncbi_mult_taxo_gbnm(3859, 'sweet pea').
ncbi_mult_taxo_gbnm(3860, 'Indian pea').
ncbi_mult_taxo_gbnm(3861, 'spring vetchling').
ncbi_mult_taxo_gbnm(3862, 'Tangier pea').
ncbi_mult_taxo_gbnm(3864, lentil).
ncbi_mult_taxo_gbnm(3866, 'white popinac').
ncbi_mult_taxo_gbnm(3868, 'winged pea').
ncbi_mult_taxo_gbnm(3870, 'white lupine').
ncbi_mult_taxo_gbnm(3871, 'narrow-leaved blue lupine').
ncbi_mult_taxo_gbnm(3872, 'tree lupine').
ncbi_mult_taxo_gbnm(3873, 'yellow lupine').
ncbi_mult_taxo_gbnm(3874, 'large-leaved lupine').
ncbi_mult_taxo_gbnm(3877, medics).
ncbi_mult_taxo_gbnm(3878, 'sickle medic').
ncbi_mult_taxo_gbnm(3879, alfalfa).
ncbi_mult_taxo_gbnm(3880, 'barrel medic').
ncbi_mult_taxo_gbnm(3882, 'common sainfoin').
ncbi_mult_taxo_gbnm(3884, 'lima bean').
ncbi_mult_taxo_gbnm(3885, 'common bean').
ncbi_mult_taxo_gbnm(3888, 'garden pea').
ncbi_mult_taxo_gbnm(3891, 'winged bean').
ncbi_mult_taxo_gbnm(3893, 'kudzu vine').
ncbi_mult_taxo_gbnm(3897, 'Japanese pagoda tree').
ncbi_mult_taxo_gbnm(3899, 'white clover').
ncbi_mult_taxo_gbnm(3902, furze).
ncbi_mult_taxo_gbnm(3905, 'bird vetch').
ncbi_mult_taxo_gbnm(3906, 'fava bean').
ncbi_mult_taxo_gbnm(3908, 'common vetch').
ncbi_mult_taxo_gbnm(3909, 'narrow-leaved vetch').
ncbi_mult_taxo_gbnm(3911, 'hairy vetch').
ncbi_mult_taxo_gbnm(3914, 'adzuki bean').
ncbi_mult_taxo_gbnm(3915, 'black gram').
ncbi_mult_taxo_gbnm(3916, 'mung bean').
ncbi_mult_taxo_gbnm(3917, cowpea).
ncbi_mult_taxo_gbnm(3920, cowpea).
ncbi_mult_taxo_gbnm(3922, 'Japanese wisteria').
ncbi_mult_taxo_gbnm(3933, 'cider tree').
ncbi_mult_taxo_gbnm(3939, 'evening primroses').
ncbi_mult_taxo_gbnm(3940, 'Appalachian evening primrose').
ncbi_mult_taxo_gbnm(3942, 'German evening primrose').
ncbi_mult_taxo_gbnm(3956, 'Rangoon creeper').
ncbi_mult_taxo_gbnm(3960, 'oil nut').
ncbi_mult_taxo_gbnm(3963, 'showy mistletoe family').
ncbi_mult_taxo_gbnm(3965, 'Columbian mistletoe').
ncbi_mult_taxo_gbnm(3968, 'Argentine mistletoe').
ncbi_mult_taxo_gbnm(3969, 'California mistletoe').
ncbi_mult_taxo_gbnm(3970, 'American mistletoe').
ncbi_mult_taxo_gbnm(3972, 'European mistletoe').
ncbi_mult_taxo_gbnm(3981, 'rubber tree').
ncbi_mult_taxo_gbnm(3983, cassava).
ncbi_mult_taxo_gbnm(3985, 'dog\'s mercury').
ncbi_mult_taxo_gbnm(3986, 'annual mercury').
ncbi_mult_taxo_gbnm(3988, 'castor bean').
ncbi_mult_taxo_gbnm(3990, spurges).
ncbi_mult_taxo_gbnm(3993, 'leafy spurge').
ncbi_mult_taxo_gbnm(3999, jojoba).
ncbi_mult_taxo_gbnm(4006, flax).
ncbi_mult_taxo_gbnm(4013, 'Chinese lacquer tree').
ncbi_mult_taxo_gbnm(4020, nasturtium).
ncbi_mult_taxo_gbnm(4022, 'maple trees').
ncbi_mult_taxo_gbnm(4023, 'box elder').
ncbi_mult_taxo_gbnm(4024, 'sugar maple').
ncbi_mult_taxo_gbnm(4025, 'Norway maple').
ncbi_mult_taxo_gbnm(4026, 'sycamore maple').
ncbi_mult_taxo_gbnm(4031, 'zonal geranium').
ncbi_mult_taxo_gbnm(4039, carrot).
ncbi_mult_taxo_gbnm(4041, parsnip).
ncbi_mult_taxo_gbnm(4043, parsley).
ncbi_mult_taxo_gbnm(4047, coriander).
ncbi_mult_taxo_gbnm(4048, 'water pennyworts').
ncbi_mult_taxo_gbnm(4049, 'lawn water-pennywort').
ncbi_mult_taxo_gbnm(4054, ginseng).
ncbi_mult_taxo_gbnm(4058, 'Madagascar periwinkle').
ncbi_mult_taxo_gbnm(4060, serpentwood).
ncbi_mult_taxo_gbnm(4066, mudar).
ncbi_mult_taxo_gbnm(4071, peppers).
ncbi_mult_taxo_gbnm(4073, 'tabasco pepper').
ncbi_mult_taxo_gbnm(4075, 'sacred datura').
ncbi_mult_taxo_gbnm(4076, jimsonweed).
ncbi_mult_taxo_gbnm(4079, henbane).
ncbi_mult_taxo_gbnm(4081, tomato).
ncbi_mult_taxo_gbnm(4086, 'acuminate tobacco').
ncbi_mult_taxo_gbnm(4087, 'Persian tobacco').
ncbi_mult_taxo_gbnm(4088, 'Bigelov\'s tobacco').
ncbi_mult_taxo_gbnm(4089, 'Debney\'s tobacco').
ncbi_mult_taxo_gbnm(4090, 'tree tobacco').
ncbi_mult_taxo_gbnm(4092, 'curled-leaved tobacco').
ncbi_mult_taxo_gbnm(4093, 'Aztec tobacco').
ncbi_mult_taxo_gbnm(4096, 'wood tobacco').
ncbi_mult_taxo_gbnm(4097, 'common tobacco').
ncbi_mult_taxo_gbnm(4108, 'Chaco potato').
ncbi_mult_taxo_gbnm(4109, 'Commerson\'s wild potato').
ncbi_mult_taxo_gbnm(4110, 'Chilean potato-tree').
ncbi_mult_taxo_gbnm(4111, eggplant).
ncbi_mult_taxo_gbnm(4112, 'black nightshade').
ncbi_mult_taxo_gbnm(4113, potato).
ncbi_mult_taxo_gbnm(4120, 'sweet potato').
ncbi_mult_taxo_gbnm(4121, 'common morning-glory').
ncbi_mult_taxo_gbnm(4129, 'southern Asian dodder').
ncbi_mult_taxo_gbnm(4138, 'Chinese motherwort').
ncbi_mult_taxo_gbnm(4146, 'common olive').
ncbi_mult_taxo_gbnm(4147, jasmines).
ncbi_mult_taxo_gbnm(4150, snapdragons).
ncbi_mult_taxo_gbnm(4151, snapdragon).
ncbi_mult_taxo_gbnm(4154, 'monkey flowers').
ncbi_mult_taxo_gbnm(4155, 'spotted monkey flower').
ncbi_mult_taxo_gbnm(4163, foxgloves).
ncbi_mult_taxo_gbnm(4164, 'common foxglove').
ncbi_mult_taxo_gbnm(4166, 'Kenilworth ivy').
ncbi_mult_taxo_gbnm(4173, speedwells).
ncbi_mult_taxo_gbnm(4177, beechdrops).
ncbi_mult_taxo_gbnm(4182, sesame).
ncbi_mult_taxo_gbnm(4202, 'European elder').
ncbi_mult_taxo_gbnm(4205, 'mapleleaf viburnum').
ncbi_mult_taxo_gbnm(4208, 'townhall clock').
ncbi_mult_taxo_gbnm(4212, 'common ragweed').
ncbi_mult_taxo_gbnm(4214, 'giant ragweed').
ncbi_mult_taxo_gbnm(4216, burdocks).
ncbi_mult_taxo_gbnm(4217, 'great burdock').
ncbi_mult_taxo_gbnm(4220, 'common mugwort').
ncbi_mult_taxo_gbnm(4222, safflower).
ncbi_mult_taxo_gbnm(4230, 'Niger seed').
ncbi_mult_taxo_gbnm(4232, 'common sunflower').
ncbi_mult_taxo_gbnm(4236, 'garden lettuce').
ncbi_mult_taxo_gbnm(4265, cardoon).
ncbi_mult_taxo_gbnm(4270, nance).
ncbi_mult_taxo_gbnm(4282, 'Canadian bunchberry').
ncbi_mult_taxo_gbnm(4296, 'Japanese holly').
ncbi_mult_taxo_gbnm(4307, 'winged euonymus').
ncbi_mult_taxo_gbnm(4395, 'witch hazels').
ncbi_mult_taxo_gbnm(4396, 'Chinese witch hazel').
ncbi_mult_taxo_gbnm(4398, 'sweet gum trees').
ncbi_mult_taxo_gbnm(4400, 'sweet gum').
ncbi_mult_taxo_gbnm(4402, 'plane trees').
ncbi_mult_taxo_gbnm(4403, 'American sycamore').
ncbi_mult_taxo_gbnm(4418, 'water-lilies').
ncbi_mult_taxo_gbnm(4421, 'Santa Cruz water-lily').
ncbi_mult_taxo_gbnm(4431, 'American lotus').
ncbi_mult_taxo_gbnm(4432, 'sacred lotus').
ncbi_mult_taxo_gbnm(4439, leadwort).
ncbi_mult_taxo_gbnm(4447, monocots).
ncbi_mult_taxo_gbnm(4456, 'giant taro').
ncbi_mult_taxo_gbnm(4458, cuckoopint).
ncbi_mult_taxo_gbnm(4460, taro).
ncbi_mult_taxo_gbnm(4463, 'voodoo lily').
ncbi_mult_taxo_gbnm(4465, 'Eurasian sweet-flag').
ncbi_mult_taxo_gbnm(4469, duckweed).
ncbi_mult_taxo_gbnm(4470, 'swollen duckweed').
ncbi_mult_taxo_gbnm(4477, 'water lettuce').
ncbi_mult_taxo_gbnm(4497, 'small naked oat').
ncbi_mult_taxo_gbnm(4498, oats).
ncbi_mult_taxo_gbnm(4502, 'rye brome').
ncbi_mult_taxo_gbnm(4505, 'Job\'s tears').
ncbi_mult_taxo_gbnm(4509, 'orchard grass').
ncbi_mult_taxo_gbnm(4511, 'finger millet').
ncbi_mult_taxo_gbnm(4519, 'seaside barley').
ncbi_mult_taxo_gbnm(4521, 'Italian ryegrass').
ncbi_mult_taxo_gbnm(4528, 'longstamen rice').
ncbi_mult_taxo_gbnm(4529, 'brownbeard rice').
ncbi_mult_taxo_gbnm(4530, 'Asian cultivated rice').
ncbi_mult_taxo_gbnm(4533, 'malo sina').
ncbi_mult_taxo_gbnm(4538, 'African rice').
ncbi_mult_taxo_gbnm(4540, 'proso millet').
ncbi_mult_taxo_gbnm(4543, 'pearl millet').
ncbi_mult_taxo_gbnm(4544, bluegrass).
ncbi_mult_taxo_gbnm(4545, 'Kentucky bluegrass').
ncbi_mult_taxo_gbnm(4547, sugarcane).
ncbi_mult_taxo_gbnm(4550, rye).
ncbi_mult_taxo_gbnm(4555, 'foxtail millet').
ncbi_mult_taxo_gbnm(4558, sorghum).
ncbi_mult_taxo_gbnm(4563, 'eastern gama grass').
ncbi_mult_taxo_gbnm(4565, 'bread wheat').
ncbi_mult_taxo_gbnm(4567, 'durum wheat').
ncbi_mult_taxo_gbnm(4568, 'einkorn wheat').
ncbi_mult_taxo_gbnm(4571, 'rivet wheat').
ncbi_mult_taxo_gbnm(4576, 'diploperennial teosinte').
ncbi_mult_taxo_gbnm(4579, 'Mexican teosinte').
ncbi_mult_taxo_gbnm(4580, 'perennial teosinte').
ncbi_mult_taxo_gbnm(4581, bamboos).
ncbi_mult_taxo_gbnm(4582, 'hedge bamboo').
ncbi_mult_taxo_gbnm(4584, 'birdwood grass').
ncbi_mult_taxo_gbnm(4615, pineapple).
ncbi_mult_taxo_gbnm(4617, karatas).
ncbi_mult_taxo_gbnm(4628, 'Indian-shot').
ncbi_mult_taxo_gbnm(4641, 'dwarf banana').
ncbi_mult_taxo_gbnm(4669, snowdrops).
ncbi_mult_taxo_gbnm(4670, 'common snowdrop').
ncbi_mult_taxo_gbnm(4673, 'Japanese yam').
ncbi_mult_taxo_gbnm(4679, onion).
ncbi_mult_taxo_gbnm(4681, leek).
ncbi_mult_taxo_gbnm(4682, garlic).
ncbi_mult_taxo_gbnm(4684, ramson).
ncbi_mult_taxo_gbnm(4686, 'garden asparagus').
ncbi_mult_taxo_gbnm(4689, 'Henry\'s lily').
ncbi_mult_taxo_gbnm(4690, 'trumpet lily').
ncbi_mult_taxo_gbnm(4702, 'Siberian squill').
ncbi_mult_taxo_gbnm(4710, 'palm family').
ncbi_mult_taxo_gbnm(4713, 'fishtail palms').
ncbi_mult_taxo_gbnm(4714, 'Burmese fishtail palm').
ncbi_mult_taxo_gbnm(4718, 'nipa palm').
ncbi_mult_taxo_gbnm(4725, 'screw pines').
ncbi_mult_taxo_gbnm(4726, 'thatch screwpine').
ncbi_mult_taxo_gbnm(4741, spiderworts).
ncbi_mult_taxo_gbnm(4779, 'lettuce downy mildew').
ncbi_mult_taxo_gbnm(4787, 'potato late blight agent').
ncbi_mult_taxo_gbnm(4792, 'black shank of tobacco agent').
ncbi_mult_taxo_gbnm(4827, 'pin molds').
ncbi_mult_taxo_gbnm(4890, 'ascomycete fungi').
ncbi_mult_taxo_gbnm(4894, 'fission yeasts').
ncbi_mult_taxo_gbnm(4896, 'fission yeast').
ncbi_mult_taxo_gbnm(4932, 'brewer\'s yeast').
ncbi_mult_taxo_gbnm(5011, 'peach leaf curl fungus').
ncbi_mult_taxo_gbnm(5016, 'southern corn leaf blight pathogen').
ncbi_mult_taxo_gbnm(5022, 'blackleg of rapeseed fungus').
ncbi_mult_taxo_gbnm(5042, 'green and blue molds').
ncbi_mult_taxo_gbnm(5101, 'creosote fungus').
ncbi_mult_taxo_gbnm(5111, 'ergot fungus').
ncbi_mult_taxo_gbnm(5116, 'chestnut blight fungus').
ncbi_mult_taxo_gbnm(5188, 'orange peel mushroom').
ncbi_mult_taxo_gbnm(5204, 'basidiomycete fungi').
ncbi_mult_taxo_gbnm(5234, 'jelly fungi').
ncbi_mult_taxo_gbnm(5258, rusts).
ncbi_mult_taxo_gbnm(5261, 'flax rust').
ncbi_mult_taxo_gbnm(5270, 'corn smut').
ncbi_mult_taxo_gbnm(5279, bunts).
ncbi_mult_taxo_gbnm(5317, 'bracket fungi').
ncbi_mult_taxo_gbnm(5321, 'cornucopia mushroom').
ncbi_mult_taxo_gbnm(5322, 'oyster mushroom').
ncbi_mult_taxo_gbnm(5338, 'gill mushrooms').
ncbi_mult_taxo_gbnm(5341, 'cultivated mushroom').
ncbi_mult_taxo_gbnm(5353, 'shiitake mushroom').
ncbi_mult_taxo_gbnm(5370, 'Devil\'s bolete').
ncbi_mult_taxo_gbnm(5627, maitake).
ncbi_mult_taxo_gbnm(5653, kinetoplastids).
ncbi_mult_taxo_gbnm(5719, parabasalids).
ncbi_mult_taxo_gbnm(5738, diplomonads).
ncbi_mult_taxo_gbnm(5794, apicomplexans).
ncbi_mult_taxo_gbnm(5819, haemosporidians).
ncbi_mult_taxo_gbnm(5833, 'malaria parasite P. falciparum').
ncbi_mult_taxo_gbnm(5855, 'malaria parasite P. vivax').
ncbi_mult_taxo_gbnm(5863, 'Piroplasmids').
ncbi_mult_taxo_gbnm(5878, ciliates).
ncbi_mult_taxo_gbnm(6000, prostomes).
ncbi_mult_taxo_gbnm(6029, microsporidians).
ncbi_mult_taxo_gbnm(6040, sponges).
ncbi_mult_taxo_gbnm(6050, 'freshwater sponges').
ncbi_mult_taxo_gbnm(6073, cnidarians).
ncbi_mult_taxo_gbnm(6074, hydrozoans).
ncbi_mult_taxo_gbnm(6080, hydras).
ncbi_mult_taxo_gbnm(6082, 'green hydra').
ncbi_mult_taxo_gbnm(6087, 'swiftwater hydra').
ncbi_mult_taxo_gbnm(6091, 'penicillate jellyfish').
ncbi_mult_taxo_gbnm(6101, anthozoans).
ncbi_mult_taxo_gbnm(6103, 'sea anemones').
ncbi_mult_taxo_gbnm(6105, 'Australian red waratah sea anemone').
ncbi_mult_taxo_gbnm(6108, 'snake-locks sea anemone').
ncbi_mult_taxo_gbnm(6110, 'clonal anemone').
ncbi_mult_taxo_gbnm(6112, 'giant green sea anemone').
ncbi_mult_taxo_gbnm(6116, 'brown sea anemone').
ncbi_mult_taxo_gbnm(6125, 'stony corals').
ncbi_mult_taxo_gbnm(6127, 'staghorn corals').
ncbi_mult_taxo_gbnm(6132, 'soft corals').
ncbi_mult_taxo_gbnm(6133, 'sea pens').
ncbi_mult_taxo_gbnm(6135, 'Koelliker\'s sea pansy').
ncbi_mult_taxo_gbnm(6136, 'sea pansy').
ncbi_mult_taxo_gbnm(6137, 'sea wasps').
ncbi_mult_taxo_gbnm(6142, jellyfishes).
ncbi_mult_taxo_gbnm(6145, 'moon jelly').
ncbi_mult_taxo_gbnm(6157, flatworms).
ncbi_mult_taxo_gbnm(6179, flukes).
ncbi_mult_taxo_gbnm(6192, 'liver fluke').
ncbi_mult_taxo_gbnm(6199, tapeworms).
ncbi_mult_taxo_gbnm(6203, 'sheep tapeworm').
ncbi_mult_taxo_gbnm(6204, 'pork tapeworm').
ncbi_mult_taxo_gbnm(6206, 'beef tapeworm').
ncbi_mult_taxo_gbnm(6217, 'ribbon worms').
ncbi_mult_taxo_gbnm(6219, 'heteronemertine worms').
ncbi_mult_taxo_gbnm(6221, 'milky ribbon-worm').
ncbi_mult_taxo_gbnm(6231, nematodes).
ncbi_mult_taxo_gbnm(6252, 'common roundworm').
ncbi_mult_taxo_gbnm(6253, 'pig roundworm').
ncbi_mult_taxo_gbnm(6259, 'raccoon roundworm').
ncbi_mult_taxo_gbnm(6260, 'bear roundworm').
ncbi_mult_taxo_gbnm(6265, 'dog roundworm').
ncbi_mult_taxo_gbnm(6266, 'cat roundworm').
ncbi_mult_taxo_gbnm(6269, 'herring worm').
ncbi_mult_taxo_gbnm(6271, codworm).
ncbi_mult_taxo_gbnm(6287, 'dog heartworm nematode').
ncbi_mult_taxo_gbnm(6289, 'barber pole worm').
ncbi_mult_taxo_gbnm(6303, 'root-knot nematode').
ncbi_mult_taxo_gbnm(6306, 'southern root-knot nematode').
ncbi_mult_taxo_gbnm(6313, 'rat lungworm').
ncbi_mult_taxo_gbnm(6324, 'pine wood nematodes').
ncbi_mult_taxo_gbnm(6326, 'pine wood nematode').
ncbi_mult_taxo_gbnm(6340, 'segmented worms').
ncbi_mult_taxo_gbnm(6341, polychaetes).
ncbi_mult_taxo_gbnm(6344, lugworm).
ncbi_mult_taxo_gbnm(6359, 'Dumeril\'s clam worm').
ncbi_mult_taxo_gbnm(6386, 'sludge worm').
ncbi_mult_taxo_gbnm(6391, earthworms).
ncbi_mult_taxo_gbnm(6396, 'common brandling worm').
ncbi_mult_taxo_gbnm(6398, 'common earthworm').
ncbi_mult_taxo_gbnm(6405, 'North American leech').
ncbi_mult_taxo_gbnm(6406, 'jawless leeches').
ncbi_mult_taxo_gbnm(6409, 'Amazon leech').
ncbi_mult_taxo_gbnm(6410, 'Mexican leech').
ncbi_mult_taxo_gbnm(6415, 'turtle leech').
ncbi_mult_taxo_gbnm(6421, 'medicinal leech').
ncbi_mult_taxo_gbnm(6426, 'tube worm').
ncbi_mult_taxo_gbnm(6427, spoonworms).
ncbi_mult_taxo_gbnm(6433, 'peanut worms').
ncbi_mult_taxo_gbnm(6446, 'marine worm').
ncbi_mult_taxo_gbnm(6447, molluscs).
ncbi_mult_taxo_gbnm(6448, gastropods).
ncbi_mult_taxo_gbnm(6451, abalones).
ncbi_mult_taxo_gbnm(6453, 'pink abalone').
ncbi_mult_taxo_gbnm(6454, 'red abalone').
ncbi_mult_taxo_gbnm(6455, 'black abalone').
ncbi_mult_taxo_gbnm(6456, 'green abalone').
ncbi_mult_taxo_gbnm(6458, 'white abalone').
ncbi_mult_taxo_gbnm(6459, 'flat abalone').
ncbi_mult_taxo_gbnm(6462, limpets).
ncbi_mult_taxo_gbnm(6465, 'common limpet').
ncbi_mult_taxo_gbnm(6466, 'top shells').
ncbi_mult_taxo_gbnm(6470, 'horn shells').
ncbi_mult_taxo_gbnm(6472, 'water snail').
ncbi_mult_taxo_gbnm(6480, 'crown conchs').
ncbi_mult_taxo_gbnm(6488, 'ferruginous spindle').
ncbi_mult_taxo_gbnm(6489, 'cone shells').
ncbi_mult_taxo_gbnm(6491, 'geography cone').
ncbi_mult_taxo_gbnm(6492, 'magus cone').
ncbi_mult_taxo_gbnm(6493, 'striated cone').
ncbi_mult_taxo_gbnm(6494, 'cloth-of-gold cone').
ncbi_mult_taxo_gbnm(6495, 'tulip cone').
ncbi_mult_taxo_gbnm(6497, 'sea hares').
ncbi_mult_taxo_gbnm(6500, 'California sea hare').
ncbi_mult_taxo_gbnm(6501, 'Kuroda\'s sea hare').
ncbi_mult_taxo_gbnm(6502, 'slug sea hare').
ncbi_mult_taxo_gbnm(6503, 'little sea hare').
ncbi_mult_taxo_gbnm(6504, 'sea hare').
ncbi_mult_taxo_gbnm(6506, 'sea hare').
ncbi_mult_taxo_gbnm(6508, 'ragged sea hare').
ncbi_mult_taxo_gbnm(6511, 'sea hare').
ncbi_mult_taxo_gbnm(6521, 'pond snails').
ncbi_mult_taxo_gbnm(6523, 'great pond snail').
ncbi_mult_taxo_gbnm(6527, 'land snails').
ncbi_mult_taxo_gbnm(6535, 'brown garden snail').
ncbi_mult_taxo_gbnm(6536, 'Roman snail').
ncbi_mult_taxo_gbnm(6544, bivalves).
ncbi_mult_taxo_gbnm(6549, 'California mussel').
ncbi_mult_taxo_gbnm(6550, 'blue mussel').
ncbi_mult_taxo_gbnm(6551, 'common blue mussel').
ncbi_mult_taxo_gbnm(6553, 'ark shells').
ncbi_mult_taxo_gbnm(6556, 'ark clam').
ncbi_mult_taxo_gbnm(6563, oysters).
ncbi_mult_taxo_gbnm(6565, 'eastern oyster').
ncbi_mult_taxo_gbnm(6566, scallops).
ncbi_mult_taxo_gbnm(6570, 'Japanese scallop').
ncbi_mult_taxo_gbnm(6571, 'akazara scallop').
ncbi_mult_taxo_gbnm(6573, 'Yesso scallop').
ncbi_mult_taxo_gbnm(6574, scallop).
ncbi_mult_taxo_gbnm(6577, 'sea scallop').
ncbi_mult_taxo_gbnm(6581, 'surf clams').
ncbi_mult_taxo_gbnm(6584, 'Atlantic surf clam').
ncbi_mult_taxo_gbnm(6585, 'razor clams').
ncbi_mult_taxo_gbnm(6587, 'minor jackknife clam').
ncbi_mult_taxo_gbnm(6592, 'venus clams').
ncbi_mult_taxo_gbnm(6594, 'sunray clam').
ncbi_mult_taxo_gbnm(6605, cephalopods).
ncbi_mult_taxo_gbnm(6608, cuttlefish).
ncbi_mult_taxo_gbnm(6610, 'common cuttlefish').
ncbi_mult_taxo_gbnm(6618, 'northern European squid').
ncbi_mult_taxo_gbnm(6625, 'sparkling enope').
ncbi_mult_taxo_gbnm(6626, 'arrow squids').
ncbi_mult_taxo_gbnm(6628, 'Argentinian squid').
ncbi_mult_taxo_gbnm(6631, 'Gould\'s flying squid').
ncbi_mult_taxo_gbnm(6637, 'Japanese flying squid').
ncbi_mult_taxo_gbnm(6641, 'musky octopus').
ncbi_mult_taxo_gbnm(6645, 'common octopus').
ncbi_mult_taxo_gbnm(6650, chitons).
ncbi_mult_taxo_gbnm(6655, 'gumboot chiton').
ncbi_mult_taxo_gbnm(6656, arthropods).
ncbi_mult_taxo_gbnm(6657, crustaceans).
ncbi_mult_taxo_gbnm(6659, 'fairy shrimps').
ncbi_mult_taxo_gbnm(6660, 'brine shrimps').
ncbi_mult_taxo_gbnm(6665, 'water fleas').
ncbi_mult_taxo_gbnm(6668, 'common water fleas').
ncbi_mult_taxo_gbnm(6669, 'common water flea').
ncbi_mult_taxo_gbnm(6670, 'mussel shrimps').
ncbi_mult_taxo_gbnm(6674, 'sea firefly').
ncbi_mult_taxo_gbnm(6676, barnacles).
ncbi_mult_taxo_gbnm(6678, 'giant acorn barnacle').
ncbi_mult_taxo_gbnm(6680, 'acorn barnacle').
ncbi_mult_taxo_gbnm(6685, 'penaeid shrimps').
ncbi_mult_taxo_gbnm(6687, 'black tiger shrimp').
ncbi_mult_taxo_gbnm(6689, 'Pacific white shrimp').
ncbi_mult_taxo_gbnm(6690, 'brown shrimp').
ncbi_mult_taxo_gbnm(6695, 'palaemonid shrimps').
ncbi_mult_taxo_gbnm(6697, 'monsoon river-prawn').
ncbi_mult_taxo_gbnm(6701, 'pandalid shrimps').
ncbi_mult_taxo_gbnm(6703, 'northern shrimp').
ncbi_mult_taxo_gbnm(6704, 'clawed lobsters').
ncbi_mult_taxo_gbnm(6706, 'American lobster').
ncbi_mult_taxo_gbnm(6707, 'European lobster').
ncbi_mult_taxo_gbnm(6712, 'true lobsters and crayfishes').
ncbi_mult_taxo_gbnm(6715, 'noble crayfish').
ncbi_mult_taxo_gbnm(6717, 'narrow-clawed crayfish').
ncbi_mult_taxo_gbnm(6720, 'signal crayfish').
ncbi_mult_taxo_gbnm(6724, crayfish).
ncbi_mult_taxo_gbnm(6728, 'red swamp crayfish').
ncbi_mult_taxo_gbnm(6731, 'spiny lobsters').
ncbi_mult_taxo_gbnm(6733, 'European spiny lobster').
ncbi_mult_taxo_gbnm(6735, 'California spiny lobster').
ncbi_mult_taxo_gbnm(6736, 'Japanese spiny lobster').
ncbi_mult_taxo_gbnm(6737, 'Caribbean spiny lobster').
ncbi_mult_taxo_gbnm(6738, 'hermit crabs').
ncbi_mult_taxo_gbnm(6739, 'stone and king crabs').
ncbi_mult_taxo_gbnm(6741, 'red king crab').
ncbi_mult_taxo_gbnm(6747, 'flat-clawed hermit crab').
ncbi_mult_taxo_gbnm(6752, 'short-tailed crabs').
ncbi_mult_taxo_gbnm(6753, 'rock crabs').
ncbi_mult_taxo_gbnm(6755, 'edible crab').
ncbi_mult_taxo_gbnm(6756, 'Atlantic rock crab').
ncbi_mult_taxo_gbnm(6757, 'swimming crabs').
ncbi_mult_taxo_gbnm(6759, 'green crab').
ncbi_mult_taxo_gbnm(6760, 'mangrove crabs').
ncbi_mult_taxo_gbnm(6761, 'giant mud crab').
ncbi_mult_taxo_gbnm(6763, 'blue crab').
ncbi_mult_taxo_gbnm(6764, 'land crabs').
ncbi_mult_taxo_gbnm(6766, 'blue land crab').
ncbi_mult_taxo_gbnm(6769, 'blackback land crab').
ncbi_mult_taxo_gbnm(6772, 'Atlantic sand fiddler crab').
ncbi_mult_taxo_gbnm(6775, 'deepsea crabs').
ncbi_mult_taxo_gbnm(6778, 'mud crabs').
ncbi_mult_taxo_gbnm(6781, 'Florida stone crab').
ncbi_mult_taxo_gbnm(6790, 'frog crabs').
ncbi_mult_taxo_gbnm(6797, 'box crabs').
ncbi_mult_taxo_gbnm(6799, 'calico box crab').
ncbi_mult_taxo_gbnm(6800, 'purse crabs').
ncbi_mult_taxo_gbnm(6802, 'longfinger purse crab').
ncbi_mult_taxo_gbnm(6805, 'spider crabs').
ncbi_mult_taxo_gbnm(6807, 'portly spider crab').
ncbi_mult_taxo_gbnm(6809, 'elbow crabs').
ncbi_mult_taxo_gbnm(6815, 'banded coral shrimp').
ncbi_mult_taxo_gbnm(6816, krill).
ncbi_mult_taxo_gbnm(6819, 'Antarctic krill').
ncbi_mult_taxo_gbnm(6821, amphipods).
ncbi_mult_taxo_gbnm(6829, 'Norway lobster').
ncbi_mult_taxo_gbnm(6830, copepods).
ncbi_mult_taxo_gbnm(6839, 'fish lice').
ncbi_mult_taxo_gbnm(6844, 'horseshoe crabs').
ncbi_mult_taxo_gbnm(6848, 'Southeast Asian horseshoe crab').
ncbi_mult_taxo_gbnm(6850, 'Atlantic horseshoe crab').
ncbi_mult_taxo_gbnm(6852, 'Indo-Pacific horseshoe crab').
ncbi_mult_taxo_gbnm(6853, 'Chinese horseshoe crab').
ncbi_mult_taxo_gbnm(6854, arachnids).
ncbi_mult_taxo_gbnm(6855, scorpions).
ncbi_mult_taxo_gbnm(6858, 'Sahara scorpion').
ncbi_mult_taxo_gbnm(6868, 'common European scorpion').
ncbi_mult_taxo_gbnm(6869, 'Moroccan scorpion').
ncbi_mult_taxo_gbnm(6871, 'Tunisian scorpion').
ncbi_mult_taxo_gbnm(6878, 'Mexican scorpion').
ncbi_mult_taxo_gbnm(6880, 'Mexican scorpion').
ncbi_mult_taxo_gbnm(6881, 'Mexican scorpion').
ncbi_mult_taxo_gbnm(6883, 'Egyptian scorpion').
ncbi_mult_taxo_gbnm(6885, 'Egyptian scorpion').
ncbi_mult_taxo_gbnm(6887, 'Brazilian scorpion').
ncbi_mult_taxo_gbnm(6892, 'Central Asian scorpion').
ncbi_mult_taxo_gbnm(6893, spiders).
ncbi_mult_taxo_gbnm(6894, 'mygalomorph spiders').
ncbi_mult_taxo_gbnm(6895, tarantulas).
ncbi_mult_taxo_gbnm(6901, 'funnel-web tarantulas').
ncbi_mult_taxo_gbnm(6906, 'funnel weavers').
ncbi_mult_taxo_gbnm(6913, 'orb weavers').
ncbi_mult_taxo_gbnm(6916, 'wandering spiders').
ncbi_mult_taxo_gbnm(6918, 'Brazilian armed spider').
ncbi_mult_taxo_gbnm(6921, 'brown recluse').
ncbi_mult_taxo_gbnm(6923, 'black widows').
ncbi_mult_taxo_gbnm(6924, 'black widow').
ncbi_mult_taxo_gbnm(6925, 'black widow').
ncbi_mult_taxo_gbnm(6932, 'longbodied cellar spider').
ncbi_mult_taxo_gbnm(6933, 'mites & ticks').
ncbi_mult_taxo_gbnm(6935, ticks).
ncbi_mult_taxo_gbnm(6936, 'softbacked ticks').
ncbi_mult_taxo_gbnm(6937, 'relapsing fever ticks').
ncbi_mult_taxo_gbnm(6939, 'hardbacked ticks').
ncbi_mult_taxo_gbnm(6941, 'southern cattle tick').
ncbi_mult_taxo_gbnm(6943, 'Lone Star tick').
ncbi_mult_taxo_gbnm(6945, 'black-legged tick').
ncbi_mult_taxo_gbnm(6950, 'straw itch mite').
ncbi_mult_taxo_gbnm(6952, 'house-dust mites').
ncbi_mult_taxo_gbnm(6954, 'American house dust mite').
ncbi_mult_taxo_gbnm(6956, 'European house dust mite').
ncbi_mult_taxo_gbnm(6960, hexapods).
ncbi_mult_taxo_gbnm(6961, 'dragonflies & damselflies').
ncbi_mult_taxo_gbnm(6962, dragonflies).
ncbi_mult_taxo_gbnm(6964, 'common skimmers').
ncbi_mult_taxo_gbnm(6965, 'pond skimmers').
ncbi_mult_taxo_gbnm(6966, 'golden-winged skimmer').
ncbi_mult_taxo_gbnm(6967, 'twelve-spotted skimmer').
ncbi_mult_taxo_gbnm(6973, 'German cockroach').
ncbi_mult_taxo_gbnm(6974, 'American cockroach family').
ncbi_mult_taxo_gbnm(6976, 'oriental cockroach').
ncbi_mult_taxo_gbnm(6978, 'American cockroach').
ncbi_mult_taxo_gbnm(6979, 'blaberid cockroaches').
ncbi_mult_taxo_gbnm(6981, 'tropical cockroach').
ncbi_mult_taxo_gbnm(6982, 'death\'s head cockroach').
ncbi_mult_taxo_gbnm(6984, 'Pacific beetle cockroach').
ncbi_mult_taxo_gbnm(6990, 'gray cockroach').
ncbi_mult_taxo_gbnm(6993, 'grasshoppers, crickets & katydids').
ncbi_mult_taxo_gbnm(6994, 'crickets & katydids').
ncbi_mult_taxo_gbnm(6997, 'house cricket').
ncbi_mult_taxo_gbnm(6999, 'two-spotted cricket').
ncbi_mult_taxo_gbnm(7001, 'grasshoppers, groundhoppers & pygmy mole crickets').
ncbi_mult_taxo_gbnm(7002, 'short-horned grasshoppers').
ncbi_mult_taxo_gbnm(7004, 'migratory locust').
ncbi_mult_taxo_gbnm(7005, 'African migratory locust').
ncbi_mult_taxo_gbnm(7007, 'eastern lubber grasshopper').
ncbi_mult_taxo_gbnm(7009, 'American grasshopper').
ncbi_mult_taxo_gbnm(7011, 'vagrant locust').
ncbi_mult_taxo_gbnm(7020, 'walking sticks').
ncbi_mult_taxo_gbnm(7022, 'Indian stick insect').
ncbi_mult_taxo_gbnm(7024, 'giant prickly stick insect').
ncbi_mult_taxo_gbnm(7029, 'pea aphid').
ncbi_mult_taxo_gbnm(7033, cicadas).
ncbi_mult_taxo_gbnm(7036, whiteflies).
ncbi_mult_taxo_gbnm(7040, 'ash whitefly').
ncbi_mult_taxo_gbnm(7041, beetles).
ncbi_mult_taxo_gbnm(7042, weevils).
ncbi_mult_taxo_gbnm(7044, 'boll weevil').
ncbi_mult_taxo_gbnm(7046, 'granary weevil').
ncbi_mult_taxo_gbnm(7047, 'maize weevil').
ncbi_mult_taxo_gbnm(7048, 'rice weevil').
ncbi_mult_taxo_gbnm(7049, fireflies).
ncbi_mult_taxo_gbnm(7051, 'Japanese firefly').
ncbi_mult_taxo_gbnm(7052, 'Japanese firefly').
ncbi_mult_taxo_gbnm(7054, 'common eastern firefly').
ncbi_mult_taxo_gbnm(7055, 'scarab beetles').
ncbi_mult_taxo_gbnm(7056, 'goliath beetles & flower beetles').
ncbi_mult_taxo_gbnm(7059, 'May beetles & June bugs').
ncbi_mult_taxo_gbnm(7061, cockchafer).
ncbi_mult_taxo_gbnm(7062, 'shining leaf chafers').
ncbi_mult_taxo_gbnm(7064, 'Japanese beetle').
ncbi_mult_taxo_gbnm(7065, 'darkling ground beetles').
ncbi_mult_taxo_gbnm(7067, 'yellow mealworm').
ncbi_mult_taxo_gbnm(7070, 'red flour beetle').
ncbi_mult_taxo_gbnm(7071, 'confused flour beetle').
ncbi_mult_taxo_gbnm(7074, 'kingworm beetle').
ncbi_mult_taxo_gbnm(7077, 'small-eyed flour beetle').
ncbi_mult_taxo_gbnm(7080, 'ladybird beetles').
ncbi_mult_taxo_gbnm(7084, 'two-spotted ladybird beetle').
ncbi_mult_taxo_gbnm(7088, 'moths & butterflies').
ncbi_mult_taxo_gbnm(7089, 'silkworm moths').
ncbi_mult_taxo_gbnm(7091, 'domestic silkworm').
ncbi_mult_taxo_gbnm(7092, 'wild silkworm').
ncbi_mult_taxo_gbnm(7096, 'lappet moths').
ncbi_mult_taxo_gbnm(7097, 'tent caterpillars').
ncbi_mult_taxo_gbnm(7098, 'lackey moth').
ncbi_mult_taxo_gbnm(7099, 'eastern tent caterpillar').
ncbi_mult_taxo_gbnm(7100, 'owlet moths').
ncbi_mult_taxo_gbnm(7102, 'tobacco budworm').
ncbi_mult_taxo_gbnm(7107, 'beet armyworm').
ncbi_mult_taxo_gbnm(7108, 'fall armyworm').
ncbi_mult_taxo_gbnm(7109, 'African cotton leafworm').
ncbi_mult_taxo_gbnm(7111, 'cabbage looper').
ncbi_mult_taxo_gbnm(7113, 'corn earworm').
ncbi_mult_taxo_gbnm(7114, 'white, yellow and sulphur butterflies').
ncbi_mult_taxo_gbnm(7116, 'large cabbage white').
ncbi_mult_taxo_gbnm(7117, 'emperor moths').
ncbi_mult_taxo_gbnm(7119, 'Chinese oak silkmoth').
ncbi_mult_taxo_gbnm(7120, 'polyphemus moth').
ncbi_mult_taxo_gbnm(7121, 'Japanese oak silkmoth').
ncbi_mult_taxo_gbnm(7123, 'cecropia moth').
ncbi_mult_taxo_gbnm(7127, 'ailanthus silkmoth').
ncbi_mult_taxo_gbnm(7128, hawkmoths).
ncbi_mult_taxo_gbnm(7130, 'tobacco hornworm').
ncbi_mult_taxo_gbnm(7135, 'snout moths').
ncbi_mult_taxo_gbnm(7137, 'greater wax moth').
ncbi_mult_taxo_gbnm(7141, 'eastern spruce budworm').
ncbi_mult_taxo_gbnm(7143, 'swallowtail butterflies').
ncbi_mult_taxo_gbnm(7146, 'black swallowtail').
ncbi_mult_taxo_gbnm(7147, flies).
ncbi_mult_taxo_gbnm(7149, 'nonbiting midges').
ncbi_mult_taxo_gbnm(7157, mosquitos).
ncbi_mult_taxo_gbnm(7159, 'yellow fever mosquito').
ncbi_mult_taxo_gbnm(7160, 'Asian tiger mosquito').
ncbi_mult_taxo_gbnm(7165, 'African malaria mosquito').
ncbi_mult_taxo_gbnm(7175, 'northern house mosquito').
ncbi_mult_taxo_gbnm(7176, 'southern house mosquito').
ncbi_mult_taxo_gbnm(7184, 'black fungus gnats').
ncbi_mult_taxo_gbnm(7190, 'black flies').
ncbi_mult_taxo_gbnm(7197, 'sandflies and mothflies').
ncbi_mult_taxo_gbnm(7198, sandflies).
ncbi_mult_taxo_gbnm(7205, 'horseflies and deerflies').
ncbi_mult_taxo_gbnm(7207, 'black horsefly').
ncbi_mult_taxo_gbnm(7209, 'African eye worm').
ncbi_mult_taxo_gbnm(7211, 'fruit flies').
ncbi_mult_taxo_gbnm(7213, 'Mediterranean fruit fly').
ncbi_mult_taxo_gbnm(7214, 'pomace flies').
ncbi_mult_taxo_gbnm(7215, 'fruit flies').
ncbi_mult_taxo_gbnm(7227, 'fruit fly').
ncbi_mult_taxo_gbnm(7366, 'house flies').
ncbi_mult_taxo_gbnm(7368, 'horn fly').
ncbi_mult_taxo_gbnm(7370, 'house fly').
ncbi_mult_taxo_gbnm(7371, blowflies).
ncbi_mult_taxo_gbnm(7373, 'urban bluebottle blowfly').
ncbi_mult_taxo_gbnm(7375, 'Australian sheep blowfly').
ncbi_mult_taxo_gbnm(7380, 'black blowfly').
ncbi_mult_taxo_gbnm(7381, 'flesh flies').
ncbi_mult_taxo_gbnm(7385, 'grey fleshfly').
ncbi_mult_taxo_gbnm(7387, 'warble flies').
ncbi_mult_taxo_gbnm(7389, 'early cattle grub').
ncbi_mult_taxo_gbnm(7393, 'tsetse flies').
ncbi_mult_taxo_gbnm(7399, hymenopterans).
ncbi_mult_taxo_gbnm(7425, 'jewel wasp').
ncbi_mult_taxo_gbnm(7437, 'garden dagger wasp').
ncbi_mult_taxo_gbnm(7438, wasps).
ncbi_mult_taxo_gbnm(7439, 'hornets and yellowjackets').
ncbi_mult_taxo_gbnm(7441, 'bald-faced hornet').
ncbi_mult_taxo_gbnm(7445, 'European hornet').
ncbi_mult_taxo_gbnm(7446, 'Asian giant hornet').
ncbi_mult_taxo_gbnm(7447, 'oriental hornet').
ncbi_mult_taxo_gbnm(7448, 'Japanese yellow hornet').
ncbi_mult_taxo_gbnm(7453, 'eastern yellowjacket').
ncbi_mult_taxo_gbnm(7455, 'paper wasps').
ncbi_mult_taxo_gbnm(7458, 'bumble bees and honey bees').
ncbi_mult_taxo_gbnm(7460, 'honey bee').
ncbi_mult_taxo_gbnm(7461, 'Asiatic honeybee').
ncbi_mult_taxo_gbnm(7462, 'giant honeybee').
ncbi_mult_taxo_gbnm(7463, 'little honeybee').
ncbi_mult_taxo_gbnm(7469, 'common honey bee').
ncbi_mult_taxo_gbnm(7476, 'large carpenter bees').
ncbi_mult_taxo_gbnm(7485, 'digger wasps').
ncbi_mult_taxo_gbnm(7487, 'cicada killer').
ncbi_mult_taxo_gbnm(7489, 'trichogrammid wasps').
ncbi_mult_taxo_gbnm(7496, 'winged insects').
ncbi_mult_taxo_gbnm(7501, 'damp wood termites').
ncbi_mult_taxo_gbnm(7503, 'Pacific dampwood termite').
ncbi_mult_taxo_gbnm(7504, mantids).
ncbi_mult_taxo_gbnm(7507, 'praying mantis').
ncbi_mult_taxo_gbnm(7509, fleas).
ncbi_mult_taxo_gbnm(7511, 'common fleas').
ncbi_mult_taxo_gbnm(7515, 'cat flea').
ncbi_mult_taxo_gbnm(7516, 'net-winged insects').
ncbi_mult_taxo_gbnm(7520, 'green lacewings').
ncbi_mult_taxo_gbnm(7522, 'common green lacewing').
ncbi_mult_taxo_gbnm(7524, 'true bugs').
ncbi_mult_taxo_gbnm(7533, 'seed bugs').
ncbi_mult_taxo_gbnm(7536, 'milkweed bug').
ncbi_mult_taxo_gbnm(7539, 'Colorado potato beetle').
ncbi_mult_taxo_gbnm(7540, centipedes).
ncbi_mult_taxo_gbnm(7553, millipedes).
ncbi_mult_taxo_gbnm(7561, 'tongue worms').
ncbi_mult_taxo_gbnm(7568, brachiopods).
ncbi_mult_taxo_gbnm(7586, echinoderms).
ncbi_mult_taxo_gbnm(7588, starfish).
ncbi_mult_taxo_gbnm(7602, 'Northern Pacific seastar').
ncbi_mult_taxo_gbnm(7603, 'Forbes\'s starfish').
ncbi_mult_taxo_gbnm(7604, 'European starfish').
ncbi_mult_taxo_gbnm(7609, 'spiny starfish').
ncbi_mult_taxo_gbnm(7612, 'purple sea star').
ncbi_mult_taxo_gbnm(7618, 'brittle stars').
ncbi_mult_taxo_gbnm(7625, 'sea urchins').
ncbi_mult_taxo_gbnm(7626, 'pencil urchins').
ncbi_mult_taxo_gbnm(7627, 'pencil urchins').
ncbi_mult_taxo_gbnm(7640, 'black urchin').
ncbi_mult_taxo_gbnm(7641, 'punctuate urchin').
ncbi_mult_taxo_gbnm(7653, 'painted urchin').
ncbi_mult_taxo_gbnm(7654, 'green sea urchin').
ncbi_mult_taxo_gbnm(7656, 'common urchin').
ncbi_mult_taxo_gbnm(7658, 'angulate urchin').
ncbi_mult_taxo_gbnm(7660, 'sand urchin').
ncbi_mult_taxo_gbnm(7668, 'purple sea urchin').
ncbi_mult_taxo_gbnm(7670, 'pale sea urchin').
ncbi_mult_taxo_gbnm(7671, 'green sea urchin').
ncbi_mult_taxo_gbnm(7673, 'Hawaiian sea urchin').
ncbi_mult_taxo_gbnm(7705, 'sea cucumbers').
ncbi_mult_taxo_gbnm(7711, chordates).
ncbi_mult_taxo_gbnm(7712, tunicates).
ncbi_mult_taxo_gbnm(7713, 'sea squirts').
ncbi_mult_taxo_gbnm(7719, 'vase tunicate').
ncbi_mult_taxo_gbnm(7733, 'red throated ascidian').
ncbi_mult_taxo_gbnm(7735, lancelets).
ncbi_mult_taxo_gbnm(7736, lancelets).
ncbi_mult_taxo_gbnm(7738, 'California lancelet').
ncbi_mult_taxo_gbnm(7739, 'Florida lancelet').
ncbi_mult_taxo_gbnm(7740, amphioxus).
ncbi_mult_taxo_gbnm(7741, 'Belcher\'s lancelet').
ncbi_mult_taxo_gbnm(7742, vertebrates).
ncbi_mult_taxo_gbnm(7745, lampreys).
ncbi_mult_taxo_gbnm(7746, lampreys).
ncbi_mult_taxo_gbnm(7748, 'European river lamprey').
ncbi_mult_taxo_gbnm(7750, 'European brook lamprey').
ncbi_mult_taxo_gbnm(7752, 'least brook lamprey').
ncbi_mult_taxo_gbnm(7753, 'Far Eastern brook lamprey').
ncbi_mult_taxo_gbnm(7755, 'southern lamprey').
ncbi_mult_taxo_gbnm(7757, 'sea lamprey').
ncbi_mult_taxo_gbnm(7761, hagfishes).
ncbi_mult_taxo_gbnm(7762, hagfishes).
ncbi_mult_taxo_gbnm(7764, 'inshore hagfish').
ncbi_mult_taxo_gbnm(7765, 'Pacific hagfish').
ncbi_mult_taxo_gbnm(7769, 'Atlantic hagfish').
ncbi_mult_taxo_gbnm(7776, 'jawed vertebrates').
ncbi_mult_taxo_gbnm(7777, 'cartilaginous fishes').
ncbi_mult_taxo_gbnm(7778, 'sharks & rays').
ncbi_mult_taxo_gbnm(7781, 'thornback ray').
ncbi_mult_taxo_gbnm(7782, 'little skate').
ncbi_mult_taxo_gbnm(7787, 'Pacific electric ray').
ncbi_mult_taxo_gbnm(7788, 'marbled electric ray').
ncbi_mult_taxo_gbnm(7790, 'bullhead sharks').
ncbi_mult_taxo_gbnm(7792, 'horn shark').
ncbi_mult_taxo_gbnm(7793, 'Port Jackson shark').
ncbi_mult_taxo_gbnm(7797, 'spiny dogfish').
ncbi_mult_taxo_gbnm(7798, 'Puget Sound dogfish').
ncbi_mult_taxo_gbnm(7801, 'nurse shark').
ncbi_mult_taxo_gbnm(7802, 'sand tigers').
ncbi_mult_taxo_gbnm(7805, 'requiem sharks').
ncbi_mult_taxo_gbnm(7806, 'gray sharks').
ncbi_mult_taxo_gbnm(7807, 'dusky shark').
ncbi_mult_taxo_gbnm(7808, 'sandbar shark').
ncbi_mult_taxo_gbnm(7810, 'smalltail shark').
ncbi_mult_taxo_gbnm(7812, 'smooth dogfish').
ncbi_mult_taxo_gbnm(7813, 'gummy shark').
ncbi_mult_taxo_gbnm(7815, 'blue shark').
ncbi_mult_taxo_gbnm(7818, 'tiger sharks').
ncbi_mult_taxo_gbnm(7819, 'tiger shark').
ncbi_mult_taxo_gbnm(7820, 'lemon sharks').
ncbi_mult_taxo_gbnm(7821, 'lemon shark').
ncbi_mult_taxo_gbnm(7822, hammerheads).
ncbi_mult_taxo_gbnm(7823, 'scalloped hammerhead').
ncbi_mult_taxo_gbnm(7824, bonnethead).
ncbi_mult_taxo_gbnm(7826, 'cat sharks').
ncbi_mult_taxo_gbnm(7830, 'smaller spotted catshark').
ncbi_mult_taxo_gbnm(7832, 'bramble sharks').
ncbi_mult_taxo_gbnm(7834, 'prickly shark').
ncbi_mult_taxo_gbnm(7839, houndsharks).
ncbi_mult_taxo_gbnm(7840, 'leopard sharks').
ncbi_mult_taxo_gbnm(7844, 'mackerel sharks').
ncbi_mult_taxo_gbnm(7847, 'longfin mako shark').
ncbi_mult_taxo_gbnm(7852, 'thresher shark').
ncbi_mult_taxo_gbnm(7855, 'cow sharks').
ncbi_mult_taxo_gbnm(7857, 'broadnose sevengill shark').
ncbi_mult_taxo_gbnm(7858, skates).
ncbi_mult_taxo_gbnm(7860, guitarfishes).
ncbi_mult_taxo_gbnm(7862, 'Atlantic guitarfish').
ncbi_mult_taxo_gbnm(7864, chimaeras).
ncbi_mult_taxo_gbnm(7865, 'plownose chimaeras').
ncbi_mult_taxo_gbnm(7867, elephantfish).
ncbi_mult_taxo_gbnm(7868, 'elephant shark').
ncbi_mult_taxo_gbnm(7869, 'shortnose chimaeras').
ncbi_mult_taxo_gbnm(7871, 'rabbit fish').
ncbi_mult_taxo_gbnm(7873, 'spotted ratfish').
ncbi_mult_taxo_gbnm(7878, lungfishes).
ncbi_mult_taxo_gbnm(7880, 'South American lungfishes').
ncbi_mult_taxo_gbnm(7883, 'South American lungfish').
ncbi_mult_taxo_gbnm(7884, 'African lungfishes').
ncbi_mult_taxo_gbnm(7886, 'marbled lungfish').
ncbi_mult_taxo_gbnm(7888, 'West African lungfish').
ncbi_mult_taxo_gbnm(7889, 'Australian lungfishes').
ncbi_mult_taxo_gbnm(7892, 'Australian lungfish').
ncbi_mult_taxo_gbnm(7894, coelacanths).
ncbi_mult_taxo_gbnm(7895, coelacanths).
ncbi_mult_taxo_gbnm(7897, coelacanth).
ncbi_mult_taxo_gbnm(7898, 'ray-finned fishes').
ncbi_mult_taxo_gbnm(7899, 'sturgeons and paddlefish').
ncbi_mult_taxo_gbnm(7900, sturgeons).
ncbi_mult_taxo_gbnm(7902, 'Russian sturgeon').
ncbi_mult_taxo_gbnm(7903, 'stellate sturgeon').
ncbi_mult_taxo_gbnm(7904, 'white sturgeon').
ncbi_mult_taxo_gbnm(7906, sterlet).
ncbi_mult_taxo_gbnm(7907, 'shortnose sturgeon').
ncbi_mult_taxo_gbnm(7908, 'green sturgeon').
ncbi_mult_taxo_gbnm(7910, 'shovelnose sturgeon').
ncbi_mult_taxo_gbnm(7911, paddlefishes).
ncbi_mult_taxo_gbnm(7913, 'Mississippi paddlefish').
ncbi_mult_taxo_gbnm(7915, gars).
ncbi_mult_taxo_gbnm(7917, 'alligator gar').
ncbi_mult_taxo_gbnm(7918, 'spotted gar').
ncbi_mult_taxo_gbnm(7922, bowfins).
ncbi_mult_taxo_gbnm(7924, bowfin).
ncbi_mult_taxo_gbnm(7925, 'ladyfishes and tarpons').
ncbi_mult_taxo_gbnm(7926, tenpounders).
ncbi_mult_taxo_gbnm(7928, ladyfish).
ncbi_mult_taxo_gbnm(7930, tarpons).
ncbi_mult_taxo_gbnm(7932, tarpon).
ncbi_mult_taxo_gbnm(7933, 'true eels').
ncbi_mult_taxo_gbnm(7934, 'freshwater eels').
ncbi_mult_taxo_gbnm(7936, 'European eel').
ncbi_mult_taxo_gbnm(7937, 'Japanese eel').
ncbi_mult_taxo_gbnm(7938, 'American eel').
ncbi_mult_taxo_gbnm(7939, 'giant mottled eel').
ncbi_mult_taxo_gbnm(7940, 'Australian shortfin eel').
ncbi_mult_taxo_gbnm(7941, 'conger eels').
ncbi_mult_taxo_gbnm(7943, 'whitespotted conger').
ncbi_mult_taxo_gbnm(7944, 'pike congers').
ncbi_mult_taxo_gbnm(7946, 'daggertooth pike conger').
ncbi_mult_taxo_gbnm(7950, 'Atlantic herring').
ncbi_mult_taxo_gbnm(7952, 'carps and others').
ncbi_mult_taxo_gbnm(7955, zebrafish).
ncbi_mult_taxo_gbnm(7957, goldfish).
ncbi_mult_taxo_gbnm(7959, 'grass carp').
ncbi_mult_taxo_gbnm(7962, 'common carp').
ncbi_mult_taxo_gbnm(7965, 'bighead carp').
ncbi_mult_taxo_gbnm(7967, 'cherryfin shiner').
ncbi_mult_taxo_gbnm(7968, suckers).
ncbi_mult_taxo_gbnm(7970, 'desert sucker').
ncbi_mult_taxo_gbnm(7971, 'white sucker').
ncbi_mult_taxo_gbnm(7973, 'smallmouth buffalo').
ncbi_mult_taxo_gbnm(7982, loaches).
ncbi_mult_taxo_gbnm(7992, characins).
ncbi_mult_taxo_gbnm(7994, 'Mexican tetra').
ncbi_mult_taxo_gbnm(7995, catfishes).
ncbi_mult_taxo_gbnm(7996, 'bullhead catfishes').
ncbi_mult_taxo_gbnm(7998, 'channel catfish').
ncbi_mult_taxo_gbnm(8001, 'yellowtail catfish').
ncbi_mult_taxo_gbnm(8002, 'electric eels and knifefishes').
ncbi_mult_taxo_gbnm(8005, 'electric eel').
ncbi_mult_taxo_gbnm(8006, 'salmons and trouts').
ncbi_mult_taxo_gbnm(8007, 'pikes and mudminnows').
ncbi_mult_taxo_gbnm(8008, pikes).
ncbi_mult_taxo_gbnm(8010, 'northern pike').
ncbi_mult_taxo_gbnm(8012, smelts).
ncbi_mult_taxo_gbnm(8014, 'rainbow smelt').
ncbi_mult_taxo_gbnm(8015, salmonids).
ncbi_mult_taxo_gbnm(8017, 'pink salmon').
ncbi_mult_taxo_gbnm(8018, 'chum salmon').
ncbi_mult_taxo_gbnm(8019, 'coho salmon').
ncbi_mult_taxo_gbnm(8020, 'cherry salmon').
ncbi_mult_taxo_gbnm(8021, 'Ishikawa\'s cherry salmon').
ncbi_mult_taxo_gbnm(8022, 'rainbow trout').
ncbi_mult_taxo_gbnm(8023, 'sockeye salmon').
ncbi_mult_taxo_gbnm(8024, 'kokanee salmon').
ncbi_mult_taxo_gbnm(8030, 'Atlantic salmon').
ncbi_mult_taxo_gbnm(8032, 'river trout').
ncbi_mult_taxo_gbnm(8034, 'whitespotted char').
ncbi_mult_taxo_gbnm(8036, 'Arctic char').
ncbi_mult_taxo_gbnm(8037, 'bull trout').
ncbi_mult_taxo_gbnm(8038, 'brook trout').
ncbi_mult_taxo_gbnm(8039, 'Dolly Varden').
ncbi_mult_taxo_gbnm(8040, 'lake trout').
ncbi_mult_taxo_gbnm(8042, 'Japanese huchen').
ncbi_mult_taxo_gbnm(8043, 'cods and others').
ncbi_mult_taxo_gbnm(8045, cods).
ncbi_mult_taxo_gbnm(8047, 'saffron cod').
ncbi_mult_taxo_gbnm(8049, 'Atlantic cod').
ncbi_mult_taxo_gbnm(8052, 'Greenland cod').
ncbi_mult_taxo_gbnm(8053, 'Baltic cod').
ncbi_mult_taxo_gbnm(8056, haddock).
ncbi_mult_taxo_gbnm(8058, whiting).
ncbi_mult_taxo_gbnm(8060, saithe).
ncbi_mult_taxo_gbnm(8061, 'merluccid hakes').
ncbi_mult_taxo_gbnm(8063, 'European hake').
ncbi_mult_taxo_gbnm(8064, toadfishes).
ncbi_mult_taxo_gbnm(8065, toadfishes).
ncbi_mult_taxo_gbnm(8066, toadfish).
ncbi_mult_taxo_gbnm(8068, 'oyster toadfish').
ncbi_mult_taxo_gbnm(8070, anglerfishes).
ncbi_mult_taxo_gbnm(8071, goosefishes).
ncbi_mult_taxo_gbnm(8073, 'American angler').
ncbi_mult_taxo_gbnm(8074, angler).
ncbi_mult_taxo_gbnm(8076, killifishes).
ncbi_mult_taxo_gbnm(8078, mummichog).
ncbi_mult_taxo_gbnm(8079, livebearers).
ncbi_mult_taxo_gbnm(8081, guppy).
ncbi_mult_taxo_gbnm(8083, 'southern platyfish').
ncbi_mult_taxo_gbnm(8084, 'green swordtail').
ncbi_mult_taxo_gbnm(8086, 'swordtail platyfish').
ncbi_mult_taxo_gbnm(8088, medakas).
ncbi_mult_taxo_gbnm(8090, 'Japanese medaka').
ncbi_mult_taxo_gbnm(8092, sculpins).
ncbi_mult_taxo_gbnm(8094, 'sea raven').
ncbi_mult_taxo_gbnm(8096, 'grubby sculpin').
ncbi_mult_taxo_gbnm(8097, 'shorthorn sculpin').
ncbi_mult_taxo_gbnm(8099, 'Kessler\'s sculpin').
ncbi_mult_taxo_gbnm(8101, lumpfishes).
ncbi_mult_taxo_gbnm(8103, lumpfish).
ncbi_mult_taxo_gbnm(8108, scorpionfishes).
ncbi_mult_taxo_gbnm(8111, 'perches and others').
ncbi_mult_taxo_gbnm(8113, cichlids).
ncbi_mult_taxo_gbnm(8125, 'convict julie').
ncbi_mult_taxo_gbnm(8127, 'Mozambique tilapia').
ncbi_mult_taxo_gbnm(8128, 'Nile tilapia').
ncbi_mult_taxo_gbnm(8129, 'redbreast tilapia').
ncbi_mult_taxo_gbnm(8130, 'redbelly tilapia').
ncbi_mult_taxo_gbnm(8144, 'mango tilapia').
ncbi_mult_taxo_gbnm(8150, 'blunthead cichlid').
ncbi_mult_taxo_gbnm(8153, 'Burton\'s mouthbrooder').
ncbi_mult_taxo_gbnm(8154, 'eastern happy').
ncbi_mult_taxo_gbnm(8157, jacks).
ncbi_mult_taxo_gbnm(8161, 'Japanese amberjack').
ncbi_mult_taxo_gbnm(8162, 'temperate perches').
ncbi_mult_taxo_gbnm(8164, 'Japanese seabass').
ncbi_mult_taxo_gbnm(8165, perches).
ncbi_mult_taxo_gbnm(8167, 'yellow perch').
ncbi_mult_taxo_gbnm(8168, 'European perch').
ncbi_mult_taxo_gbnm(8169, porgies).
ncbi_mult_taxo_gbnm(8173, 'common seabream').
ncbi_mult_taxo_gbnm(8175, 'gilthead seabream').
ncbi_mult_taxo_gbnm(8177, 'yellowfin seabream').
ncbi_mult_taxo_gbnm(8179, 'southern black bream').
ncbi_mult_taxo_gbnm(8180, sunfishes).
ncbi_mult_taxo_gbnm(8182, 'black crappie').
ncbi_mult_taxo_gbnm(8184, snooks).
ncbi_mult_taxo_gbnm(8187, 'barramundi perch').
ncbi_mult_taxo_gbnm(8189, mullets).
ncbi_mult_taxo_gbnm(8193, eelpouts).
ncbi_mult_taxo_gbnm(8197, 'Canadian eelpout').
ncbi_mult_taxo_gbnm(8199, 'ocean pout').
ncbi_mult_taxo_gbnm(8201, 'Antarctic eel pout').
ncbi_mult_taxo_gbnm(8202, wolffishes).
ncbi_mult_taxo_gbnm(8204, 'Atlantic wolffish').
ncbi_mult_taxo_gbnm(8206, 'Antarctic cods').
ncbi_mult_taxo_gbnm(8208, 'black rockcod').
ncbi_mult_taxo_gbnm(8210, 'Maori chief').
ncbi_mult_taxo_gbnm(8213, 'bald rockcod').
ncbi_mult_taxo_gbnm(8214, 'Antarctic dragonfishes').
ncbi_mult_taxo_gbnm(8216, 'Mawson\'s dragonfish').
ncbi_mult_taxo_gbnm(8220, gobies).
ncbi_mult_taxo_gbnm(8222, 'long-jawed mudsucker').
ncbi_mult_taxo_gbnm(8224, mackerels).
ncbi_mult_taxo_gbnm(8226, 'skipjack tuna').
ncbi_mult_taxo_gbnm(8227, 'eastern little tuna').
ncbi_mult_taxo_gbnm(8228, 'little tunny').
ncbi_mult_taxo_gbnm(8230, 'striped bonito').
ncbi_mult_taxo_gbnm(8231, 'Pacific bonito').
ncbi_mult_taxo_gbnm(8232, 'Atlantic bonito').
ncbi_mult_taxo_gbnm(8233, tuna).
ncbi_mult_taxo_gbnm(8235, albacore).
ncbi_mult_taxo_gbnm(8236, 'yellowfin tuna').
ncbi_mult_taxo_gbnm(8237, 'Atlantic bluefin tuna').
ncbi_mult_taxo_gbnm(8238, 'Pacific bluefin tuna').
ncbi_mult_taxo_gbnm(8240, 'southern bluefin tuna').
ncbi_mult_taxo_gbnm(8241, 'bigeye tuna').
ncbi_mult_taxo_gbnm(8243, swordfishes).
ncbi_mult_taxo_gbnm(8245, swordfish).
ncbi_mult_taxo_gbnm(8247, wrasses).
ncbi_mult_taxo_gbnm(8252, flatfishes).
ncbi_mult_taxo_gbnm(8253, 'lefteye flounders').
ncbi_mult_taxo_gbnm(8255, 'Japanese flounder').
ncbi_mult_taxo_gbnm(8256, 'righteye flounders').
ncbi_mult_taxo_gbnm(8258, 'yellowtail flounder').
ncbi_mult_taxo_gbnm(8260, 'European flounder').
ncbi_mult_taxo_gbnm(8262, 'European plaice').
ncbi_mult_taxo_gbnm(8265, 'winter flounder').
ncbi_mult_taxo_gbnm(8267, 'Atlantic halibut').
ncbi_mult_taxo_gbnm(8274, butterflyfish).
ncbi_mult_taxo_gbnm(8276, 'freshwater butterflyfish').
ncbi_mult_taxo_gbnm(8277, 'whalefishes and others').
ncbi_mult_taxo_gbnm(8279, 'lanterneye fishes').
ncbi_mult_taxo_gbnm(8281, 'Caribbean flashlight fish').
ncbi_mult_taxo_gbnm(8284, 'European chub').
ncbi_mult_taxo_gbnm(8286, 'Pacific sole').
ncbi_mult_taxo_gbnm(8288, reedfish).
ncbi_mult_taxo_gbnm(8289, bichirs).
ncbi_mult_taxo_gbnm(8292, amphibians).
ncbi_mult_taxo_gbnm(8293, salamanders).
ncbi_mult_taxo_gbnm(8294, 'mole salamanders').
ncbi_mult_taxo_gbnm(8295, 'mole salamanders').
ncbi_mult_taxo_gbnm(8296, axolotl).
ncbi_mult_taxo_gbnm(8297, 'Jefferson salamander').
ncbi_mult_taxo_gbnm(8298, 'blue-spotted salamander').
ncbi_mult_taxo_gbnm(8299, 'blue-spotted x Jefferson salamander').
ncbi_mult_taxo_gbnm(8304, 'smallmouth salamander').
ncbi_mult_taxo_gbnm(8305, 'tiger salamander').
ncbi_mult_taxo_gbnm(8306, 'mole salamander').
ncbi_mult_taxo_gbnm(8310, amphiumas).
ncbi_mult_taxo_gbnm(8312, 'two-toed amphiuma').
ncbi_mult_taxo_gbnm(8313, 'three-toed salamander').
ncbi_mult_taxo_gbnm(8314, newts).
ncbi_mult_taxo_gbnm(8316, 'eastern newt').
ncbi_mult_taxo_gbnm(8319, 'Iberian ribbed newt').
ncbi_mult_taxo_gbnm(8320, 'Pacific newts').
ncbi_mult_taxo_gbnm(8321, 'rough-skinned newt').
ncbi_mult_taxo_gbnm(8323, 'warty newt').
ncbi_mult_taxo_gbnm(8324, 'common newt').
ncbi_mult_taxo_gbnm(8325, 'Balkan newt').
ncbi_mult_taxo_gbnm(8326, 'Italian crested newt').
ncbi_mult_taxo_gbnm(8327, 'Danube newt').
ncbi_mult_taxo_gbnm(8328, 'marbled newt').
ncbi_mult_taxo_gbnm(8329, 'firebelly newts').
ncbi_mult_taxo_gbnm(8330, 'Japanese firebelly newt').
ncbi_mult_taxo_gbnm(8332, 'lungless salamanders').
ncbi_mult_taxo_gbnm(8333, 'mushroom-tongued salamanders').
ncbi_mult_taxo_gbnm(8334, 'La Palma salamander').
ncbi_mult_taxo_gbnm(8335, 'woodland salamanders').
ncbi_mult_taxo_gbnm(8336, 'Appalachian woodland salamander').
ncbi_mult_taxo_gbnm(8337, 'Yonahlossee salamander').
ncbi_mult_taxo_gbnm(8339, sirens).
ncbi_mult_taxo_gbnm(8341, 'lesser siren').
ncbi_mult_taxo_gbnm(8342, 'frogs & toads').
ncbi_mult_taxo_gbnm(8343, 'discoglossid toads').
ncbi_mult_taxo_gbnm(8344, 'firebellied toads').
ncbi_mult_taxo_gbnm(8345, 'fire-bellied toad').
ncbi_mult_taxo_gbnm(8348, 'yellow-bellied toad').
ncbi_mult_taxo_gbnm(8351, 'painted frog').
ncbi_mult_taxo_gbnm(8352, 'tongueless frogs').
ncbi_mult_taxo_gbnm(8354, 'Kenyan clawed frog').
ncbi_mult_taxo_gbnm(8355, 'African clawed frog').
ncbi_mult_taxo_gbnm(8356, 'clawed frog').
ncbi_mult_taxo_gbnm(8358, 'Eritrea clawed frog').
ncbi_mult_taxo_gbnm(8362, 'western dwarf clawed frog').
ncbi_mult_taxo_gbnm(8364, 'tropical clawed frog').
ncbi_mult_taxo_gbnm(8365, 'Australian froglets').
ncbi_mult_taxo_gbnm(8367, 'marbled toadlet').
ncbi_mult_taxo_gbnm(8368, 'wrinkled toadlet').
ncbi_mult_taxo_gbnm(8371, 'green and golden bell frog').
ncbi_mult_taxo_gbnm(8372, 'southern frogs').
ncbi_mult_taxo_gbnm(8374, 'Australian frog').
ncbi_mult_taxo_gbnm(8375, 'Paraguay horned frogs').
ncbi_mult_taxo_gbnm(8376, 'Budgett\'s frog').
ncbi_mult_taxo_gbnm(8377, 'dwarf frogs').
ncbi_mult_taxo_gbnm(8378, 'brown-spotted dwarf frog').
ncbi_mult_taxo_gbnm(8381, 'Juventud robber frog').
ncbi_mult_taxo_gbnm(8382, 'true toads').
ncbi_mult_taxo_gbnm(8384, 'common toad').
ncbi_mult_taxo_gbnm(8386, 'marine toad').
ncbi_mult_taxo_gbnm(8387, 'Japanese toad').
ncbi_mult_taxo_gbnm(8388, 'Gulf coast toad').
ncbi_mult_taxo_gbnm(8389, 'American toad').
ncbi_mult_taxo_gbnm(8392, 'leaf frogs').
ncbi_mult_taxo_gbnm(8393, 'two-colored leaf frog').
ncbi_mult_taxo_gbnm(8394, 'Rohde\'s leaf frog').
ncbi_mult_taxo_gbnm(8395, 'painted-belly leaf frog').
ncbi_mult_taxo_gbnm(8397, 'riparian frogs').
ncbi_mult_taxo_gbnm(8400, 'American bullfrog').
ncbi_mult_taxo_gbnm(8402, 'Japanese frog').
ncbi_mult_taxo_gbnm(8403, 'Iberian green frog').
ncbi_mult_taxo_gbnm(8404, 'northern leopard frog').
ncbi_mult_taxo_gbnm(8406, 'marsh frog').
ncbi_mult_taxo_gbnm(8407, 'common frog').
ncbi_mult_taxo_gbnm(8409, 'dark-spotted frog').
ncbi_mult_taxo_gbnm(8410, 'Japanese wrinkled frog').
ncbi_mult_taxo_gbnm(8412, 'African reed frogs').
ncbi_mult_taxo_gbnm(8413, 'running frogs').
ncbi_mult_taxo_gbnm(8415, 'Senegal running frog').
ncbi_mult_taxo_gbnm(8418, 'tree frogs').
ncbi_mult_taxo_gbnm(8419, 'marsupial frogs').
ncbi_mult_taxo_gbnm(8420, 'Riobamba marsupial frog').
ncbi_mult_taxo_gbnm(8421, 'common treefrogs').
ncbi_mult_taxo_gbnm(8422, 'green tree frog').
ncbi_mult_taxo_gbnm(8423, 'Seychelles frogs').
ncbi_mult_taxo_gbnm(8425, 'Thomasset\'s Seychelles frog').
ncbi_mult_taxo_gbnm(8427, 'microhylid toads').
ncbi_mult_taxo_gbnm(8429, 'eastern narrow-mouthed toad').
ncbi_mult_taxo_gbnm(8432, 'spadefoot toads').
ncbi_mult_taxo_gbnm(8435, 'eastern spadefoot toad').
ncbi_mult_taxo_gbnm(8439, 'tailed frog').
ncbi_mult_taxo_gbnm(8443, 'midwife toad').
ncbi_mult_taxo_gbnm(8445, caecilians).
ncbi_mult_taxo_gbnm(8446, 'true caecilians').
ncbi_mult_taxo_gbnm(8451, 'Asiatic tailed caecilians').
ncbi_mult_taxo_gbnm(8454, 'aquatic caecilians').
ncbi_mult_taxo_gbnm(8456, 'Rio Cauca caecilian').
ncbi_mult_taxo_gbnm(8457, sauropsids).
ncbi_mult_taxo_gbnm(8459, turtles).
ncbi_mult_taxo_gbnm(8460, 'side-necked turtles').
ncbi_mult_taxo_gbnm(8461, 'snake-necked turtles').
ncbi_mult_taxo_gbnm(8463, 'snake-necked turtle').
ncbi_mult_taxo_gbnm(8464, 'hidden-necked turtles').
ncbi_mult_taxo_gbnm(8465, 'sea turtles').
ncbi_mult_taxo_gbnm(8467, 'Loggerhead turtle').
ncbi_mult_taxo_gbnm(8469, 'Green sea turtle').
ncbi_mult_taxo_gbnm(8472, 'Atlantic ridley').
ncbi_mult_taxo_gbnm(8473, 'snapping turtles').
ncbi_mult_taxo_gbnm(8475, 'Common snapping turtle').
ncbi_mult_taxo_gbnm(8476, terrapins).
ncbi_mult_taxo_gbnm(8478, 'western painted turtle').
ncbi_mult_taxo_gbnm(8479, 'Painted turtle').
ncbi_mult_taxo_gbnm(8481, 'map turtle').
ncbi_mult_taxo_gbnm(8485, 'diamondback terrapin').
ncbi_mult_taxo_gbnm(8487, tortoises).
ncbi_mult_taxo_gbnm(8493, crocodilians).
ncbi_mult_taxo_gbnm(8496, 'American alligator').
ncbi_mult_taxo_gbnm(8499, 'spectacled caiman').
ncbi_mult_taxo_gbnm(8501, 'Nile crocodile').
ncbi_mult_taxo_gbnm(8502, 'Australian saltwater crocodile').
ncbi_mult_taxo_gbnm(8503, 'New Guinea crocodile').
ncbi_mult_taxo_gbnm(8504, 'lizards & snakes').
ncbi_mult_taxo_gbnm(8505, 'beaked reptiles').
ncbi_mult_taxo_gbnm(8508, tuatara).
ncbi_mult_taxo_gbnm(8509, squamates).
ncbi_mult_taxo_gbnm(8511, 'iguanian lizards').
ncbi_mult_taxo_gbnm(8515, 'iguanid lizards').
ncbi_mult_taxo_gbnm(8517, 'Common green iguana').
ncbi_mult_taxo_gbnm(8520, 'fence lizard').
ncbi_mult_taxo_gbnm(8524, 'common lizard').
ncbi_mult_taxo_gbnm(8527, 'stump-tailed skink').
ncbi_mult_taxo_gbnm(8530, whiptails).
ncbi_mult_taxo_gbnm(8531, tegus).
ncbi_mult_taxo_gbnm(8532, 'common tegu').
ncbi_mult_taxo_gbnm(8534, 'Auber\'s ameiva').
ncbi_mult_taxo_gbnm(8542, 'Smith\'s tropical night lizard').
ncbi_mult_taxo_gbnm(8548, 'anguimorph lizards').
ncbi_mult_taxo_gbnm(8549, 'beaded lizards').
ncbi_mult_taxo_gbnm(8551, 'Mexican beaded lizard').
ncbi_mult_taxo_gbnm(8552, 'Mexican beaded lizard').
ncbi_mult_taxo_gbnm(8553, 'beaded lizard').
ncbi_mult_taxo_gbnm(8554, 'Gila monster').
ncbi_mult_taxo_gbnm(8555, monitors).
ncbi_mult_taxo_gbnm(8558, 'White-throated monitor').
ncbi_mult_taxo_gbnm(8559, 'lace monitor').
ncbi_mult_taxo_gbnm(8560, geckos).
ncbi_mult_taxo_gbnm(8561, geckos).
ncbi_mult_taxo_gbnm(8569, 'Moorish gecko').
ncbi_mult_taxo_gbnm(8570, snakes).
ncbi_mult_taxo_gbnm(8572, 'true boas').
ncbi_mult_taxo_gbnm(8574, boa).
ncbi_mult_taxo_gbnm(8576, 'Jamaican yellow boa').
ncbi_mult_taxo_gbnm(8578, 'colubrid snakes').
ncbi_mult_taxo_gbnm(8582, 'military ground snake').
ncbi_mult_taxo_gbnm(8584, 'checkered water snake').
ncbi_mult_taxo_gbnm(8585, 'viperine water snake').
ncbi_mult_taxo_gbnm(8589, racers).
ncbi_mult_taxo_gbnm(8590, 'Eastern racer').
ncbi_mult_taxo_gbnm(8598, 'burrowing asps').
ncbi_mult_taxo_gbnm(8600, 'Arabian small-scaled burrowing asp').
ncbi_mult_taxo_gbnm(8605, 'death adder').
ncbi_mult_taxo_gbnm(8607, 'shield snake').
ncbi_mult_taxo_gbnm(8609, 'ringed water cobra').
ncbi_mult_taxo_gbnm(8610, 'banded water cobra').
ncbi_mult_taxo_gbnm(8611, 'Christy\'s water cobra').
ncbi_mult_taxo_gbnm(8613, 'banded krait').
ncbi_mult_taxo_gbnm(8615, 'red-headed krait').
ncbi_mult_taxo_gbnm(8616, 'many-banded krait').
ncbi_mult_taxo_gbnm(8618, 'eastern green mamba').
ncbi_mult_taxo_gbnm(8619, 'eastern Jameson\'s mamba').
ncbi_mult_taxo_gbnm(8620, 'black mamba').
ncbi_mult_taxo_gbnm(8621, 'western green mamba').
ncbi_mult_taxo_gbnm(8623, 'Jameson\'s mamba').
ncbi_mult_taxo_gbnm(8626, ringhals).
ncbi_mult_taxo_gbnm(8628, 'yellow-lipped sea krait').
ncbi_mult_taxo_gbnm(8629, 'Crocker\'s sea krait').
ncbi_mult_taxo_gbnm(8630, 'blue-ringed sea krait').
ncbi_mult_taxo_gbnm(8631, 'broad-banded blue sea krait').
ncbi_mult_taxo_gbnm(8633, 'Blue Malaysian coral snake').
ncbi_mult_taxo_gbnm(8634, 'coral snakes').
ncbi_mult_taxo_gbnm(8635, 'black-banded coral snake').
ncbi_mult_taxo_gbnm(8636, 'Mexican coral snake').
ncbi_mult_taxo_gbnm(8637, 'eastern coral snake').
ncbi_mult_taxo_gbnm(8642, 'Egyptian cobra').
ncbi_mult_taxo_gbnm(8643, 'forest cobra').
ncbi_mult_taxo_gbnm(8644, 'Mozambique cobra').
ncbi_mult_taxo_gbnm(8649, 'monocled cobra').
ncbi_mult_taxo_gbnm(8654, 'spitting cobra').
ncbi_mult_taxo_gbnm(8655, 'cape cobra').
ncbi_mult_taxo_gbnm(8656, 'Chinese cobra').
ncbi_mult_taxo_gbnm(8657, 'Central Asian cobra').
ncbi_mult_taxo_gbnm(8658, 'red spitting cobra').
ncbi_mult_taxo_gbnm(8659, 'Philippine cobra').
ncbi_mult_taxo_gbnm(8660, 'Visayan cobra').
ncbi_mult_taxo_gbnm(8663, 'mainland tiger snake').
ncbi_mult_taxo_gbnm(8665, 'king cobra').
ncbi_mult_taxo_gbnm(8667, 'Australian taipan').
ncbi_mult_taxo_gbnm(8670, 'mulga snake').
ncbi_mult_taxo_gbnm(8671, 'red-bellied black snake').
ncbi_mult_taxo_gbnm(8676, 'Spiny-headed seasnake').
ncbi_mult_taxo_gbnm(8678, 'olive-brown sea snake').
ncbi_mult_taxo_gbnm(8682, 'beaked sea snake').
ncbi_mult_taxo_gbnm(8684, 'Persian Gulf sea snake').
ncbi_mult_taxo_gbnm(8685, 'reef sea snake').
ncbi_mult_taxo_gbnm(8686, 'Asian annulated sea snake').
ncbi_mult_taxo_gbnm(8688, 'pelagic sea snake').
ncbi_mult_taxo_gbnm(8690, vipers).
ncbi_mult_taxo_gbnm(8692, 'puff adder').
ncbi_mult_taxo_gbnm(8693, 'horned viper').
ncbi_mult_taxo_gbnm(8694, 'Gaboon viper').
ncbi_mult_taxo_gbnm(8695, 'rhinoceros viper').
ncbi_mult_taxo_gbnm(8697, 'horn viper').
ncbi_mult_taxo_gbnm(8698, 'Sahara sand viper').
ncbi_mult_taxo_gbnm(8700, 'carpet viper').
ncbi_mult_taxo_gbnm(8704, 'sand viper').
ncbi_mult_taxo_gbnm(8705, 'western sand viper').
ncbi_mult_taxo_gbnm(8706, 'aspic viper').
ncbi_mult_taxo_gbnm(8707, 'Russell\'s viper').
ncbi_mult_taxo_gbnm(8710, 'pit vipers').
ncbi_mult_taxo_gbnm(8713, 'southern copperhead').
ncbi_mult_taxo_gbnm(8714, 'Halys viper').
ncbi_mult_taxo_gbnm(8715, cottonmouth).
ncbi_mult_taxo_gbnm(8716, 'Eastern cottonmouth').
ncbi_mult_taxo_gbnm(8717, 'Malayan pit viper').
ncbi_mult_taxo_gbnm(8718, 'Cantil viper').
ncbi_mult_taxo_gbnm(8719, 'Chinese water mocassin').
ncbi_mult_taxo_gbnm(8720, 'Copperhead').
ncbi_mult_taxo_gbnm(8722, terciopelo).
ncbi_mult_taxo_gbnm(8723, 'golden lancehead').
ncbi_mult_taxo_gbnm(8724, jararaca).
ncbi_mult_taxo_gbnm(8725, 'barba amarilla').
ncbi_mult_taxo_gbnm(8726, jararacussu).
ncbi_mult_taxo_gbnm(8727, cotiara).
ncbi_mult_taxo_gbnm(8729, 'eastern diamondback rattlesnake').
ncbi_mult_taxo_gbnm(8730, 'western diamondback rattlesnake').
ncbi_mult_taxo_gbnm(8731, 'tropical rattlesnake').
ncbi_mult_taxo_gbnm(8732, 'tropical rattlesnake').
ncbi_mult_taxo_gbnm(8733, 'blacktail rattlesnake').
ncbi_mult_taxo_gbnm(8735, 'red diamond rattlesnake').
ncbi_mult_taxo_gbnm(8736, 'red diamond rattlesnake').
ncbi_mult_taxo_gbnm(8737, 'Mojave rattlesnake').
ncbi_mult_taxo_gbnm(8738, 'Mojave rattlesnake').
ncbi_mult_taxo_gbnm(8739, 'western rattlesnake').
ncbi_mult_taxo_gbnm(8740, 'midget faded rattlesnake').
ncbi_mult_taxo_gbnm(8741, 'southern Pacific rattlesnake').
ncbi_mult_taxo_gbnm(8742, 'prairie rattlesnake').
ncbi_mult_taxo_gbnm(8752, bushmaster).
ncbi_mult_taxo_gbnm(8756, massasauga).
ncbi_mult_taxo_gbnm(8757, 'Western massasauga').
ncbi_mult_taxo_gbnm(8758, 'pigmy rattlesnake').
ncbi_mult_taxo_gbnm(8759, 'dusky pigmy rattlesnake').
ncbi_mult_taxo_gbnm(8762, 'desert massasauga').
ncbi_mult_taxo_gbnm(8765, 'white-lipped tree viper').
ncbi_mult_taxo_gbnm(8767, 'Indian green tree viper').
ncbi_mult_taxo_gbnm(8769, himehabu).
ncbi_mult_taxo_gbnm(8770, 'Wagler\'s pit viper').
ncbi_mult_taxo_gbnm(8781, 'Hardwick\'s sea snake').
ncbi_mult_taxo_gbnm(8782, birds).
ncbi_mult_taxo_gbnm(8784, 'emus & cassowaries').
ncbi_mult_taxo_gbnm(8785, cassowaries).
ncbi_mult_taxo_gbnm(8787, 'southern cassowary').
ncbi_mult_taxo_gbnm(8788, emus).
ncbi_mult_taxo_gbnm(8790, emu).
ncbi_mult_taxo_gbnm(8792, rheas).
ncbi_mult_taxo_gbnm(8797, 'greater rhea').
ncbi_mult_taxo_gbnm(8798, ostriches).
ncbi_mult_taxo_gbnm(8801, 'African ostrich').
ncbi_mult_taxo_gbnm(8802, tinamous).
ncbi_mult_taxo_gbnm(8805, 'elegant crested-tinamou').
ncbi_mult_taxo_gbnm(8807, 'brushland tinamou').
ncbi_mult_taxo_gbnm(8808, moas).
ncbi_mult_taxo_gbnm(8811, 'little bush moa').
ncbi_mult_taxo_gbnm(8813, 'upland moa').
ncbi_mult_taxo_gbnm(8815, 'heavy-footed moa').
ncbi_mult_taxo_gbnm(8818, 'large bush moa').
ncbi_mult_taxo_gbnm(8819, kiwis).
ncbi_mult_taxo_gbnm(8822, 'Southern brown kiwi').
ncbi_mult_taxo_gbnm(8823, 'Great spotted kiwi').
ncbi_mult_taxo_gbnm(8824, 'little spotted kiwi').
ncbi_mult_taxo_gbnm(8826, 'ducks, geese & swans').
ncbi_mult_taxo_gbnm(8827, screamers).
ncbi_mult_taxo_gbnm(8829, 'northern screamer').
ncbi_mult_taxo_gbnm(8830, waterfowl).
ncbi_mult_taxo_gbnm(8832, 'mandarin duck').
ncbi_mult_taxo_gbnm(8833, 'wood duck').
ncbi_mult_taxo_gbnm(8835, ducks).
ncbi_mult_taxo_gbnm(8837, 'cape teal').
ncbi_mult_taxo_gbnm(8838, 'Eurasian wigeon').
ncbi_mult_taxo_gbnm(8839, mallard).
ncbi_mult_taxo_gbnm(8840, 'common mallard').
ncbi_mult_taxo_gbnm(8841, 'domestic duck x muscovy duck').
ncbi_mult_taxo_gbnm(8842, geese).
ncbi_mult_taxo_gbnm(8843, 'Domestic goose').
ncbi_mult_taxo_gbnm(8844, 'western graylag goose').
ncbi_mult_taxo_gbnm(8845, 'Swan goose').
ncbi_mult_taxo_gbnm(8846, 'Bar-headed goose').
ncbi_mult_taxo_gbnm(8847, goose).
ncbi_mult_taxo_gbnm(8849, 'Snow goose').
ncbi_mult_taxo_gbnm(8851, 'magpie goose').
ncbi_mult_taxo_gbnm(8853, 'Canada goose').
ncbi_mult_taxo_gbnm(8855, 'Muscovy duck').
ncbi_mult_taxo_gbnm(8858, 'Cape Barren goose').
ncbi_mult_taxo_gbnm(8860, 'Andean goose').
ncbi_mult_taxo_gbnm(8861, 'upland goose').
ncbi_mult_taxo_gbnm(8863, 'Coscoroba swan').
ncbi_mult_taxo_gbnm(8865, 'blue-winged goose').
ncbi_mult_taxo_gbnm(8867, swans).
ncbi_mult_taxo_gbnm(8868, 'black swan').
ncbi_mult_taxo_gbnm(8869, 'mute swan').
ncbi_mult_taxo_gbnm(8871, 'black-billed whistling-duck').
ncbi_mult_taxo_gbnm(8872, 'wandering whistling-duck').
ncbi_mult_taxo_gbnm(8873, 'black-bellied whistling-duck').
ncbi_mult_taxo_gbnm(8874, 'fulvous whistling-duck').
ncbi_mult_taxo_gbnm(8875, 'plumed whistling-duck').
ncbi_mult_taxo_gbnm(8876, 'white-faced whistling-duck').
ncbi_mult_taxo_gbnm(8880, 'common merganser').
ncbi_mult_taxo_gbnm(8882, 'Orinoco goose').
ncbi_mult_taxo_gbnm(8884, 'ruddy duck').
ncbi_mult_taxo_gbnm(8885, 'lack duck').
ncbi_mult_taxo_gbnm(8887, 'knob-billed duck').
ncbi_mult_taxo_gbnm(8892, 'swifts and hummingbirds').
ncbi_mult_taxo_gbnm(8893, swifts).
ncbi_mult_taxo_gbnm(8895, 'common swift').
ncbi_mult_taxo_gbnm(8897, 'chimney swift').
ncbi_mult_taxo_gbnm(8899, herons).
ncbi_mult_taxo_gbnm(8900, 'night herons').
ncbi_mult_taxo_gbnm(8901, 'black-crowned night-heron').
ncbi_mult_taxo_gbnm(8902, 'nightjars and others').
ncbi_mult_taxo_gbnm(8903, frogmouths).
ncbi_mult_taxo_gbnm(8905, 'tawny frogmouth').
ncbi_mult_taxo_gbnm(8906, 'shorebirds & allies').
ncbi_mult_taxo_gbnm(8909, 'spur-winged plover').
ncbi_mult_taxo_gbnm(8910, gulls).
ncbi_mult_taxo_gbnm(8917, snipes).
ncbi_mult_taxo_gbnm(8919, dunlin).
ncbi_mult_taxo_gbnm(8920, 'storks and others').
ncbi_mult_taxo_gbnm(8924, 'Andean condor').
ncbi_mult_taxo_gbnm(8926, storks).
ncbi_mult_taxo_gbnm(8928, 'White stork').
ncbi_mult_taxo_gbnm(8929, 'pigeons and others').
ncbi_mult_taxo_gbnm(8930, pigeons).
ncbi_mult_taxo_gbnm(8932, 'rock pigeon').
ncbi_mult_taxo_gbnm(8936, 'kingfishers and others').
ncbi_mult_taxo_gbnm(8937, kingfishers).
ncbi_mult_taxo_gbnm(8939, 'Laughing kookaburra').
ncbi_mult_taxo_gbnm(8940, 'cuckoos and others').
ncbi_mult_taxo_gbnm(8941, cuckoos).
ncbi_mult_taxo_gbnm(8943, 'coral-billed ground-cuckoo').
ncbi_mult_taxo_gbnm(8945, 'Asian koel').
ncbi_mult_taxo_gbnm(8947, 'greater roadrunner').
ncbi_mult_taxo_gbnm(8948, 'falcons and others').
ncbi_mult_taxo_gbnm(8951, 'crested caracara').
ncbi_mult_taxo_gbnm(8952, falcons).
ncbi_mult_taxo_gbnm(8954, 'peregrine falcon').
ncbi_mult_taxo_gbnm(8957, 'Northern goshawk').
ncbi_mult_taxo_gbnm(8959, 'Cinereous vulture').
ncbi_mult_taxo_gbnm(8961, 'wedge-tailed eagle').
ncbi_mult_taxo_gbnm(8962, 'golden eagle').
ncbi_mult_taxo_gbnm(8963, harriers).
ncbi_mult_taxo_gbnm(8964, 'western marsh harrier').
ncbi_mult_taxo_gbnm(8966, 'cape vulture').
ncbi_mult_taxo_gbnm(8967, 'Rueppell\'s griffon').
ncbi_mult_taxo_gbnm(8969, 'white-tailed eagle').
ncbi_mult_taxo_gbnm(8971, 'brahminy kite').
ncbi_mult_taxo_gbnm(8973, 'Madagascar harrier-hawk').
ncbi_mult_taxo_gbnm(8975, 'white-headed vulture').
ncbi_mult_taxo_gbnm(8976, landfowls).
ncbi_mult_taxo_gbnm(8979, 'common megapode').
ncbi_mult_taxo_gbnm(8981, malleefowl).
ncbi_mult_taxo_gbnm(8984, 'plain chachalaca').
ncbi_mult_taxo_gbnm(8986, 'White-browed guan').
ncbi_mult_taxo_gbnm(8987, 'rusty-margined guan').
ncbi_mult_taxo_gbnm(8990, guineafowls).
ncbi_mult_taxo_gbnm(8992, 'vulturine guineafowl').
ncbi_mult_taxo_gbnm(8994, 'Kenya guineafowl').
ncbi_mult_taxo_gbnm(8996, 'helmeted guineafowl').
ncbi_mult_taxo_gbnm(8997, guineafowl).
ncbi_mult_taxo_gbnm(9000, 'ruffed grouse').
ncbi_mult_taxo_gbnm(9002, 'Greater sage-grouse').
ncbi_mult_taxo_gbnm(9004, 'greater prairie chicken').
ncbi_mult_taxo_gbnm(9005, turkeys).
ncbi_mult_taxo_gbnm(9009, 'scaled quail').
ncbi_mult_taxo_gbnm(9010, 'chestnut-bellied scaled quail').
ncbi_mult_taxo_gbnm(9011, 'blue scaled quail').
ncbi_mult_taxo_gbnm(9014, 'northern bobwhite').
ncbi_mult_taxo_gbnm(9017, 'Montezuma quail').
ncbi_mult_taxo_gbnm(9019, 'gray francolin').
ncbi_mult_taxo_gbnm(9020, 'Red-necked spurfowl').
ncbi_mult_taxo_gbnm(9021, 'Coqui francolin').
ncbi_mult_taxo_gbnm(9022, 'Erckel\'s francolin').
ncbi_mult_taxo_gbnm(9023, 'black francolin').
ncbi_mult_taxo_gbnm(9029, 'mountain quail').
ncbi_mult_taxo_gbnm(9031, chicken).
ncbi_mult_taxo_gbnm(9032, 'Ceylon junglefowl').
ncbi_mult_taxo_gbnm(9033, 'gray junglefowl').
ncbi_mult_taxo_gbnm(9034, 'green junglefowl').
ncbi_mult_taxo_gbnm(9040, 'Himalayan monal').
ncbi_mult_taxo_gbnm(9042, 'Bulwer\'s pheasant').
ncbi_mult_taxo_gbnm(9043, 'Edwards\'s pheasant').
ncbi_mult_taxo_gbnm(9044, 'crested fireback pheasant').
ncbi_mult_taxo_gbnm(9046, 'Silver pheasant').
ncbi_mult_taxo_gbnm(9048, peafowls).
ncbi_mult_taxo_gbnm(9049, 'Indian peafowl').
ncbi_mult_taxo_gbnm(9050, 'green peafowl').
ncbi_mult_taxo_gbnm(9052, 'grey partridge').
ncbi_mult_taxo_gbnm(9054, 'ring-necked pheasant').
ncbi_mult_taxo_gbnm(9055, 'green pheasant').
ncbi_mult_taxo_gbnm(9057, 'ring-necked pheasant').
ncbi_mult_taxo_gbnm(9059, 'gray peacock-pheasant').
ncbi_mult_taxo_gbnm(9063, 'Elliot\'s pheasant').
ncbi_mult_taxo_gbnm(9064, 'Hume\'s pheasant').
ncbi_mult_taxo_gbnm(9065, 'Mikado pheasant').
ncbi_mult_taxo_gbnm(9066, 'Reeves\'s pheasant').
ncbi_mult_taxo_gbnm(9067, 'copper pheasant').
ncbi_mult_taxo_gbnm(9076, 'Congo peafowl').
ncbi_mult_taxo_gbnm(9078, 'chukar partridge').
ncbi_mult_taxo_gbnm(9079, 'red-legged partridge').
ncbi_mult_taxo_gbnm(9081, 'great argus').
ncbi_mult_taxo_gbnm(9083, 'Chinese bamboo-partridge').
ncbi_mult_taxo_gbnm(9085, 'cheer pheasant').
ncbi_mult_taxo_gbnm(9088, 'Lady Amherst\'s pheasant').
ncbi_mult_taxo_gbnm(9089, 'golden pheasant').
ncbi_mult_taxo_gbnm(9091, 'Common quail').
ncbi_mult_taxo_gbnm(9093, 'harlequin quail').
ncbi_mult_taxo_gbnm(9096, 'blue eared-pheasant').
ncbi_mult_taxo_gbnm(9097, 'brown eared-pheasant').
ncbi_mult_taxo_gbnm(9101, 'ocellated turkey').
ncbi_mult_taxo_gbnm(9103, turkey).
ncbi_mult_taxo_gbnm(9105, 'hill partridge').
ncbi_mult_taxo_gbnm(9108, 'cranes, rails & allies').
ncbi_mult_taxo_gbnm(9109, cranes).
ncbi_mult_taxo_gbnm(9111, 'demoiselle crane').
ncbi_mult_taxo_gbnm(9117, 'Whooping crane').
ncbi_mult_taxo_gbnm(9118, 'wattled crane').
ncbi_mult_taxo_gbnm(9119, rails).
ncbi_mult_taxo_gbnm(9120, coots).
ncbi_mult_taxo_gbnm(9121, 'Eurasian coot').
ncbi_mult_taxo_gbnm(9123, 'common moorhen').
ncbi_mult_taxo_gbnm(9125, weka).
ncbi_mult_taxo_gbnm(9126, 'song birds').
ncbi_mult_taxo_gbnm(9132, 'Australian magpie').
ncbi_mult_taxo_gbnm(9135, 'Common canary').
ncbi_mult_taxo_gbnm(9138, 'creamy-breasted canastero').
ncbi_mult_taxo_gbnm(9143, 'Australian choughs').
ncbi_mult_taxo_gbnm(9145, 'white-winged chough').
ncbi_mult_taxo_gbnm(9146, honeyeaters).
ncbi_mult_taxo_gbnm(9148, 'leaden honeyeater').
ncbi_mult_taxo_gbnm(9149, 'paradise birds').
ncbi_mult_taxo_gbnm(9151, 'black-billed sicklebill').
ncbi_mult_taxo_gbnm(9153, titmice).
ncbi_mult_taxo_gbnm(9157, 'Great Tit').
ncbi_mult_taxo_gbnm(9158, sparrows).
ncbi_mult_taxo_gbnm(9160, 'Eurasian tree sparrow').
ncbi_mult_taxo_gbnm(9161, pittas).
ncbi_mult_taxo_gbnm(9163, 'hooded pitta').
ncbi_mult_taxo_gbnm(9164, bowerbirds).
ncbi_mult_taxo_gbnm(9166, 'MacGregor\'s bowerbird').
ncbi_mult_taxo_gbnm(9167, tapaculos).
ncbi_mult_taxo_gbnm(9169, 'Andean tapaculo').
ncbi_mult_taxo_gbnm(9170, starlings).
ncbi_mult_taxo_gbnm(9172, 'Common starling').
ncbi_mult_taxo_gbnm(9173, babblers).
ncbi_mult_taxo_gbnm(9175, 'rufous babbler').
ncbi_mult_taxo_gbnm(9176, 'chestnut-crowned babbler').
ncbi_mult_taxo_gbnm(9177, 'white-browed babbler').
ncbi_mult_taxo_gbnm(9178, 'gray-crowned babbler').
ncbi_mult_taxo_gbnm(9182, 'Willow warbler').
ncbi_mult_taxo_gbnm(9183, thrushes).
ncbi_mult_taxo_gbnm(9185, 'hermit thrush').
ncbi_mult_taxo_gbnm(9187, blackbird).
ncbi_mult_taxo_gbnm(9188, 'American robin').
ncbi_mult_taxo_gbnm(9191, 'tricolored blackbird').
ncbi_mult_taxo_gbnm(9193, shrikes).
ncbi_mult_taxo_gbnm(9196, 'Abyssinnian gonolek').
ncbi_mult_taxo_gbnm(9198, 'Luehder\'s bushshrike').
ncbi_mult_taxo_gbnm(9205, 'Ibis, herons and pelicans').
ncbi_mult_taxo_gbnm(9206, 'cormorants and shags').
ncbi_mult_taxo_gbnm(9208, 'king cormorant').
ncbi_mult_taxo_gbnm(9209, 'great cormorant').
ncbi_mult_taxo_gbnm(9210, 'little black cormorant').
ncbi_mult_taxo_gbnm(9211, anhingas).
ncbi_mult_taxo_gbnm(9213, 'Australian darter').
ncbi_mult_taxo_gbnm(9214, flamingos).
ncbi_mult_taxo_gbnm(9215, flamingos).
ncbi_mult_taxo_gbnm(9217, 'American flamingo').
ncbi_mult_taxo_gbnm(9219, 'woodpeckers and others').
ncbi_mult_taxo_gbnm(9220, woodpeckers).
ncbi_mult_taxo_gbnm(9222, 'Andean flicker').
ncbi_mult_taxo_gbnm(9223, 'parrots and others').
ncbi_mult_taxo_gbnm(9224, parrots).
ncbi_mult_taxo_gbnm(9226, 'blue-and-yellow macaw').
ncbi_mult_taxo_gbnm(9228, 'Rose-ringed parakeet').
ncbi_mult_taxo_gbnm(9230, penguins).
ncbi_mult_taxo_gbnm(9231, penguins).
ncbi_mult_taxo_gbnm(9233, 'emperor penguin').
ncbi_mult_taxo_gbnm(9234, 'king penguin').
ncbi_mult_taxo_gbnm(9238, 'Adelie penguin').
ncbi_mult_taxo_gbnm(9240, 'Humboldt\'s penguin').
ncbi_mult_taxo_gbnm(9242, hummingbirds).
ncbi_mult_taxo_gbnm(9244, 'Anna\'s hummingbird').
ncbi_mult_taxo_gbnm(9246, buttonquails).
ncbi_mult_taxo_gbnm(9248, 'Andalusian buttonquail').
ncbi_mult_taxo_gbnm(9255, monotremes).
ncbi_mult_taxo_gbnm(9258, platypus).
ncbi_mult_taxo_gbnm(9259, echidnas).
ncbi_mult_taxo_gbnm(9260, 'short-nosed echidnas').
ncbi_mult_taxo_gbnm(9261, 'Australian echidna').
ncbi_mult_taxo_gbnm(9263, marsupials).
ncbi_mult_taxo_gbnm(9265, opossums).
ncbi_mult_taxo_gbnm(9267, 'North American opossum').
ncbi_mult_taxo_gbnm(9268, 'southern opossum').
ncbi_mult_taxo_gbnm(9272, 'gray four-eyed opossum').
ncbi_mult_taxo_gbnm(9275, 'Tasmanian wolf').
ncbi_mult_taxo_gbnm(9278, quolls).
ncbi_mult_taxo_gbnm(9279, 'eastern quoll').
ncbi_mult_taxo_gbnm(9280, 'northern quoll').
ncbi_mult_taxo_gbnm(9281, 'spotted-tailed quoll').
ncbi_mult_taxo_gbnm(9282, 'broad-footed marsupial mice').
ncbi_mult_taxo_gbnm(9283, 'brown antechinus').
ncbi_mult_taxo_gbnm(9284, 'dusky antechinus').
ncbi_mult_taxo_gbnm(9288, 'short-haired marsupial mice').
ncbi_mult_taxo_gbnm(9291, 'southern dibbler').
ncbi_mult_taxo_gbnm(9292, tuans).
ncbi_mult_taxo_gbnm(9293, 'brush-tailed phascogale').
ncbi_mult_taxo_gbnm(9295, 'narrow-striped marsupial shrew').
ncbi_mult_taxo_gbnm(9297, 'pygmy planigale').
ncbi_mult_taxo_gbnm(9299, 'fat-tailed pseudantechinus').
ncbi_mult_taxo_gbnm(9301, 'fat-tailed dunnart').
ncbi_mult_taxo_gbnm(9302, 'stripe-faced dunnart').
ncbi_mult_taxo_gbnm(9305, 'Tasmanian devil').
ncbi_mult_taxo_gbnm(9310, 'long-nosed potoroo').
ncbi_mult_taxo_gbnm(9313, 'Agile wallaby').
ncbi_mult_taxo_gbnm(9314, 'antelopine kangaroo').
ncbi_mult_taxo_gbnm(9315, 'tammar wallaby').
ncbi_mult_taxo_gbnm(9316, 'western gray kangaroo').
ncbi_mult_taxo_gbnm(9317, 'eastern gray kangaroo').
ncbi_mult_taxo_gbnm(9318, 'whiptail wallaby').
ncbi_mult_taxo_gbnm(9319, 'common wallaroo').
ncbi_mult_taxo_gbnm(9321, 'red kangaroo').
ncbi_mult_taxo_gbnm(9322, kangaroo).
ncbi_mult_taxo_gbnm(9323, 'black wallaroo').
ncbi_mult_taxo_gbnm(9324, 'rock wallabies').
ncbi_mult_taxo_gbnm(9325, 'ring-tailed rock wallaby').
ncbi_mult_taxo_gbnm(9327, 'red-bellied pademelon').
ncbi_mult_taxo_gbnm(9328, 'red-legged pademelon').
ncbi_mult_taxo_gbnm(9330, 'swamp wallaby').
ncbi_mult_taxo_gbnm(9331, 'gliding and striped possums').
ncbi_mult_taxo_gbnm(9333, 'common ring-tailed possum').
ncbi_mult_taxo_gbnm(9335, 'possums and cuscuses').
ncbi_mult_taxo_gbnm(9336, 'brush-tailed possums').
ncbi_mult_taxo_gbnm(9337, 'common brushtail').
ncbi_mult_taxo_gbnm(9338, wombats).
ncbi_mult_taxo_gbnm(9342, bandicoots).
ncbi_mult_taxo_gbnm(9344, 'long-nosed bandicoot').
ncbi_mult_taxo_gbnm(9347, placentals).
ncbi_mult_taxo_gbnm(9348, 'armadillos and others').
ncbi_mult_taxo_gbnm(9349, anteaters).
ncbi_mult_taxo_gbnm(9351, 'Mexican collared anteater').
ncbi_mult_taxo_gbnm(9352, 'three-fingered sloths').
ncbi_mult_taxo_gbnm(9353, 'three-toed sloths').
ncbi_mult_taxo_gbnm(9354, 'Pale-throated sloth').
ncbi_mult_taxo_gbnm(9355, 'Brown-throated sloth').
ncbi_mult_taxo_gbnm(9358, 'Hoffmann\'s two-fingered sloth').
ncbi_mult_taxo_gbnm(9359, armadillos).
ncbi_mult_taxo_gbnm(9361, 'nine-banded armadillo').
ncbi_mult_taxo_gbnm(9362, insectivores).
ncbi_mult_taxo_gbnm(9363, hedgehogs).
ncbi_mult_taxo_gbnm(9365, 'western European hedgehog').
ncbi_mult_taxo_gbnm(9366, moonrats).
ncbi_mult_taxo_gbnm(9368, 'middle-African hedgehog').
ncbi_mult_taxo_gbnm(9369, tenrecs).
ncbi_mult_taxo_gbnm(9371, 'small Madagascar hedgehog').
ncbi_mult_taxo_gbnm(9373, 'moles, shrew-moles, and desmans').
ncbi_mult_taxo_gbnm(9375, 'European mole').
ncbi_mult_taxo_gbnm(9376, shrews).
ncbi_mult_taxo_gbnm(9377, 'musk shrews').
ncbi_mult_taxo_gbnm(9378, 'house shrew').
ncbi_mult_taxo_gbnm(9383, 'prairie shrew').
ncbi_mult_taxo_gbnm(9384, 'pygmy shrew').
ncbi_mult_taxo_gbnm(9387, 'short-tailed shrew').
ncbi_mult_taxo_gbnm(9389, 'Golden moles').
ncbi_mult_taxo_gbnm(9391, 'Hottentot golden mole').
ncbi_mult_taxo_gbnm(9392, 'tree shrews').
ncbi_mult_taxo_gbnm(9393, 'tree shrews').
ncbi_mult_taxo_gbnm(9395, 'common tree shrew').
ncbi_mult_taxo_gbnm(9397, bats).
ncbi_mult_taxo_gbnm(9398, 'flying foxes').
ncbi_mult_taxo_gbnm(9400, 'Indian short-nosed fruit bat').
ncbi_mult_taxo_gbnm(9402, 'black flying fox').
ncbi_mult_taxo_gbnm(9403, 'gray-headed flying fox').
ncbi_mult_taxo_gbnm(9404, 'Temminck\'s flying fox').
ncbi_mult_taxo_gbnm(9405, 'small flying fox').
ncbi_mult_taxo_gbnm(9407, 'Egyptian rousette').
ncbi_mult_taxo_gbnm(9408, 'Leschenault\'s rousette').
ncbi_mult_taxo_gbnm(9409, 'false vampire bats').
ncbi_mult_taxo_gbnm(9411, 'Australian ghost bat').
ncbi_mult_taxo_gbnm(9414, 'lesser false vampire bat').
ncbi_mult_taxo_gbnm(9415, 'leaf-nosed bats').
ncbi_mult_taxo_gbnm(9416, 'neotropical fruit bats').
ncbi_mult_taxo_gbnm(9417, 'Jamaican fruit-eating bat').
ncbi_mult_taxo_gbnm(9418, 'big-eared bats').
ncbi_mult_taxo_gbnm(9419, 'California big-eared bat').
ncbi_mult_taxo_gbnm(9421, 'Antillean fruit-eating bat').
ncbi_mult_taxo_gbnm(9423, 'greater spear-nosed bat').
ncbi_mult_taxo_gbnm(9426, 'Spix\'s round-eared bat').
ncbi_mult_taxo_gbnm(9430, 'common vampire bat').
ncbi_mult_taxo_gbnm(9431, 'vesper bats').
ncbi_mult_taxo_gbnm(9433, 'Schreibers\' long-fingered bat').
ncbi_mult_taxo_gbnm(9435, 'mouse-eared bat').
ncbi_mult_taxo_gbnm(9436, 'free-tailed bats').
ncbi_mult_taxo_gbnm(9438, 'Brazilian free-tailed bat').
ncbi_mult_taxo_gbnm(9440, 'pallid bat').
ncbi_mult_taxo_gbnm(9443, primates).
ncbi_mult_taxo_gbnm(9445, lemurs).
ncbi_mult_taxo_gbnm(9447, 'Ring-tailed lemur').
ncbi_mult_taxo_gbnm(9453, 'weasel lemur').
ncbi_mult_taxo_gbnm(9455, 'ruffed lemur').
ncbi_mult_taxo_gbnm(9460, 'Lesser dwarf lemur').
ncbi_mult_taxo_gbnm(9461, lorises).
ncbi_mult_taxo_gbnm(9463, 'thick-tailed bush baby').
ncbi_mult_taxo_gbnm(9464, 'bush baby').
ncbi_mult_taxo_gbnm(9465, 'Senegal galago').
ncbi_mult_taxo_gbnm(9468, 'slender loris').
ncbi_mult_taxo_gbnm(9470, 'slow loris').
ncbi_mult_taxo_gbnm(9472, potto).
ncbi_mult_taxo_gbnm(9475, tarsiers).
ncbi_mult_taxo_gbnm(9477, 'Horsfield\'s tarsier').
ncbi_mult_taxo_gbnm(9479, 'New World monkeys').
ncbi_mult_taxo_gbnm(9480, 'marmosets and tamarins').
ncbi_mult_taxo_gbnm(9482, 'Silvery marmoset').
ncbi_mult_taxo_gbnm(9483, 'white-tufted-ear marmoset').
ncbi_mult_taxo_gbnm(9487, 'brown-headed tamarin').
ncbi_mult_taxo_gbnm(9488, 'moustached tamarin').
ncbi_mult_taxo_gbnm(9489, 'black-and-red tamarin').
ncbi_mult_taxo_gbnm(9490, 'cotton-top tamarin').
ncbi_mult_taxo_gbnm(9491, tamarin).
ncbi_mult_taxo_gbnm(9493, 'pygmy marmoset').
ncbi_mult_taxo_gbnm(9495, 'Goeldi\'s marmoset').
ncbi_mult_taxo_gbnm(9499, 'howler monkeys').
ncbi_mult_taxo_gbnm(9501, 'howler monkey').
ncbi_mult_taxo_gbnm(9502, 'black howler monkey').
ncbi_mult_taxo_gbnm(9503, 'howler monkey').
ncbi_mult_taxo_gbnm(9504, 'night monkeys').
ncbi_mult_taxo_gbnm(9505, douroucouli).
ncbi_mult_taxo_gbnm(9507, 'white-bellied spider monkey').
ncbi_mult_taxo_gbnm(9508, 'brown-headed spider monkey').
ncbi_mult_taxo_gbnm(9509, 'black-handed spider monkey').
ncbi_mult_taxo_gbnm(9510, 'red-faced black spider monkey').
ncbi_mult_taxo_gbnm(9511, 'spider monkey').
ncbi_mult_taxo_gbnm(9513, 'capuchin monkeys').
ncbi_mult_taxo_gbnm(9514, 'white-fronted capuchin').
ncbi_mult_taxo_gbnm(9515, 'tufted capuchin').
ncbi_mult_taxo_gbnm(9516, 'white-faced sapajou').
ncbi_mult_taxo_gbnm(9518, 'woolly monkeys').
ncbi_mult_taxo_gbnm(9519, 'brown woolly monkey').
ncbi_mult_taxo_gbnm(9520, 'squirrel monkeys').
ncbi_mult_taxo_gbnm(9521, 'common squirrel monkey').
ncbi_mult_taxo_gbnm(9522, 'titi monkeys').
ncbi_mult_taxo_gbnm(9523, 'red-bellied titi').
ncbi_mult_taxo_gbnm(9525, 'black-bearded saki').
ncbi_mult_taxo_gbnm(9527, 'Old World monkeys').
ncbi_mult_taxo_gbnm(9530, 'collared mangabey').
ncbi_mult_taxo_gbnm(9531, 'sooty mangabey').
ncbi_mult_taxo_gbnm(9532, 'Tana river mangabey').
ncbi_mult_taxo_gbnm(9534, grivet).
ncbi_mult_taxo_gbnm(9535, 'moustached guenon').
ncbi_mult_taxo_gbnm(9536, 'owl-faced monkey').
ncbi_mult_taxo_gbnm(9538, 'red guenon').
ncbi_mult_taxo_gbnm(9539, macaques).
ncbi_mult_taxo_gbnm(9540, 'stump-tailed macaque').
ncbi_mult_taxo_gbnm(9541, 'crab-eating macaque').
ncbi_mult_taxo_gbnm(9542, 'Japanese macaque').
ncbi_mult_taxo_gbnm(9543, 'Japanese macaque').
ncbi_mult_taxo_gbnm(9544, 'Rhesus monkey').
ncbi_mult_taxo_gbnm(9545, 'pig-tailed macaque').
ncbi_mult_taxo_gbnm(9546, 'Barbary ape').
ncbi_mult_taxo_gbnm(9548, 'bonnet macaque').
ncbi_mult_taxo_gbnm(9551, 'Assam macaque').
ncbi_mult_taxo_gbnm(9552, 'toque macaque').
ncbi_mult_taxo_gbnm(9554, baboons).
ncbi_mult_taxo_gbnm(9555, 'olive baboon').
ncbi_mult_taxo_gbnm(9556, 'Yellow baboon').
ncbi_mult_taxo_gbnm(9557, 'hamadryas baboon').
ncbi_mult_taxo_gbnm(9561, mandrill).
ncbi_mult_taxo_gbnm(9565, gelada).
ncbi_mult_taxo_gbnm(9567, 'forest baboons').
ncbi_mult_taxo_gbnm(9568, drill).
ncbi_mult_taxo_gbnm(9570, 'black-and-white colobus monkeys').
ncbi_mult_taxo_gbnm(9572, 'king colobus').
ncbi_mult_taxo_gbnm(9577, gibbons).
ncbi_mult_taxo_gbnm(9579, 'agile gibbon').
ncbi_mult_taxo_gbnm(9580, 'common gibbon').
ncbi_mult_taxo_gbnm(9581, gibbon).
ncbi_mult_taxo_gbnm(9586, 'southern white-cheeked gibbon').
ncbi_mult_taxo_gbnm(9587, 'Kloss\'s gibbon').
ncbi_mult_taxo_gbnm(9588, 'Mueller\'s Borneo gibbon').
ncbi_mult_taxo_gbnm(9589, 'pileated gibbon').
ncbi_mult_taxo_gbnm(9590, siamang).
ncbi_mult_taxo_gbnm(9593, 'western gorilla').
ncbi_mult_taxo_gbnm(9595, 'western lowland gorilla').
ncbi_mult_taxo_gbnm(9596, chimpanzees).
ncbi_mult_taxo_gbnm(9597, 'pygmy chimpanzee').
ncbi_mult_taxo_gbnm(9598, chimpanzee).
ncbi_mult_taxo_gbnm(9600, 'Bornean orangutan').
ncbi_mult_taxo_gbnm(9601, 'Sumatran orangutan').
ncbi_mult_taxo_gbnm(9602, 'Northwest Bornean orangutan').
ncbi_mult_taxo_gbnm(9604, 'great apes').
ncbi_mult_taxo_gbnm(9606, human).
ncbi_mult_taxo_gbnm(9608, 'dog, coyote, wolf, fox').
ncbi_mult_taxo_gbnm(9612, wolf).
ncbi_mult_taxo_gbnm(9614, coyote).
ncbi_mult_taxo_gbnm(9615, dog).
ncbi_mult_taxo_gbnm(9620, 'crab-eating fox').
ncbi_mult_taxo_gbnm(9622, 'African hunting dog').
ncbi_mult_taxo_gbnm(9624, 'bat-eared fox').
ncbi_mult_taxo_gbnm(9626, 'Cape fox').
ncbi_mult_taxo_gbnm(9627, 'red fox').
ncbi_mult_taxo_gbnm(9629, 'Corsac fox').
ncbi_mult_taxo_gbnm(9630, 'kit fox').
ncbi_mult_taxo_gbnm(9631, 'swift fox').
ncbi_mult_taxo_gbnm(9632, bears).
ncbi_mult_taxo_gbnm(9634, 'Malayan sun bear').
ncbi_mult_taxo_gbnm(9636, 'sloth bear').
ncbi_mult_taxo_gbnm(9638, 'spectacled bear').
ncbi_mult_taxo_gbnm(9641, bear).
ncbi_mult_taxo_gbnm(9642, 'Asiatic black bear').
ncbi_mult_taxo_gbnm(9643, 'American black bear').
ncbi_mult_taxo_gbnm(9644, 'brown bear').
ncbi_mult_taxo_gbnm(9646, 'giant panda').
ncbi_mult_taxo_gbnm(9647, 'raccoon, coati & olingo').
ncbi_mult_taxo_gbnm(9649, 'lesser panda').
ncbi_mult_taxo_gbnm(9651, 'ring-tailed coati').
ncbi_mult_taxo_gbnm(9652, 'ring-tailed coati').
ncbi_mult_taxo_gbnm(9654, raccoon).
ncbi_mult_taxo_gbnm(9655, 'weasel, mink, badger, martens and others').
ncbi_mult_taxo_gbnm(9657, 'Eurasian river otter').
ncbi_mult_taxo_gbnm(9659, 'beach marten').
ncbi_mult_taxo_gbnm(9660, 'American marten').
ncbi_mult_taxo_gbnm(9662, 'Eurasian badger').
ncbi_mult_taxo_gbnm(9664, ratel).
ncbi_mult_taxo_gbnm(9666, 'European mink').
ncbi_mult_taxo_gbnm(9668, 'European polecat').
ncbi_mult_taxo_gbnm(9669, 'domestic ferret').
ncbi_mult_taxo_gbnm(9672, 'giant otter').
ncbi_mult_taxo_gbnm(9673, civets).
ncbi_mult_taxo_gbnm(9675, 'masked palm civet').
ncbi_mult_taxo_gbnm(9676, hyaenas).
ncbi_mult_taxo_gbnm(9678, 'spotted hyena').
ncbi_mult_taxo_gbnm(9680, aardwolf).
ncbi_mult_taxo_gbnm(9681, 'cat family').
ncbi_mult_taxo_gbnm(9683, 'wild cat').
ncbi_mult_taxo_gbnm(9685, 'domestic cat').
ncbi_mult_taxo_gbnm(9689, lion).
ncbi_mult_taxo_gbnm(9690, jaguar).
ncbi_mult_taxo_gbnm(9691, leopard).
ncbi_mult_taxo_gbnm(9692, 'Amur leopard').
ncbi_mult_taxo_gbnm(9693, 'northern Persian leopard').
ncbi_mult_taxo_gbnm(9694, tiger).
ncbi_mult_taxo_gbnm(9695, 'Sumatran tiger').
ncbi_mult_taxo_gbnm(9696, puma).
ncbi_mult_taxo_gbnm(9697, mongooses).
ncbi_mult_taxo_gbnm(9700, 'Egyptian mongoose').
ncbi_mult_taxo_gbnm(9702, 'fur seals & sea lions').
ncbi_mult_taxo_gbnm(9704, 'California sea lion').
ncbi_mult_taxo_gbnm(9705, walruses).
ncbi_mult_taxo_gbnm(9707, walrus).
ncbi_mult_taxo_gbnm(9708, 'Pacific walrus').
ncbi_mult_taxo_gbnm(9709, 'true seals').
ncbi_mult_taxo_gbnm(9711, 'gray seal').
ncbi_mult_taxo_gbnm(9713, 'Weddell seal').
ncbi_mult_taxo_gbnm(9714, 'elephant seals').
ncbi_mult_taxo_gbnm(9715, 'Southern elephant seal').
ncbi_mult_taxo_gbnm(9716, 'Northern elephant seal').
ncbi_mult_taxo_gbnm(9718, 'ringed seal').
ncbi_mult_taxo_gbnm(9719, 'Baikal seal').
ncbi_mult_taxo_gbnm(9720, 'harbor seal').
ncbi_mult_taxo_gbnm(9721, 'whales & dolphins').
ncbi_mult_taxo_gbnm(9722, 'tooth whales').
ncbi_mult_taxo_gbnm(9723, 'freshwater dolphins').
ncbi_mult_taxo_gbnm(9725, boutu).
ncbi_mult_taxo_gbnm(9726, 'marine dolphins').
ncbi_mult_taxo_gbnm(9728, 'saddleback dolphin').
ncbi_mult_taxo_gbnm(9729, 'pilot whales').
ncbi_mult_taxo_gbnm(9731, 'long-finned pilot whale').
ncbi_mult_taxo_gbnm(9733, 'killer whale').
ncbi_mult_taxo_gbnm(9735, 'bridled dolphin').
ncbi_mult_taxo_gbnm(9736, 'spinner dolphin').
ncbi_mult_taxo_gbnm(9737, 'striped dolphin').
ncbi_mult_taxo_gbnm(9739, 'common bottlenose dolphin').
ncbi_mult_taxo_gbnm(9740, porpoises).
ncbi_mult_taxo_gbnm(9742, 'harbor porpoise').
ncbi_mult_taxo_gbnm(9744, 'Dall\'s porpoise').
ncbi_mult_taxo_gbnm(9749, 'beluga whale').
ncbi_mult_taxo_gbnm(9750, 'sperm whales').
ncbi_mult_taxo_gbnm(9752, 'dwarf sperm whale').
ncbi_mult_taxo_gbnm(9755, 'sperm whale').
ncbi_mult_taxo_gbnm(9756, 'beaked whales').
ncbi_mult_taxo_gbnm(9758, 'Hubbs\' beaked whale').
ncbi_mult_taxo_gbnm(9760, 'Cuvier\'s beaked whale').
ncbi_mult_taxo_gbnm(9761, 'baleen whales').
ncbi_mult_taxo_gbnm(9764, 'grey whale').
ncbi_mult_taxo_gbnm(9765, rorquals).
ncbi_mult_taxo_gbnm(9767, 'minke whale').
ncbi_mult_taxo_gbnm(9768, 'sei whale').
ncbi_mult_taxo_gbnm(9769, 'pygmy Bryde\'s whale').
ncbi_mult_taxo_gbnm(9770, 'Fin whale').
ncbi_mult_taxo_gbnm(9771, 'blue whale').
ncbi_mult_taxo_gbnm(9773, 'humpback whale').
ncbi_mult_taxo_gbnm(9774, 'manatees and dugongs (seacows)').
ncbi_mult_taxo_gbnm(9775, manatees).
ncbi_mult_taxo_gbnm(9777, 'Amazon manatee').
ncbi_mult_taxo_gbnm(9778, 'West Indian manatee').
ncbi_mult_taxo_gbnm(9779, elephants).
ncbi_mult_taxo_gbnm(9780, elephants).
ncbi_mult_taxo_gbnm(9783, 'Asiatic elephant').
ncbi_mult_taxo_gbnm(9785, 'African savanna elephant').
ncbi_mult_taxo_gbnm(9786, 'pale devil\'s-claw').
ncbi_mult_taxo_gbnm(9787, 'odd-toed ungulates').
ncbi_mult_taxo_gbnm(9788, horses).
ncbi_mult_taxo_gbnm(9791, 'mountain zebra').
ncbi_mult_taxo_gbnm(9792, 'Grevy\'s zebra').
ncbi_mult_taxo_gbnm(9793, donkey).
ncbi_mult_taxo_gbnm(9794, onager).
ncbi_mult_taxo_gbnm(9796, horse).
ncbi_mult_taxo_gbnm(9798, 'Przewalski\'s horse').
ncbi_mult_taxo_gbnm(9799, tapirs).
ncbi_mult_taxo_gbnm(9801, 'Brazilian tapir').
ncbi_mult_taxo_gbnm(9802, 'Asiatic tapir').
ncbi_mult_taxo_gbnm(9803, rhinoceroses).
ncbi_mult_taxo_gbnm(9805, 'black rhinoceros').
ncbi_mult_taxo_gbnm(9807, 'white rhinoceros').
ncbi_mult_taxo_gbnm(9809, 'greater Indian rhinoceros').
ncbi_mult_taxo_gbnm(9810, 'rock rabbits/dassies').
ncbi_mult_taxo_gbnm(9811, hyraxes).
ncbi_mult_taxo_gbnm(9813, 'Cape rock hyrax').
ncbi_mult_taxo_gbnm(9814, 'Abyssinian hyrax').
ncbi_mult_taxo_gbnm(9815, aardvarks).
ncbi_mult_taxo_gbnm(9816, aardvark).
ncbi_mult_taxo_gbnm(9818, aardvark).
ncbi_mult_taxo_gbnm(9821, pigs).
ncbi_mult_taxo_gbnm(9823, pig).
ncbi_mult_taxo_gbnm(9825, 'domestic pig').
ncbi_mult_taxo_gbnm(9827, peccaries).
ncbi_mult_taxo_gbnm(9829, 'collared peccary').
ncbi_mult_taxo_gbnm(9833, hippopotamus).
ncbi_mult_taxo_gbnm(9837, 'Bactrian camel').
ncbi_mult_taxo_gbnm(9838, 'Arabian camel').
ncbi_mult_taxo_gbnm(9840, guanaco).
ncbi_mult_taxo_gbnm(9843, vicugna).
ncbi_mult_taxo_gbnm(9844, llama).
ncbi_mult_taxo_gbnm(9846, chevrotains).
ncbi_mult_taxo_gbnm(9848, 'Balabac chevrotain').
ncbi_mult_taxo_gbnm(9849, 'Java mouse-deer').
ncbi_mult_taxo_gbnm(9850, deer).
ncbi_mult_taxo_gbnm(9852, 'Eurasian elk').
ncbi_mult_taxo_gbnm(9853, 'European elk').
ncbi_mult_taxo_gbnm(9858, 'Western roe deer').
ncbi_mult_taxo_gbnm(9860, 'red deer').
ncbi_mult_taxo_gbnm(9861, 'Eastern wapiti').
ncbi_mult_taxo_gbnm(9863, 'sika deer').
ncbi_mult_taxo_gbnm(9864, 'American elk').
ncbi_mult_taxo_gbnm(9865, 'Manchurian Wapiti').
ncbi_mult_taxo_gbnm(9870, reindeer).
ncbi_mult_taxo_gbnm(9872, 'mule deer').
ncbi_mult_taxo_gbnm(9873, 'black-tailed deer').
ncbi_mult_taxo_gbnm(9874, 'white-tailed deer').
ncbi_mult_taxo_gbnm(9875, 'Virginia white-tailed deer').
ncbi_mult_taxo_gbnm(9883, 'Chinese water deer').
ncbi_mult_taxo_gbnm(9886, 'Reeves\' muntjac').
ncbi_mult_taxo_gbnm(9888, muntjak).
ncbi_mult_taxo_gbnm(9891, pronghorn).
ncbi_mult_taxo_gbnm(9894, giraffe).
ncbi_mult_taxo_gbnm(9897, impala).
ncbi_mult_taxo_gbnm(9899, aoudad).
ncbi_mult_taxo_gbnm(9901, 'American bison').
ncbi_mult_taxo_gbnm(9902, 'European bison').
ncbi_mult_taxo_gbnm(9903, cattle).
ncbi_mult_taxo_gbnm(9904, gaur).
ncbi_mult_taxo_gbnm(9906, banteng).
ncbi_mult_taxo_gbnm(9909, aurochs).
ncbi_mult_taxo_gbnm(9913, 'domestic cattle').
ncbi_mult_taxo_gbnm(9915, 'zebu cattle').
ncbi_mult_taxo_gbnm(9917, nilgai).
ncbi_mult_taxo_gbnm(9923, 'wild goat').
ncbi_mult_taxo_gbnm(9925, goat).
ncbi_mult_taxo_gbnm(9927, 'brindled gnu').
ncbi_mult_taxo_gbnm(9929, topi).
ncbi_mult_taxo_gbnm(9930, 'korrigum sassaby').
ncbi_mult_taxo_gbnm(9933, gazelles).
ncbi_mult_taxo_gbnm(9938, mouflon).
ncbi_mult_taxo_gbnm(9940, sheep).
ncbi_mult_taxo_gbnm(9943, 'Dall sheep').
ncbi_mult_taxo_gbnm(9945, eland).
ncbi_mult_taxo_gbnm(9946, 'greater kudu').
ncbi_mult_taxo_gbnm(9947, 'lesser kudu').
ncbi_mult_taxo_gbnm(9958, gemsbok).
ncbi_mult_taxo_gbnm(9962, waterbuck).
ncbi_mult_taxo_gbnm(9966, 'Japanese serow').
ncbi_mult_taxo_gbnm(9970, 'African buffalo').
ncbi_mult_taxo_gbnm(9971, pangolins).
ncbi_mult_taxo_gbnm(9972, pangolins).
ncbi_mult_taxo_gbnm(9974, 'Malayan pangolin').
ncbi_mult_taxo_gbnm(9976, pikas).
ncbi_mult_taxo_gbnm(9978, 'American pika').
ncbi_mult_taxo_gbnm(9979, 'rabbits and hares').
ncbi_mult_taxo_gbnm(9980, hares).
ncbi_mult_taxo_gbnm(9981, 'brown hare').
ncbi_mult_taxo_gbnm(9983, 'European hare').
ncbi_mult_taxo_gbnm(9986, rabbit).
ncbi_mult_taxo_gbnm(9988, 'eastern cottontail').
ncbi_mult_taxo_gbnm(9989, rodents).
ncbi_mult_taxo_gbnm(9993, 'European marmot').
ncbi_mult_taxo_gbnm(9994, 'Alpine marmot').
ncbi_mult_taxo_gbnm(9995, woodchuck).
ncbi_mult_taxo_gbnm(9996, 'old world ground squirrels').
ncbi_mult_taxo_gbnm(9997, 'European suslik').
ncbi_mult_taxo_gbnm(9999, 'Arctic ground squirrel').
ncbi_mult_taxo_gbnm(10006, 'Kaibab squirrel').
ncbi_mult_taxo_gbnm(10007, 'tassel-eared squirrel').
ncbi_mult_taxo_gbnm(10009, 'American red squirrel').
ncbi_mult_taxo_gbnm(10010, 'pocket gophers').
ncbi_mult_taxo_gbnm(10012, 'western pocket gopher').
ncbi_mult_taxo_gbnm(10013, 'Botta\'s pocket gopher').
ncbi_mult_taxo_gbnm(10016, 'kangaroo rats').
ncbi_mult_taxo_gbnm(10017, 'California kangaroo rat').
ncbi_mult_taxo_gbnm(10018, 'Heermann\'s kangaroo rat').
ncbi_mult_taxo_gbnm(10019, 'Panamint kangaroo rat').
ncbi_mult_taxo_gbnm(10020, 'Ord\'s kangaroo rat').
ncbi_mult_taxo_gbnm(10021, springhares).
ncbi_mult_taxo_gbnm(10023, springhare).
ncbi_mult_taxo_gbnm(10026, hamsters).
ncbi_mult_taxo_gbnm(10029, 'Chinese hamster').
ncbi_mult_taxo_gbnm(10030, 'long-tailed hamster').
ncbi_mult_taxo_gbnm(10034, 'black-bellied hamster').
ncbi_mult_taxo_gbnm(10036, 'golden hamster').
ncbi_mult_taxo_gbnm(10037, 'Turkish hamster').
ncbi_mult_taxo_gbnm(10041, 'white-footed mouse').
ncbi_mult_taxo_gbnm(10042, 'North American deer mouse').
ncbi_mult_taxo_gbnm(10044, 'winter white dwarf hamster').
ncbi_mult_taxo_gbnm(10045, gerbils).
ncbi_mult_taxo_gbnm(10046, jirds).
ncbi_mult_taxo_gbnm(10047, 'Mongolian gerbil').
ncbi_mult_taxo_gbnm(10053, 'meadow voles').
ncbi_mult_taxo_gbnm(10054, 'yellow-cheeked vole').
ncbi_mult_taxo_gbnm(10055, 'rock vole').
ncbi_mult_taxo_gbnm(10058, 'meadow vole').
ncbi_mult_taxo_gbnm(10060, muskrat).
ncbi_mult_taxo_gbnm(10061, 'blind mole-rats').
ncbi_mult_taxo_gbnm(10067, 'spiny mice').
ncbi_mult_taxo_gbnm(10068, 'Egyptian spiny mouse').
ncbi_mult_taxo_gbnm(10070, 'highland grass mouse').
ncbi_mult_taxo_gbnm(10072, 'Bolivian grass mouse').
ncbi_mult_taxo_gbnm(10073, 'Junin grass mouse').
ncbi_mult_taxo_gbnm(10074, 'Koford\'s grass mouse').
ncbi_mult_taxo_gbnm(10075, 'soft grass mouse').
ncbi_mult_taxo_gbnm(10076, 'altiplano grass mouse').
ncbi_mult_taxo_gbnm(10077, 'Puno grass mouse').
ncbi_mult_taxo_gbnm(10078, 'cloud forest grass mouse').
ncbi_mult_taxo_gbnm(10081, 'pleasant bolo mouse').
ncbi_mult_taxo_gbnm(10085, 'Gambian giant pouched rat').
ncbi_mult_taxo_gbnm(10087, 'Thespian grass mouse').
ncbi_mult_taxo_gbnm(10088, mice).
ncbi_mult_taxo_gbnm(10089, 'Ryukyu mouse').
ncbi_mult_taxo_gbnm(10090, 'house mouse').
ncbi_mult_taxo_gbnm(10091, 'southeastern Asian house mouse').
ncbi_mult_taxo_gbnm(10092, 'western European house mouse').
ncbi_mult_taxo_gbnm(10093, 'shrew mouse').
ncbi_mult_taxo_gbnm(10094, 'spiny mouse').
ncbi_mult_taxo_gbnm(10096, 'western wild mouse').
ncbi_mult_taxo_gbnm(10097, 'fawn-colored mouse').
ncbi_mult_taxo_gbnm(10098, 'Cook\'s mouse').
ncbi_mult_taxo_gbnm(10100, 'Macedonian mouse').
ncbi_mult_taxo_gbnm(10101, 'flat-haired mouse').
ncbi_mult_taxo_gbnm(10102, 'Peter\'s mouse').
ncbi_mult_taxo_gbnm(10103, 'steppe mouse').
ncbi_mult_taxo_gbnm(10105, 'Southern African pygmy mouse').
ncbi_mult_taxo_gbnm(10108, 'Abbott\'s mouse').
ncbi_mult_taxo_gbnm(10111, 'African soft-furred rats').
ncbi_mult_taxo_gbnm(10112, 'African soft-furred rat').
ncbi_mult_taxo_gbnm(10113, 'Dalton\'s Praomys').
ncbi_mult_taxo_gbnm(10114, rats).
ncbi_mult_taxo_gbnm(10115, 'mottle-tailed rat').
ncbi_mult_taxo_gbnm(10116, 'Norway rat').
ncbi_mult_taxo_gbnm(10117, 'black rat').
ncbi_mult_taxo_gbnm(10119, 'bush rat').
ncbi_mult_taxo_gbnm(10120, 'Australian dusky field rat').
ncbi_mult_taxo_gbnm(10121, 'Tunney\'s rat').
ncbi_mult_taxo_gbnm(10122, 'long-haired rat').
ncbi_mult_taxo_gbnm(10127, 'brush-tailed rabbit-rat').
ncbi_mult_taxo_gbnm(10129, 'European woodmouse').
ncbi_mult_taxo_gbnm(10132, 'mouse-like hamsters').
ncbi_mult_taxo_gbnm(10133, 'mouse-like hamster').
ncbi_mult_taxo_gbnm(10135, 'Old World porcupines').
ncbi_mult_taxo_gbnm(10137, 'crested porcupine').
ncbi_mult_taxo_gbnm(10138, 'Cape porcupine').
ncbi_mult_taxo_gbnm(10139, cavies).
ncbi_mult_taxo_gbnm(10140, 'guinea pigs').
ncbi_mult_taxo_gbnm(10141, 'domestic guinea pig').
ncbi_mult_taxo_gbnm(10146, cuis).
ncbi_mult_taxo_gbnm(10149, capybara).
ncbi_mult_taxo_gbnm(10150, chinchillas).
ncbi_mult_taxo_gbnm(10152, 'short-tailed chinchilla').
ncbi_mult_taxo_gbnm(10154, 'plains viscacha').
ncbi_mult_taxo_gbnm(10157, nutria).
ncbi_mult_taxo_gbnm(10160, degu).
ncbi_mult_taxo_gbnm(10161, 'American spiny rats').
ncbi_mult_taxo_gbnm(10163, casiragua).
ncbi_mult_taxo_gbnm(10164, gundis).
ncbi_mult_taxo_gbnm(10166, 'northern gundi').
ncbi_mult_taxo_gbnm(10167, 'African mole-rats').
ncbi_mult_taxo_gbnm(10169, 'Greater cane rat').
ncbi_mult_taxo_gbnm(10171, 'Namaqua dune mole-rat').
ncbi_mult_taxo_gbnm(10172, 'Cape dune mole-rat').
ncbi_mult_taxo_gbnm(10175, 'Hottentot mole-rat').
ncbi_mult_taxo_gbnm(10177, 'Cape mole-rat').
ncbi_mult_taxo_gbnm(10179, 'silvery mole-rat').
ncbi_mult_taxo_gbnm(10181, 'naked mole-rat').
ncbi_mult_taxo_gbnm(10183, 'dassie-rat').
ncbi_mult_taxo_gbnm(10185, 'Eurasian beaver').
ncbi_mult_taxo_gbnm(10186, 'northern pygmy gerbils').
ncbi_mult_taxo_gbnm(10190, rotifers).
ncbi_mult_taxo_gbnm(10197, 'comb jellies').
ncbi_mult_taxo_gbnm(10205, bryozoans).
ncbi_mult_taxo_gbnm(10219, hemichordates).
ncbi_mult_taxo_gbnm(10220, 'acorn worms').
ncbi_mult_taxo_gbnm(10226, placozoans).
ncbi_mult_taxo_gbnm(10229, 'arrow worms').
ncbi_mult_taxo_gbnm(10232, 'thorny-headed worms').
ncbi_mult_taxo_gbnm(10298, 'Herpes simplex virus type 1').
ncbi_mult_taxo_gbnm(10326, 'Equine herpesvirus 1').
ncbi_mult_taxo_gbnm(10331, 'Equine herpesvirus 4').
ncbi_mult_taxo_gbnm(10335, 'Varicella-zoster virus').
ncbi_mult_taxo_gbnm(10366, 'Murine cytomegalovirus').
ncbi_mult_taxo_gbnm(10374, 'lymphoproliferative virus group').
ncbi_mult_taxo_gbnm(10376, 'Epstein-Barr virus').
ncbi_mult_taxo_gbnm(10377, 'Epstein-Barr virus (strain B95-8)').
ncbi_mult_taxo_gbnm(10378, 'Epstein-Barr virus (strain RAJI)').
ncbi_mult_taxo_gbnm(10380, 'Herpesvirus ateles').
ncbi_mult_taxo_gbnm(10381, 'Herpesvirus saimiri').
ncbi_mult_taxo_gbnm(10401, 'Channel catfish virus').
ncbi_mult_taxo_gbnm(10404, 'hepatitis B-type viruses').
ncbi_mult_taxo_gbnm(10405, 'mammalian hepatitis B-type viruses').
ncbi_mult_taxo_gbnm(10437, 'avian hepatitis B-type viruses').
ncbi_mult_taxo_gbnm(10487, 'small iridescent insect viruses').
ncbi_mult_taxo_gbnm(10841, 'isometric ssDNA phages').
ncbi_mult_taxo_gbnm(10981, 'cytoplasmic polyhedrosis viruses').
ncbi_mult_taxo_gbnm(10985, 'plant reovirus 1').
ncbi_mult_taxo_gbnm(10988, 'plant reovirus 2').
ncbi_mult_taxo_gbnm(10995, 'Gumboro virus').
ncbi_mult_taxo_gbnm(11006, 'monopartite dsRNA genome mycoviruses').
ncbi_mult_taxo_gbnm(11019, 'arboviruses group A').
ncbi_mult_taxo_gbnm(11051, 'arboviruses group B').
ncbi_mult_taxo_gbnm(11157, 'negative-sense genome single-stranded RNA viruses').
ncbi_mult_taxo_gbnm(12305, 'cucumber mosaic cucumovirus').
ncbi_mult_taxo_gbnm(12509, 'Epstein-Barr virus type 2').
ncbi_mult_taxo_gbnm(12657, 'Equine herpesvirus 2').
ncbi_mult_taxo_gbnm(12913, 'brown surgeonfish').
ncbi_mult_taxo_gbnm(12921, 'spangled skimmer').
ncbi_mult_taxo_gbnm(12930, 'blue-fronted amazon').
ncbi_mult_taxo_gbnm(12946, 'red-masked parakeet').
ncbi_mult_taxo_gbnm(12956, 'leaf cutting ants').
ncbi_mult_taxo_gbnm(12964, 'deepwater dragon').
ncbi_mult_taxo_gbnm(12983, 'Tanimbar cockatoo').
ncbi_mult_taxo_gbnm(12985, 'almond moth').
ncbi_mult_taxo_gbnm(12990, 'European hornbeam').
ncbi_mult_taxo_gbnm(12991, 'American hornbeam').
ncbi_mult_taxo_gbnm(12992, 'upside-down jellyfish').
ncbi_mult_taxo_gbnm(13013, 'North African catfish').
ncbi_mult_taxo_gbnm(13025, 'pecan weevil').
ncbi_mult_taxo_gbnm(13029, 'spotted seatrout').
ncbi_mult_taxo_gbnm(13037, 'monarch butterfly').
ncbi_mult_taxo_gbnm(13040, 'Diaprepes root weevil').
ncbi_mult_taxo_gbnm(13047, burheads).
ncbi_mult_taxo_gbnm(13048, 'Texas mudbaby').
ncbi_mult_taxo_gbnm(13068, 'European earwig').
ncbi_mult_taxo_gbnm(13074, 'redhump eartheater').
ncbi_mult_taxo_gbnm(13085, 'prickly gecko').
ncbi_mult_taxo_gbnm(13090, 'plantain lilies').
ncbi_mult_taxo_gbnm(13091, 'Japanese plantain lily').
ncbi_mult_taxo_gbnm(13095, 'silver carp').
ncbi_mult_taxo_gbnm(13098, 'Florida anisetree').
ncbi_mult_taxo_gbnm(13100, junipers).
ncbi_mult_taxo_gbnm(13101, 'Ozark white cedar').
ncbi_mult_taxo_gbnm(13102, 'shore juniper').
ncbi_mult_taxo_gbnm(13106, bluegill).
ncbi_mult_taxo_gbnm(13114, 'chattering lory').
ncbi_mult_taxo_gbnm(13122, 'gypsy moths').
ncbi_mult_taxo_gbnm(13123, 'gypsy moth').
ncbi_mult_taxo_gbnm(13125, 'Eurasian lynx').
ncbi_mult_taxo_gbnm(13131, 'potato aphid').
ncbi_mult_taxo_gbnm(13139, 'giant northern termite').
ncbi_mult_taxo_gbnm(13142, 'sumac gall aphid').
ncbi_mult_taxo_gbnm(13146, budgerigar).
ncbi_mult_taxo_gbnm(13151, 'European harvest mouse').
ncbi_mult_taxo_gbnm(13164, 'green peach aphid').
ncbi_mult_taxo_gbnm(13165, naiads).
ncbi_mult_taxo_gbnm(13180, cockatiel).
ncbi_mult_taxo_gbnm(13191, 'pink bollworm').
ncbi_mult_taxo_gbnm(13196, 'radiator plants').
ncbi_mult_taxo_gbnm(13214, 'blue-headed parrot').
ncbi_mult_taxo_gbnm(13225, 'sand goby').
ncbi_mult_taxo_gbnm(13228, pondweeds).
ncbi_mult_taxo_gbnm(13232, 'glasshouse mealybug').
ncbi_mult_taxo_gbnm(13233, 'long-tailed mealybug').
ncbi_mult_taxo_gbnm(13234, 'American grape mealybug').
ncbi_mult_taxo_gbnm(13245, 'golden-crowned kinglet').
ncbi_mult_taxo_gbnm(13253, palmettos).
ncbi_mult_taxo_gbnm(13260, 'lizard\'s tail').
ncbi_mult_taxo_gbnm(13262, greenbug).
ncbi_mult_taxo_gbnm(13266, 'saber-toothed cat').
ncbi_mult_taxo_gbnm(13268, 'Atlantic awning clam').
ncbi_mult_taxo_gbnm(13279, 'estuarine stonefish').
ncbi_mult_taxo_gbnm(13281, 'sharp-nosed tomb bat').
ncbi_mult_taxo_gbnm(13290, 'wheat bunt fungus').
ncbi_mult_taxo_gbnm(13291, 'dwarf bunt fungus').
ncbi_mult_taxo_gbnm(13323, wahoo).
ncbi_mult_taxo_gbnm(13331, 'five-leaf akebia').
ncbi_mult_taxo_gbnm(13337, soursop).
ncbi_mult_taxo_gbnm(13339, 'hemp dogbane').
ncbi_mult_taxo_gbnm(13341, 'devil\'s walking stick').
ncbi_mult_taxo_gbnm(13347, 'common pillbug').
ncbi_mult_taxo_gbnm(13353, 'frigate tuna').
ncbi_mult_taxo_gbnm(13379, 'China aster').
ncbi_mult_taxo_gbnm(13380, 'water starwort').
ncbi_mult_taxo_gbnm(13385, 'heather flower').
ncbi_mult_taxo_gbnm(13390, 'carpenter ants').
ncbi_mult_taxo_gbnm(13397, 'great white shark').
ncbi_mult_taxo_gbnm(13403, 'pignut hickory').
ncbi_mult_taxo_gbnm(13405, 'western moss heather').
ncbi_mult_taxo_gbnm(13411, 'Florida rosemary').
ncbi_mult_taxo_gbnm(13427, chicory).
ncbi_mult_taxo_gbnm(13429, 'camphor tree').
ncbi_mult_taxo_gbnm(13435, 'coastal sweetpepperbush').
ncbi_mult_taxo_gbnm(13443, coffee).
ncbi_mult_taxo_gbnm(13447, 'poison hemlock').
ncbi_mult_taxo_gbnm(13456, 'yellow-nosed pocket gopher').
ncbi_mult_taxo_gbnm(13458, 'smoky pocket gopher').
ncbi_mult_taxo_gbnm(13461, 'Llano pocket gopher').
ncbi_mult_taxo_gbnm(13462, 'Merriam\'s pocket gopher').
ncbi_mult_taxo_gbnm(13463, 'naked-nosed pocket gopher').
ncbi_mult_taxo_gbnm(13477, 'spotfin shiner').
ncbi_mult_taxo_gbnm(13489, 'European seabass').
ncbi_mult_taxo_gbnm(13493, 'American persimmon').
ncbi_mult_taxo_gbnm(13514, 'crowned lemur').
ncbi_mult_taxo_gbnm(13515, 'brown lemur').
ncbi_mult_taxo_gbnm(13537, 'butterfly kingfish').
ncbi_mult_taxo_gbnm(13543, 'snake mackerel').
ncbi_mult_taxo_gbnm(13555, 'Indian leech').
ncbi_mult_taxo_gbnm(13557, 'bamboo lemur').
ncbi_mult_taxo_gbnm(13574, sailfishes).
ncbi_mult_taxo_gbnm(13575, 'Indo-Pacific sailfish').
ncbi_mult_taxo_gbnm(13577, 'imperial hairstreak').
ncbi_mult_taxo_gbnm(13578, rushes).
ncbi_mult_taxo_gbnm(13587, escolar).
ncbi_mult_taxo_gbnm(13593, 'king cricket').
ncbi_mult_taxo_gbnm(13596, privets).
ncbi_mult_taxo_gbnm(13597, 'common privet').
ncbi_mult_taxo_gbnm(13602, marlins).
ncbi_mult_taxo_gbnm(13603, 'black marlin').
ncbi_mult_taxo_gbnm(13604, 'Atlantic blue marlin').
ncbi_mult_taxo_gbnm(13615, 'short-tailed opossums').
ncbi_mult_taxo_gbnm(13616, 'gray short-tailed opossum').
ncbi_mult_taxo_gbnm(13618, 'Australian jumper ant').
ncbi_mult_taxo_gbnm(13622, 'American hop-hornbeam').
ncbi_mult_taxo_gbnm(13625, peonies).
ncbi_mult_taxo_gbnm(13628, 'Buller\'s pocket gopher').
ncbi_mult_taxo_gbnm(13632, 'common green bottle fly').
ncbi_mult_taxo_gbnm(13634, 'Japanese buff-tip moth').
ncbi_mult_taxo_gbnm(13639, 'Jacob\'s ladders').
ncbi_mult_taxo_gbnm(13656, 'corky root of lettuce').
ncbi_mult_taxo_gbnm(13662, oilfish).
ncbi_mult_taxo_gbnm(13665, snakeroots).
ncbi_mult_taxo_gbnm(13667, 'bowstring hemps').
ncbi_mult_taxo_gbnm(13676, 'chub mackerel').
ncbi_mult_taxo_gbnm(13677, 'Atlantic mackerel').
ncbi_mult_taxo_gbnm(13679, 'king mackerel').
ncbi_mult_taxo_gbnm(13686, 'red fire ant').
ncbi_mult_taxo_gbnm(13692, 'European barracuda').
ncbi_mult_taxo_gbnm(13698, 'gray hairstreak').
ncbi_mult_taxo_gbnm(13707, marigolds).
ncbi_mult_taxo_gbnm(13708, 'African marigold').
ncbi_mult_taxo_gbnm(13718, spearfishes).
ncbi_mult_taxo_gbnm(13719, 'Atlantic white marlin').
ncbi_mult_taxo_gbnm(13720, 'shortbill spearfish').
ncbi_mult_taxo_gbnm(13721, 'striped marlin').
ncbi_mult_taxo_gbnm(13722, 'Mediterranean spearfish').
ncbi_mult_taxo_gbnm(13723, 'longbill spearfish').
ncbi_mult_taxo_gbnm(13731, salsify).
ncbi_mult_taxo_gbnm(13733, 'Atlantic cutlassfish').
ncbi_mult_taxo_gbnm(13735, 'Chinese soft-shelled turtle').
ncbi_mult_taxo_gbnm(13745, murres).
ncbi_mult_taxo_gbnm(13746, 'common murre').
ncbi_mult_taxo_gbnm(13750, 'large cranberry').
ncbi_mult_taxo_gbnm(13758, 'common blue violet').
ncbi_mult_taxo_gbnm(13764, 'rosy razorfish').
ncbi_mult_taxo_gbnm(13765, 'pearly razorfish').
ncbi_mult_taxo_gbnm(13766, 'green razorfish').
ncbi_mult_taxo_gbnm(13809, hornworts).
ncbi_mult_taxo_gbnm(13815, 'water clovers').
ncbi_mult_taxo_gbnm(13816, 'European water clover').
ncbi_mult_taxo_gbnm(13821, 'Chinese brake').
ncbi_mult_taxo_gbnm(13833, 'adder\'s-tongue ferns').
ncbi_mult_taxo_gbnm(13834, 'limestone adder\'s-tongue').
ncbi_mult_taxo_gbnm(13836, quillworts).
ncbi_mult_taxo_gbnm(13894, 'coconut palm').
ncbi_mult_taxo_gbnm(14026, 'fan palms').
ncbi_mult_taxo_gbnm(14027, 'windmill palm').
ncbi_mult_taxo_gbnm(15008, wapato).
ncbi_mult_taxo_gbnm(15297, 'bent grasses').
ncbi_mult_taxo_gbnm(15367, 'false bromes').
ncbi_mult_taxo_gbnm(15368, 'stiff brome').
ncbi_mult_taxo_gbnm(15369, 'quaking grass').
ncbi_mult_taxo_gbnm(15371, 'smooth brome grass').
ncbi_mult_taxo_gbnm(15452, 'hair grass').
ncbi_mult_taxo_gbnm(15492, 'wild rye').
ncbi_mult_taxo_gbnm(15945, 'Guatemalan teosinte').
ncbi_mult_taxo_gbnm(15949, 'wild rice').
ncbi_mult_taxo_gbnm(15957, 'timothy grass').
ncbi_mult_taxo_gbnm(15970, 'bear grasses').
ncbi_mult_taxo_gbnm(16195, 'Solomon\'s seals').
ncbi_mult_taxo_gbnm(16237, 'twisted stalks').
ncbi_mult_taxo_gbnm(16362, 'pondweed family').
ncbi_mult_taxo_gbnm(16481, 'beach naupaka').
ncbi_mult_taxo_gbnm(16718, walnuts).
ncbi_mult_taxo_gbnm(16719, 'black walnut').
ncbi_mult_taxo_gbnm(16752, 'chameleon-plant').
ncbi_mult_taxo_gbnm(16902, 'alternate-leaved dogwood').
ncbi_mult_taxo_gbnm(16925, 'ogeechee lime').
ncbi_mult_taxo_gbnm(18184, spikeweeds).
ncbi_mult_taxo_gbnm(18795, 'cape-ivy').
ncbi_mult_taxo_gbnm(19027, silverpuffs).
ncbi_mult_taxo_gbnm(19953, 'common valerian').
ncbi_mult_taxo_gbnm(20340, carob).
ncbi_mult_taxo_gbnm(21020, 'European chestnut').
ncbi_mult_taxo_gbnm(21024, 'beech trees').
ncbi_mult_taxo_gbnm(21496, gentian).
ncbi_mult_taxo_gbnm(21880, sages).
ncbi_mult_taxo_gbnm(21896, germanders).
ncbi_mult_taxo_gbnm(22002, vervains).
ncbi_mult_taxo_gbnm(22531, 'gum myrtles').
ncbi_mult_taxo_gbnm(22663, pomegranate).
ncbi_mult_taxo_gbnm(22774, barberries).
ncbi_mult_taxo_gbnm(23013, 'devil\'s backbone').
ncbi_mult_taxo_gbnm(23159, hawthorn).
ncbi_mult_taxo_gbnm(23199, chokeberry).
ncbi_mult_taxo_gbnm(23206, 'hollyleaf cherry').
ncbi_mult_taxo_gbnm(23207, 'black cherry').
ncbi_mult_taxo_gbnm(23211, pear).
ncbi_mult_taxo_gbnm(23216, bramble).
ncbi_mult_taxo_gbnm(23222, 'mountain ashes').
ncbi_mult_taxo_gbnm(23224, 'bridal-wreaths').
ncbi_mult_taxo_gbnm(23283, 'golden currant').
ncbi_mult_taxo_gbnm(24208, lilacs).
ncbi_mult_taxo_gbnm(24736, 'winged elm').
ncbi_mult_taxo_gbnm(24952, 'water milfoils').
ncbi_mult_taxo_gbnm(24962, 'Australian chestnut').
ncbi_mult_taxo_gbnm(25385, 'Egyptian star cluster').
ncbi_mult_taxo_gbnm(25608, 'China firs').
ncbi_mult_taxo_gbnm(25629, 'English yew').
ncbi_mult_taxo_gbnm(27417, 'rodent fleas').
ncbi_mult_taxo_gbnm(27420, scorpionflies).
ncbi_mult_taxo_gbnm(27422, 'hanging flies').
ncbi_mult_taxo_gbnm(27427, 'ant lions').
ncbi_mult_taxo_gbnm(27434, earwigs).
ncbi_mult_taxo_gbnm(27437, 'common earwigs').
ncbi_mult_taxo_gbnm(27439, 'leaf beetles').
ncbi_mult_taxo_gbnm(27448, 'lesser mealworm').
ncbi_mult_taxo_gbnm(27449, 'dark mealworm').
ncbi_mult_taxo_gbnm(27450, 'tiger beetles').
ncbi_mult_taxo_gbnm(27457, 'oriental fruit fly').
ncbi_mult_taxo_gbnm(27458, 'deer flies').
ncbi_mult_taxo_gbnm(27474, 'parasitic flies').
ncbi_mult_taxo_gbnm(27479, 'assassin bugs').
ncbi_mult_taxo_gbnm(27482, aphids).
ncbi_mult_taxo_gbnm(27484, 'ensign wasps').
ncbi_mult_taxo_gbnm(27511, 'cuckoo wasps').
ncbi_mult_taxo_gbnm(27515, 'spider wasps').
ncbi_mult_taxo_gbnm(27528, 'parasitic wood wasps').
ncbi_mult_taxo_gbnm(27532, 'common sawflies').
ncbi_mult_taxo_gbnm(27541, 'western spruce budworm').
ncbi_mult_taxo_gbnm(27542, 'jack pine budworm').
ncbi_mult_taxo_gbnm(27543, 'oblique banded leafroller').
ncbi_mult_taxo_gbnm(27544, 'gossamer-wings').
ncbi_mult_taxo_gbnm(27548, 'tussock moths').
ncbi_mult_taxo_gbnm(27549, 'band-winged grasshoppers').
ncbi_mult_taxo_gbnm(27553, 'four-lined silverfish').
ncbi_mult_taxo_gbnm(27554, 'long-tailed silverfish').
ncbi_mult_taxo_gbnm(27563, 'velvet worms').
ncbi_mult_taxo_gbnm(27577, 'Old World tree frogs').
ncbi_mult_taxo_gbnm(27578, 'flying frogs').
ncbi_mult_taxo_gbnm(27579, 'Taipei treefrog').
ncbi_mult_taxo_gbnm(27582, 'Large-billed scrubwren').
ncbi_mult_taxo_gbnm(27583, 'frill sharks').
ncbi_mult_taxo_gbnm(27585, 'frilled shark').
ncbi_mult_taxo_gbnm(27588, 'spotted ray').
ncbi_mult_taxo_gbnm(27590, 'Atlantic torpedo').
ncbi_mult_taxo_gbnm(27591, 'Grant\'s gazelle').
ncbi_mult_taxo_gbnm(27596, 'lowland anoa').
ncbi_mult_taxo_gbnm(27602, 'bowhead whale').
ncbi_mult_taxo_gbnm(27604, 'pygmy right whale').
ncbi_mult_taxo_gbnm(27606, 'North Atlantic right whale').
ncbi_mult_taxo_gbnm(27608, 'black dolphin').
ncbi_mult_taxo_gbnm(27610, 'white-beaked dolphin').
ncbi_mult_taxo_gbnm(27613, 'southern right whale dolphin').
ncbi_mult_taxo_gbnm(27614, 'Burmeister\'s porpoise').
ncbi_mult_taxo_gbnm(27615, 'pygmy sperm whale').
ncbi_mult_taxo_gbnm(27616, 'Gervais\' beaked whale').
ncbi_mult_taxo_gbnm(27617, 'Peruvian beaked whale').
ncbi_mult_taxo_gbnm(27619, 'Wagner\'s bonneted bat').
ncbi_mult_taxo_gbnm(27620, 'western bonneted bat').
ncbi_mult_taxo_gbnm(27622, 'Pallas\'s mastiff bat').
ncbi_mult_taxo_gbnm(27624, 'Kalinowski\'s mastiff bat').
ncbi_mult_taxo_gbnm(27626, 'Peale\'s free-tailed bat').
ncbi_mult_taxo_gbnm(27627, 'broad-eared bat').
ncbi_mult_taxo_gbnm(27629, 'big crested mastiff bat').
ncbi_mult_taxo_gbnm(27634, 'great fruit-eating bat').
ncbi_mult_taxo_gbnm(27638, 'Pallas\'s long-tongued bat').
ncbi_mult_taxo_gbnm(27642, 'tailed tailless bat').
ncbi_mult_taxo_gbnm(27644, 'wrinkle-faced bat').
ncbi_mult_taxo_gbnm(27646, 'Salvin\'s big-eyed bat').
ncbi_mult_taxo_gbnm(27647, 'little big-eyed bat').
ncbi_mult_taxo_gbnm(27654, 'little fruit-eating bat').
ncbi_mult_taxo_gbnm(27658, 'Heller\'s broad-nosed bat').
ncbi_mult_taxo_gbnm(27660, 'little yellow-shouldered bat').
ncbi_mult_taxo_gbnm(27661, 'Tilda yellow-shouldered bat').
ncbi_mult_taxo_gbnm(27663, 'tent-building bat').
ncbi_mult_taxo_gbnm(27665, 'Allen\'s big-eared bat').
ncbi_mult_taxo_gbnm(27667, 'Silver-haired bat').
ncbi_mult_taxo_gbnm(27668, 'eastern small-footed myotis').
ncbi_mult_taxo_gbnm(27670, 'evening bat').
ncbi_mult_taxo_gbnm(27672, 'eastern pipistrelle').
ncbi_mult_taxo_gbnm(27674, 'Rafinesque\'s big-eared bat').
ncbi_mult_taxo_gbnm(27675, 'southern two-toed sloth').
ncbi_mult_taxo_gbnm(27679, 'Bolivian squirrel monkey').
ncbi_mult_taxo_gbnm(27681, 'little Indian field mouse').
ncbi_mult_taxo_gbnm(27682, 'Plains pocket gopher').
ncbi_mult_taxo_gbnm(27687, reedfish).
ncbi_mult_taxo_gbnm(27688, 'West African bichir').
ncbi_mult_taxo_gbnm(27689, 'Siberian sturgeon').
ncbi_mult_taxo_gbnm(27695, curimbata).
ncbi_mult_taxo_gbnm(27697, sardine).
ncbi_mult_taxo_gbnm(27699, 'pearl danio').
ncbi_mult_taxo_gbnm(27703, gudgeons).
ncbi_mult_taxo_gbnm(27704, gudgeon).
ncbi_mult_taxo_gbnm(27706, 'largemouth bass').
ncbi_mult_taxo_gbnm(27708, 'rosy barb').
ncbi_mult_taxo_gbnm(27712, 'elegant rasbora').
ncbi_mult_taxo_gbnm(27714, 'red-stripped rasbora').
ncbi_mult_taxo_gbnm(27715, 'scissor-tailed rasbora').
ncbi_mult_taxo_gbnm(27717, tench).
ncbi_mult_taxo_gbnm(27718, trahiras).
ncbi_mult_taxo_gbnm(27720, trahira).
ncbi_mult_taxo_gbnm(27723, 'bony tongues').
ncbi_mult_taxo_gbnm(27749, 'spangled cichlid').
ncbi_mult_taxo_gbnm(27750, 'black cichlids').
ncbi_mult_taxo_gbnm(27763, 'spotfin goby cichlid').
ncbi_mult_taxo_gbnm(27766, dolphinfishes).
ncbi_mult_taxo_gbnm(27767, 'snake mackerels').
ncbi_mult_taxo_gbnm(27768, billfishes).
ncbi_mult_taxo_gbnm(27769, barracudas).
ncbi_mult_taxo_gbnm(27770, cutlassfishes).
ncbi_mult_taxo_gbnm(27771, 'common dab').
ncbi_mult_taxo_gbnm(27773, 'Arctic cisco').
ncbi_mult_taxo_gbnm(27774, searobins).
ncbi_mult_taxo_gbnm(27777, 'Florida gar').
ncbi_mult_taxo_gbnm(27778, 'brown bullhead').
ncbi_mult_taxo_gbnm(27779, 'slender lungfish').
ncbi_mult_taxo_gbnm(27783, 'humphead cichlid').
ncbi_mult_taxo_gbnm(27787, 'hawksbill sea turtle').
ncbi_mult_taxo_gbnm(27788, 'Pacific ridley').
ncbi_mult_taxo_gbnm(27790, 'flatback sea turtle').
ncbi_mult_taxo_gbnm(27792, 'leatherback turtles').
ncbi_mult_taxo_gbnm(27794, 'leatherback sea turtle').
ncbi_mult_taxo_gbnm(27807, 'ribbed mussel').
ncbi_mult_taxo_gbnm(27813, 'turret shells').
ncbi_mult_taxo_gbnm(27818, 'door snails').
ncbi_mult_taxo_gbnm(27829, lungworms).
ncbi_mult_taxo_gbnm(27923, 'sea walnut').
ncbi_mult_taxo_gbnm(28009, choanoflagellates).
ncbi_mult_taxo_gbnm(28211, 'a-proteobacteria').
ncbi_mult_taxo_gbnm(28216, 'b-proteobacteria').
ncbi_mult_taxo_gbnm(28221, 'd-proteobacteria').
ncbi_mult_taxo_gbnm(28304, 'Rat cytomegalovirus').
ncbi_mult_taxo_gbnm(28377, 'green anole').
ncbi_mult_taxo_gbnm(28379, 'spinycheek crayfish').
ncbi_mult_taxo_gbnm(28381, 'South American pilchard').
ncbi_mult_taxo_gbnm(28437, 'Nantou flying frog').
ncbi_mult_taxo_gbnm(28470, 'Christmas fern').
ncbi_mult_taxo_gbnm(28478, 'arrowleaf elephant\'s ear').
ncbi_mult_taxo_gbnm(28479, 'canary grass').
ncbi_mult_taxo_gbnm(28483, 'starry hyacinth').
ncbi_mult_taxo_gbnm(28502, 'grain amaranth').
ncbi_mult_taxo_gbnm(28509, 'ground ivy').
ncbi_mult_taxo_gbnm(28510, 'obedient plant').
ncbi_mult_taxo_gbnm(28511, patchouli).
ncbi_mult_taxo_gbnm(28512, 'round-leaf mintbush').
ncbi_mult_taxo_gbnm(28516, 'purpletop vervain').
ncbi_mult_taxo_gbnm(28523, 'red morning glory').
ncbi_mult_taxo_gbnm(28528, 'mugo pine').
ncbi_mult_taxo_gbnm(28540, 'summer lilac').
ncbi_mult_taxo_gbnm(28586, 'Mexican fruit fly').
ncbi_mult_taxo_gbnm(28587, 'Caribbean fruit fly').
ncbi_mult_taxo_gbnm(28588, 'melon fly').
ncbi_mult_taxo_gbnm(28610, 'apple maggot').
ncbi_mult_taxo_gbnm(28612, 'snowberry fruit fly').
ncbi_mult_taxo_gbnm(28624, 'rock-pool mosquito').
ncbi_mult_taxo_gbnm(28628, 'black onion fly').
ncbi_mult_taxo_gbnm(28629, 'skipper flies').
ncbi_mult_taxo_gbnm(28635, 'light flies').
ncbi_mult_taxo_gbnm(28641, 'bumble bees').
ncbi_mult_taxo_gbnm(28653, 'cuckoo bumblebees').
ncbi_mult_taxo_gbnm(28660, 'yucca moths').
ncbi_mult_taxo_gbnm(28661, 'greya moths').
ncbi_mult_taxo_gbnm(28676, 'bogus yucca moths').
ncbi_mult_taxo_gbnm(28680, 'northern pintail').
ncbi_mult_taxo_gbnm(28689, razorbill).
ncbi_mult_taxo_gbnm(28699, 'parakeet auklet').
ncbi_mult_taxo_gbnm(28701, 'Atlantic puffin').
ncbi_mult_taxo_gbnm(28708, 'ancient murrelet').
ncbi_mult_taxo_gbnm(28709, 'Xantus\'s murrelet').
ncbi_mult_taxo_gbnm(28711, 'thick-billed guillemot').
ncbi_mult_taxo_gbnm(28722, 'Black-eared catbird').
ncbi_mult_taxo_gbnm(28724, 'satin bowerbird').
ncbi_mult_taxo_gbnm(28727, 'blue jay').
ncbi_mult_taxo_gbnm(28733, 'red-eyed vireo').
ncbi_mult_taxo_gbnm(28734, 'elephants shrews').
ncbi_mult_taxo_gbnm(28736, 'long-eared elephant shrews').
ncbi_mult_taxo_gbnm(28737, 'Cape elephant shrew').
ncbi_mult_taxo_gbnm(28738, 'killifishes and others').
ncbi_mult_taxo_gbnm(28742, 'Red River pupfish').
ncbi_mult_taxo_gbnm(28743, 'sheepshead minnow').
ncbi_mult_taxo_gbnm(28745, flagfish).
ncbi_mult_taxo_gbnm(28756, topminnows).
ncbi_mult_taxo_gbnm(28757, 'California killifish').
ncbi_mult_taxo_gbnm(28758, goodeids).
ncbi_mult_taxo_gbnm(28760, 'White River springfish').
ncbi_mult_taxo_gbnm(28762, 'redtail splitfin').
ncbi_mult_taxo_gbnm(28764, 'picotee splitfin').
ncbi_mult_taxo_gbnm(28765, jenynsiids).
ncbi_mult_taxo_gbnm(28767, 'onesided livebearer').
ncbi_mult_taxo_gbnm(28768, 'Middle American killifishes').
ncbi_mult_taxo_gbnm(28770, 'Guatemalan killifish').
ncbi_mult_taxo_gbnm(28771, 'New World rivulines').
ncbi_mult_taxo_gbnm(28778, rivulines).
ncbi_mult_taxo_gbnm(28780, 'blackspotted nothobranch').
ncbi_mult_taxo_gbnm(28791, 'red shiner').
ncbi_mult_taxo_gbnm(28792, 'blacktail shiner').
ncbi_mult_taxo_gbnm(28794, 'rainbow shiner').
ncbi_mult_taxo_gbnm(28795, 'sand shiner').
ncbi_mult_taxo_gbnm(28796, 'Topeka shiner').
ncbi_mult_taxo_gbnm(28798, 'swallowtail shiner').
ncbi_mult_taxo_gbnm(28800, 'golden shiner').
ncbi_mult_taxo_gbnm(28827, 'rainbow krib').
ncbi_mult_taxo_gbnm(28829, 'Senegalese sole').
ncbi_mult_taxo_gbnm(28835, 'banded wood snail').
ncbi_mult_taxo_gbnm(28841, 'sheep tapeworm').
ncbi_mult_taxo_gbnm(28844, 'broad tapeworms').
ncbi_mult_taxo_gbnm(28890, euryarchaeotes).
ncbi_mult_taxo_gbnm(28909, 'Bermuda grass').
ncbi_mult_taxo_gbnm(28911, shallot).
ncbi_mult_taxo_gbnm(28913, 'Fremont\'s calycadenia').
ncbi_mult_taxo_gbnm(28915, 'Hoover\'s calycadenia').
ncbi_mult_taxo_gbnm(28916, 'soft calycadenia').
ncbi_mult_taxo_gbnm(28917, 'sticky calycadenia').
ncbi_mult_taxo_gbnm(28918, 'Butte County calycadenia').
ncbi_mult_taxo_gbnm(28919, 'small-flowered calycadenia').
ncbi_mult_taxo_gbnm(28920, 'spicate calycadenia').
ncbi_mult_taxo_gbnm(28921, 'rosin weed').
ncbi_mult_taxo_gbnm(28922, 'dwarf calycadenia').
ncbi_mult_taxo_gbnm(28923, 'perennial spikeweed').
ncbi_mult_taxo_gbnm(28929, 'Japanese beech').
ncbi_mult_taxo_gbnm(28930, 'European beech').
ncbi_mult_taxo_gbnm(28959, 'Texas bluebonnet').
ncbi_mult_taxo_gbnm(28973, 'Douglas\'s meadowfoam').
ncbi_mult_taxo_gbnm(28980, 'coast redwood').
ncbi_mult_taxo_gbnm(28987, 'blackleg fungus').
ncbi_mult_taxo_gbnm(29017, 'Chinese earth tiger').
ncbi_mult_taxo_gbnm(29019, 'blue shrimp').
ncbi_mult_taxo_gbnm(29022, 'house centipede').
ncbi_mult_taxo_gbnm(29025, 'spined soldier bug').
ncbi_mult_taxo_gbnm(29026, 'rove beetles').
ncbi_mult_taxo_gbnm(29032, 'frit flies').
ncbi_mult_taxo_gbnm(29034, 'grass fly').
ncbi_mult_taxo_gbnm(29035, 'fungus gnats').
ncbi_mult_taxo_gbnm(29037, 'fungus gnat').
ncbi_mult_taxo_gbnm(29039, 'odorous house ant').
ncbi_mult_taxo_gbnm(29040, 'acrobat ants').
ncbi_mult_taxo_gbnm(29057, 'European corn borer').
ncbi_mult_taxo_gbnm(29058, 'cotton bollworm').
ncbi_mult_taxo_gbnm(29060, 'rufous hummingbird').
ncbi_mult_taxo_gbnm(29064, 'snow leopard').
ncbi_mult_taxo_gbnm(29065, 'European pine marten').
ncbi_mult_taxo_gbnm(29067, kinkajou).
ncbi_mult_taxo_gbnm(29073, 'polar bear').
ncbi_mult_taxo_gbnm(29076, 'lesser long-tongued fruit bat').
ncbi_mult_taxo_gbnm(29078, 'big brown bat').
ncbi_mult_taxo_gbnm(29080, 'large hairy armadillo').
ncbi_mult_taxo_gbnm(29082, 'short-eared elephant shrew').
ncbi_mult_taxo_gbnm(29084, 'New Zealand fur seal').
ncbi_mult_taxo_gbnm(29086, 'leopard seal').
ncbi_mult_taxo_gbnm(29087, 'monk seals').
ncbi_mult_taxo_gbnm(29088, 'Hawaiian monk seal').
ncbi_mult_taxo_gbnm(29089, 'Black crested gibbon').
ncbi_mult_taxo_gbnm(29091, 'Patagonian cavy').
ncbi_mult_taxo_gbnm(29092, 'short-tailed field vole').
ncbi_mult_taxo_gbnm(29094, 'long-haired grass mouse').
ncbi_mult_taxo_gbnm(29095, 'Azara\'s grass mouse').
ncbi_mult_taxo_gbnm(29096, 'Cursor grass mouse').
ncbi_mult_taxo_gbnm(29098, 'olive grass mouse').
ncbi_mult_taxo_gbnm(29099, 'El Dorado grass mouse').
ncbi_mult_taxo_gbnm(29100, 'Cochabamba grass mouse').
ncbi_mult_taxo_gbnm(29101, 'Chaco grass mouse').
ncbi_mult_taxo_gbnm(29102, 'northern grass mouse').
ncbi_mult_taxo_gbnm(29104, 'painted big-eared mouse').
ncbi_mult_taxo_gbnm(29106, 'Andean vesper mouse').
ncbi_mult_taxo_gbnm(29109, 'Andean long-clawed mouse').
ncbi_mult_taxo_gbnm(29111, 'long-clawed mole mouse').
ncbi_mult_taxo_gbnm(29113, 'Chilean climbing mouse').
ncbi_mult_taxo_gbnm(29115, 'Andean rat').
ncbi_mult_taxo_gbnm(29117, 'South American water rat').
ncbi_mult_taxo_gbnm(29119, 'Edwards\'s long-clawed mouse').
ncbi_mult_taxo_gbnm(29125, 'spy hocicudo').
ncbi_mult_taxo_gbnm(29126, 'small hocicudo').
ncbi_mult_taxo_gbnm(29127, 'Paramo hocicudo').
ncbi_mult_taxo_gbnm(29129, 'white-footed climbing mouse').
ncbi_mult_taxo_gbnm(29131, 'golden oldfield mouse').
ncbi_mult_taxo_gbnm(29132, beavers).
ncbi_mult_taxo_gbnm(29135, 'dugong and sea cow').
ncbi_mult_taxo_gbnm(29137, dugong).
ncbi_mult_taxo_gbnm(29139, 'common wombat').
ncbi_mult_taxo_gbnm(29140, 'milkfish and others').
ncbi_mult_taxo_gbnm(29142, milkfish).
ncbi_mult_taxo_gbnm(29144, milkfish).
ncbi_mult_taxo_gbnm(29146, surgeonfishes).
ncbi_mult_taxo_gbnm(29147, 'Nile perch').
ncbi_mult_taxo_gbnm(29149, 'red empress cichlid').
ncbi_mult_taxo_gbnm(29150, 'blue mackerel').
ncbi_mult_taxo_gbnm(29151, 'European smelt').
ncbi_mult_taxo_gbnm(29154, 'Atlantic croaker').
ncbi_mult_taxo_gbnm(29156, 'Australian copperhead').
ncbi_mult_taxo_gbnm(29158, 'Mediterranean mussel').
ncbi_mult_taxo_gbnm(29159, 'Pacific oyster').
ncbi_mult_taxo_gbnm(29170, 'dog hookworm').
ncbi_mult_taxo_gbnm(29172, 'bovine lungworm').
ncbi_mult_taxo_gbnm(29178, forams).
ncbi_mult_taxo_gbnm(29451, 'photosynthetic Rhizobia').
ncbi_mult_taxo_gbnm(29547, 'e-proteobacteria').
ncbi_mult_taxo_gbnm(29588, 'golden chicken fern').
ncbi_mult_taxo_gbnm(29594, 'coast leather fern').
ncbi_mult_taxo_gbnm(29642, 'bird\'s-nest fern').
ncbi_mult_taxo_gbnm(29649, 'American eelgrass').
ncbi_mult_taxo_gbnm(29651, 'Richardson\'s pondweed').
ncbi_mult_taxo_gbnm(29656, 'great duckweed').
ncbi_mult_taxo_gbnm(29658, 'confederate spiderwort').
ncbi_mult_taxo_gbnm(29666, 'erect brome').
ncbi_mult_taxo_gbnm(29667, cheatgrass).
ncbi_mult_taxo_gbnm(29674, goosegrass).
ncbi_mult_taxo_gbnm(29675, 'Canada wild rye').
ncbi_mult_taxo_gbnm(29679, 'velvet grass').
ncbi_mult_taxo_gbnm(29692, 'fall panicum').
ncbi_mult_taxo_gbnm(29694, 'white foxtail').
ncbi_mult_taxo_gbnm(29695, 'common reed').
ncbi_mult_taxo_gbnm(29706, 'smooth cordgrass').
ncbi_mult_taxo_gbnm(29710, 'yellow Guinea yam').
ncbi_mult_taxo_gbnm(29711, daylily).
ncbi_mult_taxo_gbnm(29719, spearmint).
ncbi_mult_taxo_gbnm(29722, 'Joseph\'s coat').
ncbi_mult_taxo_gbnm(29727, arugula).
ncbi_mult_taxo_gbnm(29730, 'Peruvian cotton').
ncbi_mult_taxo_gbnm(29739, 'bog myrtle').
ncbi_mult_taxo_gbnm(29740, 'American elm').
ncbi_mult_taxo_gbnm(29760, 'wine grape').
ncbi_mult_taxo_gbnm(29780, mango).
ncbi_mult_taxo_gbnm(29783, firecrackerbush).
ncbi_mult_taxo_gbnm(29801, 'Levantine madder').
ncbi_mult_taxo_gbnm(29802, madder).
ncbi_mult_taxo_gbnm(29818, 'common plantain').
ncbi_mult_taxo_gbnm(29892, 'jelly ear fungus').
ncbi_mult_taxo_gbnm(29930, 'western blacklegged tick').
ncbi_mult_taxo_gbnm(29965, 'Dungeness crab').
ncbi_mult_taxo_gbnm(29966, 'snapping shrimps').
ncbi_mult_taxo_gbnm(29979, isopods).
ncbi_mult_taxo_gbnm(29997, diplurans).
ncbi_mult_taxo_gbnm(29999, coneheads).
ncbi_mult_taxo_gbnm(30001, springtails).
ncbi_mult_taxo_gbnm(30002, 'elongate-bodied springtails').
ncbi_mult_taxo_gbnm(30005, 'sucking lice').
ncbi_mult_taxo_gbnm(30007, 'desert cockroaches').
ncbi_mult_taxo_gbnm(30009, 'click beetles').
ncbi_mult_taxo_gbnm(30069, 'Asian malaria mosquito').
ncbi_mult_taxo_gbnm(30073, mayflies).
ncbi_mult_taxo_gbnm(30078, bedbugs).
ncbi_mult_taxo_gbnm(30080, 'armored scales').
ncbi_mult_taxo_gbnm(30082, 'California citrus scale').
ncbi_mult_taxo_gbnm(30083, 'plant bugs').
ncbi_mult_taxo_gbnm(30085, 'lygus bug').
ncbi_mult_taxo_gbnm(30086, spittlebugs).
ncbi_mult_taxo_gbnm(30094, 'eugenia psyllid').
ncbi_mult_taxo_gbnm(30095, treehoppers).
ncbi_mult_taxo_gbnm(30097, 'three-cornered alfalfa treehopper').
ncbi_mult_taxo_gbnm(30099, 'Doogie Howzer whitefly').
ncbi_mult_taxo_gbnm(30101, 'Kellogg\'s whitefly').
ncbi_mult_taxo_gbnm(30102, leafhoppers).
ncbi_mult_taxo_gbnm(30138, 'aster leafhopper').
ncbi_mult_taxo_gbnm(30189, 'soft scales').
ncbi_mult_taxo_gbnm(30190, mealybugs).
ncbi_mult_taxo_gbnm(30193, 'white-tailed bumblebee').
ncbi_mult_taxo_gbnm(30195, 'buff-tailed bumblebee').
ncbi_mult_taxo_gbnm(30203, 'black fire ant').
ncbi_mult_taxo_gbnm(30207, 'common paper wasp').
ncbi_mult_taxo_gbnm(30213, 'western yellowjacket').
ncbi_mult_taxo_gbnm(30222, 'fairy moths').
ncbi_mult_taxo_gbnm(30225, 'tiger moths').
ncbi_mult_taxo_gbnm(30227, 'ranchman\'s tiger moth').
ncbi_mult_taxo_gbnm(30228, 'gall moths').
ncbi_mult_taxo_gbnm(30241, 'true yucca moths').
ncbi_mult_taxo_gbnm(30243, 'yucca moth').
ncbi_mult_taxo_gbnm(30248, 'milkweed butterflies').
ncbi_mult_taxo_gbnm(30253, 'differential grasshopper').
ncbi_mult_taxo_gbnm(30261, 'twisted-wing parasites').
ncbi_mult_taxo_gbnm(30262, thrips).
ncbi_mult_taxo_gbnm(30263, caddisflies).
ncbi_mult_taxo_gbnm(30265, 'angel insects').
ncbi_mult_taxo_gbnm(30302, appendicularians).
ncbi_mult_taxo_gbnm(30307, salps).
ncbi_mult_taxo_gbnm(30317, 'Mexican spadefoot toad').
ncbi_mult_taxo_gbnm(30324, 'Colorado River toad').
ncbi_mult_taxo_gbnm(30325, 'boreal toad').
ncbi_mult_taxo_gbnm(30326, 'natterjack toad').
ncbi_mult_taxo_gbnm(30327, 'Yosemite toad').
ncbi_mult_taxo_gbnm(30328, 'Great Plains toad').
ncbi_mult_taxo_gbnm(30329, 'green toad').
ncbi_mult_taxo_gbnm(30330, 'black toad').
ncbi_mult_taxo_gbnm(30331, 'Asiatic toad').
ncbi_mult_taxo_gbnm(30332, 'granular toad').
ncbi_mult_taxo_gbnm(30333, 'Truando toad').
ncbi_mult_taxo_gbnm(30334, 'Kisolo toad').
ncbi_mult_taxo_gbnm(30335, 'Asian common toad').
ncbi_mult_taxo_gbnm(30336, 'Arizona toad').
ncbi_mult_taxo_gbnm(30337, 'Texas toad').
ncbi_mult_taxo_gbnm(30338, 'European green toad').
ncbi_mult_taxo_gbnm(30340, 'ghost frogs').
ncbi_mult_taxo_gbnm(30342, 'Cope\'s gray treefrog').
ncbi_mult_taxo_gbnm(30343, 'chameleon treefrog').
ncbi_mult_taxo_gbnm(30344, 'White\'s tree frog').
ncbi_mult_taxo_gbnm(30345, 'magnificent tree frog').
ncbi_mult_taxo_gbnm(30346, 'South American horned frogs').
ncbi_mult_taxo_gbnm(30347, 'ornate horned frog').
ncbi_mult_taxo_gbnm(30349, 'crawling toadlet').
ncbi_mult_taxo_gbnm(30360, 'Rio Grande leopard frog').
ncbi_mult_taxo_gbnm(30365, hellbenders).
ncbi_mult_taxo_gbnm(30374, 'Pyrenean brook newt').
ncbi_mult_taxo_gbnm(30378, 'African caecilians').
ncbi_mult_taxo_gbnm(30380, 'neotropical tailed caecilians').
ncbi_mult_taxo_gbnm(30382, 'Egyptian goose').
ncbi_mult_taxo_gbnm(30385, redhead).
ncbi_mult_taxo_gbnm(30387, 'red-crested pochard').
ncbi_mult_taxo_gbnm(30388, 'southern screamer').
ncbi_mult_taxo_gbnm(30389, 'great herons').
ncbi_mult_taxo_gbnm(30390, 'grey heron').
ncbi_mult_taxo_gbnm(30396, hawks).
ncbi_mult_taxo_gbnm(30397, 'common buzzard').
ncbi_mult_taxo_gbnm(30399, 'hooded vulture').
ncbi_mult_taxo_gbnm(30401, 'wattled brush turkey').
ncbi_mult_taxo_gbnm(30405, 'Crested partridge').
ncbi_mult_taxo_gbnm(30408, 'white-eared pheasant').
ncbi_mult_taxo_gbnm(30410, 'white-tailed ptarmigan').
ncbi_mult_taxo_gbnm(30411, loons).
ncbi_mult_taxo_gbnm(30412, loons).
ncbi_mult_taxo_gbnm(30414, 'black crowned-crane').
ncbi_mult_taxo_gbnm(30415, 'Red-crowned crane').
ncbi_mult_taxo_gbnm(30416, hoatzins).
ncbi_mult_taxo_gbnm(30417, hoatzins).
ncbi_mult_taxo_gbnm(30420, crows).
ncbi_mult_taxo_gbnm(30421, 'pied crow').
ncbi_mult_taxo_gbnm(30422, 'carrion crow').
ncbi_mult_taxo_gbnm(30423, jackdaw).
ncbi_mult_taxo_gbnm(30424, buntings).
ncbi_mult_taxo_gbnm(30425, 'reed bunting').
ncbi_mult_taxo_gbnm(30427, 'house finch').
ncbi_mult_taxo_gbnm(30431, 'Peruvian rufous-vented tapaculo').
ncbi_mult_taxo_gbnm(30435, 'unicolored tapaculo').
ncbi_mult_taxo_gbnm(30443, frigatebirds).
ncbi_mult_taxo_gbnm(30444, pelicans).
ncbi_mult_taxo_gbnm(30445, tropicbirds).
ncbi_mult_taxo_gbnm(30446, 'gannets and boobies').
ncbi_mult_taxo_gbnm(30447, grebes).
ncbi_mult_taxo_gbnm(30448, grebes).
ncbi_mult_taxo_gbnm(30449, 'petrels and albatrosses').
ncbi_mult_taxo_gbnm(30451, 'shearwaters and petrels').
ncbi_mult_taxo_gbnm(30455, 'Northern fulmar').
ncbi_mult_taxo_gbnm(30456, 'white-capped parrot').
ncbi_mult_taxo_gbnm(30457, 'Gentoo penguin').
ncbi_mult_taxo_gbnm(30458, owls).
ncbi_mult_taxo_gbnm(30460, 'eagle owls').
ncbi_mult_taxo_gbnm(30461, 'Eurasian eagle-owl').
ncbi_mult_taxo_gbnm(30462, 'barn owls').
ncbi_mult_taxo_gbnm(30466, 'red-winged tinamou').
ncbi_mult_taxo_gbnm(30468, 'great tinamou').
ncbi_mult_taxo_gbnm(30469, stingrays).
ncbi_mult_taxo_gbnm(30475, 'hardnose skates').
ncbi_mult_taxo_gbnm(30480, 'electric rays').
ncbi_mult_taxo_gbnm(30483, 'ground sharks').
ncbi_mult_taxo_gbnm(30489, 'African catshark').
ncbi_mult_taxo_gbnm(30493, 'leopard shark').
ncbi_mult_taxo_gbnm(30494, 'banded houndshark').
ncbi_mult_taxo_gbnm(30501, 'sand tiger shark').
ncbi_mult_taxo_gbnm(30503, 'carpet sharks').
ncbi_mult_taxo_gbnm(30507, 'nurse sharks').
ncbi_mult_taxo_gbnm(30511, 'dogfish sharks').
ncbi_mult_taxo_gbnm(30520, gayal).
ncbi_mult_taxo_gbnm(30521, 'domestic yak').
ncbi_mult_taxo_gbnm(30522, 'hybrid cattle').
ncbi_mult_taxo_gbnm(30527, argali).
ncbi_mult_taxo_gbnm(30531, chital).
ncbi_mult_taxo_gbnm(30532, 'fallow deer').
ncbi_mult_taxo_gbnm(30533, 'musk deer').
ncbi_mult_taxo_gbnm(30535, 'white-lipped peccary').
ncbi_mult_taxo_gbnm(30538, alpaca).
ncbi_mult_taxo_gbnm(30542, 'Molina\'s hog-nosed skunk').
ncbi_mult_taxo_gbnm(30543, 'eastern hog-nosed skunk').
ncbi_mult_taxo_gbnm(30544, 'western hog-nosed skunk').
ncbi_mult_taxo_gbnm(30547, 'hooded skunk').
ncbi_mult_taxo_gbnm(30548, 'striped skunk').
ncbi_mult_taxo_gbnm(30551, 'western spotted skunk').
ncbi_mult_taxo_gbnm(30552, 'eastern spotted skunk').
ncbi_mult_taxo_gbnm(30554, 'American badger').
ncbi_mult_taxo_gbnm(30558, 'right whales').
ncbi_mult_taxo_gbnm(30562, 'sac-winged, sheath-tailed, and ghost bats').
ncbi_mult_taxo_gbnm(30576, 'Algerian hedgehog').
ncbi_mult_taxo_gbnm(30577, 'spiny hedgehogs').
ncbi_mult_taxo_gbnm(30581, 'desert cottontail').
ncbi_mult_taxo_gbnm(30582, 'mountain tapir').
ncbi_mult_taxo_gbnm(30584, 'Galapagos fur seal').
ncbi_mult_taxo_gbnm(30586, 'Midas tamarin').
ncbi_mult_taxo_gbnm(30588, 'golden lion tamarin').
ncbi_mult_taxo_gbnm(30589, 'mantled howler monkey').
ncbi_mult_taxo_gbnm(30590, 'black-and-red howler monkey').
ncbi_mult_taxo_gbnm(30591, 'Azara\'s night monkey').
ncbi_mult_taxo_gbnm(30592, 'collared titi').
ncbi_mult_taxo_gbnm(30594, 'woolly spider monkey').
ncbi_mult_taxo_gbnm(30596, 'Bald Uacari').
ncbi_mult_taxo_gbnm(30597, 'saki monkeys').
ncbi_mult_taxo_gbnm(30598, 'bald-faced saki').
ncbi_mult_taxo_gbnm(30600, sifakas).
ncbi_mult_taxo_gbnm(30601, 'Tattersall\'s sifaka').
ncbi_mult_taxo_gbnm(30602, 'black lemur').
ncbi_mult_taxo_gbnm(30608, 'gray mouse lemur').
ncbi_mult_taxo_gbnm(30609, 'Moholi bushbaby').
ncbi_mult_taxo_gbnm(30610, 'greater bushbabies').
ncbi_mult_taxo_gbnm(30611, 'small-eared galago').
ncbi_mult_taxo_gbnm(30613, 'aye-ayes').
ncbi_mult_taxo_gbnm(30615, 'dwarf and mouse lemurs').
ncbi_mult_taxo_gbnm(30618, 'Bolivian bamboo rat').
ncbi_mult_taxo_gbnm(30619, 'Amazon bamboo rat').
ncbi_mult_taxo_gbnm(30621, 'White-faced spiny tree-rat').
ncbi_mult_taxo_gbnm(30622, 'Red-nosed armored tree-rat').
ncbi_mult_taxo_gbnm(30624, 'yellow-crowned brush-tailed rat').
ncbi_mult_taxo_gbnm(30625, 'plain brush-tailed rat').
ncbi_mult_taxo_gbnm(30627, 'spiny tree rat').
ncbi_mult_taxo_gbnm(30629, 'Surinam spiny tree rat').
ncbi_mult_taxo_gbnm(30630, 'East European vole').
ncbi_mult_taxo_gbnm(30635, 'hairy-tailed bolo mouse').
ncbi_mult_taxo_gbnm(30636, 'Mediterranean blind mole-rats').
ncbi_mult_taxo_gbnm(30637, 'Ehrenberg\'s mole-rat').
ncbi_mult_taxo_gbnm(30638, 'lesser mole rat').
ncbi_mult_taxo_gbnm(30639, 'multimammate rats').
ncbi_mult_taxo_gbnm(30640, 'gray squirrel').
ncbi_mult_taxo_gbnm(30644, hutias).
ncbi_mult_taxo_gbnm(30645, 'tuco-tucos').
ncbi_mult_taxo_gbnm(30646, 'agoutis and pacas').
ncbi_mult_taxo_gbnm(30648, jerboas).
ncbi_mult_taxo_gbnm(30649, 'New World porcupines').
ncbi_mult_taxo_gbnm(30650, dormice).
ncbi_mult_taxo_gbnm(30656, 'flying lemurs').
ncbi_mult_taxo_gbnm(30657, 'flying lemurs').
ncbi_mult_taxo_gbnm(30658, 'pygmy possums').
ncbi_mult_taxo_gbnm(30659, 'shrew opossums').
ncbi_mult_taxo_gbnm(30660, 'Monito del Monte').
ncbi_mult_taxo_gbnm(30662, 'marsupial moles').
ncbi_mult_taxo_gbnm(30666, 'hairy-nosed wombats').
ncbi_mult_taxo_gbnm(30667, 'northern hairy-nosed wombat').
ncbi_mult_taxo_gbnm(30668, 'southern hairy-nosed wombat').
ncbi_mult_taxo_gbnm(30670, quokka).
ncbi_mult_taxo_gbnm(30700, rainbowfishes).
ncbi_mult_taxo_gbnm(30720, 'freshwater hatchetfishes').
ncbi_mult_taxo_gbnm(30724, 'Pacific herring').
ncbi_mult_taxo_gbnm(30726, 'algae eaters').
ncbi_mult_taxo_gbnm(30732, 'Indian medaka').
ncbi_mult_taxo_gbnm(30734, 'Yucatan flagfish').
ncbi_mult_taxo_gbnm(30740, 'checkered pupfish').
ncbi_mult_taxo_gbnm(30742, 'goldspotted killifish').
ncbi_mult_taxo_gbnm(30756, 'European hake').
ncbi_mult_taxo_gbnm(30757, codlets).
ncbi_mult_taxo_gbnm(30758, 'pelagic cods').
ncbi_mult_taxo_gbnm(30759, 'morid cods').
ncbi_mult_taxo_gbnm(30760, 'eel cods').
ncbi_mult_taxo_gbnm(30761, grenadiers).
ncbi_mult_taxo_gbnm(30766, 'ghost knifefishes').
ncbi_mult_taxo_gbnm(30771, 'naked-back knifefishes').
ncbi_mult_taxo_gbnm(30800, 'cuckoo wrasse').
ncbi_mult_taxo_gbnm(30804, 'thin-lipped mullet').
ncbi_mult_taxo_gbnm(30806, 'crocodile icefishes').
ncbi_mult_taxo_gbnm(30828, butterflyfishes).
ncbi_mult_taxo_gbnm(30840, grunts).
ncbi_mult_taxo_gbnm(30842, aholeholes).
ncbi_mult_taxo_gbnm(30843, 'sea chubs').
ncbi_mult_taxo_gbnm(30845, 'false trevallies').
ncbi_mult_taxo_gbnm(30846, ponyfishes).
ncbi_mult_taxo_gbnm(30847, beachsalmon).
ncbi_mult_taxo_gbnm(30848, emperors).
ncbi_mult_taxo_gbnm(30849, tripletails).
ncbi_mult_taxo_gbnm(30850, snappers).
ncbi_mult_taxo_gbnm(30851, tilefishes).
ncbi_mult_taxo_gbnm(30852, moonfish).
ncbi_mult_taxo_gbnm(30853, moonfishes).
ncbi_mult_taxo_gbnm(30854, goatfishes).
ncbi_mult_taxo_gbnm(30855, leaffishes).
ncbi_mult_taxo_gbnm(30856, roosterfish).
ncbi_mult_taxo_gbnm(30857, 'threadfin breams').
ncbi_mult_taxo_gbnm(30858, knifejaws).
ncbi_mult_taxo_gbnm(30859, sweepers).
ncbi_mult_taxo_gbnm(30860, armorheads).
ncbi_mult_taxo_gbnm(30861, roundheads).
ncbi_mult_taxo_gbnm(30862, angelfishes).
ncbi_mult_taxo_gbnm(30863, damselfishes).
ncbi_mult_taxo_gbnm(30864, bluefishes).
ncbi_mult_taxo_gbnm(30865, bigeyes).
ncbi_mult_taxo_gbnm(30866, dottybacks).
ncbi_mult_taxo_gbnm(30867, cobia).
ncbi_mult_taxo_gbnm(30869, scats).
ncbi_mult_taxo_gbnm(30870, drums).
ncbi_mult_taxo_gbnm(30871, 'sea basses').
ncbi_mult_taxo_gbnm(30873, 'barred sand bass').
ncbi_mult_taxo_gbnm(30874, 'smelt-whitings').
ncbi_mult_taxo_gbnm(30875, grunters).
ncbi_mult_taxo_gbnm(30876, archerfishes).
ncbi_mult_taxo_gbnm(30882, 'hump-head').
ncbi_mult_taxo_gbnm(30887, louvar).
ncbi_mult_taxo_gbnm(30888, wrymouths).
ncbi_mult_taxo_gbnm(30890, quillfishes).
ncbi_mult_taxo_gbnm(30891, graveldivers).
ncbi_mult_taxo_gbnm(30892, pricklebacks).
ncbi_mult_taxo_gbnm(30893, prowfish).
ncbi_mult_taxo_gbnm(30908, dragonets).
ncbi_mult_taxo_gbnm(30910, snakeheads).
ncbi_mult_taxo_gbnm(30917, threadfins).
ncbi_mult_taxo_gbnm(30943, citharids).
ncbi_mult_taxo_gbnm(30945, 'flathead sole').
ncbi_mult_taxo_gbnm(30947, tonguefishes).
ncbi_mult_taxo_gbnm(30948, soles).
ncbi_mult_taxo_gbnm(30949, psettodids).
ncbi_mult_taxo_gbnm(30950, mudminnows).
ncbi_mult_taxo_gbnm(30955, 'ayu fish').
ncbi_mult_taxo_gbnm(30960, capelin).
ncbi_mult_taxo_gbnm(30962, 'cutthroat trout').
ncbi_mult_taxo_gbnm(30972, poachers).
ncbi_mult_taxo_gbnm(30976, 'fathead sculpins').
ncbi_mult_taxo_gbnm(30983, greenlings).
ncbi_mult_taxo_gbnm(30984, combfishes).
ncbi_mult_taxo_gbnm(30986, 'ghost flatheads').
ncbi_mult_taxo_gbnm(30987, flatheads).
ncbi_mult_taxo_gbnm(30988, sablefishes).
ncbi_mult_taxo_gbnm(30989, sheatfishes).
ncbi_mult_taxo_gbnm(30991, 'Amur catfish').
ncbi_mult_taxo_gbnm(30993, 'Mekong giant catfish').
ncbi_mult_taxo_gbnm(30994, 'pencil catfishes').
ncbi_mult_taxo_gbnm(30995, 'sisorid catfishes').
ncbi_mult_taxo_gbnm(30996, 'schilbid catfishes').
ncbi_mult_taxo_gbnm(30997, 'eeltail catfishes').
ncbi_mult_taxo_gbnm(30998, 'long-wiskered catfishes').
ncbi_mult_taxo_gbnm(31000, squeakers).
ncbi_mult_taxo_gbnm(31001, 'electric catfishes').
ncbi_mult_taxo_gbnm(31002, 'suckermouth armored catfishes').
ncbi_mult_taxo_gbnm(31004, 'airsac catfishes').
ncbi_mult_taxo_gbnm(31006, 'thorny catfishes').
ncbi_mult_taxo_gbnm(31007, 'velvet catfishes').
ncbi_mult_taxo_gbnm(31008, 'armorhead catfishes').
ncbi_mult_taxo_gbnm(31009, 'airbreathing catfishes').
ncbi_mult_taxo_gbnm(31010, 'squarehead catfishes').
ncbi_mult_taxo_gbnm(31011, 'whalelike catfishes').
ncbi_mult_taxo_gbnm(31012, 'callichthyid armored catfishes').
ncbi_mult_taxo_gbnm(31013, 'bagrid catfishes').
ncbi_mult_taxo_gbnm(31014, 'bottlenose catfishes').
ncbi_mult_taxo_gbnm(31016, 'banjo catfishes').
ncbi_mult_taxo_gbnm(31017, 'sea catfishes').
ncbi_mult_taxo_gbnm(31018, 'loach catfishes').
ncbi_mult_taxo_gbnm(31019, 'torrent catfishes').
ncbi_mult_taxo_gbnm(31020, 'stream catfishes').
ncbi_mult_taxo_gbnm(31022, 'pufferfishes and others').
ncbi_mult_taxo_gbnm(31024, triggerfishes).
ncbi_mult_taxo_gbnm(31025, boxfishes).
ncbi_mult_taxo_gbnm(31026, spikefishes).
ncbi_mult_taxo_gbnm(31027, triplespines).
ncbi_mult_taxo_gbnm(31029, molas).
ncbi_mult_taxo_gbnm(31031, puffers).
ncbi_mult_taxo_gbnm(31033, torafugu).
ncbi_mult_taxo_gbnm(31034, porcupinefishes).
ncbi_mult_taxo_gbnm(31087, 'finless sole').
ncbi_mult_taxo_gbnm(31090, mooneyes).
ncbi_mult_taxo_gbnm(31091, featherbacks).
ncbi_mult_taxo_gbnm(31092, elephantfishes).
ncbi_mult_taxo_gbnm(31097, 'dories and others').
ncbi_mult_taxo_gbnm(31098, boarfishes).
ncbi_mult_taxo_gbnm(31099, grammicolepidids).
ncbi_mult_taxo_gbnm(31101, oreos).
ncbi_mult_taxo_gbnm(31103, dories).
ncbi_mult_taxo_gbnm(31136, 'Nile bichir').
ncbi_mult_taxo_gbnm(31140, 'Galapagos land iguana').
ncbi_mult_taxo_gbnm(31142, 'Dhaman').
ncbi_mult_taxo_gbnm(31143, 'Japanese ratsnake').
ncbi_mult_taxo_gbnm(31155, adder).
ncbi_mult_taxo_gbnm(31156, 'common viper').
ncbi_mult_taxo_gbnm(31157, 'Dinnik\'s viper').
ncbi_mult_taxo_gbnm(31162, 'graceful small-headed seasnake').
ncbi_mult_taxo_gbnm(31180, 'pencil urchin').
ncbi_mult_taxo_gbnm(31186, 'sand dollars').
ncbi_mult_taxo_gbnm(31194, 'date mussels').
ncbi_mult_taxo_gbnm(31199, 'bay scallop').
ncbi_mult_taxo_gbnm(31210, 'golden cuttlefish').
ncbi_mult_taxo_gbnm(31245, 'blood flukes').
ncbi_mult_taxo_gbnm(31525, 'Epstein-Barr virus (strain CAO)').
ncbi_mult_taxo_gbnm(31869, 'aye-aye').
ncbi_mult_taxo_gbnm(31908, 'Eurasian oystercatcher').
ncbi_mult_taxo_gbnm(31911, 'Cape ghost frog').
ncbi_mult_taxo_gbnm(31919, 'Eurasian curlew').
ncbi_mult_taxo_gbnm(31969, mycoplasmas).
ncbi_mult_taxo_gbnm(32071, spleenworts).
ncbi_mult_taxo_gbnm(32088, 'hay-scented fern').
ncbi_mult_taxo_gbnm(32101, 'common bracken').
ncbi_mult_taxo_gbnm(32168, 'delta maidenhair fern').
ncbi_mult_taxo_gbnm(32171, 'claw ferns').
ncbi_mult_taxo_gbnm(32172, 'Japanese claw fern').
ncbi_mult_taxo_gbnm(32198, 'black-eyed Susan vine').
ncbi_mult_taxo_gbnm(32199, 'aphid P-endosymbionts').
ncbi_mult_taxo_gbnm(32202, 'red mulberry').
ncbi_mult_taxo_gbnm(32237, osoberry).
ncbi_mult_taxo_gbnm(32241, 'bitter cherry').
ncbi_mult_taxo_gbnm(32242, 'cherry laurel').
ncbi_mult_taxo_gbnm(32243, bitterbrush).
ncbi_mult_taxo_gbnm(32247, 'red raspberry').
ncbi_mult_taxo_gbnm(32258, 'winged sumac').
ncbi_mult_taxo_gbnm(32262, 'spider mites').
ncbi_mult_taxo_gbnm(32264, 'two-spotted spider mite').
ncbi_mult_taxo_gbnm(32434, 'twirler moths').
ncbi_mult_taxo_gbnm(32443, 'teleost fishes').
ncbi_mult_taxo_gbnm(32446, 'herrings and anchovies').
ncbi_mult_taxo_gbnm(32458, 'red rainbowfish').
ncbi_mult_taxo_gbnm(32464, 'Palenque priapella').
ncbi_mult_taxo_gbnm(32465, 'Isthmian priapella').
ncbi_mult_taxo_gbnm(32466, 'Olmec priapella').
ncbi_mult_taxo_gbnm(32467, 'Chiapas swordtail').
ncbi_mult_taxo_gbnm(32468, 'spiketail swordfish').
ncbi_mult_taxo_gbnm(32469, 'sheepshead swordtail').
ncbi_mult_taxo_gbnm(32470, 'yellow swordtail').
ncbi_mult_taxo_gbnm(32471, 'short-sword platyfish').
ncbi_mult_taxo_gbnm(32472, 'delicate swordtail').
ncbi_mult_taxo_gbnm(32473, 'Monterrey platyfish').
ncbi_mult_taxo_gbnm(32474, 'Puebla platyfish').
ncbi_mult_taxo_gbnm(32475, 'northern platyfish').
ncbi_mult_taxo_gbnm(32476, 'highland swordtail').
ncbi_mult_taxo_gbnm(32477, 'marbled swordtail').
ncbi_mult_taxo_gbnm(32478, 'Catemaco platyfish').
ncbi_mult_taxo_gbnm(32479, 'Montezuma swordtail').
ncbi_mult_taxo_gbnm(32481, 'mountain swordtail').
ncbi_mult_taxo_gbnm(32482, 'Panuco swordtail').
ncbi_mult_taxo_gbnm(32483, 'pygmy swordtail').
ncbi_mult_taxo_gbnm(32484, 'variable platyfish').
ncbi_mult_taxo_gbnm(32488, 'giant cichlid').
ncbi_mult_taxo_gbnm(32490, 'slender tail hap').
ncbi_mult_taxo_gbnm(32523, tetrapods).
ncbi_mult_taxo_gbnm(32524, amniotes).
ncbi_mult_taxo_gbnm(32534, 'Ethiopian wolf').
ncbi_mult_taxo_gbnm(32536, cheetah).
ncbi_mult_taxo_gbnm(32538, ocelot).
ncbi_mult_taxo_gbnm(32542, 'Crest-tailed Mulgara').
ncbi_mult_taxo_gbnm(32544, kowari).
ncbi_mult_taxo_gbnm(32545, 'New Guinean quoll').
ncbi_mult_taxo_gbnm(32546, 'bronze quoll').
ncbi_mult_taxo_gbnm(32549, 'three-striped marsupial mouse').
ncbi_mult_taxo_gbnm(32551, 'long-clawed marsupial mouse').
ncbi_mult_taxo_gbnm(32553, 'Wongai ningaui').
ncbi_mult_taxo_gbnm(32554, 'southern ningaui').
ncbi_mult_taxo_gbnm(32556, 'flat-skulled marsupial mouse').
ncbi_mult_taxo_gbnm(32557, 'flat-skulled marsupial mouse').
ncbi_mult_taxo_gbnm(32558, 'ningbing antechinus').
ncbi_mult_taxo_gbnm(32559, 'Woolley\'s pseudantechinus').
ncbi_mult_taxo_gbnm(32560, 'narrow-footed marsupial mouse').
ncbi_mult_taxo_gbnm(32561, diapsids).
ncbi_mult_taxo_gbnm(32584, 'tusk shells').
ncbi_mult_taxo_gbnm(32638, curlews).
ncbi_mult_taxo_gbnm(33083, 'cellular slime molds').
ncbi_mult_taxo_gbnm(33109, witchgrass).
ncbi_mult_taxo_gbnm(33113, belladonna).
ncbi_mult_taxo_gbnm(33117, mandrake).
ncbi_mult_taxo_gbnm(33118, 'shoo-fly plant').
ncbi_mult_taxo_gbnm(33119, 'large white petunia').
ncbi_mult_taxo_gbnm(33120, 'Japanese lantern').
ncbi_mult_taxo_gbnm(33121, 'painted tongue').
ncbi_mult_taxo_gbnm(33122, 'butterfly flower').
ncbi_mult_taxo_gbnm(33128, 'corn poppy').
ncbi_mult_taxo_gbnm(33129, 'tepary bean').
ncbi_mult_taxo_gbnm(33152, 'Chinese ephedra').
ncbi_mult_taxo_gbnm(33208, animals).
ncbi_mult_taxo_gbnm(33310, 'horsehair worms').
ncbi_mult_taxo_gbnm(33313, gastrotrichs).
ncbi_mult_taxo_gbnm(33343, bugs).
ncbi_mult_taxo_gbnm(33361, planthoppers).
ncbi_mult_taxo_gbnm(33375, psyllids).
ncbi_mult_taxo_gbnm(33377, whiteflies).
ncbi_mult_taxo_gbnm(33380, aphids).
ncbi_mult_taxo_gbnm(33381, 'scale insects').
ncbi_mult_taxo_gbnm(33383, 'pine & spruce aphids').
ncbi_mult_taxo_gbnm(33384, phylloxerans).
ncbi_mult_taxo_gbnm(33396, 'blueberry fruit fly').
ncbi_mult_taxo_gbnm(33406, 'gall midges').
ncbi_mult_taxo_gbnm(33408, 'Asian rice gall midge').
ncbi_mult_taxo_gbnm(33412, 'dogface butterfly').
ncbi_mult_taxo_gbnm(33414, 'Douglas fir tussock moth').
ncbi_mult_taxo_gbnm(33415, brushfoots).
ncbi_mult_taxo_gbnm(33431, 'crimson-patched longwing').
ncbi_mult_taxo_gbnm(33434, 'zebra longwing').
ncbi_mult_taxo_gbnm(33453, 'julia butterfly').
ncbi_mult_taxo_gbnm(33464, 'ermine moths').
ncbi_mult_taxo_gbnm(33465, 'European small ermine moth').
ncbi_mult_taxo_gbnm(33466, 'apple ermine moth').
ncbi_mult_taxo_gbnm(33467, priapulids).
ncbi_mult_taxo_gbnm(33519, 'eastern rainbowfish').
ncbi_mult_taxo_gbnm(33520, 'Amargosa pupfish').
ncbi_mult_taxo_gbnm(33521, 'plains killifish').
ncbi_mult_taxo_gbnm(33522, 'Railroad Valley springfish').
ncbi_mult_taxo_gbnm(33524, 'goldbreast splitfin').
ncbi_mult_taxo_gbnm(33526, 'splotched skiffia').
ncbi_mult_taxo_gbnm(33528, 'western mosquitofish').
ncbi_mult_taxo_gbnm(33529, 'brownspotted killifish').
ncbi_mult_taxo_gbnm(33532, 'Pahrump poolfish').
ncbi_mult_taxo_gbnm(33536, 'striped shiner').
ncbi_mult_taxo_gbnm(33539, 'common shiner').
ncbi_mult_taxo_gbnm(33540, 'rosyface shiner').
ncbi_mult_taxo_gbnm(33541, 'whitespotted clarias').
ncbi_mult_taxo_gbnm(33543, 'long-beaked echidna').
ncbi_mult_taxo_gbnm(33544, 'Brazilian big-eyed bat').
ncbi_mult_taxo_gbnm(33545, 'Guadeloupe big-eyed bat').
ncbi_mult_taxo_gbnm(33546, 'hairy big-eyed bat').
ncbi_mult_taxo_gbnm(33548, 'mantled guereza').
ncbi_mult_taxo_gbnm(33550, 'guinea pigs and others').
ncbi_mult_taxo_gbnm(33552, 'Porteous\'s tuco-tuco').
ncbi_mult_taxo_gbnm(33553, squirrels).
ncbi_mult_taxo_gbnm(33554, carnivores).
ncbi_mult_taxo_gbnm(33556, 'Antarctic minke whale').
ncbi_mult_taxo_gbnm(33558, 'Chilean shrew opossums').
ncbi_mult_taxo_gbnm(33559, 'Chilean shrew opossum').
ncbi_mult_taxo_gbnm(33560, 'little red kaluta').
ncbi_mult_taxo_gbnm(33562, 'monito del monte').
ncbi_mult_taxo_gbnm(33563, 'Barbour\'s map turtle').
ncbi_mult_taxo_gbnm(33571, 'false map turtle').
ncbi_mult_taxo_gbnm(33576, 'Puna ibis').
ncbi_mult_taxo_gbnm(33578, 'African spoonbill').
ncbi_mult_taxo_gbnm(33581, hamerkop).
ncbi_mult_taxo_gbnm(33584, shoebill).
ncbi_mult_taxo_gbnm(33586, 'yellow-billed stork').
ncbi_mult_taxo_gbnm(33587, 'wood stork').
ncbi_mult_taxo_gbnm(33591, 'Jabiru stork').
ncbi_mult_taxo_gbnm(33598, 'groove-billed ani').
ncbi_mult_taxo_gbnm(33601, 'squirrel cuckoo').
ncbi_mult_taxo_gbnm(33604, 'black-billed cuckoo').
ncbi_mult_taxo_gbnm(33606, 'lappet-faced vulture').
ncbi_mult_taxo_gbnm(33608, 'Egyptian vulture').
ncbi_mult_taxo_gbnm(33610, lammergeier).
ncbi_mult_taxo_gbnm(33612, 'lesser yellow-headed vulture').
ncbi_mult_taxo_gbnm(33614, 'black vulture').
ncbi_mult_taxo_gbnm(33616, 'California condor').
ncbi_mult_taxo_gbnm(33618, 'American white pelican').
ncbi_mult_taxo_gbnm(33630, alveolates).
ncbi_mult_taxo_gbnm(33634, heterokonts).
ncbi_mult_taxo_gbnm(33680, 'plasmodial slime molds').
ncbi_mult_taxo_gbnm(33708, 'Murine herpesvirus 68').
ncbi_mult_taxo_gbnm(33790, 'dwarf snakehead').
ncbi_mult_taxo_gbnm(33836, 'centric diatoms').
ncbi_mult_taxo_gbnm(33849, 'Raphid, pennate diatoms').
ncbi_mult_taxo_gbnm(33853, 'Araphid, pennate diatoms').
ncbi_mult_taxo_gbnm(33926, 'plant yellows agents').
ncbi_mult_taxo_gbnm(34165, 'Boston fern').
ncbi_mult_taxo_gbnm(34172, 'dwarf palmetto').
ncbi_mult_taxo_gbnm(34175, inchplant).
ncbi_mult_taxo_gbnm(34178, 'woody bamboo').
ncbi_mult_taxo_gbnm(34197, 'rose mandarin').
ncbi_mult_taxo_gbnm(34199, 'aloe-vera').
ncbi_mult_taxo_gbnm(34205, flag).
ncbi_mult_taxo_gbnm(34256, peppermint).
ncbi_mult_taxo_gbnm(34270, 'common lilac').
ncbi_mult_taxo_gbnm(34306, 'cocolmeca bean').
ncbi_mult_taxo_gbnm(34313, 'white-leaved marlock').
ncbi_mult_taxo_gbnm(34314, illyarie).
ncbi_mult_taxo_gbnm(34315, tallowwood).
ncbi_mult_taxo_gbnm(34316, 'Murray red gum').
ncbi_mult_taxo_gbnm(34318, 'white ironbark').
ncbi_mult_taxo_gbnm(34320, 'gympie messmate').
ncbi_mult_taxo_gbnm(34321, 'yellow stringybark').
ncbi_mult_taxo_gbnm(34322, 'bell-fruited mallee').
ncbi_mult_taxo_gbnm(34325, 'red-flowering gum').
ncbi_mult_taxo_gbnm(34328, 'yellow bloodwood').
ncbi_mult_taxo_gbnm(34329, 'lemon-scented gum').
ncbi_mult_taxo_gbnm(34340, 'subalpine fir').
ncbi_mult_taxo_gbnm(34384, dermatophytes).
ncbi_mult_taxo_gbnm(34395, 'black yeasts').
ncbi_mult_taxo_gbnm(34498, 'sea gooseberries').
ncbi_mult_taxo_gbnm(34510, 'cereal cyst nematode').
ncbi_mult_taxo_gbnm(34531, 'bobtail squids').
ncbi_mult_taxo_gbnm(34576, 'bellybutton nautilus').
ncbi_mult_taxo_gbnm(34587, 'black chiton').
ncbi_mult_taxo_gbnm(34607, 'Cayenne tick').
ncbi_mult_taxo_gbnm(34608, 'bont tick').
ncbi_mult_taxo_gbnm(34609, 'Gulf Coast tick').
ncbi_mult_taxo_gbnm(34610, 'tropical bont tick').
ncbi_mult_taxo_gbnm(34612, 'hedgehog tick').
ncbi_mult_taxo_gbnm(34613, 'castor bean tick').
ncbi_mult_taxo_gbnm(34615, 'taiga tick').
ncbi_mult_taxo_gbnm(34621, 'American dog tick').
ncbi_mult_taxo_gbnm(34632, 'brown dog tick').
ncbi_mult_taxo_gbnm(34638, 'western predatory mite').
ncbi_mult_taxo_gbnm(34643, 'cobweb weavers').
ncbi_mult_taxo_gbnm(34647, 'Indian red scorpion').
ncbi_mult_taxo_gbnm(34648, 'lesser Asian scorpion').
ncbi_mult_taxo_gbnm(34649, 'Chinese scorpion').
ncbi_mult_taxo_gbnm(34650, 'Pacific rock crab').
ncbi_mult_taxo_gbnm(34652, 'lubber grasshoppers').
ncbi_mult_taxo_gbnm(34666, 'large raspberry aphid').
ncbi_mult_taxo_gbnm(34667, 'long-horned beetles').
ncbi_mult_taxo_gbnm(34672, 'blister beetles').
ncbi_mult_taxo_gbnm(34676, 'northern blowfly').
ncbi_mult_taxo_gbnm(34678, 'buffalo fly').
ncbi_mult_taxo_gbnm(34680, 'hover flies').
ncbi_mult_taxo_gbnm(34683, 'rust flies').
ncbi_mult_taxo_gbnm(34687, 'soldier flies').
ncbi_mult_taxo_gbnm(34740, 'postman butterfly').
ncbi_mult_taxo_gbnm(34746, 'mantis lacewings').
ncbi_mult_taxo_gbnm(34770, 'milk shark').
ncbi_mult_taxo_gbnm(34771, 'longnose gar').
ncbi_mult_taxo_gbnm(34773, 'American shad').
ncbi_mult_taxo_gbnm(34774, alewife).
ncbi_mult_taxo_gbnm(34776, 'northern studfish').
ncbi_mult_taxo_gbnm(34777, 'golden topminnow').
ncbi_mult_taxo_gbnm(34778, 'starhead topminnow').
ncbi_mult_taxo_gbnm(34779, 'Gulf killifish').
ncbi_mult_taxo_gbnm(34780, killifish).
ncbi_mult_taxo_gbnm(34781, 'blackstripe topminnow').
ncbi_mult_taxo_gbnm(34782, 'blackspotted topminnow').
ncbi_mult_taxo_gbnm(34783, 'Pacific molly').
ncbi_mult_taxo_gbnm(34785, dragonet).
ncbi_mult_taxo_gbnm(34787, cunner).
ncbi_mult_taxo_gbnm(34790, 'ocellated icefish').
ncbi_mult_taxo_gbnm(34814, 'common dolphinfish').
ncbi_mult_taxo_gbnm(34816, 'striped sea-bass').
ncbi_mult_taxo_gbnm(34817, 'American plaice').
ncbi_mult_taxo_gbnm(34819, witch).
ncbi_mult_taxo_gbnm(34821, 'ocean perch').
ncbi_mult_taxo_gbnm(34823, 'Atlantic tomcod').
ncbi_mult_taxo_gbnm(34825, 'white sifaka').
ncbi_mult_taxo_gbnm(34828, 'mongoose lemur').
ncbi_mult_taxo_gbnm(34829, 'red-bellied lemur').
ncbi_mult_taxo_gbnm(34830, 'Allen\'s squirrel galago').
ncbi_mult_taxo_gbnm(34835, 'brush-tailed porcupines').
ncbi_mult_taxo_gbnm(34836, 'Asiatic brush-tailed porcupine').
ncbi_mult_taxo_gbnm(34837, 'long-tailed spiny rat').
ncbi_mult_taxo_gbnm(34838, 'Bolivian tuco-tuco').
ncbi_mult_taxo_gbnm(34839, 'long-tailed chinchilla').
ncbi_mult_taxo_gbnm(34841, 'Cuban hutias').
ncbi_mult_taxo_gbnm(34842, 'Desmarest\'s hutia').
ncbi_mult_taxo_gbnm(34844, 'North American porcupine').
ncbi_mult_taxo_gbnm(34845, agoutis).
ncbi_mult_taxo_gbnm(34846, 'punctate agouti').
ncbi_mult_taxo_gbnm(34854, 'Polynesian rat').
ncbi_mult_taxo_gbnm(34856, 'target rat').
ncbi_mult_taxo_gbnm(34858, 'Allen\'s wood mouse').
ncbi_mult_taxo_gbnm(34861, 'fox squirrel').
ncbi_mult_taxo_gbnm(34862, 'California ground squirrel').
ncbi_mult_taxo_gbnm(34865, 'Sumatran serow').
ncbi_mult_taxo_gbnm(34866, 'Taiwan serow').
ncbi_mult_taxo_gbnm(34869, chamois).
ncbi_mult_taxo_gbnm(34873, 'mountain goat').
ncbi_mult_taxo_gbnm(34880, 'raccoon dog').
ncbi_mult_taxo_gbnm(34882, 'sea otter').
ncbi_mult_taxo_gbnm(34884, 'northern fur seal').
ncbi_mult_taxo_gbnm(34886, 'Steller sea lion').
ncbi_mult_taxo_gbnm(34888, 'Hooker\'s sea lion').
ncbi_mult_taxo_gbnm(34890, 'spectacled porpoise').
ncbi_mult_taxo_gbnm(34892, 'Indo-Pacific finless porpoise').
ncbi_mult_taxo_gbnm(34893, 'common planigale').
ncbi_mult_taxo_gbnm(34896, 'long-tailed planigale').
ncbi_mult_taxo_gbnm(34897, 'Papuan planigale').
ncbi_mult_taxo_gbnm(34898, 'lesser gliding possums').
ncbi_mult_taxo_gbnm(34899, 'sugar glider').
ncbi_mult_taxo_gbnm(34903, 'red-eared slider turtle').
ncbi_mult_taxo_gbnm(34907, 'soft-shelled turtles').
ncbi_mult_taxo_gbnm(34912, 'American mud and musk turtles').
ncbi_mult_taxo_gbnm(34915, alligators).
ncbi_mult_taxo_gbnm(34919, 'Australian Sarus crane').
ncbi_mult_taxo_gbnm(34920, 'Indian Sarus crane').
ncbi_mult_taxo_gbnm(34921, 'Burmese Sarus crane').
ncbi_mult_taxo_gbnm(34923, magpies).
ncbi_mult_taxo_gbnm(34924, 'Eurasian magpie').
ncbi_mult_taxo_gbnm(34925, 'Green catbird').
ncbi_mult_taxo_gbnm(34926, 'streaked bowerbird').
ncbi_mult_taxo_gbnm(34929, 'tooth-billed bowerbird').
ncbi_mult_taxo_gbnm(34931, 'spotted bowerbird').
ncbi_mult_taxo_gbnm(34932, 'great bowerbird').
ncbi_mult_taxo_gbnm(34933, 'fawn-breasted bowerbird').
ncbi_mult_taxo_gbnm(34935, 'golden bowerbird').
ncbi_mult_taxo_gbnm(34937, 'regent bowerbird').
ncbi_mult_taxo_gbnm(34939, 'Archbold\'s bowerbird').
ncbi_mult_taxo_gbnm(34941, peppershrikes).
ncbi_mult_taxo_gbnm(34943, 'rufous-browed peppershrike').
ncbi_mult_taxo_gbnm(34944, 'shrike-vireos').
ncbi_mult_taxo_gbnm(34945, 'warbling vireo').
ncbi_mult_taxo_gbnm(34948, 'white-eyed vireo').
ncbi_mult_taxo_gbnm(34949, 'Philadelphia vireo').
ncbi_mult_taxo_gbnm(34950, 'solitary vireo').
ncbi_mult_taxo_gbnm(34953, 'gray vireo').
ncbi_mult_taxo_gbnm(34954, 'Bell\'s vireo').
ncbi_mult_taxo_gbnm(34956, 'black-whiskered vireo').
ncbi_mult_taxo_gbnm(34958, 'vireos and greenlets').
ncbi_mult_taxo_gbnm(34960, 'slaty-capped shrike-vireo').
ncbi_mult_taxo_gbnm(34977, 'slender blind snakes').
ncbi_mult_taxo_gbnm(34984, 'true pythons').
ncbi_mult_taxo_gbnm(35005, 'Western terrestrial garter snake').
ncbi_mult_taxo_gbnm(35007, 'Mexican wandering garter snake').
ncbi_mult_taxo_gbnm(35016, 'narrowhead garter snake').
ncbi_mult_taxo_gbnm(35017, 'Eastern ribbonsnake').
ncbi_mult_taxo_gbnm(35020, 'Pacific garter snake').
ncbi_mult_taxo_gbnm(35024, 'timber rattlesnake').
ncbi_mult_taxo_gbnm(35046, 'flat-backed toad').
ncbi_mult_taxo_gbnm(35052, 'daisy brittle star').
ncbi_mult_taxo_gbnm(35069, crinoids).
ncbi_mult_taxo_gbnm(35073, 'feather stars').
ncbi_mult_taxo_gbnm(35122, 'giant kelp').
ncbi_mult_taxo_gbnm(35131, 'slime nets').
ncbi_mult_taxo_gbnm(35246, 'Simian varicella virus').
ncbi_mult_taxo_gbnm(35252, 'wildebeest herpesvirus').
ncbi_mult_taxo_gbnm(35531, 'southwestern Asian house mouse').
ncbi_mult_taxo_gbnm(35538, 'rock parrot').
ncbi_mult_taxo_gbnm(35540, 'ground parrot').
ncbi_mult_taxo_gbnm(35543, 'western rosella').
ncbi_mult_taxo_gbnm(35546, 'regent parrot').
ncbi_mult_taxo_gbnm(35549, cockatoos).
ncbi_mult_taxo_gbnm(35552, 'red-tailed black cockatoo').
ncbi_mult_taxo_gbnm(35566, 'mouse tick').
ncbi_mult_taxo_gbnm(35570, 'stable fly').
ncbi_mult_taxo_gbnm(35581, myxozoans).
ncbi_mult_taxo_gbnm(35582, myxosporidians).
ncbi_mult_taxo_gbnm(35608, 'sweet wormwood').
ncbi_mult_taxo_gbnm(35610, lories).
ncbi_mult_taxo_gbnm(35625, 'Hindu datura').
ncbi_mult_taxo_gbnm(35628, 'Townsville stylo').
ncbi_mult_taxo_gbnm(35632, 'humus earthworm').
ncbi_mult_taxo_gbnm(35634, 'chewing lice').
ncbi_mult_taxo_gbnm(35635, 'mammal chewing lice').
ncbi_mult_taxo_gbnm(35657, 'bighead catfish').
ncbi_mult_taxo_gbnm(35658, 'southern multimammate mouse').
ncbi_mult_taxo_gbnm(35659, 'South Texas pocket gopher').
ncbi_mult_taxo_gbnm(35660, 'northern pocket gopher').
ncbi_mult_taxo_gbnm(35663, 'Cherrie\'s pocket gopher').
ncbi_mult_taxo_gbnm(35666, 'Underwood\'s pocket gopher').
ncbi_mult_taxo_gbnm(35668, tuza).
ncbi_mult_taxo_gbnm(35669, 'herring gull').
ncbi_mult_taxo_gbnm(35670, 'Indian cobra').
ncbi_mult_taxo_gbnm(35671, 'Ussuri mamushi').
ncbi_mult_taxo_gbnm(35706, 'timber bamboo').
ncbi_mult_taxo_gbnm(35708, 'giant reed').
ncbi_mult_taxo_gbnm(35711, cutgrass).
ncbi_mult_taxo_gbnm(35712, 'rice cutgrass').
ncbi_mult_taxo_gbnm(35716, 'Chilean mesquite').
ncbi_mult_taxo_gbnm(35730, 'dusky notothen').
ncbi_mult_taxo_gbnm(35732, 'Oriental house rat').
ncbi_mult_taxo_gbnm(35736, 'Bobrinski\'s jerboa').
ncbi_mult_taxo_gbnm(35739, 'Lichtenstein\'s jerboa').
ncbi_mult_taxo_gbnm(35845, 'mermaid\'s wine glass').
ncbi_mult_taxo_gbnm(35872, buffelgrass).
ncbi_mult_taxo_gbnm(35874, 'air-potato').
ncbi_mult_taxo_gbnm(35875, 'Welsh onion').
ncbi_mult_taxo_gbnm(35883, 'Japanese morning glory').
ncbi_mult_taxo_gbnm(35885, 'trilobed morning glory').
ncbi_mult_taxo_gbnm(35922, 'four-winged saltbush').
ncbi_mult_taxo_gbnm(35924, 'Chinese peony').
ncbi_mult_taxo_gbnm(35925, 'kaki persimmon').
ncbi_mult_taxo_gbnm(35926, 'mountain papaya').
ncbi_mult_taxo_gbnm(35927, 'woolly Dutchman\'s pipe').
ncbi_mult_taxo_gbnm(35936, 'hyacinth bean').
ncbi_mult_taxo_gbnm(35968, 'mountain shadbush').
ncbi_mult_taxo_gbnm(35973, sandalwoods).
ncbi_mult_taxo_gbnm(35974, 'white sandalwood').
ncbi_mult_taxo_gbnm(36014, popote).
ncbi_mult_taxo_gbnm(36046, 'hart\'s truffles').
ncbi_mult_taxo_gbnm(36048, truffles).
ncbi_mult_taxo_gbnm(36049, 'Burgundy truffle').
ncbi_mult_taxo_gbnm(36066, chanterelle).
ncbi_mult_taxo_gbnm(36087, 'human whipworm').
ncbi_mult_taxo_gbnm(36092, 'Australian abalone').
ncbi_mult_taxo_gbnm(36096, 'paua abalone').
ncbi_mult_taxo_gbnm(36097, 'greenlip abalone').
ncbi_mult_taxo_gbnm(36098, 'perlemoen abalone').
ncbi_mult_taxo_gbnm(36100, 'blacklip abalone').
ncbi_mult_taxo_gbnm(36101, 'staircase abalone').
ncbi_mult_taxo_gbnm(36103, 'green ormer').
ncbi_mult_taxo_gbnm(36108, 'Pompeii worms').
ncbi_mult_taxo_gbnm(36141, 'smooth springtails').
ncbi_mult_taxo_gbnm(36161, 'water striders').
ncbi_mult_taxo_gbnm(36163, 'common water strider').
ncbi_mult_taxo_gbnm(36164, 'humpbacked flies').
ncbi_mult_taxo_gbnm(36170, 'red bulldog ant').
ncbi_mult_taxo_gbnm(36176, 'whitespotted bambooshark').
ncbi_mult_taxo_gbnm(36177, 'Atlantic sturgeon').
ncbi_mult_taxo_gbnm(36178, 'pallid sturgeon').
ncbi_mult_taxo_gbnm(36179, 'Alabama sturgeon').
ncbi_mult_taxo_gbnm(36180, vendace).
ncbi_mult_taxo_gbnm(36181, cisco).
ncbi_mult_taxo_gbnm(36183, 'Bonneville whitefish').
ncbi_mult_taxo_gbnm(36185, grayling).
ncbi_mult_taxo_gbnm(36188, 'Antarctic icefish').
ncbi_mult_taxo_gbnm(36190, 'blackfin icefish').
ncbi_mult_taxo_gbnm(36195, 'blunt scalyhead').
ncbi_mult_taxo_gbnm(36196, 'striped rockcod').
ncbi_mult_taxo_gbnm(36197, 'spotted notothen').
ncbi_mult_taxo_gbnm(36198, 'sharp-spined notothen').
ncbi_mult_taxo_gbnm(36200, 'Antarctic toothfish').
ncbi_mult_taxo_gbnm(36202, 'humped rockcod').
ncbi_mult_taxo_gbnm(36203, thornfishes).
ncbi_mult_taxo_gbnm(36205, thornfish).
ncbi_mult_taxo_gbnm(36206, 'barbeled plunderfishes').
ncbi_mult_taxo_gbnm(36212, 'Atlantic horse mackerel').
ncbi_mult_taxo_gbnm(36214, 'night sergeant').
ncbi_mult_taxo_gbnm(36215, 'Mexican nightsergeant').
ncbi_mult_taxo_gbnm(36216, 'night sergeant').
ncbi_mult_taxo_gbnm(36217, 'Panama sergeant major').
ncbi_mult_taxo_gbnm(36221, 'Antarctic eelpout').
ncbi_mult_taxo_gbnm(36223, 'red-tailed monkey').
ncbi_mult_taxo_gbnm(36224, 'Diana monkey').
ncbi_mult_taxo_gbnm(36225, 'blue monkey').
ncbi_mult_taxo_gbnm(36226, 'Mona monkey').
ncbi_mult_taxo_gbnm(36227, 'De Brazza\'s monkey').
ncbi_mult_taxo_gbnm(36228, 'white-nosed guenon').
ncbi_mult_taxo_gbnm(36229, 'Chacma baboon').
ncbi_mult_taxo_gbnm(36231, talapoin).
ncbi_mult_taxo_gbnm(36234, 'black spider monkey x brown-headed spider monkey').
ncbi_mult_taxo_gbnm(36239, 'least weasel').
ncbi_mult_taxo_gbnm(36240, 'Siberian weasel').
ncbi_mult_taxo_gbnm(36241, 'black stork').
ncbi_mult_taxo_gbnm(36243, 'eastern turtle dove').
ncbi_mult_taxo_gbnm(36245, 'common kingfisher').
ncbi_mult_taxo_gbnm(36247, 'Eurasian griffon').
ncbi_mult_taxo_gbnm(36248, 'Himalayan griffon').
ncbi_mult_taxo_gbnm(36249, 'Large-billed crow').
ncbi_mult_taxo_gbnm(36250, 'rustic bunting').
ncbi_mult_taxo_gbnm(36251, 'grey bunting').
ncbi_mult_taxo_gbnm(36255, brambling).
ncbi_mult_taxo_gbnm(36258, 'Indian tree pipit').
ncbi_mult_taxo_gbnm(36259, 'Wilson\'s bird of paradise').
ncbi_mult_taxo_gbnm(36260, 'brown sicklebill').
ncbi_mult_taxo_gbnm(36261, 'curl-crested manucode').
ncbi_mult_taxo_gbnm(36263, 'king bird of paradise').
ncbi_mult_taxo_gbnm(36265, 'twelve-wired bird of paradise').
ncbi_mult_taxo_gbnm(36267, 'blue bird of paradise').
ncbi_mult_taxo_gbnm(36268, 'Raggiana bird of paradise').
ncbi_mult_taxo_gbnm(36270, 'Old World warblers').
ncbi_mult_taxo_gbnm(36272, 'Japanese bush warbler').
ncbi_mult_taxo_gbnm(36273, 'Arctic warbler').
ncbi_mult_taxo_gbnm(36275, 'red-billed leiothrix').
ncbi_mult_taxo_gbnm(36278, 'Eurasian wren').
ncbi_mult_taxo_gbnm(36279, 'Japanese grey thrush').
ncbi_mult_taxo_gbnm(36280, 'brown-headed thrush').
ncbi_mult_taxo_gbnm(36281, 'eye-browed thrush').
ncbi_mult_taxo_gbnm(36282, 'pale thrush').
ncbi_mult_taxo_gbnm(36286, 'blue rock thrush').
ncbi_mult_taxo_gbnm(36288, 'Scaly Thrush').
ncbi_mult_taxo_gbnm(36291, 'Old World flycatchers').
ncbi_mult_taxo_gbnm(36293, 'narcissus flycatcher').
ncbi_mult_taxo_gbnm(36294, bulbuls).
ncbi_mult_taxo_gbnm(36297, 'white-eyes').
ncbi_mult_taxo_gbnm(36299, 'Japanese white-eye').
ncbi_mult_taxo_gbnm(36300, 'Dalmatian pelican').
ncbi_mult_taxo_gbnm(36303, 'pygmy woodpecker').
ncbi_mult_taxo_gbnm(36305, 'Ural owl').
ncbi_mult_taxo_gbnm(36306, 'Graphic spiny lizard').
ncbi_mult_taxo_gbnm(36307, 'Chinese moccasin').
ncbi_mult_taxo_gbnm(36309, 'Arizona black rattlesnake').
ncbi_mult_taxo_gbnm(36310, tokay).
ncbi_mult_taxo_gbnm(36312, 'Hokkaido salamander').
ncbi_mult_taxo_gbnm(36313, 'red-bellied newt').
ncbi_mult_taxo_gbnm(36314, 'California newt').
ncbi_mult_taxo_gbnm(36316, 'web-toed salamanders').
ncbi_mult_taxo_gbnm(36317, 'Ambrosi\'s cave salamander').
ncbi_mult_taxo_gbnm(36318, 'Sardinian cave salamander').
ncbi_mult_taxo_gbnm(36321, 'silky cucumber').
ncbi_mult_taxo_gbnm(36324, 'scarlet psolus').
ncbi_mult_taxo_gbnm(36330, 'malaria parasite P. ovale').
ncbi_mult_taxo_gbnm(36352, 'Epstein-Barr virus type 1').
ncbi_mult_taxo_gbnm(36592, 'messmate stringybark').
ncbi_mult_taxo_gbnm(36595, 'cherry plum').
ncbi_mult_taxo_gbnm(36596, apricot).
ncbi_mult_taxo_gbnm(36597, 'callery pear').
ncbi_mult_taxo_gbnm(36599, rowan).
ncbi_mult_taxo_gbnm(36601, whitebeam).
ncbi_mult_taxo_gbnm(36602, 'alder-leaved whitebeam').
ncbi_mult_taxo_gbnm(36604, 'Chinese flowering quince').
ncbi_mult_taxo_gbnm(36610, quince).
ncbi_mult_taxo_gbnm(36612, toyon).
ncbi_mult_taxo_gbnm(36616, medlar).
ncbi_mult_taxo_gbnm(36666, spittlebugs).
ncbi_mult_taxo_gbnm(36667, 'meadow spittlebug').
ncbi_mult_taxo_gbnm(36668, ants).
ncbi_mult_taxo_gbnm(36673, 'black ghost').
ncbi_mult_taxo_gbnm(36721, 'Japanese marten').
ncbi_mult_taxo_gbnm(36722, sable).
ncbi_mult_taxo_gbnm(36723, ermine).
ncbi_mult_taxo_gbnm(36725, 'scarlet-rumped tanager').
ncbi_mult_taxo_gbnm(36726, 'crimson-collared tanager').
ncbi_mult_taxo_gbnm(36727, 'yellow-rumped tanager').
ncbi_mult_taxo_gbnm(36728, 'Cherrie\'s tanager').
ncbi_mult_taxo_gbnm(36729, 'masked crimson tanager').
ncbi_mult_taxo_gbnm(36730, 'silver-beaked tanager').
ncbi_mult_taxo_gbnm(36731, 'Brazilian tanager').
ncbi_mult_taxo_gbnm(36733, 'summer tanager').
ncbi_mult_taxo_gbnm(36749, 'golden saxifrage').
ncbi_mult_taxo_gbnm(36757, 'alfalfa weevil').
ncbi_mult_taxo_gbnm(36758, 'clover leaf weevil').
ncbi_mult_taxo_gbnm(36759, 'Egyptian alfalfa weevil').
ncbi_mult_taxo_gbnm(36763, 'horntail wasps').
ncbi_mult_taxo_gbnm(36774, broccoli).
ncbi_mult_taxo_gbnm(36777, 'Russian olive').
ncbi_mult_taxo_gbnm(36786, 'rosefin shiner').
ncbi_mult_taxo_gbnm(36787, 'ribbon shiner').
ncbi_mult_taxo_gbnm(36788, 'blacktip shiner').
ncbi_mult_taxo_gbnm(36789, 'Ouchita Mountain shiner').
ncbi_mult_taxo_gbnm(36790, 'mountain shiner').
ncbi_mult_taxo_gbnm(36791, 'redfin shiner').
ncbi_mult_taxo_gbnm(36792, 'pretty shiner').
ncbi_mult_taxo_gbnm(36794, 'pugnose minnow').
ncbi_mult_taxo_gbnm(36796, 'grassland melomys').
ncbi_mult_taxo_gbnm(36797, 'faun-footed melomys').
ncbi_mult_taxo_gbnm(36799, 'Thornton Peak uromys').
ncbi_mult_taxo_gbnm(36800, 'giant uromys').
ncbi_mult_taxo_gbnm(36801, 'white-toothed shrews').
ncbi_mult_taxo_gbnm(36802, 'white-toothed shrew').
ncbi_mult_taxo_gbnm(36803, 'cinereus shrew').
ncbi_mult_taxo_gbnm(36930, 'small rock oyster').
ncbi_mult_taxo_gbnm(36933, 'Celtic sea slug').
ncbi_mult_taxo_gbnm(36938, 'cassava green mite').
ncbi_mult_taxo_gbnm(36953, 'giant Madagascar hissing cockroach').
ncbi_mult_taxo_gbnm(36961, 'Surinam cockroach').
ncbi_mult_taxo_gbnm(36963, 'Madeira cockroach').
ncbi_mult_taxo_gbnm(36966, 'field cockroach').
ncbi_mult_taxo_gbnm(36975, 'Australian cockroach').
ncbi_mult_taxo_gbnm(36976, 'brown cockroach').
ncbi_mult_taxo_gbnm(36977, 'smokybrown cockroach').
ncbi_mult_taxo_gbnm(36981, 'Turkestan cockroach').
ncbi_mult_taxo_gbnm(36982, 'brown-hooded cockroach family').
ncbi_mult_taxo_gbnm(36984, 'brown-hooded cockroach').
ncbi_mult_taxo_gbnm(36985, 'subterranean termites').
ncbi_mult_taxo_gbnm(36987, 'Formosan subterranean termite').
ncbi_mult_taxo_gbnm(36989, 'eastern subterranean termite').
ncbi_mult_taxo_gbnm(36998, stainers).
ncbi_mult_taxo_gbnm(37003, 'mangrove rivulus').
ncbi_mult_taxo_gbnm(37005, 'Maori cod').
ncbi_mult_taxo_gbnm(37007, 'red mullet').
ncbi_mult_taxo_gbnm(37014, 'Andean pygmy rice rat').
ncbi_mult_taxo_gbnm(37015, 'Chacoan pygmy rice rat').
ncbi_mult_taxo_gbnm(37017, 'Black-footed pygmy rice rat').
ncbi_mult_taxo_gbnm(37018, 'sprightly pygmy rice rat').
ncbi_mult_taxo_gbnm(37020, 'marsh rice rat').
ncbi_mult_taxo_gbnm(37022, 'Flavescent Oryzomys').
ncbi_mult_taxo_gbnm(37025, 'forest small rice rat').
ncbi_mult_taxo_gbnm(37029, 'leopard cat').
ncbi_mult_taxo_gbnm(37030, 'Iriomote cat').
ncbi_mult_taxo_gbnm(37032, meerkat).
ncbi_mult_taxo_gbnm(37035, 'Hector\'s dolphin').
ncbi_mult_taxo_gbnm(37039, 'great northern loon').
ncbi_mult_taxo_gbnm(37040, 'red-throated loon').
ncbi_mult_taxo_gbnm(37046, 'Neotropic cormorant').
ncbi_mult_taxo_gbnm(37051, 'Great shearwater').
ncbi_mult_taxo_gbnm(37052, 'Sooty shearwater').
ncbi_mult_taxo_gbnm(37064, 'Kerguelen petrel').
ncbi_mult_taxo_gbnm(37073, 'black-bellied storm-petrel').
ncbi_mult_taxo_gbnm(37075, 'white-faced storm-petrel').
ncbi_mult_taxo_gbnm(37080, 'Fiordland penguin').
ncbi_mult_taxo_gbnm(37081, 'Magellanic penguin').
ncbi_mult_taxo_gbnm(37083, 'Little blue penguin').
ncbi_mult_taxo_gbnm(37085, 'Yellow-eyed penguin').
ncbi_mult_taxo_gbnm(37088, 'Supramonte cave salamander').
ncbi_mult_taxo_gbnm(37104, trichomonads).
ncbi_mult_taxo_gbnm(37108, 'Turkey herpesvirus').
ncbi_mult_taxo_gbnm(37171, bontebok).
ncbi_mult_taxo_gbnm(37172, blesbok).
ncbi_mult_taxo_gbnm(37173, 'Long-tailed goral').
ncbi_mult_taxo_gbnm(37174, 'bighorn sheep').
ncbi_mult_taxo_gbnm(37176, muskox).
ncbi_mult_taxo_gbnm(37179, 'Himalayan tahr').
ncbi_mult_taxo_gbnm(37181, takin).
ncbi_mult_taxo_gbnm(37182, 'golden takin').
ncbi_mult_taxo_gbnm(37183, 'Mishmi takin').
ncbi_mult_taxo_gbnm(37185, 'blue antelope').
ncbi_mult_taxo_gbnm(37186, 'roan antelope').
ncbi_mult_taxo_gbnm(37189, 'sable antelope').
ncbi_mult_taxo_gbnm(37190, 'antarctic fur seal').
ncbi_mult_taxo_gbnm(37192, 'South African fur seal').
ncbi_mult_taxo_gbnm(37193, 'Australian fur seal').
ncbi_mult_taxo_gbnm(37194, 'subantarctic fur seal').
ncbi_mult_taxo_gbnm(37210, 'Samoan cup fern').
ncbi_mult_taxo_gbnm(37231, moonwort).
ncbi_mult_taxo_gbnm(37247, 'speckle-winged grasshopper').
ncbi_mult_taxo_gbnm(37248, 'red-winged grasshopper').
ncbi_mult_taxo_gbnm(37250, 'green-striped grasshopper').
ncbi_mult_taxo_gbnm(37252, 'dusky grasshopper').
ncbi_mult_taxo_gbnm(37257, 'mottled sand grasshopper').
ncbi_mult_taxo_gbnm(37259, 'blue-legged grasshopper').
ncbi_mult_taxo_gbnm(37261, 'clear-winged grasshopper').
ncbi_mult_taxo_gbnm(37263, 'Kiowa grasshopper').
ncbi_mult_taxo_gbnm(37265, 'Carolina grasshopper').
ncbi_mult_taxo_gbnm(37266, 'spur-throated grasshoppers').
ncbi_mult_taxo_gbnm(37267, 'migratory bird locusts').
ncbi_mult_taxo_gbnm(37270, 'Largespring gambusia').
ncbi_mult_taxo_gbnm(37271, 'Clear Creek gambusia').
ncbi_mult_taxo_gbnm(37272, 'Hispaniolan gambusia').
ncbi_mult_taxo_gbnm(37273, 'eastern mosquitofish').
ncbi_mult_taxo_gbnm(37274, 'Hubbs\'s gambusia').
ncbi_mult_taxo_gbnm(37275, 'crescent gambusia').
ncbi_mult_taxo_gbnm(37277, 'Mann\'s gambusia').
ncbi_mult_taxo_gbnm(37278, 'robust gambusia').
ncbi_mult_taxo_gbnm(37279, 'striped gambusia').
ncbi_mult_taxo_gbnm(37280, 'Nicaraguan gambusia').
ncbi_mult_taxo_gbnm(37282, 'Panuco Basin gambusia').
ncbi_mult_taxo_gbnm(37283, 'Cuban gambusia').
ncbi_mult_taxo_gbnm(37284, 'Carribean gambusia').
ncbi_mult_taxo_gbnm(37285, 'Rachow\'s gambusia').
ncbi_mult_taxo_gbnm(37286, 'mangrove gambusia').
ncbi_mult_taxo_gbnm(37287, 'stippled gambusia').
ncbi_mult_taxo_gbnm(37288, 'Gulf gambusia').
ncbi_mult_taxo_gbnm(37289, 'Yucatan gambusia').
ncbi_mult_taxo_gbnm(37290, 'Wray\'s gambusia').
ncbi_mult_taxo_gbnm(37292, 'pike killifish').
ncbi_mult_taxo_gbnm(37293, 'Ma\'s night monkey').
ncbi_mult_taxo_gbnm(37295, 'weeper capuchin monkey').
ncbi_mult_taxo_gbnm(37316, 'southern white-breasted hedgehog').
ncbi_mult_taxo_gbnm(37334, pomelo).
ncbi_mult_taxo_gbnm(37344, 'coleseed sawfly').
ncbi_mult_taxo_gbnm(37347, 'northern tree shrew').
ncbi_mult_taxo_gbnm(37348, mammoths).
ncbi_mult_taxo_gbnm(37349, 'woolly mammoth').
ncbi_mult_taxo_gbnm(37358, plasmodiophorids).
ncbi_mult_taxo_gbnm(37427, 'Engelmann\'s quillwort').
ncbi_mult_taxo_gbnm(37429, 'shining club moss').
ncbi_mult_taxo_gbnm(37432, 'ground cedar').
ncbi_mult_taxo_gbnm(37435, 'Shaw\'s jird').
ncbi_mult_taxo_gbnm(37436, 'Wilson\'s spiny mouse').
ncbi_mult_taxo_gbnm(37438, 'long-eared mouse').
ncbi_mult_taxo_gbnm(37440, 'Michoacan deer mouse').
ncbi_mult_taxo_gbnm(37441, 'yellow-faced pocket gopher').
ncbi_mult_taxo_gbnm(37442, 'silky pocket mice').
ncbi_mult_taxo_gbnm(37443, 'silky pocket mouse').
ncbi_mult_taxo_gbnm(37445, 'Cape buffalo').
ncbi_mult_taxo_gbnm(37446, 'forest buffalo').
ncbi_mult_taxo_gbnm(37455, 'Ehrenberg\'s copper fern').
ncbi_mult_taxo_gbnm(37456, 'lip ferns').
ncbi_mult_taxo_gbnm(37458, 'golden cloak fern').
ncbi_mult_taxo_gbnm(37459, 'cloak ferns').
ncbi_mult_taxo_gbnm(37460, 'delicate cloak fern').
ncbi_mult_taxo_gbnm(37461, 'cliff brakes').
ncbi_mult_taxo_gbnm(37462, 'coffee fern').
ncbi_mult_taxo_gbnm(37469, 'American bloodworm').
ncbi_mult_taxo_gbnm(37491, 'winter aconites').
ncbi_mult_taxo_gbnm(37495, poinsettia).
ncbi_mult_taxo_gbnm(37510, 'Mueller\'s sea pansy').
ncbi_mult_taxo_gbnm(37512, 'tube anemones').
ncbi_mult_taxo_gbnm(37520, 'sea thread hydroid').
ncbi_mult_taxo_gbnm(37528, 'stalked jellyfishes').
ncbi_mult_taxo_gbnm(37536, 'upsidedown jellyfishes').
ncbi_mult_taxo_gbnm(37541, 'waved whelk').
ncbi_mult_taxo_gbnm(37547, 'southern armyworm').
ncbi_mult_taxo_gbnm(37548, 'Brazilian guinea pig').
ncbi_mult_taxo_gbnm(37550, 'Formosan sika deer').
ncbi_mult_taxo_gbnm(37565, 'common rue').
ncbi_mult_taxo_gbnm(37569, 'hawk-moths').
ncbi_mult_taxo_gbnm(37571, 'prominent moths').
ncbi_mult_taxo_gbnm(37572, butterflies).
ncbi_mult_taxo_gbnm(37576, oystercatchers).
ncbi_mult_taxo_gbnm(37578, 'northern gannet').
ncbi_mult_taxo_gbnm(37584, 'yucca and fairy moths').
ncbi_mult_taxo_gbnm(37588, 'Brazilian Bare-faced tamarin').
ncbi_mult_taxo_gbnm(37589, 'pied bare-faced tamarin').
ncbi_mult_taxo_gbnm(37591, 'Richardson\'s ground squirrel').
ncbi_mult_taxo_gbnm(37593, 'loggerhead musk turtle').
ncbi_mult_taxo_gbnm(37595, yellowhammer).
ncbi_mult_taxo_gbnm(37598, chaffinch).
ncbi_mult_taxo_gbnm(37600, 'Eurasian goldfinch').
ncbi_mult_taxo_gbnm(37601, 'European greenfinch').
ncbi_mult_taxo_gbnm(37602, 'European serin').
ncbi_mult_taxo_gbnm(37604, redpolls).
ncbi_mult_taxo_gbnm(37607, 'Eurasian bullfinch').
ncbi_mult_taxo_gbnm(37609, hawfinch).
ncbi_mult_taxo_gbnm(37610, 'European robin').
ncbi_mult_taxo_gbnm(37614, 'paradise whydah').
ncbi_mult_taxo_gbnm(37623, 'European flat oyster').
ncbi_mult_taxo_gbnm(37629, 'gyrodactylosis fluke').
ncbi_mult_taxo_gbnm(37645, 'figleaf gourd').
ncbi_mult_taxo_gbnm(37646, 'mixta squash').
ncbi_mult_taxo_gbnm(37651, 'Texas gourd').
ncbi_mult_taxo_gbnm(37652, 'Verill\'s two-spot octopus').
ncbi_mult_taxo_gbnm(37653, 'California two-spot octopus').
ncbi_mult_taxo_gbnm(37660, 'Caribbean stylo').
ncbi_mult_taxo_gbnm(37690, 'trifoliate orange').
ncbi_mult_taxo_gbnm(37696, 'silky shrew opossum').
ncbi_mult_taxo_gbnm(37698, 'northern brown bandicoot').
ncbi_mult_taxo_gbnm(37699, 'marsupial mole').
ncbi_mult_taxo_gbnm(37702, 'coppery ringtail possum').
ncbi_mult_taxo_gbnm(37721, 'rattlesnake brome').
ncbi_mult_taxo_gbnm(37723, 'tufted hair grass').
ncbi_mult_taxo_gbnm(37736, 'short-furred dasyure').
ncbi_mult_taxo_gbnm(37737, 'eastern barred bandicoot').
ncbi_mult_taxo_gbnm(37751, 'Dorcas gazelle').
ncbi_mult_taxo_gbnm(37776, 'Indian moon moth').
ncbi_mult_taxo_gbnm(37806, 'acorn barnacles').
ncbi_mult_taxo_gbnm(37812, 'wood cockroaches').
ncbi_mult_taxo_gbnm(37813, 'Pennsylvania wood cockroach').
ncbi_mult_taxo_gbnm(37886, 'common shrew-opossums').
ncbi_mult_taxo_gbnm(37888, 'short-nosed bandicoots').
ncbi_mult_taxo_gbnm(37889, 'ring-tailed possums').
ncbi_mult_taxo_gbnm(37897, 'star barnacles').
ncbi_mult_taxo_gbnm(37949, 'four-eye butterflyfish').
ncbi_mult_taxo_gbnm(38010, 'goose barnacles').
ncbi_mult_taxo_gbnm(38038, 'leaf blotch of barley').
ncbi_mult_taxo_gbnm(38058, 'purple-lined sallow').
ncbi_mult_taxo_gbnm(38060, 'arcigera flower moth').
ncbi_mult_taxo_gbnm(38085, 'periodical cicadas').
ncbi_mult_taxo_gbnm(38086, 'seventeen-year cicada').
ncbi_mult_taxo_gbnm(38092, 'oak treehopper').
ncbi_mult_taxo_gbnm(38099, 'giant water bugs').
ncbi_mult_taxo_gbnm(38102, 'toad bugs').
ncbi_mult_taxo_gbnm(38106, 'scentless plant bugs').
ncbi_mult_taxo_gbnm(38111, 'horned gall aphid').
ncbi_mult_taxo_gbnm(38115, 'cochineal scales').
ncbi_mult_taxo_gbnm(38121, 'pecan leaf phylloxera').
ncbi_mult_taxo_gbnm(38123, 'hackberry petiole gall psyllid').
ncbi_mult_taxo_gbnm(38128, 'damp barklice').
ncbi_mult_taxo_gbnm(38132, 'predacious thrips').
ncbi_mult_taxo_gbnm(38149, 'Gulf stone crab').
ncbi_mult_taxo_gbnm(38151, 'Arizona spittle bug').
ncbi_mult_taxo_gbnm(38181, 'hyacinth orchid').
ncbi_mult_taxo_gbnm(38185, 'lady-of-the-night').
ncbi_mult_taxo_gbnm(38191, 'pink lady\'s slipper').
ncbi_mult_taxo_gbnm(38241, 'short-finned pilot whale').
ncbi_mult_taxo_gbnm(38243, 'bronze-tailed skink').
ncbi_mult_taxo_gbnm(38244, 'blue-tailed skink').
ncbi_mult_taxo_gbnm(38281, 'magnificent sea anemone').
ncbi_mult_taxo_gbnm(38354, 'Appalachian polypody').
ncbi_mult_taxo_gbnm(38390, 'licorice fern').
ncbi_mult_taxo_gbnm(38392, 'Hawaiian polypody').
ncbi_mult_taxo_gbnm(38393, 'leathery polypody').
ncbi_mult_taxo_gbnm(38394, 'Canary Islands polypody').
ncbi_mult_taxo_gbnm(38395, logrunners).
ncbi_mult_taxo_gbnm(38396, chowchillas).
ncbi_mult_taxo_gbnm(38397, 'northern chowchilla').
ncbi_mult_taxo_gbnm(38398, 'Atherton scrubwren').
ncbi_mult_taxo_gbnm(38399, 'Yellow-throated scrubwren').
ncbi_mult_taxo_gbnm(38408, 'Arizona pocket mouse').
ncbi_mult_taxo_gbnm(38409, 'San Joaquin pocket mouse').
ncbi_mult_taxo_gbnm(38414, 'weeping love grass').
ncbi_mult_taxo_gbnm(38415, 'Leakey\'s carpet viper').
ncbi_mult_taxo_gbnm(38489, ricegrass).
ncbi_mult_taxo_gbnm(38493, 'Mexican tree fern').
ncbi_mult_taxo_gbnm(38494, 'spiny-spored quillwort').
ncbi_mult_taxo_gbnm(38527, 'common bream').
ncbi_mult_taxo_gbnm(38538, 'shoestring fern').
ncbi_mult_taxo_gbnm(38563, 'Australasian robins').
ncbi_mult_taxo_gbnm(38564, 'thicket robins').
ncbi_mult_taxo_gbnm(38565, 'ashy robin').
ncbi_mult_taxo_gbnm(38577, 'Argentine toad').
ncbi_mult_taxo_gbnm(38592, 'Catherine\'s moss').
ncbi_mult_taxo_gbnm(38594, saltgrass).
ncbi_mult_taxo_gbnm(38596, bugle).
ncbi_mult_taxo_gbnm(38598, 'rufous rat-kangaroo').
ncbi_mult_taxo_gbnm(38600, 'mountain pygmy possum').
ncbi_mult_taxo_gbnm(38601, 'dormouse possums').
ncbi_mult_taxo_gbnm(38602, 'long-tailed pygmy possum').
ncbi_mult_taxo_gbnm(38603, 'tree kangaroos').
ncbi_mult_taxo_gbnm(38604, 'grizzled tree kangaroo').
ncbi_mult_taxo_gbnm(38612, 'feather-tailed possums').
ncbi_mult_taxo_gbnm(38614, 'New Guinean feather-tailed possum').
ncbi_mult_taxo_gbnm(38615, 'striped possums').
ncbi_mult_taxo_gbnm(38616, 'striped possum').
ncbi_mult_taxo_gbnm(38618, 'Leadbeater\'s possum').
ncbi_mult_taxo_gbnm(38620, 'thick-tailed opossum').
ncbi_mult_taxo_gbnm(38621, 'green ringtail possum').
ncbi_mult_taxo_gbnm(38622, cuscuses).
ncbi_mult_taxo_gbnm(38623, 'mountain cuscus').
ncbi_mult_taxo_gbnm(38624, koalas).
ncbi_mult_taxo_gbnm(38626, koala).
ncbi_mult_taxo_gbnm(38627, 'New Guinean bandicoots').
ncbi_mult_taxo_gbnm(38629, 'long-tailed bandicoot').
ncbi_mult_taxo_gbnm(38630, 'honey possums').
ncbi_mult_taxo_gbnm(38632, 'honey possum').
ncbi_mult_taxo_gbnm(38633, 'New Zealand wrens').
ncbi_mult_taxo_gbnm(38635, 'South Island wren').
ncbi_mult_taxo_gbnm(38651, 'Gray\'s biscuitroot').
ncbi_mult_taxo_gbnm(38652, 'slickrock biscuitroot').
ncbi_mult_taxo_gbnm(38653, 'white beach tiger beetle').
ncbi_mult_taxo_gbnm(38654, 'Chinese alligator').
ncbi_mult_taxo_gbnm(38656, 'black caiman').
ncbi_mult_taxo_gbnm(38658, 'Schneider\'s dwarf caiman').
ncbi_mult_taxo_gbnm(38659, 'sidestripe rasbora').
ncbi_mult_taxo_gbnm(38664, 'coarse-haired pocket mice').
ncbi_mult_taxo_gbnm(38665, 'hispid pocket mouse').
ncbi_mult_taxo_gbnm(38666, 'rock pocket mouse').
ncbi_mult_taxo_gbnm(38667, 'grasshopper mice').
ncbi_mult_taxo_gbnm(38668, 'northern grasshopper mouse').
ncbi_mult_taxo_gbnm(38669, 'little pocket mouse').
ncbi_mult_taxo_gbnm(38670, 'Merriam\'s pocket mouse').
ncbi_mult_taxo_gbnm(38671, 'Great Basin pocket mouse').
ncbi_mult_taxo_gbnm(38672, 'desert pocket mouse').
ncbi_mult_taxo_gbnm(38673, 'Sinaloan pocket mouse').
ncbi_mult_taxo_gbnm(38674, 'southern grasshopper mouse').
ncbi_mult_taxo_gbnm(38675, 'plains pocket mouse').
ncbi_mult_taxo_gbnm(38677, 'olive-backed pocket mouse').
ncbi_mult_taxo_gbnm(38678, 'long-tailed pocket mouse').
ncbi_mult_taxo_gbnm(38679, 'Chihuahuan grasshopper mouse').
ncbi_mult_taxo_gbnm(38689, 'moor grass').
ncbi_mult_taxo_gbnm(38695, 'perennial veldt grass').
ncbi_mult_taxo_gbnm(38705, 'moso bamboo').
ncbi_mult_taxo_gbnm(38706, 'Virginian cutgrass').
ncbi_mult_taxo_gbnm(38722, 'Manila grass').
ncbi_mult_taxo_gbnm(38727, switchgrass).
ncbi_mult_taxo_gbnm(38729, 'tiger grass').
ncbi_mult_taxo_gbnm(38730, dropseed).
ncbi_mult_taxo_gbnm(38731, 'smut grass').
ncbi_mult_taxo_gbnm(38735, 'wild oats').
ncbi_mult_taxo_gbnm(38750, 'Kerr\'s danio').
ncbi_mult_taxo_gbnm(38753, 'Tweedie\'s danio').
ncbi_mult_taxo_gbnm(38762, 'white cloud mountain minnow').
ncbi_mult_taxo_gbnm(38764, 'Atlantic hawksbill turtle').
ncbi_mult_taxo_gbnm(38772, 'Agassiz\'s desert tortoise').
ncbi_mult_taxo_gbnm(38773, 'Florida gopher tortoise').
ncbi_mult_taxo_gbnm(38775, 'yellow-footed antechinus').
ncbi_mult_taxo_gbnm(38776, 'red-tailed phascogale').
ncbi_mult_taxo_gbnm(38783, 'black oat').
ncbi_mult_taxo_gbnm(38784, 'European green alder').
ncbi_mult_taxo_gbnm(38787, 'downy birch').
ncbi_mult_taxo_gbnm(38791, 'yellow foxglove').
ncbi_mult_taxo_gbnm(38844, 'cypress spurge').
ncbi_mult_taxo_gbnm(38851, 'yellow gentian').
ncbi_mult_taxo_gbnm(38859, horsemint).
ncbi_mult_taxo_gbnm(38860, 'apple mint').
ncbi_mult_taxo_gbnm(38862, 'bog stars').
ncbi_mult_taxo_gbnm(38863, 'snowy mintbush').
ncbi_mult_taxo_gbnm(38865, 'sessile oak').
ncbi_mult_taxo_gbnm(38868, 'garden sage').
ncbi_mult_taxo_gbnm(38869, clary).
ncbi_mult_taxo_gbnm(38871, 'ash trees').
ncbi_mult_taxo_gbnm(38872, 'white ash').
ncbi_mult_taxo_gbnm(38873, 'European ash').
ncbi_mult_taxo_gbnm(38874, 'flowering ash').
ncbi_mult_taxo_gbnm(38887, 'short-bearded anole').
ncbi_mult_taxo_gbnm(38891, 'large-headed anole').
ncbi_mult_taxo_gbnm(38893, 'bark anole').
ncbi_mult_taxo_gbnm(38901, 'Cuban green anole').
ncbi_mult_taxo_gbnm(38914, 'bird-in-a-bush').
ncbi_mult_taxo_gbnm(38931, 'curly-tailed lizards').
ncbi_mult_taxo_gbnm(38934, 'common monkey lizard').
ncbi_mult_taxo_gbnm(38935, 'Haitian green anole').
ncbi_mult_taxo_gbnm(38937, 'Brown anole').
ncbi_mult_taxo_gbnm(38941, 'white seabream').
ncbi_mult_taxo_gbnm(38942, 'English oak').
ncbi_mult_taxo_gbnm(38949, 'greenshell mussel').
ncbi_mult_taxo_gbnm(39023, 'variable coral snake').
ncbi_mult_taxo_gbnm(39030, 'Eurasian field mouse').
ncbi_mult_taxo_gbnm(39031, 'Hawaiian butterflyfish').
ncbi_mult_taxo_gbnm(39032, 'atoll butterflyfish').
ncbi_mult_taxo_gbnm(39033, 'pearlscale butterflyfish').
ncbi_mult_taxo_gbnm(39037, 'Eritrean butterflyfish').
ncbi_mult_taxo_gbnm(39039, 'sunset butterflyfish').
ncbi_mult_taxo_gbnm(39040, 'spotband butterflyfish').
ncbi_mult_taxo_gbnm(39041, 'Asian butterflyfish').
ncbi_mult_taxo_gbnm(39042, 'threadfin butterflyfish').
ncbi_mult_taxo_gbnm(39043, 'peppered butterflyfish').
ncbi_mult_taxo_gbnm(39044, 'multi-banded butterflyfish').
ncbi_mult_taxo_gbnm(39045, 'millet butterflyfish').
ncbi_mult_taxo_gbnm(39053, 'American mastodon').
ncbi_mult_taxo_gbnm(39078, 'Mexican python').
ncbi_mult_taxo_gbnm(39080, 'Arizona coral snake').
ncbi_mult_taxo_gbnm(39082, 'hazel dormouse').
ncbi_mult_taxo_gbnm(39083, 'mole voles').
ncbi_mult_taxo_gbnm(39088, 'ribbon seal').
ncbi_mult_taxo_gbnm(39089, 'harp seal').
ncbi_mult_taxo_gbnm(39090, 'spotted seal').
ncbi_mult_taxo_gbnm(39095, 'wolf snakes').
ncbi_mult_taxo_gbnm(39096, 'Laotian wolf snake').
ncbi_mult_taxo_gbnm(39097, 'cave bear').
ncbi_mult_taxo_gbnm(39098, 'Seychelles butterflyfish').
ncbi_mult_taxo_gbnm(39099, 'Western rat snake').
ncbi_mult_taxo_gbnm(39110, 'southern puffer').
ncbi_mult_taxo_gbnm(39131, 'globular springtails').
ncbi_mult_taxo_gbnm(39166, dragonheads).
ncbi_mult_taxo_gbnm(39169, lavenders).
ncbi_mult_taxo_gbnm(39171, 'wild bergamots').
ncbi_mult_taxo_gbnm(39172, catmints).
ncbi_mult_taxo_gbnm(39173, basils).
ncbi_mult_taxo_gbnm(39174, marjorams).
ncbi_mult_taxo_gbnm(39176, 'self-heals').
ncbi_mult_taxo_gbnm(39249, figworts).
ncbi_mult_taxo_gbnm(39257, mulleins).
ncbi_mult_taxo_gbnm(39269, 'blue giant hyssop').
ncbi_mult_taxo_gbnm(39274, 'emperor dragonfly').
ncbi_mult_taxo_gbnm(39289, 'northern horsebalm').
ncbi_mult_taxo_gbnm(39293, 'hooded seal').
ncbi_mult_taxo_gbnm(39298, 'sea potato').
ncbi_mult_taxo_gbnm(39304, 'bearded seal').
ncbi_mult_taxo_gbnm(39309, 'Atlantic lizard').
ncbi_mult_taxo_gbnm(39310, 'Gallot\'s lizard').
ncbi_mult_taxo_gbnm(39311, 'Gran Canaria giant lizard').
ncbi_mult_taxo_gbnm(39313, 'red-tailed green ratsnake').
ncbi_mult_taxo_gbnm(39328, 'brown house snake').
ncbi_mult_taxo_gbnm(39338, 'common balm').
ncbi_mult_taxo_gbnm(39343, 'bee balm').
ncbi_mult_taxo_gbnm(39347, catnip).
ncbi_mult_taxo_gbnm(39350, 'sweet basil').
ncbi_mult_taxo_gbnm(39352, oregano).
ncbi_mult_taxo_gbnm(39358, 'self-heal').
ncbi_mult_taxo_gbnm(39367, rosemary).
ncbi_mult_taxo_gbnm(39376, 'cayenne snakeweed').
ncbi_mult_taxo_gbnm(39382, 'pink trumpet tree').
ncbi_mult_taxo_gbnm(39387, cowherb).
ncbi_mult_taxo_gbnm(39388, 'common mullein').
ncbi_mult_taxo_gbnm(39395, 'Jonah crab').
ncbi_mult_taxo_gbnm(39404, 'salmon-striped frog').
ncbi_mult_taxo_gbnm(39405, 'Centralian tree frog').
ncbi_mult_taxo_gbnm(39406, 'banded rainbowfish').
ncbi_mult_taxo_gbnm(39411, 'Arabian oryx').
ncbi_mult_taxo_gbnm(39413, 'common walking leaf frog').
ncbi_mult_taxo_gbnm(39414, 'narrow-leaved plantain').
ncbi_mult_taxo_gbnm(39416, 'Perigord truffle').
ncbi_mult_taxo_gbnm(39417, 'prostrate vervain').
ncbi_mult_taxo_gbnm(39432, 'Bolivian squirrel monkey').
ncbi_mult_taxo_gbnm(39442, 'eastern European house mouse').
ncbi_mult_taxo_gbnm(39466, 'fall webworm moth').
ncbi_mult_taxo_gbnm(39468, 'Turkey oak').
ncbi_mult_taxo_gbnm(39469, 'shingle oak').
ncbi_mult_taxo_gbnm(39472, 'Nigerian gerbil').
ncbi_mult_taxo_gbnm(39473, gherkin).
ncbi_mult_taxo_gbnm(39501, 'ti plant').
ncbi_mult_taxo_gbnm(39504, sotols).
ncbi_mult_taxo_gbnm(39505, 'spoon flower').
ncbi_mult_taxo_gbnm(39506, 'Texas sotol').
ncbi_mult_taxo_gbnm(39517, 'ponytail palms').
ncbi_mult_taxo_gbnm(39519, 'ponytail palm').
ncbi_mult_taxo_gbnm(39523, camases).
ncbi_mult_taxo_gbnm(39524, 'eastern camas').
ncbi_mult_taxo_gbnm(39526, 'cast-iron plant').
ncbi_mult_taxo_gbnm(39527, 'blue plantain lily').
ncbi_mult_taxo_gbnm(39528, lilyturfs).
ncbi_mult_taxo_gbnm(39529, 'big blue lilyturf').
ncbi_mult_taxo_gbnm(39534, 'snake plant').
ncbi_mult_taxo_gbnm(39535, 'small Solomon\'s seal').
ncbi_mult_taxo_gbnm(39536, 'grass trees').
ncbi_mult_taxo_gbnm(39537, 'grass tree').
ncbi_mult_taxo_gbnm(39550, yuccas).
ncbi_mult_taxo_gbnm(39551, 'soap tree').
ncbi_mult_taxo_gbnm(39552, 'Spanish dagger').
ncbi_mult_taxo_gbnm(39558, 'heavy marsh crab').
ncbi_mult_taxo_gbnm(39568, 'three-lips').
ncbi_mult_taxo_gbnm(39582, sifaka).
ncbi_mult_taxo_gbnm(39585, 'meadow spike moss').
ncbi_mult_taxo_gbnm(39589, 'argus reed frog').
ncbi_mult_taxo_gbnm(39590, 'spotted reed frog').
ncbi_mult_taxo_gbnm(39591, 'common reed frog').
ncbi_mult_taxo_gbnm(39598, 'three-color reed frog').
ncbi_mult_taxo_gbnm(39600, 'leaf-folding frog').
ncbi_mult_taxo_gbnm(39602, 'vermiculated tree frog').
ncbi_mult_taxo_gbnm(39603, 'Bagamoyo forest treefrog').
ncbi_mult_taxo_gbnm(39604, 'Witu forest treefrog').
ncbi_mult_taxo_gbnm(39610, 'African gray treefrog').
ncbi_mult_taxo_gbnm(39612, 'robust Buerger\'s frog').
ncbi_mult_taxo_gbnm(39615, 'Mexican bowstring hemp').
ncbi_mult_taxo_gbnm(39617, 'scrub jay').
ncbi_mult_taxo_gbnm(39621, 'great reed warbler').
ncbi_mult_taxo_gbnm(39630, 'mosquito ferns').
ncbi_mult_taxo_gbnm(39631, 'mosquito fern').
ncbi_mult_taxo_gbnm(39633, pillworts).
ncbi_mult_taxo_gbnm(39634, 'American pillwort').
ncbi_mult_taxo_gbnm(39638, 'red-winged blackbird').
ncbi_mult_taxo_gbnm(39639, daffodil).
ncbi_mult_taxo_gbnm(39682, 'Stejneger\'s pit viper').
ncbi_mult_taxo_gbnm(39699, 'shield-tailed snakes').
ncbi_mult_taxo_gbnm(39703, 'tomato leaf spot fungus').
ncbi_mult_taxo_gbnm(39704, 'Boettiger\'s reed frog').
ncbi_mult_taxo_gbnm(39705, 'Indian gray mongoose').
ncbi_mult_taxo_gbnm(39707, buckeyes).
ncbi_mult_taxo_gbnm(39708, buckeye).
ncbi_mult_taxo_gbnm(39758, 'Hessian fly').
ncbi_mult_taxo_gbnm(39789, 'Abdim\'s stork').
ncbi_mult_taxo_gbnm(39812, 'palm weevils').
ncbi_mult_taxo_gbnm(39814, 'broad-nosed weevils').
ncbi_mult_taxo_gbnm(39820, sandworms).
ncbi_mult_taxo_gbnm(39821, bloodworms).
ncbi_mult_taxo_gbnm(39833, 'Mexican spruce').
ncbi_mult_taxo_gbnm(39848, 'corn cockle').
ncbi_mult_taxo_gbnm(39855, 'scarlet lychnis').
ncbi_mult_taxo_gbnm(39858, 'flower of Jove').
ncbi_mult_taxo_gbnm(39862, 'cushion pink').
ncbi_mult_taxo_gbnm(39869, 'Bory\'s campion').
ncbi_mult_taxo_gbnm(39871, 'Burchell\'s campion').
ncbi_mult_taxo_gbnm(39879, 'red campion').
ncbi_mult_taxo_gbnm(39881, 'Elisabeth\'s campion').
ncbi_mult_taxo_gbnm(39893, 'Maheshwari\'s campion').
ncbi_mult_taxo_gbnm(39899, 'night-flowering catchfly').
ncbi_mult_taxo_gbnm(39906, 'royal catchfly').
ncbi_mult_taxo_gbnm(39907, 'Reinhold\'s campion').
ncbi_mult_taxo_gbnm(39908, 'Roemer\'s campion').
ncbi_mult_taxo_gbnm(39922, 'Waldstein\'s campion').
ncbi_mult_taxo_gbnm(39946, 'long-grained rice').
ncbi_mult_taxo_gbnm(39947, 'Japanese rice').
ncbi_mult_taxo_gbnm(39958, 'Superb bird of paradise').
ncbi_mult_taxo_gbnm(39961, 'Lawes\'s parotia').
ncbi_mult_taxo_gbnm(39963, 'red bird of paradise').
ncbi_mult_taxo_gbnm(39964, 'lesser bird of paradise').
ncbi_mult_taxo_gbnm(39968, 'blood lilies').
ncbi_mult_taxo_gbnm(39974, 'lilly-pilly').
ncbi_mult_taxo_gbnm(39975, 'sand-verbena myrtles').
ncbi_mult_taxo_gbnm(39988, leatherwoods).
ncbi_mult_taxo_gbnm(39989, leatherwood).
ncbi_mult_taxo_gbnm(39993, 'Indian almond').
ncbi_mult_taxo_gbnm(40002, 'meadow beauties').
ncbi_mult_taxo_gbnm(40003, 'Virginia meadow beauty').
ncbi_mult_taxo_gbnm(40008, 'glory bushes').
ncbi_mult_taxo_gbnm(40009, 'princess flower').
ncbi_mult_taxo_gbnm(40031, 'American mangrove').
ncbi_mult_taxo_gbnm(40037, 'longwings, fritillaries & silverspots').
ncbi_mult_taxo_gbnm(40040, 'tortoiseshells, admirals &c.').
ncbi_mult_taxo_gbnm(40071, 'forest tent caterpillar').
ncbi_mult_taxo_gbnm(40075, 'tawny emperor').
ncbi_mult_taxo_gbnm(40077, 'cloudless sulphur butterfly').
ncbi_mult_taxo_gbnm(40079, 'Mediterranean flour moth').
ncbi_mult_taxo_gbnm(40085, 'sugarcane borer').
ncbi_mult_taxo_gbnm(40090, 'buck moth').
ncbi_mult_taxo_gbnm(40093, skippers).
ncbi_mult_taxo_gbnm(40095, 'fiery skipper').
ncbi_mult_taxo_gbnm(40096, 'grass skippers').
ncbi_mult_taxo_gbnm(40099, 'yucca skipper').
ncbi_mult_taxo_gbnm(40100, 'spread-wing skippers').
ncbi_mult_taxo_gbnm(40101, 'checkered skipper').
ncbi_mult_taxo_gbnm(40104, 'sweetpotato hornworm').
ncbi_mult_taxo_gbnm(40128, 'wedge shells').
ncbi_mult_taxo_gbnm(40130, 'truncated wedgeshell').
ncbi_mult_taxo_gbnm(40146, 'Gulf sturgeon').
ncbi_mult_taxo_gbnm(40151, narwhal).
ncbi_mult_taxo_gbnm(40156, mannikins).
ncbi_mult_taxo_gbnm(40157, 'white-rumped munia').
ncbi_mult_taxo_gbnm(40169, 'Natron tilapia').
ncbi_mult_taxo_gbnm(40171, 'Alluaud\'s haplo').
ncbi_mult_taxo_gbnm(40177, 'Barbary partridge').
ncbi_mult_taxo_gbnm(40178, 'rock partridge').
ncbi_mult_taxo_gbnm(40179, 'Przewalski\'s partridge').
ncbi_mult_taxo_gbnm(40180, 'Arabian partridge').
ncbi_mult_taxo_gbnm(40181, 'Philby\'s partridge').
ncbi_mult_taxo_gbnm(40191, 'Singida tilapia').
ncbi_mult_taxo_gbnm(40193, 'Rufigi tilapia').
ncbi_mult_taxo_gbnm(40200, towhees).
ncbi_mult_taxo_gbnm(40202, 'green-tailed towhee').
ncbi_mult_taxo_gbnm(40203, 'white-throated towhee').
ncbi_mult_taxo_gbnm(40204, 'California towhee').
ncbi_mult_taxo_gbnm(40205, 'canyon towhee').
ncbi_mult_taxo_gbnm(40207, 'American tree sparrow').
ncbi_mult_taxo_gbnm(40208, 'Black-chinned sparrow').
ncbi_mult_taxo_gbnm(40209, 'Brewer\'s sparrow').
ncbi_mult_taxo_gbnm(40210, 'chipping sparrow').
ncbi_mult_taxo_gbnm(40211, 'clay-colored sparrow').
ncbi_mult_taxo_gbnm(40212, 'field sparrow').
ncbi_mult_taxo_gbnm(40213, juncos).
ncbi_mult_taxo_gbnm(40217, 'dark-eyed junco').
ncbi_mult_taxo_gbnm(40224, 'Gervais\' fruit-eating bat').
ncbi_mult_taxo_gbnm(40225, 'brown fruit-eating bat').
ncbi_mult_taxo_gbnm(40226, 'silver fruit-eating bat').
ncbi_mult_taxo_gbnm(40228, 'dark fruit-eating bat').
ncbi_mult_taxo_gbnm(40229, 'dwarf fruit-eating bat').
ncbi_mult_taxo_gbnm(40230, 'flat-faced fruit-eating bat').
ncbi_mult_taxo_gbnm(40233, 'Seba\'s short-tailed bat').
ncbi_mult_taxo_gbnm(40239, 'Aztec fruit-eating bat').
ncbi_mult_taxo_gbnm(40240, 'Toltec fruit-eating bat').
ncbi_mult_taxo_gbnm(40250, 'Indian spiny-tailed lizard').
ncbi_mult_taxo_gbnm(40254, 'scorched mussel').
ncbi_mult_taxo_gbnm(40255, horsemussels).
ncbi_mult_taxo_gbnm(40256, 'northern horsemussel').
ncbi_mult_taxo_gbnm(40297, galagos).
ncbi_mult_taxo_gbnm(40316, 'sawtooth elbow crab').
ncbi_mult_taxo_gbnm(40320, 'cultivated baccatum').
ncbi_mult_taxo_gbnm(40321, 'jalapeno pepper').
ncbi_mult_taxo_gbnm(40353, 'saw-scaled viper').
ncbi_mult_taxo_gbnm(40450, 'razor strop fungus').
ncbi_mult_taxo_gbnm(40494, 'dog snapper').
ncbi_mult_taxo_gbnm(40495, 'mutton snapper').
ncbi_mult_taxo_gbnm(40496, 'lane snapper').
ncbi_mult_taxo_gbnm(40497, 'mahogany snapper').
ncbi_mult_taxo_gbnm(40500, 'silk snapper').
ncbi_mult_taxo_gbnm(40501, 'cubera snapper').
ncbi_mult_taxo_gbnm(40502, 'schoolmaster snapper').
ncbi_mult_taxo_gbnm(40503, 'grey snapper').
ncbi_mult_taxo_gbnm(40504, 'blackfin snapper').
ncbi_mult_taxo_gbnm(40505, 'northern red snapper').
ncbi_mult_taxo_gbnm(40509, 'queen snapper').
ncbi_mult_taxo_gbnm(40511, wrenchman).
ncbi_mult_taxo_gbnm(40555, 'hairy lip-fern').
ncbi_mult_taxo_gbnm(40573, teasels).
ncbi_mult_taxo_gbnm(40574, 'Fuller\'s teasel').
ncbi_mult_taxo_gbnm(40580, 'bamboo sharks').
ncbi_mult_taxo_gbnm(40601, 'paspalum staggers ergot').
ncbi_mult_taxo_gbnm(40664, 'spot-on-spot round ray').
ncbi_mult_taxo_gbnm(40665, numbfishes).
ncbi_mult_taxo_gbnm(40674, mammals).
ncbi_mult_taxo_gbnm(40685, willows).
ncbi_mult_taxo_gbnm(40686, osier).
ncbi_mult_taxo_gbnm(40690, 'emerald rockcod').
ncbi_mult_taxo_gbnm(40691, 'slender scalyhead').
ncbi_mult_taxo_gbnm(40692, 'deepwater notothen').
ncbi_mult_taxo_gbnm(40693, 'blackfin notothen').
ncbi_mult_taxo_gbnm(40704, 'Majorcan peony').
ncbi_mult_taxo_gbnm(40707, 'Delavay\'s tree peony').
ncbi_mult_taxo_gbnm(40738, 'California Jacob\'s-ladder').
ncbi_mult_taxo_gbnm(40749, phloxes).
ncbi_mult_taxo_gbnm(40760, 'mountain-trumpets').
ncbi_mult_taxo_gbnm(40761, 'narrow leaf mountaintrumpet').
ncbi_mult_taxo_gbnm(40816, 'Eurasian crane').
ncbi_mult_taxo_gbnm(40817, 'black-necked crane').
ncbi_mult_taxo_gbnm(40818, 'hooded crane').
ncbi_mult_taxo_gbnm(40821, 'greater sandhill crane').
ncbi_mult_taxo_gbnm(40822, 'Canadian sandhill crane').
ncbi_mult_taxo_gbnm(40823, 'Florida sandhill crane').
ncbi_mult_taxo_gbnm(40824, 'lesser sandhill crane').
ncbi_mult_taxo_gbnm(40829, barbels).
ncbi_mult_taxo_gbnm(40830, barbel).
ncbi_mult_taxo_gbnm(40833, 'Barrow\'s goldeneye').
ncbi_mult_taxo_gbnm(40843, 'Tonkean macaque').
ncbi_mult_taxo_gbnm(40880, 'sweet cicely').
ncbi_mult_taxo_gbnm(40888, chervil).
ncbi_mult_taxo_gbnm(40891, 'hedge parsley').
ncbi_mult_taxo_gbnm(40902, goutweed).
ncbi_mult_taxo_gbnm(40909, 'Venus\'s comb').
ncbi_mult_taxo_gbnm(40916, 'rock samphire').
ncbi_mult_taxo_gbnm(40917, 'cow parsnips').
ncbi_mult_taxo_gbnm(40919, 'common hogweed').
ncbi_mult_taxo_gbnm(40922, dill).
ncbi_mult_taxo_gbnm(40930, 'lilac mealybug').
ncbi_mult_taxo_gbnm(40932, 'bird cherry-oat aphid').
ncbi_mult_taxo_gbnm(40947, 'golden alexanders').
ncbi_mult_taxo_gbnm(40954, 'fool\'s parsley').
ncbi_mult_taxo_gbnm(40955, 'woolyfruit desertparsley').
ncbi_mult_taxo_gbnm(40959, 'burnet saxifrage').
ncbi_mult_taxo_gbnm(40962, alexanders).
ncbi_mult_taxo_gbnm(40973, 'button fern').
ncbi_mult_taxo_gbnm(40997, 'citrus scab fungus').
ncbi_mult_taxo_gbnm(41010, 'yellow mongoose').
ncbi_mult_taxo_gbnm(41012, 'clothes-moths').
ncbi_mult_taxo_gbnm(41014, 'casemaking clothes moth').
ncbi_mult_taxo_gbnm(41021, 'ghost moths').
ncbi_mult_taxo_gbnm(41023, 'silver spotted ghost moth').
ncbi_mult_taxo_gbnm(41025, 'mandibulate moths').
ncbi_mult_taxo_gbnm(41030, 'common net-spinning caddisflies').
ncbi_mult_taxo_gbnm(41034, 'humpless casemaker caddisflies').
ncbi_mult_taxo_gbnm(41040, 'wingless hangingflies').
ncbi_mult_taxo_gbnm(41041, 'wingless hangingfly').
ncbi_mult_taxo_gbnm(41042, 'crane flies').
ncbi_mult_taxo_gbnm(41073, 'ground beetles').
ncbi_mult_taxo_gbnm(41094, 'skin and larder beetles').
ncbi_mult_taxo_gbnm(41097, 'soldier beetles').
ncbi_mult_taxo_gbnm(41102, 'water scavenger beetles').
ncbi_mult_taxo_gbnm(41105, 'stag beetles').
ncbi_mult_taxo_gbnm(41107, 'lesser stag beetle').
ncbi_mult_taxo_gbnm(41110, 'flat bark beetles').
ncbi_mult_taxo_gbnm(41111, 'grain beetles').
ncbi_mult_taxo_gbnm(41112, 'saw-toothed grain beetle').
ncbi_mult_taxo_gbnm(41116, pillbugs).
ncbi_mult_taxo_gbnm(41139, 'seven-spotted ladybird').
ncbi_mult_taxo_gbnm(41142, 'dung beetles & tumblebugs').
ncbi_mult_taxo_gbnm(41143, scarabs).
ncbi_mult_taxo_gbnm(41145, 'black dung beetles').
ncbi_mult_taxo_gbnm(41152, 'flower long-horned beetles').
ncbi_mult_taxo_gbnm(41153, 'flower long-horned beetle').
ncbi_mult_taxo_gbnm(41164, amago).
ncbi_mult_taxo_gbnm(41186, 'conifer swift moth').
ncbi_mult_taxo_gbnm(41190, 'kauri moth').
ncbi_mult_taxo_gbnm(41195, 'southern beech moth').
ncbi_mult_taxo_gbnm(41198, 'common imperial blue').
ncbi_mult_taxo_gbnm(41199, 'North African gerbil').
ncbi_mult_taxo_gbnm(41210, 'snow crab').
ncbi_mult_taxo_gbnm(41219, 'climbing lilies').
ncbi_mult_taxo_gbnm(41220, 'flame lily').
ncbi_mult_taxo_gbnm(41226, 'mint shrub').
ncbi_mult_taxo_gbnm(41227, 'Swedish begonias').
ncbi_mult_taxo_gbnm(41229, horehounds).
ncbi_mult_taxo_gbnm(41230, 'white horehound').
ncbi_mult_taxo_gbnm(41231, 'purple wreaths').
ncbi_mult_taxo_gbnm(41233, 'queen\'s wreath').
ncbi_mult_taxo_gbnm(41239, bluecurls).
ncbi_mult_taxo_gbnm(41240, 'bastard pennyroyal').
ncbi_mult_taxo_gbnm(41241, 'garden sorrel').
ncbi_mult_taxo_gbnm(41256, 'coin leaf plant').
ncbi_mult_taxo_gbnm(41260, 'fat dormice').
ncbi_mult_taxo_gbnm(41261, 'Fat dormouse').
ncbi_mult_taxo_gbnm(41262, 'large naked-sole gerbils').
ncbi_mult_taxo_gbnm(41265, 'Stella wood mouse').
ncbi_mult_taxo_gbnm(41266, 'long-tailed giant rats').
ncbi_mult_taxo_gbnm(41268, 'Guinea multimammate mouse').
ncbi_mult_taxo_gbnm(41269, 'Sumatran shrewlike mouse').
ncbi_mult_taxo_gbnm(41270, 'Matthey\'s mouse').
ncbi_mult_taxo_gbnm(41272, 'white-bellied brush-furred rat').
ncbi_mult_taxo_gbnm(41295, 'purple nonsulfur bacteria').
ncbi_mult_taxo_gbnm(41297, 'alpha-4 proteobacteria').
ncbi_mult_taxo_gbnm(41324, 'tube worms').
ncbi_mult_taxo_gbnm(41356, 'sun spiders').
ncbi_mult_taxo_gbnm(41378, 'black mangrove').
ncbi_mult_taxo_gbnm(41385, bluebeards).
ncbi_mult_taxo_gbnm(41398, 'night jasmine').
ncbi_mult_taxo_gbnm(41425, 'wart hogs').
ncbi_mult_taxo_gbnm(41426, 'Common warthog').
ncbi_mult_taxo_gbnm(41443, 'bulb mites').
ncbi_mult_taxo_gbnm(41446, 'false kelpfish').
ncbi_mult_taxo_gbnm(41447, 'greater amberjack').
ncbi_mult_taxo_gbnm(41480, 'common blue wood aster').
ncbi_mult_taxo_gbnm(41496, 'pot marigold').
ncbi_mult_taxo_gbnm(41522, 'bachelor\'s button').
ncbi_mult_taxo_gbnm(41548, chuquiragua).
ncbi_mult_taxo_gbnm(41568, 'florist\'s daisy').
ncbi_mult_taxo_gbnm(41653, 'meadow salsify').
ncbi_mult_taxo_gbnm(41679, 'Chinese radish').
ncbi_mult_taxo_gbnm(41689, maikoa).
ncbi_mult_taxo_gbnm(41691, 'black-necked swan').
ncbi_mult_taxo_gbnm(41702, 'broad-headed bugs').
ncbi_mult_taxo_gbnm(41704, 'bean bug').
ncbi_mult_taxo_gbnm(41711, 'freshwater smelts and others').
ncbi_mult_taxo_gbnm(41712, bonytongues).
ncbi_mult_taxo_gbnm(41767, 'turkey corn').
ncbi_mult_taxo_gbnm(41776, 'heavenly bamboo').
ncbi_mult_taxo_gbnm(41806, babirusa).
ncbi_mult_taxo_gbnm(41807, 'bearded pig').
ncbi_mult_taxo_gbnm(41811, 'phantom midges').
ncbi_mult_taxo_gbnm(41814, 'solitary midges').
ncbi_mult_taxo_gbnm(41819, 'biting midges').
ncbi_mult_taxo_gbnm(41820, punkies).
ncbi_mult_taxo_gbnm(41824, 'meniscus midges').
ncbi_mult_taxo_gbnm(41832, mothflies).
ncbi_mult_taxo_gbnm(41871, 'lake sturgeon').
ncbi_mult_taxo_gbnm(41872, mullets).
ncbi_mult_taxo_gbnm(41893, 'allied rock wallaby').
ncbi_mult_taxo_gbnm(41895, 'black flour beetle').
ncbi_mult_taxo_gbnm(41913, kamraj).
ncbi_mult_taxo_gbnm(41915, 'daisy-leaved grape fern').
ncbi_mult_taxo_gbnm(41931, 'little grapefern').
ncbi_mult_taxo_gbnm(41956, 'fly agaric').
ncbi_mult_taxo_gbnm(41964, 'hart\'s tongue').
ncbi_mult_taxo_gbnm(41966, 'Indian holly fern').
ncbi_mult_taxo_gbnm(41994, 'Mexican horncone').
ncbi_mult_taxo_gbnm(42029, 'yellow-striped armyworm moth').
ncbi_mult_taxo_gbnm(42034, 'rose campion').
ncbi_mult_taxo_gbnm(42036, 'ragged-robin').
ncbi_mult_taxo_gbnm(42039, 'Spanish catchfly').
ncbi_mult_taxo_gbnm(42040, 'nodding catchfly').
ncbi_mult_taxo_gbnm(42042, 'clammy campion').
ncbi_mult_taxo_gbnm(42043, 'bladder campion').
ncbi_mult_taxo_gbnm(42048, 'poverty oat grass').
ncbi_mult_taxo_gbnm(42053, 'uva grass').
ncbi_mult_taxo_gbnm(42059, 'greater red rock rabbit').
ncbi_mult_taxo_gbnm(42060, 'Jameson\'s red rock rabbit').
ncbi_mult_taxo_gbnm(42061, 'Smith\'s red rock rabbit').
ncbi_mult_taxo_gbnm(42064, 'slash pine').
ncbi_mult_taxo_gbnm(42100, vaquita).
ncbi_mult_taxo_gbnm(42146, 'bare-backed fruit bats').
ncbi_mult_taxo_gbnm(42147, 'Moluccan bare-backed fruit bat').
ncbi_mult_taxo_gbnm(42148, 'temperate basses').
ncbi_mult_taxo_gbnm(42150, 'Podolsk blind mole rat').
ncbi_mult_taxo_gbnm(42151, 'East African long-eared elephant shrew').
ncbi_mult_taxo_gbnm(42152, 'Brazilian agouti').
ncbi_mult_taxo_gbnm(42165, 'small-scaled burrowing asp').
ncbi_mult_taxo_gbnm(42196, 'dumb cane').
ncbi_mult_taxo_gbnm(42229, 'sweet cherry').
ncbi_mult_taxo_gbnm(42241, tardigrades).
ncbi_mult_taxo_gbnm(42249, 'white Piedmont truffle').
ncbi_mult_taxo_gbnm(42251, 'whitish truffle').
ncbi_mult_taxo_gbnm(42254, 'European shrew').
ncbi_mult_taxo_gbnm(42267, 'Mormon metalmark').
ncbi_mult_taxo_gbnm(42270, viceroy).
ncbi_mult_taxo_gbnm(42273, 'Atlantis fritillary').
ncbi_mult_taxo_gbnm(42275, 'red admiral').
ncbi_mult_taxo_gbnm(42279, 'snout butterflies').
ncbi_mult_taxo_gbnm(42282, 'graylings, ringlets, browns & heaths').
ncbi_mult_taxo_gbnm(42286, 'little wood satyr').
ncbi_mult_taxo_gbnm(42288, 'pipe-vine swallowtail').
ncbi_mult_taxo_gbnm(42289, swallowtails).
ncbi_mult_taxo_gbnm(42290, 'Apollo butterflies').
ncbi_mult_taxo_gbnm(42292, 'Clodius parnassian').
ncbi_mult_taxo_gbnm(42294, 'checkered white').
ncbi_mult_taxo_gbnm(42295, 'clouded yellows').
ncbi_mult_taxo_gbnm(42296, 'orange sulphur').
ncbi_mult_taxo_gbnm(42297, blues).
ncbi_mult_taxo_gbnm(42299, 'spring azure').
ncbi_mult_taxo_gbnm(42300, 'hairstreak butterflies').
ncbi_mult_taxo_gbnm(42324, 'tree hyraxes').
ncbi_mult_taxo_gbnm(42325, 'Western tree hyrax').
ncbi_mult_taxo_gbnm(42330, 'Adriatic sturgeon').
ncbi_mult_taxo_gbnm(42332, 'red valerian').
ncbi_mult_taxo_gbnm(42337, 'bur-marigold').
ncbi_mult_taxo_gbnm(42343, 'Roe\'s abalone').
ncbi_mult_taxo_gbnm(42344, 'Japanese disc abalone').
ncbi_mult_taxo_gbnm(42345, 'date palm').
ncbi_mult_taxo_gbnm(42346, 'Afghan pika').
ncbi_mult_taxo_gbnm(42407, 'wood rats').
ncbi_mult_taxo_gbnm(42408, 'white-throated woodrat').
ncbi_mult_taxo_gbnm(42409, 'eastern woodrat').
ncbi_mult_taxo_gbnm(42410, 'cactus mouse').
ncbi_mult_taxo_gbnm(42411, 'cotton mouse').
ncbi_mult_taxo_gbnm(42412, 'black-eared mouse').
ncbi_mult_taxo_gbnm(42413, 'oldfield mouse').
ncbi_mult_taxo_gbnm(42414, 'cotton rats').
ncbi_mult_taxo_gbnm(42415, 'hispid cotton rat').
ncbi_mult_taxo_gbnm(42416, 'Jaliscan cotton rat').
ncbi_mult_taxo_gbnm(42434, 'northern house mosquito').
ncbi_mult_taxo_gbnm(42439, 'white meadowfoam').
ncbi_mult_taxo_gbnm(42449, whites).
ncbi_mult_taxo_gbnm(42450, 'sulphurs and yellows').
ncbi_mult_taxo_gbnm(42451, 'air-breathing sea slugs').
ncbi_mult_taxo_gbnm(42473, 'gray cuscus').
ncbi_mult_taxo_gbnm(42486, 'Congo tetra').
ncbi_mult_taxo_gbnm(42492, 'neon tetra').
ncbi_mult_taxo_gbnm(42494, 'black tetra').
ncbi_mult_taxo_gbnm(42514, 'red-bellied piranha').
ncbi_mult_taxo_gbnm(42520, 'California mouse').
ncbi_mult_taxo_gbnm(42524, 'golden mylossoma').
ncbi_mult_taxo_gbnm(42526, tambaqui).
ncbi_mult_taxo_gbnm(42528, pacu).
ncbi_mult_taxo_gbnm(42529, pirapitinga).
ncbi_mult_taxo_gbnm(42538, 'wimple piranha').
ncbi_mult_taxo_gbnm(42541, 'sheep-pacu').
ncbi_mult_taxo_gbnm(42547, 'disk tetra').
ncbi_mult_taxo_gbnm(42550, 'redhook myleus').
ncbi_mult_taxo_gbnm(42552, 'pinktail chalceus').
ncbi_mult_taxo_gbnm(42556, 'Congo citharin').
ncbi_mult_taxo_gbnm(42563, 'African pike characin').
ncbi_mult_taxo_gbnm(42603, 'spotted pike-characin').
ncbi_mult_taxo_gbnm(42612, 'darter characine').
ncbi_mult_taxo_gbnm(42645, 'elephantnose fish').
ncbi_mult_taxo_gbnm(42663, 'northern redbelly dace').
ncbi_mult_taxo_gbnm(42712, 'woolly opossums').
ncbi_mult_taxo_gbnm(42713, 'western woolly opossum').
ncbi_mult_taxo_gbnm(42715, 'bushy-tailed opossum').
ncbi_mult_taxo_gbnm(42716, 'white-eared opossum').
ncbi_mult_taxo_gbnm(42717, 'red mouse opossum').
ncbi_mult_taxo_gbnm(42719, 'long-furred woolly mouse opossum').
ncbi_mult_taxo_gbnm(42720, 'Short-furred woolly mouse opossum').
ncbi_mult_taxo_gbnm(42722, 'Andean slender mouse opossum').
ncbi_mult_taxo_gbnm(42725, 'brown four-eyed opossum').
ncbi_mult_taxo_gbnm(42726, 'sepia short-tailed opossum').
ncbi_mult_taxo_gbnm(42731, 'Incan shrew opossum').
ncbi_mult_taxo_gbnm(42733, 'Kalubu echymipera').
ncbi_mult_taxo_gbnm(42754, 'monkey-puzzle tree').
ncbi_mult_taxo_gbnm(42757, mudpuppy).
ncbi_mult_taxo_gbnm(42759, siphonophores).
ncbi_mult_taxo_gbnm(42820, 'ash-colored tapaculo').
ncbi_mult_taxo_gbnm(42830, 'Ihering\'s Atlantic spiny-rat').
ncbi_mult_taxo_gbnm(42834, 'Simon\'s spiny rat').
ncbi_mult_taxo_gbnm(42863, 'angel fish').
ncbi_mult_taxo_gbnm(42892, 'Japanese anchovy').
ncbi_mult_taxo_gbnm(43042, 'slimy salamander').
ncbi_mult_taxo_gbnm(43043, 'brook salamanders').
ncbi_mult_taxo_gbnm(43044, 'long-tailed salamander').
ncbi_mult_taxo_gbnm(43045, 'dusky salamanders').
ncbi_mult_taxo_gbnm(43048, hellbender).
ncbi_mult_taxo_gbnm(43054, 'six-rayed sea stars').
ncbi_mult_taxo_gbnm(43062, anchovies).
ncbi_mult_taxo_gbnm(43066, 'minute egg parasite').
ncbi_mult_taxo_gbnm(43070, eryngos).
ncbi_mult_taxo_gbnm(43073, tobira).
ncbi_mult_taxo_gbnm(43104, 'swamp dewberry').
ncbi_mult_taxo_gbnm(43105, 'blunthead salamander').
ncbi_mult_taxo_gbnm(43106, 'ringed salamander').
ncbi_mult_taxo_gbnm(43107, 'California tiger salamander').
ncbi_mult_taxo_gbnm(43108, 'flatwoods salamander').
ncbi_mult_taxo_gbnm(43109, 'Mexican tiger salamander').
ncbi_mult_taxo_gbnm(43110, 'Mabee\'s salamander').
ncbi_mult_taxo_gbnm(43111, 'long-toed salamander').
ncbi_mult_taxo_gbnm(43112, 'Central long-toed salamander').
ncbi_mult_taxo_gbnm(43113, 'Western long-toed salamander').
ncbi_mult_taxo_gbnm(43114, 'spotted salamander').
ncbi_mult_taxo_gbnm(43115, 'marbled salamander').
ncbi_mult_taxo_gbnm(43117, 'Tarahumara salamander').
ncbi_mult_taxo_gbnm(43120, 'goblet worms').
ncbi_mult_taxo_gbnm(43146, 'corn leaf aphid').
ncbi_mult_taxo_gbnm(43147, 'gray-bellied night monkey').
ncbi_mult_taxo_gbnm(43148, swallows).
ncbi_mult_taxo_gbnm(43150, 'Barn swallow').
ncbi_mult_taxo_gbnm(43155, 'Bonin honeyeater').
ncbi_mult_taxo_gbnm(43157, 'golden white-eye').
ncbi_mult_taxo_gbnm(43159, 'Fuscous honeyeater').
ncbi_mult_taxo_gbnm(43161, 'Belford\'s melidectes').
ncbi_mult_taxo_gbnm(43163, 'lesser whitethroat').
ncbi_mult_taxo_gbnm(43165, 'eastern kingbird').
ncbi_mult_taxo_gbnm(43166, 'bitter orange').
ncbi_mult_taxo_gbnm(43168, 'golden rain tree').
ncbi_mult_taxo_gbnm(43170, toadflaxes).
ncbi_mult_taxo_gbnm(43171, 'common toadflax').
ncbi_mult_taxo_gbnm(43172, 'owl\'s clovers').
ncbi_mult_taxo_gbnm(43174, louseworts).
ncbi_mult_taxo_gbnm(43179, 'thirteen-lined ground squirrel').
ncbi_mult_taxo_gbnm(43233, 'autumn-olive').
ncbi_mult_taxo_gbnm(43253, 'marsh rose').
ncbi_mult_taxo_gbnm(43254, plunderfishes).
ncbi_mult_taxo_gbnm(43256, 'Antarctic spiny plunderfish').
ncbi_mult_taxo_gbnm(43258, 'Japanese sillago').
ncbi_mult_taxo_gbnm(43271, harvestmen).
ncbi_mult_taxo_gbnm(43320, 'bicolor-spined porcupine').
ncbi_mult_taxo_gbnm(43321, 'social tuco-tuco').
ncbi_mult_taxo_gbnm(43325, 'Guiara').
ncbi_mult_taxo_gbnm(43327, 'common punare').
ncbi_mult_taxo_gbnm(43328, barasingha).
ncbi_mult_taxo_gbnm(43332, 'Pere David\'s deer').
ncbi_mult_taxo_gbnm(43334, 'red brocket').
ncbi_mult_taxo_gbnm(43335, 'white poplar').
ncbi_mult_taxo_gbnm(43363, 'horse chestnuts').
ncbi_mult_taxo_gbnm(43364, 'common horse chestnut').
ncbi_mult_taxo_gbnm(43367, 'bedding dahlia').
ncbi_mult_taxo_gbnm(43368, coralbells).
ncbi_mult_taxo_gbnm(43385, 'asparagus fly').
ncbi_mult_taxo_gbnm(43450, degame).
ncbi_mult_taxo_gbnm(43452, 'lily thorn').
ncbi_mult_taxo_gbnm(43455, 'turkey vulture').
ncbi_mult_taxo_gbnm(43458, 'giant glass frogs').
ncbi_mult_taxo_gbnm(43459, 'Pacific giant glass frog').
ncbi_mult_taxo_gbnm(43460, buttonbushes).
ncbi_mult_taxo_gbnm(43465, 'short-toed snake-eagle').
ncbi_mult_taxo_gbnm(43466, 'hen harrier').
ncbi_mult_taxo_gbnm(43469, 'dart-poison frogs').
ncbi_mult_taxo_gbnm(43471, 'green and black poison dart frog').
ncbi_mult_taxo_gbnm(43472, 'splendid poison frog').
ncbi_mult_taxo_gbnm(43475, 'Pacific giant salamanders').
ncbi_mult_taxo_gbnm(43490, 'white-backed vulture').
ncbi_mult_taxo_gbnm(43491, 'white-rumped vulture').
ncbi_mult_taxo_gbnm(43498, 'Natal ghost frog').
ncbi_mult_taxo_gbnm(43503, 'flame-of-the-woods').
ncbi_mult_taxo_gbnm(43518, 'red kite').
ncbi_mult_taxo_gbnm(43522, 'Indian mulberry').
ncbi_mult_taxo_gbnm(43528, 'Neuse river waterdog').
ncbi_mult_taxo_gbnm(43532, 'Alabama waterdog').
ncbi_mult_taxo_gbnm(43534, 'bead plant').
ncbi_mult_taxo_gbnm(43542, 'parsley frog').
ncbi_mult_taxo_gbnm(43551, 'European honey-buzzard').
ncbi_mult_taxo_gbnm(43557, 'swimming frogs').
ncbi_mult_taxo_gbnm(43558, 'paradox frog').
ncbi_mult_taxo_gbnm(43566, 'Mexican burrowing toad').
ncbi_mult_taxo_gbnm(43567, 'Olympic salamanders').
ncbi_mult_taxo_gbnm(43569, 'Olympic salamander').
ncbi_mult_taxo_gbnm(43577, 'Spanish tamarind').
ncbi_mult_taxo_gbnm(43579, 'red-headed vulture').
ncbi_mult_taxo_gbnm(43580, 'pale white-eye').
ncbi_mult_taxo_gbnm(43581, 'silver-eye').
ncbi_mult_taxo_gbnm(43583, 'king vulture').
ncbi_mult_taxo_gbnm(43593, 'Longnose leopard lizard').
ncbi_mult_taxo_gbnm(43597, 'lesser earless lizard').
ncbi_mult_taxo_gbnm(43611, 'pigmy short-horned lizard').
ncbi_mult_taxo_gbnm(43622, 'blue spiny lizard').
ncbi_mult_taxo_gbnm(43625, 'sagebrush lizard').
ncbi_mult_taxo_gbnm(43627, 'desert spiny lizard').
ncbi_mult_taxo_gbnm(43630, 'cleft lizard').
ncbi_mult_taxo_gbnm(43634, 'bunch grass lizard').
ncbi_mult_taxo_gbnm(43645, 'Colorado Desert fringe-toed lizard').
ncbi_mult_taxo_gbnm(43697, 'swamp eels and others').
ncbi_mult_taxo_gbnm(43698, 'swamp eels').
ncbi_mult_taxo_gbnm(43700, 'swamp eel').
ncbi_mult_taxo_gbnm(43725, 'Amargo').
ncbi_mult_taxo_gbnm(43729, 'paradise tree').
ncbi_mult_taxo_gbnm(43756, 'dung flies').
ncbi_mult_taxo_gbnm(43777, 'white-faced saki').
ncbi_mult_taxo_gbnm(43778, 'Geoffroy\'s tamarin').
ncbi_mult_taxo_gbnm(43780, 'proboscis monkey').
ncbi_mult_taxo_gbnm(43827, 'flat-footed flies').
ncbi_mult_taxo_gbnm(43848, 'picture-winged flies').
ncbi_mult_taxo_gbnm(43861, 'Polynesian plum').
ncbi_mult_taxo_gbnm(43890, mahogany).
ncbi_mult_taxo_gbnm(43956, 'longnose sucker').
ncbi_mult_taxo_gbnm(43957, 'largescale sucker').
ncbi_mult_taxo_gbnm(44147, 'Madagascar iguana').
ncbi_mult_taxo_gbnm(44152, 'Haitian boa').
ncbi_mult_taxo_gbnm(44168, 'black corals').
ncbi_mult_taxo_gbnm(44185, 'bubblegum corals').
ncbi_mult_taxo_gbnm(44234, 'western harvest mouse').
ncbi_mult_taxo_gbnm(44241, 'Santa Cruz mouse').
ncbi_mult_taxo_gbnm(44242, 'Slevin\'s mouse').
ncbi_mult_taxo_gbnm(44295, 'coral anemones').
ncbi_mult_taxo_gbnm(44314, 'noisy miner').
ncbi_mult_taxo_gbnm(44316, 'Gouldian finch').
ncbi_mult_taxo_gbnm(44318, 'eastern yellow robin').
ncbi_mult_taxo_gbnm(44321, 'bush tick').
ncbi_mult_taxo_gbnm(44326, 'Albanian pool frog').
ncbi_mult_taxo_gbnm(44368, 'Pratt\'s rocket frog').
ncbi_mult_taxo_gbnm(44371, 'cross-banded treefrogs').
ncbi_mult_taxo_gbnm(44375, 'gold-striped frog').
ncbi_mult_taxo_gbnm(44386, 'longhorned tick').
ncbi_mult_taxo_gbnm(44389, 'fox sparrow').
ncbi_mult_taxo_gbnm(44391, 'rufous-collared sparrow').
ncbi_mult_taxo_gbnm(44393, 'white-crowned sparrow').
ncbi_mult_taxo_gbnm(44394, 'white-throated sparrow').
ncbi_mult_taxo_gbnm(44397, 'song sparrow').
ncbi_mult_taxo_gbnm(44477, 'German honeybee').
ncbi_mult_taxo_gbnm(44489, 'pitted-shelled turtle').
ncbi_mult_taxo_gbnm(44492, 'North Australian snake-necked turtle').
ncbi_mult_taxo_gbnm(44495, 'Mata Mata').
ncbi_mult_taxo_gbnm(44502, 'Geoffroy\'s toadhead turtle').
ncbi_mult_taxo_gbnm(44510, 'Western swamp turtle').
ncbi_mult_taxo_gbnm(44530, 'Mary River turtle').
ncbi_mult_taxo_gbnm(44586, notoginseng).
ncbi_mult_taxo_gbnm(44599, 'pen shells').
ncbi_mult_taxo_gbnm(44604, 'red deer lungworm').
ncbi_mult_taxo_gbnm(44624, 'saddle fungi').
ncbi_mult_taxo_gbnm(44658, 'violet aphid').
ncbi_mult_taxo_gbnm(44659, 'rose aphid').
ncbi_mult_taxo_gbnm(44664, 'English grain aphid').
ncbi_mult_taxo_gbnm(44665, 'blackberry-cereal aphid').
ncbi_mult_taxo_gbnm(44670, 'rose-grain aphid').
ncbi_mult_taxo_gbnm(44679, 'seventeen-year cicada').
ncbi_mult_taxo_gbnm(44680, 'seventeen-year cicada').
ncbi_mult_taxo_gbnm(44685, 'Japanese ginseng').
ncbi_mult_taxo_gbnm(44706, 'Hispaniolan rivulus').
ncbi_mult_taxo_gbnm(44707, 'green rivulus').
ncbi_mult_taxo_gbnm(44709, 'rock rattlesnake').
ncbi_mult_taxo_gbnm(44710, 'Caatinga lancehead').
ncbi_mult_taxo_gbnm(44711, 'Cantor\' pit viper').
ncbi_mult_taxo_gbnm(44722, 'Godman\'s montane pit viper').
ncbi_mult_taxo_gbnm(44724, 'green jararaca').
ncbi_mult_taxo_gbnm(44732, 'Central Asian pitviper').
ncbi_mult_taxo_gbnm(44741, 'pea aphid rickettsia').
ncbi_mult_taxo_gbnm(44927, 'mat anemones').
ncbi_mult_taxo_gbnm(44947, 'water hyacinth').
ncbi_mult_taxo_gbnm(44955, 'water star-grass').
ncbi_mult_taxo_gbnm(45005, 'autumn-crocus').
ncbi_mult_taxo_gbnm(45007, 'marsh calla').
ncbi_mult_taxo_gbnm(45050, 'tree thrips').
ncbi_mult_taxo_gbnm(45053, 'true thrips').
ncbi_mult_taxo_gbnm(45055, 'pear thrips').
ncbi_mult_taxo_gbnm(45171, 'tree peony').
ncbi_mult_taxo_gbnm(45172, 'Cape leadwort').
ncbi_mult_taxo_gbnm(45179, 'sea grape').
ncbi_mult_taxo_gbnm(45189, 'lignum-vitae').
ncbi_mult_taxo_gbnm(45314, 'red maple').
ncbi_mult_taxo_gbnm(45325, 'Indian kapok').
ncbi_mult_taxo_gbnm(45351, 'starlet sea anemone').
ncbi_mult_taxo_gbnm(45352, 'white bass x striped sea-bass').
ncbi_mult_taxo_gbnm(45372, 'European silver fir').
ncbi_mult_taxo_gbnm(45384, 'plainfin midshipman').
ncbi_mult_taxo_gbnm(45438, 'wood frog').
ncbi_mult_taxo_gbnm(45450, 'hairy maggot blowfly').
ncbi_mult_taxo_gbnm(45455, 'Rhesus lymphocryptovirus').
ncbi_mult_taxo_gbnm(45463, 'Japanese elderberry').
ncbi_mult_taxo_gbnm(45466, 'gray-footed chipmunk').
ncbi_mult_taxo_gbnm(45467, 'cliff chipmunk').
ncbi_mult_taxo_gbnm(45468, 'least chipmunk').
ncbi_mult_taxo_gbnm(45469, 'Colorado chipmunk').
ncbi_mult_taxo_gbnm(45470, 'Franklin\'s ground squirrel').
ncbi_mult_taxo_gbnm(45471, 'spotted ground squirrel').
ncbi_mult_taxo_gbnm(45472, 'rock squirrel').
ncbi_mult_taxo_gbnm(45473, 'Guayaquil squirrel').
ncbi_mult_taxo_gbnm(45474, 'eastern chipmunk').
ncbi_mult_taxo_gbnm(45477, 'pygmy squirrel').
ncbi_mult_taxo_gbnm(45479, 'Gunnison\'s prairie dog').
ncbi_mult_taxo_gbnm(45480, 'black-tailed prairie dog').
ncbi_mult_taxo_gbnm(45482, 'northern flying squirrel').
ncbi_mult_taxo_gbnm(45484, 'Neotropical pygmy squirrel').
ncbi_mult_taxo_gbnm(45486, 'Texas antelope squirrel').
ncbi_mult_taxo_gbnm(45487, 'Harris\'s antelope squirrel').
ncbi_mult_taxo_gbnm(45488, 'white-tailed antelope squirrel').
ncbi_mult_taxo_gbnm(45621, 'mottled anemone').
ncbi_mult_taxo_gbnm(45623, 'pool frog').
ncbi_mult_taxo_gbnm(45630, 'grey teal').
ncbi_mult_taxo_gbnm(45631, 'chestnut teal').
ncbi_mult_taxo_gbnm(45632, 'Pacific black duck').
ncbi_mult_taxo_gbnm(45633, 'Australasian shoveler').
ncbi_mult_taxo_gbnm(45635, 'hardhead duck').
ncbi_mult_taxo_gbnm(45637, 'freckled duck').
ncbi_mult_taxo_gbnm(45638, 'Australian shelduck').
ncbi_mult_taxo_gbnm(45639, 'ruddy shelduck').
ncbi_mult_taxo_gbnm(45641, 'cotton pygmy goose').
ncbi_mult_taxo_gbnm(45642, 'green pygmy goose').
ncbi_mult_taxo_gbnm(45644, 'Maned duck').
ncbi_mult_taxo_gbnm(45646, 'pink-eared duck').
ncbi_mult_taxo_gbnm(45648, 'musk duck').
ncbi_mult_taxo_gbnm(45649, 'blue-billed duck').
ncbi_mult_taxo_gbnm(45675, 'Desert side-blotched lizard').
ncbi_mult_taxo_gbnm(45679, 'hog peanut').
ncbi_mult_taxo_gbnm(45779, 'eastern tiger swallowtail').
ncbi_mult_taxo_gbnm(45781, 'red wolf').
ncbi_mult_taxo_gbnm(45783, 'Australian bass').
ncbi_mult_taxo_gbnm(45798, 'Berthelot\'s pipit').
ncbi_mult_taxo_gbnm(45800, 'Tawny pipit').
ncbi_mult_taxo_gbnm(45802, 'water pipit').
ncbi_mult_taxo_gbnm(45804, 'Tree pipit').
ncbi_mult_taxo_gbnm(45807, 'white wagtail').
ncbi_mult_taxo_gbnm(45838, 'eastern black nightshade').
ncbi_mult_taxo_gbnm(45843, tamarillo).
ncbi_mult_taxo_gbnm(45896, tarflower).
ncbi_mult_taxo_gbnm(45920, 'European garden spider').
ncbi_mult_taxo_gbnm(45931, 'walnut meadow nematode').
ncbi_mult_taxo_gbnm(45971, 'dark false mussel').
ncbi_mult_taxo_gbnm(46029, 'cowpea witchweed').
ncbi_mult_taxo_gbnm(46032, 'corn speedwell').
ncbi_mult_taxo_gbnm(46091, 'nettle-leaved goosefoot').
ncbi_mult_taxo_gbnm(46107, greasewood).
ncbi_mult_taxo_gbnm(46108, seepweeds).
ncbi_mult_taxo_gbnm(46112, 'silver cockscomb').
ncbi_mult_taxo_gbnm(46150, 'mignonette vine').
ncbi_mult_taxo_gbnm(46167, 'rough-toothed dolphin').
ncbi_mult_taxo_gbnm(46195, 'banded iguana').
ncbi_mult_taxo_gbnm(46196, 'crested iguana').
ncbi_mult_taxo_gbnm(46218, 'blue-breasted quail').
ncbi_mult_taxo_gbnm(46219, 'American water shrew').
ncbi_mult_taxo_gbnm(46259, 'white bass').
ncbi_mult_taxo_gbnm(46260, 'white perch').
ncbi_mult_taxo_gbnm(46261, 'yellow bass').
ncbi_mult_taxo_gbnm(46271, 'Red-necked keelback').
ncbi_mult_taxo_gbnm(46276, 'Boulenger\'s odd-scaled snake').
ncbi_mult_taxo_gbnm(46280, 'triangle keelback').
ncbi_mult_taxo_gbnm(46287, 'little file snake').
ncbi_mult_taxo_gbnm(46305, 'night snake').
ncbi_mult_taxo_gbnm(46322, woodrushes).
ncbi_mult_taxo_gbnm(46324, spikerushes).
ncbi_mult_taxo_gbnm(46325, 'fewflower spikerush').
ncbi_mult_taxo_gbnm(46359, 'eastern lowland gorilla').
ncbi_mult_taxo_gbnm(46409, 'five finger').
ncbi_mult_taxo_gbnm(46475, 'Guam swiftlet').
ncbi_mult_taxo_gbnm(46476, 'Seychelles swiftlet').
ncbi_mult_taxo_gbnm(46477, 'Mascarene swiftlet').
ncbi_mult_taxo_gbnm(46478, 'edible-nest swiftlet').
ncbi_mult_taxo_gbnm(46479, 'brown-rumped swiftlet').
ncbi_mult_taxo_gbnm(46481, 'black-nest swiftlet').
ncbi_mult_taxo_gbnm(46482, 'white-rumped swiftlet').
ncbi_mult_taxo_gbnm(46484, 'white-rumped swiftlet').
ncbi_mult_taxo_gbnm(46485, 'mossy-nest swiftlet').
ncbi_mult_taxo_gbnm(46486, 'Sawtell\'s swiftlet').
ncbi_mult_taxo_gbnm(46488, 'Himalayan swiftlet').
ncbi_mult_taxo_gbnm(46490, 'glossy swiftlet').
ncbi_mult_taxo_gbnm(46492, 'house swift').
ncbi_mult_taxo_gbnm(46493, 'grey-rumped swiftlet').
ncbi_mult_taxo_gbnm(46495, 'cave swiftlet').
ncbi_mult_taxo_gbnm(46496, 'pygmy swiftlet').
ncbi_mult_taxo_gbnm(46498, 'Asian palm-swift').
ncbi_mult_taxo_gbnm(46500, 'black swift').
ncbi_mult_taxo_gbnm(46502, 'giant swiftlet').
ncbi_mult_taxo_gbnm(46505, 'white-collared swift').
ncbi_mult_taxo_gbnm(46508, 'tree swifts').
ncbi_mult_taxo_gbnm(46510, 'moustached treeswift').
ncbi_mult_taxo_gbnm(46511, 'Vaux\'s swift').
ncbi_mult_taxo_gbnm(46513, 'long-tailed hermit').
ncbi_mult_taxo_gbnm(46514, 'bat star').
ncbi_mult_taxo_gbnm(46550, 'Wandering albatross').
ncbi_mult_taxo_gbnm(46562, 'powder-post termites').
ncbi_mult_taxo_gbnm(46569, 'desert termites').
ncbi_mult_taxo_gbnm(46611, 'grand fir').
ncbi_mult_taxo_gbnm(46612, 'bull shark').
ncbi_mult_taxo_gbnm(46660, 'moray eels').
ncbi_mult_taxo_gbnm(46662, 'Mediterranean moray').
ncbi_mult_taxo_gbnm(46664, 'Brazilian fern tree').
ncbi_mult_taxo_gbnm(46705, 'finger coral').
ncbi_mult_taxo_gbnm(46711, 'mushroom corals').
ncbi_mult_taxo_gbnm(46731, 'cauliflower coral').
ncbi_mult_taxo_gbnm(46750, 'hammer coral').
ncbi_mult_taxo_gbnm(46761, 'Del Norte salamander').
ncbi_mult_taxo_gbnm(46780, 'Malabar danio').
ncbi_mult_taxo_gbnm(46781, 'Sind dario').
ncbi_mult_taxo_gbnm(46842, 'little spotted cat').
ncbi_mult_taxo_gbnm(46844, 'Geoffroy\'s cat').
ncbi_mult_taxo_gbnm(46904, 'golden whistler').
ncbi_mult_taxo_gbnm(46906, piopio).
ncbi_mult_taxo_gbnm(46907, 'South Island piopio').
ncbi_mult_taxo_gbnm(46908, 'olive-tailed thrush').
ncbi_mult_taxo_gbnm(46963, 'blue cohosh').
ncbi_mult_taxo_gbnm(46970, 'early meadow-rue').
ncbi_mult_taxo_gbnm(46973, 'purple meadow-rue').
ncbi_mult_taxo_gbnm(46985, 'spring adonis').
ncbi_mult_taxo_gbnm(46997, 'frog-biting midges').
ncbi_mult_taxo_gbnm(47073, 'giant Caribbean anemone').
ncbi_mult_taxo_gbnm(47080, 'American licorice').
ncbi_mult_taxo_gbnm(47148, 'flowering dogwood fly').
ncbi_mult_taxo_gbnm(47149, 'buffaloberry fly').
ncbi_mult_taxo_gbnm(47177, 'Greater dwarf lemur').
ncbi_mult_taxo_gbnm(47180, 'Coquerel\'s mouse lemur').
ncbi_mult_taxo_gbnm(47230, 'common vole').
ncbi_mult_taxo_gbnm(47245, 'mourning dove').
ncbi_mult_taxo_gbnm(47308, 'round goby').
ncbi_mult_taxo_gbnm(47310, 'tubenose goby').
ncbi_mult_taxo_gbnm(47433, 'Finch\'s wart frog').
ncbi_mult_taxo_gbnm(47435, 'Palawan wart frog').
ncbi_mult_taxo_gbnm(47436, 'lesser swamp frog').
ncbi_mult_taxo_gbnm(47437, 'greater swamp frog').
ncbi_mult_taxo_gbnm(47471, 'Guatemalan gamagrass').
ncbi_mult_taxo_gbnm(47519, 'hedge bindweed').
ncbi_mult_taxo_gbnm(47543, 'giant Asian toad').
ncbi_mult_taxo_gbnm(47544, 'Sunda ridge-headed toad').
ncbi_mult_taxo_gbnm(47545, 'Bocourt\'s toad').
ncbi_mult_taxo_gbnm(47546, 'green climbing toad').
ncbi_mult_taxo_gbnm(47547, 'Pico Blanco toad').
ncbi_mult_taxo_gbnm(47548, 'Karroo toad').
ncbi_mult_taxo_gbnm(47549, 'olive toad').
ncbi_mult_taxo_gbnm(47551, 'Sinaloa toad').
ncbi_mult_taxo_gbnm(47553, 'red-spotted toad').
ncbi_mult_taxo_gbnm(47554, 'oak toad').
ncbi_mult_taxo_gbnm(47555, 'Sonoran green toad').
ncbi_mult_taxo_gbnm(47557, 'Volcan Tacana toad').
ncbi_mult_taxo_gbnm(47559, 'southern toad').
ncbi_mult_taxo_gbnm(47560, 'southern pygmy toad').
ncbi_mult_taxo_gbnm(47561, 'Woodhouse\'s toad').
ncbi_mult_taxo_gbnm(47562, 'Pacific treefrog').
ncbi_mult_taxo_gbnm(47564, 'smoky jungle frog').
ncbi_mult_taxo_gbnm(47577, 'Mueller\'s stream toad').
ncbi_mult_taxo_gbnm(47584, 'Guacamayo plump toad').
ncbi_mult_taxo_gbnm(47586, 'lowland Caribbean toad').
ncbi_mult_taxo_gbnm(47651, 'alkali swainsonpea').
ncbi_mult_taxo_gbnm(47665, 'Campbell\'s desert hamster').
ncbi_mult_taxo_gbnm(47692, 'superb lyrebird').
ncbi_mult_taxo_gbnm(47695, 'rufous treecreeper').
ncbi_mult_taxo_gbnm(47698, soldierfishes).
ncbi_mult_taxo_gbnm(47700, 'blotcheye soldierfish').
ncbi_mult_taxo_gbnm(47701, 'lattice soldierfish').
ncbi_mult_taxo_gbnm(47702, squirrelfishes).
ncbi_mult_taxo_gbnm(47704, 'clearfin squirrelfish').
ncbi_mult_taxo_gbnm(47705, 'yellowstriped squirrelfish').
ncbi_mult_taxo_gbnm(47706, 'Sammara squirrelfish').
ncbi_mult_taxo_gbnm(47708, 'Hawaiian squirrelfish').
ncbi_mult_taxo_gbnm(47709, 'crown squirrelfish').
ncbi_mult_taxo_gbnm(47710, 'smallmouth squirrelfish').
ncbi_mult_taxo_gbnm(47711, 'speckled squirrelfish').
ncbi_mult_taxo_gbnm(47712, 'sabre squirrelfish').
ncbi_mult_taxo_gbnm(47713, 'blue lined squirrelfish').
ncbi_mult_taxo_gbnm(47729, 'common house gecko').
ncbi_mult_taxo_gbnm(47767, 'turnip moth').
ncbi_mult_taxo_gbnm(47769, 'Persian horned viper').
ncbi_mult_taxo_gbnm(47773, 'guava fruit fly').
ncbi_mult_taxo_gbnm(47774, 'cucumber fruit fly').
ncbi_mult_taxo_gbnm(47929, 'Rhesus cytomegalovirus').
ncbi_mult_taxo_gbnm(47965, 'Shantung maple').
ncbi_mult_taxo_gbnm(47966, 'downy Japanese maple').
ncbi_mult_taxo_gbnm(47972, 'African bush squirrels').
ncbi_mult_taxo_gbnm(47973, 'Smith\'s bush squirrel').
ncbi_mult_taxo_gbnm(47976, 'Audubon\'s shearwater').
ncbi_mult_taxo_gbnm(47980, 'western crowned-warbler').
ncbi_mult_taxo_gbnm(48005, 'bristly mouse').
ncbi_mult_taxo_gbnm(48006, 'MacConnell\'s rice rat').
ncbi_mult_taxo_gbnm(48008, 'small-eared pygmy rice rat').
ncbi_mult_taxo_gbnm(48009, 'elegant rice rat').
ncbi_mult_taxo_gbnm(48011, 'bicolored arboreal rice rat').
ncbi_mult_taxo_gbnm(48012, 'Robert\'s arboreal rice rat').
ncbi_mult_taxo_gbnm(48013, 'foothill arboreal rice rat').
ncbi_mult_taxo_gbnm(48015, 'Trinidad arboreal rice rat').
ncbi_mult_taxo_gbnm(48026, 'large bullwort').
ncbi_mult_taxo_gbnm(48040, 'Howell\'s biscuitroot').
ncbi_mult_taxo_gbnm(48083, 'pygmy rabbit').
ncbi_mult_taxo_gbnm(48085, 'riverine rabbit').
ncbi_mult_taxo_gbnm(48086, 'snowshoe hare').
ncbi_mult_taxo_gbnm(48087, 'black-tailed jackrabbit').
ncbi_mult_taxo_gbnm(48089, 'volcano rabbit').
ncbi_mult_taxo_gbnm(48090, 'swamp rabbit').
ncbi_mult_taxo_gbnm(48106, 'Asiatic pennywort').
ncbi_mult_taxo_gbnm(48131, 'false indigo bush').
ncbi_mult_taxo_gbnm(48139, 'fat sand rat').
ncbi_mult_taxo_gbnm(48141, 'ice krill').
ncbi_mult_taxo_gbnm(48150, 'eurasian chiffchaff').
ncbi_mult_taxo_gbnm(48151, 'buff-browed warbler').
ncbi_mult_taxo_gbnm(48154, 'greenish warbler').
ncbi_mult_taxo_gbnm(48155, blackcap).
ncbi_mult_taxo_gbnm(48163, 'Celebes longfin eel').
ncbi_mult_taxo_gbnm(48164, 'African longfin eel').
ncbi_mult_taxo_gbnm(48165, 'speckled longfin eel').
ncbi_mult_taxo_gbnm(48167, markhor).
ncbi_mult_taxo_gbnm(48168, 'blackfin tuna').
ncbi_mult_taxo_gbnm(48169, 'longtail tuna').
ncbi_mult_taxo_gbnm(48171, 'thicklip grey mullet').
ncbi_mult_taxo_gbnm(48191, 'golden grey mullet').
ncbi_mult_taxo_gbnm(48192, 'leaping mullet').
ncbi_mult_taxo_gbnm(48193, 'flathead mullet').
ncbi_mult_taxo_gbnm(48194, 'white mullet').
ncbi_mult_taxo_gbnm(48196, 'boxlip mullet').
ncbi_mult_taxo_gbnm(48258, 'depressed flour beetle').
ncbi_mult_taxo_gbnm(48386, 'beefsteak plant').
ncbi_mult_taxo_gbnm(48397, 'trumperter swan').
ncbi_mult_taxo_gbnm(48398, 'Common nighthawk').
ncbi_mult_taxo_gbnm(48399, 'American crocodile').
ncbi_mult_taxo_gbnm(48416, 'viviparous blenny').
ncbi_mult_taxo_gbnm(48418, 'small Indian mongoose').
ncbi_mult_taxo_gbnm(48420, wolverine).
ncbi_mult_taxo_gbnm(48422, olingo).
ncbi_mult_taxo_gbnm(48425, 'long-tailed potoo').
ncbi_mult_taxo_gbnm(48426, 'Rufous potoo').
ncbi_mult_taxo_gbnm(48435, oilbird).
ncbi_mult_taxo_gbnm(48438, 'dragonfishes and others').
ncbi_mult_taxo_gbnm(48439, bristlemouths).
ncbi_mult_taxo_gbnm(48441, 'benttooth bristlemouth').
ncbi_mult_taxo_gbnm(48442, bristlemouth).
ncbi_mult_taxo_gbnm(48443, 'deep-water bristlemouth').
ncbi_mult_taxo_gbnm(48444, garrick).
ncbi_mult_taxo_gbnm(48447, 'veiled anglemouth').
ncbi_mult_taxo_gbnm(48449, 'tan bristlemouth').
ncbi_mult_taxo_gbnm(48451, 'slender bristlemouth').
ncbi_mult_taxo_gbnm(48453, 'showy bristlemouth').
ncbi_mult_taxo_gbnm(48456, 'Atlantic fangjaw').
ncbi_mult_taxo_gbnm(48457, 'slender fangjaw').
ncbi_mult_taxo_gbnm(48500, 'boulder star coral').
ncbi_mult_taxo_gbnm(48517, 'desert christmas tree').
ncbi_mult_taxo_gbnm(48536, 'phantom orchid').
ncbi_mult_taxo_gbnm(48560, 'Eastern roe deer').
ncbi_mult_taxo_gbnm(48620, 'bronze tiger beetle').
ncbi_mult_taxo_gbnm(48668, 'roach minnow').
ncbi_mult_taxo_gbnm(48672, 'Barolo shearwater').
ncbi_mult_taxo_gbnm(48674, 'Townsend\'s shearwater').
ncbi_mult_taxo_gbnm(48676, 'Buller\'s shearwater').
ncbi_mult_taxo_gbnm(48679, 'Pink-footed shearwater').
ncbi_mult_taxo_gbnm(48684, 'Short-tailed shearwater').
ncbi_mult_taxo_gbnm(48698, 'Amazon molly').
ncbi_mult_taxo_gbnm(48699, 'sailfin molly').
ncbi_mult_taxo_gbnm(48700, 'broadspotted molly').
ncbi_mult_taxo_gbnm(48702, 'sail-fin molly').
ncbi_mult_taxo_gbnm(48704, 'slender springtails').
ncbi_mult_taxo_gbnm(48708, 'Blainville\'s beaked whale').
ncbi_mult_taxo_gbnm(48715, 'blind springtails').
ncbi_mult_taxo_gbnm(48717, 'giant springtail').
ncbi_mult_taxo_gbnm(48720, 'sand bees').
ncbi_mult_taxo_gbnm(48723, franciscana).
ncbi_mult_taxo_gbnm(48732, 'blue grama').
ncbi_mult_taxo_gbnm(48734, 'stink grass').
ncbi_mult_taxo_gbnm(48742, 'Baird\'s beaked whale').
ncbi_mult_taxo_gbnm(48744, 'northern bottlenose whale').
ncbi_mult_taxo_gbnm(48745, 'Sowerby\'s beaked whale').
ncbi_mult_taxo_gbnm(48747, 'Irrawaddy dolphin').
ncbi_mult_taxo_gbnm(48752, 'Indus River dolphin').
ncbi_mult_taxo_gbnm(48842, 'Emilia\'s marmoset').
ncbi_mult_taxo_gbnm(48849, 'house sparrow').
ncbi_mult_taxo_gbnm(48850, 'southern tamandua').
ncbi_mult_taxo_gbnm(48852, 'southern naked-tailed armadillo').
ncbi_mult_taxo_gbnm(48868, 'greater Egyptian jerboa').
ncbi_mult_taxo_gbnm(48878, 'woodpecker finch').
ncbi_mult_taxo_gbnm(48883, 'medium ground-finch').
ncbi_mult_taxo_gbnm(48890, 'marsh tit').
ncbi_mult_taxo_gbnm(48891, 'Black-capped chickadee').
ncbi_mult_taxo_gbnm(48892, 'Carolina chickadee').
ncbi_mult_taxo_gbnm(48895, 'willow tit').
ncbi_mult_taxo_gbnm(48897, 'short-tailed gymnure').
ncbi_mult_taxo_gbnm(48905, 'Mindanao gymnure').
ncbi_mult_taxo_gbnm(48910, 'snow scorpionflies').
ncbi_mult_taxo_gbnm(48913, 'annular seabream').
ncbi_mult_taxo_gbnm(48914, 'Senegal seabream').
ncbi_mult_taxo_gbnm(48915, 'sharpsnout seabream').
ncbi_mult_taxo_gbnm(48988, 'common tube-nosed fruit bat').
ncbi_mult_taxo_gbnm(48991, 'shore flies').
ncbi_mult_taxo_gbnm(49148, 'swamp doghobble').
ncbi_mult_taxo_gbnm(49170, 'marsh Labrador tea').
ncbi_mult_taxo_gbnm(49203, 'Simony\'s lizard').
ncbi_mult_taxo_gbnm(49227, 'southern adder\'s-tongue').
ncbi_mult_taxo_gbnm(49314, cherimoya).
ncbi_mult_taxo_gbnm(49439, 'southern pygmy gerbils').
ncbi_mult_taxo_gbnm(49440, 'brush-tailed hairy-footed gerbil').
ncbi_mult_taxo_gbnm(49443, 'Darling\'s horseshoe bat').
ncbi_mult_taxo_gbnm(49444, 'African mole-rats').
ncbi_mult_taxo_gbnm(49445, 'East African mole rat').
ncbi_mult_taxo_gbnm(49450, 'wooly foxglove').
ncbi_mult_taxo_gbnm(49554, 'Scots lovage').
ncbi_mult_taxo_gbnm(49606, honeysuckles).
ncbi_mult_taxo_gbnm(49647, primroses).
ncbi_mult_taxo_gbnm(49652, 'Japanese jacinth').
ncbi_mult_taxo_gbnm(49797, horseflyweed).
ncbi_mult_taxo_gbnm(49814, 'white spanishbroom').
ncbi_mult_taxo_gbnm(49817, 'cockspur coraltree').
ncbi_mult_taxo_gbnm(49828, 'common laburnum').
ncbi_mult_taxo_gbnm(49848, 'French broom').
ncbi_mult_taxo_gbnm(49857, 'mountain soursop').
ncbi_mult_taxo_gbnm(49895, 'ornate bichir').
ncbi_mult_taxo_gbnm(49992, 'common thyme').
ncbi_mult_taxo_gbnm(49996, 'northern grey sassafras').
ncbi_mult_taxo_gbnm(50007, 'false spider mites').
ncbi_mult_taxo_gbnm(50023, 'citrus red mite').
ncbi_mult_taxo_gbnm(50024, 'European red spider mite').
ncbi_mult_taxo_gbnm(50047, 'red-footed tortoise').
ncbi_mult_taxo_gbnm(50148, 'ghost pipe').
ncbi_mult_taxo_gbnm(50178, 'plum yews').
ncbi_mult_taxo_gbnm(50184, 'celery pine').
ncbi_mult_taxo_gbnm(50189, 'Japanese torreya').
ncbi_mult_taxo_gbnm(50236, 'flowering-rush').
ncbi_mult_taxo_gbnm(50242, 'California false hellebore').
ncbi_mult_taxo_gbnm(50249, 'Red-breasted nuthatch').
ncbi_mult_taxo_gbnm(50251, 'wood nuthatch').
ncbi_mult_taxo_gbnm(50252, 'velvet-fronted nuthatch').
ncbi_mult_taxo_gbnm(50273, 'tansyleaf nightshade').
ncbi_mult_taxo_gbnm(50278, 'red cinchona').
ncbi_mult_taxo_gbnm(50347, 'yellow-backed duiker').
ncbi_mult_taxo_gbnm(50352, 'lobe-lipped bats').
ncbi_mult_taxo_gbnm(50353, 'chocolate-wattled bat').
ncbi_mult_taxo_gbnm(50365, 'White-fronted goose').
ncbi_mult_taxo_gbnm(50367, 'spectacled eider').
ncbi_mult_taxo_gbnm(50378, 'mountain cottontail').
ncbi_mult_taxo_gbnm(50380, 'marsh rabbit').
ncbi_mult_taxo_gbnm(50386, 'northern corn rootworm').
ncbi_mult_taxo_gbnm(50388, 'spotted cucumber beetle').
ncbi_mult_taxo_gbnm(50390, 'western corn rootworm').
ncbi_mult_taxo_gbnm(50392, 'Kentish plover').
ncbi_mult_taxo_gbnm(50393, 'inland dotterel').
ncbi_mult_taxo_gbnm(50394, 'Double-banded plover').
ncbi_mult_taxo_gbnm(50395, 'Collared plover').
ncbi_mult_taxo_gbnm(50396, 'Two-banded plover').
ncbi_mult_taxo_gbnm(50399, 'Red-capped plover').
ncbi_mult_taxo_gbnm(50402, killdeer).
ncbi_mult_taxo_gbnm(50406, 'black-fronted dotterel').
ncbi_mult_taxo_gbnm(50432, 'black witch').
ncbi_mult_taxo_gbnm(50434, 'dog flea').
ncbi_mult_taxo_gbnm(50435, 'brown lacewings').
ncbi_mult_taxo_gbnm(50439, 'common scorpionflies').
ncbi_mult_taxo_gbnm(50442, 'spicebush swallowtail').
ncbi_mult_taxo_gbnm(50447, 'long-horned earwigs').
ncbi_mult_taxo_gbnm(50451, rockcress).
ncbi_mult_taxo_gbnm(50452, 'gray rockcress').
ncbi_mult_taxo_gbnm(50455, oat).
ncbi_mult_taxo_gbnm(50457, 'winter cress').
ncbi_mult_taxo_gbnm(50458, 'early winter cress').
ncbi_mult_taxo_gbnm(50459, 'winter cress').
ncbi_mult_taxo_gbnm(50460, bittercresses).
ncbi_mult_taxo_gbnm(50462, 'woodland bittercress').
ncbi_mult_taxo_gbnm(50463, 'hairy bittercress').
ncbi_mult_taxo_gbnm(50464, 'small-leaf bittercress').
ncbi_mult_taxo_gbnm(50475, oca).
ncbi_mult_taxo_gbnm(50479, 'beaded lacewings').
ncbi_mult_taxo_gbnm(50482, snakeflies).
ncbi_mult_taxo_gbnm(50488, damselflies).
ncbi_mult_taxo_gbnm(50489, 'broad-winged damselflies').
ncbi_mult_taxo_gbnm(50491, 'black-wing damselfly').
ncbi_mult_taxo_gbnm(50495, yellowcress).
ncbi_mult_taxo_gbnm(50498, 'bog yellowcress').
ncbi_mult_taxo_gbnm(50500, 'variableleaf yellowcress').
ncbi_mult_taxo_gbnm(50507, 'Chinese magnolia-vine').
ncbi_mult_taxo_gbnm(50509, darners).
ncbi_mult_taxo_gbnm(50511, 'ball nightshade').
ncbi_mult_taxo_gbnm(50515, 'predacious diving beetles').
ncbi_mult_taxo_gbnm(50519, 'rhinoceros beetles, hercules beetles & elephant beetles').
ncbi_mult_taxo_gbnm(50527, 'jewel beetles').
ncbi_mult_taxo_gbnm(50545, 'red trillium').
ncbi_mult_taxo_gbnm(50548, 'reticulated beetles').
ncbi_mult_taxo_gbnm(50554, 'dobsonflies and fishflies').
ncbi_mult_taxo_gbnm(50557, insects).
ncbi_mult_taxo_gbnm(50558, 'jumping bristletails').
ncbi_mult_taxo_gbnm(50581, 'common burrower mayflies').
ncbi_mult_taxo_gbnm(50587, 'water springtails').
ncbi_mult_taxo_gbnm(50589, 'water springtail').
ncbi_mult_taxo_gbnm(50591, 'sand steenbras').
ncbi_mult_taxo_gbnm(50593, 'common pandora').
ncbi_mult_taxo_gbnm(50595, 'black seabream').
ncbi_mult_taxo_gbnm(50606, alderflies).
ncbi_mult_taxo_gbnm(50613, 'blackchin tilapia').
ncbi_mult_taxo_gbnm(50616, 'backswimmer bugs').
ncbi_mult_taxo_gbnm(50619, 'common barklice').
ncbi_mult_taxo_gbnm(50622, stoneflies).
ncbi_mult_taxo_gbnm(50623, 'predatory stoneflies').
ncbi_mult_taxo_gbnm(50626, 'velvet ants').
ncbi_mult_taxo_gbnm(50628, 'thistledown velvet ant').
ncbi_mult_taxo_gbnm(50629, 'chewing lice').
ncbi_mult_taxo_gbnm(50630, 'poultry lice').
ncbi_mult_taxo_gbnm(50633, 'spiny crawler mayflies').
ncbi_mult_taxo_gbnm(50638, 'potter wasps').
ncbi_mult_taxo_gbnm(50642, 'longhorned casemaker caddisflies').
ncbi_mult_taxo_gbnm(50645, 'northern casemaker caddisflies').
ncbi_mult_taxo_gbnm(50650, 'tarnished plant bug').
ncbi_mult_taxo_gbnm(50651, 'forceps flies').
ncbi_mult_taxo_gbnm(50654, 'shore bugs').
ncbi_mult_taxo_gbnm(50657, 'web-spinners').
ncbi_mult_taxo_gbnm(50673, 'robber flies').
ncbi_mult_taxo_gbnm(50674, 'bee flies').
ncbi_mult_taxo_gbnm(50675, 'window flies').
ncbi_mult_taxo_gbnm(50676, 'stiletto flies').
ncbi_mult_taxo_gbnm(50677, 'Mydas flies').
ncbi_mult_taxo_gbnm(50678, 'flower-loving flies').
ncbi_mult_taxo_gbnm(50681, 'grass flies').
ncbi_mult_taxo_gbnm(50722, 'agile kangaroo rat').
ncbi_mult_taxo_gbnm(50724, 'mountain pocket gopher').
ncbi_mult_taxo_gbnm(50725, 'southern pocket gopher').
ncbi_mult_taxo_gbnm(50731, 'sergeant major').
ncbi_mult_taxo_gbnm(50733, oscar).
ncbi_mult_taxo_gbnm(50735, 'peacock cichlid').
ncbi_mult_taxo_gbnm(50790, 'three spot damselfish').
ncbi_mult_taxo_gbnm(50791, surfperches).
ncbi_mult_taxo_gbnm(50794, 'shiner perch').
ncbi_mult_taxo_gbnm(50812, 'Egyptian mouth-brooder').
ncbi_mult_taxo_gbnm(50814, 'dwarf perch').
ncbi_mult_taxo_gbnm(50862, 'Columbian ground squirrel').
ncbi_mult_taxo_gbnm(50897, 'blue streak hap').
ncbi_mult_taxo_gbnm(50911, 'rough-backed river frog').
ncbi_mult_taxo_gbnm(50913, 'brown mountain frog').
ncbi_mult_taxo_gbnm(50914, 'Mindanao fanged frog').
ncbi_mult_taxo_gbnm(50915, 'Malaysian peat frog').
ncbi_mult_taxo_gbnm(50916, 'Sulawesi wart frog').
ncbi_mult_taxo_gbnm(50954, 'Iberian mole').
ncbi_mult_taxo_gbnm(50993, 'buttercup winterhazel').
ncbi_mult_taxo_gbnm(51010, 'fringed fruit-eating bat').
ncbi_mult_taxo_gbnm(51011, 'fraternal fruit-eating bat').
ncbi_mult_taxo_gbnm(51012, 'hairy fruit-eating bat').
ncbi_mult_taxo_gbnm(51013, 'Honduran fruit-eating bat').
ncbi_mult_taxo_gbnm(51015, 'Andersen\'s fruit-eating bat').
ncbi_mult_taxo_gbnm(51024, hydrilla).
ncbi_mult_taxo_gbnm(51028, 'human pinworm').
ncbi_mult_taxo_gbnm(51029, 'soybean cyst nematode').
ncbi_mult_taxo_gbnm(51031, 'New World hookworm').
ncbi_mult_taxo_gbnm(51070, 'bird\'s nest coral').
ncbi_mult_taxo_gbnm(51072, 'black turret coral').
ncbi_mult_taxo_gbnm(51073, 'pagoda coral').
ncbi_mult_taxo_gbnm(51089, nutmeg).
ncbi_mult_taxo_gbnm(51092, 'European harbour seal').
ncbi_mult_taxo_gbnm(51112, hydrocorals).
ncbi_mult_taxo_gbnm(51116, 'fire corals').
ncbi_mult_taxo_gbnm(51138, 'bluntnose minnow').
ncbi_mult_taxo_gbnm(51154, 'Chacoan peccary').
ncbi_mult_taxo_gbnm(51172, 'Blue Victoria mouthbrooder').
ncbi_mult_taxo_gbnm(51184, 'dwarf Victoria mouthbrooder').
ncbi_mult_taxo_gbnm(51212, 'black iguana').
ncbi_mult_taxo_gbnm(51215, 'Ricord\'s ground iguana').
ncbi_mult_taxo_gbnm(51236, 'bristly sarsaparilla').
ncbi_mult_taxo_gbnm(51240, 'Persian walnut').
ncbi_mult_taxo_gbnm(51241, 'galaxias and mudfish').
ncbi_mult_taxo_gbnm(51243, 'Cape galaxias').
ncbi_mult_taxo_gbnm(51250, 'Sudell\'s frog').
ncbi_mult_taxo_gbnm(51255, 'Amur honeysuckle').
ncbi_mult_taxo_gbnm(51291, chlamydias).
ncbi_mult_taxo_gbnm(51295, 'bird and rodent fleas').
ncbi_mult_taxo_gbnm(51300, noctule).
ncbi_mult_taxo_gbnm(51331, 'agile frog').
ncbi_mult_taxo_gbnm(51332, 'Greek frog').
ncbi_mult_taxo_gbnm(51337, 'lesser Egyptian jerboa').
ncbi_mult_taxo_gbnm(51338, 'American beaver').
ncbi_mult_taxo_gbnm(51342, 'mountain beaver').
ncbi_mult_taxo_gbnm(51346, 'woodland dormouse').
ncbi_mult_taxo_gbnm(51348, 'yellow-spotted brush-furred rat').
ncbi_mult_taxo_gbnm(51350, turnip).
ncbi_mult_taxo_gbnm(51351, 'Chinese cabbage').
ncbi_mult_taxo_gbnm(51356, 'Hairy woodpecker').
ncbi_mult_taxo_gbnm(51370, 'greater hooked squid').
ncbi_mult_taxo_gbnm(51373, 'short-tailed bandicoot rat').
ncbi_mult_taxo_gbnm(51501, 'African lily').
ncbi_mult_taxo_gbnm(51511, 'Pacific transparent sea squirt').
ncbi_mult_taxo_gbnm(51516, 'mud dragons').
ncbi_mult_taxo_gbnm(51549, 'stone moroko').
ncbi_mult_taxo_gbnm(51551, 'common stoneflies').
ncbi_mult_taxo_gbnm(51653, 'diamondback moths').
ncbi_mult_taxo_gbnm(51655, 'diamondback moth').
ncbi_mult_taxo_gbnm(51742, 'Cuban boa').
ncbi_mult_taxo_gbnm(51744, 'Turk\'s Island boa').
ncbi_mult_taxo_gbnm(51745, 'Abaco Island boa').
ncbi_mult_taxo_gbnm(51746, 'Fords boa').
ncbi_mult_taxo_gbnm(51747, 'Puerto Rican boa').
ncbi_mult_taxo_gbnm(51748, 'Mona Island boa').
ncbi_mult_taxo_gbnm(51750, 'Indian rock python').
ncbi_mult_taxo_gbnm(51751, 'ball python').
ncbi_mult_taxo_gbnm(51752, 'African rock python').
ncbi_mult_taxo_gbnm(51753, 'Timor python').
ncbi_mult_taxo_gbnm(51758, doctorfish).
ncbi_mult_taxo_gbnm(51765, 'bucktooth parrotfish').
ncbi_mult_taxo_gbnm(51766, 'redtail parrotfish').
ncbi_mult_taxo_gbnm(51789, 'clown wrasse').
ncbi_mult_taxo_gbnm(51798, 'gray angelfish').
ncbi_mult_taxo_gbnm(51799, 'false scorpions').
ncbi_mult_taxo_gbnm(51844, 'false coral snake').
ncbi_mult_taxo_gbnm(51846, 'Brahminy blind snake').
ncbi_mult_taxo_gbnm(51860, 'ringed tree boa').
ncbi_mult_taxo_gbnm(51861, 'emerald tree boa').
ncbi_mult_taxo_gbnm(51867, 'Rough-tailed sand Boa').
ncbi_mult_taxo_gbnm(51875, anacondas).
ncbi_mult_taxo_gbnm(51876, 'green anaconda').
ncbi_mult_taxo_gbnm(51877, 'yellow anaconda').
ncbi_mult_taxo_gbnm(51879, 'rosy boa').
ncbi_mult_taxo_gbnm(51883, 'Black-headed python').
ncbi_mult_taxo_gbnm(51888, 'Children\'s python').
ncbi_mult_taxo_gbnm(51891, 'eastern small-blotched python').
ncbi_mult_taxo_gbnm(51895, 'scrub python').
ncbi_mult_taxo_gbnm(51896, 'carpet python').
ncbi_mult_taxo_gbnm(51897, 'north-western carpet python').
ncbi_mult_taxo_gbnm(51898, 'peach-fronted parakeet').
ncbi_mult_taxo_gbnm(51900, 'hyacinth macaw').
ncbi_mult_taxo_gbnm(51902, 'Spix\'s macaw').
ncbi_mult_taxo_gbnm(51904, 'red-fan parrot').
ncbi_mult_taxo_gbnm(51908, 'Nanday parakeet').
ncbi_mult_taxo_gbnm(51949, 'harlequin poison frog').
ncbi_mult_taxo_gbnm(51950, 'strawberry poison frog').
ncbi_mult_taxo_gbnm(51951, 'Talamanca rocket frog').
ncbi_mult_taxo_gbnm(51953, 'African oil palm').
ncbi_mult_taxo_gbnm(51959, 'bluebelly poison frog').
ncbi_mult_taxo_gbnm(51980, 'Haitian dwarf boa').
ncbi_mult_taxo_gbnm(51993, 'shallot aphid').
ncbi_mult_taxo_gbnm(51996, stonefish).
ncbi_mult_taxo_gbnm(52072, 'jumbie teta').
ncbi_mult_taxo_gbnm(52073, 'bushymouth catfish').
ncbi_mult_taxo_gbnm(52100, 'dusky salamander').
ncbi_mult_taxo_gbnm(52101, 'imitator salamander').
ncbi_mult_taxo_gbnm(52104, 'Allegheny mountain salamander').
ncbi_mult_taxo_gbnm(52105, 'black-bellied salamander').
ncbi_mult_taxo_gbnm(52106, 'Santeetlah dusky salamander').
ncbi_mult_taxo_gbnm(52107, 'black mountain salamander').
ncbi_mult_taxo_gbnm(52108, 'pygmy salamander').
ncbi_mult_taxo_gbnm(52110, 'Red Hills salamander').
ncbi_mult_taxo_gbnm(52112, 'Hector\'s beaked whale').
ncbi_mult_taxo_gbnm(52113, 'True\'s beaked whale').
ncbi_mult_taxo_gbnm(52114, 'Stejneger\'s beaked whale').
ncbi_mult_taxo_gbnm(52116, 'Shepherd\'s beaked whale').
ncbi_mult_taxo_gbnm(52117, 'Barau\'s petrel').
ncbi_mult_taxo_gbnm(52120, 'Bulwer\'s petrel').
ncbi_mult_taxo_gbnm(52122, 'Scopoli\'s shearwater').
ncbi_mult_taxo_gbnm(52124, 'Leach\'s storm-petrel').
ncbi_mult_taxo_gbnm(52126, 'lesser snow-petrel').
ncbi_mult_taxo_gbnm(52128, 'Mascarene petrel').
ncbi_mult_taxo_gbnm(52129, 'Tahiti petrel').
ncbi_mult_taxo_gbnm(52137, 'red brome').
ncbi_mult_taxo_gbnm(52147, 'soft brome').
ncbi_mult_taxo_gbnm(52150, rescuegrass).
ncbi_mult_taxo_gbnm(52158, 'smilo grass').
ncbi_mult_taxo_gbnm(52167, 'North-African mastigure').
ncbi_mult_taxo_gbnm(52169, 'Przewalski\'s wonder gecko').
ncbi_mult_taxo_gbnm(52173, 'spinytail lizards').
ncbi_mult_taxo_gbnm(52179, 'Reticulate racerunner').
ncbi_mult_taxo_gbnm(52208, 'Southern rock agama').
ncbi_mult_taxo_gbnm(52210, 'brilliant ground agama').
ncbi_mult_taxo_gbnm(52224, 'Chinese crocodile lizard').
ncbi_mult_taxo_gbnm(52231, 'Geoffroy\'s marmoset').
ncbi_mult_taxo_gbnm(52232, 'Santarem marmoset').
ncbi_mult_taxo_gbnm(52237, 'mackerel icefish').
ncbi_mult_taxo_gbnm(52239, 'South Georgia icefish').
ncbi_mult_taxo_gbnm(52273, cabezon).
ncbi_mult_taxo_gbnm(52284, 'pygmy gerbil').
ncbi_mult_taxo_gbnm(52361, 'western pearlshell').
ncbi_mult_taxo_gbnm(52372, 'mapleleaf mussel').
ncbi_mult_taxo_gbnm(52383, 'paper pondshell').
ncbi_mult_taxo_gbnm(52407, 'gray brocket').
ncbi_mult_taxo_gbnm(52428, 'bristly millipede').
ncbi_mult_taxo_gbnm(52518, 'showy prairie gentian').
ncbi_mult_taxo_gbnm(52576, 'mountain horned lizard').
ncbi_mult_taxo_gbnm(52577, 'Desert horned lizard').
ncbi_mult_taxo_gbnm(52580, 'striped panchax').
ncbi_mult_taxo_gbnm(52581, 'blue panchax').
ncbi_mult_taxo_gbnm(52582, 'Kafue killifish').
ncbi_mult_taxo_gbnm(52583, 'redfin notho').
ncbi_mult_taxo_gbnm(52586, 'grape powdery mildew').
ncbi_mult_taxo_gbnm(52609, 'sedge warbler').
ncbi_mult_taxo_gbnm(52612, 'banded demoiselle').
ncbi_mult_taxo_gbnm(52617, 'Japanese crucian carp').
ncbi_mult_taxo_gbnm(52631, 'Lesser white-toothed shrew').
ncbi_mult_taxo_gbnm(52644, 'bald eagle').
ncbi_mult_taxo_gbnm(52647, 'Steller\'s sea-eagle').
ncbi_mult_taxo_gbnm(52650, 'willow ptarmigan').
ncbi_mult_taxo_gbnm(52653, 'lyretail killifish').
ncbi_mult_taxo_gbnm(52657, 'toothed carp').
ncbi_mult_taxo_gbnm(52664, 'golden panchax').
ncbi_mult_taxo_gbnm(52668, 'golden pheasant panchax').
ncbi_mult_taxo_gbnm(52729, 'march flies').
ncbi_mult_taxo_gbnm(52747, 'winter crane flies').
ncbi_mult_taxo_gbnm(52748, 'wood gnats').
ncbi_mult_taxo_gbnm(52749, 'minute black scavenger flies').
ncbi_mult_taxo_gbnm(52775, 'Oriental stork').
ncbi_mult_taxo_gbnm(52792, bluethroat).
ncbi_mult_taxo_gbnm(52804, 'thirteen-year cicada').
ncbi_mult_taxo_gbnm(52805, 'thirteen-year cicada').
ncbi_mult_taxo_gbnm(52806, 'thirteen-year cicada').
ncbi_mult_taxo_gbnm(52808, 'Indochinese ground squirrel').
ncbi_mult_taxo_gbnm(52810, 'black kite').
ncbi_mult_taxo_gbnm(52812, 'island mouse').
ncbi_mult_taxo_gbnm(52814, 'southern water shrew').
ncbi_mult_taxo_gbnm(52818, 'golden trumpet').
ncbi_mult_taxo_gbnm(52824, 'Ethiopian mustard').
ncbi_mult_taxo_gbnm(52826, 'string of hearts').
ncbi_mult_taxo_gbnm(52837, 'Brazilian jasmine').
ncbi_mult_taxo_gbnm(52838, 'Balbis banana').
ncbi_mult_taxo_gbnm(52853, 'white campion').
ncbi_mult_taxo_gbnm(52861, pinwheelflower).
ncbi_mult_taxo_gbnm(52886, 'Roman mole').
ncbi_mult_taxo_gbnm(52904, turbot).
ncbi_mult_taxo_gbnm(52907, 'Tien Shan birch mouse').
ncbi_mult_taxo_gbnm(52929, 'false limpets').
ncbi_mult_taxo_gbnm(52954, 'Tanganyika clown').
ncbi_mult_taxo_gbnm(53160, 'henbit deadnettle').
ncbi_mult_taxo_gbnm(53164, 'red dead-nettle').
ncbi_mult_taxo_gbnm(53173, 'common hedgenettle').
ncbi_mult_taxo_gbnm(53196, 'sarvis holly').
ncbi_mult_taxo_gbnm(53222, 'West Australian blue lupin').
ncbi_mult_taxo_gbnm(53275, 'hoary bamboo rat').
ncbi_mult_taxo_gbnm(53277, 'garden dormouse').
ncbi_mult_taxo_gbnm(53278, 'western gray squirrel').
ncbi_mult_taxo_gbnm(53279, 'moon-toothed degu').
ncbi_mult_taxo_gbnm(53505, 'Idaho ground squirrel').
ncbi_mult_taxo_gbnm(53580, 'Engelmann daisy').
ncbi_mult_taxo_gbnm(53666, 'Chatham Island petrel').
ncbi_mult_taxo_gbnm(53668, 'Cook\'s petrel').
ncbi_mult_taxo_gbnm(53673, 'white-headed petrel').
ncbi_mult_taxo_gbnm(53675, 'great-winged petrel').
ncbi_mult_taxo_gbnm(53677, 'soft-plumaged petrel').
ncbi_mult_taxo_gbnm(53730, 'green prairie coneflower').
ncbi_mult_taxo_gbnm(53852, 'golden shower tree').
ncbi_mult_taxo_gbnm(53854, 'partridge pea').
ncbi_mult_taxo_gbnm(53873, 'tonka bean').
ncbi_mult_taxo_gbnm(53883, 'Kentucky coffee tree').
ncbi_mult_taxo_gbnm(53885, 'false sarsaparilla').
ncbi_mult_taxo_gbnm(53893, 'sericea lespedeza').
ncbi_mult_taxo_gbnm(53923, 'candle bush').
ncbi_mult_taxo_gbnm(53941, shelligs).
ncbi_mult_taxo_gbnm(53942, 'lesser blue crab').
ncbi_mult_taxo_gbnm(53944, 'Atlantic mud crab').
ncbi_mult_taxo_gbnm(53951, 'Tenerife teydefinch').
ncbi_mult_taxo_gbnm(54017, 'Atlantic yellow-nosed albatross').
ncbi_mult_taxo_gbnm(54018, 'Buller\'s albatross').
ncbi_mult_taxo_gbnm(54021, 'Hawaiian black-footed albatross').
ncbi_mult_taxo_gbnm(54025, 'Grey-headed albatross').
ncbi_mult_taxo_gbnm(54026, 'Black-browed albatross').
ncbi_mult_taxo_gbnm(54052, 'Chilean skua').
ncbi_mult_taxo_gbnm(54054, 'brown skua').
ncbi_mult_taxo_gbnm(54056, 'great skua').
ncbi_mult_taxo_gbnm(54058, 'long-tailed jaeger').
ncbi_mult_taxo_gbnm(54079, 'short-eared rock wallaby').
ncbi_mult_taxo_gbnm(54080, monjon).
ncbi_mult_taxo_gbnm(54082, 'Godman\'s rock wallaby').
ncbi_mult_taxo_gbnm(54084, 'unadorned rock wallaby').
ncbi_mult_taxo_gbnm(54085, 'black-footed rock wallaby').
ncbi_mult_taxo_gbnm(54088, 'brush-tailed rock wallaby').
ncbi_mult_taxo_gbnm(54111, 'Barbary striped grass mouse').
ncbi_mult_taxo_gbnm(54131, 'Angolan colobus').
ncbi_mult_taxo_gbnm(54133, 'Red shanked douc langur').
ncbi_mult_taxo_gbnm(54135, 'Allen\'s swamp monkey').
ncbi_mult_taxo_gbnm(54136, 'leaf monkeys').
ncbi_mult_taxo_gbnm(54137, 'purple-faced leaf monkey').
ncbi_mult_taxo_gbnm(54180, 'Francois\'s langur').
ncbi_mult_taxo_gbnm(54181, 'Dusky leaf-monkey').
ncbi_mult_taxo_gbnm(54263, 'Alpine newt').
ncbi_mult_taxo_gbnm(54266, 'western starhead topminnow').
ncbi_mult_taxo_gbnm(54267, 'banded killifish').
ncbi_mult_taxo_gbnm(54268, 'russetfin topminnow').
ncbi_mult_taxo_gbnm(54269, 'lined topminnow').
ncbi_mult_taxo_gbnm(54270, 'bayou topminnow').
ncbi_mult_taxo_gbnm(54271, 'plains topminnow').
ncbi_mult_taxo_gbnm(54292, 'Yellow-necked field mouse').
ncbi_mult_taxo_gbnm(54317, logperch).
ncbi_mult_taxo_gbnm(54319, 'rainbow darter').
ncbi_mult_taxo_gbnm(54320, 'bluntnose darter').
ncbi_mult_taxo_gbnm(54321, 'ashy darter').
ncbi_mult_taxo_gbnm(54322, 'creole darter').
ncbi_mult_taxo_gbnm(54323, 'channel darter').
ncbi_mult_taxo_gbnm(54325, 'crystal darter').
ncbi_mult_taxo_gbnm(54326, 'brown darter').
ncbi_mult_taxo_gbnm(54327, 'Arkansas saddled darter').
ncbi_mult_taxo_gbnm(54328, 'gilt darter').
ncbi_mult_taxo_gbnm(54329, 'Iowa darter').
ncbi_mult_taxo_gbnm(54330, 'fantail darter').
ncbi_mult_taxo_gbnm(54331, 'slough darter').
ncbi_mult_taxo_gbnm(54332, 'harlequin darter').
ncbi_mult_taxo_gbnm(54333, 'greenthroat darter').
ncbi_mult_taxo_gbnm(54334, 'redband darter').
ncbi_mult_taxo_gbnm(54335, 'pinewoods darter').
ncbi_mult_taxo_gbnm(54336, 'longnose darter').
ncbi_mult_taxo_gbnm(54337, 'Johnny darter').
ncbi_mult_taxo_gbnm(54338, 'paleback darter').
ncbi_mult_taxo_gbnm(54339, 'goldstripe darter').
ncbi_mult_taxo_gbnm(54340, 'slenderhead darter').
ncbi_mult_taxo_gbnm(54341, 'orangebelly darter').
ncbi_mult_taxo_gbnm(54342, 'Cumberland arrow darter').
ncbi_mult_taxo_gbnm(54343, 'orangethroat darter').
ncbi_mult_taxo_gbnm(54344, 'speckled darter').
ncbi_mult_taxo_gbnm(54347, 'Tuscumbia darter').
ncbi_mult_taxo_gbnm(54348, 'glassy darter').
ncbi_mult_taxo_gbnm(54349, 'redfin darter').
ncbi_mult_taxo_gbnm(54350, 'greenside darter').
ncbi_mult_taxo_gbnm(54351, 'bluebreast darter').
ncbi_mult_taxo_gbnm(54352, 'yoke darter').
ncbi_mult_taxo_gbnm(54353, 'banded darter').
ncbi_mult_taxo_gbnm(54354, limpkins).
ncbi_mult_taxo_gbnm(54356, limpkin).
ncbi_mult_taxo_gbnm(54357, trumpeters).
ncbi_mult_taxo_gbnm(54359, 'common trumpeter').
ncbi_mult_taxo_gbnm(54361, 'mangrove rail').
ncbi_mult_taxo_gbnm(54363, 'rufous-sided crake').
ncbi_mult_taxo_gbnm(54366, 'South Island adzebill').
ncbi_mult_taxo_gbnm(54367, sungrebes).
ncbi_mult_taxo_gbnm(54369, sungrebe).
ncbi_mult_taxo_gbnm(54371, 'African finfoot').
ncbi_mult_taxo_gbnm(54374, 'brown roatelo').
ncbi_mult_taxo_gbnm(54375, bustards).
ncbi_mult_taxo_gbnm(54378, seriemas).
ncbi_mult_taxo_gbnm(54380, 'Red-legged seriema').
ncbi_mult_taxo_gbnm(54381, sunbitterns).
ncbi_mult_taxo_gbnm(54383, sunbittern).
ncbi_mult_taxo_gbnm(54384, kagu).
ncbi_mult_taxo_gbnm(54386, kagu).
ncbi_mult_taxo_gbnm(54390, 'painted coral snake').
ncbi_mult_taxo_gbnm(54423, 'Allegheny vine').
ncbi_mult_taxo_gbnm(54447, 'cabbage palmetto').
ncbi_mult_taxo_gbnm(54477, 'lilac chaste tree').
ncbi_mult_taxo_gbnm(54482, 'New Guinea flightless rail').
ncbi_mult_taxo_gbnm(54484, 'North Island takahe').
ncbi_mult_taxo_gbnm(54497, 'Chatham Island rail').
ncbi_mult_taxo_gbnm(54500, 'Dieffenbach\'s rail').
ncbi_mult_taxo_gbnm(54501, 'Lord Howe rail').
ncbi_mult_taxo_gbnm(54503, 'Australian lapwing').
ncbi_mult_taxo_gbnm(54504, jacanas).
ncbi_mult_taxo_gbnm(54506, 'comb-crested jacana').
ncbi_mult_taxo_gbnm(54508, 'wattled jacana').
ncbi_mult_taxo_gbnm(54556, bleak).
ncbi_mult_taxo_gbnm(54557, 'black-headed greenfinch').
ncbi_mult_taxo_gbnm(54559, 'lesser goldfinch').
ncbi_mult_taxo_gbnm(54560, 'yellow-bellied siskin').
ncbi_mult_taxo_gbnm(54563, 'common roach').
ncbi_mult_taxo_gbnm(54567, 'purple gallinule').
ncbi_mult_taxo_gbnm(54568, 'New Zealand coot').
ncbi_mult_taxo_gbnm(54577, 'white-collared jay').
ncbi_mult_taxo_gbnm(54579, 'plush-crested jay').
ncbi_mult_taxo_gbnm(54600, 'Celebes crested macaque').
ncbi_mult_taxo_gbnm(54601, 'liontail macaque').
ncbi_mult_taxo_gbnm(54602, 'Pere David\'s macaque').
ncbi_mult_taxo_gbnm(54647, 'buffalo treehoppers').
ncbi_mult_taxo_gbnm(54720, 'California lomatium').
ncbi_mult_taxo_gbnm(54733, 'star magnolia').
ncbi_mult_taxo_gbnm(54756, bagpod).
ncbi_mult_taxo_gbnm(54768, 'hooded siskin').
ncbi_mult_taxo_gbnm(54769, 'common redpoll').
ncbi_mult_taxo_gbnm(54770, 'yellow-breasted greenfinch').
ncbi_mult_taxo_gbnm(54772, 'black-headed siskin').
ncbi_mult_taxo_gbnm(54773, 'American goldfinch').
ncbi_mult_taxo_gbnm(54775, 'gray-crowned goldfinch').
ncbi_mult_taxo_gbnm(54776, 'Andean siskin').
ncbi_mult_taxo_gbnm(54777, 'thick-billed siskin').
ncbi_mult_taxo_gbnm(54835, 'summer snowflake').
ncbi_mult_taxo_gbnm(54874, 'honey locust').
ncbi_mult_taxo_gbnm(54878, 'elephant ear tree').
ncbi_mult_taxo_gbnm(54904, goldeye).
ncbi_mult_taxo_gbnm(54905, 'Hawaiian ladyfish').
ncbi_mult_taxo_gbnm(54906, bonefishes).
ncbi_mult_taxo_gbnm(54907, bonefishes).
ncbi_mult_taxo_gbnm(54909, bonefish).
ncbi_mult_taxo_gbnm(54916, 'snake eels').
ncbi_mult_taxo_gbnm(54918, 'king snake eel').
ncbi_mult_taxo_gbnm(54920, 'stippled spoon-nose eel').
ncbi_mult_taxo_gbnm(54921, 'red pine').
ncbi_mult_taxo_gbnm(54971, 'ruddy turnstone').
ncbi_mult_taxo_gbnm(54972, turnstones).
ncbi_mult_taxo_gbnm(55040, 'gray fox').
ncbi_mult_taxo_gbnm(55045, 'Palawan stink badger').
ncbi_mult_taxo_gbnm(55047, ringtail).
ncbi_mult_taxo_gbnm(55050, 'striped polecat').
ncbi_mult_taxo_gbnm(55052, 'Cape gray mongoose').
ncbi_mult_taxo_gbnm(55054, 'southern long-nosed bat').
ncbi_mult_taxo_gbnm(55055, 'morning glory sphinx moth').
ncbi_mult_taxo_gbnm(55057, 'cabbage moth').
ncbi_mult_taxo_gbnm(55084, 'emperor scorpion').
ncbi_mult_taxo_gbnm(55104, 'least killifish').
ncbi_mult_taxo_gbnm(55106, 'metallic livebearer').
ncbi_mult_taxo_gbnm(55108, 'dusky millions fish').
ncbi_mult_taxo_gbnm(55109, 'black arawana').
ncbi_mult_taxo_gbnm(55111, 'spiny eels').
ncbi_mult_taxo_gbnm(55115, gulpers).
ncbi_mult_taxo_gbnm(55117, 'pelican eel').
ncbi_mult_taxo_gbnm(55118, herrings).
ncbi_mult_taxo_gbnm(55119, shads).
ncbi_mult_taxo_gbnm(55120, 'freshwater herrings').
ncbi_mult_taxo_gbnm(55125, 'Pacific barracuda').
ncbi_mult_taxo_gbnm(55126, 'pelican barracuda').
ncbi_mult_taxo_gbnm(55127, 'Lucas barracuda').
ncbi_mult_taxo_gbnm(55129, sawfishes).
ncbi_mult_taxo_gbnm(55131, 'large-tooth sawfish').
ncbi_mult_taxo_gbnm(55133, 'saw sharks').
ncbi_mult_taxo_gbnm(55136, 'eagle rays').
ncbi_mult_taxo_gbnm(55138, 'Japanese eagle ray').
ncbi_mult_taxo_gbnm(55140, 'angel sharks').
ncbi_mult_taxo_gbnm(55142, 'clouded angelshark').
ncbi_mult_taxo_gbnm(55145, 'forest dormouse').
ncbi_mult_taxo_gbnm(55147, 'Japanese dormouse').
ncbi_mult_taxo_gbnm(55149, 'Eurasian red squirrel').
ncbi_mult_taxo_gbnm(55150, 'Japanese squirrel').
ncbi_mult_taxo_gbnm(55152, 'Siberian flying squirrel').
ncbi_mult_taxo_gbnm(55156, 'Japanese giant flying squirrel').
ncbi_mult_taxo_gbnm(55157, 'red giant flying squirrel').
ncbi_mult_taxo_gbnm(55186, 'large white trillium').
ncbi_mult_taxo_gbnm(55188, 'satsuma mandarin').
ncbi_mult_taxo_gbnm(55198, 'common walkingsticks').
ncbi_mult_taxo_gbnm(55262, 'cascara buckthorn').
ncbi_mult_taxo_gbnm(55286, 'vampire squids').
ncbi_mult_taxo_gbnm(55290, 'Amu Darya sturgeon').
ncbi_mult_taxo_gbnm(55291, 'gray bichir').
ncbi_mult_taxo_gbnm(55310, 'long-footed potoroo').
ncbi_mult_taxo_gbnm(55311, 'Cape-pondweed').
ncbi_mult_taxo_gbnm(55316, 'spiny naiad').
ncbi_mult_taxo_gbnm(55318, 'curly-leaf pondweed').
ncbi_mult_taxo_gbnm(55319, 'grass-leaf pondweed').
ncbi_mult_taxo_gbnm(55363, 'date-plum').
ncbi_mult_taxo_gbnm(55419, 'Le Conte\'s thrasher').
ncbi_mult_taxo_gbnm(55420, 'Crissal thrasher').
ncbi_mult_taxo_gbnm(55423, 'Atlantic fish-hunting cone').
ncbi_mult_taxo_gbnm(55431, 'green shield bug').
ncbi_mult_taxo_gbnm(55475, 'American frogbit').
ncbi_mult_taxo_gbnm(55520, 'Talas tuco-tuco').
ncbi_mult_taxo_gbnm(55521, 'veined rapa whelk').
ncbi_mult_taxo_gbnm(55534, 'spiny softshell turtle').
ncbi_mult_taxo_gbnm(55535, 'Williams African mud turtle').
ncbi_mult_taxo_gbnm(55542, 'Indian flap-shelled turtle').
ncbi_mult_taxo_gbnm(55544, 'big-headed turtle').
ncbi_mult_taxo_gbnm(55553, 'Shimofuri goby').
ncbi_mult_taxo_gbnm(55556, 'dusky tripletooth goby').
ncbi_mult_taxo_gbnm(55571, 'purple yam').
ncbi_mult_taxo_gbnm(55575, 'Chinese yam').
ncbi_mult_taxo_gbnm(55577, 'Guinea yam').
ncbi_mult_taxo_gbnm(55581, 'cush-cush yam').
ncbi_mult_taxo_gbnm(55598, bluemink).
ncbi_mult_taxo_gbnm(55605, 'acutelobed angelica').
ncbi_mult_taxo_gbnm(55611, 'big sagebrush').
ncbi_mult_taxo_gbnm(55634, 'black bryony').
ncbi_mult_taxo_gbnm(55661, 'common cuckoo').
ncbi_mult_taxo_gbnm(55720, 'swordtip squid').
ncbi_mult_taxo_gbnm(55766, 'Australian brome').
ncbi_mult_taxo_gbnm(55771, 'Japanese brome').
ncbi_mult_taxo_gbnm(55773, 'hairy chess').
ncbi_mult_taxo_gbnm(55782, numbat).
ncbi_mult_taxo_gbnm(55807, 'Superb fairywren').
ncbi_mult_taxo_gbnm(55824, leeches).
ncbi_mult_taxo_gbnm(55832, 'eastern elliptio').
ncbi_mult_taxo_gbnm(55837, 'painter\'s mussel').
ncbi_mult_taxo_gbnm(55860, 'nutmeg shells').
ncbi_mult_taxo_gbnm(55867, 'bark beetles').
ncbi_mult_taxo_gbnm(55869, 'Mediterranean pine engraver').
ncbi_mult_taxo_gbnm(55958, 'northern spicebush').
ncbi_mult_taxo_gbnm(55960, 'Adam\'s needle').
ncbi_mult_taxo_gbnm(55973, 'Transvolcanic jay').
ncbi_mult_taxo_gbnm(55984, 'European pine engraver').
ncbi_mult_taxo_gbnm(56046, 'Spanish fir').
ncbi_mult_taxo_gbnm(56060, 'flame-of-the-forest').
ncbi_mult_taxo_gbnm(56065, 'Indian beech tree').
ncbi_mult_taxo_gbnm(56067, 'American anhinga').
ncbi_mult_taxo_gbnm(56068, 'masked booby').
ncbi_mult_taxo_gbnm(56069, 'double-crested cormorant').
ncbi_mult_taxo_gbnm(56071, 'red-faced cormorant').
ncbi_mult_taxo_gbnm(56072, 'great blue heron').
ncbi_mult_taxo_gbnm(56073, 'plumed egrets').
ncbi_mult_taxo_gbnm(56074, 'reddish egret').
ncbi_mult_taxo_gbnm(56076, 'bar-bellied woodpecker').
ncbi_mult_taxo_gbnm(56079, 'yellow-bellied sapsucker').
ncbi_mult_taxo_gbnm(56085, 'Crimson-bellied woodpecker').
ncbi_mult_taxo_gbnm(56115, 'Spanish sparrow').
ncbi_mult_taxo_gbnm(56117, 'Baird\'s tapir').
ncbi_mult_taxo_gbnm(56154, 'Canterbury bells').
ncbi_mult_taxo_gbnm(56183, 'parasol mushroom').
ncbi_mult_taxo_gbnm(56194, 'snow sheep').
ncbi_mult_taxo_gbnm(56196, 'slender amaranth').
ncbi_mult_taxo_gbnm(56210, 'large vesper mouse').
ncbi_mult_taxo_gbnm(56211, 'small vesper mouse').
ncbi_mult_taxo_gbnm(56212, 'drylands vesper mouse').
ncbi_mult_taxo_gbnm(56213, 'fulvous harvest mouse').
ncbi_mult_taxo_gbnm(56214, 'yellow-nosed cotton rat').
ncbi_mult_taxo_gbnm(56216, 'desert woodrat').
ncbi_mult_taxo_gbnm(56217, 'White-chinned akodont').
ncbi_mult_taxo_gbnm(56219, 'northern pygmy mouse').
ncbi_mult_taxo_gbnm(56221, 'highland gerbil mouse').
ncbi_mult_taxo_gbnm(56225, 'diminutive woodrat').
ncbi_mult_taxo_gbnm(56227, 'vesper rat').
ncbi_mult_taxo_gbnm(56230, 'red hocicudo').
ncbi_mult_taxo_gbnm(56234, 'bunny rat').
ncbi_mult_taxo_gbnm(56236, 'Alston\'s brown mouse').
ncbi_mult_taxo_gbnm(56239, 'white-tailed mouse').
ncbi_mult_taxo_gbnm(56242, 'western heather vole').
ncbi_mult_taxo_gbnm(56263, 'red-tailed hawk').
ncbi_mult_taxo_gbnm(56264, 'saw-whet owls').
ncbi_mult_taxo_gbnm(56265, 'northern saw-whet owl').
ncbi_mult_taxo_gbnm(56267, 'short-eared owl').
ncbi_mult_taxo_gbnm(56268, 'great horned owl').
ncbi_mult_taxo_gbnm(56273, 'Philippine scops-owl').
ncbi_mult_taxo_gbnm(56278, 'Baikal teal').
ncbi_mult_taxo_gbnm(56281, 'Ross\' goose').
ncbi_mult_taxo_gbnm(56289, 'Luzon hawk-owl').
ncbi_mult_taxo_gbnm(56292, 'lilac-breasted roller').
ncbi_mult_taxo_gbnm(56294, 'yellow-crowned night heron').
ncbi_mult_taxo_gbnm(56297, 'crowned sandgrouse').
ncbi_mult_taxo_gbnm(56301, turacos).
ncbi_mult_taxo_gbnm(56304, 'Hartlaub\'s turaco').
ncbi_mult_taxo_gbnm(56307, 'painted buttonquail').
ncbi_mult_taxo_gbnm(56308, 'trogons and quetzals').
ncbi_mult_taxo_gbnm(56311, 'black-tailed trogon').
ncbi_mult_taxo_gbnm(56313, 'common barn owl').
ncbi_mult_taxo_gbnm(56315, 'Eastern phoebe').
ncbi_mult_taxo_gbnm(56316, 'brush mouse').
ncbi_mult_taxo_gbnm(56317, 'Mexican deer mouse').
ncbi_mult_taxo_gbnm(56319, 'crested-tailed deer mouse').
ncbi_mult_taxo_gbnm(56321, 'Mt. Pirri Isthmus rat').
ncbi_mult_taxo_gbnm(56323, 'Florida mouse').
ncbi_mult_taxo_gbnm(56324, 'red-backed shrike').
ncbi_mult_taxo_gbnm(56327, 'vermilion cardinal').
ncbi_mult_taxo_gbnm(56330, 'Sharp-shinned hawk').
ncbi_mult_taxo_gbnm(56332, 'spot-winged falconet').
ncbi_mult_taxo_gbnm(56341, 'Philippine falconet').
ncbi_mult_taxo_gbnm(56347, 'Red-throated caracara').
ncbi_mult_taxo_gbnm(56351, 'red-footed falcon').
ncbi_mult_taxo_gbnm(56364, 'black cutworm moth').
ncbi_mult_taxo_gbnm(56366, 'copper underwing').
ncbi_mult_taxo_gbnm(56376, 'plum tree underwing').
ncbi_mult_taxo_gbnm(56382, 'brown-hooded owlet').
ncbi_mult_taxo_gbnm(56392, 'hemina pinion').
ncbi_mult_taxo_gbnm(56396, 'gray half-spot').
ncbi_mult_taxo_gbnm(56400, 'rustic quaker').
ncbi_mult_taxo_gbnm(56432, 'ashy-throated warbler').
ncbi_mult_taxo_gbnm(56435, 'Pallas\'s leaf-warbler').
ncbi_mult_taxo_gbnm(56436, 'yellow-browed warbler').
ncbi_mult_taxo_gbnm(56440, 'pale-legged leaf-warbler').
ncbi_mult_taxo_gbnm(56549, 'Loo-Choo big-tooth snake').
ncbi_mult_taxo_gbnm(56554, 'shortjaw cisco').
ncbi_mult_taxo_gbnm(56566, 'tufted white pine caterpillar').
ncbi_mult_taxo_gbnm(56572, 'yellowmarked caterpillar').
ncbi_mult_taxo_gbnm(56578, 'olive-shaded bird-dropping moth').
ncbi_mult_taxo_gbnm(56588, 'gray furcula').
ncbi_mult_taxo_gbnm(56596, 'scarletwinged lichen moth').
ncbi_mult_taxo_gbnm(56613, 'clearfin livebearer').
ncbi_mult_taxo_gbnm(56639, tamaraw).
ncbi_mult_taxo_gbnm(56640, 'mountain anoa').
ncbi_mult_taxo_gbnm(56659, 'Tyrian metaltail').
ncbi_mult_taxo_gbnm(56707, 'Shasta salamander').
ncbi_mult_taxo_gbnm(56718, 'combtooth blennies').
ncbi_mult_taxo_gbnm(56720, shanny).
ncbi_mult_taxo_gbnm(56722, congolli).
ncbi_mult_taxo_gbnm(56723, 'ballan wrasse').
ncbi_mult_taxo_gbnm(56724, gunnels).
ncbi_mult_taxo_gbnm(56726, 'rock gunnel').
ncbi_mult_taxo_gbnm(56733, 'Patagonian blennie').
ncbi_mult_taxo_gbnm(56737, 'greater weever').
ncbi_mult_taxo_gbnm(56781, 'Common raven').
ncbi_mult_taxo_gbnm(56783, 'Eurasian jay').
ncbi_mult_taxo_gbnm(56796, 'blue magpie').
ncbi_mult_taxo_gbnm(56798, 'pygmy hippopotamus').
ncbi_mult_taxo_gbnm(56864, 'celandine poppy').
ncbi_mult_taxo_gbnm(56866, 'angled luffa').
ncbi_mult_taxo_gbnm(56892, 'Huon pine').
ncbi_mult_taxo_gbnm(56897, 'outeniqua yellowwood').
ncbi_mult_taxo_gbnm(56958, 'Natal fruit fly').
ncbi_mult_taxo_gbnm(56994, 'hoop pine').
ncbi_mult_taxo_gbnm(57060, 'Puerto Rican coqui').
ncbi_mult_taxo_gbnm(57062, 'coffee berry borer').
ncbi_mult_taxo_gbnm(57064, 'Yellow-headed dwarf gecko').
ncbi_mult_taxo_gbnm(57068, rifleman).
ncbi_mult_taxo_gbnm(57073, 'red-tailed tropicbird').
ncbi_mult_taxo_gbnm(57074, 'Derbyan parakeet').
ncbi_mult_taxo_gbnm(57075, 'Northern barred owl').
ncbi_mult_taxo_gbnm(57095, 'Egyptian grasshopper').
ncbi_mult_taxo_gbnm(57098, 'rhinocerus iguana').
ncbi_mult_taxo_gbnm(57100, 'Aztec mouse').
ncbi_mult_taxo_gbnm(57104, 'transvolcanic deermouse').
ncbi_mult_taxo_gbnm(57105, 'Gleaning mouse').
ncbi_mult_taxo_gbnm(57106, 'Winkelmann\'s mouse').
ncbi_mult_taxo_gbnm(57123, 'dark southern subterranean termite').
ncbi_mult_taxo_gbnm(57175, 'black-headed night monkey').
ncbi_mult_taxo_gbnm(57176, 'noisy night monkey').
ncbi_mult_taxo_gbnm(57236, 'western grebe').
ncbi_mult_taxo_gbnm(57237, 'military macaw').
ncbi_mult_taxo_gbnm(57240, 'Royal penguin').
ncbi_mult_taxo_gbnm(57242, 'Morepork').
ncbi_mult_taxo_gbnm(57247, 'grey parrot').
ncbi_mult_taxo_gbnm(57294, 'sea spiders').
ncbi_mult_taxo_gbnm(57298, 'striped shield bug').
ncbi_mult_taxo_gbnm(57307, 'blue mbuna').
ncbi_mult_taxo_gbnm(57312, 'Southern bunchgrass lizard').
ncbi_mult_taxo_gbnm(57374, 'golden-headed lion tamarin').
ncbi_mult_taxo_gbnm(57375, 'white-eared marmoset').
ncbi_mult_taxo_gbnm(57378, 'black-pencilled marmoset').
ncbi_mult_taxo_gbnm(57379, hornbills).
ncbi_mult_taxo_gbnm(57384, mousebirds).
ncbi_mult_taxo_gbnm(57392, 'rufous-tailed hummingbird').
ncbi_mult_taxo_gbnm(57395, 'Oriental pied-hornbill').
ncbi_mult_taxo_gbnm(57397, 'bar-tailed trogon').
ncbi_mult_taxo_gbnm(57402, 'greater coucal').
ncbi_mult_taxo_gbnm(57406, 'green kingfisher').
ncbi_mult_taxo_gbnm(57412, 'speckled mousebird').
ncbi_mult_taxo_gbnm(57421, 'carmine bee-eater').
ncbi_mult_taxo_gbnm(57426, 'Blue-crowned motmot').
ncbi_mult_taxo_gbnm(57428, 'eared poorwill').
ncbi_mult_taxo_gbnm(57439, 'Eurasian hoopoe').
ncbi_mult_taxo_gbnm(57486, 'Japanese wild mouse').
ncbi_mult_taxo_gbnm(57514, 'carrion beetles').
ncbi_mult_taxo_gbnm(57515, 'sexton beetles').
ncbi_mult_taxo_gbnm(57540, 'arboreal salamanders').
ncbi_mult_taxo_gbnm(57542, 'slender salamanders').
ncbi_mult_taxo_gbnm(57543, 'Inyo Mountains salamander').
ncbi_mult_taxo_gbnm(57544, 'Channel Islands slender salamander').
ncbi_mult_taxo_gbnm(57546, 'Kern Canyon slender salamander').
ncbi_mult_taxo_gbnm(57547, 'Oregon slender salamander').
ncbi_mult_taxo_gbnm(57550, 'common Ensatina').
ncbi_mult_taxo_gbnm(57551, 'yellow-blotched Ensatina').
ncbi_mult_taxo_gbnm(57552, 'Oregon Ensatina').
ncbi_mult_taxo_gbnm(57553, 'limestone salamander').
ncbi_mult_taxo_gbnm(57554, 'Monte Albo cave salamander').
ncbi_mult_taxo_gbnm(57555, 'Italian cave salamander').
ncbi_mult_taxo_gbnm(57556, 'Mount Lyell salamander').
ncbi_mult_taxo_gbnm(57569, 'fire salamanders').
ncbi_mult_taxo_gbnm(57571, 'fire salamander').
ncbi_mult_taxo_gbnm(57577, 'red clover').
ncbi_mult_taxo_gbnm(57610, 'auger shells').
ncbi_mult_taxo_gbnm(57614, volutes).
ncbi_mult_taxo_gbnm(57622, 'channeled whelk').
ncbi_mult_taxo_gbnm(57649, 'trident maple').
ncbi_mult_taxo_gbnm(57652, 'mountain maple').
ncbi_mult_taxo_gbnm(57655, 'Indian soapberry').
ncbi_mult_taxo_gbnm(57662, 'red-footed booby').
ncbi_mult_taxo_gbnm(57734, 'Baikal yellowfin').
ncbi_mult_taxo_gbnm(57737, 'Hog deer').
ncbi_mult_taxo_gbnm(57751, 'Madagascar partridge').
ncbi_mult_taxo_gbnm(57752, 'Red-billed francolin').
ncbi_mult_taxo_gbnm(57756, 'Finsch\'s francolin').
ncbi_mult_taxo_gbnm(57760, 'Red-winged francolin').
ncbi_mult_taxo_gbnm(57761, 'Orange River francolin').
ncbi_mult_taxo_gbnm(57763, 'crested francolin').
ncbi_mult_taxo_gbnm(57764, 'Shelley\'s francolin').
ncbi_mult_taxo_gbnm(57766, 'Swainson\'s spurfowl').
ncbi_mult_taxo_gbnm(57774, 'glossy blenny').
ncbi_mult_taxo_gbnm(57776, 'roughhead blenny').
ncbi_mult_taxo_gbnm(57777, 'browncheek blenny').
ncbi_mult_taxo_gbnm(57779, 'penpoint gunnel').
ncbi_mult_taxo_gbnm(57780, 'kelp gunnel').
ncbi_mult_taxo_gbnm(57784, 'Cortez triplefin').
ncbi_mult_taxo_gbnm(57788, cline).
ncbi_mult_taxo_gbnm(57792, nalolo).
ncbi_mult_taxo_gbnm(57794, 'Gulf signal blenny').
ncbi_mult_taxo_gbnm(57796, 'West African rockhopper').
ncbi_mult_taxo_gbnm(57797, 'rock blenny').
ncbi_mult_taxo_gbnm(57801, 'spotted kelpfish').
ncbi_mult_taxo_gbnm(57802, 'striped kelpfish').
ncbi_mult_taxo_gbnm(57803, 'crevice kelpfish').
ncbi_mult_taxo_gbnm(57805, 'seven-bar weedfish').
ncbi_mult_taxo_gbnm(57807, 'Wilson\'s weedfish').
ncbi_mult_taxo_gbnm(57809, 'giant kelpfish').
ncbi_mult_taxo_gbnm(57811, 'bay blenny').
ncbi_mult_taxo_gbnm(57812, 'rockpool blenny').
ncbi_mult_taxo_gbnm(57818, 'bigfin eelpout').
ncbi_mult_taxo_gbnm(57822, 'redside blenny').
ncbi_mult_taxo_gbnm(57824, 'foureye rockskipper').
ncbi_mult_taxo_gbnm(57830, 'sarcastic fringehead').
ncbi_mult_taxo_gbnm(57837, 'muzzled blenny').
ncbi_mult_taxo_gbnm(57839, 'black-back snake-blenny').
ncbi_mult_taxo_gbnm(57841, 'large-banded blenny').
ncbi_mult_taxo_gbnm(57845, 'reef finspot').
ncbi_mult_taxo_gbnm(57847, 'striped poison-fang blenny mimic').
ncbi_mult_taxo_gbnm(57849, 'bluebarred prickleback').
ncbi_mult_taxo_gbnm(57851, 'barred-chin blenny').
ncbi_mult_taxo_gbnm(57855, 'smooth-eye blenny').
ncbi_mult_taxo_gbnm(57856, 'dwarf blenny').
ncbi_mult_taxo_gbnm(57860, 'sand crawler').
ncbi_mult_taxo_gbnm(57865, ruffe).
ncbi_mult_taxo_gbnm(57866, 'blackside darter').
ncbi_mult_taxo_gbnm(57907, 'jumping bristletail').
ncbi_mult_taxo_gbnm(57918, 'wild strawberry').
ncbi_mult_taxo_gbnm(57926, 'silverweed cinquefoil').
ncbi_mult_taxo_gbnm(57935, 'cinnamon rose').
ncbi_mult_taxo_gbnm(57974, 'basking sharks').
ncbi_mult_taxo_gbnm(57979, 'pelagic thresher').
ncbi_mult_taxo_gbnm(57980, 'bigeye thresher').
ncbi_mult_taxo_gbnm(57983, 'shortfin mako shark').
ncbi_mult_taxo_gbnm(57987, 'goblin shark').
ncbi_mult_taxo_gbnm(57989, 'smalltooth sand tiger').
ncbi_mult_taxo_gbnm(57992, 'concealer moths').
ncbi_mult_taxo_gbnm(57993, 'damsel bugs').
ncbi_mult_taxo_gbnm(57995, 'purse casemaker caddisflies').
ncbi_mult_taxo_gbnm(58002, 'grape phylloxera').
ncbi_mult_taxo_gbnm(58030, 'Lawson\'s cypress').
ncbi_mult_taxo_gbnm(58039, 'common juniper').
ncbi_mult_taxo_gbnm(58041, 'Swiss stone pine').
ncbi_mult_taxo_gbnm(58042, 'Austrian pine').
ncbi_mult_taxo_gbnm(58055, 'horseshoe bats').
ncbi_mult_taxo_gbnm(58057, 'Sulawesi fruit bat').
ncbi_mult_taxo_gbnm(58059, 'Bulmer\'s fruit bat').
ncbi_mult_taxo_gbnm(58060, 'lesser short-nosed fruit bat').
ncbi_mult_taxo_gbnm(58063, 'Malagasy straw-colored fruit bat').
ncbi_mult_taxo_gbnm(58065, 'lesser dawn bat').
ncbi_mult_taxo_gbnm(58067, 'Wahlberg\'s epauletted fruit bat').
ncbi_mult_taxo_gbnm(58069, 'Cantor\'s roundleaf bat').
ncbi_mult_taxo_gbnm(58071, 'Angolan soft-furred fruit bat').
ncbi_mult_taxo_gbnm(58073, 'Woermann\'s bat').
ncbi_mult_taxo_gbnm(58076, 'Sinaloan mastiff bat').
ncbi_mult_taxo_gbnm(58078, 'long-tailed fruit bat').
ncbi_mult_taxo_gbnm(58079, 'Queensland tube-nosed fruit bat').
ncbi_mult_taxo_gbnm(58081, 'Guadalcanal monkey-faced bat').
ncbi_mult_taxo_gbnm(58082, 'admiralty flying fox').
ncbi_mult_taxo_gbnm(58083, 'Geoffroy\'s rousette').
ncbi_mult_taxo_gbnm(58085, 'southern blossom bat').
ncbi_mult_taxo_gbnm(58087, 'swift fruit bat').
ncbi_mult_taxo_gbnm(58139, 'hooded tickspiders').
ncbi_mult_taxo_gbnm(58151, 'whip scorpions').
ncbi_mult_taxo_gbnm(58176, 'Great Basin spotted frog').
ncbi_mult_taxo_gbnm(58187, 'brown ball frog').
ncbi_mult_taxo_gbnm(58191, 'Boettger\'s wall gecko').
ncbi_mult_taxo_gbnm(58195, 'Mediterranean house gecko').
ncbi_mult_taxo_gbnm(58197, 'brown trembler').
ncbi_mult_taxo_gbnm(58205, 'streaked saltator').
ncbi_mult_taxo_gbnm(58209, 'blue-gray tanager').
ncbi_mult_taxo_gbnm(58211, 'House wren').
ncbi_mult_taxo_gbnm(58220, 'Japanese scad').
ncbi_mult_taxo_gbnm(58254, 'predatory fungus gnats').
ncbi_mult_taxo_gbnm(58317, 'white bream').
ncbi_mult_taxo_gbnm(58319, rudd).
ncbi_mult_taxo_gbnm(58321, spirlin).
ncbi_mult_taxo_gbnm(58323, sunbleak).
ncbi_mult_taxo_gbnm(58324, 'Eurasian minnow').
ncbi_mult_taxo_gbnm(58325, 'common dace').
ncbi_mult_taxo_gbnm(58327, 'Amur bitterling').
ncbi_mult_taxo_gbnm(58512, 'Fiji tree frog').
ncbi_mult_taxo_gbnm(58513, 'Japanese Buerger\'s frog').
ncbi_mult_taxo_gbnm(58517, 'Gunther\'s triangle frog').
ncbi_mult_taxo_gbnm(58519, 'skittering frog').
ncbi_mult_taxo_gbnm(58522, 'netted adder\'s-tongue').
ncbi_mult_taxo_gbnm(58536, 'tooth-legged grasshoppers').
ncbi_mult_taxo_gbnm(58544, 'bladder grasshoppers').
ncbi_mult_taxo_gbnm(58545, 'stick grasshoppers').
ncbi_mult_taxo_gbnm(58557, 'rock crawlers').
ncbi_mult_taxo_gbnm(58560, 'rufous grasshopper').
ncbi_mult_taxo_gbnm(58603, 'tree weta').
ncbi_mult_taxo_gbnm(58656, 'hairy cat\'s-ear').
ncbi_mult_taxo_gbnm(58664, 'African teak').
ncbi_mult_taxo_gbnm(58674, 'large-blotched Ensatina').
ncbi_mult_taxo_gbnm(58675, 'painted Ensatina').
ncbi_mult_taxo_gbnm(58676, 'Sierra Nevada Ensatina').
ncbi_mult_taxo_gbnm(58677, 'yellow-eyed Enstina').
ncbi_mult_taxo_gbnm(58699, 'Richardson\'s least gecko').
ncbi_mult_taxo_gbnm(58705, 'cat greenbrier').
ncbi_mult_taxo_gbnm(58710, 'golden-rumped lion tamarin').
ncbi_mult_taxo_gbnm(58767, 'giant whipscorpion').
ncbi_mult_taxo_gbnm(58774, 'shield shrimps and tadpole shrimps').
ncbi_mult_taxo_gbnm(58822, 'minute leaf miner moths').
ncbi_mult_taxo_gbnm(58824, 'Indianmeal moth').
ncbi_mult_taxo_gbnm(58886, 'Mexican palo verde').
ncbi_mult_taxo_gbnm(59016, 'Virginia spiderwort').
ncbi_mult_taxo_gbnm(59054, 'bridal creeper').
ncbi_mult_taxo_gbnm(59166, 'common cornsalad').
ncbi_mult_taxo_gbnm(59291, 'common whitefish').
ncbi_mult_taxo_gbnm(59296, inconnu).
ncbi_mult_taxo_gbnm(59403, groundhoppers).
ncbi_mult_taxo_gbnm(59409, 'Diard\'s trogon').
ncbi_mult_taxo_gbnm(59419, 'white-tailed trogon').
ncbi_mult_taxo_gbnm(59445, 'ghost-faced bats').
ncbi_mult_taxo_gbnm(59446, 'funnel-eared bats').
ncbi_mult_taxo_gbnm(59447, 'hollow-faced bats').
ncbi_mult_taxo_gbnm(59449, 'western barbastelle').
ncbi_mult_taxo_gbnm(59453, 'diadem roundleaf bat').
ncbi_mult_taxo_gbnm(59455, 'papillose woolly bat').
ncbi_mult_taxo_gbnm(59456, 'Mexican long-nosed bat').
ncbi_mult_taxo_gbnm(59460, 'ghost-faced bat').
ncbi_mult_taxo_gbnm(59461, 'large-footed bat').
ncbi_mult_taxo_gbnm(59462, 'Bechstein\'s bat').
ncbi_mult_taxo_gbnm(59463, 'little brown bat').
ncbi_mult_taxo_gbnm(59464, 'giant noctule').
ncbi_mult_taxo_gbnm(59465, 'lesser noctule').
ncbi_mult_taxo_gbnm(59467, 'Egyptian slit-faced bat').
ncbi_mult_taxo_gbnm(59471, 'Gould\'s long-eared bat').
ncbi_mult_taxo_gbnm(59472, 'Kuhl\'s pipistrelle').
ncbi_mult_taxo_gbnm(59473, 'Nathusius\'s pipistrelle').
ncbi_mult_taxo_gbnm(59474, 'common pipistrelle').
ncbi_mult_taxo_gbnm(59476, 'Parnell\'s mustached bat').
ncbi_mult_taxo_gbnm(59477, 'intermediate horseshoe bat').
ncbi_mult_taxo_gbnm(59478, 'Geoffroy\'s horseshoe bat').
ncbi_mult_taxo_gbnm(59479, 'greater horseshoe bat').
ncbi_mult_taxo_gbnm(59480, 'lesser woolly horseshoe bat').
ncbi_mult_taxo_gbnm(59482, 'greater sac-winged bat').
ncbi_mult_taxo_gbnm(59483, 'European free-tailed bat').
ncbi_mult_taxo_gbnm(59485, 'particolored bat').
ncbi_mult_taxo_gbnm(59487, 'Trinidadian funnel-eared bat').
ncbi_mult_taxo_gbnm(59489, 'Brown tube-nosed bat').
ncbi_mult_taxo_gbnm(59492, 'yellow Himalayan raspberry').
ncbi_mult_taxo_gbnm(59495, 'snowpeaks raspberry').
ncbi_mult_taxo_gbnm(59517, hartebeest).
ncbi_mult_taxo_gbnm(59519, 'Red hartebeest').
ncbi_mult_taxo_gbnm(59520, 'Lichtenstein\'s hartebeest').
ncbi_mult_taxo_gbnm(59523, springbok).
ncbi_mult_taxo_gbnm(59525, blackbuck).
ncbi_mult_taxo_gbnm(59528, 'black wildebeest').
ncbi_mult_taxo_gbnm(59529, 'goitered gazelle').
ncbi_mult_taxo_gbnm(59530, kob).
ncbi_mult_taxo_gbnm(59531, lechwe).
ncbi_mult_taxo_gbnm(59532, 'Nile lechwe').
ncbi_mult_taxo_gbnm(59533, puku).
ncbi_mult_taxo_gbnm(59534, 'scimitar-horned oryx').
ncbi_mult_taxo_gbnm(59536, oribi).
ncbi_mult_taxo_gbnm(59538, chiru).
ncbi_mult_taxo_gbnm(59540, 'Tibetan gazelle').
ncbi_mult_taxo_gbnm(59542, bharal).
ncbi_mult_taxo_gbnm(59544, steenbok).
ncbi_mult_taxo_gbnm(59552, 'common rhebok').
ncbi_mult_taxo_gbnm(59554, 'southern reedbuck').
ncbi_mult_taxo_gbnm(59555, 'mountain reedbuck').
ncbi_mult_taxo_gbnm(59556, 'Bohar reedbuck').
ncbi_mult_taxo_gbnm(59557, 'summer truffle').
ncbi_mult_taxo_gbnm(59626, 'zombi-pea').
ncbi_mult_taxo_gbnm(59636, 'northwestern salamander').
ncbi_mult_taxo_gbnm(59643, 'blue-tongued lizard tick').
ncbi_mult_taxo_gbnm(59654, 'Tasmanian possum tick').
ncbi_mult_taxo_gbnm(59655, 'common seabird tick').
ncbi_mult_taxo_gbnm(59659, 'longtooth parrotfish').
ncbi_mult_taxo_gbnm(59661, 'striped parrotfish').
ncbi_mult_taxo_gbnm(59662, 'greenblotch parrotfish').
ncbi_mult_taxo_gbnm(59663, 'redband parrotfish').
ncbi_mult_taxo_gbnm(59665, 'redfin parrotfish').
ncbi_mult_taxo_gbnm(59666, 'stoplight parrotfish').
ncbi_mult_taxo_gbnm(59693, 'Dunes sagebrush lizard').
ncbi_mult_taxo_gbnm(59706, 'lined spiny lizard').
ncbi_mult_taxo_gbnm(59709, 'largescale spiny lizard').
ncbi_mult_taxo_gbnm(59714, 'ornate spiny lizard').
ncbi_mult_taxo_gbnm(59715, 'blue ornate spiny lizard').
ncbi_mult_taxo_gbnm(59717, 'painted cursorial spiny lizard').
ncbi_mult_taxo_gbnm(59729, 'zebra finch').
ncbi_mult_taxo_gbnm(59755, 'slipper lobsters').
ncbi_mult_taxo_gbnm(59763, 'ridged slipper lobster').
ncbi_mult_taxo_gbnm(59766, 'Duges\' spiny lizard').
ncbi_mult_taxo_gbnm(59768, 'Yarrow\'s spiny lizard').
ncbi_mult_taxo_gbnm(59776, 'lily of the valley tree').
ncbi_mult_taxo_gbnm(59837, 'spot croaker').
ncbi_mult_taxo_gbnm(59861, 'lake whitefish').
ncbi_mult_taxo_gbnm(59862, bloater).
ncbi_mult_taxo_gbnm(59863, kiyi).
ncbi_mult_taxo_gbnm(59894, 'Collared flycatcher').
ncbi_mult_taxo_gbnm(59895, artichoke).
ncbi_mult_taxo_gbnm(59896, urial).
ncbi_mult_taxo_gbnm(59899, 'walking catfish').
ncbi_mult_taxo_gbnm(59933, 'Andean big-eared mouse').
ncbi_mult_taxo_gbnm(59934, 'friendly leaf-eared mouse').
ncbi_mult_taxo_gbnm(59935, 'Andean leaf-eared mouse').
ncbi_mult_taxo_gbnm(59937, 'master leaf-eared mouse').
ncbi_mult_taxo_gbnm(59938, 'Osgood\'s leaf-eared mouse').
ncbi_mult_taxo_gbnm(59939, 'Bunchgrass leaf-eared mouse').
ncbi_mult_taxo_gbnm(59940, 'Wolffsohn\'s leaf-eared mouse').
ncbi_mult_taxo_gbnm(59941, 'yellow-rumped leaf-eared mouse').
ncbi_mult_taxo_gbnm(59946, 'silver gemfish').
ncbi_mult_taxo_gbnm(59948, 'Plain greenbul').
ncbi_mult_taxo_gbnm(59950, 'Yellow-whiskered greenbul').
ncbi_mult_taxo_gbnm(59956, 'Stripe-faced greenbul').
ncbi_mult_taxo_gbnm(60093, 'lesser periwinkle').
ncbi_mult_taxo_gbnm(60181, 'Spotted whistling-duck').
ncbi_mult_taxo_gbnm(60182, 'lesser whistling duck').
ncbi_mult_taxo_gbnm(60220, 'black-headed bushmaster').
ncbi_mult_taxo_gbnm(60262, 'blue lyretail').
ncbi_mult_taxo_gbnm(60270, 'golden killifish').
ncbi_mult_taxo_gbnm(60272, 'banner lyretail').
ncbi_mult_taxo_gbnm(60273, 'Cameroon killifish').
ncbi_mult_taxo_gbnm(60275, 'Christy\'s lyretail').
ncbi_mult_taxo_gbnm(60277, 'sky-blue killifish').
ncbi_mult_taxo_gbnm(60278, 'redspot panchax').
ncbi_mult_taxo_gbnm(60279, 'Gabon jewelfish').
ncbi_mult_taxo_gbnm(60281, 'elegant killifish').
ncbi_mult_taxo_gbnm(60282, 'false jewel killifish').
ncbi_mult_taxo_gbnm(60283, 'jewel killifish').
ncbi_mult_taxo_gbnm(60284, 'Gabon killifish').
ncbi_mult_taxo_gbnm(60289, 'Congo killifish').
ncbi_mult_taxo_gbnm(60304, 'Togo killifish').
ncbi_mult_taxo_gbnm(60402, 'Guinean killifish').
ncbi_mult_taxo_gbnm(60419, 'Chinese chestnut').
ncbi_mult_taxo_gbnm(60423, 'American beech').
ncbi_mult_taxo_gbnm(60458, 'winter truffle').
ncbi_mult_taxo_gbnm(60466, 'yellow-collared lovebird').
ncbi_mult_taxo_gbnm(60467, 'red-headed lovebird').
ncbi_mult_taxo_gbnm(60468, 'peach-faced lovebird').
ncbi_mult_taxo_gbnm(60702, 'Pilbara ningaui').
ncbi_mult_taxo_gbnm(60710, vervet).
ncbi_mult_taxo_gbnm(60711, 'green monkey').
ncbi_mult_taxo_gbnm(60712, 'tantalus monkey').
ncbi_mult_taxo_gbnm(60713, 'Northern mockingbird').
ncbi_mult_taxo_gbnm(60742, 'Temminck\'s mouse').
ncbi_mult_taxo_gbnm(60745, 'fiery spiny mouse').
ncbi_mult_taxo_gbnm(60746, 'golden spiny mouse').
ncbi_mult_taxo_gbnm(60891, 'New England cottontail').
ncbi_mult_taxo_gbnm(60963, 'Cajun dwarf crayfish').
ncbi_mult_taxo_gbnm(61075, 'silky lupine').
ncbi_mult_taxo_gbnm(61076, 'woolly-leaf lupine').
ncbi_mult_taxo_gbnm(61084, ayu).
ncbi_mult_taxo_gbnm(61086, 'Beccari\'s shrew').
ncbi_mult_taxo_gbnm(61087, 'thick-tailed shrew').
ncbi_mult_taxo_gbnm(61088, 'elongated shrew').
ncbi_mult_taxo_gbnm(61090, 'Southeast Asian shrew').
ncbi_mult_taxo_gbnm(61091, 'Sulawesi shrew').
ncbi_mult_taxo_gbnm(61093, 'Celebes shrew').
ncbi_mult_taxo_gbnm(61094, 'Mindoro shrew').
ncbi_mult_taxo_gbnm(61096, 'black-footed shrew').
ncbi_mult_taxo_gbnm(61097, 'paradox shrew').
ncbi_mult_taxo_gbnm(61098, 'Temboan shrew').
ncbi_mult_taxo_gbnm(61102, 'Arizona lupine').
ncbi_mult_taxo_gbnm(61107, 'Inyo bush lupine').
ncbi_mult_taxo_gbnm(61111, 'seashore lupine').
ncbi_mult_taxo_gbnm(61112, 'butter lupine').
ncbi_mult_taxo_gbnm(61120, 'Coulter\'s lupine').
ncbi_mult_taxo_gbnm(61121, 'sulphur lupine').
ncbi_mult_taxo_gbnm(61124, 'Indonesian shortfin eel').
ncbi_mult_taxo_gbnm(61125, 'Indonesian shortfin eel').
ncbi_mult_taxo_gbnm(61126, 'Indian short-finned eel').
ncbi_mult_taxo_gbnm(61127, 'New Zealand longfin eel').
ncbi_mult_taxo_gbnm(61154, 'Abyssinian grass rat').
ncbi_mult_taxo_gbnm(61156, 'Nile rat').
ncbi_mult_taxo_gbnm(61159, 'Bellier\'s striped grass mouse').
ncbi_mult_taxo_gbnm(61161, 'Southern cleft lizard').
ncbi_mult_taxo_gbnm(61165, 'Eastern fence lizard').
ncbi_mult_taxo_gbnm(61167, 'boojum tree').
ncbi_mult_taxo_gbnm(61168, 'Dermacentor andersoni endosymbiont').
ncbi_mult_taxo_gbnm(61180, 'nodular worm').
ncbi_mult_taxo_gbnm(61195, 'Australian giant treefrog').
ncbi_mult_taxo_gbnm(61221, 'Komodo dragon').
ncbi_mult_taxo_gbnm(61225, 'Tokara Habu').
ncbi_mult_taxo_gbnm(61236, 'Kamchatka fritillary').
ncbi_mult_taxo_gbnm(61250, 'mountain harebell').
ncbi_mult_taxo_gbnm(61263, 'Rhinoceros auklet').
ncbi_mult_taxo_gbnm(61276, 'greater big-footed mouse').
ncbi_mult_taxo_gbnm(61289, 'southwestern corn borer').
ncbi_mult_taxo_gbnm(61308, 'Phoenician juniper').
ncbi_mult_taxo_gbnm(61309, 'staghorn ferns').
ncbi_mult_taxo_gbnm(61310, 'elephant\'s-ear fern').
ncbi_mult_taxo_gbnm(61316, 'northern hog sucker').
ncbi_mult_taxo_gbnm(61318, 'central stoneroller').
ncbi_mult_taxo_gbnm(61323, 'slender madtom').
ncbi_mult_taxo_gbnm(61376, 'jungle cat').
ncbi_mult_taxo_gbnm(61377, 'Near Eastern wildcat').
ncbi_mult_taxo_gbnm(61378, 'sand cat').
ncbi_mult_taxo_gbnm(61379, 'black-footed cat').
ncbi_mult_taxo_gbnm(61382, margay).
ncbi_mult_taxo_gbnm(61383, 'Canada lynx').
ncbi_mult_taxo_gbnm(61384, bobcat).
ncbi_mult_taxo_gbnm(61386, kodkod).
ncbi_mult_taxo_gbnm(61387, 'rusty-spotted cat').
ncbi_mult_taxo_gbnm(61388, 'fishing cat').
ncbi_mult_taxo_gbnm(61400, 'ring-tailed mongoose').
ncbi_mult_taxo_gbnm(61403, 'flat-headed cat').
ncbi_mult_taxo_gbnm(61405, serval).
ncbi_mult_taxo_gbnm(61408, 'Pallas\'s cat').
ncbi_mult_taxo_gbnm(61410, 'marbled cat').
ncbi_mult_taxo_gbnm(61412, 'African golden cat').
ncbi_mult_taxo_gbnm(61428, 'West China toad').
ncbi_mult_taxo_gbnm(61450, 'sheep\'s sorrel').
ncbi_mult_taxo_gbnm(61452, 'Clouded leopard').
ncbi_mult_taxo_gbnm(61454, 'bay cat').
ncbi_mult_taxo_gbnm(61455, 'Asiatic golden cat').
ncbi_mult_taxo_gbnm(61474, 'California timema').
ncbi_mult_taxo_gbnm(61590, nannyberry).
ncbi_mult_taxo_gbnm(61614, 'Spanish painted frog').
ncbi_mult_taxo_gbnm(61616, 'western spadefoot toad').
ncbi_mult_taxo_gbnm(61618, 'Phayre\'s leaf monkey').
ncbi_mult_taxo_gbnm(61620, cowfish).
ncbi_mult_taxo_gbnm(61621, 'black snub-nosed monkey').
ncbi_mult_taxo_gbnm(61622, 'golden snub-nosed monkey').
ncbi_mult_taxo_gbnm(61626, 'stone sculpin').
ncbi_mult_taxo_gbnm(61627, 'longin Baikal sculpin').
ncbi_mult_taxo_gbnm(61674, sturgeon).
ncbi_mult_taxo_gbnm(61679, 'neon flying squid').
ncbi_mult_taxo_gbnm(61693, 'deepsea squid').
ncbi_mult_taxo_gbnm(61805, 'firemouth cichlid').
ncbi_mult_taxo_gbnm(61817, 'blue-eye cichlid').
ncbi_mult_taxo_gbnm(61819, 'Midas cichlid').
ncbi_mult_taxo_gbnm(61820, 'red devil').
ncbi_mult_taxo_gbnm(61836, 'saberfin killie').
ncbi_mult_taxo_gbnm(61837, 'small Japanese field mouse').
ncbi_mult_taxo_gbnm(61851, 'hoolock gibbon').
ncbi_mult_taxo_gbnm(61852, 'Red-cheeked gibbon').
ncbi_mult_taxo_gbnm(61853, 'northern white-cheeked gibbon').
ncbi_mult_taxo_gbnm(61861, 'Brazilian jackbean').
ncbi_mult_taxo_gbnm(61862, 'brown big-eared bat').
ncbi_mult_taxo_gbnm(61864, 'Christmas-bells').
ncbi_mult_taxo_gbnm(61865, 'blacktip shark').
ncbi_mult_taxo_gbnm(61866, 'Conover\'s tuco-tuco').
ncbi_mult_taxo_gbnm(61867, 'forest tuco-tuco').
ncbi_mult_taxo_gbnm(61868, 'Goodfellow\'s tuco-tuco').
ncbi_mult_taxo_gbnm(61869, 'Haig\'s tuco-tuco').
ncbi_mult_taxo_gbnm(61871, 'white-toothed tuco-tuco').
ncbi_mult_taxo_gbnm(61872, 'Lewis\'s tuco-tuco').
ncbi_mult_taxo_gbnm(61874, 'Mendoza tuco-tuco').
ncbi_mult_taxo_gbnm(61877, 'highland tuco-tuco').
ncbi_mult_taxo_gbnm(61878, 'Steinbach\'s tuco-tuco').
ncbi_mult_taxo_gbnm(61880, coruro).
ncbi_mult_taxo_gbnm(61882, 'plains viscacha rat').
ncbi_mult_taxo_gbnm(61918, 'bird\'s-eyes').
ncbi_mult_taxo_gbnm(61966, 'Sakhalin sturgeon').
ncbi_mult_taxo_gbnm(61967, 'fringebarbel sturgeon').
ncbi_mult_taxo_gbnm(61968, 'Persian sturgeon').
ncbi_mult_taxo_gbnm(61970, 'Chinese sturgeon').
ncbi_mult_taxo_gbnm(61971, beluga).
ncbi_mult_taxo_gbnm(61976, 'Chinese swordfish').
ncbi_mult_taxo_gbnm(61977, 'whip spiders').
ncbi_mult_taxo_gbnm(61986, symphylans).
ncbi_mult_taxo_gbnm(61993, 'slender entrophs').
ncbi_mult_taxo_gbnm(62018, 'American ruby spot damselfly').
ncbi_mult_taxo_gbnm(62038, 'Short-tailed pygmy monitor').
ncbi_mult_taxo_gbnm(62041, perentie).
ncbi_mult_taxo_gbnm(62042, 'Gould\'s goanna').
ncbi_mult_taxo_gbnm(62043, 'Mangrove monitor').
ncbi_mult_taxo_gbnm(62046, 'Nile monitor').
ncbi_mult_taxo_gbnm(62051, 'water monitor').
ncbi_mult_taxo_gbnm(62058, 'Borneo earless monitor').
ncbi_mult_taxo_gbnm(62061, 'Yangtze sturgeon').
ncbi_mult_taxo_gbnm(62062, huchen).
ncbi_mult_taxo_gbnm(62067, 'lenok trout').
ncbi_mult_taxo_gbnm(62085, 'red-headed tanager').
ncbi_mult_taxo_gbnm(62086, 'scarlet tanager').
ncbi_mult_taxo_gbnm(62097, frangipani).
ncbi_mult_taxo_gbnm(62101, 'Bugula neritina bacterial symbiont').
ncbi_mult_taxo_gbnm(62187, 'white-rumped tanager').
ncbi_mult_taxo_gbnm(62193, 'glossy flowerpiercer').
ncbi_mult_taxo_gbnm(62226, 'white-banded tanager').
ncbi_mult_taxo_gbnm(62259, 'orange-crowned warbler').
ncbi_mult_taxo_gbnm(62272, 'large-toothed Siberian shrew').
ncbi_mult_taxo_gbnm(62273, 'slender shrew').
ncbi_mult_taxo_gbnm(62274, 'miniscule shrew').
ncbi_mult_taxo_gbnm(62275, 'long-clawed shrew').
ncbi_mult_taxo_gbnm(62276, 'Laxmann\'s shrew').
ncbi_mult_taxo_gbnm(62277, 'Dsinezumi shrew').
ncbi_mult_taxo_gbnm(62279, 'Azumi shrew').
ncbi_mult_taxo_gbnm(62280, 'Eurasian pygmy shrew').
ncbi_mult_taxo_gbnm(62281, 'even-toothed shrew').
ncbi_mult_taxo_gbnm(62282, 'Eurasian water shrew').
ncbi_mult_taxo_gbnm(62283, 'smoky shrew').
ncbi_mult_taxo_gbnm(62284, 'Radde\'s shrew').
ncbi_mult_taxo_gbnm(62285, 'Sado shrew').
ncbi_mult_taxo_gbnm(62286, 'Shinto shrew').
ncbi_mult_taxo_gbnm(62287, 'tundra shrew').
ncbi_mult_taxo_gbnm(62288, 'flat-skulled shrew').
ncbi_mult_taxo_gbnm(62289, 'Ussuri shrew').
ncbi_mult_taxo_gbnm(62291, 'Hodgson\'s brown-toothed shrew').
ncbi_mult_taxo_gbnm(62293, 'flat-headed water shrew').
ncbi_mult_taxo_gbnm(62295, 'Japanese mole').
ncbi_mult_taxo_gbnm(62296, 'Himalayan shrew').
ncbi_mult_taxo_gbnm(62324, 'African malaria mosquito').
ncbi_mult_taxo_gbnm(62330, 'Tartarian buckwheat').
ncbi_mult_taxo_gbnm(62335, 'wild sugarcane').
ncbi_mult_taxo_gbnm(62337, eulalia).
ncbi_mult_taxo_gbnm(62343, 'brittle naiad').
ncbi_mult_taxo_gbnm(62617, 'antelope jackrabbit').
ncbi_mult_taxo_gbnm(62618, 'Arctic hare').
ncbi_mult_taxo_gbnm(62619, 'white-sided jackrabbit').
ncbi_mult_taxo_gbnm(62620, 'Alaskan hare').
ncbi_mult_taxo_gbnm(62621, 'Mountain hare').
ncbi_mult_taxo_gbnm(62627, 'citrophilus mealybug').
ncbi_mult_taxo_gbnm(62680, 'SAR406 cluster').
ncbi_mult_taxo_gbnm(62696, 'New Zealand Christmas tree').
ncbi_mult_taxo_gbnm(62698, 'Atlantic walrus').
ncbi_mult_taxo_gbnm(62729, 'Volga pikeperch').
ncbi_mult_taxo_gbnm(62746, 'emma field cricket').
ncbi_mult_taxo_gbnm(62747, 'red-legged earwigs').
ncbi_mult_taxo_gbnm(62753, 'African juniper').
ncbi_mult_taxo_gbnm(62768, 'cave crickets').
ncbi_mult_taxo_gbnm(62769, 'camel crickets').
ncbi_mult_taxo_gbnm(62784, katydids).
ncbi_mult_taxo_gbnm(62802, 'spring stoneflies').
ncbi_mult_taxo_gbnm(62884, 'Mexican mahogany').
ncbi_mult_taxo_gbnm(62894, 'Lagranja shrew').
ncbi_mult_taxo_gbnm(62895, 'crowned shrew').
ncbi_mult_taxo_gbnm(62896, 'Caucasian shrew').
ncbi_mult_taxo_gbnm(62897, 'Tien Shan shrew').
ncbi_mult_taxo_gbnm(62898, 'Arctic shrew').
ncbi_mult_taxo_gbnm(62899, 'Apennine shrew').
ncbi_mult_taxo_gbnm(62900, 'Caucasian pygmy shrew').
ncbi_mult_taxo_gbnm(62901, 'lofty shrew').
ncbi_mult_taxo_gbnm(62902, 'alpine shrew').
ncbi_mult_taxo_gbnm(62903, 'montane shrew').
ncbi_mult_taxo_gbnm(62904, 'Pacific shrew').
ncbi_mult_taxo_gbnm(62905, 'vagrant shrew').
ncbi_mult_taxo_gbnm(62906, 'Trowbridge\'s shrew').
ncbi_mult_taxo_gbnm(62941, 'nasute termites').
ncbi_mult_taxo_gbnm(62965, 'Japanese sleeper ray').
ncbi_mult_taxo_gbnm(63054, 'Japanese hackberry').
ncbi_mult_taxo_gbnm(63058, 'Chinese elm').
ncbi_mult_taxo_gbnm(63086, thrift).
ncbi_mult_taxo_gbnm(63143, 'western quoll').
ncbi_mult_taxo_gbnm(63155, 'flier cichlid').
ncbi_mult_taxo_gbnm(63156, 'topaz cichlid').
ncbi_mult_taxo_gbnm(63160, 'T-bar cichlid').
ncbi_mult_taxo_gbnm(63170, 'rainbow cichlid').
ncbi_mult_taxo_gbnm(63177, guapote).
ncbi_mult_taxo_gbnm(63221, 'Neandertal').
ncbi_mult_taxo_gbnm(63224, 'scrub hare').
ncbi_mult_taxo_gbnm(63225, 'white-tailed jackrabbit').
ncbi_mult_taxo_gbnm(63233, 'large-mouth bowel worm').
ncbi_mult_taxo_gbnm(63338, 'viviparous spikerush').
ncbi_mult_taxo_gbnm(63345, 'vanilla leaf').
ncbi_mult_taxo_gbnm(63347, 'umbrella leaf').
ncbi_mult_taxo_gbnm(63355, 'Japanese witch hazel').
ncbi_mult_taxo_gbnm(63357, 'Ozark witch-hazel').
ncbi_mult_taxo_gbnm(63359, 'Formosan gum').
ncbi_mult_taxo_gbnm(63360, 'Oriental sweet gum').
ncbi_mult_taxo_gbnm(63442, 'Fendler\'s bladderpod').
ncbi_mult_taxo_gbnm(63459, quinoa).
ncbi_mult_taxo_gbnm(63464, 'Easter herald\'s trumpet').
ncbi_mult_taxo_gbnm(63479, 'common oleander').
ncbi_mult_taxo_gbnm(63517, 'flame-colored tanager').
ncbi_mult_taxo_gbnm(63518, 'hepatic tanager').
ncbi_mult_taxo_gbnm(63519, 'white-winged tanager').
ncbi_mult_taxo_gbnm(63520, 'western tanager').
ncbi_mult_taxo_gbnm(63521, 'rose-throated tanager').
ncbi_mult_taxo_gbnm(63522, 'red-hooded tanager').
ncbi_mult_taxo_gbnm(63558, 'great star coral').
ncbi_mult_taxo_gbnm(63614, 'Angolan mole-rat').
ncbi_mult_taxo_gbnm(63616, 'Darling\'s mole-rat').
ncbi_mult_taxo_gbnm(63624, 'false German cockroach').
ncbi_mult_taxo_gbnm(63626, 'relict cockroach').
ncbi_mult_taxo_gbnm(63631, 'Steller\'s sea cow').
ncbi_mult_taxo_gbnm(63633, 'Brandegee\'s desertparsley').
ncbi_mult_taxo_gbnm(63634, 'adobe desertparsley').
ncbi_mult_taxo_gbnm(63635, 'fernleaf biscuitroot').
ncbi_mult_taxo_gbnm(63636, 'king desert parsley').
ncbi_mult_taxo_gbnm(63637, 'Greenman\'s biscuitroot').
ncbi_mult_taxo_gbnm(63638, 'Idaho biscuitroot').
ncbi_mult_taxo_gbnm(63639, 'canyonlands biscuitroot').
ncbi_mult_taxo_gbnm(63640, 'shiny biscuitroot').
ncbi_mult_taxo_gbnm(63641, 'barestem biscuitroot').
ncbi_mult_taxo_gbnm(63642, 'Nuttall\'s biscuitroot').
ncbi_mult_taxo_gbnm(63643, 'coastal biscuitroot').
ncbi_mult_taxo_gbnm(63644, 'Napa biscuitroot').
ncbi_mult_taxo_gbnm(63645, 'Big Pine biscuitroot').
ncbi_mult_taxo_gbnm(63646, 'Owens Peak desertparsley').
ncbi_mult_taxo_gbnm(63647, 'nineleaf biscuitroot').
ncbi_mult_taxo_gbnm(63671, 'turban shells').
ncbi_mult_taxo_gbnm(63678, 'tower rockcress').
ncbi_mult_taxo_gbnm(63766, 'Argentine tuco-tuco').
ncbi_mult_taxo_gbnm(63769, 'Natterer\'s tuco-tuco').
ncbi_mult_taxo_gbnm(63779, 'garden balsam').
ncbi_mult_taxo_gbnm(63787, 'South American air plant').
ncbi_mult_taxo_gbnm(63824, 'pampas deer').
ncbi_mult_taxo_gbnm(63826, clingfishes).
ncbi_mult_taxo_gbnm(63828, 'northern clingfish').
ncbi_mult_taxo_gbnm(63897, 'wrinkled bark beetles').
ncbi_mult_taxo_gbnm(63901, 'burrowing water beetles').
ncbi_mult_taxo_gbnm(63912, 'moth lacewings').
ncbi_mult_taxo_gbnm(63975, 'Spanish moon moth').
ncbi_mult_taxo_gbnm(63990, 'Indian eri silkmoth').
ncbi_mult_taxo_gbnm(64099, 'blackthroat cichlid').
ncbi_mult_taxo_gbnm(64108, 'John dory').
ncbi_mult_taxo_gbnm(64144, 'climbing perch').
ncbi_mult_taxo_gbnm(64145, 'Bangka snakehead').
ncbi_mult_taxo_gbnm(64147, 'emperor snakehead').
ncbi_mult_taxo_gbnm(64148, 'black snakehead').
ncbi_mult_taxo_gbnm(64149, 'giant snakehead').
ncbi_mult_taxo_gbnm(64150, 'walking snakehead').
ncbi_mult_taxo_gbnm(64152, 'snakehead murrel').
ncbi_mult_taxo_gbnm(64174, urutu).
ncbi_mult_taxo_gbnm(64176, 'Common wall lizard').
ncbi_mult_taxo_gbnm(64185, 'Gila trout').
ncbi_mult_taxo_gbnm(64278, 'Great-tailed grackle').
ncbi_mult_taxo_gbnm(64356, 'needle-cast of pine').
ncbi_mult_taxo_gbnm(64387, 'seed weevils').
ncbi_mult_taxo_gbnm(64391, 'cowpea weevil').
ncbi_mult_taxo_gbnm(64415, 'Crimean wall lizard').
ncbi_mult_taxo_gbnm(64451, 'large wood nymph').
ncbi_mult_taxo_gbnm(64457, malachite).
ncbi_mult_taxo_gbnm(64459, 'cabbage white').
ncbi_mult_taxo_gbnm(64463, 'rock shrimps').
ncbi_mult_taxo_gbnm(64466, 'pink shrimp').
ncbi_mult_taxo_gbnm(64468, 'white shrimp').
ncbi_mult_taxo_gbnm(64469, 'ridgeback rock shrimp').
ncbi_mult_taxo_gbnm(64533, 'headwater catfish').
ncbi_mult_taxo_gbnm(64534, 'Yaqui catfish').
ncbi_mult_taxo_gbnm(64535, 'bluelip haplo').
ncbi_mult_taxo_gbnm(64549, 'Guinean tilapia').
ncbi_mult_taxo_gbnm(64550, 'Okavango tilapia').
ncbi_mult_taxo_gbnm(64551, 'banded tilapia').
ncbi_mult_taxo_gbnm(64557, 'lionhead cichlid').
ncbi_mult_taxo_gbnm(64580, lindens).
ncbi_mult_taxo_gbnm(64664, 'gray-bellied squirrel').
ncbi_mult_taxo_gbnm(64668, 'rock ptarmigan').
ncbi_mult_taxo_gbnm(64676, 'Prevost\'s squirrel').
ncbi_mult_taxo_gbnm(64677, 'Pallas\'s squirrel').
ncbi_mult_taxo_gbnm(64678, 'plantain squirrel').
ncbi_mult_taxo_gbnm(64679, 'yellow-pine chipmunk').
ncbi_mult_taxo_gbnm(64680, 'Siberian chipmunk').
ncbi_mult_taxo_gbnm(64681, 'Northern palm squirrel').
ncbi_mult_taxo_gbnm(64682, 'Japanese flying squirrel').
ncbi_mult_taxo_gbnm(64683, 'southern flying squirrel').
ncbi_mult_taxo_gbnm(64696, 'convergent lady beetle').
ncbi_mult_taxo_gbnm(64793, 'little fire ant').
ncbi_mult_taxo_gbnm(64799, 'Hawaii amakihi').
ncbi_mult_taxo_gbnm(64802, 'red crossbill').
ncbi_mult_taxo_gbnm(64806, 'Kauai creeper').
ncbi_mult_taxo_gbnm(64884, 'rough lemon').
ncbi_mult_taxo_gbnm(64900, 'American burying beetle').
ncbi_mult_taxo_gbnm(65030, 'brownheaded leafroller').
ncbi_mult_taxo_gbnm(65035, 'greenheaded leafroller').
ncbi_mult_taxo_gbnm(65125, brill).
ncbi_mult_taxo_gbnm(65351, pepperwort).
ncbi_mult_taxo_gbnm(65378, 'chestnut-capped brush-finch').
ncbi_mult_taxo_gbnm(65379, 'stripe-headed brush-finch').
ncbi_mult_taxo_gbnm(65382, 'tule elk').
ncbi_mult_taxo_gbnm(65476, 'green lizard').
ncbi_mult_taxo_gbnm(65481, 'Filfola wall lizard').
ncbi_mult_taxo_gbnm(65483, 'Aeolian wall lizard').
ncbi_mult_taxo_gbnm(65484, 'Italian wall lizard').
ncbi_mult_taxo_gbnm(65557, hollyhock).
ncbi_mult_taxo_gbnm(65558, caperbush).
ncbi_mult_taxo_gbnm(65560, 'crown-of-thorns').
ncbi_mult_taxo_gbnm(65569, 'yellow-throated warbler').
ncbi_mult_taxo_gbnm(65570, 'arrowhead warbler').
ncbi_mult_taxo_gbnm(65571, 'olive-capped warbler').
ncbi_mult_taxo_gbnm(65572, 'plumbeous warbler').
ncbi_mult_taxo_gbnm(65606, 'cinnamon antechinus').
ncbi_mult_taxo_gbnm(65607, 'long-fingered triok').
ncbi_mult_taxo_gbnm(65608, 'Doria\'s tree kangaroo').
ncbi_mult_taxo_gbnm(65609, 'tenkile tree kangaroo').
ncbi_mult_taxo_gbnm(65610, 'Clara\'s echymipera').
ncbi_mult_taxo_gbnm(65611, 'long-nosed echymipera').
ncbi_mult_taxo_gbnm(65612, 'southern brown bandicoot').
ncbi_mult_taxo_gbnm(65613, 'Papuan bandicoot').
ncbi_mult_taxo_gbnm(65614, 'Proserpine rock wallaby').
ncbi_mult_taxo_gbnm(65616, 'Painted ringtail').
ncbi_mult_taxo_gbnm(65618, 'Dusky pademelon').
ncbi_mult_taxo_gbnm(65621, boodie).
ncbi_mult_taxo_gbnm(65624, 'spectacled hare-wallaby').
ncbi_mult_taxo_gbnm(65626, 'northern nail-tailed wallaby').
ncbi_mult_taxo_gbnm(65628, 'Raffray\'s bandicoot').
ncbi_mult_taxo_gbnm(65629, 'golden ringtail possum').
ncbi_mult_taxo_gbnm(65631, 'musky rat kangaroo').
ncbi_mult_taxo_gbnm(65632, 'rufous hare-wallaby').
ncbi_mult_taxo_gbnm(65634, 'banded hare-wallaby').
ncbi_mult_taxo_gbnm(65637, 'ornate kangaroo tick').
ncbi_mult_taxo_gbnm(65640, 'echidna tick').
ncbi_mult_taxo_gbnm(65641, 'goanna tick').
ncbi_mult_taxo_gbnm(65642, 'goanna tick').
ncbi_mult_taxo_gbnm(65647, 'paralysis tick').
ncbi_mult_taxo_gbnm(65694, 'Siberian shrew').
ncbi_mult_taxo_gbnm(65739, 'spotted wolffish').
ncbi_mult_taxo_gbnm(65742, 'migratory grasshopper').
ncbi_mult_taxo_gbnm(65771, 'Peruvian jacinth').
ncbi_mult_taxo_gbnm(65946, 'Pennsylvania bittercress').
ncbi_mult_taxo_gbnm(65975, 'California oat grass').
ncbi_mult_taxo_gbnm(65986, 'black seed panic').
ncbi_mult_taxo_gbnm(65990, 'alkali cordgrass').
ncbi_mult_taxo_gbnm(65991, 'prairie cordgrass').
ncbi_mult_taxo_gbnm(65992, 'alkali sacaton').
ncbi_mult_taxo_gbnm(65999, 'vine reeds').
ncbi_mult_taxo_gbnm(66000, 'Mauritania vine reed').
ncbi_mult_taxo_gbnm(66004, 'curly Mitchell grass').
ncbi_mult_taxo_gbnm(66014, 'lemon grass').
ncbi_mult_taxo_gbnm(66018, 'southern crabgrass').
ncbi_mult_taxo_gbnm(66039, 'knotroot foxtail').
ncbi_mult_taxo_gbnm(66056, skinks).
ncbi_mult_taxo_gbnm(66062, 'Tonkin snub-nosed monkey').
ncbi_mult_taxo_gbnm(66063, 'Nilgiri langur').
ncbi_mult_taxo_gbnm(66065, 'sheep hookworm').
ncbi_mult_taxo_gbnm(66088, 'water locust').
ncbi_mult_taxo_gbnm(66168, 'bristle-cone fir').
ncbi_mult_taxo_gbnm(66169, 'Chinese plum yew').
ncbi_mult_taxo_gbnm(66173, 'Canada hemlock').
ncbi_mult_taxo_gbnm(66179, 'Lake Taal snake').
ncbi_mult_taxo_gbnm(66184, 'Mueller\'s crown snake').
ncbi_mult_taxo_gbnm(66205, 'hedge maple').
ncbi_mult_taxo_gbnm(66206, 'hornbeam maple').
ncbi_mult_taxo_gbnm(66207, 'vine maple').
ncbi_mult_taxo_gbnm(66208, 'hawthorn maple').
ncbi_mult_taxo_gbnm(66211, 'big-leaf maple').
ncbi_mult_taxo_gbnm(66214, 'striped maple').
ncbi_mult_taxo_gbnm(66233, 'purple false gilyflower').
ncbi_mult_taxo_gbnm(66234, 'large flower mountaintrumpet').
ncbi_mult_taxo_gbnm(66235, 'variable leaf mountaintrumpet').
ncbi_mult_taxo_gbnm(66236, 'bird lice').
ncbi_mult_taxo_gbnm(66265, 'bare-eared squirrel monkey').
ncbi_mult_taxo_gbnm(66361, 'secondary screw-worm').
ncbi_mult_taxo_gbnm(66380, kozo).
ncbi_mult_taxo_gbnm(66385, 'Chinese banyan').
ncbi_mult_taxo_gbnm(66386, 'creeping fig').
ncbi_mult_taxo_gbnm(66387, 'bo tree').
ncbi_mult_taxo_gbnm(66392, 'Aino mulberry').
ncbi_mult_taxo_gbnm(66410, 'black metaltail').
ncbi_mult_taxo_gbnm(66420, 'Asian swallowtail').
ncbi_mult_taxo_gbnm(66433, 'Guenther\'s dik-dik').
ncbi_mult_taxo_gbnm(66434, 'Kirk\'s dik-dik').
ncbi_mult_taxo_gbnm(66435, 'Cape grysbok').
ncbi_mult_taxo_gbnm(66436, 'Sharpe\'s grysbok').
ncbi_mult_taxo_gbnm(66437, nyala).
ncbi_mult_taxo_gbnm(66440, bushbuck).
ncbi_mult_taxo_gbnm(66442, suni).
ncbi_mult_taxo_gbnm(66444, klipspringer).
ncbi_mult_taxo_gbnm(66447, koaro).
ncbi_mult_taxo_gbnm(66448, 'spotted mountain trout').
ncbi_mult_taxo_gbnm(66449, 'common river galaxias').
ncbi_mult_taxo_gbnm(66535, 'round fungus beetles').
ncbi_mult_taxo_gbnm(66551, 'beetle mites').
ncbi_mult_taxo_gbnm(66627, 'Maracaibo lignum-vitae').
ncbi_mult_taxo_gbnm(66636, 'creosote bush').
ncbi_mult_taxo_gbnm(66654, 'Gold Coast bombax').
ncbi_mult_taxo_gbnm(66662, balsa).
ncbi_mult_taxo_gbnm(66666, 'Mexican flannelbush').
ncbi_mult_taxo_gbnm(66669, 'American linden').
ncbi_mult_taxo_gbnm(66672, 'lipstick tree').
ncbi_mult_taxo_gbnm(66684, 'cannonball tree').
ncbi_mult_taxo_gbnm(66713, 'Akoya pearl oyster').
ncbi_mult_taxo_gbnm(66718, 'summer flounder').
ncbi_mult_taxo_gbnm(66780, 'jaw worms').
ncbi_mult_taxo_gbnm(66828, 'flat tree-oyster').
ncbi_mult_taxo_gbnm(66907, 'leatherleaf rhododendron').
ncbi_mult_taxo_gbnm(66911, 'white catfish').
ncbi_mult_taxo_gbnm(66912, 'yellow bullhead').
ncbi_mult_taxo_gbnm(66913, 'blue catfish').
ncbi_mult_taxo_gbnm(67537, chiselmouth).
ncbi_mult_taxo_gbnm(67539, 'lake chub').
ncbi_mult_taxo_gbnm(67541, 'humpback chub').
ncbi_mult_taxo_gbnm(67545, 'little Colorado spinedace').
ncbi_mult_taxo_gbnm(67547, 'pearl dace').
ncbi_mult_taxo_gbnm(67549, spikedace).
ncbi_mult_taxo_gbnm(67550, 'emerald shiner').
ncbi_mult_taxo_gbnm(67552, 'riffle minnow').
ncbi_mult_taxo_gbnm(67556, 'blacknose dace').
ncbi_mult_taxo_gbnm(67558, 'creek chub').
ncbi_mult_taxo_gbnm(67559, 'Dixie chub').
ncbi_mult_taxo_gbnm(67771, 'California quail').
ncbi_mult_taxo_gbnm(67772, 'Elegant quail').
ncbi_mult_taxo_gbnm(67773, 'Gambel\'s quail').
ncbi_mult_taxo_gbnm(67776, 'Danube ruffe').
ncbi_mult_taxo_gbnm(67777, schraetzer).
ncbi_mult_taxo_gbnm(67936, 'yellowwood ash').
ncbi_mult_taxo_gbnm(67940, 'Dama gazelle').
ncbi_mult_taxo_gbnm(68165, 'harlequin duck').
ncbi_mult_taxo_gbnm(68294, 'Mariana crow').
ncbi_mult_taxo_gbnm(68352, 'Little striped whiptail').
ncbi_mult_taxo_gbnm(68356, 'six-lined racerunner').
ncbi_mult_taxo_gbnm(68408, 'Chinese forest musk deer').
ncbi_mult_taxo_gbnm(68412, 'alpine musk deer').
ncbi_mult_taxo_gbnm(68413, 'dusky musk deer').
ncbi_mult_taxo_gbnm(68415, 'Siberian musk deer').
ncbi_mult_taxo_gbnm(68419, 'Kinugasa flying frog').
ncbi_mult_taxo_gbnm(68424, 'Madagascar jumping frog').
ncbi_mult_taxo_gbnm(68430, 'Murud bubble-nest frog').
ncbi_mult_taxo_gbnm(68442, 'Grandidier\'s Madagascar frog').
ncbi_mult_taxo_gbnm(68443, 'Peter\'s bubble-nest frog').
ncbi_mult_taxo_gbnm(68444, 'Java whipping frog').
ncbi_mult_taxo_gbnm(68448, 'whipping frogs').
ncbi_mult_taxo_gbnm(68449, 'Hong Kong whipping frog').
ncbi_mult_taxo_gbnm(68454, nursehound).
ncbi_mult_taxo_gbnm(68455, 'Siamese crocodile').
ncbi_mult_taxo_gbnm(68464, 'Gila topminnow').
ncbi_mult_taxo_gbnm(68472, 'African reed-warbler').
ncbi_mult_taxo_gbnm(68475, 'marsh warbler').
ncbi_mult_taxo_gbnm(68476, 'paddyfield warbler').
ncbi_mult_taxo_gbnm(68478, 'thick-billed warbler').
ncbi_mult_taxo_gbnm(68482, 'Lesser swamp-warbler').
ncbi_mult_taxo_gbnm(68490, 'Savi\'s warbler').
ncbi_mult_taxo_gbnm(68491, 'Eurasian river warbler').
ncbi_mult_taxo_gbnm(68495, 'Upcher\'s warbler').
ncbi_mult_taxo_gbnm(68497, 'icterine warbler').
ncbi_mult_taxo_gbnm(68498, 'melodious warbler').
ncbi_mult_taxo_gbnm(68500, 'marine hatchetfishes').
ncbi_mult_taxo_gbnm(68502, pearlsides).
ncbi_mult_taxo_gbnm(68504, 'half-naked hatchetfish').
ncbi_mult_taxo_gbnm(68509, 'Sloane\'s viperfish').
ncbi_mult_taxo_gbnm(68510, 'grinners and others').
ncbi_mult_taxo_gbnm(68511, greeneyes).
ncbi_mult_taxo_gbnm(68514, 'lanternfishes and blackchins').
ncbi_mult_taxo_gbnm(68515, lanternfishes).
ncbi_mult_taxo_gbnm(68527, 'Bengal quince').
ncbi_mult_taxo_gbnm(68535, 'white sapote').
ncbi_mult_taxo_gbnm(68557, 'longhorn sculpin').
ncbi_mult_taxo_gbnm(68722, 'small-eared dog').
ncbi_mult_taxo_gbnm(68723, 'side-striped jackal').
ncbi_mult_taxo_gbnm(68724, 'golden jackal').
ncbi_mult_taxo_gbnm(68725, 'black-backed jackal').
ncbi_mult_taxo_gbnm(68728, 'maned wolf').
ncbi_mult_taxo_gbnm(68730, dhole).
ncbi_mult_taxo_gbnm(68732, 'fennec fox').
ncbi_mult_taxo_gbnm(68734, 'hoary fox').
ncbi_mult_taxo_gbnm(68736, 'Culpeo').
ncbi_mult_taxo_gbnm(68737, 'South American gray fox').
ncbi_mult_taxo_gbnm(68739, 'Sechura desert fox').
ncbi_mult_taxo_gbnm(68741, 'bush dog').
ncbi_mult_taxo_gbnm(68875, 'wishbone flower').
ncbi_mult_taxo_gbnm(68888, 'pig whipworm').
ncbi_mult_taxo_gbnm(69045, 'eastern African black-backed jackal').
ncbi_mult_taxo_gbnm(69073, 'long-tailed giant rat').
ncbi_mult_taxo_gbnm(69075, 'lesser rice-field rat').
ncbi_mult_taxo_gbnm(69077, 'Indochinese forest rat').
ncbi_mult_taxo_gbnm(69079, 'lesser bandicoot rat').
ncbi_mult_taxo_gbnm(69081, 'Indomalayan maxomys').
ncbi_mult_taxo_gbnm(69083, 'dark-tailed tree rat').
ncbi_mult_taxo_gbnm(69110, boab).
ncbi_mult_taxo_gbnm(69121, 'coastal cutthroat trout').
ncbi_mult_taxo_gbnm(69127, 'Whitehead\'s spiny rat').
ncbi_mult_taxo_gbnm(69128, 'New World silversides').
ncbi_mult_taxo_gbnm(69130, 'Ogilby\'s hardyhead').
ncbi_mult_taxo_gbnm(69132, 'small-mouth hardyhead').
ncbi_mult_taxo_gbnm(69134, 'Marjorie\'s hardyhead').
ncbi_mult_taxo_gbnm(69135, 'fly-specked hardyhead').
ncbi_mult_taxo_gbnm(69136, 'Devil\'s Hole pupfish').
ncbi_mult_taxo_gbnm(69196, 'cabbage aphid').
ncbi_mult_taxo_gbnm(69226, 'Gill\'s molly').
ncbi_mult_taxo_gbnm(69228, 'mini-molly').
ncbi_mult_taxo_gbnm(69229, 'blackbarred limia').
ncbi_mult_taxo_gbnm(69230, 'mangrove molly').
ncbi_mult_taxo_gbnm(69232, 'Perugia\'s limia').
ncbi_mult_taxo_gbnm(69233, 'Peten molly').
ncbi_mult_taxo_gbnm(69234, 'swamp guppy').
ncbi_mult_taxo_gbnm(69235, 'Mexican molly').
ncbi_mult_taxo_gbnm(69259, woylie).
ncbi_mult_taxo_gbnm(69260, 'Goodfellow\'s tree kangaroo').
ncbi_mult_taxo_gbnm(69266, 'northern highbush blueberry').
ncbi_mult_taxo_gbnm(69270, 'lesser forest wallaby').
ncbi_mult_taxo_gbnm(69291, 'sticklebacks & tubesnouts').
ncbi_mult_taxo_gbnm(69293, 'three-spined stickleback').
ncbi_mult_taxo_gbnm(69296, 'mountain nyala').
ncbi_mult_taxo_gbnm(69297, bongo).
ncbi_mult_taxo_gbnm(69298, 'Sitatunga').
ncbi_mult_taxo_gbnm(69299, 'Natal duiker').
ncbi_mult_taxo_gbnm(69300, chinkara).
ncbi_mult_taxo_gbnm(69301, 'Cuvier\'s gazelle').
ncbi_mult_taxo_gbnm(69302, 'mountain gazelle').
ncbi_mult_taxo_gbnm(69303, 'Rhim gazelle').
ncbi_mult_taxo_gbnm(69304, 'Red-fronted gazelle').
ncbi_mult_taxo_gbnm(69305, 'Saudi gazelle').
ncbi_mult_taxo_gbnm(69306, 'Soemmerring\'s gazelle').
ncbi_mult_taxo_gbnm(69307, 'Speke\'s gazelle').
ncbi_mult_taxo_gbnm(69308, 'Thomson\'s gazelle').
ncbi_mult_taxo_gbnm(69311, gerenuk).
ncbi_mult_taxo_gbnm(69364, 'Old World screwworm').
ncbi_mult_taxo_gbnm(69379, 'West African rubber tree').
ncbi_mult_taxo_gbnm(69412, 'ivy leaf peperomia').
ncbi_mult_taxo_gbnm(69414, 'baby rubberplant').
ncbi_mult_taxo_gbnm(69489, 'Levant water frog').
ncbi_mult_taxo_gbnm(69490, 'Italian pool frog').
ncbi_mult_taxo_gbnm(69510, whinchat).
ncbi_mult_taxo_gbnm(69614, 'carambola fruit fly').
ncbi_mult_taxo_gbnm(69683, 'hollow-shelled snails').
ncbi_mult_taxo_gbnm(69721, 'calla lily').
ncbi_mult_taxo_gbnm(69811, ide).
ncbi_mult_taxo_gbnm(69940, 'northern hawk-owl').
ncbi_mult_taxo_gbnm(69944, burbot).
ncbi_mult_taxo_gbnm(69957, 'green-rumped parrotlet').
ncbi_mult_taxo_gbnm(70019, 'Sahara frog').
ncbi_mult_taxo_gbnm(70082, 'oopu alamoo').
ncbi_mult_taxo_gbnm(70084, 'scribbled goby').
ncbi_mult_taxo_gbnm(70284, 'Cabrera\'s vole').
ncbi_mult_taxo_gbnm(70285, 'Arctic grayling').
ncbi_mult_taxo_gbnm(70320, 'gall mites').
ncbi_mult_taxo_gbnm(70325, 'blackcurrant gall mite').
ncbi_mult_taxo_gbnm(70340, 'Snow goose').
ncbi_mult_taxo_gbnm(70341, 'Nairobi grass rat').
ncbi_mult_taxo_gbnm(70381, 'green-eyed skimmers').
ncbi_mult_taxo_gbnm(70385, 'blue corporal').
ncbi_mult_taxo_gbnm(70386, 'white corporal').
ncbi_mult_taxo_gbnm(70387, 'chalk-fronted corporal').
ncbi_mult_taxo_gbnm(70390, 'neon skimmer').
ncbi_mult_taxo_gbnm(70392, 'slaty skimmer').
ncbi_mult_taxo_gbnm(70394, 'widow skimmer').
ncbi_mult_taxo_gbnm(70396, 'flame skimmer').
ncbi_mult_taxo_gbnm(70397, 'painted skimmer').
ncbi_mult_taxo_gbnm(70398, 'great blue skimmer').
ncbi_mult_taxo_gbnm(70433, 'Myers\' icefish').
ncbi_mult_taxo_gbnm(70446, 'Indian mackerel').
ncbi_mult_taxo_gbnm(70543, 'Chinese sucker').
ncbi_mult_taxo_gbnm(70546, yellowfin).
ncbi_mult_taxo_gbnm(70548, 'smallscale yellowfin').
ncbi_mult_taxo_gbnm(70596, 'long-tailed pouched rat').
ncbi_mult_taxo_gbnm(70610, 'bare-tailed woolly opossum').
ncbi_mult_taxo_gbnm(70687, 'large tree shrew').
ncbi_mult_taxo_gbnm(70701, 'Epirus pool frog').
ncbi_mult_taxo_gbnm(70738, 'white-bellied duiker').
ncbi_mult_taxo_gbnm(70741, 'Arctic raspberry').
ncbi_mult_taxo_gbnm(70783, 'purple tipped acropora').
ncbi_mult_taxo_gbnm(70784, 'masked julie').
ncbi_mult_taxo_gbnm(70814, 'masked titi').
ncbi_mult_taxo_gbnm(70825, 'Black-headed Uacari').
ncbi_mult_taxo_gbnm(70846, stargazers).
ncbi_mult_taxo_gbnm(70868, 'great barracuda').
ncbi_mult_taxo_gbnm(70895, 'narrow-winged damselflies').
ncbi_mult_taxo_gbnm(70906, crickets).
ncbi_mult_taxo_gbnm(70910, grasshoppers).
ncbi_mult_taxo_gbnm(70916, 'sand crickets').
ncbi_mult_taxo_gbnm(70920, 'harvester termites').
ncbi_mult_taxo_gbnm(70928, 'Central American squirrel monkey').
ncbi_mult_taxo_gbnm(70929, 'Caribbean pine').
ncbi_mult_taxo_gbnm(70987, 'honey bees').
ncbi_mult_taxo_gbnm(70999, 'kissing bugs').
ncbi_mult_taxo_gbnm(71003, 'wood lemming').
ncbi_mult_taxo_gbnm(71006, 'giant anteater').
ncbi_mult_taxo_gbnm(71009, 'Southern blind snake').
ncbi_mult_taxo_gbnm(71015, 'Western mourning skink').
ncbi_mult_taxo_gbnm(71111, 'long-nosed cusimanse').
ncbi_mult_taxo_gbnm(71113, 'neotropical river otter').
ncbi_mult_taxo_gbnm(71115, 'African palm civet').
ncbi_mult_taxo_gbnm(71117, 'Asian palm civet').
ncbi_mult_taxo_gbnm(71119, 'eastern mole').
ncbi_mult_taxo_gbnm(71121, 'Malayan civet').
ncbi_mult_taxo_gbnm(71148, 'Turkestan rock agama').
ncbi_mult_taxo_gbnm(71160, 'jewel lanternfish').
ncbi_mult_taxo_gbnm(71162, 'Peter\'s striped mouse').
ncbi_mult_taxo_gbnm(71173, 'African marsh rat').
ncbi_mult_taxo_gbnm(71195, 'net-winged beetles').
ncbi_mult_taxo_gbnm(71302, 'frond-aeolis').
ncbi_mult_taxo_gbnm(71354, 'shortpod mustard').
ncbi_mult_taxo_gbnm(71384, 'fawn antechinus').
ncbi_mult_taxo_gbnm(71385, 'Atherton antechinus').
ncbi_mult_taxo_gbnm(71386, 'swamp antechinus').
ncbi_mult_taxo_gbnm(71410, 'pinkspotted shrimp').
ncbi_mult_taxo_gbnm(71413, 'pink shrimp').
ncbi_mult_taxo_gbnm(71422, 'dusky rat').
ncbi_mult_taxo_gbnm(71531, 'bombadier beetles').
ncbi_mult_taxo_gbnm(71578, 'Chinese spiny lobster').
ncbi_mult_taxo_gbnm(71625, 'ayacahuite pine').
ncbi_mult_taxo_gbnm(71627, 'Mexican pinyon').
ncbi_mult_taxo_gbnm(71631, 'shortleaf pine').
ncbi_mult_taxo_gbnm(71636, 'Khasi pine').
ncbi_mult_taxo_gbnm(71641, 'Sumatran pine').
ncbi_mult_taxo_gbnm(71644, 'Japanese white pine').
ncbi_mult_taxo_gbnm(71645, 'Mexican weeping pine').
ncbi_mult_taxo_gbnm(71647, 'maritime pine').
ncbi_mult_taxo_gbnm(71649, 'dwarf Siberian pine').
ncbi_mult_taxo_gbnm(71650, 'chir pine').
ncbi_mult_taxo_gbnm(71674, 'Everglades pygmy sunfish').
ncbi_mult_taxo_gbnm(71678, 'Okefenokee pygmy sunfish').
ncbi_mult_taxo_gbnm(71679, 'banded pygmy sunfish').
ncbi_mult_taxo_gbnm(71750, 'Utah chub').
ncbi_mult_taxo_gbnm(71751, 'blue chub').
ncbi_mult_taxo_gbnm(71752, 'Nazas chub').
ncbi_mult_taxo_gbnm(71753, 'Sonora chub').
ncbi_mult_taxo_gbnm(71754, 'Chihuahua chub').
ncbi_mult_taxo_gbnm(71755, 'arroyo chub').
ncbi_mult_taxo_gbnm(71756, 'Rio Grande chub').
ncbi_mult_taxo_gbnm(71757, 'Pahranagat roundtail chub').
ncbi_mult_taxo_gbnm(71760, 'southern redbelly dace').
ncbi_mult_taxo_gbnm(71761, 'finscale dace').
ncbi_mult_taxo_gbnm(71763, 'desert dace').
ncbi_mult_taxo_gbnm(71765, hitch).
ncbi_mult_taxo_gbnm(71767, 'Sacramento blackfish').
ncbi_mult_taxo_gbnm(71769, 'northern pikeminnow').
ncbi_mult_taxo_gbnm(71771, 'relict dace').
ncbi_mult_taxo_gbnm(71773, 'tui chub').
ncbi_mult_taxo_gbnm(71802, 'long-tailed marmot').
ncbi_mult_taxo_gbnm(71854, 'black muntjac').
ncbi_mult_taxo_gbnm(71855, 'Fea\'s muntjac').
ncbi_mult_taxo_gbnm(71859, 'Annamite muntjac').
ncbi_mult_taxo_gbnm(72004, 'wild yak').
ncbi_mult_taxo_gbnm(72011, 'black porgy').
ncbi_mult_taxo_gbnm(72013, 'Australian swamphen').
ncbi_mult_taxo_gbnm(72036, 'salmon louse').
ncbi_mult_taxo_gbnm(72039, 'mustache shrimps').
ncbi_mult_taxo_gbnm(72040, 'horseshoe shrimps').
ncbi_mult_taxo_gbnm(72053, 'Lahontan cutthroat trout').
ncbi_mult_taxo_gbnm(72054, 'Bonneville cutthroat trout').
ncbi_mult_taxo_gbnm(72055, 'Pacific ocean perch').
ncbi_mult_taxo_gbnm(72056, 'kelp rockfish').
ncbi_mult_taxo_gbnm(72057, 'brown rockfish').
ncbi_mult_taxo_gbnm(72058, 'aurora rockfish').
ncbi_mult_taxo_gbnm(72059, 'redbanded rockfish').
ncbi_mult_taxo_gbnm(72060, 'silvergray rockfish').
ncbi_mult_taxo_gbnm(72061, 'false jacopever').
ncbi_mult_taxo_gbnm(72062, 'gopher rockfish').
ncbi_mult_taxo_gbnm(72063, 'copper rockfish').
ncbi_mult_taxo_gbnm(72064, 'greenspotted rockfish').
ncbi_mult_taxo_gbnm(72065, 'dusky rockfish').
ncbi_mult_taxo_gbnm(72066, 'starry rockfish').
ncbi_mult_taxo_gbnm(72067, 'darkblotched rockfish').
ncbi_mult_taxo_gbnm(72069, 'splitnose rockfish').
ncbi_mult_taxo_gbnm(72070, 'greenstriped rockfish').
ncbi_mult_taxo_gbnm(72071, 'Puget Sound rockfish').
ncbi_mult_taxo_gbnm(72072, 'swordspine rockfish').
ncbi_mult_taxo_gbnm(72073, 'widow rockfish').
ncbi_mult_taxo_gbnm(72074, 'pink rockfish').
ncbi_mult_taxo_gbnm(72075, 'buccaneer rockfish').
ncbi_mult_taxo_gbnm(72076, 'yellowtain rockfish').
ncbi_mult_taxo_gbnm(72077, 'bronzespotted rockfish').
ncbi_mult_taxo_gbnm(72078, chilipepper).
ncbi_mult_taxo_gbnm(72079, 'rosethorn rockfish').
ncbi_mult_taxo_gbnm(72080, 'squarespot rockfish').
ncbi_mult_taxo_gbnm(72081, 'shortbelly rockfish').
ncbi_mult_taxo_gbnm(72082, 'freckled rockfish').
ncbi_mult_taxo_gbnm(72083, cowcod).
ncbi_mult_taxo_gbnm(72084, 'quillback rockfish').
ncbi_mult_taxo_gbnm(72085, 'black rockfish').
ncbi_mult_taxo_gbnm(72086, 'blackgill rockfish').
ncbi_mult_taxo_gbnm(72087, 'vermillion rockfish').
ncbi_mult_taxo_gbnm(72089, 'tiger rockfish').
ncbi_mult_taxo_gbnm(72091, 'Patagonian redfish').
ncbi_mult_taxo_gbnm(72092, 'speckled rockfish').
ncbi_mult_taxo_gbnm(72093, bocaccio).
ncbi_mult_taxo_gbnm(72094, 'canary rockfish').
ncbi_mult_taxo_gbnm(72095, 'grass rockfish').
ncbi_mult_taxo_gbnm(72096, 'rosy rockfish').
ncbi_mult_taxo_gbnm(72097, 'greenblotched rockfish').
ncbi_mult_taxo_gbnm(72098, 'yelloweye rockfish').
ncbi_mult_taxo_gbnm(72099, 'flag rockfish').
ncbi_mult_taxo_gbnm(72100, 'bank rockfish').
ncbi_mult_taxo_gbnm(72101, 'stripetail rockfish').
ncbi_mult_taxo_gbnm(72102, 'olive rockfish').
ncbi_mult_taxo_gbnm(72103, 'pinkrose rockfish').
ncbi_mult_taxo_gbnm(72105, 'honeycomb rockfish').
ncbi_mult_taxo_gbnm(72106, 'harlequin rockfish').
ncbi_mult_taxo_gbnm(72107, 'pygmy rockfish').
ncbi_mult_taxo_gbnm(72108, 'sharpchin rockfish').
ncbi_mult_taxo_gbnm(72114, 'California scorpionfish').
ncbi_mult_taxo_gbnm(72131, 'western yellow bat').
ncbi_mult_taxo_gbnm(72205, larks).
ncbi_mult_taxo_gbnm(72245, 'Sara\'s orangetip').
ncbi_mult_taxo_gbnm(72246, 'Alexandra sulphur butterfly').
ncbi_mult_taxo_gbnm(72247, 'sierra green sulfur').
ncbi_mult_taxo_gbnm(72248, 'clouded yellow').
ncbi_mult_taxo_gbnm(72251, 'Mead\'s sulphur').
ncbi_mult_taxo_gbnm(72255, 'creamy marblewing').
ncbi_mult_taxo_gbnm(72256, 'grass yellows').
ncbi_mult_taxo_gbnm(72257, 'fairy yellow').
ncbi_mult_taxo_gbnm(72258, 'little yellow').
ncbi_mult_taxo_gbnm(72259, 'sleepy orange').
ncbi_mult_taxo_gbnm(72260, 'western tiger swallowtail').
ncbi_mult_taxo_gbnm(72265, 'California dogface butterfly').
ncbi_mult_taxo_gbnm(72276, 'purple sulfur bacteria').
ncbi_mult_taxo_gbnm(72278, 'Bukhara urial').
ncbi_mult_taxo_gbnm(72290, 'rugose hooked squid').
ncbi_mult_taxo_gbnm(72291, 'smooth hooked squid').
ncbi_mult_taxo_gbnm(72292, 'robust clubhook squid').
ncbi_mult_taxo_gbnm(72341, tarragon).
ncbi_mult_taxo_gbnm(72368, 'sweet acacia').
ncbi_mult_taxo_gbnm(72402, 'Alexandrian senna').
ncbi_mult_taxo_gbnm(72420, 'Murray cray').
ncbi_mult_taxo_gbnm(72424, 'Sydney crayfish').
ncbi_mult_taxo_gbnm(72425, 'Glenelg cray').
ncbi_mult_taxo_gbnm(72426, 'Yarra cray').
ncbi_mult_taxo_gbnm(72433, 'royal poinciana').
ncbi_mult_taxo_gbnm(72446, catla).
ncbi_mult_taxo_gbnm(72450, 'fat greenling').
ncbi_mult_taxo_gbnm(72491, 'kissing bug').
ncbi_mult_taxo_gbnm(72493, 'western bloodsucking conenose').
ncbi_mult_taxo_gbnm(72494, 'bloodsucking conenose').
ncbi_mult_taxo_gbnm(72517, 'wheel bug').
ncbi_mult_taxo_gbnm(72540, 'West Caucasian tur').
ncbi_mult_taxo_gbnm(72541, 'East Caucasian tur').
ncbi_mult_taxo_gbnm(72542, 'Alpine ibex').
ncbi_mult_taxo_gbnm(72543, 'Nubian ibex').
ncbi_mult_taxo_gbnm(72544, 'Siberian ibex').
ncbi_mult_taxo_gbnm(72545, 'Pyrenean chamois').
ncbi_mult_taxo_gbnm(72546, 'redtail surfperch').
ncbi_mult_taxo_gbnm(72550, 'rhinoceros beetle').
ncbi_mult_taxo_gbnm(72636, 'mottled shore crab').
ncbi_mult_taxo_gbnm(72643, 'tall kangaroo paw').
ncbi_mult_taxo_gbnm(72647, 'roundleaf greenbrier').
ncbi_mult_taxo_gbnm(72648, 'Polynesian arrowroot').
ncbi_mult_taxo_gbnm(72705, 'CVd-Ia').
ncbi_mult_taxo_gbnm(72791, 'desert ant').
ncbi_mult_taxo_gbnm(72851, 'clouded sulphur butterfly').
ncbi_mult_taxo_gbnm(72852, 'eastern pale clouded yellow').
ncbi_mult_taxo_gbnm(72867, 'fairy martin').
ncbi_mult_taxo_gbnm(72873, 'Tree swallow').
ncbi_mult_taxo_gbnm(72882, 'black saw-wing').
ncbi_mult_taxo_gbnm(72884, 'cliff swallow').
ncbi_mult_taxo_gbnm(73009, 'sugar ant').
ncbi_mult_taxo_gbnm(73031, 'Asian green mussel').
ncbi_mult_taxo_gbnm(73102, salal).
ncbi_mult_taxo_gbnm(73107, 'great bustard').
ncbi_mult_taxo_gbnm(73109, 'Amami-oshima island spiny rat').
ncbi_mult_taxo_gbnm(73114, 'amber snails').
ncbi_mult_taxo_gbnm(73161, 'headwater livebearer').
ncbi_mult_taxo_gbnm(73200, 'rose geranium').
ncbi_mult_taxo_gbnm(73322, 'Firecrest').
ncbi_mult_taxo_gbnm(73323, 'Canary Islands kinglet').
ncbi_mult_taxo_gbnm(73324, 'garden warbler').
ncbi_mult_taxo_gbnm(73327, 'Northern long-tailed tit').
ncbi_mult_taxo_gbnm(73330, 'short-toed tree-creeper').
ncbi_mult_taxo_gbnm(73333, 'Eurasian tree-creeper').
ncbi_mult_taxo_gbnm(73334, kulan).
ncbi_mult_taxo_gbnm(73335, 'Hartmann\'s mountain zebra').
ncbi_mult_taxo_gbnm(73337, 'southern white rhinoceros').
ncbi_mult_taxo_gbnm(73401, 'gall wasps').
ncbi_mult_taxo_gbnm(73405, 'mossy rose gall wasp').
ncbi_mult_taxo_gbnm(73406, 'rose gall wasp').
ncbi_mult_taxo_gbnm(73431, 'common feather star').
ncbi_mult_taxo_gbnm(73493, 'Balkan frog').
ncbi_mult_taxo_gbnm(73634, 'Brazilian skipper butterfly').
ncbi_mult_taxo_gbnm(73717, lotebush).
ncbi_mult_taxo_gbnm(73815, 'long-tailed pangolin').
ncbi_mult_taxo_gbnm(73823, 'four-horned antelope').
ncbi_mult_taxo_gbnm(73824, 'balsam poplar').
ncbi_mult_taxo_gbnm(73861, 'small five-toed jerboa').
ncbi_mult_taxo_gbnm(73863, 'northern three-toed jerboa').
ncbi_mult_taxo_gbnm(73865, 'long-tailed porcupine').
ncbi_mult_taxo_gbnm(73882, 'Rufous owl').
ncbi_mult_taxo_gbnm(73883, 'Powerful owl').
ncbi_mult_taxo_gbnm(74065, 'maize leafhopper').
ncbi_mult_taxo_gbnm(74068, 'aster leafhopper').
ncbi_mult_taxo_gbnm(74074, 'leatherleaf slugs').
ncbi_mult_taxo_gbnm(74081, 'Iberian wall lizard').
ncbi_mult_taxo_gbnm(74106, 'river patwa').
ncbi_mult_taxo_gbnm(74131, 'freshwater angelfish').
ncbi_mult_taxo_gbnm(74133, 'blue discus').
ncbi_mult_taxo_gbnm(74137, uaru).
ncbi_mult_taxo_gbnm(74200, 'Carolina wren').
ncbi_mult_taxo_gbnm(74358, 'Lilford\'s wall lizard').
ncbi_mult_taxo_gbnm(74361, 'red-banded snake').
ncbi_mult_taxo_gbnm(74362, 'Amur rat snake').
ncbi_mult_taxo_gbnm(74363, 'Chinese leopard snake').
ncbi_mult_taxo_gbnm(74364, 'Taiwan stink snake').
ncbi_mult_taxo_gbnm(74365, 'Mandarin rat snake').
ncbi_mult_taxo_gbnm(74366, 'Flower snake').
ncbi_mult_taxo_gbnm(74369, 'frog-eating rat snake').
ncbi_mult_taxo_gbnm(74391, 'Arnoux\'s beaked whale').
ncbi_mult_taxo_gbnm(74392, 'southern bottlenose whale').
ncbi_mult_taxo_gbnm(74393, 'Andrew\'s beaked whale').
ncbi_mult_taxo_gbnm(74394, 'Gray\'s beaked whale').
ncbi_mult_taxo_gbnm(74395, 'strap-toothed whale').
ncbi_mult_taxo_gbnm(74398, 'beauty snake').
ncbi_mult_taxo_gbnm(74457, 'Red boobook').
ncbi_mult_taxo_gbnm(74533, 'Amur tiger').
ncbi_mult_taxo_gbnm(74534, 'Indochinese tiger').
ncbi_mult_taxo_gbnm(74535, 'Bengal tiger').
ncbi_mult_taxo_gbnm(74613, 'Chinese licorice').
ncbi_mult_taxo_gbnm(74632, 'French rose').
ncbi_mult_taxo_gbnm(74636, 'sweetbriar rose').
ncbi_mult_taxo_gbnm(74638, 'Carolina rose').
ncbi_mult_taxo_gbnm(74645, 'rugosa rose').
ncbi_mult_taxo_gbnm(74654, 'burr rose').
ncbi_mult_taxo_gbnm(74656, 'hairy agrimony').
ncbi_mult_taxo_gbnm(74822, 'western poppy').
ncbi_mult_taxo_gbnm(74823, 'Iceland poppy').
ncbi_mult_taxo_gbnm(74864, 'yellow-throated marten').
ncbi_mult_taxo_gbnm(74883, 'northern sassafras').
ncbi_mult_taxo_gbnm(74884, 'yellow sassafras').
ncbi_mult_taxo_gbnm(74909, 'Amboina box turtle').
ncbi_mult_taxo_gbnm(74915, 'Asian leaf turtles').
ncbi_mult_taxo_gbnm(74916, 'Asian leaf turtle').
ncbi_mult_taxo_gbnm(74920, 'Elongated tortoise').
ncbi_mult_taxo_gbnm(74922, 'Mekong snail-eating turtle').
ncbi_mult_taxo_gbnm(74926, 'yellowpond turtle').
ncbi_mult_taxo_gbnm(74930, 'Malayan giant turtle').
ncbi_mult_taxo_gbnm(74934, 'four-eyed turtle').
ncbi_mult_taxo_gbnm(74940, 'Chinook salmon').
ncbi_mult_taxo_gbnm(74973, 'wolf spiders').
ncbi_mult_taxo_gbnm(74980, 'thin-legged wolf spiders').
ncbi_mult_taxo_gbnm(75013, 'whitespotted surgeonfish').
ncbi_mult_taxo_gbnm(75014, 'yellowfin surgeonfish').
ncbi_mult_taxo_gbnm(75015, 'horse-eye jack').
ncbi_mult_taxo_gbnm(75016, 'banded butterflyfish').
ncbi_mult_taxo_gbnm(75020, 'twospot surgeonfish').
ncbi_mult_taxo_gbnm(75022, 'spotted sicklefish').
ncbi_mult_taxo_gbnm(75024, 'queen angelfish').
ncbi_mult_taxo_gbnm(75026, luvar).
ncbi_mult_taxo_gbnm(75028, 'orangespine unicornfish').
ncbi_mult_taxo_gbnm(75030, 'palette surgeonfish').
ncbi_mult_taxo_gbnm(75032, 'orbicular batfish').
ncbi_mult_taxo_gbnm(75036, 'yellowspotted sawtail').
ncbi_mult_taxo_gbnm(75042, 'white-spotted rabbitfish').
ncbi_mult_taxo_gbnm(75044, 'moorish idol').
ncbi_mult_taxo_gbnm(75046, 'twotone tang').
ncbi_mult_taxo_gbnm(75061, 'robin runaway').
ncbi_mult_taxo_gbnm(75062, 'Allegheny blackberry').
ncbi_mult_taxo_gbnm(75085, wineberry).
ncbi_mult_taxo_gbnm(75140, rook).
ncbi_mult_taxo_gbnm(75144, 'oak gall wasps').
ncbi_mult_taxo_gbnm(75150, 'cola-nut gall wasp').
ncbi_mult_taxo_gbnm(75187, 'fig wasps').
ncbi_mult_taxo_gbnm(75252, 'Hispaniolan green anole').
ncbi_mult_taxo_gbnm(75256, 'humble anole').
ncbi_mult_taxo_gbnm(75266, 'tiny anole').
ncbi_mult_taxo_gbnm(75268, 'Cuban spiny-plant anole').
ncbi_mult_taxo_gbnm(75284, 'black madtom').
ncbi_mult_taxo_gbnm(75286, 'hardheaded sea catfish').
ncbi_mult_taxo_gbnm(75329, 'oriental weatherfish').
ncbi_mult_taxo_gbnm(75332, 'Chinese false gudgeon').
ncbi_mult_taxo_gbnm(75334, 'Khanka spiny bitterling').
ncbi_mult_taxo_gbnm(75348, 'Lake Qinghai scale-less carp').
ncbi_mult_taxo_gbnm(75350, sharpbelly).
ncbi_mult_taxo_gbnm(75352, 'Wuchang bream').
ncbi_mult_taxo_gbnm(75354, 'black Amur bream').
ncbi_mult_taxo_gbnm(75356, 'black carp').
ncbi_mult_taxo_gbnm(75358, 'white Amur bream').
ncbi_mult_taxo_gbnm(75360, 'Burmese trout').
ncbi_mult_taxo_gbnm(75372, 'barbel chub').
ncbi_mult_taxo_gbnm(75381, spadefishes).
ncbi_mult_taxo_gbnm(75382, rabbitfishes).
ncbi_mult_taxo_gbnm(75384, 'common Japanese scorpion fly').
ncbi_mult_taxo_gbnm(75389, 'mantis shrimps').
ncbi_mult_taxo_gbnm(75399, 'opossum shrimps').
ncbi_mult_taxo_gbnm(75485, 'black-legged kittiwake').
ncbi_mult_taxo_gbnm(75486, 'Hell Hollow slender salamander').
ncbi_mult_taxo_gbnm(75487, 'gregarious slender salamander').
ncbi_mult_taxo_gbnm(75488, 'sequoia slender salamander').
ncbi_mult_taxo_gbnm(75489, 'Kings River slender salamander').
ncbi_mult_taxo_gbnm(75490, 'relictual slender salamander').
ncbi_mult_taxo_gbnm(75545, 'featherwing beetles').
ncbi_mult_taxo_gbnm(75562, squirefish).
ncbi_mult_taxo_gbnm(75566, 'Black crested mangabey').
ncbi_mult_taxo_gbnm(75567, 'gray-cheeked mangabey').
ncbi_mult_taxo_gbnm(75569, 'Golden-bellied mangabey').
ncbi_mult_taxo_gbnm(75702, 'Euphrates poplar').
ncbi_mult_taxo_gbnm(75743, 'cloudy catshark').
ncbi_mult_taxo_gbnm(75753, 'Kangaroo Island dunnart').
ncbi_mult_taxo_gbnm(75754, 'little long-tailed dunnart').
ncbi_mult_taxo_gbnm(75755, 'Gilbert\'s dunnart').
ncbi_mult_taxo_gbnm(75756, 'gray-bellied dunnart').
ncbi_mult_taxo_gbnm(75832, 'American wigeon').
ncbi_mult_taxo_gbnm(75833, 'Auckland teal').
ncbi_mult_taxo_gbnm(75836, 'green-winged teal').
ncbi_mult_taxo_gbnm(75838, 'Northern shoveler').
ncbi_mult_taxo_gbnm(75839, 'Common teal').
ncbi_mult_taxo_gbnm(75840, 'cinnamon teal').
ncbi_mult_taxo_gbnm(75841, 'Mexican duck').
ncbi_mult_taxo_gbnm(75842, 'blue-winged teal').
ncbi_mult_taxo_gbnm(75844, 'falcated duck').
ncbi_mult_taxo_gbnm(75845, 'Yellow-billed teal').
ncbi_mult_taxo_gbnm(75847, 'yellow-billed pintail').
ncbi_mult_taxo_gbnm(75854, 'Indian spot-billed duck').
ncbi_mult_taxo_gbnm(75856, garganey).
ncbi_mult_taxo_gbnm(75857, 'American black duck').
ncbi_mult_taxo_gbnm(75858, 'Chiloe wigeon').
ncbi_mult_taxo_gbnm(75861, gadwall).
ncbi_mult_taxo_gbnm(75864, 'Eastern spot-billed duck').
ncbi_mult_taxo_gbnm(75865, 'common shelduck').
ncbi_mult_taxo_gbnm(75873, 'crested duck').
ncbi_mult_taxo_gbnm(75875, 'Marbled teal').
ncbi_mult_taxo_gbnm(75877, 'Hartlaub\'s duck').
ncbi_mult_taxo_gbnm(75933, 'European mudminnow').
ncbi_mult_taxo_gbnm(75934, 'eastern mudminnow').
ncbi_mult_taxo_gbnm(75935, 'central mudminnow').
ncbi_mult_taxo_gbnm(75939, 'Alaska blackfish').
ncbi_mult_taxo_gbnm(75943, 'prickly lettuce').
ncbi_mult_taxo_gbnm(75971, 'lineated woodcreeper').
ncbi_mult_taxo_gbnm(75974, 'narrow-billed woodcreeper').
ncbi_mult_taxo_gbnm(75976, 'Montane woodcreeper').
ncbi_mult_taxo_gbnm(75977, 'streak-headed woodcreeper').
ncbi_mult_taxo_gbnm(75978, 'scaled woodcreeper').
ncbi_mult_taxo_gbnm(75979, 'Wagler\'s woodcreeper').
ncbi_mult_taxo_gbnm(75988, 'Mexican giant tree frog').
ncbi_mult_taxo_gbnm(75989, 'leaf frogs').
ncbi_mult_taxo_gbnm(75990, 'blue-sided leaf frog').
ncbi_mult_taxo_gbnm(76025, 'tuber fleeceflower').
ncbi_mult_taxo_gbnm(76029, 'black bindweed').
ncbi_mult_taxo_gbnm(76036, 'giant knotweed').
ncbi_mult_taxo_gbnm(76053, 'striped killifish').
ncbi_mult_taxo_gbnm(76054, 'bayou killifish').
ncbi_mult_taxo_gbnm(76055, 'longnose killifish').
ncbi_mult_taxo_gbnm(76058, 'common eider').
ncbi_mult_taxo_gbnm(76060, 'Colorado dwarf frog').
ncbi_mult_taxo_gbnm(76062, 'Steindachner\'s dwarf frog').
ncbi_mult_taxo_gbnm(76064, 'Peters\' dwarf frog').
ncbi_mult_taxo_gbnm(76065, 'Guayaquil dwarf frog').
ncbi_mult_taxo_gbnm(76066, 'Tungara frog').
ncbi_mult_taxo_gbnm(76071, 'medakas, needlefish and others').
ncbi_mult_taxo_gbnm(76074, 'fourwing flyingfish').
ncbi_mult_taxo_gbnm(76143, 'stoplight loosejaw').
ncbi_mult_taxo_gbnm(76193, 'common yellow swallowtail').
ncbi_mult_taxo_gbnm(76194, 'common Mormon').
ncbi_mult_taxo_gbnm(76199, 'Chinese peacock').
ncbi_mult_taxo_gbnm(76202, 'lime butterfly').
ncbi_mult_taxo_gbnm(76203, 'common grass yellow').
ncbi_mult_taxo_gbnm(76212, duskywings).
ncbi_mult_taxo_gbnm(76214, eggflies).
ncbi_mult_taxo_gbnm(76215, 'common eggfly').
ncbi_mult_taxo_gbnm(76216, treebrowns).
ncbi_mult_taxo_gbnm(76219, 'yellow-legged tortoiseshell').
ncbi_mult_taxo_gbnm(76228, 'orange tiger').
ncbi_mult_taxo_gbnm(76235, 'striped blue crow').
ncbi_mult_taxo_gbnm(76239, 'nettle-tree butterfly').
ncbi_mult_taxo_gbnm(76253, bushbrowns).
ncbi_mult_taxo_gbnm(76254, 'Chinese bushbrown').
ncbi_mult_taxo_gbnm(76277, 'sea-dock').
ncbi_mult_taxo_gbnm(76338, bluehead).
ncbi_mult_taxo_gbnm(76340, 'red drum').
ncbi_mult_taxo_gbnm(76342, 'Queretaro pocket gopher').
ncbi_mult_taxo_gbnm(76593, 'Taiwan torrent carp').
ncbi_mult_taxo_gbnm(76643, 'Cope\'s arboreal alligator lizard').
ncbi_mult_taxo_gbnm(76717, 'Northern American river otter').
ncbi_mult_taxo_gbnm(76718, 'marine otter').
ncbi_mult_taxo_gbnm(76720, fisher).
ncbi_mult_taxo_gbnm(76722, 'African clawless otter').
ncbi_mult_taxo_gbnm(76772, 'golden-mantled ground squirrel').
ncbi_mult_taxo_gbnm(76807, 'golden-eye lacewing').
ncbi_mult_taxo_gbnm(76834, 'Arcuate horseshoe bat').
ncbi_mult_taxo_gbnm(76835, 'broad-eared horseshoe bat').
ncbi_mult_taxo_gbnm(76836, 'smaller horseshoe bat').
ncbi_mult_taxo_gbnm(76837, 'large-eared horseshoe bat').
ncbi_mult_taxo_gbnm(76910, 'rain tree').
ncbi_mult_taxo_gbnm(76912, 'Balsas teosinte').
ncbi_mult_taxo_gbnm(76919, 'St. Paul\'s fingerfin').
ncbi_mult_taxo_gbnm(76927, hawkfish).
ncbi_mult_taxo_gbnm(76930, porae).
ncbi_mult_taxo_gbnm(76931, tarakihi).
ncbi_mult_taxo_gbnm(76932, 'sea carp').
ncbi_mult_taxo_gbnm(76966, 'marumi kumquat').
ncbi_mult_taxo_gbnm(77027, 'yellow pond lily').
ncbi_mult_taxo_gbnm(77136, 'stripetail darter').
ncbi_mult_taxo_gbnm(77137, 'riverweed darter').
ncbi_mult_taxo_gbnm(77138, 'frecklebelly darter').
ncbi_mult_taxo_gbnm(77142, 'Danube streber').
ncbi_mult_taxo_gbnm(77144, asprete).
ncbi_mult_taxo_gbnm(77145, 'western sand darter').
ncbi_mult_taxo_gbnm(77149, 'steppe polecat').
ncbi_mult_taxo_gbnm(77151, 'black-footed ferret').
ncbi_mult_taxo_gbnm(77157, 'roundheaded pine beetle').
ncbi_mult_taxo_gbnm(77158, 'Mexican pine beetle').
ncbi_mult_taxo_gbnm(77160, 'western pine beetle').
ncbi_mult_taxo_gbnm(77161, 'southern pine beetle').
ncbi_mult_taxo_gbnm(77162, 'Jeffrey pine beetle').
ncbi_mult_taxo_gbnm(77164, 'European spruce beetle').
ncbi_mult_taxo_gbnm(77165, 'lodgepole pine beetle').
ncbi_mult_taxo_gbnm(77166, 'mountain pine beetle').
ncbi_mult_taxo_gbnm(77167, 'Douglas fir beetle').
ncbi_mult_taxo_gbnm(77168, 'Allegheny spruce beetle').
ncbi_mult_taxo_gbnm(77170, 'spruce beetle').
ncbi_mult_taxo_gbnm(77171, 'eastern larch beetle').
ncbi_mult_taxo_gbnm(77172, 'black turpentine beetle').
ncbi_mult_taxo_gbnm(77173, 'red turpentine beetle').
ncbi_mult_taxo_gbnm(77214, 'straw-colored fruit bat').
ncbi_mult_taxo_gbnm(77215, 'black-bellied fruit bat').
ncbi_mult_taxo_gbnm(77216, 'Rodriguez flying fox').
ncbi_mult_taxo_gbnm(77217, 'Pacific flying fox').
ncbi_mult_taxo_gbnm(77218, 'lesser horseshoe bat').
ncbi_mult_taxo_gbnm(77223, 'Madagascan rousette').
ncbi_mult_taxo_gbnm(77227, 'Pygmy fruit bat').
ncbi_mult_taxo_gbnm(77229, 'spotted-winged fruit bat').
ncbi_mult_taxo_gbnm(77231, 'Franquet\'s epauletted bat').
ncbi_mult_taxo_gbnm(77233, 'Ratanaworabhan\'s fruit bat').
ncbi_mult_taxo_gbnm(77237, 'Sao Tome collared fruit bat').
ncbi_mult_taxo_gbnm(77240, 'island tube-nosed fruit bat').
ncbi_mult_taxo_gbnm(77242, 'East African little collared fruit bat').
ncbi_mult_taxo_gbnm(77243, 'little collared fruit bat').
ncbi_mult_taxo_gbnm(77245, 'zebra swallowtail').
ncbi_mult_taxo_gbnm(77255, 'twin-tailed tiger swallowtail').
ncbi_mult_taxo_gbnm(77259, 'African swallowtail butterfly').
ncbi_mult_taxo_gbnm(77304, 'Katavi mouthbrooder').
ncbi_mult_taxo_gbnm(77339, 'reed palm').
ncbi_mult_taxo_gbnm(77340, 'Ohio spiderwort').
ncbi_mult_taxo_gbnm(77573, 'sweat bees').
ncbi_mult_taxo_gbnm(77594, 'giant goby').
ncbi_mult_taxo_gbnm(77598, 'yellow-spotted hyrax').
ncbi_mult_taxo_gbnm(77657, 'clam shrimps').
ncbi_mult_taxo_gbnm(77687, 'Tasmanian mountain shrimp').
ncbi_mult_taxo_gbnm(77794, 'Bulatmai barbel').
ncbi_mult_taxo_gbnm(77796, 'Mediterranean barbel').
ncbi_mult_taxo_gbnm(77855, 'silverleaf whitefly').
ncbi_mult_taxo_gbnm(77880, ipecac).
ncbi_mult_taxo_gbnm(77914, 'blackmouth catshark').
ncbi_mult_taxo_gbnm(78093, 'soldier crabs').
ncbi_mult_taxo_gbnm(78169, 'cuckoo bees').
ncbi_mult_taxo_gbnm(78170, 'carpenter bees').
ncbi_mult_taxo_gbnm(78195, 'purple-spotted gudgeon').
ncbi_mult_taxo_gbnm(78197, 'lesser cuckoo').
ncbi_mult_taxo_gbnm(78198, 'red-crested malkoha').
ncbi_mult_taxo_gbnm(78217, 'ferruginous pygmy-owl').
ncbi_mult_taxo_gbnm(78255, 'Hoffmanns\'s titi').
ncbi_mult_taxo_gbnm(78260, 'momi fir').
ncbi_mult_taxo_gbnm(78357, 'European destroying angel').
ncbi_mult_taxo_gbnm(78372, konjac).
ncbi_mult_taxo_gbnm(78376, 'green arrow arum').
ncbi_mult_taxo_gbnm(78394, 'broadgilled hagfish').
ncbi_mult_taxo_gbnm(78449, 'Taiwan macaque').
ncbi_mult_taxo_gbnm(78451, 'mitred leaf monkey').
ncbi_mult_taxo_gbnm(78452, 'grizzled leaf monkey').
ncbi_mult_taxo_gbnm(78453, 'banded leaf monkey').
ncbi_mult_taxo_gbnm(78454, 'red-chested mustached tamarin').
ncbi_mult_taxo_gbnm(78524, 'civil bluet').
ncbi_mult_taxo_gbnm(78583, 'gray-backed sportive lemur').
ncbi_mult_taxo_gbnm(78584, 'northern sportive lemur').
ncbi_mult_taxo_gbnm(78608, 'brimstone butterflies').
ncbi_mult_taxo_gbnm(78609, 'common brimstone butterfly').
ncbi_mult_taxo_gbnm(78612, 'lesser clouded yellow').
ncbi_mult_taxo_gbnm(78613, 'Greenland butterfly').
ncbi_mult_taxo_gbnm(78615, 'pale clouded yellow').
ncbi_mult_taxo_gbnm(78617, 'Danube clouded yellow').
ncbi_mult_taxo_gbnm(78618, 'Labrador sulphur').
ncbi_mult_taxo_gbnm(78620, 'moorland clouded yellow').
ncbi_mult_taxo_gbnm(78622, 'mountain clouded yellow').
ncbi_mult_taxo_gbnm(78624, 'Cleopatra butterfly').
ncbi_mult_taxo_gbnm(78630, 'Asian white birch').
ncbi_mult_taxo_gbnm(78794, 'large twayblade').
ncbi_mult_taxo_gbnm(78866, 'red-tailed sportive lemur').
ncbi_mult_taxo_gbnm(78879, 'Korean stumpy bullhead').
ncbi_mult_taxo_gbnm(78897, 'black-arched tussock moth').
ncbi_mult_taxo_gbnm(78900, 'Indian gypsy moth').
ncbi_mult_taxo_gbnm(79001, 'bamboo lily').
ncbi_mult_taxo_gbnm(79015, 'Chinese brown frog').
ncbi_mult_taxo_gbnm(79088, 'smartweed borer').
ncbi_mult_taxo_gbnm(79238, 'Barking owl').
ncbi_mult_taxo_gbnm(79239, 'Moluccan hawk-owl').
ncbi_mult_taxo_gbnm(79242, 'Christmas Island hawk-owl').
ncbi_mult_taxo_gbnm(79303, 'primitive crane flies').
ncbi_mult_taxo_gbnm(79304, 'phantom crane flies').
ncbi_mult_taxo_gbnm(79453, 'violet dancer').
ncbi_mult_taxo_gbnm(79475, 'common bluet').
ncbi_mult_taxo_gbnm(79622, 'streaked shearwater').
ncbi_mult_taxo_gbnm(79626, 'Rockhopper penguin').
ncbi_mult_taxo_gbnm(79627, 'Macaroni penguin').
ncbi_mult_taxo_gbnm(79628, 'white-bellied storm-petrel').
ncbi_mult_taxo_gbnm(79631, 'Fork-tailed storm-petrel').
ncbi_mult_taxo_gbnm(79632, 'black storm-petrel').
ncbi_mult_taxo_gbnm(79633, 'Wedge-rumped storm-petrel').
ncbi_mult_taxo_gbnm(79634, 'Tristram\'s storm-petrel').
ncbi_mult_taxo_gbnm(79637, 'Peruvian diving-petrel').
ncbi_mult_taxo_gbnm(79643, 'chinstrap penguin').
ncbi_mult_taxo_gbnm(79644, 'Indian yellow-nosed albatross').
ncbi_mult_taxo_gbnm(79651, 'European storm-petrel').
ncbi_mult_taxo_gbnm(79653, 'Wilson\'s storm-petrel').
ncbi_mult_taxo_gbnm(79657, 'least storm-petrel').
ncbi_mult_taxo_gbnm(79674, 'giant freshwater prawn').
ncbi_mult_taxo_gbnm(79683, 'shortjaw mudsucker').
ncbi_mult_taxo_gbnm(79684, 'prairie vole').
ncbi_mult_taxo_gbnm(79689, 'Mexican vole').
ncbi_mult_taxo_gbnm(79690, 'Atlantic stingray').
ncbi_mult_taxo_gbnm(79697, 'orange-thighed treefrog').
ncbi_mult_taxo_gbnm(79698, 'silver hake').
ncbi_mult_taxo_gbnm(79709, 'short-horned springtails').
ncbi_mult_taxo_gbnm(79735, 'earwig-like entrophs').
ncbi_mult_taxo_gbnm(79736, 'starspotted smooth-hound').
ncbi_mult_taxo_gbnm(79772, 'common vervain').
ncbi_mult_taxo_gbnm(79782, 'bed bug').
ncbi_mult_taxo_gbnm(79784, 'Indo-pacific bottlenose dolphin').
ncbi_mult_taxo_gbnm(79805, 'Hispaniolan solenodon').
ncbi_mult_taxo_gbnm(79920, 'web-footed marsh rat').
ncbi_mult_taxo_gbnm(79949, 'Norway lemming').
ncbi_mult_taxo_gbnm(80249, 'mustard beetle').
ncbi_mult_taxo_gbnm(80265, 'American oil palm').
ncbi_mult_taxo_gbnm(80269, 'Catemaco molly').
ncbi_mult_taxo_gbnm(80270, 'sulphur molly').
ncbi_mult_taxo_gbnm(80326, 'gumbo limbo').
ncbi_mult_taxo_gbnm(80338, 'yellow mombin').
ncbi_mult_taxo_gbnm(80345, 'brown turban snail').
ncbi_mult_taxo_gbnm(80379, habanero).
ncbi_mult_taxo_gbnm(80419, 'Spanish ibex').
ncbi_mult_taxo_gbnm(80426, 'steppe-runner').
ncbi_mult_taxo_gbnm(80427, 'Sand lizard').
ncbi_mult_taxo_gbnm(80444, 'Indian fringe-fingered lizard').
ncbi_mult_taxo_gbnm(80468, 'Spanish sand racer').
ncbi_mult_taxo_gbnm(80640, 'sand weakfish').
ncbi_mult_taxo_gbnm(80720, 'Pacific cod').
ncbi_mult_taxo_gbnm(80722, 'poor cod').
ncbi_mult_taxo_gbnm(80723, 'Norway pout').
ncbi_mult_taxo_gbnm(80752, 'Korean hornbeam').
ncbi_mult_taxo_gbnm(80765, 'cotton aphid').
ncbi_mult_taxo_gbnm(80772, 'Pollen\'s cichlid').
ncbi_mult_taxo_gbnm(80782, 'deepbody bitterling').
ncbi_mult_taxo_gbnm(80789, zenitanago).
ncbi_mult_taxo_gbnm(80790, 'Korean striped bitterling').
ncbi_mult_taxo_gbnm(80791, 'deep body bitterling').
ncbi_mult_taxo_gbnm(80794, 'Kyushu bitterling').
ncbi_mult_taxo_gbnm(80798, 'Light\'s bitterling').
ncbi_mult_taxo_gbnm(80799, 'rosy bitterling').
ncbi_mult_taxo_gbnm(80800, 'Japanese rosy bitterling').
ncbi_mult_taxo_gbnm(80801, 'rosy bitterling').
ncbi_mult_taxo_gbnm(80806, 'oily bitterling').
ncbi_mult_taxo_gbnm(80807, 'Korean bittering').
ncbi_mult_taxo_gbnm(80810, 'freshwater minnow').
ncbi_mult_taxo_gbnm(80829, 'giant clam').
ncbi_mult_taxo_gbnm(80836, 'sand crab').
ncbi_mult_taxo_gbnm(80839, 'shore swimming crab').
ncbi_mult_taxo_gbnm(80948, 'scissortail sergeant').
ncbi_mult_taxo_gbnm(80949, 'white-tailed damselfish').
ncbi_mult_taxo_gbnm(80950, 'blacktail humbug').
ncbi_mult_taxo_gbnm(80951, 'reticulated damselfish').
ncbi_mult_taxo_gbnm(80952, 'goldbelly damsel').
ncbi_mult_taxo_gbnm(80953, 'speckled damselfish').
ncbi_mult_taxo_gbnm(80954, 'whitetail damsel').
ncbi_mult_taxo_gbnm(80955, 'neon damselfish').
ncbi_mult_taxo_gbnm(80956, 'lemon damsel').
ncbi_mult_taxo_gbnm(80966, 'spiny chromis').
ncbi_mult_taxo_gbnm(80968, 'staghorn damselfish').
ncbi_mult_taxo_gbnm(80970, 'yellowtail clownfish').
ncbi_mult_taxo_gbnm(80971, 'tomato clownfish').
ncbi_mult_taxo_gbnm(80972, 'clown anemonefish').
ncbi_mult_taxo_gbnm(80973, 'pink anemonefish').
ncbi_mult_taxo_gbnm(80975, 'yellow chromis').
ncbi_mult_taxo_gbnm(80976, 'smokey chromis').
ncbi_mult_taxo_gbnm(80977, 'blue green damselfish').
ncbi_mult_taxo_gbnm(80980, 'king demoisselle').
ncbi_mult_taxo_gbnm(80982, 'bowtie damselfish').
ncbi_mult_taxo_gbnm(80983, 'black-and-gold chromis').
ncbi_mult_taxo_gbnm(80984, 'lyretail damselfishes').
ncbi_mult_taxo_gbnm(80985, 'yellow-tail demoiselle').
ncbi_mult_taxo_gbnm(80987, 'blackbar devil').
ncbi_mult_taxo_gbnm(80988, 'whitespotted devil').
ncbi_mult_taxo_gbnm(80991, 'spinecheek anemonefish').
ncbi_mult_taxo_gbnm(80993, 'Japanese gregory').
ncbi_mult_taxo_gbnm(80994, 'Pacific gregory').
ncbi_mult_taxo_gbnm(80998, 'Jordan\'s damsel').
ncbi_mult_taxo_gbnm(81336, 'speckled pavon').
ncbi_mult_taxo_gbnm(81339, 'pearl cichlid').
ncbi_mult_taxo_gbnm(81340, 'sharphead eartheater').
ncbi_mult_taxo_gbnm(81341, 'demon eartheater').
ncbi_mult_taxo_gbnm(81343, 'threadfin acara').
ncbi_mult_taxo_gbnm(81347, 'orinoco eartheater').
ncbi_mult_taxo_gbnm(81370, 'North Atlantic opah').
ncbi_mult_taxo_gbnm(81373, unicornfish).
ncbi_mult_taxo_gbnm(81377, 'trout-perches and others').
ncbi_mult_taxo_gbnm(81382, beardfishes).
ncbi_mult_taxo_gbnm(81385, 'silver eye').
ncbi_mult_taxo_gbnm(81386, 'opahs and oarfishes').
ncbi_mult_taxo_gbnm(81389, 'king of herrings').
ncbi_mult_taxo_gbnm(81392, 'Atlantic lizardfish').
ncbi_mult_taxo_gbnm(81393, ribbonfishes).
ncbi_mult_taxo_gbnm(81395, dealfish).
ncbi_mult_taxo_gbnm(81419, 'hairy maggot blowfly').
ncbi_mult_taxo_gbnm(81522, 'white-backed woodpecker').
ncbi_mult_taxo_gbnm(81572, 'silvery gibbon').
ncbi_mult_taxo_gbnm(81578, 'southern pocketbook').
ncbi_mult_taxo_gbnm(81620, 'Cassin\'s vireo').
ncbi_mult_taxo_gbnm(81630, 'great long-nosed armadillo').
ncbi_mult_taxo_gbnm(81631, 'Cape spiny mouse').
ncbi_mult_taxo_gbnm(81636, 'blue whiting').
ncbi_mult_taxo_gbnm(81640, 'fourbeard rockling').
ncbi_mult_taxo_gbnm(81641, cuskfishes).
ncbi_mult_taxo_gbnm(81643, 'Arctic rockling').
ncbi_mult_taxo_gbnm(81695, 'New Zealand batfly').
ncbi_mult_taxo_gbnm(81697, 'bat flies').
ncbi_mult_taxo_gbnm(81707, 'wingless bat flies').
ncbi_mult_taxo_gbnm(81710, 'louse flies').
ncbi_mult_taxo_gbnm(81835, 'dwarf spiders and sheet-web weavers').
ncbi_mult_taxo_gbnm(81868, 'lovely hatchetfish').
ncbi_mult_taxo_gbnm(81869, 'Pacific hatchet fish').
ncbi_mult_taxo_gbnm(81870, 'Sladen\'s hatchetfish').
ncbi_mult_taxo_gbnm(81873, 'diaphanous hatchet fish').
ncbi_mult_taxo_gbnm(81879, 'Guianan cock-of-the-rock').
ncbi_mult_taxo_gbnm(81889, 'barred antshrike').
ncbi_mult_taxo_gbnm(81899, 'Sakhalin surf clam').
ncbi_mult_taxo_gbnm(81901, 'Pfeiffer\'s top shell').
ncbi_mult_taxo_gbnm(81903, 'American coot').
ncbi_mult_taxo_gbnm(81905, 'eastern screech-owl').
ncbi_mult_taxo_gbnm(81907, 'australian brush-turkey').
ncbi_mult_taxo_gbnm(81911, 'red-billed hornbill').
ncbi_mult_taxo_gbnm(81913, 'Japanese dodder').
ncbi_mult_taxo_gbnm(81935, 'Forrest\'s mouse').
ncbi_mult_taxo_gbnm(81936, 'Lakeland Downs mouse').
ncbi_mult_taxo_gbnm(82168, 'European pond turtle').
ncbi_mult_taxo_gbnm(82174, 'false killer whale').
ncbi_mult_taxo_gbnm(82248, 'Aztec lily').
ncbi_mult_taxo_gbnm(82256, 'zephyr lily').
ncbi_mult_taxo_gbnm(82281, 'clustered bellflower').
ncbi_mult_taxo_gbnm(82312, 'Hong Kong lily').
ncbi_mult_taxo_gbnm(82366, 'spotted halibut').
ncbi_mult_taxo_gbnm(82464, 'Korean red-backed vole').
ncbi_mult_taxo_gbnm(82468, 'Pere David\'s vole').
ncbi_mult_taxo_gbnm(82479, 'little sweet Betsy').
ncbi_mult_taxo_gbnm(82495, 'prairie trillium').
ncbi_mult_taxo_gbnm(82579, 'pearly crescentspot').
ncbi_mult_taxo_gbnm(82582, 'emperor butterflies').
ncbi_mult_taxo_gbnm(82589, 'Io moth').
ncbi_mult_taxo_gbnm(82592, 'inchworm moths').
ncbi_mult_taxo_gbnm(82593, 'geometer moths').
ncbi_mult_taxo_gbnm(82595, 'pepper-and-salt moth').
ncbi_mult_taxo_gbnm(82600, 'codling moth').
ncbi_mult_taxo_gbnm(82607, 'pine-devil moth').
ncbi_mult_taxo_gbnm(82613, 'sack-bearer moths').
ncbi_mult_taxo_gbnm(82616, 'small-eyed sphinx moth').
ncbi_mult_taxo_gbnm(82619, 'southern pine sphinx').
ncbi_mult_taxo_gbnm(82622, 'hummingbird moths').
ncbi_mult_taxo_gbnm(82624, 'small-eyed sphinx').
ncbi_mult_taxo_gbnm(82655, 'European conger').
ncbi_mult_taxo_gbnm(82663, 'Painted tree iguana').
ncbi_mult_taxo_gbnm(82738, 'minute pirate bugs').
ncbi_mult_taxo_gbnm(82758, 'Pacific madrone').
ncbi_mult_taxo_gbnm(82890, marblefishes).
ncbi_mult_taxo_gbnm(82899, 'blackbarred morwong').
ncbi_mult_taxo_gbnm(83141, 'velvet mites').
ncbi_mult_taxo_gbnm(83152, 'feather mites').
ncbi_mult_taxo_gbnm(83154, 'summer cypress').
ncbi_mult_taxo_gbnm(83163, 'feather mites').
ncbi_mult_taxo_gbnm(83203, 'yellowfin notie').
ncbi_mult_taxo_gbnm(83205, 'black southern cod').
ncbi_mult_taxo_gbnm(83269, 'black deer fly').
ncbi_mult_taxo_gbnm(83281, 'diademed sifaka').
ncbi_mult_taxo_gbnm(83287, 'sharp-tailed grouse').
ncbi_mult_taxo_gbnm(83310, 'orchid bees').
ncbi_mult_taxo_gbnm(83319, 'stingless bees').
ncbi_mult_taxo_gbnm(83323, 'digger bees').
ncbi_mult_taxo_gbnm(83385, 'white char').
ncbi_mult_taxo_gbnm(83386, 'Asiatic lion').
ncbi_mult_taxo_gbnm(83388, 'longnose grenadier').
ncbi_mult_taxo_gbnm(83389, 'longfin grenadier').
ncbi_mult_taxo_gbnm(83390, 'Pacific grenadier').
ncbi_mult_taxo_gbnm(83391, 'popeye grenadier').
ncbi_mult_taxo_gbnm(83392, 'giant grenadier').
ncbi_mult_taxo_gbnm(83396, 'longarm grenadier').
ncbi_mult_taxo_gbnm(83398, 'blackfin cisco').
ncbi_mult_taxo_gbnm(83485, 'Argentine ant').
ncbi_mult_taxo_gbnm(83527, 'Percival\'s spiny mouse').
ncbi_mult_taxo_gbnm(83528, 'Crete spiny mouse').
ncbi_mult_taxo_gbnm(83529, 'Cyprus spiny mouse').
ncbi_mult_taxo_gbnm(83530, 'Asia Minor spiny mouse').
ncbi_mult_taxo_gbnm(83535, 'rusty-bellied brush-furred rat').
ncbi_mult_taxo_gbnm(83653, 'Risso\'s dolphin').
ncbi_mult_taxo_gbnm(83752, 'rice-field rat').
ncbi_mult_taxo_gbnm(83753, 'summit rat').
ncbi_mult_taxo_gbnm(83755, 'Malayan field rat').
ncbi_mult_taxo_gbnm(83756, 'Edwards\'s long-tailed giant rat').
ncbi_mult_taxo_gbnm(83757, 'white-bellied rat').
ncbi_mult_taxo_gbnm(83759, 'Bower\'s white-toothed rat').
ncbi_mult_taxo_gbnm(83761, 'Mueller\'s giant Sunda rat').
ncbi_mult_taxo_gbnm(83762, 'Kemp\'s spiny mouse').
ncbi_mult_taxo_gbnm(83773, 'servant mouse').
ncbi_mult_taxo_gbnm(83774, 'Chestnut white-bellied rat').
ncbi_mult_taxo_gbnm(83869, 'giant scales').
ncbi_mult_taxo_gbnm(83874, 'sapphire devil').
ncbi_mult_taxo_gbnm(83875, 'Japanese jack mackerel').
ncbi_mult_taxo_gbnm(83878, 'Temminck\'s surfperch').
ncbi_mult_taxo_gbnm(83881, cardinalfishes).
ncbi_mult_taxo_gbnm(83883, 'half-lined cardinal').
ncbi_mult_taxo_gbnm(83887, 'cloud sponge').
ncbi_mult_taxo_gbnm(83902, 'brown-banded cockroach').
ncbi_mult_taxo_gbnm(83906, ramie).
ncbi_mult_taxo_gbnm(83912, 'sheep scab mite').
ncbi_mult_taxo_gbnm(83937, 'American trumpet vine').
ncbi_mult_taxo_gbnm(83951, 'Indian trumpet tree').
ncbi_mult_taxo_gbnm(83971, 'mottled shovel-nosed frog').
ncbi_mult_taxo_gbnm(83975, 'squeaking frogs').
ncbi_mult_taxo_gbnm(83977, 'Buea screeching frog').
ncbi_mult_taxo_gbnm(84011, 'alpine bearberry').
ncbi_mult_taxo_gbnm(84074, 'silky anteater').
ncbi_mult_taxo_gbnm(84099, 'Cuvier\'s dwarf caiman').
ncbi_mult_taxo_gbnm(84293, 'hemlock looper').
ncbi_mult_taxo_gbnm(84294, 'eastern hemlock looper').
ncbi_mult_taxo_gbnm(84296, 'western hemlock looper').
ncbi_mult_taxo_gbnm(84318, 'seed shrimps & mussel shrimps').
ncbi_mult_taxo_gbnm(84524, 'horse bot flies').
ncbi_mult_taxo_gbnm(84543, 'queen parrotfish').
ncbi_mult_taxo_gbnm(84545, 'weaver ants').
ncbi_mult_taxo_gbnm(84565, 'tsetse S-endosymbionts').
ncbi_mult_taxo_gbnm(84619, 'sand lances').
ncbi_mult_taxo_gbnm(84621, 'small sandeel').
ncbi_mult_taxo_gbnm(84623, 'southern viscacha').
ncbi_mult_taxo_gbnm(84638, 'Cuban stone crab').
ncbi_mult_taxo_gbnm(84645, rohu).
ncbi_mult_taxo_gbnm(84648, 'Guianan squirrel').
ncbi_mult_taxo_gbnm(84651, 'stilt crabs').
ncbi_mult_taxo_gbnm(84653, 'inflated stilt crab').
ncbi_mult_taxo_gbnm(84654, 'pea crabs').
ncbi_mult_taxo_gbnm(84658, 'nimble spray crab').
ncbi_mult_taxo_gbnm(84660, 'porcelain crabs').
ncbi_mult_taxo_gbnm(84662, 'green porcelain crab').
ncbi_mult_taxo_gbnm(84683, 'solenocerid shrimps').
ncbi_mult_taxo_gbnm(84684, 'humpback shrimps').
ncbi_mult_taxo_gbnm(84701, 'Tian Shan wapiti').
ncbi_mult_taxo_gbnm(84702, 'Yarkand deer').
ncbi_mult_taxo_gbnm(84766, 'Humboldt\'s flying squirrel').
ncbi_mult_taxo_gbnm(84769, 'brown lemming').
ncbi_mult_taxo_gbnm(84782, 'common grackle').
ncbi_mult_taxo_gbnm(84783, 'Grayish saltator').
ncbi_mult_taxo_gbnm(84785, 'western meadowlark').
ncbi_mult_taxo_gbnm(84791, 'yellow-billed cacique').
ncbi_mult_taxo_gbnm(84795, 'austral blackbird').
ncbi_mult_taxo_gbnm(84799, bobolink).
ncbi_mult_taxo_gbnm(84801, 'Rusty blackbird').
ncbi_mult_taxo_gbnm(84803, 'Chopi blackbird').
ncbi_mult_taxo_gbnm(84805, 'epaulet oriole').
ncbi_mult_taxo_gbnm(84812, 'scarlet-headed blackbird').
ncbi_mult_taxo_gbnm(84814, 'solitary cacique').
ncbi_mult_taxo_gbnm(84817, 'Brewer\'s blackbird').
ncbi_mult_taxo_gbnm(84819, 'oriole blackbird').
ncbi_mult_taxo_gbnm(84822, 'Bullock\'s oriole').
ncbi_mult_taxo_gbnm(84825, 'Jamaican oriole').
ncbi_mult_taxo_gbnm(84826, 'yellow-tailed oriole').
ncbi_mult_taxo_gbnm(84827, 'Yellow oriole').
ncbi_mult_taxo_gbnm(84831, 'golden-tufted mountain grackle').
ncbi_mult_taxo_gbnm(84833, 'bronzed cowbird').
ncbi_mult_taxo_gbnm(84835, 'bay-winged cowbird').
ncbi_mult_taxo_gbnm(84839, 'Jamaican blackbird').
ncbi_mult_taxo_gbnm(84841, 'Bolivian blackbird').
ncbi_mult_taxo_gbnm(84843, 'indigo bunting').
ncbi_mult_taxo_gbnm(84845, 'russet-backed oropendola').
ncbi_mult_taxo_gbnm(84849, 'yellow-rumped marshbird').
ncbi_mult_taxo_gbnm(84850, 'brown-and-yellow marshbird').
ncbi_mult_taxo_gbnm(84854, dickcissel).
ncbi_mult_taxo_gbnm(85047, 'Allegheny woodrat').
ncbi_mult_taxo_gbnm(85051, 'creek heelsplitter').
ncbi_mult_taxo_gbnm(85062, davatchan).
ncbi_mult_taxo_gbnm(85066, 'American crow').
ncbi_mult_taxo_gbnm(85089, 'Couch\'s spadefoot toad').
ncbi_mult_taxo_gbnm(85095, 'Malachite kingfisher').
ncbi_mult_taxo_gbnm(85097, 'Pacific loon').
ncbi_mult_taxo_gbnm(85099, 'black-necked grebe').
ncbi_mult_taxo_gbnm(85105, 'Eurasian thick-knee').
ncbi_mult_taxo_gbnm(85118, 'inquiline gall wasps').
ncbi_mult_taxo_gbnm(85120, mothmidge).
ncbi_mult_taxo_gbnm(85156, 'European bushcricket').
ncbi_mult_taxo_gbnm(85178, 'nettle-leaved bellflower').
ncbi_mult_taxo_gbnm(85179, 'southern catalpa').
ncbi_mult_taxo_gbnm(85283, 'black bat flower').
ncbi_mult_taxo_gbnm(85293, 'European cranberrybush').
ncbi_mult_taxo_gbnm(85310, 'southern green stink bug').
ncbi_mult_taxo_gbnm(85415, 'golden goby').
ncbi_mult_taxo_gbnm(85416, 'Bucchich\'s goby').
ncbi_mult_taxo_gbnm(85417, 'black goby').
ncbi_mult_taxo_gbnm(85418, 'rock goby').
ncbi_mult_taxo_gbnm(85419, 'marbled goby').
ncbi_mult_taxo_gbnm(85420, 'quagga goby').
ncbi_mult_taxo_gbnm(85426, 'zebra goby').
ncbi_mult_taxo_gbnm(85428, 'grass goby').
ncbi_mult_taxo_gbnm(85440, 'Bloyet\'s haplo').
ncbi_mult_taxo_gbnm(85509, 'subterranean silverfish').
ncbi_mult_taxo_gbnm(85510, 'forest silverfish').
ncbi_mult_taxo_gbnm(85517, 'desert warthog').
ncbi_mult_taxo_gbnm(85520, 'Grey-throated warbler').
ncbi_mult_taxo_gbnm(85526, 'golden-crowned warbler').
ncbi_mult_taxo_gbnm(85551, 'orange mud crab').
ncbi_mult_taxo_gbnm(85552, 'green mud crab').
ncbi_mult_taxo_gbnm(85553, 'purple mud crab').
ncbi_mult_taxo_gbnm(85566, 'streamline chub').
ncbi_mult_taxo_gbnm(85568, 'silver chub').
ncbi_mult_taxo_gbnm(85571, 'mandarin orange').
ncbi_mult_taxo_gbnm(85585, 'smaller tea tortrix').
ncbi_mult_taxo_gbnm(85587, 'polkadot poison frog').
ncbi_mult_taxo_gbnm(85588, 'red-headed poison frog').
ncbi_mult_taxo_gbnm(85589, 'granular poison frog').
ncbi_mult_taxo_gbnm(85590, 'yellow-headed poison frog').
ncbi_mult_taxo_gbnm(85591, 'Amazonian poison frog').
ncbi_mult_taxo_gbnm(85608, 'spotted turtle').
ncbi_mult_taxo_gbnm(85611, 'ornate box turtle').
ncbi_mult_taxo_gbnm(85613, 'Blanding\'s turtle').
ncbi_mult_taxo_gbnm(85655, 'Lucke tumor herpesvirus').
ncbi_mult_taxo_gbnm(85694, 'big-eared opossum').
ncbi_mult_taxo_gbnm(85815, dobsonflies).
ncbi_mult_taxo_gbnm(85816, fishflies).
ncbi_mult_taxo_gbnm(85819, lice).
ncbi_mult_taxo_gbnm(85820, 'elephant lice & wart-hog lice').
ncbi_mult_taxo_gbnm(85823, 'cockroaches & termites').
ncbi_mult_taxo_gbnm(85856, 'Yulan magnolia').
ncbi_mult_taxo_gbnm(85878, 'platypus tick').
ncbi_mult_taxo_gbnm(85952, 'Arctic lemming').
ncbi_mult_taxo_gbnm(85953, 'northern collared lemming').
ncbi_mult_taxo_gbnm(85954, 'Alaska yellow cedar').
ncbi_mult_taxo_gbnm(85961, 'Amazon water-lily').
ncbi_mult_taxo_gbnm(86009, 'sea gooseberries').
ncbi_mult_taxo_gbnm(86058, 'crown jellyfishes').
ncbi_mult_taxo_gbnm(86063, 'tope shark').
ncbi_mult_taxo_gbnm(86064, 'red-eyed tree frog').
ncbi_mult_taxo_gbnm(86068, 'Baikal whitefish').
ncbi_mult_taxo_gbnm(86195, 'Japanese four-lined ratsnake').
ncbi_mult_taxo_gbnm(86197, sleepers).
ncbi_mult_taxo_gbnm(86200, 'loach gobies').
ncbi_mult_taxo_gbnm(86202, sandfishes).
ncbi_mult_taxo_gbnm(86203, 'yellowfin goby').
ncbi_mult_taxo_gbnm(86205, 'barred mudskipper').
ncbi_mult_taxo_gbnm(86207, 'blacktail goby').
ncbi_mult_taxo_gbnm(86209, 'transparent sand dart').
ncbi_mult_taxo_gbnm(86213, 'onespot wormfish').
ncbi_mult_taxo_gbnm(86218, 'peacock gudgeon').
ncbi_mult_taxo_gbnm(86220, 'loach goby').
ncbi_mult_taxo_gbnm(86224, 'four-eyed sleeper').
ncbi_mult_taxo_gbnm(86232, 'sleeper goby').
ncbi_mult_taxo_gbnm(86233, 'dusky sleeper').
ncbi_mult_taxo_gbnm(86234, 'broadhead sleeper').
ncbi_mult_taxo_gbnm(86237, 'bluegilled bully').
ncbi_mult_taxo_gbnm(86242, 'Australian spotted gudgeon').
ncbi_mult_taxo_gbnm(86250, 'marble goby').
ncbi_mult_taxo_gbnm(86255, 'fragile urchin').
ncbi_mult_taxo_gbnm(86345, 'Bankor toad').
ncbi_mult_taxo_gbnm(86356, 'whiptail stingray').
ncbi_mult_taxo_gbnm(86357, 'longtail stingray').
ncbi_mult_taxo_gbnm(86358, 'snouted eagle ray').
ncbi_mult_taxo_gbnm(86359, 'butterfly rays').
ncbi_mult_taxo_gbnm(86361, 'California butterfly ray').
ncbi_mult_taxo_gbnm(86366, 'smoothtail devil ray').
ncbi_mult_taxo_gbnm(86371, 'long-tailed river stingray').
ncbi_mult_taxo_gbnm(86373, 'ocellate stingray').
ncbi_mult_taxo_gbnm(86375, 'Pacific cownose ray').
ncbi_mult_taxo_gbnm(86377, 'bluespotted ribbontail ray').
ncbi_mult_taxo_gbnm(86381, 'smooth-back river stingray').
ncbi_mult_taxo_gbnm(86382, 'Maracaibo river stingray').
ncbi_mult_taxo_gbnm(86513, 'blue corals').
ncbi_mult_taxo_gbnm(86543, 'deadman\'s fingers').
ncbi_mult_taxo_gbnm(86606, 'black sea whip').
ncbi_mult_taxo_gbnm(86643, 'Texas barometer bush').
ncbi_mult_taxo_gbnm(86673, 'American round stingrays').
ncbi_mult_taxo_gbnm(86675, 'Haller\'s round ray').
ncbi_mult_taxo_gbnm(86794, 'tree lungwort').
ncbi_mult_taxo_gbnm(86916, 'bluehead chub').
ncbi_mult_taxo_gbnm(86918, 'peamouth chub').
ncbi_mult_taxo_gbnm(86920, 'Mississippi silvery minnow').
ncbi_mult_taxo_gbnm(86921, 'gravel chub').
ncbi_mult_taxo_gbnm(86922, 'speckled chub').
ncbi_mult_taxo_gbnm(86923, 'hornyhead chub').
ncbi_mult_taxo_gbnm(86924, 'speckled dace').
ncbi_mult_taxo_gbnm(86926, 'Oregon chub').
ncbi_mult_taxo_gbnm(86928, 'Sacramento splittail').
ncbi_mult_taxo_gbnm(86930, 'redside shiner').
ncbi_mult_taxo_gbnm(86932, 'loach minnow').
ncbi_mult_taxo_gbnm(86934, 'Lahontan redside').
ncbi_mult_taxo_gbnm(86935, 'Mexican stoneroller').
ncbi_mult_taxo_gbnm(86936, 'beautiful shiner').
ncbi_mult_taxo_gbnm(86938, 'longfin dace').
ncbi_mult_taxo_gbnm(86942, 'eastern tonguetied minnow').
ncbi_mult_taxo_gbnm(86963, 'Polynesian longfinned eel').
ncbi_mult_taxo_gbnm(86964, 'Pacific shortfinned eel').
ncbi_mult_taxo_gbnm(86965, 'mottled eel').
ncbi_mult_taxo_gbnm(86967, 'highlands long-finned eel').
ncbi_mult_taxo_gbnm(86973, okapi).
ncbi_mult_taxo_gbnm(87088, 'rice bean').
ncbi_mult_taxo_gbnm(87114, 'South American cucurbit fruit fly').
ncbi_mult_taxo_gbnm(87138, 'cowtail stingray').
ncbi_mult_taxo_gbnm(87140, 'spotted eagle ray').
ncbi_mult_taxo_gbnm(87141, 'Japanese butterflyray').
ncbi_mult_taxo_gbnm(87177, 'Bananaquit').
ncbi_mult_taxo_gbnm(87288, 'Sclater\'s lemur').
ncbi_mult_taxo_gbnm(87325, 'eastern North American destroying angel').
ncbi_mult_taxo_gbnm(87707, 'satinfin shiner').
ncbi_mult_taxo_gbnm(87708, 'blue shiner').
ncbi_mult_taxo_gbnm(87709, 'Ocmulgee shiner').
ncbi_mult_taxo_gbnm(87710, 'Alabama shiner').
ncbi_mult_taxo_gbnm(87711, 'bluestripe shiner').
ncbi_mult_taxo_gbnm(87712, 'bluntface shiner').
ncbi_mult_taxo_gbnm(87713, 'greenfin shiner').
ncbi_mult_taxo_gbnm(87714, 'whitetail shiner').
ncbi_mult_taxo_gbnm(87715, 'Tallapoosa shiner').
ncbi_mult_taxo_gbnm(87716, 'thicklip chub').
ncbi_mult_taxo_gbnm(87717, 'bannerfin shiner').
ncbi_mult_taxo_gbnm(87718, 'plateau shiner').
ncbi_mult_taxo_gbnm(87720, 'whitefin shiner').
ncbi_mult_taxo_gbnm(87721, 'prosperine shiner').
ncbi_mult_taxo_gbnm(87722, 'fieryblack shiner').
ncbi_mult_taxo_gbnm(87723, 'tricolor shiner').
ncbi_mult_taxo_gbnm(87724, 'steelcolor shiner').
ncbi_mult_taxo_gbnm(87728, 'clear chub').
ncbi_mult_taxo_gbnm(87756, 'common two-banded seabream').
ncbi_mult_taxo_gbnm(87757, 'striped red mullet').
ncbi_mult_taxo_gbnm(87785, 'big-scale sand smelt').
ncbi_mult_taxo_gbnm(87972, 'sandpaper limpet').
ncbi_mult_taxo_gbnm(88029, 'Hanuman langur').
ncbi_mult_taxo_gbnm(88031, 'Masarene ridged frog').
ncbi_mult_taxo_gbnm(88032, 'Canada yew').
ncbi_mult_taxo_gbnm(88081, 'snouted night adder').
ncbi_mult_taxo_gbnm(88082, 'Tiger rattlesnake').
ncbi_mult_taxo_gbnm(88083, 'Shedao Island pitviper').
ncbi_mult_taxo_gbnm(88112, 'Eurasian skylark').
ncbi_mult_taxo_gbnm(88114, 'tufted titmouse').
ncbi_mult_taxo_gbnm(88116, 'Northern house-martin').
ncbi_mult_taxo_gbnm(88120, 'Bushtit').
ncbi_mult_taxo_gbnm(88123, 'Japanese plum').
ncbi_mult_taxo_gbnm(88125, 'Pearson\'s tuco-tuco').
ncbi_mult_taxo_gbnm(88127, 'collared tuco-tuco').
ncbi_mult_taxo_gbnm(88147, 'Shokihaze gobi').
ncbi_mult_taxo_gbnm(88148, 'bare-naped goby').
ncbi_mult_taxo_gbnm(88162, 'Madagascar day gecko').
ncbi_mult_taxo_gbnm(88171, 'white-fringed antwren').
ncbi_mult_taxo_gbnm(88175, 'Guianan warbling antbird').
ncbi_mult_taxo_gbnm(88177, 'plain-throated antwren').
ncbi_mult_taxo_gbnm(88181, 'pale-breasted spinetail').
ncbi_mult_taxo_gbnm(88185, 'rusty-backed antwren').
ncbi_mult_taxo_gbnm(88186, 'yellow-browed antbird').
ncbi_mult_taxo_gbnm(88200, 'Abe\'s mangrove goby').
ncbi_mult_taxo_gbnm(88201, 'yellowstripe goby').
ncbi_mult_taxo_gbnm(88202, 'least mullet goby').
ncbi_mult_taxo_gbnm(88206, 'graceful rock crab').
ncbi_mult_taxo_gbnm(88208, 'pygmy rock crab').
ncbi_mult_taxo_gbnm(88209, 'red rock crab').
ncbi_mult_taxo_gbnm(88211, 'flat porcelain crab').
ncbi_mult_taxo_gbnm(88212, 'woodlark cuscus').
ncbi_mult_taxo_gbnm(88217, 'Carniolan honeybee').
ncbi_mult_taxo_gbnm(88320, 'lampshade spiders').
ncbi_mult_taxo_gbnm(88327, 'funnel-web spiders').
ncbi_mult_taxo_gbnm(88328, 'purseweb spiders').
ncbi_mult_taxo_gbnm(88329, 'trapdoor spiders').
ncbi_mult_taxo_gbnm(88344, 'microwhip scorpions').
ncbi_mult_taxo_gbnm(88445, 'dharma pond frog').
ncbi_mult_taxo_gbnm(88446, 'Tokyo dharma pond frog').
ncbi_mult_taxo_gbnm(88447, 'dharma pond frog').
ncbi_mult_taxo_gbnm(88448, 'Fukien gold-striped pond frog').
ncbi_mult_taxo_gbnm(88450, 'montane vole').
ncbi_mult_taxo_gbnm(88454, 'southwestern water vole').
ncbi_mult_taxo_gbnm(88556, 'greenhouse whitefly').
ncbi_mult_taxo_gbnm(88653, 'longnose lancetfish').
ncbi_mult_taxo_gbnm(88656, 'common fangtooth').
ncbi_mult_taxo_gbnm(88661, alfonsinos).
ncbi_mult_taxo_gbnm(88663, 'splendid alfonsino').
ncbi_mult_taxo_gbnm(88665, 'yelloweye nannygai').
ncbi_mult_taxo_gbnm(88666, 'flabby whalefishes').
ncbi_mult_taxo_gbnm(88671, 'pink flabby whalefish').
ncbi_mult_taxo_gbnm(88673, 'pinecone fishes').
ncbi_mult_taxo_gbnm(88680, spinyfins).
ncbi_mult_taxo_gbnm(88682, 'silver spinyfin').
ncbi_mult_taxo_gbnm(88690, 'East African black mud turtle').
ncbi_mult_taxo_gbnm(88698, 'shoulderbar soldierfish').
ncbi_mult_taxo_gbnm(88705, 'Pacific beardfish').
ncbi_mult_taxo_gbnm(88706, ridgeheads).
ncbi_mult_taxo_gbnm(88708, 'crested bigscale').
ncbi_mult_taxo_gbnm(88709, 'redmouth whalefishes').
ncbi_mult_taxo_gbnm(88713, 'redmouth whalefish').
ncbi_mult_taxo_gbnm(88714, 'silverspot squirrelfish').
ncbi_mult_taxo_gbnm(88726, 'Turkish pine').
ncbi_mult_taxo_gbnm(88728, 'Korean pine').
ncbi_mult_taxo_gbnm(88801, 'agent of canine granulocytic ehrlichiosis').
ncbi_mult_taxo_gbnm(88846, 'Egyptian walking onion').
ncbi_mult_taxo_gbnm(89032, 'common flying dragon').
ncbi_mult_taxo_gbnm(89036, 'Dusky earless agama').
ncbi_mult_taxo_gbnm(89055, firebrat).
ncbi_mult_taxo_gbnm(89057, 'slime flounder').
ncbi_mult_taxo_gbnm(89058, 'Dover sole').
ncbi_mult_taxo_gbnm(89094, 'red and white giant flying squirrel').
ncbi_mult_taxo_gbnm(89095, 'Indian giant flying squirrel').
ncbi_mult_taxo_gbnm(89096, 'Andean akodont').
ncbi_mult_taxo_gbnm(89097, 'Morgan\'s gerbil mouse').
ncbi_mult_taxo_gbnm(89098, 'marsh rat').
ncbi_mult_taxo_gbnm(89099, 'large-headed rice rat').
ncbi_mult_taxo_gbnm(89100, 'Ihering\'s hocicudo').
ncbi_mult_taxo_gbnm(89101, 'Pinyon mouse').
ncbi_mult_taxo_gbnm(89102, 'Sumichrast\'s harvest mouse').
ncbi_mult_taxo_gbnm(89103, 'MacConnell\'s climbing mouse').
ncbi_mult_taxo_gbnm(89104, 'long-tailed climbing mouse').
ncbi_mult_taxo_gbnm(89105, 'splendid climbing mouse').
ncbi_mult_taxo_gbnm(89106, 'Wetzel\'s climbing mouse').
ncbi_mult_taxo_gbnm(89107, 'Chiriqui brown mouse').
ncbi_mult_taxo_gbnm(89108, 'Daphne\'s oldfield mouse').
ncbi_mult_taxo_gbnm(89109, 'slender oldfield mouse').
ncbi_mult_taxo_gbnm(89111, 'distinguished oldfield mouse').
ncbi_mult_taxo_gbnm(89112, 'montane oldfield mouse').
ncbi_mult_taxo_gbnm(89115, 'Brazilian shrew mouse').
ncbi_mult_taxo_gbnm(89117, 'Colombian forest mouse').
ncbi_mult_taxo_gbnm(89119, 'striped Atlantic forest rat').
ncbi_mult_taxo_gbnm(89121, 'woolly giant rat').
ncbi_mult_taxo_gbnm(89122, 'southern big-eared mouse').
ncbi_mult_taxo_gbnm(89124, 'Fernandina Galapagos mouse').
ncbi_mult_taxo_gbnm(89126, 'swamp rat').
ncbi_mult_taxo_gbnm(89131, 'pallid Atlantic forest rat').
ncbi_mult_taxo_gbnm(89132, 'lesser Wilfred\'s mouse').
ncbi_mult_taxo_gbnm(89133, 'Ebony akodont').
ncbi_mult_taxo_gbnm(89150, 'Mexican harvest mouse').
ncbi_mult_taxo_gbnm(89246, 'tawny-bellied cotton rat').
ncbi_mult_taxo_gbnm(89252, 'Burchell\'s zebra').
ncbi_mult_taxo_gbnm(89337, 'mountain whitefish').
ncbi_mult_taxo_gbnm(89379, 'Malagasy giant rat').
ncbi_mult_taxo_gbnm(89399, 'Chinese rufous horseshoe bat').
ncbi_mult_taxo_gbnm(89457, 'gray-tailed narrow-headed rat').
ncbi_mult_taxo_gbnm(89458, 'Ethiopian narrow-headed rat').
ncbi_mult_taxo_gbnm(89462, 'water buffalo').
ncbi_mult_taxo_gbnm(89468, 'Northern leaf-tail gecko').
ncbi_mult_taxo_gbnm(89475, 'big saltbush').
ncbi_mult_taxo_gbnm(89549, 'Eastern grey partridge').
ncbi_mult_taxo_gbnm(89554, 'golden galaxias').
ncbi_mult_taxo_gbnm(89555, 'banded kokopu').
ncbi_mult_taxo_gbnm(89556, 'swan galaxias').
ncbi_mult_taxo_gbnm(89557, 'Clarence galaxias').
ncbi_mult_taxo_gbnm(89561, 'shortjaw kokopu').
ncbi_mult_taxo_gbnm(89565, 'western mud minnow').
ncbi_mult_taxo_gbnm(89573, 'Tasmanian smelt').
ncbi_mult_taxo_gbnm(89574, 'black-stripe minnow').
ncbi_mult_taxo_gbnm(89577, 'salamanderfish and Shannon mudminnow').
ncbi_mult_taxo_gbnm(89578, salamanderfish).
ncbi_mult_taxo_gbnm(89632, 'Sumatran rhinoceros').
ncbi_mult_taxo_gbnm(89647, 'white morning-glory').
ncbi_mult_taxo_gbnm(89648, 'bush moonflower').
ncbi_mult_taxo_gbnm(89650, 'firecracker vine').
ncbi_mult_taxo_gbnm(89656, 'bay hops').
ncbi_mult_taxo_gbnm(89660, 'cypress vine').
ncbi_mult_taxo_gbnm(89672, 'Demidoff\'s galago').
ncbi_mult_taxo_gbnm(89673, 'pale spear-nosed bat').
ncbi_mult_taxo_gbnm(89829, 'pronggill mayflies').
ncbi_mult_taxo_gbnm(89900, 'bark scorpions').
ncbi_mult_taxo_gbnm(89945, 'offshore hake').
ncbi_mult_taxo_gbnm(89946, 'southern hake').
ncbi_mult_taxo_gbnm(89947, 'shallow-water Cape hake').
ncbi_mult_taxo_gbnm(89948, 'Southern Pacific hake').
ncbi_mult_taxo_gbnm(89949, 'Argentine hake').
ncbi_mult_taxo_gbnm(89950, 'deep-water Cape hake').
ncbi_mult_taxo_gbnm(89951, 'Benguela hake').
ncbi_mult_taxo_gbnm(89952, 'North Pacific hake').
ncbi_mult_taxo_gbnm(89953, 'Senegalese hake').
ncbi_mult_taxo_gbnm(89987, 'Benoit\'s lanternfish').
ncbi_mult_taxo_gbnm(89988, 'lantern fish').
ncbi_mult_taxo_gbnm(89991, 'large-finned lanternfish').
ncbi_mult_taxo_gbnm(90065, 'snake-eyed lizard').
ncbi_mult_taxo_gbnm(90067, 'Adriatic sole').
ncbi_mult_taxo_gbnm(90068, 'sand sole').
ncbi_mult_taxo_gbnm(90069, 'common sole').
ncbi_mult_taxo_gbnm(90071, solenette).
ncbi_mult_taxo_gbnm(90073, 'foureyed sole').
ncbi_mult_taxo_gbnm(90074, 'thickback sole').
ncbi_mult_taxo_gbnm(90313, 'cherry salmon').
ncbi_mult_taxo_gbnm(90382, 'Heck\'s macaque').
ncbi_mult_taxo_gbnm(90383, 'moor macaque').
ncbi_mult_taxo_gbnm(90385, 'booted macaque').
ncbi_mult_taxo_gbnm(90386, 'Philippine long-tailed macaque').
ncbi_mult_taxo_gbnm(90387, 'Northern pig-tailed macaque').
ncbi_mult_taxo_gbnm(90392, 'Murray river turtle').
ncbi_mult_taxo_gbnm(90396, 'jungle rice').
ncbi_mult_taxo_gbnm(90397, 'barnyard grass').
ncbi_mult_taxo_gbnm(90408, 'peppermint drop lichen').
ncbi_mult_taxo_gbnm(90412, 'bluelip parrotfish').
ncbi_mult_taxo_gbnm(90413, 'emerald parrotfish').
ncbi_mult_taxo_gbnm(90460, 'rattlesnake master').
ncbi_mult_taxo_gbnm(90521, 'Skyros wall lizard').
ncbi_mult_taxo_gbnm(90522, 'Milos wall lizard').
ncbi_mult_taxo_gbnm(90523, 'Peloponnese wall lizard').
ncbi_mult_taxo_gbnm(90659, 'yellowfin madtom').
ncbi_mult_taxo_gbnm(90660, 'orangefin madtom').
ncbi_mult_taxo_gbnm(90661, 'tadpole madtom').
ncbi_mult_taxo_gbnm(90662, 'least madtom').
ncbi_mult_taxo_gbnm(90663, 'margined madtom').
ncbi_mult_taxo_gbnm(90664, 'Ouachita madtom').
ncbi_mult_taxo_gbnm(90665, 'speckled madtom').
ncbi_mult_taxo_gbnm(90668, 'brown madtom').
ncbi_mult_taxo_gbnm(90669, 'Neosho madtom').
ncbi_mult_taxo_gbnm(90670, 'Caddo madtom').
ncbi_mult_taxo_gbnm(90675, 'false flax').
ncbi_mult_taxo_gbnm(90717, twite).
ncbi_mult_taxo_gbnm(90751, moroco).
ncbi_mult_taxo_gbnm(90755, 'blue grouse').
ncbi_mult_taxo_gbnm(90756, 'chestnut dunnart').
ncbi_mult_taxo_gbnm(90758, 'Julia Creek dunnart').
ncbi_mult_taxo_gbnm(90759, 'white-tailed dunnart').
ncbi_mult_taxo_gbnm(90760, 'hairy-footed dunnart').
ncbi_mult_taxo_gbnm(90761, 'white-footed dunnart').
ncbi_mult_taxo_gbnm(90764, 'long-tailed dunnart').
ncbi_mult_taxo_gbnm(90765, 'Ooldea dunnart').
ncbi_mult_taxo_gbnm(90766, 'sandhill dunnart').
ncbi_mult_taxo_gbnm(90767, 'red-cheeked dunnart').
ncbi_mult_taxo_gbnm(90770, 'lesser hairy-footed dunnart').
ncbi_mult_taxo_gbnm(90772, 'Carpentarian dunnart').
ncbi_mult_taxo_gbnm(90906, 'Mexican racerunner').
ncbi_mult_taxo_gbnm(90986, 'mole cricket nematode').
ncbi_mult_taxo_gbnm(90988, 'fathead minnow').
ncbi_mult_taxo_gbnm(91020, 'Indain temperate tasar silkmoth').
ncbi_mult_taxo_gbnm(91021, 'Indian muga silkmoth').
ncbi_mult_taxo_gbnm(91097, orpine).
ncbi_mult_taxo_gbnm(91179, 'Aseev').
ncbi_mult_taxo_gbnm(91233, 'disc abalone').
ncbi_mult_taxo_gbnm(91296, 'prairie fleabane').
ncbi_mult_taxo_gbnm(91461, 'yellowish elongate chafer').
ncbi_mult_taxo_gbnm(91462, 'Afeev').
ncbi_mult_taxo_gbnm(91496, 'Robinson\'s mouse opossum').
ncbi_mult_taxo_gbnm(91497, 'Dorothy\'s slender mouse opossum').
ncbi_mult_taxo_gbnm(91500, 'water opossum').
ncbi_mult_taxo_gbnm(91502, 'Buff-bellied fat-tailed mouse oppossum').
ncbi_mult_taxo_gbnm(91518, 'Japanese stiltgrass').
ncbi_mult_taxo_gbnm(91561, 'even-toed ungulates & whales').
ncbi_mult_taxo_gbnm(91607, damselfish).
ncbi_mult_taxo_gbnm(91608, 'Hawaiian threespot damsel').
ncbi_mult_taxo_gbnm(91609, 'whitetail damselfish').
ncbi_mult_taxo_gbnm(91610, 'black damselfish').
ncbi_mult_taxo_gbnm(91611, 'marginate dascyllus').
ncbi_mult_taxo_gbnm(91653, 'California headlightfish').
ncbi_mult_taxo_gbnm(91654, 'pinpoint lanternfish').
ncbi_mult_taxo_gbnm(91656, 'California flashlightfish').
ncbi_mult_taxo_gbnm(91658, 'northern lampfish').
ncbi_mult_taxo_gbnm(91721, 'African bonytongue').
ncbi_mult_taxo_gbnm(91729, 'Cornish jack').
ncbi_mult_taxo_gbnm(91738, 'northern brown argus').
ncbi_mult_taxo_gbnm(91739, 'brown argus').
ncbi_mult_taxo_gbnm(91743, 'chocolate hind').
ncbi_mult_taxo_gbnm(91745, 'white-patch tuskfish').
ncbi_mult_taxo_gbnm(91752, 'lion\'s mane mushroom').
ncbi_mult_taxo_gbnm(91761, 'grey-breasted mountain-toucan').
ncbi_mult_taxo_gbnm(91767, 'red-headed barbet').
ncbi_mult_taxo_gbnm(91775, 'Yellow-rumped Tinkerbird').
ncbi_mult_taxo_gbnm(91779, 'chestnut-eared aracari').
ncbi_mult_taxo_gbnm(91781, 'Cuvier\'s toucan').
ncbi_mult_taxo_gbnm(91787, 'D\'Arnaud\'s barbet').
ncbi_mult_taxo_gbnm(91798, 'Yunnan hare').
ncbi_mult_taxo_gbnm(91844, 'primary endosymbiont of Bemisia tabaci').
ncbi_mult_taxo_gbnm(91855, 'rock cale').
ncbi_mult_taxo_gbnm(91906, 'African chameleon').
ncbi_mult_taxo_gbnm(91907, 'common chameleon').
ncbi_mult_taxo_gbnm(91908, 'flapneck chameleon').
ncbi_mult_taxo_gbnm(91951, 'Swainson\'s thrush').
ncbi_mult_taxo_gbnm(91952, 'teardrop darter').
ncbi_mult_taxo_gbnm(91953, 'relict darter').
ncbi_mult_taxo_gbnm(91954, 'crown darter').
ncbi_mult_taxo_gbnm(91955, 'fringed darter').
ncbi_mult_taxo_gbnm(91956, 'barrens darter').
ncbi_mult_taxo_gbnm(91957, 'lollipop darter').
ncbi_mult_taxo_gbnm(91958, 'blackfin darter').
ncbi_mult_taxo_gbnm(91959, 'barcheek carter').
ncbi_mult_taxo_gbnm(91960, 'sooty darter').
ncbi_mult_taxo_gbnm(91961, 'guardian darter').
ncbi_mult_taxo_gbnm(91962, 'duskytail darter').
ncbi_mult_taxo_gbnm(91963, 'egg-mimic darter').
ncbi_mult_taxo_gbnm(91964, 'slabrock darter').
ncbi_mult_taxo_gbnm(91965, 'spottail darter').
ncbi_mult_taxo_gbnm(91966, 'striated darter').
ncbi_mult_taxo_gbnm(91967, 'striped darter').
ncbi_mult_taxo_gbnm(91969, 'Ebeling\'s fangjaw').
ncbi_mult_taxo_gbnm(91970, 'elongated bristlemouth fish').
ncbi_mult_taxo_gbnm(91975, 'Pacific portholefish').
ncbi_mult_taxo_gbnm(92050, 'Patagonian grenadier').
ncbi_mult_taxo_gbnm(92062, 'mountain weasel').
ncbi_mult_taxo_gbnm(92068, 'water mites').
ncbi_mult_taxo_gbnm(92120, 'prairie warbler').
ncbi_mult_taxo_gbnm(92121, 'Magnolia warbler').
ncbi_mult_taxo_gbnm(92122, 'Chestnut-sided warbler').
ncbi_mult_taxo_gbnm(92124, 'black-throated green warbler').
ncbi_mult_taxo_gbnm(92248, 'whirligig mites').
ncbi_mult_taxo_gbnm(92251, chiggers).
ncbi_mult_taxo_gbnm(92439, 'goldlined spinefoot').
ncbi_mult_taxo_gbnm(92481, 'Val\'s gundi').
ncbi_mult_taxo_gbnm(92483, 'Mzab gundi').
ncbi_mult_taxo_gbnm(92522, 'crab-eating raccoon').
ncbi_mult_taxo_gbnm(92523, 'Guadeloupe raccoon').
ncbi_mult_taxo_gbnm(92537, 'Richardson\'s collared lemming').
ncbi_mult_taxo_gbnm(92538, 'Ungava collared lemming').
ncbi_mult_taxo_gbnm(92557, 'dance flies').
ncbi_mult_taxo_gbnm(92558, 'long-legged flies').
ncbi_mult_taxo_gbnm(92600, 'smoke flies').
ncbi_mult_taxo_gbnm(92609, 'snipe flies').
ncbi_mult_taxo_gbnm(92615, 'tangle-veined flies').
ncbi_mult_taxo_gbnm(92616, 'small-headed flies').
ncbi_mult_taxo_gbnm(92619, 'horse lubber grasshopper').
ncbi_mult_taxo_gbnm(92649, 'pig-footed bandicoot').
ncbi_mult_taxo_gbnm(92651, bilby).
ncbi_mult_taxo_gbnm(92683, 'jackass penguin').
ncbi_mult_taxo_gbnm(92688, 'Erect-crested penguin').
ncbi_mult_taxo_gbnm(92690, 'horned powder-post beetles').
ncbi_mult_taxo_gbnm(92692, 'lesser grain borer').
ncbi_mult_taxo_gbnm(92721, 'dull rocket frog').
ncbi_mult_taxo_gbnm(92724, 'dyeing poison frog').
ncbi_mult_taxo_gbnm(92725, 'Brazilian poison frog').
ncbi_mult_taxo_gbnm(92727, 'phantasmal poison frogs').
ncbi_mult_taxo_gbnm(92730, 'pleasing poison frog').
ncbi_mult_taxo_gbnm(92731, 'Ecuador poison frog').
ncbi_mult_taxo_gbnm(92733, 'brilliant-thighed poison frog').
ncbi_mult_taxo_gbnm(92734, 'spot-legged poison frog').
ncbi_mult_taxo_gbnm(92737, 'three-striped poison frog').
ncbi_mult_taxo_gbnm(92738, 'snapping termites').
ncbi_mult_taxo_gbnm(92866, 'Ussuri sika deer').
ncbi_mult_taxo_gbnm(92921, 'milk thistle').
ncbi_mult_taxo_gbnm(93070, 'Cocos finch').
ncbi_mult_taxo_gbnm(93129, 'carmine spider mite').
ncbi_mult_taxo_gbnm(93157, 'gray marmot').
ncbi_mult_taxo_gbnm(93158, 'Bobak marmot').
ncbi_mult_taxo_gbnm(93159, 'Alaska marmot').
ncbi_mult_taxo_gbnm(93160, 'hoary marmot').
ncbi_mult_taxo_gbnm(93161, 'black-capped marmot').
ncbi_mult_taxo_gbnm(93162, 'yellow-bellied marmot').
ncbi_mult_taxo_gbnm(93163, 'Himalayan marmot').
ncbi_mult_taxo_gbnm(93164, 'Menzbier\'s marmot').
ncbi_mult_taxo_gbnm(93165, 'Olympic marmot').
ncbi_mult_taxo_gbnm(93166, 'Tarbagan marmot').
ncbi_mult_taxo_gbnm(93167, 'Vancouver Island marmot').
ncbi_mult_taxo_gbnm(93199, 'light southeastern subterranean termite').
ncbi_mult_taxo_gbnm(93208, 'swift tiger beetle').
ncbi_mult_taxo_gbnm(93382, 'white-winged dove').
ncbi_mult_taxo_gbnm(93412, 'large black chafer').
ncbi_mult_taxo_gbnm(93504, 'Asian corn borer').
ncbi_mult_taxo_gbnm(93600, 'Chinese weather loach').
ncbi_mult_taxo_gbnm(93621, 'stinging catfish').
ncbi_mult_taxo_gbnm(93700, 'fishing spiders').
ncbi_mult_taxo_gbnm(93704, 'lynx spiders').
ncbi_mult_taxo_gbnm(93708, 'hackled orbweavers').
ncbi_mult_taxo_gbnm(93715, 'Rocky Mountain parnassian').
ncbi_mult_taxo_gbnm(93721, 'black cherry aphid').
ncbi_mult_taxo_gbnm(93745, 'Illawara flametree').
ncbi_mult_taxo_gbnm(93767, 'California flannelbush').
ncbi_mult_taxo_gbnm(93817, 'one-flowered wintergreen').
ncbi_mult_taxo_gbnm(93819, 'one-sided wintergreen').
ncbi_mult_taxo_gbnm(93875, 'tube case makers').
ncbi_mult_taxo_gbnm(93876, 'finger-net caddisflies').
ncbi_mult_taxo_gbnm(93884, 'bagworm moths').
ncbi_mult_taxo_gbnm(93934, 'Japanese quail').
ncbi_mult_taxo_gbnm(94016, 'crab spiders').
ncbi_mult_taxo_gbnm(94017, 'jumping spiders').
ncbi_mult_taxo_gbnm(94026, 'autumn spider').
ncbi_mult_taxo_gbnm(94117, 'little red flying fox').
ncbi_mult_taxo_gbnm(94172, 'banded knifefish').
ncbi_mult_taxo_gbnm(94178, 'large Indian civet').
ncbi_mult_taxo_gbnm(94180, binturong).
ncbi_mult_taxo_gbnm(94182, 'small-toothed palm civet').
ncbi_mult_taxo_gbnm(94184, 'Owston\'s palm civet').
ncbi_mult_taxo_gbnm(94186, 'African civet').
ncbi_mult_taxo_gbnm(94188, fossa).
ncbi_mult_taxo_gbnm(94190, 'small-spotted genet').
ncbi_mult_taxo_gbnm(94192, 'banded palm civet').
ncbi_mult_taxo_gbnm(94194, 'banded linsang').
ncbi_mult_taxo_gbnm(94196, 'small Indian civet').
ncbi_mult_taxo_gbnm(94232, 'orange-spotted grouper').
ncbi_mult_taxo_gbnm(94237, 'ocean sunfish').
ncbi_mult_taxo_gbnm(94243, butterfishes).
ncbi_mult_taxo_gbnm(94247, 'Merriam\'s kangaroo rat').
ncbi_mult_taxo_gbnm(94248, 'chisel-toothed kangaroo rat').
ncbi_mult_taxo_gbnm(94286, 'balloon flower').
ncbi_mult_taxo_gbnm(94308, 'zebra turkeyfish').
ncbi_mult_taxo_gbnm(94324, 'Kumamoto oyster').
ncbi_mult_taxo_gbnm(94327, 'greater galangal').
ncbi_mult_taxo_gbnm(94395, 'American conger').
ncbi_mult_taxo_gbnm(94398, kiang).
ncbi_mult_taxo_gbnm(94400, 'green rice leafhopper').
ncbi_mult_taxo_gbnm(94413, 'Nidua fringe-fingered lizard').
ncbi_mult_taxo_gbnm(94417, 'Cape girdled lizard').
ncbi_mult_taxo_gbnm(94437, 'hairy-tailed mole').
ncbi_mult_taxo_gbnm(94439, 'tailess tenrec').
ncbi_mult_taxo_gbnm(94450, 'Carolina pygmy sunfish').
ncbi_mult_taxo_gbnm(94451, 'bluebarred pygmy sunfish').
ncbi_mult_taxo_gbnm(94612, 'Western forest robin').
ncbi_mult_taxo_gbnm(94623, 'great auk').
ncbi_mult_taxo_gbnm(94630, 'northern acorn barnacle').
ncbi_mult_taxo_gbnm(94641, 'white plague pathogen').
ncbi_mult_taxo_gbnm(94770, 'Blue Mountains treefrog').
ncbi_mult_taxo_gbnm(94777, glowworms).
ncbi_mult_taxo_gbnm(94803, 'footballer mite').
ncbi_mult_taxo_gbnm(94806, 'rake-legged mite').
ncbi_mult_taxo_gbnm(94808, 'rake-legged mite').
ncbi_mult_taxo_gbnm(94827, 'white-throated tinamou').
ncbi_mult_taxo_gbnm(94828, 'Hottentot buttonquail').
ncbi_mult_taxo_gbnm(94829, 'snout mites').
ncbi_mult_taxo_gbnm(94835, 'Gharial').
ncbi_mult_taxo_gbnm(94840, 'whirligig mite').
ncbi_mult_taxo_gbnm(94850, 'gopher snake').
ncbi_mult_taxo_gbnm(94859, 'Cape gopher snake').
ncbi_mult_taxo_gbnm(94874, 'California Mountain kingsnake').
ncbi_mult_taxo_gbnm(94881, 'Helena Mountain kingsnake').
ncbi_mult_taxo_gbnm(94886, 'Eastern fox snake').
ncbi_mult_taxo_gbnm(94897, 'scarlet snake').
ncbi_mult_taxo_gbnm(94899, coachwhip).
ncbi_mult_taxo_gbnm(94901, 'longnose snake').
ncbi_mult_taxo_gbnm(94905, 'short-tailed snake').
ncbi_mult_taxo_gbnm(94908, 'Congo puffer').
ncbi_mult_taxo_gbnm(94911, 'hardhead silverside').
ncbi_mult_taxo_gbnm(94915, 'sand diver').
ncbi_mult_taxo_gbnm(94919, 'pirate perch').
ncbi_mult_taxo_gbnm(94921, 'plate fish').
ncbi_mult_taxo_gbnm(94922, 'flying gurnards').
ncbi_mult_taxo_gbnm(94924, 'flying gurnard').
ncbi_mult_taxo_gbnm(94928, 'black triggerfish').
ncbi_mult_taxo_gbnm(94929, 'cusk-eels and others').
ncbi_mult_taxo_gbnm(94930, 'cusk-eels').
ncbi_mult_taxo_gbnm(94932, 'redfin brotula').
ncbi_mult_taxo_gbnm(94934, 'longjaw bigscale').
ncbi_mult_taxo_gbnm(94935, needlefishes).
ncbi_mult_taxo_gbnm(94937, 'redfin needlefish').
ncbi_mult_taxo_gbnm(94939, 'mirror dory').
ncbi_mult_taxo_gbnm(94942, 'stone crayfish').
ncbi_mult_taxo_gbnm(94943, 'white-clawed crayfish').
ncbi_mult_taxo_gbnm(94945, 'western patchnose snake').
ncbi_mult_taxo_gbnm(94949, 'lesser amberjack').
ncbi_mult_taxo_gbnm(94951, 'common dentex').
ncbi_mult_taxo_gbnm(94953, comber).
ncbi_mult_taxo_gbnm(94955, 'Shi drum').
ncbi_mult_taxo_gbnm(94956, 'Davy\'s naked-backed bat').
ncbi_mult_taxo_gbnm(94957, 'bulldog bats').
ncbi_mult_taxo_gbnm(94959, 'New Zealand short-tailed bats').
ncbi_mult_taxo_gbnm(94961, 'New Zealand lesser short-tailed bat').
ncbi_mult_taxo_gbnm(94962, 'lesser bulldog bat').
ncbi_mult_taxo_gbnm(94963, 'greater bulldog bat').
ncbi_mult_taxo_gbnm(94984, 'lesser weever').
ncbi_mult_taxo_gbnm(94993, 'European catfish').
ncbi_mult_taxo_gbnm(95122, 'New Caledonia giant gecko').
ncbi_mult_taxo_gbnm(95124, 'Western beaked gecko').
ncbi_mult_taxo_gbnm(95128, 'Angiana treefrog').
ncbi_mult_taxo_gbnm(95130, 'fringed tree frog').
ncbi_mult_taxo_gbnm(95131, 'big-eyed treefrog').
ncbi_mult_taxo_gbnm(95132, 'brown-spotted treefrog').
ncbi_mult_taxo_gbnm(95133, 'dainty green tree frog').
ncbi_mult_taxo_gbnm(95134, 'Stony Creek frog').
ncbi_mult_taxo_gbnm(95135, 'Nodugl treefrog').
ncbi_mult_taxo_gbnm(95136, 'torrent treefrog').
ncbi_mult_taxo_gbnm(95137, 'common mist frog').
ncbi_mult_taxo_gbnm(95142, 'big-eyed treefrogs').
ncbi_mult_taxo_gbnm(95143, 'lace-eyed tree frog').
ncbi_mult_taxo_gbnm(95145, 'Gulf toadfish').
ncbi_mult_taxo_gbnm(95166, 'thread-waisted wasps').
ncbi_mult_taxo_gbnm(95181, 'greater red dart moth').
ncbi_mult_taxo_gbnm(95199, 'clover looper').
ncbi_mult_taxo_gbnm(95219, 'green cloverworm').
ncbi_mult_taxo_gbnm(95247, 'green leuconycta').
ncbi_mult_taxo_gbnm(95252, 'small mossy lithacodia').
ncbi_mult_taxo_gbnm(95259, 'white-marked tussock moth').
ncbi_mult_taxo_gbnm(95274, 'web-spinning and leaf-rolling sawflies').
ncbi_mult_taxo_gbnm(95461, 'red rock lobster').
ncbi_mult_taxo_gbnm(95463, 'yellow dung fly').
ncbi_mult_taxo_gbnm(95543, 'golden tropheops').
ncbi_mult_taxo_gbnm(95544, 'Japanese bullhead shark').
ncbi_mult_taxo_gbnm(95565, 'gold-rim swallowtail').
ncbi_mult_taxo_gbnm(95582, 'crimson rose swallowtail').
ncbi_mult_taxo_gbnm(95586, 'common clubtail').
ncbi_mult_taxo_gbnm(95590, 'common birdwing').
ncbi_mult_taxo_gbnm(95599, jezebels).
ncbi_mult_taxo_gbnm(95602, 'Chinese mitten crab').
ncbi_mult_taxo_gbnm(95603, 'Japanese mitten crab').
ncbi_mult_taxo_gbnm(95634, 'highland doghobble').
ncbi_mult_taxo_gbnm(95648, 'Jararaca pintada').
ncbi_mult_taxo_gbnm(95675, 'sea skaters').
ncbi_mult_taxo_gbnm(95677, 'water crickets').
ncbi_mult_taxo_gbnm(95683, 'marsh treaders').
ncbi_mult_taxo_gbnm(95686, 'water treaders').
ncbi_mult_taxo_gbnm(95912, 'striped hyena').
ncbi_mult_taxo_gbnm(95972, 'predatory gall midge').
ncbi_mult_taxo_gbnm(96243, 'Mexican corn rootworm').
ncbi_mult_taxo_gbnm(96428, 'elegant mabuya').
ncbi_mult_taxo_gbnm(96430, 'African five-lined skink').
ncbi_mult_taxo_gbnm(96437, 'Spix\'s whiptail').
ncbi_mult_taxo_gbnm(96440, 'Argentine black and white tegu').
ncbi_mult_taxo_gbnm(96441, 'red tegu').
ncbi_mult_taxo_gbnm(96718, 'major skink').
ncbi_mult_taxo_gbnm(96720, 'Long-tailed sun skink').
ncbi_mult_taxo_gbnm(96722, 'rough mabuya').
ncbi_mult_taxo_gbnm(96724, 'tough-snouted giant gecko').
ncbi_mult_taxo_gbnm(96739, 'Tokashiki gecko').
ncbi_mult_taxo_gbnm(96741, 'African fat-tailed gecko').
ncbi_mult_taxo_gbnm(96759, 'Blotched forest skink').
ncbi_mult_taxo_gbnm(96761, 'Berdmores water skink').
ncbi_mult_taxo_gbnm(96776, roughies).
ncbi_mult_taxo_gbnm(96778, 'orange roughy').
ncbi_mult_taxo_gbnm(96794, 'banded Egyptian cobra').
ncbi_mult_taxo_gbnm(96821, 'oak-woodland pillbug').
ncbi_mult_taxo_gbnm(96856, 'common sea slater').
ncbi_mult_taxo_gbnm(96881, 'orange tortrix').
ncbi_mult_taxo_gbnm(96882, 'saddleback clownfish').
ncbi_mult_taxo_gbnm(96883, 'yellow clownfish').
ncbi_mult_taxo_gbnm(96884, nameradamashi).
ncbi_mult_taxo_gbnm(96886, 'white sardinella').
ncbi_mult_taxo_gbnm(96887, 'fringescale sardinella').
ncbi_mult_taxo_gbnm(96888, 'Indian oil sardine').
ncbi_mult_taxo_gbnm(96889, 'freshwater sardinella').
ncbi_mult_taxo_gbnm(96903, 'three spot gourami').
ncbi_mult_taxo_gbnm(96932, 'giant floater mussel').
ncbi_mult_taxo_gbnm(96939, 'riverbank grape').
ncbi_mult_taxo_gbnm(96982, 'blue-spotted spiny lizard').
ncbi_mult_taxo_gbnm(96983, 'red-spotted minor lizard').
ncbi_mult_taxo_gbnm(96991, 'smoothcheek eartheater').
ncbi_mult_taxo_gbnm(96998, 'bay snook').
ncbi_mult_taxo_gbnm(97007, 'owl-head clover').
ncbi_mult_taxo_gbnm(97097, 'White-tailed tropicbird').
ncbi_mult_taxo_gbnm(97160, 'blue moki').
ncbi_mult_taxo_gbnm(97162, 'striped trumpeter').
ncbi_mult_taxo_gbnm(97165, 'bastard trumpeter').
ncbi_mult_taxo_gbnm(97177, 'Caucasian fir').
ncbi_mult_taxo_gbnm(97190, 'circumcision cone').
ncbi_mult_taxo_gbnm(97206, 'Texas deermouse').
ncbi_mult_taxo_gbnm(97207, 'Zacatecan deer mouse').
ncbi_mult_taxo_gbnm(97208, 'Osgood\'s mouse').
ncbi_mult_taxo_gbnm(97209, 'nimble-footed mouse').
ncbi_mult_taxo_gbnm(97211, 'Tres Marias Island mouse').
ncbi_mult_taxo_gbnm(97212, 'northern rock mouse').
ncbi_mult_taxo_gbnm(97213, 'white-ankled mouse').
ncbi_mult_taxo_gbnm(97216, 'Chihuahuan mouse').
ncbi_mult_taxo_gbnm(97219, 'San Esteban Island mouse').
ncbi_mult_taxo_gbnm(97306, 'miyama cherry').
ncbi_mult_taxo_gbnm(97325, 'Japanese mountain cherry').
ncbi_mult_taxo_gbnm(97360, 'bay duiker').
ncbi_mult_taxo_gbnm(97363, saola).
ncbi_mult_taxo_gbnm(97435, 'Macloskey\'s violet').
ncbi_mult_taxo_gbnm(97723, 'pink porcelain-lily').
ncbi_mult_taxo_gbnm(97955, 'Mallorcan midwife toad').
ncbi_mult_taxo_gbnm(97956, 'Iberian painted frog').
ncbi_mult_taxo_gbnm(98002, touristplant).
ncbi_mult_taxo_gbnm(98028, bladderpods).
ncbi_mult_taxo_gbnm(98115, 'yellow flycatcher-warbler').
ncbi_mult_taxo_gbnm(98117, 'Southern fiscal').
ncbi_mult_taxo_gbnm(98144, 'white-throated Oxylabes').
ncbi_mult_taxo_gbnm(98146, 'puff-throated babbler').
ncbi_mult_taxo_gbnm(98310, 'Chinese razor clam').
ncbi_mult_taxo_gbnm(98314, 'long-tailed vole').
ncbi_mult_taxo_gbnm(98316, 'large-eared vole').
ncbi_mult_taxo_gbnm(98318, 'northern bog lemming').
ncbi_mult_taxo_gbnm(98334, 'Brazilian lancehead').
ncbi_mult_taxo_gbnm(98395, 'spined loach').
ncbi_mult_taxo_gbnm(98397, bitterling).
ncbi_mult_taxo_gbnm(98425, 'European earwig').
ncbi_mult_taxo_gbnm(98426, 'European earwig').
ncbi_mult_taxo_gbnm(98646, 'Albanian roach').
ncbi_mult_taxo_gbnm(98648, 'redtail sharkminnow').
ncbi_mult_taxo_gbnm(98658, 'Zaisan mole vole').
ncbi_mult_taxo_gbnm(98661, 'Pacific jumping mouse').
ncbi_mult_taxo_gbnm(98745, 'bristly locust').
ncbi_mult_taxo_gbnm(98810, 'Fijian fruit fly').
ncbi_mult_taxo_gbnm(98812, 'Canary dentex').
ncbi_mult_taxo_gbnm(98813, 'pink dentex').
ncbi_mult_taxo_gbnm(98814, 'large-eye dentex').
ncbi_mult_taxo_gbnm(98815, 'Morocco dentex').
ncbi_mult_taxo_gbnm(98816, 'bluespotted sunbreak').
ncbi_mult_taxo_gbnm(98817, 'axillary seabream').
ncbi_mult_taxo_gbnm(98819, 'blackspot seabream').
ncbi_mult_taxo_gbnm(98820, 'zebra seabream').
ncbi_mult_taxo_gbnm(98821, picarels).
ncbi_mult_taxo_gbnm(98823, 'blotched picarel').
ncbi_mult_taxo_gbnm(98825, 'saddled seabream').
ncbi_mult_taxo_gbnm(98921, 'panther puffer').
ncbi_mult_taxo_gbnm(98922, 'Daubenton\'s bat').
ncbi_mult_taxo_gbnm(98923, 'barfin flounder').
ncbi_mult_taxo_gbnm(98924, 'hillstream loaches').
ncbi_mult_taxo_gbnm(98952, 'willow fairy moth').
ncbi_mult_taxo_gbnm(98953, 'shield bearer moths').
ncbi_mult_taxo_gbnm(98958, 'leafcutter moths').
ncbi_mult_taxo_gbnm(98963, 'poplar petiolegall moth').
ncbi_mult_taxo_gbnm(98964, 'northern cardinal').
ncbi_mult_taxo_gbnm(98966, 'leaf blotch miner moths').
ncbi_mult_taxo_gbnm(98973, 'Gondwanaland moths').
ncbi_mult_taxo_gbnm(98982, 'white cap-eye moths').
ncbi_mult_taxo_gbnm(99070, 'autumn oxeye').
ncbi_mult_taxo_gbnm(99108, 'scentless false mayweed').
ncbi_mult_taxo_gbnm(99292, 'Japanese raisin tree').
ncbi_mult_taxo_gbnm(99341, 'Serra Spanish mackerel').
ncbi_mult_taxo_gbnm(99342, 'Monterey Spanish mackerel').
ncbi_mult_taxo_gbnm(99343, 'Indo-Pacific king mackerel').
ncbi_mult_taxo_gbnm(99344, 'Spanish mackerel').
ncbi_mult_taxo_gbnm(99345, cero).
ncbi_mult_taxo_gbnm(99346, 'Pacific sierra').
ncbi_mult_taxo_gbnm(99391, 'spiny spider crab').
ncbi_mult_taxo_gbnm(99490, 'African forest elephant').
ncbi_mult_taxo_gbnm(99539, 'Nayarit mouse').
ncbi_mult_taxo_gbnm(99570, 'cherry silverberry').
ncbi_mult_taxo_gbnm(99572, 'South African cape rock lobster').
ncbi_mult_taxo_gbnm(99577, 'burdock borer').
ncbi_mult_taxo_gbnm(99578, 'Far Eastern knotweed borer').
ncbi_mult_taxo_gbnm(99806, 'Japanese yew').
ncbi_mult_taxo_gbnm(99808, 'sawara cypress').
ncbi_mult_taxo_gbnm(99812, 'Montezuma bald cypress').
ncbi_mult_taxo_gbnm(99814, 'giant sequoia').
ncbi_mult_taxo_gbnm(99825, 'white-tailed prairie dog').
ncbi_mult_taxo_gbnm(99826, 'Mexican prairie dog').
ncbi_mult_taxo_gbnm(99827, 'Utah prairie dog').
ncbi_mult_taxo_gbnm(99829, 'tropical ground squirrel').
ncbi_mult_taxo_gbnm(99830, 'Alashan ground squirrel').
ncbi_mult_taxo_gbnm(99831, 'ring-tailed ground squirrel').
ncbi_mult_taxo_gbnm(99832, 'Uinta ground squirrel').
ncbi_mult_taxo_gbnm(99833, 'Baja California rock squirrel').
ncbi_mult_taxo_gbnm(99835, 'Belding\'s ground squirrel').
ncbi_mult_taxo_gbnm(99837, 'Daurian ground squirrel').
ncbi_mult_taxo_gbnm(99838, 'Wyoming ground squirrel').
ncbi_mult_taxo_gbnm(99840, 'red-cheeked ground squirrel').
ncbi_mult_taxo_gbnm(99841, 'yellow ground squirrel').
ncbi_mult_taxo_gbnm(99842, 'Sierra Madre ground squirrel').
ncbi_mult_taxo_gbnm(99843, 'russet ground squirrel').
ncbi_mult_taxo_gbnm(99844, 'Mexican ground squirrel').
ncbi_mult_taxo_gbnm(99847, 'Mohave ground squirrel').
ncbi_mult_taxo_gbnm(99848, 'Caucasian mountain ground squirrel').
ncbi_mult_taxo_gbnm(99854, 'Perote ground squirrel').
ncbi_mult_taxo_gbnm(99855, 'little ground squirrel').
ncbi_mult_taxo_gbnm(99856, 'Tien Shan ground squirrel').
ncbi_mult_taxo_gbnm(99858, 'Cascade golden-mantled ground squirrel').
ncbi_mult_taxo_gbnm(99859, 'speckled ground squirrel').
ncbi_mult_taxo_gbnm(99860, 'round-tailed ground squirrel').
ncbi_mult_taxo_gbnm(99861, 'Townsend\'s ground squirrel').
ncbi_mult_taxo_gbnm(99863, 'Piute ground squirrel').
ncbi_mult_taxo_gbnm(99867, 'long-tailed ground squirrel').
ncbi_mult_taxo_gbnm(99868, 'Washington ground squirrel').
ncbi_mult_taxo_gbnm(99869, 'Asia Minor ground squirrel').
ncbi_mult_taxo_gbnm(99871, 'long-clawed ground squirrel').
ncbi_mult_taxo_gbnm(99883, 'spotted green pufferfish').
ncbi_mult_taxo_gbnm(99884, 'eyespot pufferfish').
ncbi_mult_taxo_gbnm(99936, 'brown peach aphid').
ncbi_mult_taxo_gbnm(100124, redfins).
ncbi_mult_taxo_gbnm(100126, 'Berg River redfin').
ncbi_mult_taxo_gbnm(100181, 'Corsican hare').
ncbi_mult_taxo_gbnm(100182, 'Granada hare').
ncbi_mult_taxo_gbnm(100184, 'Ethiopian highland hare').
ncbi_mult_taxo_gbnm(100186, 'barred surfperch').
ncbi_mult_taxo_gbnm(100188, 'kelp perch').
ncbi_mult_taxo_gbnm(100190, 'black perch').
ncbi_mult_taxo_gbnm(100192, 'walleye surfperch').
ncbi_mult_taxo_gbnm(100194, 'rainbow seaperch').
ncbi_mult_taxo_gbnm(100196, 'Tule perch').
ncbi_mult_taxo_gbnm(100200, 'white seaperch').
ncbi_mult_taxo_gbnm(100202, 'rubberlip seaperch').
ncbi_mult_taxo_gbnm(100204, 'pink seaperch').
ncbi_mult_taxo_gbnm(100206, 'blackside hawkfish').
ncbi_mult_taxo_gbnm(100213, 'Florida softshell turtle').
ncbi_mult_taxo_gbnm(100224, 'L\'Hoest\'s monkey').
ncbi_mult_taxo_gbnm(100306, 'southeastern pocket gopher').
ncbi_mult_taxo_gbnm(100381, 'alpine field mouse').
ncbi_mult_taxo_gbnm(100382, 'broad-toothed field mouse').
ncbi_mult_taxo_gbnm(100385, 'southern Idaho ground squirrel').
ncbi_mult_taxo_gbnm(100475, 'white-footed sportive lemur').
ncbi_mult_taxo_gbnm(100479, 'oleander aphid').
ncbi_mult_taxo_gbnm(100487, 'lesser white-nosed monkey').
ncbi_mult_taxo_gbnm(100488, 'Gabon talapoin').
ncbi_mult_taxo_gbnm(100569, 'cluster fig').
ncbi_mult_taxo_gbnm(100579, 'common red-stem fig').
ncbi_mult_taxo_gbnm(100745, 'Chryxus arctic butterfly').
ncbi_mult_taxo_gbnm(100748, 'California arctic butterfly').
ncbi_mult_taxo_gbnm(100749, 'great arctic butterfly').
ncbi_mult_taxo_gbnm(100784, 'East African grey crowned-crane').
ncbi_mult_taxo_gbnm(100819, 'common kestrel').
ncbi_mult_taxo_gbnm(100821, 'southern bald ibis').
ncbi_mult_taxo_gbnm(100822, 'northern bald ibis').
ncbi_mult_taxo_gbnm(100823, 'European grass snake').
ncbi_mult_taxo_gbnm(100825, 'Eurasian green woodpecker').
ncbi_mult_taxo_gbnm(100828, 'little grebe').
ncbi_mult_taxo_gbnm(100830, 'western capercaillie').
ncbi_mult_taxo_gbnm(100858, 'Sacred ibis').
ncbi_mult_taxo_gbnm(100894, 'insular vole').
ncbi_mult_taxo_gbnm(100895, 'California vole').
ncbi_mult_taxo_gbnm(100896, 'gray-tailed vole').
ncbi_mult_taxo_gbnm(100897, 'reed vole').
ncbi_mult_taxo_gbnm(100900, 'Middendorf\'s vole').
ncbi_mult_taxo_gbnm(100907, 'Patagonian toothfish').
ncbi_mult_taxo_gbnm(100937, 'Guinea baboon').
ncbi_mult_taxo_gbnm(100945, 'Indochinese flying squirrel').
ncbi_mult_taxo_gbnm(100947, 'Temminck\'s flying squirrel').
ncbi_mult_taxo_gbnm(100949, 'hairy-footed flying squirrel').
ncbi_mult_taxo_gbnm(100952, bullhead).
ncbi_mult_taxo_gbnm(101163, 'shore pit viper').
ncbi_mult_taxo_gbnm(101185, 'leopard toadfish').
ncbi_mult_taxo_gbnm(101187, 'Lusitanian toadfish').
ncbi_mult_taxo_gbnm(101189, 'grunting toadfish').
ncbi_mult_taxo_gbnm(101190, 'scarecrow toadfish').
ncbi_mult_taxo_gbnm(101278, 'pygmy slow loris').
ncbi_mult_taxo_gbnm(101283, 'Say mud crab').
ncbi_mult_taxo_gbnm(101364, 'silver crucian carp').
ncbi_mult_taxo_gbnm(101490, 'smooth softshelled turtle').
ncbi_mult_taxo_gbnm(101491, 'African softshell turtle').
ncbi_mult_taxo_gbnm(101495, 'triangular notothen').
ncbi_mult_taxo_gbnm(101496, 'grey rockcod').
ncbi_mult_taxo_gbnm(101497, 'marbled rockcod').
ncbi_mult_taxo_gbnm(101504, 'Antarctic silverfish').
ncbi_mult_taxo_gbnm(101514, 'Campbell teal').
ncbi_mult_taxo_gbnm(101667, 'long-eared scaly-tailed flying squirrel').
ncbi_mult_taxo_gbnm(101669, 'Cameroon scaly-tail').
ncbi_mult_taxo_gbnm(101671, 'woodland jumping mouse').
ncbi_mult_taxo_gbnm(101673, 'Chinese jumping mouse').
ncbi_mult_taxo_gbnm(101676, 'Gaumer\'s spiny pocket mouse').
ncbi_mult_taxo_gbnm(101697, 'yellow-footed tortoise').
ncbi_mult_taxo_gbnm(101699, 'Horsfield\'s tortoise').
ncbi_mult_taxo_gbnm(101700, 'Egyptian tortoise').
ncbi_mult_taxo_gbnm(101766, 'Baikal sturgeon').
ncbi_mult_taxo_gbnm(101839, 'Tigris dace').
ncbi_mult_taxo_gbnm(101840, 'Dneiper chub').
ncbi_mult_taxo_gbnm(101849, 'crabeater seal').
ncbi_mult_taxo_gbnm(101864, 'Kura bleak').
ncbi_mult_taxo_gbnm(101876, 'Crimean barbel').
ncbi_mult_taxo_gbnm(101877, 'Terek nase').
ncbi_mult_taxo_gbnm(101899, 'Macedonian vimba').
ncbi_mult_taxo_gbnm(101904, 'Terek barbel').
ncbi_mult_taxo_gbnm(101915, 'Macedonian roach').
ncbi_mult_taxo_gbnm(101935, 'great spangled fritillary').
ncbi_mult_taxo_gbnm(101998, 'glandular plantain').
ncbi_mult_taxo_gbnm(102107, 'Japanese apricot').
ncbi_mult_taxo_gbnm(102108, 'crowned guenon').
ncbi_mult_taxo_gbnm(102173, 'Small-scaled wonder gecko').
ncbi_mult_taxo_gbnm(102175, 'Common wonder gecko').
ncbi_mult_taxo_gbnm(102178, 'Slow worm').
ncbi_mult_taxo_gbnm(102193, 'Hart\'s glass lizard').
ncbi_mult_taxo_gbnm(102194, 'Koelliker\'s glass lizard').
ncbi_mult_taxo_gbnm(102207, 'sword-tailed newt').
ncbi_mult_taxo_gbnm(102211, 'wax gourd').
ncbi_mult_taxo_gbnm(102233, 'Javan rhinoceros').
ncbi_mult_taxo_gbnm(102246, 'Taita Mountains caecilian').
ncbi_mult_taxo_gbnm(102287, 'barred tiger salamander').
ncbi_mult_taxo_gbnm(102397, 'sibling yoldia').
ncbi_mult_taxo_gbnm(102691, 'gum bully').
ncbi_mult_taxo_gbnm(102692, 'sugar hackberry').
ncbi_mult_taxo_gbnm(102693, 'slippery elm').
ncbi_mult_taxo_gbnm(102777, 'common boneset').
ncbi_mult_taxo_gbnm(102803, 'North American pine engraver').
ncbi_mult_taxo_gbnm(102876, 'curled octopus').
ncbi_mult_taxo_gbnm(102976, 'North Pacific krill').
ncbi_mult_taxo_gbnm(102981, 'beet leafhopper').
ncbi_mult_taxo_gbnm(103048, 'Swainson\'s warbler').
ncbi_mult_taxo_gbnm(103336, 'Red-headed rock agama').
ncbi_mult_taxo_gbnm(103337, 'Richard\'s worm snake').
ncbi_mult_taxo_gbnm(103349, muscadine).
ncbi_mult_taxo_gbnm(103352, 'sand grape').
ncbi_mult_taxo_gbnm(103355, 'fox grape').
ncbi_mult_taxo_gbnm(103372, 'Panamanian leafcutter ant').
ncbi_mult_taxo_gbnm(103373, 'Indus valley bullfrog').
ncbi_mult_taxo_gbnm(103375, 'boreal owl').
ncbi_mult_taxo_gbnm(103431, 'hidden-eared toad').
ncbi_mult_taxo_gbnm(103432, 'Danatea toad').
ncbi_mult_taxo_gbnm(103433, 'bony-headed toad').
ncbi_mult_taxo_gbnm(103434, 'Himalayan toad').
ncbi_mult_taxo_gbnm(103435, 'Mongolian toad').
ncbi_mult_taxo_gbnm(103437, 'Tibetan toad').
ncbi_mult_taxo_gbnm(103438, 'round-warted toad').
ncbi_mult_taxo_gbnm(103465, 'brown elfin').
ncbi_mult_taxo_gbnm(103467, 'Muir\'s hairstreak').
ncbi_mult_taxo_gbnm(103477, 'Amazon sailfin catfish').
ncbi_mult_taxo_gbnm(103479, 'bronze featherback').
ncbi_mult_taxo_gbnm(103480, 'Japanese chestnut').
ncbi_mult_taxo_gbnm(103582, 'Commerson\'s dolphin').
ncbi_mult_taxo_gbnm(103583, 'Heaviside\'s dolphin').
ncbi_mult_taxo_gbnm(103584, 'long-beaked common dolphin').
ncbi_mult_taxo_gbnm(103585, 'Arabian common dolphin').
ncbi_mult_taxo_gbnm(103588, 'northern right whale dolphin').
ncbi_mult_taxo_gbnm(103589, 'Clymene dolphin').
ncbi_mult_taxo_gbnm(103590, 'Atlantic spotted dolphin').
ncbi_mult_taxo_gbnm(103592, 'pygmy killer whale').
ncbi_mult_taxo_gbnm(103594, 'Fraser\'s dolphin').
ncbi_mult_taxo_gbnm(103596, 'melon-headed whale').
ncbi_mult_taxo_gbnm(103598, 'gray dolphin').
ncbi_mult_taxo_gbnm(103600, 'Indo-pacific humpbacked dolphin').
ncbi_mult_taxo_gbnm(103606, 'spineless stream toad').
ncbi_mult_taxo_gbnm(103630, 'Alpine grasshopper').
ncbi_mult_taxo_gbnm(103631, 'narrowwinged sand grasshopper').
ncbi_mult_taxo_gbnm(103633, 'two-striped grasshopper').
ncbi_mult_taxo_gbnm(103634, 'sagebrush grasshopper').
ncbi_mult_taxo_gbnm(103635, 'Bruner spur-throated grasshopper').
ncbi_mult_taxo_gbnm(103637, 'pasture grasshopper').
ncbi_mult_taxo_gbnm(103638, 'Dawson grasshopper').
ncbi_mult_taxo_gbnm(103639, 'devastating grasshopper').
ncbi_mult_taxo_gbnm(103640, 'red-legged grasshopper').
ncbi_mult_taxo_gbnm(103644, 'Gladston grasshopper').
ncbi_mult_taxo_gbnm(103645, 'little spur-throated grasshopper').
ncbi_mult_taxo_gbnm(103646, 'Keeler grasshopper').
ncbi_mult_taxo_gbnm(103650, 'flabellate grasshopper').
ncbi_mult_taxo_gbnm(103651, 'Packard grasshopper').
ncbi_mult_taxo_gbnm(103693, 'toad-headed agama').
ncbi_mult_taxo_gbnm(103694, 'Eastern water dragon').
ncbi_mult_taxo_gbnm(103695, 'central bearded dragon').
ncbi_mult_taxo_gbnm(103696, hardun).
ncbi_mult_taxo_gbnm(103699, 'frilled dragon').
ncbi_mult_taxo_gbnm(103701, 'Giant forest dragon').
ncbi_mult_taxo_gbnm(103705, 'Swamplands lashtail').
ncbi_mult_taxo_gbnm(103715, 'spotted seahorse').
ncbi_mult_taxo_gbnm(103717, 'crowned seahorse').
ncbi_mult_taxo_gbnm(103720, 'seaweed pipefish').
ncbi_mult_taxo_gbnm(103766, 'saffron spike').
ncbi_mult_taxo_gbnm(103775, 'fruit fly').
ncbi_mult_taxo_gbnm(103813, 'Indian mottled eel').
ncbi_mult_taxo_gbnm(103820, gag).
ncbi_mult_taxo_gbnm(103826, eyeworms).
ncbi_mult_taxo_gbnm(103827, 'thelaziosis nematode').
ncbi_mult_taxo_gbnm(103832, 'African mottled eel').
ncbi_mult_taxo_gbnm(103864, 'Roque Chico de Salmor giant lizard').
ncbi_mult_taxo_gbnm(103890, 'white-lined sphinx').
ncbi_mult_taxo_gbnm(103939, 'Strauch\'s pitviper').
ncbi_mult_taxo_gbnm(103940, 'Likiang pitviper').
ncbi_mult_taxo_gbnm(103944, 'brown spotted pit viper').
ncbi_mult_taxo_gbnm(103954, 'great blue turaco').
ncbi_mult_taxo_gbnm(103956, 'grey go-away-bird').
ncbi_mult_taxo_gbnm(103959, 'violet turaco').
ncbi_mult_taxo_gbnm(104114, 'Sumatran rabbit').
ncbi_mult_taxo_gbnm(104298, 'giant kangaroo rat').
ncbi_mult_taxo_gbnm(104421, 'Florida carpenter ant').
ncbi_mult_taxo_gbnm(104425, 'hook-tip moths').
ncbi_mult_taxo_gbnm(104452, 'winter moth').
ncbi_mult_taxo_gbnm(104453, 'northern winter moth').
ncbi_mult_taxo_gbnm(104482, 'Leyte wart frog').
ncbi_mult_taxo_gbnm(104490, 'bordered white moth').
ncbi_mult_taxo_gbnm(104494, 'teak moths').
ncbi_mult_taxo_gbnm(104496, 'European gold moths').
ncbi_mult_taxo_gbnm(104501, 'checkerspot butterflies').
ncbi_mult_taxo_gbnm(104515, 'spotted fritillary').
ncbi_mult_taxo_gbnm(104660, 'silver-lipped pearl oyster').
ncbi_mult_taxo_gbnm(104688, 'olive fruit fly').
ncbi_mult_taxo_gbnm(104690, 'Chinese citrus fly').
ncbi_mult_taxo_gbnm(104691, 'Japanese orange fly').
ncbi_mult_taxo_gbnm(104895, 'desert tree frog').
ncbi_mult_taxo_gbnm(104896, 'whistling tree frog').
ncbi_mult_taxo_gbnm(104953, 'flood plain toadlet').
ncbi_mult_taxo_gbnm(104954, 'Mjoberg\'s toadlet').
ncbi_mult_taxo_gbnm(105012, 'red barred killifish').
ncbi_mult_taxo_gbnm(105023, 'turquoise killifish').
ncbi_mult_taxo_gbnm(105147, 'bushy-tailed woodrat').
ncbi_mult_taxo_gbnm(105148, 'Goldman\'s woodrat').
ncbi_mult_taxo_gbnm(105149, 'Mexican woodrat').
ncbi_mult_taxo_gbnm(105150, 'Southern Plains woodrat').
ncbi_mult_taxo_gbnm(105181, 'green cardamom').
ncbi_mult_taxo_gbnm(105184, 'electric treefrog').
ncbi_mult_taxo_gbnm(105199, 'dusky-footed woodrat').
ncbi_mult_taxo_gbnm(105255, 'banner-tailed kangaroo rat').
ncbi_mult_taxo_gbnm(105256, 'Florida sand darter').
ncbi_mult_taxo_gbnm(105257, 'southern sand darter').
ncbi_mult_taxo_gbnm(105258, 'eastern sand darter').
ncbi_mult_taxo_gbnm(105259, 'scaly sand darter').
ncbi_mult_taxo_gbnm(105268, 'beauty bush').
ncbi_mult_taxo_gbnm(105273, 'Asian particolored bat').
ncbi_mult_taxo_gbnm(105296, 'large Japanese field mouse').
ncbi_mult_taxo_gbnm(105297, 'Korean field mouse').
ncbi_mult_taxo_gbnm(105298, 'Himalayan field mouse').
ncbi_mult_taxo_gbnm(105299, 'Taiwan field mouse').
ncbi_mult_taxo_gbnm(105361, 'rock boring urchin').
ncbi_mult_taxo_gbnm(105388, 'red sunflower').
ncbi_mult_taxo_gbnm(105427, 'Muller\'s clawed frog').
ncbi_mult_taxo_gbnm(105428, 'volcano clawed frog').
ncbi_mult_taxo_gbnm(105429, 'Kivu clawed frog').
ncbi_mult_taxo_gbnm(105430, 'Uganda clawed frog').
ncbi_mult_taxo_gbnm(105513, 'Baltimore oriole').
ncbi_mult_taxo_gbnm(105515, 'Altamira oriole').
ncbi_mult_taxo_gbnm(105516, 'campo troupial').
ncbi_mult_taxo_gbnm(105519, 'montserrat oriole').
ncbi_mult_taxo_gbnm(105520, 'Spot-breasted oriole').
ncbi_mult_taxo_gbnm(105594, 'mexican water lily').
ncbi_mult_taxo_gbnm(105596, 'black-backed oriole').
ncbi_mult_taxo_gbnm(105665, 'dwarf flowering almond').
ncbi_mult_taxo_gbnm(105667, 'Nanking cherry').
ncbi_mult_taxo_gbnm(105689, 'Nimba otter shrew').
ncbi_mult_taxo_gbnm(105691, 'trapdoor spiders').
ncbi_mult_taxo_gbnm(105716, 'copper skink').
ncbi_mult_taxo_gbnm(105726, 'Gray\'s ornate skink').
ncbi_mult_taxo_gbnm(105774, 'Australian dampwood termite').
ncbi_mult_taxo_gbnm(105885, coralberry).
ncbi_mult_taxo_gbnm(105898, 'primrose jasmine').
ncbi_mult_taxo_gbnm(106044, kanuka).
ncbi_mult_taxo_gbnm(106106, 'Japanese shrew mole').
ncbi_mult_taxo_gbnm(106110, 'Lindbergh\'s grass mouse').
ncbi_mult_taxo_gbnm(106114, 'Serrado Mar grass mouse').
ncbi_mult_taxo_gbnm(106174, 'Senegalese tonguesole').
ncbi_mult_taxo_gbnm(106175, 'lemon sole').
ncbi_mult_taxo_gbnm(106208, 'Senegal needlefish').
ncbi_mult_taxo_gbnm(106209, timucu).
ncbi_mult_taxo_gbnm(106276, 'noble scallop').
ncbi_mult_taxo_gbnm(106331, 'Marmoset lymphocryptovirus').
ncbi_mult_taxo_gbnm(106343, 'Congo forest mouse').
ncbi_mult_taxo_gbnm(106345, 'chestnut climbing mouse').
ncbi_mult_taxo_gbnm(106492, 'redbanded leafroller').
ncbi_mult_taxo_gbnm(106494, 'European fir budworm').
ncbi_mult_taxo_gbnm(106496, 'clear-winged moths').
ncbi_mult_taxo_gbnm(106501, 'peach tree borer').
ncbi_mult_taxo_gbnm(106546, 'common flowering quince').
ncbi_mult_taxo_gbnm(106582, 'zebra mbuna').
ncbi_mult_taxo_gbnm(106584, 'Malawi eyebiter').
ncbi_mult_taxo_gbnm(106585, 'goldbanded jobfish').
ncbi_mult_taxo_gbnm(106598, 'speckled forest pit viper').
ncbi_mult_taxo_gbnm(106636, 'kangaroo grass').
ncbi_mult_taxo_gbnm(106677, 'alder buckthorn').
ncbi_mult_taxo_gbnm(106726, 'James Island giant tortoise').
ncbi_mult_taxo_gbnm(106727, 'Wolf Volcano giant tortoise').
ncbi_mult_taxo_gbnm(106731, 'Cerro Azul giant tortoise').
ncbi_mult_taxo_gbnm(106732, 'Indefatigable Island giant tortoise').
ncbi_mult_taxo_gbnm(106733, 'Hood Island giant tortoise').
ncbi_mult_taxo_gbnm(106734, 'Abingdon island giant tortoise').
ncbi_mult_taxo_gbnm(106735, 'Chatham Island giant tortoise').
ncbi_mult_taxo_gbnm(106881, 'Menado coelacanth').
ncbi_mult_taxo_gbnm(106894, 'Madeira wall lizard').
ncbi_mult_taxo_gbnm(106988, 'puriri moth').
ncbi_mult_taxo_gbnm(107021, 'Emperor goose').
ncbi_mult_taxo_gbnm(107022, 'common goldeneye').
ncbi_mult_taxo_gbnm(107026, 'Smew').
ncbi_mult_taxo_gbnm(107205, 'greater racket-tailed drongo').
ncbi_mult_taxo_gbnm(107210, 'black-naped monarch').
ncbi_mult_taxo_gbnm(107216, 'grape colaspis').
ncbi_mult_taxo_gbnm(107219, 'tortoise beetles').
ncbi_mult_taxo_gbnm(107224, 'Melanesian flycatcher').
ncbi_mult_taxo_gbnm(107226, 'brown-throated wattle-eye').
ncbi_mult_taxo_gbnm(107232, 'blue-headed fantail').
ncbi_mult_taxo_gbnm(107234, 'dusky crested-flycatcher').
ncbi_mult_taxo_gbnm(107240, 'licorice weed').
ncbi_mult_taxo_gbnm(107241, alfonsino).
ncbi_mult_taxo_gbnm(107245, 'silver scabbardfish').
ncbi_mult_taxo_gbnm(107258, 'king crab').
ncbi_mult_taxo_gbnm(107265, 'giant rat').
ncbi_mult_taxo_gbnm(107266, 'bastard big-footed mouse').
ncbi_mult_taxo_gbnm(107268, 'tiny fat mouse').
ncbi_mult_taxo_gbnm(107270, 'white-tailed rat').
ncbi_mult_taxo_gbnm(107272, 'Betsileo short-tailed rat').
ncbi_mult_taxo_gbnm(107276, voalavoanala).
ncbi_mult_taxo_gbnm(107279, 'pygmy rock mouse').
ncbi_mult_taxo_gbnm(107281, 'Gregarious short-tailed rat').
ncbi_mult_taxo_gbnm(107283, 'Major\'s tufted-tailed rat').
ncbi_mult_taxo_gbnm(107284, 'lesser tufted-tailed rat').
ncbi_mult_taxo_gbnm(107285, 'dormouse tufted-tailed rat').
ncbi_mult_taxo_gbnm(107286, 'Tanala tufted-tailed rat').
ncbi_mult_taxo_gbnm(107287, 'Webb\'s tufted-tailed rat').
ncbi_mult_taxo_gbnm(107322, peled).
ncbi_mult_taxo_gbnm(107377, 'common snipe').
ncbi_mult_taxo_gbnm(107604, 'jewels-of-Opar').
ncbi_mult_taxo_gbnm(107766, 'blackmouth bass').
ncbi_mult_taxo_gbnm(107773, 'trout-stream beetles').
ncbi_mult_taxo_gbnm(107778, 'whirligig beetles').
ncbi_mult_taxo_gbnm(107808, 'clubtail dragonflies').
ncbi_mult_taxo_gbnm(107810, 'grayback dragonflies').
ncbi_mult_taxo_gbnm(107811, biddies).
ncbi_mult_taxo_gbnm(107812, 'belted and river skimmers').
ncbi_mult_taxo_gbnm(107851, 'crawling water beetles').
ncbi_mult_taxo_gbnm(107878, 'diving beetles').
ncbi_mult_taxo_gbnm(107947, 'chain catshark').
ncbi_mult_taxo_gbnm(107963, 'hidden salamanders').
ncbi_mult_taxo_gbnm(107964, 'Cortes salamander').
ncbi_mult_taxo_gbnm(107966, 'Guatemalan bromeliad salamander').
ncbi_mult_taxo_gbnm(107969, 'tropical worm salamanders').
ncbi_mult_taxo_gbnm(107973, 'Alvarez del Toro\'s salamander').
ncbi_mult_taxo_gbnm(107974, 'Baja Verapaz salamander').
ncbi_mult_taxo_gbnm(107977, 'Monteverde moss salamander').
ncbi_mult_taxo_gbnm(107989, 'maritime worm salamander').
ncbi_mult_taxo_gbnm(107992, 'quarry worm salamander').
ncbi_mult_taxo_gbnm(107994, 'Savage\'s worm salamander').
ncbi_mult_taxo_gbnm(107998, 'narrow-footed worm salamander').
ncbi_mult_taxo_gbnm(107999, 'Sierra de las Minas hidden salamander').
ncbi_mult_taxo_gbnm(108083, 'San Gabriel Mountains slender salamander').
ncbi_mult_taxo_gbnm(108096, 'Irish pollan').
ncbi_mult_taxo_gbnm(108101, 'oystershell mud crab').
ncbi_mult_taxo_gbnm(108102, 'saltmarch mud crab').
ncbi_mult_taxo_gbnm(108103, 'knotfinger mud crab').
ncbi_mult_taxo_gbnm(108104, 'furrowed mud crab').
ncbi_mult_taxo_gbnm(108105, 'narrowback mud crab').
ncbi_mult_taxo_gbnm(108109, 'lobate mud crab').
ncbi_mult_taxo_gbnm(108111, 'flatback mud crab').
ncbi_mult_taxo_gbnm(108112, 'asymmetric mud crab').
ncbi_mult_taxo_gbnm(108115, 'smooth mud crab').
ncbi_mult_taxo_gbnm(108116, 'knobbed mud crab').
ncbi_mult_taxo_gbnm(108118, 'Florida grassflat crab').
ncbi_mult_taxo_gbnm(108119, 'Gulf grassflat crab').
ncbi_mult_taxo_gbnm(108121, 'broadback mud crab').
ncbi_mult_taxo_gbnm(108124, 'spoonfinger rubble crab').
ncbi_mult_taxo_gbnm(108144, 'Texas kangaroo rat').
ncbi_mult_taxo_gbnm(108145, 'Nelson\'s kangaroo rat').
ncbi_mult_taxo_gbnm(108146, 'Phillips\'s kangaroo rat').
ncbi_mult_taxo_gbnm(108149, 'dark kangaroo mouse').
ncbi_mult_taxo_gbnm(108405, 'Common tern').
ncbi_mult_taxo_gbnm(108411, 'Panama-hat palm').
ncbi_mult_taxo_gbnm(108524, 'Alpine scree weta').
ncbi_mult_taxo_gbnm(108582, 'desert pocket gopher').
ncbi_mult_taxo_gbnm(108586, 'tropical pocket gopher').
ncbi_mult_taxo_gbnm(108594, 'Chinese trumpet vine').
ncbi_mult_taxo_gbnm(108821, 'yellow-rumped thornbill').
ncbi_mult_taxo_gbnm(108826, 'Australian raven').
ncbi_mult_taxo_gbnm(108828, 'yellow-breasted bird-of-paradise').
ncbi_mult_taxo_gbnm(108844, 'Noisy friarbird').
ncbi_mult_taxo_gbnm(108846, 'trumpet manucode').
ncbi_mult_taxo_gbnm(108847, 'white-browed scrubwren').
ncbi_mult_taxo_gbnm(108848, 'Maule tuco-tuco').
ncbi_mult_taxo_gbnm(108849, 'Para spiny rat').
ncbi_mult_taxo_gbnm(108852, 'Lowland paca').
ncbi_mult_taxo_gbnm(108855, 'Bennett\'s chinchilla rat').
ncbi_mult_taxo_gbnm(108858, pacarana).
ncbi_mult_taxo_gbnm(108931, 'brown planthopper').
ncbi_mult_taxo_gbnm(109039, 'caucasian grouse').
ncbi_mult_taxo_gbnm(109042, 'lesser prairie-chicken').
ncbi_mult_taxo_gbnm(109044, 'Himalayan snowcock').
ncbi_mult_taxo_gbnm(109047, 'ChRV1').
ncbi_mult_taxo_gbnm(109048, 'ChRV2').
ncbi_mult_taxo_gbnm(109171, jicama).
ncbi_mult_taxo_gbnm(109175, 'Japanese treefrog').
ncbi_mult_taxo_gbnm(109178, 'gold-spotted pond frog').
ncbi_mult_taxo_gbnm(109210, inkberry).
ncbi_mult_taxo_gbnm(109271, 'silver arawana').
ncbi_mult_taxo_gbnm(109274, 'big-belly seahorse').
ncbi_mult_taxo_gbnm(109275, 'West African seahorse').
ncbi_mult_taxo_gbnm(109276, 'Barbour\'s seahorse').
ncbi_mult_taxo_gbnm(109277, 'short-head seahorse').
ncbi_mult_taxo_gbnm(109278, 'giraffe seahorse').
ncbi_mult_taxo_gbnm(109279, 'Knysna seahorse').
ncbi_mult_taxo_gbnm(109280, 'tiger tail seahorse').
ncbi_mult_taxo_gbnm(109281, 'lined seahorse').
ncbi_mult_taxo_gbnm(109282, 'long-snouted seahorse').
ncbi_mult_taxo_gbnm(109283, 'short-snouted seahorse').
ncbi_mult_taxo_gbnm(109284, 'thorny seahorse').
ncbi_mult_taxo_gbnm(109286, 'great seahorse').
ncbi_mult_taxo_gbnm(109287, 'Japanese seahorse').
ncbi_mult_taxo_gbnm(109288, 'slender seahorse').
ncbi_mult_taxo_gbnm(109289, 'hedgehog seahorse').
ncbi_mult_taxo_gbnm(109290, 'West Australian seahorse').
ncbi_mult_taxo_gbnm(109291, 'longnose seahorse').
ncbi_mult_taxo_gbnm(109292, 'White\'s seahorse').
ncbi_mult_taxo_gbnm(109293, 'dwarf seahorse').
ncbi_mult_taxo_gbnm(109294, 'Leaf deer').
ncbi_mult_taxo_gbnm(109295, 'Roosevelt muntjac').
ncbi_mult_taxo_gbnm(109296, 'giant muntjac').
ncbi_mult_taxo_gbnm(109298, 'tufted deer').
ncbi_mult_taxo_gbnm(109363, 'pigeonpea mite').
ncbi_mult_taxo_gbnm(109365, 'peach mite').
ncbi_mult_taxo_gbnm(109366, 'dry bulb mite').
ncbi_mult_taxo_gbnm(109367, 'pongamia mite').
ncbi_mult_taxo_gbnm(109390, 'saffron-cowled blackbird').
ncbi_mult_taxo_gbnm(109435, 'Robert\'s tree iguana').
ncbi_mult_taxo_gbnm(109446, 'pinyon jay').
ncbi_mult_taxo_gbnm(109448, 'Tropical wren').
ncbi_mult_taxo_gbnm(109449, 'ochraceous wren').
ncbi_mult_taxo_gbnm(109450, 'rufous-browed wren').
ncbi_mult_taxo_gbnm(109461, 'honeybee mite').
ncbi_mult_taxo_gbnm(109473, 'Mediterranean mole').
ncbi_mult_taxo_gbnm(109474, 'bicolored shrew').
ncbi_mult_taxo_gbnm(109475, 'white-toothed pygmy shrew').
ncbi_mult_taxo_gbnm(109476, 'Mediterranean horseshoe bat').
ncbi_mult_taxo_gbnm(109477, 'long-fingered bat').
ncbi_mult_taxo_gbnm(109478, 'Brandt\'s bat').
ncbi_mult_taxo_gbnm(109479, 'whiskered bat').
ncbi_mult_taxo_gbnm(109480, 'Geoffroy\'s bat').
ncbi_mult_taxo_gbnm(109481, 'Natterer\'s bat').
ncbi_mult_taxo_gbnm(109482, 'lesser mouse-eared bat').
ncbi_mult_taxo_gbnm(109483, 'gray big-eared bat').
ncbi_mult_taxo_gbnm(109485, 'Savi\'s pipistrelle').
ncbi_mult_taxo_gbnm(109589, 'Brazilian larval click-beetle').
ncbi_mult_taxo_gbnm(109666, 'Chinese minnow').
ncbi_mult_taxo_gbnm(109672, 'black-billed capercaillie').
ncbi_mult_taxo_gbnm(109674, 'siberian grouse').
ncbi_mult_taxo_gbnm(109676, 'Kazbeg birch mouse').
ncbi_mult_taxo_gbnm(109677, 'Afghan mouse-like hamster').
ncbi_mult_taxo_gbnm(109678, 'desert hamster').
ncbi_mult_taxo_gbnm(109681, 'Angoni vlei rat').
ncbi_mult_taxo_gbnm(109682, 'longsnout butterflyfish').
ncbi_mult_taxo_gbnm(109683, 'golden butterflyfish').
ncbi_mult_taxo_gbnm(109684, 'blacktail butterflyfish').
ncbi_mult_taxo_gbnm(109685, 'eastern triangular butterflyfish').
ncbi_mult_taxo_gbnm(109686, 'speckled butterflyfish').
ncbi_mult_taxo_gbnm(109687, 'redtail butterflyfish').
ncbi_mult_taxo_gbnm(109688, 'Indian vagabond butterflyfish').
ncbi_mult_taxo_gbnm(109689, 'saddle butterflyfish').
ncbi_mult_taxo_gbnm(109690, 'black butterflyfish').
ncbi_mult_taxo_gbnm(109691, 'sunburst butterflyfish').
ncbi_mult_taxo_gbnm(109692, 'hooded butterflyfish').
ncbi_mult_taxo_gbnm(109693, 'lined butterflyfish').
ncbi_mult_taxo_gbnm(109694, 'raccoon butterflyfish').
ncbi_mult_taxo_gbnm(109695, 'blackback butterflyfish').
ncbi_mult_taxo_gbnm(109696, 'white-face butterflyfish').
ncbi_mult_taxo_gbnm(109697, 'scrawled butterflyfish').
ncbi_mult_taxo_gbnm(109698, 'spot-tail butterflyfish').
ncbi_mult_taxo_gbnm(109699, 'eightband butterflyfish').
ncbi_mult_taxo_gbnm(109700, 'ornate butterflyfish').
ncbi_mult_taxo_gbnm(109701, 'spot-nape butterflyfish').
ncbi_mult_taxo_gbnm(109702, 'blueblotch butterflyfish').
ncbi_mult_taxo_gbnm(109703, 'latticed butterflyfish').
ncbi_mult_taxo_gbnm(109704, 'Rainford\'s butterflyfish').
ncbi_mult_taxo_gbnm(109705, 'mirror butterflyfish').
ncbi_mult_taxo_gbnm(109706, 'chevron butterflyfish').
ncbi_mult_taxo_gbnm(109707, 'melon butterflyfish').
ncbi_mult_taxo_gbnm(109708, 'Pacific double-saddle butterflyfish').
ncbi_mult_taxo_gbnm(109709, 'vagabond butterflyfish').
ncbi_mult_taxo_gbnm(109710, 'bluering angelfish').
ncbi_mult_taxo_gbnm(109711, 'emperor angelfish').
ncbi_mult_taxo_gbnm(109712, 'bluegirdled angelfish').
ncbi_mult_taxo_gbnm(109713, 'semicircle angelfish').
ncbi_mult_taxo_gbnm(109714, 'sixbar angelfish').
ncbi_mult_taxo_gbnm(109715, 'yellowface angelfish').
ncbi_mult_taxo_gbnm(109717, 'threespot angelfish').
ncbi_mult_taxo_gbnm(109721, 'bluespotted angelfish').
ncbi_mult_taxo_gbnm(109722, 'yellowtail angelfish').
ncbi_mult_taxo_gbnm(109723, 'bicolor angelfish').
ncbi_mult_taxo_gbnm(109725, 'blacktail angelfish').
ncbi_mult_taxo_gbnm(109727, 'whitetail angelfish').
ncbi_mult_taxo_gbnm(109731, 'dusky angelfish').
ncbi_mult_taxo_gbnm(109732, 'midnight angelfish').
ncbi_mult_taxo_gbnm(109733, 'russet angelfish').
ncbi_mult_taxo_gbnm(109734, 'keyhole angelfish').
ncbi_mult_taxo_gbnm(109736, 'pearlscale angelfish').
ncbi_mult_taxo_gbnm(109737, 'scribbled angelfish').
ncbi_mult_taxo_gbnm(109738, 'black-velvet angelfish').
ncbi_mult_taxo_gbnm(109780, 'Philippine pitviper').
ncbi_mult_taxo_gbnm(109782, 'Indonesian pit viper').
ncbi_mult_taxo_gbnm(109783, 'Kanburi pit viper').
ncbi_mult_taxo_gbnm(109786, 'Pope\'s bamboo pit viper').
ncbi_mult_taxo_gbnm(109905, 'copperband butterflyfish').
ncbi_mult_taxo_gbnm(109907, 'highfin coralfish').
ncbi_mult_taxo_gbnm(109912, 'blackstriped angelfish').
ncbi_mult_taxo_gbnm(109917, 'pennant coralfish').
ncbi_mult_taxo_gbnm(109920, 'sixspine butterflyfish').
ncbi_mult_taxo_gbnm(109922, 'goldengirdled coralfish').
ncbi_mult_taxo_gbnm(109923, 'spotbreast angelfish').
ncbi_mult_taxo_gbnm(109924, 'brown-and-white butterflyfish').
ncbi_mult_taxo_gbnm(109925, 'threeband pennantfish').
ncbi_mult_taxo_gbnm(109926, 'phantom bannerfish').
ncbi_mult_taxo_gbnm(109927, 'horned bannerfish').
ncbi_mult_taxo_gbnm(109940, 'cascade frogs').
ncbi_mult_taxo_gbnm(109946, 'Hong Kong sucker frog').
ncbi_mult_taxo_gbnm(109960, 'long-snout torrent frog').
ncbi_mult_taxo_gbnm(109962, 'giant mountain frog').
ncbi_mult_taxo_gbnm(109965, 'Chinese spiny frog').
ncbi_mult_taxo_gbnm(109979, 'Gloyds moccasin').
ncbi_mult_taxo_gbnm(109996, 'wild radish').
ncbi_mult_taxo_gbnm(110010, 'marsh beetles').
ncbi_mult_taxo_gbnm(110015, 'fungus weevils').
ncbi_mult_taxo_gbnm(110033, 'minute bog beetles').
ncbi_mult_taxo_gbnm(110041, 'false clown beetles').
ncbi_mult_taxo_gbnm(110043, 'clown beetles').
ncbi_mult_taxo_gbnm(110052, 'earth-boring dung beetles').
ncbi_mult_taxo_gbnm(110072, 'rugose frog').
ncbi_mult_taxo_gbnm(110076, 'Chapa torrent frog').
ncbi_mult_taxo_gbnm(110077, 'green paddy frog').
ncbi_mult_taxo_gbnm(110094, 'Toumanoff\'s wart frog').
ncbi_mult_taxo_gbnm(110102, 'Yunan spiny frog').
ncbi_mult_taxo_gbnm(110104, 'Chinese sucker frog').
ncbi_mult_taxo_gbnm(110106, 'Dahaoping sucker frog').
ncbi_mult_taxo_gbnm(110107, 'Kuhl\'s wart frog').
ncbi_mult_taxo_gbnm(110108, 'Boie\'s wart frog').
ncbi_mult_taxo_gbnm(110110, 'John\'s groove-toed frog').
ncbi_mult_taxo_gbnm(110111, 'Kokarit frog').
ncbi_mult_taxo_gbnm(110113, 'Mo-Son frog').
ncbi_mult_taxo_gbnm(110116, 'piebald odorous frog').
ncbi_mult_taxo_gbnm(110118, 'Taipei frog').
ncbi_mult_taxo_gbnm(110204, 'Moorish viper').
ncbi_mult_taxo_gbnm(110207, 'coastal viper').
ncbi_mult_taxo_gbnm(110212, 'Caucasus viper').
ncbi_mult_taxo_gbnm(110225, 'African bush viper').
ncbi_mult_taxo_gbnm(110227, 'leaf-nosed viper').
ncbi_mult_taxo_gbnm(110272, 'barred angelfish').
ncbi_mult_taxo_gbnm(110309, 'California bulrush').
ncbi_mult_taxo_gbnm(110367, 'bush browns').
ncbi_mult_taxo_gbnm(110368, 'squinting bush brown').
ncbi_mult_taxo_gbnm(110620, 'great egret').
ncbi_mult_taxo_gbnm(110660, 'brown bitterns').
ncbi_mult_taxo_gbnm(110661, 'american bittern').
ncbi_mult_taxo_gbnm(110667, 'cattle egrets').
ncbi_mult_taxo_gbnm(110668, 'cattle egret').
ncbi_mult_taxo_gbnm(110670, 'green-backed herons').
ncbi_mult_taxo_gbnm(110671, 'green heron').
ncbi_mult_taxo_gbnm(110676, 'boat-billed heron').
ncbi_mult_taxo_gbnm(110681, 'snowy egret').
ncbi_mult_taxo_gbnm(110682, 'Little blue heron').
ncbi_mult_taxo_gbnm(110683, 'tricolored heron').
ncbi_mult_taxo_gbnm(110684, 'least bitterns').
ncbi_mult_taxo_gbnm(110685, 'least bittern').
ncbi_mult_taxo_gbnm(110791, 'scarce swallowtail').
ncbi_mult_taxo_gbnm(110793, 'yellow gorgon').
ncbi_mult_taxo_gbnm(110795, 'dingy swallowtail').
ncbi_mult_taxo_gbnm(110796, 'common mime swallowtail').
ncbi_mult_taxo_gbnm(110799, apollo).
ncbi_mult_taxo_gbnm(110915, canvasback).
ncbi_mult_taxo_gbnm(110926, 'tundra swan').
ncbi_mult_taxo_gbnm(110931, 'Philippine flying lemur').
ncbi_mult_taxo_gbnm(110938, 'Cape serotine').
ncbi_mult_taxo_gbnm(110941, 'Commerson\'s roundleaf bat').
ncbi_mult_taxo_gbnm(110942, 'Solomons flying fox').
ncbi_mult_taxo_gbnm(111063, 'dainty frogs').
ncbi_mult_taxo_gbnm(111064, 'Boettger\'s dainty frog').
ncbi_mult_taxo_gbnm(111065, 'spotted rocket frog').
ncbi_mult_taxo_gbnm(111067, 'long-clawed hermit crab').
ncbi_mult_taxo_gbnm(111069, 'Sambava tomato frog').
ncbi_mult_taxo_gbnm(111092, 'African water frogs').
ncbi_mult_taxo_gbnm(111093, 'Parker\'s water frog').
ncbi_mult_taxo_gbnm(111120, 'Apouh night frog').
ncbi_mult_taxo_gbnm(111121, 'long-fingered frogs').
ncbi_mult_taxo_gbnm(111122, 'silver long-fingered frog').
ncbi_mult_taxo_gbnm(111123, 'three-striped rocket frog').
ncbi_mult_taxo_gbnm(111124, 'yellowbelly poison frog').
ncbi_mult_taxo_gbnm(111125, 'mimic poison frog').
ncbi_mult_taxo_gbnm(111128, 'ruby poison frog').
ncbi_mult_taxo_gbnm(111129, 'Silverstone\'s poison frog').
ncbi_mult_taxo_gbnm(111130, 'moustached frog').
ncbi_mult_taxo_gbnm(111170, 'two-striped Mabuya').
ncbi_mult_taxo_gbnm(111173, 'Somali galago').
ncbi_mult_taxo_gbnm(111179, 'Red-sided skink').
ncbi_mult_taxo_gbnm(111180, 'Alpine meadow mabuya').
ncbi_mult_taxo_gbnm(111183, 'Kalahari tree skink').
ncbi_mult_taxo_gbnm(111238, 'rice hispa').
ncbi_mult_taxo_gbnm(111290, 'Madagascar golden frog').
ncbi_mult_taxo_gbnm(111304, 'Amur sturgeon').
ncbi_mult_taxo_gbnm(111367, 'crab-eating frog').
ncbi_mult_taxo_gbnm(111428, 'large mole').
ncbi_mult_taxo_gbnm(111452, 'Daurian hedgehog').
ncbi_mult_taxo_gbnm(111506, 'Bedriaga\'s fringe-fingered lizard').
ncbi_mult_taxo_gbnm(111507, 'Bosk\'s fringe-fingered lizard').
ncbi_mult_taxo_gbnm(111514, 'Masira fringe-fingered lizard').
ncbi_mult_taxo_gbnm(111515, 'Arnold\'s fringe-fingered lizard').
ncbi_mult_taxo_gbnm(111518, 'Blanford\'s fringe-fingered lizard').
ncbi_mult_taxo_gbnm(111524, 'gamba prawns').
ncbi_mult_taxo_gbnm(111525, 'benthesicymid shrimps').
ncbi_mult_taxo_gbnm(111540, 'California sycamore').
ncbi_mult_taxo_gbnm(111784, 'Greenland flounder').
ncbi_mult_taxo_gbnm(111810, 'long-eared owl').
ncbi_mult_taxo_gbnm(111811, 'Eurasian nightjar').
ncbi_mult_taxo_gbnm(111812, 'mountain pygmy-owl').
ncbi_mult_taxo_gbnm(111814, 'crested owl').
ncbi_mult_taxo_gbnm(111815, 'Flammulated owl').
ncbi_mult_taxo_gbnm(111816, 'western screech-owl').
ncbi_mult_taxo_gbnm(111818, 'oriental bay-owl').
ncbi_mult_taxo_gbnm(111820, 'spectacled owl').
ncbi_mult_taxo_gbnm(111821, 'Tawny owl').
ncbi_mult_taxo_gbnm(111822, 'Hume\'s owl').
ncbi_mult_taxo_gbnm(111824, 'African wood-owl').
ncbi_mult_taxo_gbnm(111827, 'swallow-tailed nightjar').
ncbi_mult_taxo_gbnm(111829, 'mottled owl').
ncbi_mult_taxo_gbnm(111834, 'silverjaw minnow').
ncbi_mult_taxo_gbnm(111836, 'bigeye chub').
ncbi_mult_taxo_gbnm(111837, 'singing vole').
ncbi_mult_taxo_gbnm(111838, 'creeping vole').
ncbi_mult_taxo_gbnm(111839, 'woodland vole').
ncbi_mult_taxo_gbnm(111840, 'water vole').
ncbi_mult_taxo_gbnm(111841, 'Townsend\'s vole').
ncbi_mult_taxo_gbnm(111845, 'orangefin shiner').
ncbi_mult_taxo_gbnm(111846, 'river shiner').
ncbi_mult_taxo_gbnm(111847, 'bigmouth shiner').
ncbi_mult_taxo_gbnm(111853, 'longnose shiner').
ncbi_mult_taxo_gbnm(111854, 'chub shiner').
ncbi_mult_taxo_gbnm(111855, 'Yazoo shiner').
ncbi_mult_taxo_gbnm(111856, 'Sabine shiner').
ncbi_mult_taxo_gbnm(111857, 'silverband shiner').
ncbi_mult_taxo_gbnm(111858, 'bullhead minnow').
ncbi_mult_taxo_gbnm(111865, 'lesser Antillean bullfinch').
ncbi_mult_taxo_gbnm(111881, 'small tortoiseshell').
ncbi_mult_taxo_gbnm(111892, 'dark wood nymph').
ncbi_mult_taxo_gbnm(111894, 'pearly heath').
ncbi_mult_taxo_gbnm(111895, 'Corsican heath').
ncbi_mult_taxo_gbnm(111896, 'dusky heath').
ncbi_mult_taxo_gbnm(111897, arguses).
ncbi_mult_taxo_gbnm(111898, 'false mnestra ringlet').
ncbi_mult_taxo_gbnm(111900, 'common brassy ringlet').
ncbi_mult_taxo_gbnm(111901, 'common alpine').
ncbi_mult_taxo_gbnm(111902, 'large ringlet butterfly').
ncbi_mult_taxo_gbnm(111903, 'Arran brown butterfly').
ncbi_mult_taxo_gbnm(111904, 'piedmont ringlet').
ncbi_mult_taxo_gbnm(111905, 'marbled ringlet').
ncbi_mult_taxo_gbnm(111906, 'blind ringlet').
ncbi_mult_taxo_gbnm(111907, 'arctic alpine').
ncbi_mult_taxo_gbnm(111910, 'woodland grayling').
ncbi_mult_taxo_gbnm(111911, 'Corsican grayling').
ncbi_mult_taxo_gbnm(111912, 'rock grayling').
ncbi_mult_taxo_gbnm(111913, meadowbrowns).
ncbi_mult_taxo_gbnm(111916, 'large wall brown').
ncbi_mult_taxo_gbnm(111917, 'wall brown').
ncbi_mult_taxo_gbnm(111918, 'northern wall brown').
ncbi_mult_taxo_gbnm(111919, meadowbrowns).
ncbi_mult_taxo_gbnm(111922, 'marbled whites').
ncbi_mult_taxo_gbnm(111923, 'marbled white').
ncbi_mult_taxo_gbnm(111924, 'Balkan marbled white').
ncbi_mult_taxo_gbnm(111925, 'Esper\'s marbled white').
ncbi_mult_taxo_gbnm(111933, 'Madeiran speckled wood butterfly').
ncbi_mult_taxo_gbnm(111940, 'black satyr').
ncbi_mult_taxo_gbnm(111941, 'great sooty satyr').
ncbi_mult_taxo_gbnm(111947, 'many-banded snake').
ncbi_mult_taxo_gbnm(111948, 'Preuss\' forest snake').
ncbi_mult_taxo_gbnm(111974, 'common ground-dove').
ncbi_mult_taxo_gbnm(111975, 'yellow-rumped warbler').
ncbi_mult_taxo_gbnm(111976, 'black-throated grey warbler').
ncbi_mult_taxo_gbnm(111977, 'hermit warbler').
ncbi_mult_taxo_gbnm(111978, 'Townsend\'s warbler').
ncbi_mult_taxo_gbnm(111979, 'grey trembler').
ncbi_mult_taxo_gbnm(111981, 'grey catbird').
ncbi_mult_taxo_gbnm(111983, 'Caribbean elaenia').
ncbi_mult_taxo_gbnm(111985, 'pearly-eyed thrasher').
ncbi_mult_taxo_gbnm(111986, 'scaly-breasted thrasher').
ncbi_mult_taxo_gbnm(111990, 'black catbird').
ncbi_mult_taxo_gbnm(111991, 'black-faced grassquit').
ncbi_mult_taxo_gbnm(111993, 'blue mockingbird').
ncbi_mult_taxo_gbnm(111995, 'white-breasted thrasher').
ncbi_mult_taxo_gbnm(111997, 'Bahama mockingbird').
ncbi_mult_taxo_gbnm(111998, 'tropical mockingbird').
ncbi_mult_taxo_gbnm(112001, 'Huehuetenango teosinte').
ncbi_mult_taxo_gbnm(112018, 'woolly hare').
ncbi_mult_taxo_gbnm(112021, 'Manchurian hare').
ncbi_mult_taxo_gbnm(112022, 'Chinese hare').
ncbi_mult_taxo_gbnm(112105, 'chestnut-throated huet-huet').
ncbi_mult_taxo_gbnm(112106, 'moustached turca').
ncbi_mult_taxo_gbnm(112107, 'black-throated huet-huet').
ncbi_mult_taxo_gbnm(112109, 'chucao tapaculo').
ncbi_mult_taxo_gbnm(112136, 'black date mussel').
ncbi_mult_taxo_gbnm(112138, 'discordant mussel').
ncbi_mult_taxo_gbnm(112162, 'African knifefish').
ncbi_mult_taxo_gbnm(112163, 'clown knifefish').
ncbi_mult_taxo_gbnm(112179, 'spring bitterling').
ncbi_mult_taxo_gbnm(112203, 'deepsea oyster').
ncbi_mult_taxo_gbnm(112226, 'big-eared swamp rat').
ncbi_mult_taxo_gbnm(112230, 'smooth-hound').
ncbi_mult_taxo_gbnm(112232, 'starry smooth-hound').
ncbi_mult_taxo_gbnm(112233, 'blackspotted smooth-hound').
ncbi_mult_taxo_gbnm(112261, 'desert bighorn sheep').
ncbi_mult_taxo_gbnm(112270, 'spring destroying angel').
ncbi_mult_taxo_gbnm(112273, 'vetch aphid').
ncbi_mult_taxo_gbnm(112305, 'large willow sawfly').
ncbi_mult_taxo_gbnm(112408, 'African daisy').
ncbi_mult_taxo_gbnm(112503, 'dwarf bharal').
ncbi_mult_taxo_gbnm(112509, 'domesticated barley').
ncbi_mult_taxo_gbnm(112559, 'perfumed spiderlily').
ncbi_mult_taxo_gbnm(112568, 'surprise lily').
ncbi_mult_taxo_gbnm(112728, wreckfish).
ncbi_mult_taxo_gbnm(112796, 'white heelsplitter').
ncbi_mult_taxo_gbnm(112833, 'slender goldshower').
ncbi_mult_taxo_gbnm(112849, 'Azara\'s tuco-tuco').
ncbi_mult_taxo_gbnm(112850, 'Bonetto\'s tuco-tuco').
ncbi_mult_taxo_gbnm(112852, 'mottled tuco-tuco').
ncbi_mult_taxo_gbnm(112853, 'furtive tuco-tuco').
ncbi_mult_taxo_gbnm(112856, 'Scaglia\'s tuco-tuco').
ncbi_mult_taxo_gbnm(112857, 'robust tuco-tuco').
ncbi_mult_taxo_gbnm(112858, 'Tucuman tuco-tuco').
ncbi_mult_taxo_gbnm(112863, 'goji berry').
ncbi_mult_taxo_gbnm(112883, 'Chinese wolfberry').
ncbi_mult_taxo_gbnm(113097, 'Siberian salamander').
ncbi_mult_taxo_gbnm(113101, 'violet woodhoopoe').
ncbi_mult_taxo_gbnm(113103, 'white-backed planthopper').
ncbi_mult_taxo_gbnm(113115, 'common scimitar-bill').
ncbi_mult_taxo_gbnm(113116, 'Camas pocket gopher').
ncbi_mult_taxo_gbnm(113189, 'green woodhoopoe').
ncbi_mult_taxo_gbnm(113205, 'Japanese mazus').
ncbi_mult_taxo_gbnm(113210, rocoto).
ncbi_mult_taxo_gbnm(113239, 'Indian uzi fly').
ncbi_mult_taxo_gbnm(113272, 'four-toed elephant shrew').
ncbi_mult_taxo_gbnm(113275, 'short-snouted elephant shrew').
ncbi_mult_taxo_gbnm(113276, 'Bushveld elephant shrew').
ncbi_mult_taxo_gbnm(113277, 'eastern rock elephant shrew').
ncbi_mult_taxo_gbnm(113278, 'western rock elephant shrew').
ncbi_mult_taxo_gbnm(113298, 'arachne checkerspot').
ncbi_mult_taxo_gbnm(113302, 'Elada checkerspot').
ncbi_mult_taxo_gbnm(113305, 'Texan crescentspot butterfly').
ncbi_mult_taxo_gbnm(113307, 'desert hackberry butterfly').
ncbi_mult_taxo_gbnm(113308, 'California patch butterfly').
ncbi_mult_taxo_gbnm(113314, 'Janais patch butterfly').
ncbi_mult_taxo_gbnm(113315, 'bordered patch butterfly').
ncbi_mult_taxo_gbnm(113329, 'blackvein fritillary').
ncbi_mult_taxo_gbnm(113334, 'Glanville fritillary').
ncbi_mult_taxo_gbnm(113336, 'desert fritillary').
ncbi_mult_taxo_gbnm(113337, 'false-heath fritillary').
ncbi_mult_taxo_gbnm(113342, 'knapweed fritillary').
ncbi_mult_taxo_gbnm(113345, 'lesser spotted fritillary').
ncbi_mult_taxo_gbnm(113347, 'tawny crescentspot').
ncbi_mult_taxo_gbnm(113349, 'Mylitta crescentspot').
ncbi_mult_taxo_gbnm(113350, 'Oreis crescentspot').
ncbi_mult_taxo_gbnm(113351, 'pallid crescentspot').
ncbi_mult_taxo_gbnm(113352, 'Phaon crescentspot').
ncbi_mult_taxo_gbnm(113353, 'painted crescentspot').
ncbi_mult_taxo_gbnm(113378, 'Korean water toad').
ncbi_mult_taxo_gbnm(113380, 'Manchurian narrowmouth toad').
ncbi_mult_taxo_gbnm(113382, 'Fischer\'s clawed salamander').
ncbi_mult_taxo_gbnm(113383, 'Huanren brown frog').
ncbi_mult_taxo_gbnm(113384, 'Tago frog').
ncbi_mult_taxo_gbnm(113387, 'Freyer\'s fritillary').
ncbi_mult_taxo_gbnm(113391, 'Gensan salamander').
ncbi_mult_taxo_gbnm(113393, 'Cheju salamander').
ncbi_mult_taxo_gbnm(113540, 'Asian bonytongue').
ncbi_mult_taxo_gbnm(113541, 'Australian bonytongue').
ncbi_mult_taxo_gbnm(113542, 'spotted bonytongue').
ncbi_mult_taxo_gbnm(113544, arapaima).
ncbi_mult_taxo_gbnm(114082, 'black-throated magpie-jay').
ncbi_mult_taxo_gbnm(114083, 'Steller\'s jay').
ncbi_mult_taxo_gbnm(114084, 'bushy-crested jay').
ncbi_mult_taxo_gbnm(114085, 'green jay').
ncbi_mult_taxo_gbnm(114086, 'white-throated jay').
ncbi_mult_taxo_gbnm(114087, 'Yellow-billed magpie').
ncbi_mult_taxo_gbnm(114089, 'brown jay').
ncbi_mult_taxo_gbnm(114109, atipa).
ncbi_mult_taxo_gbnm(114185, 'primary endosymbionts of psyllids').
ncbi_mult_taxo_gbnm(114229, 'black-spotted cuscus').
ncbi_mult_taxo_gbnm(114271, 'scaled fruiteater').
ncbi_mult_taxo_gbnm(114274, 'black-tipped cotinga').
ncbi_mult_taxo_gbnm(114276, 'amazonian umbrellabird').
ncbi_mult_taxo_gbnm(114280, endive).
ncbi_mult_taxo_gbnm(114289, 'black salsify').
ncbi_mult_taxo_gbnm(114291, 'black-faced cotinga').
ncbi_mult_taxo_gbnm(114294, 'spangled cotinga').
ncbi_mult_taxo_gbnm(114297, 'bay-vented cotinga').
ncbi_mult_taxo_gbnm(114303, 'bare-necked fruitcrow').
ncbi_mult_taxo_gbnm(114305, 'crimson fruitcrow').
ncbi_mult_taxo_gbnm(114307, 'whitebrowed purpletuft').
ncbi_mult_taxo_gbnm(114309, 'shrike-like cotinga').
ncbi_mult_taxo_gbnm(114311, 'dusky piha').
ncbi_mult_taxo_gbnm(114312, 'rufous piha').
ncbi_mult_taxo_gbnm(114316, 'fiery-capped manakin').
ncbi_mult_taxo_gbnm(114329, 'saffron-crested tyrant-manakin').
ncbi_mult_taxo_gbnm(114331, sharpbill).
ncbi_mult_taxo_gbnm(114333, 'black-capped becard').
ncbi_mult_taxo_gbnm(114334, 'barred becard').
ncbi_mult_taxo_gbnm(114336, capuchinbird).
ncbi_mult_taxo_gbnm(114338, 'black-necked red-cotinga').
ncbi_mult_taxo_gbnm(114356, 'band-tailed manakin').
ncbi_mult_taxo_gbnm(114366, 'barred fruiteater').
ncbi_mult_taxo_gbnm(114367, 'fiery-throated fruiteater').
ncbi_mult_taxo_gbnm(114369, 'white-winged piprites').
ncbi_mult_taxo_gbnm(114371, 'purple-throated cotinga').
ncbi_mult_taxo_gbnm(114373, 'white bellbird').
ncbi_mult_taxo_gbnm(114375, 'red-ruffed fruitcrow').
ncbi_mult_taxo_gbnm(114379, 'purple-throated fruitcrow').
ncbi_mult_taxo_gbnm(114383, 'Andean cock-of-the-rock').
ncbi_mult_taxo_gbnm(114385, 'greater schiffornis').
ncbi_mult_taxo_gbnm(114387, 'black-tailed tityra').
ncbi_mult_taxo_gbnm(114388, 'black-crowned tityra').
ncbi_mult_taxo_gbnm(114390, 'black manakin').
ncbi_mult_taxo_gbnm(114392, 'pompadour cotinga').
ncbi_mult_taxo_gbnm(114398, 'common house spider').
ncbi_mult_taxo_gbnm(114405, 'timberline sparrow').
ncbi_mult_taxo_gbnm(114409, 'Siberian mole').
ncbi_mult_taxo_gbnm(114413, 'insular mole').
ncbi_mult_taxo_gbnm(114414, 'Tokuda\'s mole').
ncbi_mult_taxo_gbnm(114422, 'gutless awningclam').
ncbi_mult_taxo_gbnm(114432, 'yellow-crowned parakeet').
ncbi_mult_taxo_gbnm(114433, 'Forbes\' Parakeet').
ncbi_mult_taxo_gbnm(114434, 'Malherbe\'s parakeet').
ncbi_mult_taxo_gbnm(114437, 'Chatham Island red-crowned parakeet').
ncbi_mult_taxo_gbnm(114438, 'New Zealand red-crowned parakeet').
ncbi_mult_taxo_gbnm(114440, 'Antipodes Island green parakeet').
ncbi_mult_taxo_gbnm(114502, 'pallid shiner').
ncbi_mult_taxo_gbnm(114504, 'highback chub').
ncbi_mult_taxo_gbnm(114505, 'lined chub').
ncbi_mult_taxo_gbnm(114506, 'rosyface chub').
ncbi_mult_taxo_gbnm(114620, 'small dung flies').
ncbi_mult_taxo_gbnm(114645, 'Spinifex termite').
ncbi_mult_taxo_gbnm(114670, 'Kellogg\'s coral snake').
ncbi_mult_taxo_gbnm(114734, 'great snipe').
ncbi_mult_taxo_gbnm(114738, 'California bubble').
ncbi_mult_taxo_gbnm(114741, 'warty seacat').
ncbi_mult_taxo_gbnm(114749, 'green glassy-bubble').
ncbi_mult_taxo_gbnm(114759, 'zebra leafslug').
ncbi_mult_taxo_gbnm(114761, 'longtail seacat').
ncbi_mult_taxo_gbnm(114781, 'ebony grasshopper').
ncbi_mult_taxo_gbnm(114793, 'leaf-rolling cricket').
ncbi_mult_taxo_gbnm(114860, 'flabby whalefish').
ncbi_mult_taxo_gbnm(114863, 'Mediterranean slimehead').
ncbi_mult_taxo_gbnm(114866, 'spotted lanternfish').
ncbi_mult_taxo_gbnm(114905, 'South American fruit tree weevil').
ncbi_mult_taxo_gbnm(114915, 'crested bobwhite').
ncbi_mult_taxo_gbnm(114918, 'grey-headed chachalaca').
ncbi_mult_taxo_gbnm(114919, 'Daurian partridge').
ncbi_mult_taxo_gbnm(114927, 'elliptical sportella').
ncbi_mult_taxo_gbnm(114933, 'giant sand treader').
ncbi_mult_taxo_gbnm(114947, 'southern wood cricket').
ncbi_mult_taxo_gbnm(114951, 'Stimpson gastrochaenid').
ncbi_mult_taxo_gbnm(114952, shipworms).
ncbi_mult_taxo_gbnm(114953, 'field crickets').
ncbi_mult_taxo_gbnm(114961, 'green falsejingle').
ncbi_mult_taxo_gbnm(114967, 'American horsemussel').
ncbi_mult_taxo_gbnm(114968, 'lateral mussel').
ncbi_mult_taxo_gbnm(115018, 'Orcutt nakedclam').
ncbi_mult_taxo_gbnm(115121, 'Attwater\'s prairie chicken').
ncbi_mult_taxo_gbnm(115122, 'upland buzzard').
ncbi_mult_taxo_gbnm(115151, 'common buzzard').
ncbi_mult_taxo_gbnm(115157, 'common buzzard').
ncbi_mult_taxo_gbnm(115158, 'common buzzard').
ncbi_mult_taxo_gbnm(115159, 'Japanese buzzard').
ncbi_mult_taxo_gbnm(115161, 'eastern steppe-buzzard').
ncbi_mult_taxo_gbnm(115228, 'western steppe-buzzard').
ncbi_mult_taxo_gbnm(115229, 'rough-legged hawk').
ncbi_mult_taxo_gbnm(115293, 'stilt flies').
ncbi_mult_taxo_gbnm(115342, 'kidney-spot ladybird beetle').
ncbi_mult_taxo_gbnm(115346, 'pine ladybird').
ncbi_mult_taxo_gbnm(115353, 'slug caterpillar moths').
ncbi_mult_taxo_gbnm(115354, burnets).
ncbi_mult_taxo_gbnm(115422, 'eastern dwarf tree frog').
ncbi_mult_taxo_gbnm(115424, 'oriental latrine fly').
ncbi_mult_taxo_gbnm(115425, 'primary screw-worm').
ncbi_mult_taxo_gbnm(115427, 'human botfly').
ncbi_mult_taxo_gbnm(115429, 'West African goatfish').
ncbi_mult_taxo_gbnm(115431, 'goldband goatfish').
ncbi_mult_taxo_gbnm(115509, 'buccaneer palm').
ncbi_mult_taxo_gbnm(115513, 'needle palm').
ncbi_mult_taxo_gbnm(115524, 'Florida thatch palm').
ncbi_mult_taxo_gbnm(115590, 'blue ground-dove').
ncbi_mult_taxo_gbnm(115607, 'Riise porcelain crab').
ncbi_mult_taxo_gbnm(115608, 'banded porcelain crab').
ncbi_mult_taxo_gbnm(115609, 'red-white porcelain crab').
ncbi_mult_taxo_gbnm(115616, 'inca dove').
ncbi_mult_taxo_gbnm(115617, 'plain-breasted ground-dove').
ncbi_mult_taxo_gbnm(115618, 'picui ground-dove').
ncbi_mult_taxo_gbnm(115626, 'short-faced scorpionflies').
ncbi_mult_taxo_gbnm(115645, 'pied imperial-pigeon').
ncbi_mult_taxo_gbnm(115648, 'diamond dove').
ncbi_mult_taxo_gbnm(115651, 'ruddy quail-dove').
ncbi_mult_taxo_gbnm(115654, 'Western crowned-pigeon').
ncbi_mult_taxo_gbnm(115656, 'white-faced dove').
ncbi_mult_taxo_gbnm(115657, 'grey-fronted dove').
ncbi_mult_taxo_gbnm(115673, 'Wonga pigeon').
ncbi_mult_taxo_gbnm(115675, 'brown cuckoo-dove').
ncbi_mult_taxo_gbnm(115677, 'bare-faced ground-dove').
ncbi_mult_taxo_gbnm(115679, 'namaqua dove').
ncbi_mult_taxo_gbnm(115695, 'common bronzewing').
ncbi_mult_taxo_gbnm(115697, 'black-chinned fruit-dove').
ncbi_mult_taxo_gbnm(115699, 'scaled dove').
ncbi_mult_taxo_gbnm(115700, 'spotted dove').
ncbi_mult_taxo_gbnm(115702, 'pink-necked green-pigeon').
ncbi_mult_taxo_gbnm(115703, 'eared dove').
ncbi_mult_taxo_gbnm(115704, 'zenaida dove').
ncbi_mult_taxo_gbnm(115708, 'Galapagos dove').
ncbi_mult_taxo_gbnm(115709, 'Socorro dove').
ncbi_mult_taxo_gbnm(115710, 'pacific dove').
ncbi_mult_taxo_gbnm(115715, 'Bambara groundnut').
ncbi_mult_taxo_gbnm(115816, 'southern quahog').
ncbi_mult_taxo_gbnm(115818, 'false quahog').
ncbi_mult_taxo_gbnm(115871, 'western river garfish').
ncbi_mult_taxo_gbnm(115982, mangar).
ncbi_mult_taxo_gbnm(116033, 'Kura barbel').
ncbi_mult_taxo_gbnm(116045, 'Transcaucasian barb').
ncbi_mult_taxo_gbnm(116049, 'Mexican mushroomtongue salamander').
ncbi_mult_taxo_gbnm(116057, 'blue-thighed treefrog').
ncbi_mult_taxo_gbnm(116116, 'chameleon forest dragon').
ncbi_mult_taxo_gbnm(116118, 'secret toadhead agama').
ncbi_mult_taxo_gbnm(116126, 'dun-bar pinion').
ncbi_mult_taxo_gbnm(116128, 'November moth').
ncbi_mult_taxo_gbnm(116130, 'satellite moth').
ncbi_mult_taxo_gbnm(116135, 'purple hairstreak').
ncbi_mult_taxo_gbnm(116150, 'speckled wood butterfly').
ncbi_mult_taxo_gbnm(116151, 'sap-feeding beetles').
ncbi_mult_taxo_gbnm(116153, 'small hive beetle').
ncbi_mult_taxo_gbnm(116558, 'clam shrimps').
ncbi_mult_taxo_gbnm(116559, 'clam shrimps').
ncbi_mult_taxo_gbnm(116580, 'rough-legged buzzard').
ncbi_mult_taxo_gbnm(116583, 'mountain buzzard').
ncbi_mult_taxo_gbnm(116584, 'forest buzzard').
ncbi_mult_taxo_gbnm(116585, 'long-legged buzzard').
ncbi_mult_taxo_gbnm(116644, 'Algerian barb').
ncbi_mult_taxo_gbnm(116674, 'skeleton shrimp').
ncbi_mult_taxo_gbnm(116961, 'Kodiak bear').
ncbi_mult_taxo_gbnm(116989, 'stubble quail').
ncbi_mult_taxo_gbnm(116990, 'brown quail').
ncbi_mult_taxo_gbnm(116992, 'hill myna').
ncbi_mult_taxo_gbnm(116994, 'red-cowled cardinal').
ncbi_mult_taxo_gbnm(117000, 'Chilean flamingo').
ncbi_mult_taxo_gbnm(117002, 'striped manakin').
ncbi_mult_taxo_gbnm(117133, 'chubbyhead barb').
ncbi_mult_taxo_gbnm(117143, 'Kopetdagh Chiffchaff').
ncbi_mult_taxo_gbnm(117145, 'chestnut antpitta').
ncbi_mult_taxo_gbnm(117146, 'ochre-striped antpitta').
ncbi_mult_taxo_gbnm(117147, 'scaled antpitta').
ncbi_mult_taxo_gbnm(117148, 'white-bellied antpitta').
ncbi_mult_taxo_gbnm(117149, 'chestnut-naped antpitta').
ncbi_mult_taxo_gbnm(117150, 'chestnut-crowned antpitta').
ncbi_mult_taxo_gbnm(117151, 'rufous antpitta').
ncbi_mult_taxo_gbnm(117164, 'undulated antpitta').
ncbi_mult_taxo_gbnm(117165, 'variegated antpitta').
ncbi_mult_taxo_gbnm(117168, 'scrub antpitta').
ncbi_mult_taxo_gbnm(117176, 'crescent-faced antpitta').
ncbi_mult_taxo_gbnm(117178, 'fulvous-bellied antpitta').
ncbi_mult_taxo_gbnm(117181, 'thrush-like antpitta').
ncbi_mult_taxo_gbnm(117183, 'streaked scrub-warbler').
ncbi_mult_taxo_gbnm(117185, 'broad-tailed thornbill').
ncbi_mult_taxo_gbnm(117186, 'Tasmanian thornbill').
ncbi_mult_taxo_gbnm(117188, 'western thornbill').
ncbi_mult_taxo_gbnm(117189, 'slender-billed thornbill').
ncbi_mult_taxo_gbnm(117190, 'mountain thornbill').
ncbi_mult_taxo_gbnm(117191, 'striated thornbill').
ncbi_mult_taxo_gbnm(117192, 'yellow thornbill').
ncbi_mult_taxo_gbnm(117193, 'brown thornbill').
ncbi_mult_taxo_gbnm(117195, 'buff-rumped thornbill').
ncbi_mult_taxo_gbnm(117197, 'slaty-backed thornbill').
ncbi_mult_taxo_gbnm(117199, 'chestnut-rumped thornbill').
ncbi_mult_taxo_gbnm(117201, 'southern whiteface').
ncbi_mult_taxo_gbnm(117203, 'western gerygone').
ncbi_mult_taxo_gbnm(117206, 'Weebill').
ncbi_mult_taxo_gbnm(117272, 'blood amaranth').
ncbi_mult_taxo_gbnm(117491, 'jocotoco antpitta').
ncbi_mult_taxo_gbnm(117493, 'papuan thornbill').
ncbi_mult_taxo_gbnm(117495, 'brown gerygone').
ncbi_mult_taxo_gbnm(117496, 'white-throated gerygone').
ncbi_mult_taxo_gbnm(117569, lampreys).
ncbi_mult_taxo_gbnm(117571, 'bony vertebrates').
ncbi_mult_taxo_gbnm(117605, 'little long-fingered bat').
ncbi_mult_taxo_gbnm(117677, 'leaf katydids').
ncbi_mult_taxo_gbnm(117781, celery).
ncbi_mult_taxo_gbnm(117867, 'softnose skates').
ncbi_mult_taxo_gbnm(117889, 'coffin rays').
ncbi_mult_taxo_gbnm(117892, 'sleeper rays').
ncbi_mult_taxo_gbnm(117893, rays).
ncbi_mult_taxo_gbnm(117914, 'sleeper sharks').
ncbi_mult_taxo_gbnm(117916, 'sleeper sharks').
ncbi_mult_taxo_gbnm(117935, 'robust redhorse').
ncbi_mult_taxo_gbnm(118072, 'lobe-finned fishes').
ncbi_mult_taxo_gbnm(118090, 'Green crested lizard').
ncbi_mult_taxo_gbnm(118092, 'Mulga dragon').
ncbi_mult_taxo_gbnm(118131, 'Japanese spinous loach').
ncbi_mult_taxo_gbnm(118138, 'Ajime loach').
ncbi_mult_taxo_gbnm(118141, 'Indo-Pacific tarpon').
ncbi_mult_taxo_gbnm(118143, 'spaghetti eels').
ncbi_mult_taxo_gbnm(118145, 'lesser thrush eel').
ncbi_mult_taxo_gbnm(118146, 'false morays').
ncbi_mult_taxo_gbnm(118151, 'slender giant moray').
ncbi_mult_taxo_gbnm(118154, 'Kaup\'s arrowtooth eel').
ncbi_mult_taxo_gbnm(118155, 'cutthroat eels').
ncbi_mult_taxo_gbnm(118158, 'longneck eels').
ncbi_mult_taxo_gbnm(118162, 'common pike conger').
ncbi_mult_taxo_gbnm(118167, 'snipe eels').
ncbi_mult_taxo_gbnm(118170, 'slender snipe eel').
ncbi_mult_taxo_gbnm(118175, 'duckbill eels').
ncbi_mult_taxo_gbnm(118177, 'shortsnouted sorcerer').
ncbi_mult_taxo_gbnm(118180, 'black-throated mango').
ncbi_mult_taxo_gbnm(118181, 'little swift').
ncbi_mult_taxo_gbnm(118183, 'lesser nighthawk').
ncbi_mult_taxo_gbnm(118187, 'coppery-chested jacamar').
ncbi_mult_taxo_gbnm(118197, 'speckled chachalaca').
ncbi_mult_taxo_gbnm(118200, 'Downy woodpecker').
ncbi_mult_taxo_gbnm(118208, 'Indonesian forest dragon').
ncbi_mult_taxo_gbnm(118214, 'Mongolia rock agama').
ncbi_mult_taxo_gbnm(118216, 'Long-snouted lashtail').
ncbi_mult_taxo_gbnm(118224, 'Tajikistan toadhead agama').
ncbi_mult_taxo_gbnm(118229, 'Sinai agama').
ncbi_mult_taxo_gbnm(118230, 'Coromandel frog').
ncbi_mult_taxo_gbnm(118235, 'Pondichry fan throated lizard').
ncbi_mult_taxo_gbnm(118237, 'Baluch ground agama').
ncbi_mult_taxo_gbnm(118251, 'Mexican burrowing caecilian').
ncbi_mult_taxo_gbnm(118255, 'cownose ray').
ncbi_mult_taxo_gbnm(118256, 'Caribbean sharpnose shark').
ncbi_mult_taxo_gbnm(118431, 'rainbow pink').
ncbi_mult_taxo_gbnm(118530, 'Asian forest scorpion').
ncbi_mult_taxo_gbnm(118533, 'South American whipspider').
ncbi_mult_taxo_gbnm(118542, 'Florida whipspider').
ncbi_mult_taxo_gbnm(118565, 'silver croaker').
ncbi_mult_taxo_gbnm(118624, 'common harvesterman').
ncbi_mult_taxo_gbnm(118643, 'black spider monkey').
ncbi_mult_taxo_gbnm(118688, 'Grand Cayman blue iguana').
ncbi_mult_taxo_gbnm(118778, coltsfoot).
ncbi_mult_taxo_gbnm(118783, 'african jacana').
ncbi_mult_taxo_gbnm(118785, 'pheasant-tailed jacana').
ncbi_mult_taxo_gbnm(118786, 'northern jacana').
ncbi_mult_taxo_gbnm(118788, 'bronze-winged jacana').
ncbi_mult_taxo_gbnm(118790, 'lesser jacana').
ncbi_mult_taxo_gbnm(118793, 'greater painted-snipe').
ncbi_mult_taxo_gbnm(118797, 'Yangtze River dolphin').
ncbi_mult_taxo_gbnm(118798, 'Ganges River dolphin').
ncbi_mult_taxo_gbnm(118842, 'Amur grass lizard').
ncbi_mult_taxo_gbnm(118843, 'Sakishima grass lizard').
ncbi_mult_taxo_gbnm(118844, 'Formosa grass lizard').
ncbi_mult_taxo_gbnm(118847, 'Koshun grass lizard').
ncbi_mult_taxo_gbnm(118848, 'Asian grass lizard').
ncbi_mult_taxo_gbnm(118852, 'Antillean ghost-faced bat').
ncbi_mult_taxo_gbnm(118853, 'MacLeay\'s mustached bat').
ncbi_mult_taxo_gbnm(118854, 'sooty mustached bat').
ncbi_mult_taxo_gbnm(118856, 'Wagner\'s mustached bat').
ncbi_mult_taxo_gbnm(118858, 'Olrog\'s chaco mouse').
ncbi_mult_taxo_gbnm(118859, 'Pearson\'s chaco mouse').
ncbi_mult_taxo_gbnm(118861, 'Andean mouse').
ncbi_mult_taxo_gbnm(118862, 'Andean gerbil mouse').
ncbi_mult_taxo_gbnm(118864, 'pale leaf-eared mouse').
ncbi_mult_taxo_gbnm(118865, 'gray leaf-eared mouse').
ncbi_mult_taxo_gbnm(118974, 'feather leg baboon tarantula').
ncbi_mult_taxo_gbnm(119041, 'yellowfin puffer').
ncbi_mult_taxo_gbnm(119162, 'whitecap limpet').
ncbi_mult_taxo_gbnm(119194, 'thresher sharks').
ncbi_mult_taxo_gbnm(119203, sharks).
ncbi_mult_taxo_gbnm(119234, 'white prairie rose').
ncbi_mult_taxo_gbnm(119237, 'brahmin moths').
ncbi_mult_taxo_gbnm(119244, 'owl moth').
ncbi_mult_taxo_gbnm(119246, 'catalpa sphinx').
ncbi_mult_taxo_gbnm(119251, 'pawpaw sphinx').
ncbi_mult_taxo_gbnm(119254, 'rosy maple moth').
ncbi_mult_taxo_gbnm(119257, 'glory moths').
ncbi_mult_taxo_gbnm(119270, 'Australian silkworm moths').
ncbi_mult_taxo_gbnm(119271, 'giant lappet moths').
ncbi_mult_taxo_gbnm(119272, 'Australian lappet moths').
ncbi_mult_taxo_gbnm(119273, 'autumn silkworm moths').
ncbi_mult_taxo_gbnm(119277, 'clearwing hummingbird moth').
ncbi_mult_taxo_gbnm(119280, 'blinded sphinx').
ncbi_mult_taxo_gbnm(119282, 'big poplar sphinx').
ncbi_mult_taxo_gbnm(119284, 'Abbott\'s sphinx').
ncbi_mult_taxo_gbnm(119286, 'one-eyed sphinx').
ncbi_mult_taxo_gbnm(119288, 'great ash sphinx').
ncbi_mult_taxo_gbnm(119403, 'horned parakeet').
ncbi_mult_taxo_gbnm(119404, 'Ouvea parakeet').
ncbi_mult_taxo_gbnm(119405, 'bare-faced go-away-bird').
ncbi_mult_taxo_gbnm(119406, 'black-faced go-away-bird').
ncbi_mult_taxo_gbnm(119408, 'western grey plantain-eater').
ncbi_mult_taxo_gbnm(119409, 'eastern grey plantain-eater').
ncbi_mult_taxo_gbnm(119411, 'purple-crested turaco').
ncbi_mult_taxo_gbnm(119412, 'Ross\'s turaco').
ncbi_mult_taxo_gbnm(119413, 'Knysna turaco').
ncbi_mult_taxo_gbnm(119414, 'Fischer\'s turaco').
ncbi_mult_taxo_gbnm(119415, 'white-crested turaco').
ncbi_mult_taxo_gbnm(119416, 'white-cheeked turaco').
ncbi_mult_taxo_gbnm(119417, 'Livingston\'s turaco').
ncbi_mult_taxo_gbnm(119418, 'yellow-billed turaco').
ncbi_mult_taxo_gbnm(119419, 'Schalow\'s turaco').
ncbi_mult_taxo_gbnm(119431, 'horse sponge').
ncbi_mult_taxo_gbnm(119480, 'twospot livebearer').
ncbi_mult_taxo_gbnm(119488, 'mandarin fish').
ncbi_mult_taxo_gbnm(119562, 'bush duiker').
ncbi_mult_taxo_gbnm(119564, 'African water rat').
ncbi_mult_taxo_gbnm(119606, 'glaucous-winged gull').
ncbi_mult_taxo_gbnm(119607, 'slaty-backed gull').
ncbi_mult_taxo_gbnm(119608, 'Vega gull').
ncbi_mult_taxo_gbnm(119609, 'caspian gull').
ncbi_mult_taxo_gbnm(119627, 'yellow-legged gull').
ncbi_mult_taxo_gbnm(119635, 'armenian gull').
ncbi_mult_taxo_gbnm(119669, 'milk termite').
ncbi_mult_taxo_gbnm(119684, 'king soldierbream').
ncbi_mult_taxo_gbnm(119692, fusiliers).
ncbi_mult_taxo_gbnm(119694, 'redbelly yellowtail fusilier').
ncbi_mult_taxo_gbnm(119704, 'Santer seabream').
ncbi_mult_taxo_gbnm(119711, 'yellowback seabream').
ncbi_mult_taxo_gbnm(119712, 'Bermuda porgy').
ncbi_mult_taxo_gbnm(119713, 'spottail pinfish').
ncbi_mult_taxo_gbnm(119719, 'blackfin seabass').
ncbi_mult_taxo_gbnm(119721, 'ornate emperor').
ncbi_mult_taxo_gbnm(119722, 'spotcheek emperor').
ncbi_mult_taxo_gbnm(119736, 'Scotsman seabream').
ncbi_mult_taxo_gbnm(119738, 'saddle grunt').
ncbi_mult_taxo_gbnm(119744, 'bigeye stumpnose').
ncbi_mult_taxo_gbnm(119752, picarel).
ncbi_mult_taxo_gbnm(119760, 'Oban toad').
ncbi_mult_taxo_gbnm(119761, 'Damaraland pygmy toad').
ncbi_mult_taxo_gbnm(119769, 'Chirinda forest toad').
ncbi_mult_taxo_gbnm(119825, skunks).
ncbi_mult_taxo_gbnm(119830, 'turkey berry').
ncbi_mult_taxo_gbnm(119849, 'porthole livebearer').
ncbi_mult_taxo_gbnm(119909, 'Gudali zebu').
ncbi_mult_taxo_gbnm(119951, 'Surinam cherry').
ncbi_mult_taxo_gbnm(119967, 'Mongolian gull').
ncbi_mult_taxo_gbnm(120133, 'azure bluet').
ncbi_mult_taxo_gbnm(120218, 'Lahontan Creek tui chub').
ncbi_mult_taxo_gbnm(120385, 'Japanese kerria').
ncbi_mult_taxo_gbnm(120494, 'Sanchiang sucker frog').
ncbi_mult_taxo_gbnm(120495, 'olive frog').
ncbi_mult_taxo_gbnm(120496, 'Fujian large-headed frog').
ncbi_mult_taxo_gbnm(120498, 'Tibetan frog').
ncbi_mult_taxo_gbnm(120502, 'spiny-bellied frog').
ncbi_mult_taxo_gbnm(120507, 'Omei wood frog').
ncbi_mult_taxo_gbnm(120620, 'real yellowwood').
ncbi_mult_taxo_gbnm(120734, 'golden bandicoot').
ncbi_mult_taxo_gbnm(120735, 'western barred bandicoot').
ncbi_mult_taxo_gbnm(120794, gyrfalcon).
ncbi_mult_taxo_gbnm(120796, 'blackbanded rainbowfish').
ncbi_mult_taxo_gbnm(120797, 'Ogilby\'s rainbowfish').
ncbi_mult_taxo_gbnm(120799, 'pygmy rainbowfish').
ncbi_mult_taxo_gbnm(120800, 'exquisite rainbowfish').
ncbi_mult_taxo_gbnm(120801, 'slender rainbowfish').
ncbi_mult_taxo_gbnm(120803, 'eastern rainbowfish').
ncbi_mult_taxo_gbnm(120804, 'blue rainbowfish').
ncbi_mult_taxo_gbnm(120805, 'checkered rainbowfish').
ncbi_mult_taxo_gbnm(120827, 'desert rainbowfish').
ncbi_mult_taxo_gbnm(120829, 'Fly River rainbowfish').
ncbi_mult_taxo_gbnm(120830, 'Parkinson\'s rainbowfish').
ncbi_mult_taxo_gbnm(120832, 'Macculloch\'s rainbowfish').
ncbi_mult_taxo_gbnm(120833, 'Lakamora rainbowfish').
ncbi_mult_taxo_gbnm(120834, 'Kamaka rainbowfish').
ncbi_mult_taxo_gbnm(120835, 'Mubi rainbowfish').
ncbi_mult_taxo_gbnm(120836, 'Goldie River rainbowfish').
ncbi_mult_taxo_gbnm(120837, 'mountain rainbowfish').
ncbi_mult_taxo_gbnm(120838, 'Lake Tebera rainbowfish').
ncbi_mult_taxo_gbnm(120839, 'Lake Kutubu rainbowfish').
ncbi_mult_taxo_gbnm(120843, 'Duboulay\'s rainbowfish').
ncbi_mult_taxo_gbnm(120844, 'Murray River rainbowfish').
ncbi_mult_taxo_gbnm(120845, 'Lake Eacham rainbowfish').
ncbi_mult_taxo_gbnm(120846, 'Waigeo rainbowfish').
ncbi_mult_taxo_gbnm(120847, 'Sorong rainbowfish').
ncbi_mult_taxo_gbnm(120848, 'Batanta rainbowfish').
ncbi_mult_taxo_gbnm(120849, 'Yapen rainbowfish').
ncbi_mult_taxo_gbnm(120856, 'Ramu rainbowfish').
ncbi_mult_taxo_gbnm(120857, 'unspecked hardyhead').
ncbi_mult_taxo_gbnm(120964, 'lesser cross-marked toad').
ncbi_mult_taxo_gbnm(121123, 'Bolivian red howler monkey').
ncbi_mult_taxo_gbnm(121136, 'Crimson-mantled woodpecker').
ncbi_mult_taxo_gbnm(121156, 'green odorous frog').
ncbi_mult_taxo_gbnm(121158, 'Hejiang odorous frog').
ncbi_mult_taxo_gbnm(121160, 'green cascade frog').
ncbi_mult_taxo_gbnm(121165, 'Hubei gold-striped pond frog').
ncbi_mult_taxo_gbnm(121168, 'Tientai rough-skinned frog').
ncbi_mult_taxo_gbnm(121169, 'Busuanga wart frog').
ncbi_mult_taxo_gbnm(121221, 'body lice').
ncbi_mult_taxo_gbnm(121224, 'human body louse').
ncbi_mult_taxo_gbnm(121225, 'human louse').
ncbi_mult_taxo_gbnm(121226, 'human head louse').
ncbi_mult_taxo_gbnm(121228, 'crab louse').
ncbi_mult_taxo_gbnm(121229, 'pubic lice').
ncbi_mult_taxo_gbnm(121280, 'avocet snipe-eel').
ncbi_mult_taxo_gbnm(121285, 'Japanese gissu').
ncbi_mult_taxo_gbnm(121298, 'Cuban racer').
ncbi_mult_taxo_gbnm(121308, 'Jamaican black groundsnake').
ncbi_mult_taxo_gbnm(121320, 'Zidok\'s ground snake').
ncbi_mult_taxo_gbnm(121343, 'blunthead tree snake').
ncbi_mult_taxo_gbnm(121346, 'banded cat-eyed snake').
ncbi_mult_taxo_gbnm(121347, 'short ground snake').
ncbi_mult_taxo_gbnm(121348, 'Julia\'s ground snake').
ncbi_mult_taxo_gbnm(121349, 'royal ground snake').
ncbi_mult_taxo_gbnm(121350, 'blind ground snake').
ncbi_mult_taxo_gbnm(121366, 'Panama spotted night snake').
ncbi_mult_taxo_gbnm(121370, 'black-headed snake').
ncbi_mult_taxo_gbnm(121380, 'striped sharpnose snake').
ncbi_mult_taxo_gbnm(121382, 'tropical flat snake').
ncbi_mult_taxo_gbnm(121400, 'Ruwenzori turaco').
ncbi_mult_taxo_gbnm(121402, 'roundjaw bonefish').
ncbi_mult_taxo_gbnm(121423, 'common redstart').
ncbi_mult_taxo_gbnm(121426, 'Sardinian warbler').
ncbi_mult_taxo_gbnm(121427, 'Tropical kingbird').
ncbi_mult_taxo_gbnm(121486, 'Brazilian gloxinia').
ncbi_mult_taxo_gbnm(121490, 'elephant ear sponge').
ncbi_mult_taxo_gbnm(121526, 'white-bellied go-away bird').
ncbi_mult_taxo_gbnm(121530, 'red-crested turaco').
ncbi_mult_taxo_gbnm(121531, 'Black-billed turaco').
ncbi_mult_taxo_gbnm(121532, 'Ruwenzori black-billed lourie').
ncbi_mult_taxo_gbnm(121533, 'Buffon\'s turaco').
ncbi_mult_taxo_gbnm(121534, 'Guinea turaco').
ncbi_mult_taxo_gbnm(121561, 'red rock rat').
ncbi_mult_taxo_gbnm(121563, 'Arvicanthis somalicus Thomas, 1903').
ncbi_mult_taxo_gbnm(121564, 'West African shaggy rat').
ncbi_mult_taxo_gbnm(121565, 'buffoon striped grass mouse').
ncbi_mult_taxo_gbnm(121566, 'single-striped grass mouse').
ncbi_mult_taxo_gbnm(121567, 'typical striped grass mouse').
ncbi_mult_taxo_gbnm(121570, 'Vlei rat').
ncbi_mult_taxo_gbnm(121573, 'four-striped grass mouse').
ncbi_mult_taxo_gbnm(121575, 'bell groove-toothed swamp rat').
ncbi_mult_taxo_gbnm(121576, 'creek groove-toothed swamp rat').
ncbi_mult_taxo_gbnm(121578, 'Brants\'s whistling rat').
ncbi_mult_taxo_gbnm(121579, 'Littledale\'s whistling rat').
ncbi_mult_taxo_gbnm(121581, 'African groove-toothed rat').
ncbi_mult_taxo_gbnm(121583, 'soft-furred rat').
ncbi_mult_taxo_gbnm(121585, 'Indian bush rat').
ncbi_mult_taxo_gbnm(121587, 'Harrington\'s rat').
ncbi_mult_taxo_gbnm(121588, 'African thicket rats').
ncbi_mult_taxo_gbnm(121718, 'silver linden').
ncbi_mult_taxo_gbnm(121724, 'eurasian pygmy-owl').
ncbi_mult_taxo_gbnm(121839, 'pear psyllid').
ncbi_mult_taxo_gbnm(121845, 'Asian citrus psyllid').
ncbi_mult_taxo_gbnm(121851, 'hackberry nipplegall maker').
ncbi_mult_taxo_gbnm(121856, 'boxwood psyllid').
ncbi_mult_taxo_gbnm(121869, 'European tree frog').
ncbi_mult_taxo_gbnm(122118, 'American plum').
ncbi_mult_taxo_gbnm(122121, 'flatwoods plum').
ncbi_mult_taxo_gbnm(122222, 'golden bamboo lemur').
ncbi_mult_taxo_gbnm(122225, 'Sanford\'s brown lemur').
ncbi_mult_taxo_gbnm(122230, 'Milne-Edwards\'s sportive lemur').
ncbi_mult_taxo_gbnm(122232, 'brown mouse lemur').
ncbi_mult_taxo_gbnm(122246, 'woolly lemur').
ncbi_mult_taxo_gbnm(122272, 'squirrel glider').
ncbi_mult_taxo_gbnm(122273, 'mahogany glider').
ncbi_mult_taxo_gbnm(122285, 'rapid racerunner').
ncbi_mult_taxo_gbnm(122298, 'Good King Henry').
ncbi_mult_taxo_gbnm(122337, 'Azerbaidzhan lizard').
ncbi_mult_taxo_gbnm(122378, 'white shrimp').
ncbi_mult_taxo_gbnm(122388, 'golden-mantled tamarin').
ncbi_mult_taxo_gbnm(122585, 'Cape region whiptail').
ncbi_mult_taxo_gbnm(122736, 'cycad weevil').
ncbi_mult_taxo_gbnm(122737, 'leaf-rolling weevils').
ncbi_mult_taxo_gbnm(122739, 'rose curculio').
ncbi_mult_taxo_gbnm(122754, 'straight-snouted weevils').
ncbi_mult_taxo_gbnm(122765, 'Silvery lutung').
ncbi_mult_taxo_gbnm(122810, 'giant crepe-myrtle').
ncbi_mult_taxo_gbnm(122822, 'hunting billbug').
ncbi_mult_taxo_gbnm(122835, 'ambrosia beetles').
ncbi_mult_taxo_gbnm(122842, 'twobanded Japanese weevil').
ncbi_mult_taxo_gbnm(122849, 'black vine weevil').
ncbi_mult_taxo_gbnm(122857, 'clover root weevil').
ncbi_mult_taxo_gbnm(122865, 'Mexican bean weevil').
ncbi_mult_taxo_gbnm(122869, 'pepper weevil').
ncbi_mult_taxo_gbnm(122892, 'plum curculio').
ncbi_mult_taxo_gbnm(122900, 'pitch-eating weevil').
ncbi_mult_taxo_gbnm(122933, 'Ladder snake').
ncbi_mult_taxo_gbnm(122934, 'Four-lined ratsnake').
ncbi_mult_taxo_gbnm(122936, 'Steppes ratsnake').
ncbi_mult_taxo_gbnm(122953, 'pouched mouse').
ncbi_mult_taxo_gbnm(123223, 'Japanese flyingfish').
ncbi_mult_taxo_gbnm(123226, 'Mediterranean checkered scorpion').
ncbi_mult_taxo_gbnm(123230, 'Pacific blackchin').
ncbi_mult_taxo_gbnm(123240, 'garnet lanternfish').
ncbi_mult_taxo_gbnm(123241, 'noble lanternfish').
ncbi_mult_taxo_gbnm(123243, 'highseas lampfish').
ncbi_mult_taxo_gbnm(123245, 'popeye lanternfish').
ncbi_mult_taxo_gbnm(123257, 'patchwork lampfish').
ncbi_mult_taxo_gbnm(123331, 'bigeye lanternfish').
ncbi_mult_taxo_gbnm(123333, 'longfin lanternfish').
ncbi_mult_taxo_gbnm(123335, 'smallfin lanternfish').
ncbi_mult_taxo_gbnm(123339, 'bigfin lanternfish').
ncbi_mult_taxo_gbnm(123340, 'pearly lanternfish').
ncbi_mult_taxo_gbnm(123342, 'roundnose lanternfish').
ncbi_mult_taxo_gbnm(123344, 'slendertail lanternfish').
ncbi_mult_taxo_gbnm(123351, 'barbeled dragonfishes').
ncbi_mult_taxo_gbnm(123374, 'ash-throated gnateater').
ncbi_mult_taxo_gbnm(123376, 'yellow-bellied elaenia').
ncbi_mult_taxo_gbnm(123377, 'black-faced antthrush').
ncbi_mult_taxo_gbnm(123379, 'ochre-bellied flycatcher').
ncbi_mult_taxo_gbnm(123381, 'rufous-throated solitaire').
ncbi_mult_taxo_gbnm(123382, 'white-fronted antwren').
ncbi_mult_taxo_gbnm(123383, 'puerto rican vireo').
ncbi_mult_taxo_gbnm(123405, khat).
ncbi_mult_taxo_gbnm(123407, 'American bittersweet').
ncbi_mult_taxo_gbnm(123419, 'spiny greasebush').
ncbi_mult_taxo_gbnm(123631, 'yellow warbler').
ncbi_mult_taxo_gbnm(123659, 'Taczanowski\'s ground-tyrant').
ncbi_mult_taxo_gbnm(123683, 'javanese ricefish').
ncbi_mult_taxo_gbnm(123684, 'black buntingi').
ncbi_mult_taxo_gbnm(123685, 'dwarf medaka').
ncbi_mult_taxo_gbnm(123734, 'northern cattle grub').
ncbi_mult_taxo_gbnm(123737, 'sheep bot fly').
ncbi_mult_taxo_gbnm(123747, 'goat warble fly').
ncbi_mult_taxo_gbnm(123787, 'Merriam\'s chipmunk').
ncbi_mult_taxo_gbnm(123788, 'California chipmunk').
ncbi_mult_taxo_gbnm(123789, 'Palmer\'s chipmunk').
ncbi_mult_taxo_gbnm(123791, 'long-eared chipmunk').
ncbi_mult_taxo_gbnm(123793, 'Hopi chipmunk').
ncbi_mult_taxo_gbnm(123794, 'Allen\'s chipmunk').
ncbi_mult_taxo_gbnm(123795, 'Sonoma chipmunk').
ncbi_mult_taxo_gbnm(123796, 'Townsend\'s chipmunk').
ncbi_mult_taxo_gbnm(123797, 'Uinta chipmunk').
ncbi_mult_taxo_gbnm(123842, 'bleached skimmer').
ncbi_mult_taxo_gbnm(123846, 'Needham\'s skimmer').
ncbi_mult_taxo_gbnm(123847, 'yellow-sided skimmer').
ncbi_mult_taxo_gbnm(123848, 'eight-spotted skimmer').
ncbi_mult_taxo_gbnm(123851, 'scarce chaser').
ncbi_mult_taxo_gbnm(123934, 'sand gazelle').
ncbi_mult_taxo_gbnm(123941, 'intermediate rice rat').
ncbi_mult_taxo_gbnm(124104, 'Coen rainbow skink').
ncbi_mult_taxo_gbnm(124113, 'fire-tailed rainbow-skink').
ncbi_mult_taxo_gbnm(124286, 'leafcutter bees').
ncbi_mult_taxo_gbnm(124314, 'wormlion flies').
ncbi_mult_taxo_gbnm(124343, 'metalmark butterflies').
ncbi_mult_taxo_gbnm(124350, harlequin).
ncbi_mult_taxo_gbnm(124390, harvesters).
ncbi_mult_taxo_gbnm(124406, coppers).
ncbi_mult_taxo_gbnm(124409, 'southern snout butterfly').
ncbi_mult_taxo_gbnm(124410, admirals).
ncbi_mult_taxo_gbnm(124411, 'white admiral').
ncbi_mult_taxo_gbnm(124745, 'Townsend\'s big-eared bat').
ncbi_mult_taxo_gbnm(124747, 'black bonneted bat').
ncbi_mult_taxo_gbnm(124749, 'hairy-winged bat').
ncbi_mult_taxo_gbnm(124750, 'Waterhouse\'s leaf-nosed bat').
ncbi_mult_taxo_gbnm(124752, 'Riparian myotis').
ncbi_mult_taxo_gbnm(124753, 'big free-tailed bat').
ncbi_mult_taxo_gbnm(124754, 'mouse-tailed bats').
ncbi_mult_taxo_gbnm(124756, 'Lesser mouse-tailed bat').
ncbi_mult_taxo_gbnm(124757, 'disk-winged bats').
ncbi_mult_taxo_gbnm(124759, 'Spix\'s disk-winged bat').
ncbi_mult_taxo_gbnm(124761, 'prostrate pigweed').
ncbi_mult_taxo_gbnm(124763, 'redroot amaranth').
ncbi_mult_taxo_gbnm(124786, 'bay starvine').
ncbi_mult_taxo_gbnm(124943, neem).
ncbi_mult_taxo_gbnm(125245, 'Amatola toad').
ncbi_mult_taxo_gbnm(125246, 'sand toad').
ncbi_mult_taxo_gbnm(125247, 'Dombe pygmy toad').
ncbi_mult_taxo_gbnm(125249, 'transvaal dwarf toad').
ncbi_mult_taxo_gbnm(125252, 'yellow swamp toad').
ncbi_mult_taxo_gbnm(125253, 'Dar-es-Salaam toad').
ncbi_mult_taxo_gbnm(125261, 'sharp-leaf galangal').
ncbi_mult_taxo_gbnm(125270, 'paradise toad').
ncbi_mult_taxo_gbnm(125854, 'Inyanga toad').
ncbi_mult_taxo_gbnm(125855, 'Okahandja toad').
ncbi_mult_taxo_gbnm(125897, 'Japanese fan lobster').
ncbi_mult_taxo_gbnm(125906, 'furry lobsters').
ncbi_mult_taxo_gbnm(126064, 'ashy chinchilla rat').
ncbi_mult_taxo_gbnm(126066, 'lesser emperor dragonfly').
ncbi_mult_taxo_gbnm(126167, 'pronged clubtail').
ncbi_mult_taxo_gbnm(126173, 'golden-ringed dragonfly').
ncbi_mult_taxo_gbnm(126180, 'stalk-winged damselflies').
ncbi_mult_taxo_gbnm(126197, 'hairy dragonfly').
ncbi_mult_taxo_gbnm(126205, 'pale snaketail').
ncbi_mult_taxo_gbnm(126227, 'western spectre').
ncbi_mult_taxo_gbnm(126239, 'lancet clubtail').
ncbi_mult_taxo_gbnm(126240, 'plains clubtail').
ncbi_mult_taxo_gbnm(126241, 'common clubtail').
ncbi_mult_taxo_gbnm(126282, 'Ryukyu flying fox').
ncbi_mult_taxo_gbnm(126286, 'black-shouldered opossum').
ncbi_mult_taxo_gbnm(126289, 'Brazilian gracile mouse opossum').
ncbi_mult_taxo_gbnm(126292, 'Patagonian opossum').
ncbi_mult_taxo_gbnm(126294, 'little rufous mouse opossum').
ncbi_mult_taxo_gbnm(126295, 'murine mouse opossum').
ncbi_mult_taxo_gbnm(126296, 'white-bellied slender mouse opossum').
ncbi_mult_taxo_gbnm(126298, 'delicate slender mouse opossum').
ncbi_mult_taxo_gbnm(126299, 'Emilia\'s short-tailed opossum').
ncbi_mult_taxo_gbnm(126301, 'pallid fat-tailed opossum').
ncbi_mult_taxo_gbnm(126305, 'Gollum galaxias').
ncbi_mult_taxo_gbnm(126307, 'northern galaxias').
ncbi_mult_taxo_gbnm(126308, 'southern flathead galaxias').
ncbi_mult_taxo_gbnm(126309, 'Teviot galaxias').
ncbi_mult_taxo_gbnm(126317, 'marsh shrew').
ncbi_mult_taxo_gbnm(126318, 'ornate shrew').
ncbi_mult_taxo_gbnm(126319, 'fog shrew').
ncbi_mult_taxo_gbnm(126321, 'burrhead shiner').
ncbi_mult_taxo_gbnm(126323, 'broadstripe shiner').
ncbi_mult_taxo_gbnm(126324, 'bluehead shiner').
ncbi_mult_taxo_gbnm(126325, 'sailfin shiner').
ncbi_mult_taxo_gbnm(126326, 'flagfin shiner').
ncbi_mult_taxo_gbnm(126327, 'bluenose shiner').
ncbi_mult_taxo_gbnm(126330, 'Mediterranean rainbow wrasse').
ncbi_mult_taxo_gbnm(126351, 'Pool Burn galaxias').
ncbi_mult_taxo_gbnm(126353, 'cobaltcap silverside').
ncbi_mult_taxo_gbnm(126373, 'Celebes medaka').
ncbi_mult_taxo_gbnm(126374, 'marmorated medaka').
ncbi_mult_taxo_gbnm(126433, 'common jasmine').
ncbi_mult_taxo_gbnm(126483, 'Hubei keelback').
ncbi_mult_taxo_gbnm(126484, 'Tiger keelback').
ncbi_mult_taxo_gbnm(126588, 'painted Indonesian treefrog').
ncbi_mult_taxo_gbnm(126610, 'Oelofsens girdled lizard').
ncbi_mult_taxo_gbnm(126620, 'plated lizards').
ncbi_mult_taxo_gbnm(126622, 'Karoo plated lizard').
ncbi_mult_taxo_gbnm(126624, 'five-toed whip lizard').
ncbi_mult_taxo_gbnm(126663, 'Portugese fire salamander').
ncbi_mult_taxo_gbnm(126671, 'daisy parrotfish').
ncbi_mult_taxo_gbnm(126672, 'bridled parrotfish').
ncbi_mult_taxo_gbnm(126679, 'Laughing gull').
ncbi_mult_taxo_gbnm(126683, 'ring-billed gull').
ncbi_mult_taxo_gbnm(126723, 'Sandwich tern').
ncbi_mult_taxo_gbnm(126735, muskellunge).
ncbi_mult_taxo_gbnm(126820, 'coffee senna').
ncbi_mult_taxo_gbnm(126836, 'Great grey owl').
ncbi_mult_taxo_gbnm(126849, 'Ashy-faced owl').
ncbi_mult_taxo_gbnm(126850, 'buff-fronted owl').
ncbi_mult_taxo_gbnm(126859, 'Indian scops owl').
ncbi_mult_taxo_gbnm(126860, 'sunda scops owl').
ncbi_mult_taxo_gbnm(126863, 'Rufous-legged owl').
ncbi_mult_taxo_gbnm(126887, 'mangrove reed-warbler').
ncbi_mult_taxo_gbnm(126903, 'Peruvian groundcherry').
ncbi_mult_taxo_gbnm(126966, 'Tonkin bug-eyed frog').
ncbi_mult_taxo_gbnm(127020, 'copper-cheeked frog').
ncbi_mult_taxo_gbnm(127021, 'black-striped frog').
ncbi_mult_taxo_gbnm(127079, 'Indian burrowing frog').
ncbi_mult_taxo_gbnm(127175, 'Burmese whipping frog').
ncbi_mult_taxo_gbnm(127177, glasswing).
ncbi_mult_taxo_gbnm(127251, 'dark glassy tiger').
ncbi_mult_taxo_gbnm(127259, 'blue tigers').
ncbi_mult_taxo_gbnm(127260, 'blue tiger').
ncbi_mult_taxo_gbnm(127290, 'Malayan bushbrown').
ncbi_mult_taxo_gbnm(127291, 'common red forester').
ncbi_mult_taxo_gbnm(127299, 'smooth-banded sister').
ncbi_mult_taxo_gbnm(127314, 'meadow fritillary').
ncbi_mult_taxo_gbnm(127335, 'ghost sailor').
ncbi_mult_taxo_gbnm(127339, calicoes).
ncbi_mult_taxo_gbnm(127344, 'chocolate pansy').
ncbi_mult_taxo_gbnm(127364, nawabs).
ncbi_mult_taxo_gbnm(127365, 'common nawab').
ncbi_mult_taxo_gbnm(127387, 'Saintonge termite').
ncbi_mult_taxo_gbnm(127399, 'leaf miners').
ncbi_mult_taxo_gbnm(127404, 'tomato leaf miner').
ncbi_mult_taxo_gbnm(127405, 'pea leafminer').
ncbi_mult_taxo_gbnm(127406, 'vegetable leafminer').
ncbi_mult_taxo_gbnm(127500, 'Finlayson\'s squirrel').
ncbi_mult_taxo_gbnm(127501, 'black-striped squirrel').
ncbi_mult_taxo_gbnm(127560, 'mole shrew').
ncbi_mult_taxo_gbnm(127582, 'Florida manatee').
ncbi_mult_taxo_gbnm(127584, 'Paraguay mabuya').
ncbi_mult_taxo_gbnm(127599, 'olive danio').
ncbi_mult_taxo_gbnm(127641, 'ornate frog').
ncbi_mult_taxo_gbnm(127644, 'Madagascar bright-eyed frog').
ncbi_mult_taxo_gbnm(127645, 'groove-crowned bullfrog').
ncbi_mult_taxo_gbnm(127654, 'savanna ridged frog').
ncbi_mult_taxo_gbnm(127946, 'song thrush').
ncbi_mult_taxo_gbnm(127972, 'coolie loach').
ncbi_mult_taxo_gbnm(128013, 'moss mites').
ncbi_mult_taxo_gbnm(128105, 'Guyenne spiny-rat').
ncbi_mult_taxo_gbnm(128106, 'Cuvier\'s spiny rat').
ncbi_mult_taxo_gbnm(128150, 'Johnston\'s Forest Shrew').
ncbi_mult_taxo_gbnm(128151, 'Greater Forest Shrew').
ncbi_mult_taxo_gbnm(128161, 'black field cricket').
ncbi_mult_taxo_gbnm(128390, 'crested ibis').
ncbi_mult_taxo_gbnm(128432, 'mountain brushtail possum').
ncbi_mult_taxo_gbnm(128608, 'Ceylon cinnamon').
ncbi_mult_taxo_gbnm(128817, 'lettuce root aphid').
ncbi_mult_taxo_gbnm(128897, dangleberry).
ncbi_mult_taxo_gbnm(128943, 'shiny bluebottle fly').
ncbi_mult_taxo_gbnm(128991, 'slender pigeon louse').
ncbi_mult_taxo_gbnm(129005, 'Jerdons bullfrog').
ncbi_mult_taxo_gbnm(129016, 'dusky torrent frog').
ncbi_mult_taxo_gbnm(129019, 'Ceylon streamlined frog').
ncbi_mult_taxo_gbnm(129020, 'night frogs').
ncbi_mult_taxo_gbnm(129021, 'cream spotted frog').
ncbi_mult_taxo_gbnm(129023, 'Malabar night frog').
ncbi_mult_taxo_gbnm(129024, 'Gunther\'s bubble-nest frog').
ncbi_mult_taxo_gbnm(129025, 'Karnataka bubble-nest frog').
ncbi_mult_taxo_gbnm(129027, 'Sri Lanka whipping frog').
ncbi_mult_taxo_gbnm(129029, 'bicolored frog').
ncbi_mult_taxo_gbnm(129043, 'Pacific saury').
ncbi_mult_taxo_gbnm(129044, 'Atlantic flyingfish').
ncbi_mult_taxo_gbnm(129055, 'Matano medaka').
ncbi_mult_taxo_gbnm(129062, 'Californian needlefish').
ncbi_mult_taxo_gbnm(129064, 'Maya needlefish').
ncbi_mult_taxo_gbnm(129065, 'reef needlefish').
ncbi_mult_taxo_gbnm(129066, 'long tom').
ncbi_mult_taxo_gbnm(129068, 'Atlantic needlefish').
ncbi_mult_taxo_gbnm(129069, 'shoulderspot needlefish').
ncbi_mult_taxo_gbnm(129071, 'spottail needlefish').
ncbi_mult_taxo_gbnm(129073, 'Agujon needlefish').
ncbi_mult_taxo_gbnm(129077, 'hound needlefish').
ncbi_mult_taxo_gbnm(129078, 'hound needlefish').
ncbi_mult_taxo_gbnm(129106, 'spotted long-tom').
ncbi_mult_taxo_gbnm(129108, 'freshwater garfish').
ncbi_mult_taxo_gbnm(129112, 'redfin needlefish').
ncbi_mult_taxo_gbnm(129190, 'agent of llama granulocytic ehrlichiosis').
ncbi_mult_taxo_gbnm(129201, 'mile-a-minute vine').
ncbi_mult_taxo_gbnm(129216, 'Lycian salamander').
ncbi_mult_taxo_gbnm(129217, 'mahaleb cherry').
ncbi_mult_taxo_gbnm(129222, 'Aders\'s duiker').
ncbi_mult_taxo_gbnm(129223, 'Peters\' duiker').
ncbi_mult_taxo_gbnm(129224, 'Harvey\'s duiker').
ncbi_mult_taxo_gbnm(129225, 'Jentink\'s duiker').
ncbi_mult_taxo_gbnm(129226, 'black duiker').
ncbi_mult_taxo_gbnm(129227, 'black-fronted duiker').
ncbi_mult_taxo_gbnm(129228, 'Ogilby\'s duiker').
ncbi_mult_taxo_gbnm(129229, 'Ruwenzori duiker').
ncbi_mult_taxo_gbnm(129230, 'red-flanked duiker').
ncbi_mult_taxo_gbnm(129231, 'Abbott\'s duiker').
ncbi_mult_taxo_gbnm(129232, 'Weyns\'s duiker').
ncbi_mult_taxo_gbnm(129233, 'zebra duiker').
ncbi_mult_taxo_gbnm(129237, 'Engelhardt\'s mushroomtongue salamander').
ncbi_mult_taxo_gbnm(129241, 'Cope\'s mushroomtongue salamander').
ncbi_mult_taxo_gbnm(129242, 'O\'Donnell\'s salamander').
ncbi_mult_taxo_gbnm(129246, 'Chevrier\'s field mouse').
ncbi_mult_taxo_gbnm(129247, 'South China field mouse').
ncbi_mult_taxo_gbnm(129250, 'cabbage fly').
ncbi_mult_taxo_gbnm(129251, 'globeflower flies').
ncbi_mult_taxo_gbnm(129310, 'Papuan olive python').
ncbi_mult_taxo_gbnm(129326, 'white-lipped python').
ncbi_mult_taxo_gbnm(129328, 'Boelen\'s python').
ncbi_mult_taxo_gbnm(129329, 'Seram-python').
ncbi_mult_taxo_gbnm(129330, 'Kinghorn\'s python').
ncbi_mult_taxo_gbnm(129331, 'Tanimbar python').
ncbi_mult_taxo_gbnm(129332, 'Halmahera python').
ncbi_mult_taxo_gbnm(129333, 'green tree python').
ncbi_mult_taxo_gbnm(129396, blackveins).
ncbi_mult_taxo_gbnm(129398, 'puffins and albatrosses').
ncbi_mult_taxo_gbnm(129400, gulls).
ncbi_mult_taxo_gbnm(129430, 'eastern harvest mouse').
ncbi_mult_taxo_gbnm(129431, 'plains harvest mouse').
ncbi_mult_taxo_gbnm(129432, 'salt marsh harvest mouse').
ncbi_mult_taxo_gbnm(129433, 'Zacatecas harvest mouse').
ncbi_mult_taxo_gbnm(129434, 'Allen\'s cotton rat').
ncbi_mult_taxo_gbnm(129435, 'Arizona cotton rat').
ncbi_mult_taxo_gbnm(129461, 'Southern coral snake').
ncbi_mult_taxo_gbnm(129464, 'South American coral snake').
ncbi_mult_taxo_gbnm(129469, 'Amazon coral snake').
ncbi_mult_taxo_gbnm(129554, 'velvetbean caterpillar').
ncbi_mult_taxo_gbnm(129788, 'Manila clam').
ncbi_mult_taxo_gbnm(129801, 'brown spider monkey').
ncbi_mult_taxo_gbnm(129883, vairone).
ncbi_mult_taxo_gbnm(129884, 'crocodile newts').
ncbi_mult_taxo_gbnm(129885, 'Taliang knobby newt').
ncbi_mult_taxo_gbnm(129912, 'pipefishes and seahorses').
ncbi_mult_taxo_gbnm(129914, pipefishes).
ncbi_mult_taxo_gbnm(129917, seahorses).
ncbi_mult_taxo_gbnm(130044, 'common halfbeak').
ncbi_mult_taxo_gbnm(130046, 'Pacific agujon needlefish').
ncbi_mult_taxo_gbnm(130138, peyote).
ncbi_mult_taxo_gbnm(130203, 'Alcock\'s spruce').
ncbi_mult_taxo_gbnm(130208, 'Koyama\'s spruce').
ncbi_mult_taxo_gbnm(130260, 'New Zealand smelts').
ncbi_mult_taxo_gbnm(130264, galaxiids).
ncbi_mult_taxo_gbnm(130591, 'spotted lanternfly').
ncbi_mult_taxo_gbnm(130601, 'piglet bugs').
ncbi_mult_taxo_gbnm(130739, 'Fischer\'s thick-toed gecko').
ncbi_mult_taxo_gbnm(130740, 'Cape Verde wall gecko').
ncbi_mult_taxo_gbnm(130786, 'Kottigehar torrent frog').
ncbi_mult_taxo_gbnm(130819, 'alpine pika').
ncbi_mult_taxo_gbnm(130821, 'Gansu pika').
ncbi_mult_taxo_gbnm(130825, 'black-lipped pika').
ncbi_mult_taxo_gbnm(130827, 'Daurian Pika').
ncbi_mult_taxo_gbnm(130830, 'Chinese red pika').
ncbi_mult_taxo_gbnm(130831, 'Forrest\'s pika').
ncbi_mult_taxo_gbnm(130832, 'Himalayan pika').
ncbi_mult_taxo_gbnm(130833, 'Huanghe pika').
ncbi_mult_taxo_gbnm(130834, 'northern pika').
ncbi_mult_taxo_gbnm(130835, 'Kozlov\'s pika').
ncbi_mult_taxo_gbnm(130836, 'Ladak pika').
ncbi_mult_taxo_gbnm(130837, 'large-eared pika').
ncbi_mult_taxo_gbnm(130838, 'Nubra pika').
ncbi_mult_taxo_gbnm(130839, 'Pallas\'s pika').
ncbi_mult_taxo_gbnm(130842, 'Royle\'s pika').
ncbi_mult_taxo_gbnm(130843, 'Moupin pika').
ncbi_mult_taxo_gbnm(130844, 'Thomas\'s pika').
ncbi_mult_taxo_gbnm(131267, 'areca palm').
ncbi_mult_taxo_gbnm(131405, 'lowland cichlid').
ncbi_mult_taxo_gbnm(131578, 'flea beetles').
ncbi_mult_taxo_gbnm(131619, 'dogbane beetle').
ncbi_mult_taxo_gbnm(131620, 'cottonwood leaf beetle').
ncbi_mult_taxo_gbnm(131627, 'common asparagus beetle').
ncbi_mult_taxo_gbnm(131645, 'water lily leaf beetle').
ncbi_mult_taxo_gbnm(131678, 'lantana leaf beetle').
ncbi_mult_taxo_gbnm(131689, 'case-bearing leaf beetles').
ncbi_mult_taxo_gbnm(131709, 'broad-necked root borer').
ncbi_mult_taxo_gbnm(132107, 'trumpet emperor').
ncbi_mult_taxo_gbnm(132113, 'common eastern bumble bee').
ncbi_mult_taxo_gbnm(132195, 'scarlet-bodied wasp moth').
ncbi_mult_taxo_gbnm(132201, 'wasp moths').
ncbi_mult_taxo_gbnm(132240, 'yellow-banded wasp moth').
ncbi_mult_taxo_gbnm(132251, 'montane Atlantic forest rat').
ncbi_mult_taxo_gbnm(132256, 'Lindbergh\'s Oryzomys').
ncbi_mult_taxo_gbnm(132429, 'Chinese hog-peanut').
ncbi_mult_taxo_gbnm(132461, 'least snoutbean').
ncbi_mult_taxo_gbnm(132585, 'Pink-footed goose').
ncbi_mult_taxo_gbnm(132586, 'Lesser white-fronted goose').
ncbi_mult_taxo_gbnm(132587, 'Taiga bean goose').
ncbi_mult_taxo_gbnm(132589, 'European white-fronted goose').
ncbi_mult_taxo_gbnm(132590, 'Greenland white-fronted goose').
ncbi_mult_taxo_gbnm(132591, 'eastern greylag goose').
ncbi_mult_taxo_gbnm(132616, 'holly leafminers').
ncbi_mult_taxo_gbnm(132696, 'western meadow fritillary').
ncbi_mult_taxo_gbnm(132697, 'common ringlet').
ncbi_mult_taxo_gbnm(132706, 'small apollo').
ncbi_mult_taxo_gbnm(132708, 'Clark\'s day sphinx').
ncbi_mult_taxo_gbnm(132710, 'southern festoon').
ncbi_mult_taxo_gbnm(132908, 'large flying fox').
ncbi_mult_taxo_gbnm(132935, 'Argentinian wood cockroach').
ncbi_mult_taxo_gbnm(133063, 'larch wooly adelgid').
ncbi_mult_taxo_gbnm(133065, 'spruce gall adelgid').
ncbi_mult_taxo_gbnm(133082, 'woolly apple aphid').
ncbi_mult_taxo_gbnm(133089, 'beech blight aphid').
ncbi_mult_taxo_gbnm(133098, 'Norway maple aphid').
ncbi_mult_taxo_gbnm(133107, 'Asian woolly hackberry aphid').
ncbi_mult_taxo_gbnm(133117, 'striped cucumber beetle').
ncbi_mult_taxo_gbnm(133119, 'western spotted cucumber beetle').
ncbi_mult_taxo_gbnm(133197, 'Japanese banana').
ncbi_mult_taxo_gbnm(133227, 'strawberry mite').
ncbi_mult_taxo_gbnm(133229, 'white mites').
ncbi_mult_taxo_gbnm(133434, 'crown-of-thorns starfish').
ncbi_mult_taxo_gbnm(133901, 'western flower thrips').
ncbi_mult_taxo_gbnm(133902, 'southern brown shrimp').
ncbi_mult_taxo_gbnm(134033, 'American chestnut').
ncbi_mult_taxo_gbnm(134352, 'Virginia ctenucha').
ncbi_mult_taxo_gbnm(134471, 'Florida rocksnail').
ncbi_mult_taxo_gbnm(134510, 'Judean mountains blind mole rat').
ncbi_mult_taxo_gbnm(134522, 'coral honeysuckle').
ncbi_mult_taxo_gbnm(134593, 'Ciscaucasian spined loach').
ncbi_mult_taxo_gbnm(134613, 'slickheads and marine smelts').
ncbi_mult_taxo_gbnm(134615, slickheads).
ncbi_mult_taxo_gbnm(134630, 'blacksaddled coralgrouper').
ncbi_mult_taxo_gbnm(134631, 'South American silver porgy').
ncbi_mult_taxo_gbnm(134639, 'arctic-alpine ground beetle').
ncbi_mult_taxo_gbnm(134699, 'Angolan reed frog').
ncbi_mult_taxo_gbnm(134700, 'arum lily frog').
ncbi_mult_taxo_gbnm(134701, 'Kivu reed frog').
ncbi_mult_taxo_gbnm(134745, 'Toltec cotton rat').
ncbi_mult_taxo_gbnm(134758, 'two-lined salamander').
ncbi_mult_taxo_gbnm(134759, 'spring salamanders').
ncbi_mult_taxo_gbnm(134760, 'spring salamander').
ncbi_mult_taxo_gbnm(134762, 'red salamander').
ncbi_mult_taxo_gbnm(134889, 'western milkweed longhorn').
ncbi_mult_taxo_gbnm(134902, 'hawaiian crow').
ncbi_mult_taxo_gbnm(134906, 'chihuahuan raven').
ncbi_mult_taxo_gbnm(134909, 'Caucasus field mouse').
ncbi_mult_taxo_gbnm(134910, 'pygmy field mouse').
ncbi_mult_taxo_gbnm(134913, 'alpine currant').
ncbi_mult_taxo_gbnm(134920, 'ninespine stickleback').
ncbi_mult_taxo_gbnm(134990, 'silver chimaera').
ncbi_mult_taxo_gbnm(134992, 'longnose chimaeras').
ncbi_mult_taxo_gbnm(134994, 'Pacific spookfish').
ncbi_mult_taxo_gbnm(135160, 'Northern bettong').
ncbi_mult_taxo_gbnm(135162, 'rufous-capped motmot').
ncbi_mult_taxo_gbnm(135165, 'short-legged ground-roller').
ncbi_mult_taxo_gbnm(135168, 'collared puffbird').
ncbi_mult_taxo_gbnm(135170, 'bluish-fronted jacamar').
ncbi_mult_taxo_gbnm(135172, 'blue-tufted starthroat').
ncbi_mult_taxo_gbnm(135173, 'grey-rumped treeswift').
ncbi_mult_taxo_gbnm(135175, 'gilded hummingbird').
ncbi_mult_taxo_gbnm(135176, 'blue-throated bee-eater').
ncbi_mult_taxo_gbnm(135178, 'spot-backed puffbird').
ncbi_mult_taxo_gbnm(135179, 'planalto hermit').
ncbi_mult_taxo_gbnm(135183, 'green barbet').
ncbi_mult_taxo_gbnm(135184, 'puerto rican tody').
ncbi_mult_taxo_gbnm(135185, 'Usambiro barbet').
ncbi_mult_taxo_gbnm(135190, 'marbled crab').
ncbi_mult_taxo_gbnm(135192, 'brazilian tinamou').
ncbi_mult_taxo_gbnm(135197, yuzu).
ncbi_mult_taxo_gbnm(135220, 'shiro-anago').
ncbi_mult_taxo_gbnm(135421, 'blood star').
ncbi_mult_taxo_gbnm(135422, 'grasshopper sparrow').
ncbi_mult_taxo_gbnm(135424, 'Lapland longspur').
ncbi_mult_taxo_gbnm(135427, 'orange-bellied flowerpecker').
ncbi_mult_taxo_gbnm(135428, 'greater flowerpiercer').
ncbi_mult_taxo_gbnm(135430, 'horned lark').
ncbi_mult_taxo_gbnm(135431, 'Finsch\'s euphonia').
ncbi_mult_taxo_gbnm(135433, 'common yellowthroat').
ncbi_mult_taxo_gbnm(135437, 'yellow-breasted chat').
ncbi_mult_taxo_gbnm(135438, 'black-and-white munia').
ncbi_mult_taxo_gbnm(135441, 'olive warbler').
ncbi_mult_taxo_gbnm(135444, 'rose-breasted grosbeak').
ncbi_mult_taxo_gbnm(135448, 'village weaver').
ncbi_mult_taxo_gbnm(135450, 'slate-colored seedeater').
ncbi_mult_taxo_gbnm(135452, 'blue-black grassquit').
ncbi_mult_taxo_gbnm(135486, 'Matschie\'s galago').
ncbi_mult_taxo_gbnm(135488, 'Kubuna hardyhead').
ncbi_mult_taxo_gbnm(135489, 'gold-striped treefrog').
ncbi_mult_taxo_gbnm(135583, 'viscacha rat').
ncbi_mult_taxo_gbnm(135584, 'barred bichir').
ncbi_mult_taxo_gbnm(135595, 'small pigeon louse').
ncbi_mult_taxo_gbnm(135627, 'speckled pigeon').
ncbi_mult_taxo_gbnm(135629, 'Caribbean dove').
ncbi_mult_taxo_gbnm(135630, 'grey-headed dove').
ncbi_mult_taxo_gbnm(135631, 'white-tipped dove').
ncbi_mult_taxo_gbnm(135632, 'white-eared brown-dove').
ncbi_mult_taxo_gbnm(135633, 'yelow-breasted fruit-dove').
ncbi_mult_taxo_gbnm(135634, 'ring-necked dove').
ncbi_mult_taxo_gbnm(135635, 'laughing dove').
ncbi_mult_taxo_gbnm(135647, 'stone loach').
ncbi_mult_taxo_gbnm(135663, 'southern carpenter bee').
ncbi_mult_taxo_gbnm(135671, 'common carpenter bee').
ncbi_mult_taxo_gbnm(135717, 'spotted giant flying squirrel').
ncbi_mult_taxo_gbnm(135759, 'eastern freshwater cod').
ncbi_mult_taxo_gbnm(135761, 'Murray cod').
ncbi_mult_taxo_gbnm(135763, 'Mary River cod').
ncbi_mult_taxo_gbnm(135764, 'golden perch').
ncbi_mult_taxo_gbnm(135765, 'Macquarie perch').
ncbi_mult_taxo_gbnm(135766, 'estuary perch').
ncbi_mult_taxo_gbnm(135770, 'Tasmanian pigmy perch').
ncbi_mult_taxo_gbnm(135776, 'spotted whiting').
ncbi_mult_taxo_gbnm(135792, 'Cedar Creek treefrog').
ncbi_mult_taxo_gbnm(135793, 'leaf green treefrog').
ncbi_mult_taxo_gbnm(135794, 'Spencer\'s treefrog').
ncbi_mult_taxo_gbnm(135829, kouprey).
ncbi_mult_taxo_gbnm(135972, 'green broadbill').
ncbi_mult_taxo_gbnm(135974, 'wedge-billed woodcreeper').
ncbi_mult_taxo_gbnm(135975, 'Micronesian myzomela').
ncbi_mult_taxo_gbnm(135976, 'rufous fantail').
ncbi_mult_taxo_gbnm(135977, 'grey-headed babbler').
ncbi_mult_taxo_gbnm(135979, 'ferruginous babbler').
ncbi_mult_taxo_gbnm(135980, 'bridled white-eye').
ncbi_mult_taxo_gbnm(135981, 'chestnut-flanked white-eye').
ncbi_mult_taxo_gbnm(135982, 'plain white-eye').
ncbi_mult_taxo_gbnm(135983, 'Kikuyu white-eye').
ncbi_mult_taxo_gbnm(135984, 'mountain white-eye').
ncbi_mult_taxo_gbnm(135985, 'yellowish white-eye').
ncbi_mult_taxo_gbnm(135986, 'Oriental white-eye').
ncbi_mult_taxo_gbnm(135988, 'Caroline white-eye').
ncbi_mult_taxo_gbnm(135989, 'African yellow white-eye').
ncbi_mult_taxo_gbnm(135992, 'Rota bridled white-eye').
ncbi_mult_taxo_gbnm(135994, 'Heuglin\'s white-eye').
ncbi_mult_taxo_gbnm(136086, 'dwarf gymnure').
ncbi_mult_taxo_gbnm(136208, 'East Indian arrowroot').
ncbi_mult_taxo_gbnm(136217, turmeric).
ncbi_mult_taxo_gbnm(136225, 'Myoga ginger').
ncbi_mult_taxo_gbnm(136317, 'low larkspur').
ncbi_mult_taxo_gbnm(136334, 'upland larkspur').
ncbi_mult_taxo_gbnm(136416, 'Shasta ground sloth').
ncbi_mult_taxo_gbnm(136417, 'ground sloths').
ncbi_mult_taxo_gbnm(136419, cercozoans).
ncbi_mult_taxo_gbnm(136465, 'Taiwan cherry').
ncbi_mult_taxo_gbnm(136503, 'mitred parakeet').
ncbi_mult_taxo_gbnm(136504, 'salmon-crested cockatoo').
ncbi_mult_taxo_gbnm(136690, 'squat lobsters').
ncbi_mult_taxo_gbnm(136815, 'redtail barb').
ncbi_mult_taxo_gbnm(136816, 'largescale yellowfish').
ncbi_mult_taxo_gbnm(136817, 'Marico barb').
ncbi_mult_taxo_gbnm(136827, 'cherry barb').
ncbi_mult_taxo_gbnm(136843, 'fluorescent pseudomonads').
ncbi_mult_taxo_gbnm(136969, 'plain-tailed warbling-finch').
ncbi_mult_taxo_gbnm(136970, 'Tucuman mountain-finch').
ncbi_mult_taxo_gbnm(136971, 'Bolivian warbling-finch').
ncbi_mult_taxo_gbnm(136974, 'Cochabamba mountain-finch').
ncbi_mult_taxo_gbnm(136975, 'collared warbling-finch').
ncbi_mult_taxo_gbnm(136977, 'black-capped warbling finch').
ncbi_mult_taxo_gbnm(136978, 'cinnamon warbling-finch').
ncbi_mult_taxo_gbnm(136979, 'ringed warbling-finch').
ncbi_mult_taxo_gbnm(136980, 'black-and-chestnut warbling-finch').
ncbi_mult_taxo_gbnm(137033, 'redspot barb').
ncbi_mult_taxo_gbnm(137034, 'blackstripe barb').
ncbi_mult_taxo_gbnm(137036, 'Nyanza barb').
ncbi_mult_taxo_gbnm(137061, 'smallmouth redhorse').
ncbi_mult_taxo_gbnm(137067, 'Ili marinka').
ncbi_mult_taxo_gbnm(137089, 'smallscale yellowfish').
ncbi_mult_taxo_gbnm(137211, 'many-colored chaco-finch').
ncbi_mult_taxo_gbnm(137215, 'Cuban bullfinch').
ncbi_mult_taxo_gbnm(137231, 'great pampa-finch').
ncbi_mult_taxo_gbnm(137237, 'Red-crested finch').
ncbi_mult_taxo_gbnm(137246, 'brownbanded bambooshark').
ncbi_mult_taxo_gbnm(137255, 'black-faced cormorant').
ncbi_mult_taxo_gbnm(137276, 'fairy cichlid').
ncbi_mult_taxo_gbnm(137477, 'bean seed maggot').
ncbi_mult_taxo_gbnm(137501, 'frit fly').
ncbi_mult_taxo_gbnm(137503, 'black scavenger flies').
ncbi_mult_taxo_gbnm(137515, 'threespot leporinus').
ncbi_mult_taxo_gbnm(137517, 'black cuckoo-shrike').
ncbi_mult_taxo_gbnm(137518, 'rufous gnateater').
ncbi_mult_taxo_gbnm(137522, 'Japanese icefish').
ncbi_mult_taxo_gbnm(137524, 'crested hornero').
ncbi_mult_taxo_gbnm(137526, 'steamer-tailed tyrant').
ncbi_mult_taxo_gbnm(137532, 'velvet asity').
ncbi_mult_taxo_gbnm(137534, 'white-tipped plantcutter').
ncbi_mult_taxo_gbnm(137535, 'white-barred piculet').
ncbi_mult_taxo_gbnm(137536, 'African pitta').
ncbi_mult_taxo_gbnm(137537, 'blue-headed pitta').
ncbi_mult_taxo_gbnm(137539, 'crested gallito').
ncbi_mult_taxo_gbnm(137540, 'variable antshrike').
ncbi_mult_taxo_gbnm(137541, 'Fork-tailed flycatcher').
ncbi_mult_taxo_gbnm(137542, 'Norfolk parakeet').
ncbi_mult_taxo_gbnm(137667, 'chain-of-love').
ncbi_mult_taxo_gbnm(137712, 'Common pine vole').
ncbi_mult_taxo_gbnm(137762, 'rufous-sided broadbill').
ncbi_mult_taxo_gbnm(137882, 'Japanese fluvial sculpin').
ncbi_mult_taxo_gbnm(138011, canola).
ncbi_mult_taxo_gbnm(138033, 'Egyptian acacia').
ncbi_mult_taxo_gbnm(138070, 'Adonis blue').
ncbi_mult_taxo_gbnm(138083, 'huge-crested toad').
ncbi_mult_taxo_gbnm(138084, 'Campbell\'s rainforest toad').
ncbi_mult_taxo_gbnm(138085, 'Gulf Coast toad').
ncbi_mult_taxo_gbnm(138129, 'lesser spiny eel').
ncbi_mult_taxo_gbnm(138334, 'wild leek').
ncbi_mult_taxo_gbnm(138513, 'shrubby wattle').
ncbi_mult_taxo_gbnm(138555, pirambeba).
ncbi_mult_taxo_gbnm(138556, 'redeye piranha').
ncbi_mult_taxo_gbnm(138560, 'birdeye speedwell').
ncbi_mult_taxo_gbnm(138608, 'Mendi termite').
ncbi_mult_taxo_gbnm(138670, 'spring pygmy sunfish').
ncbi_mult_taxo_gbnm(138676, 'Japanese silver crucian carp').
ncbi_mult_taxo_gbnm(138705, 'Thomas\' nectar bat').
ncbi_mult_taxo_gbnm(138814, 'seal lice').
ncbi_mult_taxo_gbnm(138930, 'yellow-bellied seedeater').
ncbi_mult_taxo_gbnm(138956, 'black flowerpiercer').
ncbi_mult_taxo_gbnm(138961, 'Wing-barred seedeater').
ncbi_mult_taxo_gbnm(138962, 'chestnut-bellied seedeater').
ncbi_mult_taxo_gbnm(139036, 'rice moth').
ncbi_mult_taxo_gbnm(139271, 'hard pines').
ncbi_mult_taxo_gbnm(139272, 'soft pines').
ncbi_mult_taxo_gbnm(139416, 'olive hairstreak').
ncbi_mult_taxo_gbnm(139615, 'Tasmanian hairy cicada').
ncbi_mult_taxo_gbnm(139644, 'stalk-eyed flies').
ncbi_mult_taxo_gbnm(139719, 'spaghetti eel').
ncbi_mult_taxo_gbnm(139721, 'false moray').
ncbi_mult_taxo_gbnm(139722, 'Kidako moray').
ncbi_mult_taxo_gbnm(139772, 'Chinese tallow').
ncbi_mult_taxo_gbnm(139928, 'bitternut hickory').
ncbi_mult_taxo_gbnm(139929, 'nutmeg hickory').
ncbi_mult_taxo_gbnm(140016, 'small Asian mongoose').
ncbi_mult_taxo_gbnm(140017, 'milk snake').
ncbi_mult_taxo_gbnm(140036, 'white vervain').
ncbi_mult_taxo_gbnm(140053, 'Blue-capped rock-thrush').
ncbi_mult_taxo_gbnm(140068, 'clapping cicada').
ncbi_mult_taxo_gbnm(140311, 'sour cherry').
ncbi_mult_taxo_gbnm(140442, 'dwarf inanga').
ncbi_mult_taxo_gbnm(140443, 'crestless fireback').
ncbi_mult_taxo_gbnm(140444, 'Vietnamese pheasant').
ncbi_mult_taxo_gbnm(140652, 'Carolina laurelcherry').
ncbi_mult_taxo_gbnm(140654, 'Gray\'s bird cherry').
ncbi_mult_taxo_gbnm(140657, 'Amur chokecherry').
ncbi_mult_taxo_gbnm(140715, 'scaled fleas').
ncbi_mult_taxo_gbnm(140720, 'bat fleas').
ncbi_mult_taxo_gbnm(141002, 'American-ipecac').
ncbi_mult_taxo_gbnm(141003, 'Bowman\'s root').
ncbi_mult_taxo_gbnm(141186, 'crepe myrtle').
ncbi_mult_taxo_gbnm(141191, henna).
ncbi_mult_taxo_gbnm(141248, 'Indian black scorpion').
ncbi_mult_taxo_gbnm(141262, 'Chinese giant salamander').
ncbi_mult_taxo_gbnm(141264, cobia).
ncbi_mult_taxo_gbnm(141269, 'yacare caiman').
ncbi_mult_taxo_gbnm(141271, 'yellow-crested cockatoo').
ncbi_mult_taxo_gbnm(141274, 'sulfur-crested cockatoo').
ncbi_mult_taxo_gbnm(141282, 'Eastern rosella').
ncbi_mult_taxo_gbnm(141652, 'Mesopotamian fallow deer').
ncbi_mult_taxo_gbnm(141661, 'sharpjaw bonefish').
ncbi_mult_taxo_gbnm(141682, 'Algerian barb').
ncbi_mult_taxo_gbnm(141683, 'Algerian barb').
ncbi_mult_taxo_gbnm(141825, 'pygmy whitefish').
ncbi_mult_taxo_gbnm(141834, 'Ducorps\'s cockatoo').
ncbi_mult_taxo_gbnm(141835, 'Blue-eyed cockatoo').
ncbi_mult_taxo_gbnm(141836, 'White cockatoo').
ncbi_mult_taxo_gbnm(141837, 'Philippine cockatoo').
ncbi_mult_taxo_gbnm(141839, 'palm cockatoo').
ncbi_mult_taxo_gbnm(141885, 'Gulf flounder').
ncbi_mult_taxo_gbnm(141886, 'southern flounder').
ncbi_mult_taxo_gbnm(141887, 'broad flounder').
ncbi_mult_taxo_gbnm(141895, 'goldenscale Anole').
ncbi_mult_taxo_gbnm(141976, 'red-backed salamander').
ncbi_mult_taxo_gbnm(141977, 'Peaks of Otter salamander').
ncbi_mult_taxo_gbnm(141978, 'Shenandoah salamander').
ncbi_mult_taxo_gbnm(142135, 'black-legged grasshopper').
ncbi_mult_taxo_gbnm(142137, 'Lakin grasshopper').
ncbi_mult_taxo_gbnm(142181, 'oriental paperbush').
ncbi_mult_taxo_gbnm(142466, 'Western scrub-jay').
ncbi_mult_taxo_gbnm(142467, 'plain titmouse').
ncbi_mult_taxo_gbnm(142468, 'purple finch').
ncbi_mult_taxo_gbnm(142474, 'MacGillivray\'s warbler').
ncbi_mult_taxo_gbnm(142478, 'Wilson\'s warbler').
ncbi_mult_taxo_gbnm(142482, 'striped mud turtle').
ncbi_mult_taxo_gbnm(142483, 'Durango mud turtle').
ncbi_mult_taxo_gbnm(142484, 'yellow mud turtle').
ncbi_mult_taxo_gbnm(142486, 'rough-footed mud turtle').
ncbi_mult_taxo_gbnm(142487, 'common mud turtle').
ncbi_mult_taxo_gbnm(142762, 'green cestrum').
ncbi_mult_taxo_gbnm(142885, 'greater blind mole rat').
ncbi_mult_taxo_gbnm(143020, 'common pine shoot beetle').
ncbi_mult_taxo_gbnm(143281, 'Mexican gray wolf').
ncbi_mult_taxo_gbnm(143287, 'Montane guinea pig').
ncbi_mult_taxo_gbnm(143288, 'Mountain paca').
ncbi_mult_taxo_gbnm(143291, 'Indian flying fox').
ncbi_mult_taxo_gbnm(143292, 'Chinese pangolin').
ncbi_mult_taxo_gbnm(143302, 'star-nosed mole').
ncbi_mult_taxo_gbnm(143303, 'jellynose fishes').
ncbi_mult_taxo_gbnm(143304, 'jellynose fishes').
ncbi_mult_taxo_gbnm(143306, 'Pacific jellynose fish').
ncbi_mult_taxo_gbnm(143308, 'Bombay ducks').
ncbi_mult_taxo_gbnm(143310, lizardfishes).
ncbi_mult_taxo_gbnm(143313, 'shortnose greeneye').
ncbi_mult_taxo_gbnm(143315, 'brushtooth lizardfish').
ncbi_mult_taxo_gbnm(143320, 'Malagasy civet').
ncbi_mult_taxo_gbnm(143322, 'metallic lantern fish').
ncbi_mult_taxo_gbnm(143325, 'scalloped ribbonfish').
ncbi_mult_taxo_gbnm(143326, beardfish).
ncbi_mult_taxo_gbnm(143327, 'sand roller').
ncbi_mult_taxo_gbnm(143328, 'Mugura grenadier').
ncbi_mult_taxo_gbnm(143330, 'fringelip mullet').
ncbi_mult_taxo_gbnm(143332, 'tropical two-wing flyingfish').
ncbi_mult_taxo_gbnm(143334, yawning).
ncbi_mult_taxo_gbnm(143337, flintperch).
ncbi_mult_taxo_gbnm(143339, 'deepbody boarfish').
ncbi_mult_taxo_gbnm(143340, 'tire track eel').
ncbi_mult_taxo_gbnm(143342, 'starry flying gurnard').
ncbi_mult_taxo_gbnm(143345, 'stone flounder').
ncbi_mult_taxo_gbnm(143348, 'thread-sail filefish').
ncbi_mult_taxo_gbnm(143350, 'red seabream').
ncbi_mult_taxo_gbnm(143352, 'Berthe\'s mouse lemur').
ncbi_mult_taxo_gbnm(143398, 'bigmouth buffalo').
ncbi_mult_taxo_gbnm(143401, 'Siberian spiny loach').
ncbi_mult_taxo_gbnm(143403, 'royal clown loach').
ncbi_mult_taxo_gbnm(143409, 'hogsback frog').
ncbi_mult_taxo_gbnm(143417, 'whitebelly reed frog').
ncbi_mult_taxo_gbnm(143418, 'long reed frog').
ncbi_mult_taxo_gbnm(143419, 'yellow-striped reed frog').
ncbi_mult_taxo_gbnm(143420, 'tinker reed frog').
ncbi_mult_taxo_gbnm(143421, 'modest forest treefrog').
ncbi_mult_taxo_gbnm(143422, 'raucous tree frog').
ncbi_mult_taxo_gbnm(143438, 'marbled streamlined frog').
ncbi_mult_taxo_gbnm(143439, 'spotted whipping frog').
ncbi_mult_taxo_gbnm(143442, 'sharp-nosed frog').
ncbi_mult_taxo_gbnm(143443, 'spotted ridged frog').
ncbi_mult_taxo_gbnm(143454, 'African wart frogs').
ncbi_mult_taxo_gbnm(143455, 'African wart frog').
ncbi_mult_taxo_gbnm(143460, 'Natal diving frog').
ncbi_mult_taxo_gbnm(143461, 'puddle frogs').
ncbi_mult_taxo_gbnm(143462, 'Mababe puddle frog').
ncbi_mult_taxo_gbnm(143492, 'broad-banded grass frog').
ncbi_mult_taxo_gbnm(143496, 'Nkhomo-benga peacock cichlid').
ncbi_mult_taxo_gbnm(143502, 'African foam-nest treefrog').
ncbi_mult_taxo_gbnm(143503, 'haplochromis sunset').
ncbi_mult_taxo_gbnm(143504, 'black-lined plated lizard').
ncbi_mult_taxo_gbnm(143510, 'Madagascar reed frog').
ncbi_mult_taxo_gbnm(143513, 'Reeves\' butterfly lizard').
ncbi_mult_taxo_gbnm(143515, 'Cameroon forest treefrog').
ncbi_mult_taxo_gbnm(143525, 'Taiwan rice frog').
ncbi_mult_taxo_gbnm(143526, 'ornate rice frog').
ncbi_mult_taxo_gbnm(143529, 'broad-tailed day gecko').
ncbi_mult_taxo_gbnm(143533, 'black-spotted tree frog').
ncbi_mult_taxo_gbnm(143534, 'Bongon whipping frog').
ncbi_mult_taxo_gbnm(143535, 'Ethiopia grassland frog').
ncbi_mult_taxo_gbnm(143536, 'blood python').
ncbi_mult_taxo_gbnm(143537, 'New Caledonia bumpy gecko').
ncbi_mult_taxo_gbnm(143538, 'Bavay\'s giant gecko').
ncbi_mult_taxo_gbnm(143539, 'crested gecko').
ncbi_mult_taxo_gbnm(143540, 'Roux\'s giant gecko').
ncbi_mult_taxo_gbnm(143546, kululu).
ncbi_mult_taxo_gbnm(143547, 'marbled rain frog').
ncbi_mult_taxo_gbnm(143558, 'rain frogs').
ncbi_mult_taxo_gbnm(143559, 'plain rain frog').
ncbi_mult_taxo_gbnm(143561, 'Greshoff\'s wax frog').
ncbi_mult_taxo_gbnm(143563, 'Mueller\'s termite frog').
ncbi_mult_taxo_gbnm(143568, 'royal ghost frog').
ncbi_mult_taxo_gbnm(143569, 'Betsileo reed frog').
ncbi_mult_taxo_gbnm(143592, 'Mangalore bullfrog').
ncbi_mult_taxo_gbnm(143602, 'western prairie fringed orchid').
ncbi_mult_taxo_gbnm(143632, 'marbled rubber frog').
ncbi_mult_taxo_gbnm(143633, 'giant treefrogs').
ncbi_mult_taxo_gbnm(143634, 'Boulenger\'s giant treefrog').
ncbi_mult_taxo_gbnm(143637, 'digging frogs').
ncbi_mult_taxo_gbnm(143638, 'Mahanoro digging frog').
ncbi_mult_taxo_gbnm(143641, 'Karpathos water frog').
ncbi_mult_taxo_gbnm(143642, 'Greek marsh frog').
ncbi_mult_taxo_gbnm(143646, nsess).
ncbi_mult_taxo_gbnm(143648, 'striped stream frog').
ncbi_mult_taxo_gbnm(143649, 'stump-toed frogs').
ncbi_mult_taxo_gbnm(143650, 'giant stump-toed frog').
ncbi_mult_taxo_gbnm(143656, 'banded rubber frog').
ncbi_mult_taxo_gbnm(143659, pindu).
ncbi_mult_taxo_gbnm(143660, 'Maromandia stump-toed frog').
ncbi_mult_taxo_gbnm(143669, 'Mozambique rain frog').
ncbi_mult_taxo_gbnm(143678, 'California buckthorn').
ncbi_mult_taxo_gbnm(143699, 'winter stoneflies').
ncbi_mult_taxo_gbnm(143726, 'Calidornia forestfly').
ncbi_mult_taxo_gbnm(143729, 'eastern willowfly').
ncbi_mult_taxo_gbnm(143742, 'sierra needlefly').
ncbi_mult_taxo_gbnm(143751, 'giant stoneflies').
ncbi_mult_taxo_gbnm(143756, roachflies).
ncbi_mult_taxo_gbnm(143758, 'giant roachfly').
ncbi_mult_taxo_gbnm(143760, 'piedmont roachfly').
ncbi_mult_taxo_gbnm(143894, 'ribbon fish').
ncbi_mult_taxo_gbnm(143895, 'spiny eel').
ncbi_mult_taxo_gbnm(143896, 'halosaurs and spiny eels').
ncbi_mult_taxo_gbnm(143942, 'New Zealand long-tailed bat').
ncbi_mult_taxo_gbnm(143948, 'Russian wheat aphid').
ncbi_mult_taxo_gbnm(143950, 'yellow sugarcane aphid').
ncbi_mult_taxo_gbnm(143970, 'Eastern digger bee').
ncbi_mult_taxo_gbnm(143995, 'alfalfa leafcutting bee').
ncbi_mult_taxo_gbnm(144034, 'red harvester ant').
ncbi_mult_taxo_gbnm(144197, 'bicolor damselfish').
ncbi_mult_taxo_gbnm(144198, 'Douglas squirrel').
ncbi_mult_taxo_gbnm(144199, 'Mearn\'s squirrel').
ncbi_mult_taxo_gbnm(144390, 'pincher wasps').
ncbi_mult_taxo_gbnm(144567, 'Russian thistle grasshopper').
ncbi_mult_taxo_gbnm(144575, 'northern wingless locust').
ncbi_mult_taxo_gbnm(144578, 'mountain lubber grasshopper').
ncbi_mult_taxo_gbnm(144580, 'rainbow grasshopper').
ncbi_mult_taxo_gbnm(144588, 'snakeweed grasshopper').
ncbi_mult_taxo_gbnm(144739, 'dwarf danio').
ncbi_mult_taxo_gbnm(144766, 'spotted sea hare').
ncbi_mult_taxo_gbnm(145264, 'marsupial chewing lice').
ncbi_mult_taxo_gbnm(145266, 'wallaby louse').
ncbi_mult_taxo_gbnm(145282, 'bronze frog').
ncbi_mult_taxo_gbnm(145283, 'pelican-flower').
ncbi_mult_taxo_gbnm(145346, unicornfishes).
ncbi_mult_taxo_gbnm(145348, 'thirteen-year cicada').
ncbi_mult_taxo_gbnm(145395, 'browneye skate').
ncbi_mult_taxo_gbnm(145400, 'Panther Anole').
ncbi_mult_taxo_gbnm(145410, 'San Diego pocket mouse').
ncbi_mult_taxo_gbnm(145427, 'European ambersnail').
ncbi_mult_taxo_gbnm(145451, 'bluebodied blowfly').
ncbi_mult_taxo_gbnm(145454, 'western goldenhaired blowfly').
ncbi_mult_taxo_gbnm(145526, 'Gongshanensis muntjac').
ncbi_mult_taxo_gbnm(145527, 'gold crucian carp').
ncbi_mult_taxo_gbnm(145700, babassu).
ncbi_mult_taxo_gbnm(145745, marshmallow).
ncbi_mult_taxo_gbnm(145813, 'bearded creeper').
ncbi_mult_taxo_gbnm(146130, 'Chinese bamboo rat').
ncbi_mult_taxo_gbnm(146132, 'plateau zokor').
ncbi_mult_taxo_gbnm(146136, 'Rothschild\'s zokor').
ncbi_mult_taxo_gbnm(146141, 'fourspot butterflyfish').
ncbi_mult_taxo_gbnm(146142, 'redtail scad').
ncbi_mult_taxo_gbnm(146143, 'mackerel scad').
ncbi_mult_taxo_gbnm(146144, 'Indian scad').
ncbi_mult_taxo_gbnm(146145, 'sapphire damsel').
ncbi_mult_taxo_gbnm(146146, 'bigeye scad').
ncbi_mult_taxo_gbnm(146147, 'Canary drum').
ncbi_mult_taxo_gbnm(146480, 'lesser sand-eel').
ncbi_mult_taxo_gbnm(146494, 'owl-flies').
ncbi_mult_taxo_gbnm(146530, 'slender wild oat').
ncbi_mult_taxo_gbnm(146612, 'Brandt\'s cormorant').
ncbi_mult_taxo_gbnm(146613, 'Campbell Island shag').
ncbi_mult_taxo_gbnm(146614, 'Cape cormorant').
ncbi_mult_taxo_gbnm(146615, 'Chatham Island shag').
ncbi_mult_taxo_gbnm(146616, 'Guanay shag').
ncbi_mult_taxo_gbnm(146617, 'Japanese cormorant').
ncbi_mult_taxo_gbnm(146618, 'little pied cormorant').
ncbi_mult_taxo_gbnm(146619, 'Macquarie Island shag').
ncbi_mult_taxo_gbnm(146620, 'Magellan cormorant').
ncbi_mult_taxo_gbnm(146621, 'pied cormorant').
ncbi_mult_taxo_gbnm(146623, 'red-legged cormorant').
ncbi_mult_taxo_gbnm(146624, 'spotted shag').
ncbi_mult_taxo_gbnm(146625, 'Otago shag').
ncbi_mult_taxo_gbnm(146632, 'greater glider').
ncbi_mult_taxo_gbnm(146672, 'southern leopard frog').
ncbi_mult_taxo_gbnm(146711, 'round-tongued floating frog').
ncbi_mult_taxo_gbnm(146730, 'Arabian five-fingered frog').
ncbi_mult_taxo_gbnm(146731, 'Gravenhorst\'s golden-backed frog').
ncbi_mult_taxo_gbnm(146732, 'Andersson\'s Cameroon frog').
ncbi_mult_taxo_gbnm(146733, 'montane frog').
ncbi_mult_taxo_gbnm(146763, 'Bocourt swimming crab').
ncbi_mult_taxo_gbnm(146764, 'Maracaibo swimming crab').
ncbi_mult_taxo_gbnm(146765, 'blue swimming crab').
ncbi_mult_taxo_gbnm(146766, 'redhair swimming crab').
ncbi_mult_taxo_gbnm(146774, 'azuki bean weevil').
ncbi_mult_taxo_gbnm(146808, 'butter hamlet').
ncbi_mult_taxo_gbnm(146809, 'harlequin bass').
ncbi_mult_taxo_gbnm(146810, 'barred hamlet').
ncbi_mult_taxo_gbnm(146811, 'black hamlet').
ncbi_mult_taxo_gbnm(146814, 'shy hamlet').
ncbi_mult_taxo_gbnm(146815, 'yellowtail hamlet').
ncbi_mult_taxo_gbnm(146816, 'yellowbelly hamlet').
ncbi_mult_taxo_gbnm(146818, tobaccofish).
ncbi_mult_taxo_gbnm(146834, 'black earwigs').
ncbi_mult_taxo_gbnm(146849, 'little earwigs').
ncbi_mult_taxo_gbnm(146864, 'garden symphylan').
ncbi_mult_taxo_gbnm(146909, 'stump-toed gecko').
ncbi_mult_taxo_gbnm(146912, 'Peking gecko').
ncbi_mult_taxo_gbnm(146921, 'shuttles hoppfish').
ncbi_mult_taxo_gbnm(147060, 'hairy-backed bulbul').
ncbi_mult_taxo_gbnm(147184, 'bandana-of-the-everglades').
ncbi_mult_taxo_gbnm(147208, 'mottled sculpin').
ncbi_mult_taxo_gbnm(147209, 'banded sculpin').
ncbi_mult_taxo_gbnm(147210, 'slimy sculpin').
ncbi_mult_taxo_gbnm(147211, 'Ozark sculpin').
ncbi_mult_taxo_gbnm(147232, 'threespot wrasse').
ncbi_mult_taxo_gbnm(147304, 'egg frogs').
ncbi_mult_taxo_gbnm(147305, 'Mertens\' egg frog').
ncbi_mult_taxo_gbnm(147328, 'Chinese leopard cat').
ncbi_mult_taxo_gbnm(147376, bamboo).
ncbi_mult_taxo_gbnm(147464, 'giant moa').
ncbi_mult_taxo_gbnm(147466, 'eastern moa').
ncbi_mult_taxo_gbnm(147537, 'budding yeasts & allies').
ncbi_mult_taxo_gbnm(147538, 'filamentous ascomycetes').
ncbi_mult_taxo_gbnm(147646, 'spotted sand bass').
ncbi_mult_taxo_gbnm(147649, 'Preuss\' monkey').
ncbi_mult_taxo_gbnm(147650, 'sun-tailed monkey').
ncbi_mult_taxo_gbnm(147829, 'wide-eyed flounder').
ncbi_mult_taxo_gbnm(147907, 'Georgia blind salamander').
ncbi_mult_taxo_gbnm(147909, 'Ozark blind salamander').
ncbi_mult_taxo_gbnm(147949, 'smallmouth bass').
ncbi_mult_taxo_gbnm(148021, 'Geoffroy\'s tailless bat').
ncbi_mult_taxo_gbnm(148035, 'Jamaican fig-eating bat').
ncbi_mult_taxo_gbnm(148041, 'great stripe-faced bat').
ncbi_mult_taxo_gbnm(148061, 'Common sword-nosed bat').
ncbi_mult_taxo_gbnm(148064, 'Davies\'s big-eared bat').
ncbi_mult_taxo_gbnm(148066, 'little big-eared bat').
ncbi_mult_taxo_gbnm(148068, 'Niceforo\'s big-eared bat').
ncbi_mult_taxo_gbnm(148080, 'smoky bats').
ncbi_mult_taxo_gbnm(148089, 'Hairy-legged vampire bat').
ncbi_mult_taxo_gbnm(148442, 'Lost River Sucker').
ncbi_mult_taxo_gbnm(148594, 'lesser kestrel').
ncbi_mult_taxo_gbnm(148607, 'sailfin sandfish').
ncbi_mult_taxo_gbnm(148965, 'Hildegarde\'s Shrew').
ncbi_mult_taxo_gbnm(148991, 'black prochilodus').
ncbi_mult_taxo_gbnm(149088, tubenose).
ncbi_mult_taxo_gbnm(149089, 'Bolivian bufeo').
ncbi_mult_taxo_gbnm(149983, 'rust corydoras').
ncbi_mult_taxo_gbnm(149986, 'beaked salmon').
ncbi_mult_taxo_gbnm(150114, 'bulb mites').
ncbi_mult_taxo_gbnm(150241, 'moss frogs').
ncbi_mult_taxo_gbnm(150242, 'Bainskloof moss frog').
ncbi_mult_taxo_gbnm(150243, 'Drewes\' moss frog').
ncbi_mult_taxo_gbnm(150244, 'Landdros moss frog').
ncbi_mult_taxo_gbnm(150245, 'Cape chirping frog').
ncbi_mult_taxo_gbnm(150246, 'De Villiers\' moss frog').
ncbi_mult_taxo_gbnm(150258, 'spotted prawn goby').
ncbi_mult_taxo_gbnm(150288, 'great blue-spotted mudskipper').
ncbi_mult_taxo_gbnm(150291, 'bumblebee goby').
ncbi_mult_taxo_gbnm(150292, 'duckbill sleeper').
ncbi_mult_taxo_gbnm(150293, 'black-spotted gudgeon').
ncbi_mult_taxo_gbnm(150296, 'Puntang goby').
ncbi_mult_taxo_gbnm(150298, 'Celebes goby').
ncbi_mult_taxo_gbnm(150301, 'striped gudgeon').
ncbi_mult_taxo_gbnm(150304, 'firetailed gudgeon').
ncbi_mult_taxo_gbnm(150307, firefishes).
ncbi_mult_taxo_gbnm(150309, 'fire goby').
ncbi_mult_taxo_gbnm(150312, 'sharptail goby').
ncbi_mult_taxo_gbnm(150317, 'flathead gudgeon').
ncbi_mult_taxo_gbnm(150319, 'Chinese zebra goby').
ncbi_mult_taxo_gbnm(150320, 'mud sleeper').
ncbi_mult_taxo_gbnm(150323, 'blackfin dartfish').
ncbi_mult_taxo_gbnm(150325, 'speckled goby').
ncbi_mult_taxo_gbnm(150332, 'blueband goby').
ncbi_mult_taxo_gbnm(150421, 'western rock lobster').
ncbi_mult_taxo_gbnm(150424, 'spotted spiny lobster').
ncbi_mult_taxo_gbnm(150425, 'Indian spiny lobster').
ncbi_mult_taxo_gbnm(150429, 'smoothtail spiny lobster').
ncbi_mult_taxo_gbnm(150436, 'painted spiny lobster').
ncbi_mult_taxo_gbnm(150448, 'Chinese trumpetfish').
ncbi_mult_taxo_gbnm(150449, trumpetfish).
ncbi_mult_taxo_gbnm(150450, 'Atlantic cornetfish').
ncbi_mult_taxo_gbnm(150699, 'bluntclaw snapping shrimp').
ncbi_mult_taxo_gbnm(150703, 'Upper Amazon treefrog').
ncbi_mult_taxo_gbnm(150704, 'executioner treefrog').
ncbi_mult_taxo_gbnm(150705, 'hourglass treefrog').
ncbi_mult_taxo_gbnm(150706, 'elegant forest treefrog').
ncbi_mult_taxo_gbnm(150707, 'green dotted treefrog').
ncbi_mult_taxo_gbnm(150708, 'Bereis\' treefrog').
ncbi_mult_taxo_gbnm(150709, 'marbled treefrog').
ncbi_mult_taxo_gbnm(150710, 'yellow treefrog').
ncbi_mult_taxo_gbnm(150711, 'lesser treefrog').
ncbi_mult_taxo_gbnm(150712, 'Sarayacu treefrog').
ncbi_mult_taxo_gbnm(150713, 'Shreve\'s Sarayacu treefrog').
ncbi_mult_taxo_gbnm(150714, 'triangle treefrog').
ncbi_mult_taxo_gbnm(150821, 'orangetail snapping shrimp').
ncbi_mult_taxo_gbnm(150905, 'Unicolored jay').
ncbi_mult_taxo_gbnm(151021, 'Bermuda killifish').
ncbi_mult_taxo_gbnm(151022, 'marsh killifish').
ncbi_mult_taxo_gbnm(151023, 'Lover\'s Lake killifish').
ncbi_mult_taxo_gbnm(151053, 'bullock bush').
ncbi_mult_taxo_gbnm(151069, lychee).
ncbi_mult_taxo_gbnm(151250, 'prickly saltwort').
ncbi_mult_taxo_gbnm(151300, 'dot-lined white moth').
ncbi_mult_taxo_gbnm(151304, 'pine lappet').
ncbi_mult_taxo_gbnm(151312, 'fox moth').
ncbi_mult_taxo_gbnm(151313, 'western tent caterpillar').
ncbi_mult_taxo_gbnm(151320, 'lappet moth').
ncbi_mult_taxo_gbnm(151326, 'oak eggar').
ncbi_mult_taxo_gbnm(151327, 'Asian cockroach').
ncbi_mult_taxo_gbnm(151439, 'Chinese sour cherry').
ncbi_mult_taxo_gbnm(151441, 'Simon plum').
ncbi_mult_taxo_gbnm(151442, 'Klamath plum').
ncbi_mult_taxo_gbnm(151525, 'Hondo sika deer').
ncbi_mult_taxo_gbnm(151541, 'African queen').
ncbi_mult_taxo_gbnm(151544, 'peacock pansy').
ncbi_mult_taxo_gbnm(151546, 'bee hawks').
ncbi_mult_taxo_gbnm(151708, logrunner).
ncbi_mult_taxo_gbnm(151713, 'starry goby').
ncbi_mult_taxo_gbnm(151714, 'Colon goby').
ncbi_mult_taxo_gbnm(151715, 'pallid goby').
ncbi_mult_taxo_gbnm(151716, 'glass goby').
ncbi_mult_taxo_gbnm(151717, 'peppermint goby').
ncbi_mult_taxo_gbnm(151718, 'masked goby').
ncbi_mult_taxo_gbnm(151719, 'spotted goby').
ncbi_mult_taxo_gbnm(151720, 'redlight goby').
ncbi_mult_taxo_gbnm(151721, 'brindled goby').
ncbi_mult_taxo_gbnm(151723, 'blackeye goby').
ncbi_mult_taxo_gbnm(151725, 'common fusegoby').
ncbi_mult_taxo_gbnm(151726, 'signalfin goby').
ncbi_mult_taxo_gbnm(151728, 'goldspot goby').
ncbi_mult_taxo_gbnm(151729, 'broad-barred goby').
ncbi_mult_taxo_gbnm(151731, 'crested goby').
ncbi_mult_taxo_gbnm(151759, 'red-lored parrot').
ncbi_mult_taxo_gbnm(151761, 'yellow-crowned parrot').
ncbi_mult_taxo_gbnm(151768, 'Bronze-winged parrot').
ncbi_mult_taxo_gbnm(152106, 'Boganida char').
ncbi_mult_taxo_gbnm(152107, 'small-mouth char').
ncbi_mult_taxo_gbnm(152109, 'long-finned charr').
ncbi_mult_taxo_gbnm(152110, 'Dryanin\'s char').
ncbi_mult_taxo_gbnm(152218, 'yellow grouper').
ncbi_mult_taxo_gbnm(152251, 'purple lilliput').
ncbi_mult_taxo_gbnm(152276, 'yellow-headed parrot').
ncbi_mult_taxo_gbnm(152347, 'lowland leopard frog').
ncbi_mult_taxo_gbnm(152387, 'false spider mite').
ncbi_mult_taxo_gbnm(152498, 'slender-legged treefrogs').
ncbi_mult_taxo_gbnm(152499, 'Buckley\'s slender-legged treefrog').
ncbi_mult_taxo_gbnm(152536, 'Florida blenny').
ncbi_mult_taxo_gbnm(152538, 'Montagu\'s blenny').
ncbi_mult_taxo_gbnm(152539, 'bicolor blenny').
ncbi_mult_taxo_gbnm(152540, 'Persian blenny').
ncbi_mult_taxo_gbnm(152541, 'feather blenny').
ncbi_mult_taxo_gbnm(152543, 'saddled blenny').
ncbi_mult_taxo_gbnm(152545, 'disco blenny').
ncbi_mult_taxo_gbnm(152547, 'seaweed blenny').
ncbi_mult_taxo_gbnm(152548, 'rusty blenny').
ncbi_mult_taxo_gbnm(152549, 'tentacled blenny').
ncbi_mult_taxo_gbnm(152553, 'peacock blenny').
ncbi_mult_taxo_gbnm(152582, 'Zambezi thick-toed gecko').
ncbi_mult_taxo_gbnm(152588, 'Boultons Namib day gecko').
ncbi_mult_taxo_gbnm(152621, 'painted jezebel').
ncbi_mult_taxo_gbnm(152771, 'prickly lanternfish').
ncbi_mult_taxo_gbnm(152832, 'alpine poppy').
ncbi_mult_taxo_gbnm(152838, 'golden spider-lily').
ncbi_mult_taxo_gbnm(152923, 'huntsman spiders').
ncbi_mult_taxo_gbnm(152925, 'giant crab spider').
ncbi_mult_taxo_gbnm(153015, 'fruitworm beetles').
ncbi_mult_taxo_gbnm(153017, 'raspberry fruitworm').
ncbi_mult_taxo_gbnm(153209, 'wedge sole').
ncbi_mult_taxo_gbnm(153211, 'Portuguese sole').
ncbi_mult_taxo_gbnm(153223, 'yellow wheat blossom midge').
ncbi_mult_taxo_gbnm(153284, 'rufous Myotis').
ncbi_mult_taxo_gbnm(153293, 'Hemprich\'s desert bat').
ncbi_mult_taxo_gbnm(153295, 'Allen\'s yellow bat').
ncbi_mult_taxo_gbnm(153297, 'Lesser asiatic yellow house bat').
ncbi_mult_taxo_gbnm(153298, 'Little yellow bat').
ncbi_mult_taxo_gbnm(153299, 'Black-winged little yellow bat').
ncbi_mult_taxo_gbnm(153317, 'heart-podded hoary cress').
ncbi_mult_taxo_gbnm(153620, 'red grouper').
ncbi_mult_taxo_gbnm(153621, 'black grouper').
ncbi_mult_taxo_gbnm(153633, 'swallow-tailed hummingbird').
ncbi_mult_taxo_gbnm(153643, 'Abyssinian ground-hornbill').
ncbi_mult_taxo_gbnm(153645, 'Southern yellow-billed hornbill').
ncbi_mult_taxo_gbnm(153659, 'annual honesty').
ncbi_mult_taxo_gbnm(153828, 'willow leaf beetle').
ncbi_mult_taxo_gbnm(153974, 'grain thrips').
ncbi_mult_taxo_gbnm(153979, 'banded greenhouse thrips').
ncbi_mult_taxo_gbnm(154011, 'daikon leaf beetle').
ncbi_mult_taxo_gbnm(154017, 'willow leaf beetle').
ncbi_mult_taxo_gbnm(154029, 'bluetip coral').
ncbi_mult_taxo_gbnm(154032, 'Grand Cayman limia').
ncbi_mult_taxo_gbnm(154033, 'Tiburon Peninsula limia').
ncbi_mult_taxo_gbnm(154034, 'blackbelly limia').
ncbi_mult_taxo_gbnm(154035, 'blackbanded limia').
ncbi_mult_taxo_gbnm(154036, 'few-rayed limia').
ncbi_mult_taxo_gbnm(154040, 'varicolored limia').
ncbi_mult_taxo_gbnm(154041, 'Cuban limia').
ncbi_mult_taxo_gbnm(154042, 'striped limia').
ncbi_mult_taxo_gbnm(154334, 'Rhesus rhadinovirus').
ncbi_mult_taxo_gbnm(154348, 'eightbarbel loach').
ncbi_mult_taxo_gbnm(154428, 'drunkard\'s dream').
ncbi_mult_taxo_gbnm(154467, 'peach palm').
ncbi_mult_taxo_gbnm(154493, 'sea pea').
ncbi_mult_taxo_gbnm(154494, 'perennial pea').
ncbi_mult_taxo_gbnm(154497, 'reddish tufted vetch').
ncbi_mult_taxo_gbnm(154550, megrim).
ncbi_mult_taxo_gbnm(154579, 'black salamander').
ncbi_mult_taxo_gbnm(154580, 'Sacramento mountain salamander').
ncbi_mult_taxo_gbnm(154581, 'western tan-backed salamander').
ncbi_mult_taxo_gbnm(154582, 'Fourche Mountain salamander').
ncbi_mult_taxo_gbnm(154583, 'valley and ridge salamander').
ncbi_mult_taxo_gbnm(154584, 'Larch Mountain salamander').
ncbi_mult_taxo_gbnm(154585, 'Jemez Mountains salamander').
ncbi_mult_taxo_gbnm(154586, 'Rich Mountain salamander').
ncbi_mult_taxo_gbnm(154587, 'Pigeon Mountain salamander').
ncbi_mult_taxo_gbnm(154588, 'ravine salamander').
ncbi_mult_taxo_gbnm(154589, 'southern red-backed salamander').
ncbi_mult_taxo_gbnm(154590, 'Siskiyou Mountains salamander').
ncbi_mult_taxo_gbnm(154591, 'southern Appalachian salamander').
ncbi_mult_taxo_gbnm(154592, 'Washington salamander').
ncbi_mult_taxo_gbnm(154593, 'western red-backed salamander').
ncbi_mult_taxo_gbnm(154594, 'Wehrle\'s salamander').
ncbi_mult_taxo_gbnm(154595, 'spot-bellied salamander').
ncbi_mult_taxo_gbnm(154620, 'orange gumdrop sea slug').
ncbi_mult_taxo_gbnm(154765, 'Napier grass').
ncbi_mult_taxo_gbnm(154811, 'river carpsucker').
ncbi_mult_taxo_gbnm(154813, 'blue sucker').
ncbi_mult_taxo_gbnm(154815, 'creek chubsucker').
ncbi_mult_taxo_gbnm(154816, 'Siamese algae-eater').
ncbi_mult_taxo_gbnm(154817, 'silver redhorse').
ncbi_mult_taxo_gbnm(154819, 'spotted sucker').
ncbi_mult_taxo_gbnm(154820, 'river redhorse').
ncbi_mult_taxo_gbnm(154821, 'blacktail redhorse').
ncbi_mult_taxo_gbnm(154822, 'bigeye jumprock').
ncbi_mult_taxo_gbnm(154823, 'blacktip jumprock').
ncbi_mult_taxo_gbnm(154825, 'torrent sucker').
ncbi_mult_taxo_gbnm(154827, 'razorback sucker').
ncbi_mult_taxo_gbnm(154954, 'pink cusk-eel').
ncbi_mult_taxo_gbnm(155021, bibhitaki).
ncbi_mult_taxo_gbnm(155022, 'chebulic myrobalan').
ncbi_mult_taxo_gbnm(155035, 'Hardwicke\'s woolly bat').
ncbi_mult_taxo_gbnm(155036, 'sucker-footed bats').
ncbi_mult_taxo_gbnm(155040, 'Mexican greater funnel-eared bat').
ncbi_mult_taxo_gbnm(155061, 'North Caucasian bleak').
ncbi_mult_taxo_gbnm(155062, 'Danube bleak').
ncbi_mult_taxo_gbnm(155063, 'Amur ide').
ncbi_mult_taxo_gbnm(155064, 'Schmidt\'s dace').
ncbi_mult_taxo_gbnm(155067, 'vimba bream').
ncbi_mult_taxo_gbnm(155072, 'blackbrow bleak').
ncbi_mult_taxo_gbnm(155073, 'white-eye bream').
ncbi_mult_taxo_gbnm(155074, 'blue bream').
ncbi_mult_taxo_gbnm(155086, 'southern ground hornbill').
ncbi_mult_taxo_gbnm(155165, 'northern blue').
ncbi_mult_taxo_gbnm(155166, 'Idas blue').
ncbi_mult_taxo_gbnm(155167, 'orange-bordered blue').
ncbi_mult_taxo_gbnm(155173, 'western hardyhead').
ncbi_mult_taxo_gbnm(155216, 'Jenny creek sucker').
ncbi_mult_taxo_gbnm(155217, 'Klamath largescale sucker').
ncbi_mult_taxo_gbnm(155299, 'aromatic litsea').
ncbi_mult_taxo_gbnm(155308, 'brown forest skink').
ncbi_mult_taxo_gbnm(155309, 'Central American mabuya').
ncbi_mult_taxo_gbnm(155310, 'Guinea mabuya').
ncbi_mult_taxo_gbnm(155313, 'tropical mabuya').
ncbi_mult_taxo_gbnm(155315, 'gold-spotted mabuya').
ncbi_mult_taxo_gbnm(155317, 'sandfish skink').
ncbi_mult_taxo_gbnm(155319, 'ground skink').
ncbi_mult_taxo_gbnm(155323, 'pine moth').
ncbi_mult_taxo_gbnm(155640, chinaberry).
ncbi_mult_taxo_gbnm(155717, 'northern catalpa').
ncbi_mult_taxo_gbnm(156149, 'Florida torreya').
ncbi_mult_taxo_gbnm(156167, 'variable pitohui').
ncbi_mult_taxo_gbnm(156433, 'Christmas coral').
ncbi_mult_taxo_gbnm(156483, boarwood).
ncbi_mult_taxo_gbnm(156548, 'rusty-breasted tit').
ncbi_mult_taxo_gbnm(156559, 'white-browed tit').
ncbi_mult_taxo_gbnm(156563, 'blue tit').
ncbi_mult_taxo_gbnm(156565, 'crested tit').
ncbi_mult_taxo_gbnm(156567, 'Coal Tit').
ncbi_mult_taxo_gbnm(156569, 'Eurasian penduline-tit').
ncbi_mult_taxo_gbnm(156570, 'azure tit').
ncbi_mult_taxo_gbnm(156573, 'Elegant tit').
ncbi_mult_taxo_gbnm(156574, 'black-crested tit').
ncbi_mult_taxo_gbnm(156590, 'large-headed grasshopper').
ncbi_mult_taxo_gbnm(156692, 'Texas shiner').
ncbi_mult_taxo_gbnm(156693, 'comely shiner').
ncbi_mult_taxo_gbnm(156694, 'popeye shiner').
ncbi_mult_taxo_gbnm(156695, 'bigeye shiner').
ncbi_mult_taxo_gbnm(156696, 'silverside shiner').
ncbi_mult_taxo_gbnm(156697, 'fluvial shiner').
ncbi_mult_taxo_gbnm(156698, 'Arkansas River shiner').
ncbi_mult_taxo_gbnm(156699, 'Rio Grande shiner').
ncbi_mult_taxo_gbnm(156700, 'Ozark minnow').
ncbi_mult_taxo_gbnm(156701, 'sharpnose shiner').
ncbi_mult_taxo_gbnm(156702, 'peppered shiner').
ncbi_mult_taxo_gbnm(156703, 'silver shiner').
ncbi_mult_taxo_gbnm(156704, 'sandbar shiner').
ncbi_mult_taxo_gbnm(156705, 'silverstripe shiner').
ncbi_mult_taxo_gbnm(156706, 'rocky shiner').
ncbi_mult_taxo_gbnm(156707, 'telescope shiner').
ncbi_mult_taxo_gbnm(156708, 'weed shiner').
ncbi_mult_taxo_gbnm(156757, 'Swainson\'s hawk').
ncbi_mult_taxo_gbnm(156760, 'Galapagos penguin').
ncbi_mult_taxo_gbnm(156766, 'buff-spotted flufftail').
ncbi_mult_taxo_gbnm(156851, 'brown widow').
ncbi_mult_taxo_gbnm(156870, 'Kampira Falls frog').
ncbi_mult_taxo_gbnm(156871, 'moor frog').
ncbi_mult_taxo_gbnm(156873, 'broad-folded frog').
ncbi_mult_taxo_gbnm(156874, 'Tschudi\'s Caribbean toad').
ncbi_mult_taxo_gbnm(156875, 'Guenther\'s Caribbean toad').
ncbi_mult_taxo_gbnm(156876, 'Cuban high-crested toad').
ncbi_mult_taxo_gbnm(156877, 'Cuban long-nosed toad').
ncbi_mult_taxo_gbnm(156878, 'Cuban spotted toad').
ncbi_mult_taxo_gbnm(156879, 'Cuban small-eared toad').
ncbi_mult_taxo_gbnm(156880, 'yellow toad').
ncbi_mult_taxo_gbnm(156899, 'Linnaeus\' lance skink').
ncbi_mult_taxo_gbnm(156901, 'slendertail lance skink').
ncbi_mult_taxo_gbnm(156903, 'coastal legless skink').
ncbi_mult_taxo_gbnm(156983, 'Asian redtail catfish').
ncbi_mult_taxo_gbnm(156985, 'shortnose sucker').
ncbi_mult_taxo_gbnm(156987, 'Longdong stream salamander').
ncbi_mult_taxo_gbnm(156988, 'Western Chinese mountain salamander').
ncbi_mult_taxo_gbnm(156989, 'Tibetan mountain salamander').
ncbi_mult_taxo_gbnm(156990, 'Yenyuan stream salamander').
ncbi_mult_taxo_gbnm(156992, 'Wushan salamander').
ncbi_mult_taxo_gbnm(157061, mandi).
ncbi_mult_taxo_gbnm(157104, 'Chiala Mountain salamander').
ncbi_mult_taxo_gbnm(157105, 'Taibai stream salamander').
ncbi_mult_taxo_gbnm(157107, 'yellow-spotted salamander').
ncbi_mult_taxo_gbnm(157167, 'Cherskii\'s sculpin').
ncbi_mult_taxo_gbnm(157241, 'Thor\'s scaldfish').
ncbi_mult_taxo_gbnm(157259, 'Spanish wood marjoram').
ncbi_mult_taxo_gbnm(157363, 'Korean hard clam').
ncbi_mult_taxo_gbnm(157371, 'fivebar swordtail').
ncbi_mult_taxo_gbnm(157519, 'eastern teaberry').
ncbi_mult_taxo_gbnm(157549, 'Fonseca\'s lancehead').
ncbi_mult_taxo_gbnm(157552, 'Sao Paulo lancehead').
ncbi_mult_taxo_gbnm(157584, 'ocean surgeon').
ncbi_mult_taxo_gbnm(157585, 'blue tang surgeonfish').
ncbi_mult_taxo_gbnm(157586, 'Iranian long-legged frog').
ncbi_mult_taxo_gbnm(157668, 'Przewalski\'s gazelle').
ncbi_mult_taxo_gbnm(157729, 'small rock oyster').
ncbi_mult_taxo_gbnm(157794, 'Japanese oak').
ncbi_mult_taxo_gbnm(157887, 'yellowcheek darter').
ncbi_mult_taxo_gbnm(157888, 'bayou darter').
ncbi_mult_taxo_gbnm(157889, 'redline darter').
ncbi_mult_taxo_gbnm(157914, 'Indian jujube').
ncbi_mult_taxo_gbnm(158049, 'northern shrike').
ncbi_mult_taxo_gbnm(158052, 'Black-billed magpie').
ncbi_mult_taxo_gbnm(158098, 'billion-dollar grass').
ncbi_mult_taxo_gbnm(158149, 'seashore paspalum').
ncbi_mult_taxo_gbnm(158159, palmgrass).
ncbi_mult_taxo_gbnm(158174, 'para grass').
ncbi_mult_taxo_gbnm(158199, 'golden darter').
ncbi_mult_taxo_gbnm(158200, 'Tippecanoe darter').
ncbi_mult_taxo_gbnm(158437, 'bizarre caddisflies').
ncbi_mult_taxo_gbnm(158449, 'Siamese fighting fishes').
ncbi_mult_taxo_gbnm(158451, 'paradise fish').
ncbi_mult_taxo_gbnm(158452, 'roundtail paradisefish').
ncbi_mult_taxo_gbnm(158454, 'pygmy gourami').
ncbi_mult_taxo_gbnm(158456, 'Siamese fighting fish').
ncbi_mult_taxo_gbnm(158538, 'European birthwort').
ncbi_mult_taxo_gbnm(158541, 'slender Dutchman\'s pipe').
ncbi_mult_taxo_gbnm(158555, 'Manchurian Dutchmanspipe').
ncbi_mult_taxo_gbnm(158587, 'bay scallop').
ncbi_mult_taxo_gbnm(158618, 'cardinal quelea').
ncbi_mult_taxo_gbnm(158687, 'Melissa blue butterfly').
ncbi_mult_taxo_gbnm(158688, 'Karner blue butterfly').
ncbi_mult_taxo_gbnm(158766, 'longfin tilapia').
ncbi_mult_taxo_gbnm(158779, 'spotted tilapia').
ncbi_mult_taxo_gbnm(158804, 'Ringneck snake').
ncbi_mult_taxo_gbnm(158814, 'common box turtle').
ncbi_mult_taxo_gbnm(158815, 'Coahuilan box turtle').
ncbi_mult_taxo_gbnm(158816, 'spotted box turtle').
ncbi_mult_taxo_gbnm(158894, 'three spotted tilapia').
ncbi_mult_taxo_gbnm(159053, 'wood-apple').
ncbi_mult_taxo_gbnm(159077, 'straightnose pipefish').
ncbi_mult_taxo_gbnm(159078, 'Mt. Hermon field mouse').
ncbi_mult_taxo_gbnm(159094, 'Flat-tail horned lizard').
ncbi_mult_taxo_gbnm(159164, 'Leeward blindsnake').
ncbi_mult_taxo_gbnm(159165, 'Hispaniola worm snake').
ncbi_mult_taxo_gbnm(159166, 'Bahaman slender blindsnake').
ncbi_mult_taxo_gbnm(159168, 'Dominican worm snake').
ncbi_mult_taxo_gbnm(159169, 'Grant\'s worm snake').
ncbi_mult_taxo_gbnm(159170, 'Guadeloupe worm snake').
ncbi_mult_taxo_gbnm(159172, 'Puerto Rican coastal blindsnake').
ncbi_mult_taxo_gbnm(159174, 'Luzon worm snake').
ncbi_mult_taxo_gbnm(159175, 'Montiserrat worm snake').
ncbi_mult_taxo_gbnm(159176, 'flathead worm snake').
ncbi_mult_taxo_gbnm(159184, 'Atlantic coast slimy salamander').
ncbi_mult_taxo_gbnm(159185, 'California slender salamander').
ncbi_mult_taxo_gbnm(159187, 'Santa Cecilia cochran frog').
ncbi_mult_taxo_gbnm(159190, 'Tukeit Hill frog').
ncbi_mult_taxo_gbnm(159298, 'Antarctic hairgrass').
ncbi_mult_taxo_gbnm(159326, 'Lesser large-footed bat').
ncbi_mult_taxo_gbnm(159327, 'Hairy-legged myotis').
ncbi_mult_taxo_gbnm(159339, 'Greater asiatic yellow house bat').
ncbi_mult_taxo_gbnm(159417, 'light-bulb sea squirt').
ncbi_mult_taxo_gbnm(159452, 'northern snubnose garfish').
ncbi_mult_taxo_gbnm(159453, 'Eastern sea garfish').
ncbi_mult_taxo_gbnm(159454, 'southern sea garfish').
ncbi_mult_taxo_gbnm(159457, 'Santa Rita beaked toad').
ncbi_mult_taxo_gbnm(159458, 'Mesopotamia beaked toad').
ncbi_mult_taxo_gbnm(159581, veery).
ncbi_mult_taxo_gbnm(159712, 'yellowhead wrasse').
ncbi_mult_taxo_gbnm(159713, 'threespot damselfish').
ncbi_mult_taxo_gbnm(159715, 'Patagonian rockcod').
ncbi_mult_taxo_gbnm(159716, 'pike icefish').
ncbi_mult_taxo_gbnm(159718, 'Carbonell\'s wall lizard').
ncbi_mult_taxo_gbnm(159722, 'California dune trapdoor spider').
ncbi_mult_taxo_gbnm(159850, 'Lozano\'s goby').
ncbi_mult_taxo_gbnm(159852, 'four-spotted goby').
ncbi_mult_taxo_gbnm(159856, 'Java warty pig').
ncbi_mult_taxo_gbnm(159858, 'least horseshoe bat').
ncbi_mult_taxo_gbnm(159956, 'cotton harlequin bug').
ncbi_mult_taxo_gbnm(159957, 'plague thrips').
ncbi_mult_taxo_gbnm(159970, 'scaly-winged barklice').
ncbi_mult_taxo_gbnm(159975, 'lizard barklice').
ncbi_mult_taxo_gbnm(159981, 'marten tapeworm').
ncbi_mult_taxo_gbnm(160021, 'rough keyhole limpet').
ncbi_mult_taxo_gbnm(160060, 'hummingbird lice').
ncbi_mult_taxo_gbnm(160097, 'cattle chewing louse').
ncbi_mult_taxo_gbnm(160123, 'cat louse').
ncbi_mult_taxo_gbnm(160133, 'elephant louse').
ncbi_mult_taxo_gbnm(160140, 'armoured lice').
ncbi_mult_taxo_gbnm(160145, 'spiny rat lice').
ncbi_mult_taxo_gbnm(160206, 'slender duck louse').
ncbi_mult_taxo_gbnm(160221, 'brooding anemone').
ncbi_mult_taxo_gbnm(160222, 'Ambrana Madagascar frog').
ncbi_mult_taxo_gbnm(160399, 'Coues\' Oryzomys').
ncbi_mult_taxo_gbnm(160400, 'meadow jumping mouse').
ncbi_mult_taxo_gbnm(160448, 'Golden-bellied Water Rat').
ncbi_mult_taxo_gbnm(160449, 'mountain water rat').
ncbi_mult_taxo_gbnm(160493, 'blue eyes').
ncbi_mult_taxo_gbnm(160495, 'Pacific blue-eye').
ncbi_mult_taxo_gbnm(160496, 'red-legged frog').
ncbi_mult_taxo_gbnm(160499, 'yellow-legged frog').
ncbi_mult_taxo_gbnm(160500, 'mountain yellow-legged frog').
ncbi_mult_taxo_gbnm(160513, 'stink bugs').
ncbi_mult_taxo_gbnm(160542, 'Pacific mutton hamlet').
ncbi_mult_taxo_gbnm(160543, 'rivulated mutton hamlet').
ncbi_mult_taxo_gbnm(160595, 'Southern right whale').
ncbi_mult_taxo_gbnm(160702, 'slender grouper').
ncbi_mult_taxo_gbnm(160704, graysby).
ncbi_mult_taxo_gbnm(160705, coney).
ncbi_mult_taxo_gbnm(160707, 'Pacific graysby').
ncbi_mult_taxo_gbnm(160708, 'tomato hind').
ncbi_mult_taxo_gbnm(160709, 'darkfin hind').
ncbi_mult_taxo_gbnm(160710, 'leather bass').
ncbi_mult_taxo_gbnm(160712, 'rooster hind').
ncbi_mult_taxo_gbnm(160713, 'rock hind').
ncbi_mult_taxo_gbnm(160714, 'spotted grouper').
ncbi_mult_taxo_gbnm(160715, 'areolate grouper').
ncbi_mult_taxo_gbnm(160717, 'speckled hind').
ncbi_mult_taxo_gbnm(160718, 'blacktip grouper').
ncbi_mult_taxo_gbnm(160719, 'yellowedge grouper').
ncbi_mult_taxo_gbnm(160720, 'red hind').
ncbi_mult_taxo_gbnm(160721, itajara).
ncbi_mult_taxo_gbnm(160722, 'starry grouper').
ncbi_mult_taxo_gbnm(160723, 'misty grouper').
ncbi_mult_taxo_gbnm(160724, 'Warsaw grouper').
ncbi_mult_taxo_gbnm(160725, 'star-studded grouper').
ncbi_mult_taxo_gbnm(160726, 'snowy grouper').
ncbi_mult_taxo_gbnm(160727, 'Nassau grouper').
ncbi_mult_taxo_gbnm(160728, 'wavy-lined grouper').
ncbi_mult_taxo_gbnm(160729, 'Gulf grouper').
ncbi_mult_taxo_gbnm(160730, scamp).
ncbi_mult_taxo_gbnm(160731, 'leopard grouper').
ncbi_mult_taxo_gbnm(160733, 'Pacific creole-fish').
ncbi_mult_taxo_gbnm(160734, 'leopard coralgrouper').
ncbi_mult_taxo_gbnm(160735, 'spotted coralgrouper').
ncbi_mult_taxo_gbnm(160736, 'yellowfin grouper').
ncbi_mult_taxo_gbnm(160740, 'threadfin bass').
ncbi_mult_taxo_gbnm(160742, 'greater soapfish').
ncbi_mult_taxo_gbnm(160745, 'variable tilapia').
ncbi_mult_taxo_gbnm(160755, 'black siskin').
ncbi_mult_taxo_gbnm(160756, 'black-chinned siskin').
ncbi_mult_taxo_gbnm(160757, 'Eurasian linnet').
ncbi_mult_taxo_gbnm(160760, 'Eurasian siskin').
ncbi_mult_taxo_gbnm(160761, 'yellow-throated bunting').
ncbi_mult_taxo_gbnm(160765, 'Lake Candidus dace').
ncbi_mult_taxo_gbnm(160801, 'Jipe tilapia').
ncbi_mult_taxo_gbnm(160818, 'dark-banded rockfish').
ncbi_mult_taxo_gbnm(160963, 'surf bream').
ncbi_mult_taxo_gbnm(161132, 'sailfin grouper').
ncbi_mult_taxo_gbnm(161140, 'Burmeister\'s anole').
ncbi_mult_taxo_gbnm(161221, 'Australian paper wasp').
ncbi_mult_taxo_gbnm(161255, 'viburnum leaf beetle').
ncbi_mult_taxo_gbnm(161274, 'large-webbed bell toad').
ncbi_mult_taxo_gbnm(161276, 'Wami tilapia').
ncbi_mult_taxo_gbnm(161448, 'scribbled pipefish').
ncbi_mult_taxo_gbnm(161450, 'bluestripe pipefish').
ncbi_mult_taxo_gbnm(161453, 'ringed pipefish').
ncbi_mult_taxo_gbnm(161455, 'snake pipefish').
ncbi_mult_taxo_gbnm(161456, 'blackspotted stickleback').
ncbi_mult_taxo_gbnm(161458, 'Gray\'s pipefish').
ncbi_mult_taxo_gbnm(161460, 'beady pipefish').
ncbi_mult_taxo_gbnm(161462, 'knife-snouted pipefish').
ncbi_mult_taxo_gbnm(161466, 'short-tailed pipefish').
ncbi_mult_taxo_gbnm(161467, 'opossum pipefish').
ncbi_mult_taxo_gbnm(161469, 'common seadragon').
ncbi_mult_taxo_gbnm(161471, 'pug-nosed pipefish').
ncbi_mult_taxo_gbnm(161473, 'Hardwicke\'s pipefish').
ncbi_mult_taxo_gbnm(161495, 'long-leaved groundcherry').
ncbi_mult_taxo_gbnm(161496, 'white-throated guenon').
ncbi_mult_taxo_gbnm(161581, 'spotted pipefish').
ncbi_mult_taxo_gbnm(161582, 'wide-bodied pipefish').
ncbi_mult_taxo_gbnm(161583, 'black-striped pipefish').
ncbi_mult_taxo_gbnm(161584, 'greater pipefish').
ncbi_mult_taxo_gbnm(161585, 'dusky pipefish').
ncbi_mult_taxo_gbnm(161586, 'northern pipefish').
ncbi_mult_taxo_gbnm(161587, 'bay pipefish').
ncbi_mult_taxo_gbnm(161588, 'chain pipefish').
ncbi_mult_taxo_gbnm(161589, 'Nilsson\'s pipefish').
ncbi_mult_taxo_gbnm(161590, 'Gulf pipefish').
ncbi_mult_taxo_gbnm(161591, 'darkflank pipefish').
ncbi_mult_taxo_gbnm(161592, 'broad-nosed pipefish').
ncbi_mult_taxo_gbnm(161596, 'Port Phillip pipefish').
ncbi_mult_taxo_gbnm(161597, 'Australian long-snouted pipefish').
ncbi_mult_taxo_gbnm(161624, 'Savannah sparrow').
ncbi_mult_taxo_gbnm(161648, 'cedar waxwing').
ncbi_mult_taxo_gbnm(161655, 'black-rayed soft-shelled turtle').
ncbi_mult_taxo_gbnm(161680, 'black-tailed godwit').
ncbi_mult_taxo_gbnm(161683, 'bar-tailed godwit').
ncbi_mult_taxo_gbnm(161697, 'eastern spadefoot toads').
ncbi_mult_taxo_gbnm(161698, 'Chapa spadefoot toad').
ncbi_mult_taxo_gbnm(161704, 'false ornate narrow-mouthed frog').
ncbi_mult_taxo_gbnm(161706, 'Reinwardt\'s flying frog').
ncbi_mult_taxo_gbnm(161707, 'small rough-armed tree frog').
ncbi_mult_taxo_gbnm(161718, 'wattle-necked softshell turtle').
ncbi_mult_taxo_gbnm(161739, 'Lesser yellowlegs').
ncbi_mult_taxo_gbnm(161766, 'golden damselfish').
ncbi_mult_taxo_gbnm(161767, 'orange clownfish').
ncbi_mult_taxo_gbnm(161768, 'tube-making caddisflies').
ncbi_mult_taxo_gbnm(161855, 'Mocquard\'s rain frog').
ncbi_mult_taxo_gbnm(161856, 'climbing frogs').
ncbi_mult_taxo_gbnm(161857, 'mountain climbing frog').
ncbi_mult_taxo_gbnm(161898, 'blue chromis').
ncbi_mult_taxo_gbnm(161900, 'half-and-half chromis').
ncbi_mult_taxo_gbnm(161903, 'canary wrasse').
ncbi_mult_taxo_gbnm(161905, 'Garibaldi damselfish').
ncbi_mult_taxo_gbnm(161907, 'immaculate damsel').
ncbi_mult_taxo_gbnm(161909, 'yellowtail damselfish').
ncbi_mult_taxo_gbnm(161910, 'multispine damselfish').
ncbi_mult_taxo_gbnm(161912, 'big-scale parma').
ncbi_mult_taxo_gbnm(161913, 'charcoal damsel').
ncbi_mult_taxo_gbnm(161914, 'ocellate damselfish').
ncbi_mult_taxo_gbnm(161915, 'dusky damselfish').
ncbi_mult_taxo_gbnm(161916, 'cocoa damselfish').
ncbi_mult_taxo_gbnm(161921, 'Guadalupe fur seal').
ncbi_mult_taxo_gbnm(161927, 'Juan Fernandez fur seal').
ncbi_mult_taxo_gbnm(161928, 'South American fur seal').
ncbi_mult_taxo_gbnm(161930, 'Australian sea lion').
ncbi_mult_taxo_gbnm(161932, 'South American sea lion').
ncbi_mult_taxo_gbnm(161940, 'snake-eyed skink').
ncbi_mult_taxo_gbnm(161945, 'White\'s rock-skink').
ncbi_mult_taxo_gbnm(161946, 'Eastern skink').
ncbi_mult_taxo_gbnm(161960, 'Cape Verde giant skink').
ncbi_mult_taxo_gbnm(162018, 'swamp loosestrife').
ncbi_mult_taxo_gbnm(162026, 'Guatemalan chulin').
ncbi_mult_taxo_gbnm(162147, 'silver catfish').
ncbi_mult_taxo_gbnm(162252, fairyflies).
ncbi_mult_taxo_gbnm(162300, 'Malabar grouper').
ncbi_mult_taxo_gbnm(162310, 'Delicate laucha').
ncbi_mult_taxo_gbnm(162354, 'common gliding lizard').
ncbi_mult_taxo_gbnm(162355, 'Timor flying dragon').
ncbi_mult_taxo_gbnm(162384, 'large kissing bug').
ncbi_mult_taxo_gbnm(162489, 'mouse catshark').
ncbi_mult_taxo_gbnm(162715, mopane).
ncbi_mult_taxo_gbnm(162772, 'ordeal-tree').
ncbi_mult_taxo_gbnm(162785, agba).
ncbi_mult_taxo_gbnm(162890, 'tipa colorada').
ncbi_mult_taxo_gbnm(162956, 'Sichuan sika deer').
ncbi_mult_taxo_gbnm(162957, 'emerald darter').
ncbi_mult_taxo_gbnm(162958, 'splendid darter').
ncbi_mult_taxo_gbnm(162959, 'warrior darter').
ncbi_mult_taxo_gbnm(162960, 'blenny darter').
ncbi_mult_taxo_gbnm(162961, 'holiday darter').
ncbi_mult_taxo_gbnm(162962, 'vermillion darter').
ncbi_mult_taxo_gbnm(162963, 'coastal darter').
ncbi_mult_taxo_gbnm(162964, 'Coosa darter').
ncbi_mult_taxo_gbnm(162965, 'black darter').
ncbi_mult_taxo_gbnm(162966, 'cherry darter').
ncbi_mult_taxo_gbnm(162967, 'saffron darter').
ncbi_mult_taxo_gbnm(162968, 'turquoise darter').
ncbi_mult_taxo_gbnm(162969, 'Tombigbee darter').
ncbi_mult_taxo_gbnm(162970, 'brighteye darter').
ncbi_mult_taxo_gbnm(162971, 'firebelly darter').
ncbi_mult_taxo_gbnm(162972, 'Kentucky darter').
ncbi_mult_taxo_gbnm(162973, 'Alabama darter').
ncbi_mult_taxo_gbnm(162974, 'Yazoo darter').
ncbi_mult_taxo_gbnm(162975, 'rock darter').
ncbi_mult_taxo_gbnm(162976, 'Cherokee darter').
ncbi_mult_taxo_gbnm(162978, 'snubnose darter').
ncbi_mult_taxo_gbnm(162980, 'Missouri saddled darter').
ncbi_mult_taxo_gbnm(162981, 'seagreen darter').
ncbi_mult_taxo_gbnm(162982, 'variegate darter').
ncbi_mult_taxo_gbnm(162983, 'bandfin darter').
ncbi_mult_taxo_gbnm(162989, 'Tallapoosa darter').
ncbi_mult_taxo_gbnm(163077, 'scarlet cordia').
ncbi_mult_taxo_gbnm(163078, 'kerosene tree').
ncbi_mult_taxo_gbnm(163112, ling).
ncbi_mult_taxo_gbnm(163113, 'phycid hakes').
ncbi_mult_taxo_gbnm(163117, 'tadpole fish').
ncbi_mult_taxo_gbnm(163118, 'roundnose grenadier').
ncbi_mult_taxo_gbnm(163121, 'starspotted grouper').
ncbi_mult_taxo_gbnm(163124, 'melon seed').
ncbi_mult_taxo_gbnm(163131, 'Jarbua terapon').
ncbi_mult_taxo_gbnm(163132, 'largescaled terapon').
ncbi_mult_taxo_gbnm(163134, 'barred knifejaw').
ncbi_mult_taxo_gbnm(163135, 'spotted knifejaw').
ncbi_mult_taxo_gbnm(163137, 'barred flagtail').
ncbi_mult_taxo_gbnm(163139, 'yellowstripe butterfish').
ncbi_mult_taxo_gbnm(163141, 'silver sweep').
ncbi_mult_taxo_gbnm(163143, 'brassy chub').
ncbi_mult_taxo_gbnm(163144, 'blue seachub').
ncbi_mult_taxo_gbnm(163146, stripey).
ncbi_mult_taxo_gbnm(163149, 'largescale blackfish').
ncbi_mult_taxo_gbnm(163159, 'oriental rat flea').
ncbi_mult_taxo_gbnm(163496, 'black kingsnake').
ncbi_mult_taxo_gbnm(163626, 'threespot torpedo').
ncbi_mult_taxo_gbnm(163632, 'notchtongue goby').
ncbi_mult_taxo_gbnm(163637, 'spindle hap').
ncbi_mult_taxo_gbnm(163806, 'coppercheek darter').
ncbi_mult_taxo_gbnm(163807, 'amber darter').
ncbi_mult_taxo_gbnm(163808, 'tangerine darter').
ncbi_mult_taxo_gbnm(163809, 'goldline darter').
ncbi_mult_taxo_gbnm(163810, 'pearl darter').
ncbi_mult_taxo_gbnm(163811, 'southern logperch').
ncbi_mult_taxo_gbnm(163812, 'coal darter').
ncbi_mult_taxo_gbnm(163813, 'blotchside darter').
ncbi_mult_taxo_gbnm(163814, 'Texas logperch').
ncbi_mult_taxo_gbnm(163815, 'piedmont darter').
ncbi_mult_taxo_gbnm(163816, 'bluestripe darter').
ncbi_mult_taxo_gbnm(163817, 'Appalachia darter').
ncbi_mult_taxo_gbnm(163818, 'Conasauga logperch').
ncbi_mult_taxo_gbnm(163819, 'Mobile logperch').
ncbi_mult_taxo_gbnm(163820, 'freckled darter').
ncbi_mult_taxo_gbnm(163821, 'longhead darter').
ncbi_mult_taxo_gbnm(163822, 'bigscale logperch').
ncbi_mult_taxo_gbnm(163823, 'shield darter').
ncbi_mult_taxo_gbnm(163825, 'blackbanded darter').
ncbi_mult_taxo_gbnm(163826, 'stripeback darter').
ncbi_mult_taxo_gbnm(163827, 'sharpnose darter').
ncbi_mult_taxo_gbnm(163828, 'bronze darter').
ncbi_mult_taxo_gbnm(163829, 'leopard darter').
ncbi_mult_taxo_gbnm(163830, 'Roanoke logperch').
ncbi_mult_taxo_gbnm(163831, 'Roanoke darter').
ncbi_mult_taxo_gbnm(163832, 'dusky darter').
ncbi_mult_taxo_gbnm(163833, 'river darter').
ncbi_mult_taxo_gbnm(163834, 'olive darter').
ncbi_mult_taxo_gbnm(163835, 'gulf logperch').
ncbi_mult_taxo_gbnm(163836, 'snail darter').
ncbi_mult_taxo_gbnm(163837, 'stargazing darter').
ncbi_mult_taxo_gbnm(163838, 'saddleback darter').
ncbi_mult_taxo_gbnm(163845, 'white-bellied canary').
ncbi_mult_taxo_gbnm(163847, 'Yellow canary').
ncbi_mult_taxo_gbnm(163849, 'Cape canary').
ncbi_mult_taxo_gbnm(163863, 'mountain leaf-warbler').
ncbi_mult_taxo_gbnm(163865, 'lemon-throated leaf-warbler').
ncbi_mult_taxo_gbnm(163991, 'suckermouth catfish').
ncbi_mult_taxo_gbnm(163992, 'armored catfish').
ncbi_mult_taxo_gbnm(164003, 'zucchini catfish').
ncbi_mult_taxo_gbnm(164018, 'crested oarfish').
ncbi_mult_taxo_gbnm(164022, 'Morelos false brook salamander').
ncbi_mult_taxo_gbnm(164023, 'Cochran\'s false brook salamander').
ncbi_mult_taxo_gbnm(164026, 'longtail false brook salamander').
ncbi_mult_taxo_gbnm(164030, 'Smith\'s false brook salamander').
ncbi_mult_taxo_gbnm(164033, 'Werler\'s false brook salamander').
ncbi_mult_taxo_gbnm(164113, calamondin).
ncbi_mult_taxo_gbnm(164278, 'Azuay stubfoot toad').
ncbi_mult_taxo_gbnm(164282, 'tiny tree toad').
ncbi_mult_taxo_gbnm(164287, 'Tornier\'s forest toad').
ncbi_mult_taxo_gbnm(164288, 'Napo plump toad').
ncbi_mult_taxo_gbnm(164289, 'Peracca\'s plump toad').
ncbi_mult_taxo_gbnm(164291, 'Asian tree toads').
ncbi_mult_taxo_gbnm(164293, 'flathead toads').
ncbi_mult_taxo_gbnm(164294, 'Zamboanga flathead toad').
ncbi_mult_taxo_gbnm(164295, 'Matang stream toad').
ncbi_mult_taxo_gbnm(164302, 'pumpkin toadlet').
ncbi_mult_taxo_gbnm(164308, 'shore clingfish').
ncbi_mult_taxo_gbnm(164309, 'Cornish sucker').
ncbi_mult_taxo_gbnm(164310, 'Thao Asian toad').
ncbi_mult_taxo_gbnm(164324, 'Mt Carmel blind mole rat').
ncbi_mult_taxo_gbnm(164328, 'sudden oak death agent').
ncbi_mult_taxo_gbnm(164384, 'Sichuan vole').
ncbi_mult_taxo_gbnm(164385, 'Marie\'s vole').
ncbi_mult_taxo_gbnm(164387, 'lobetoothed piranha').
ncbi_mult_taxo_gbnm(164405, 'tea tree').
ncbi_mult_taxo_gbnm(164517, 'Zinser\'s pocket gopher').
ncbi_mult_taxo_gbnm(164605, 'California roach').
ncbi_mult_taxo_gbnm(164606, 'Sacramento pikeminnow').
ncbi_mult_taxo_gbnm(164610, 'Arizona woodrat').
ncbi_mult_taxo_gbnm(164618, 'Sao Paulo leaf frog').
ncbi_mult_taxo_gbnm(164628, 'blue-black grosbeak').
ncbi_mult_taxo_gbnm(164646, 'New World blackbirds, orioles and allies').
ncbi_mult_taxo_gbnm(164648, 'western red colobus').
ncbi_mult_taxo_gbnm(164674, 'willow flycatcher').
ncbi_mult_taxo_gbnm(164736, 'dark-throated river frog').
ncbi_mult_taxo_gbnm(164738, 'large-mouthed frog').
ncbi_mult_taxo_gbnm(164740, 'Galam white-lipped frog').
ncbi_mult_taxo_gbnm(164743, 'beaded sand frog').
ncbi_mult_taxo_gbnm(164746, 'Iceland catshark').
ncbi_mult_taxo_gbnm(164747, 'smalleye catshark').
ncbi_mult_taxo_gbnm(164748, 'ghost catshark').
ncbi_mult_taxo_gbnm(164889, 'Brown-backed solitaire').
ncbi_mult_taxo_gbnm(164931, 'Bactrian deer').
ncbi_mult_taxo_gbnm(164967, 'blue-tailed fire-bellied newt').
ncbi_mult_taxo_gbnm(164969, 'Guizhou warty newt').
ncbi_mult_taxo_gbnm(164970, 'Vietnam warty newt').
ncbi_mult_taxo_gbnm(164971, 'Guangxi warty newt').
ncbi_mult_taxo_gbnm(164972, 'Hong Kong warty newt').
ncbi_mult_taxo_gbnm(164973, 'crocodile newt').
ncbi_mult_taxo_gbnm(165020, 'Florida kingsnake').
ncbi_mult_taxo_gbnm(165023, 'California kingsnake').
ncbi_mult_taxo_gbnm(165035, 'Mexican milksnake').
ncbi_mult_taxo_gbnm(165041, 'scarlet kingsnake').
ncbi_mult_taxo_gbnm(165043, 'Central Plains milksnake').
ncbi_mult_taxo_gbnm(165097, 'fragile saucer coral').
ncbi_mult_taxo_gbnm(165099, 'artichoke coral').
ncbi_mult_taxo_gbnm(165194, 'chalk-browned mockingbird').
ncbi_mult_taxo_gbnm(165202, 'Huon tree kangaroo').
ncbi_mult_taxo_gbnm(165226, 'mitred toad').
ncbi_mult_taxo_gbnm(165298, 'veldt-grape').
ncbi_mult_taxo_gbnm(165341, 'purslane speedwell').
ncbi_mult_taxo_gbnm(165353, 'Chinese angelica').
ncbi_mult_taxo_gbnm(165419, 'northern star coral').
ncbi_mult_taxo_gbnm(165538, 'smaller tea tortrix').
ncbi_mult_taxo_gbnm(165599, 'grand razor shell').
ncbi_mult_taxo_gbnm(165700, 'Ulupica de Chaco').
ncbi_mult_taxo_gbnm(165738, 'White-headed woodpecker').
ncbi_mult_taxo_gbnm(165740, 'Red-cockaded woodpecker').
ncbi_mult_taxo_gbnm(165743, 'Striped woodpecker').
ncbi_mult_taxo_gbnm(165747, 'Checkered woodpecker').
ncbi_mult_taxo_gbnm(165748, 'Nuttall\'s woodpecker').
ncbi_mult_taxo_gbnm(165749, 'Ladder-backed woodpecker').
ncbi_mult_taxo_gbnm(165789, 'American bird pepper').
ncbi_mult_taxo_gbnm(165846, 'white peacock').
ncbi_mult_taxo_gbnm(165848, 'West Indian buckeye').
ncbi_mult_taxo_gbnm(165854, 'common tiger').
ncbi_mult_taxo_gbnm(165857, 'black and white tiger').
ncbi_mult_taxo_gbnm(165858, 'white tiger').
ncbi_mult_taxo_gbnm(165861, 'tropic queen').
ncbi_mult_taxo_gbnm(166020, 'smiling worms').
ncbi_mult_taxo_gbnm(166024, 'queen butterfly').
ncbi_mult_taxo_gbnm(166053, mudpuppies).
ncbi_mult_taxo_gbnm(166059, 'ashy-throated bush tanager').
ncbi_mult_taxo_gbnm(166067, 'Black-crested warbler').
ncbi_mult_taxo_gbnm(166085, 'green whip snake').
ncbi_mult_taxo_gbnm(166086, 'horseshoe snake').
ncbi_mult_taxo_gbnm(166088, 'Algerian whip snake').
ncbi_mult_taxo_gbnm(166089, 'large whip snake').
ncbi_mult_taxo_gbnm(166093, 'Dahls wipe snake').
ncbi_mult_taxo_gbnm(166094, 'Rogers\' racer').
ncbi_mult_taxo_gbnm(166096, 'collared dwarf racer').
ncbi_mult_taxo_gbnm(166254, 'sand eels').
ncbi_mult_taxo_gbnm(166256, 'Korean sandeel').
ncbi_mult_taxo_gbnm(166258, 'Magellan plunderfish').
ncbi_mult_taxo_gbnm(166261, redfish).
ncbi_mult_taxo_gbnm(166262, 'bight redfish').
ncbi_mult_taxo_gbnm(166263, 'swallow-tail').
ncbi_mult_taxo_gbnm(166264, 'shortfin scad').
ncbi_mult_taxo_gbnm(166376, 'minotaur beetle').
ncbi_mult_taxo_gbnm(166505, 'giant Canary Island lizard').
ncbi_mult_taxo_gbnm(166729, 'gorgeous prawn goby').
ncbi_mult_taxo_gbnm(166731, 'nocturn goby').
ncbi_mult_taxo_gbnm(166732, 'banded goby').
ncbi_mult_taxo_gbnm(166734, 'bearded goby').
ncbi_mult_taxo_gbnm(166735, 'Cocos frill goby').
ncbi_mult_taxo_gbnm(166737, 'Tongareva goby').
ncbi_mult_taxo_gbnm(166739, 'Pacific goby').
ncbi_mult_taxo_gbnm(166741, 'forktongue goby').
ncbi_mult_taxo_gbnm(166743, 'sandy prawn-goby').
ncbi_mult_taxo_gbnm(166745, 'tidewater goby').
ncbi_mult_taxo_gbnm(166747, 'Afele\'s fringefin goby').
ncbi_mult_taxo_gbnm(166748, 'eyebar goby').
ncbi_mult_taxo_gbnm(166749, 'shoulderspot goby').
ncbi_mult_taxo_gbnm(166755, 'Atlantic mudskipper').
ncbi_mult_taxo_gbnm(166757, 'girdled goby').
ncbi_mult_taxo_gbnm(166758, 'noble goby').
ncbi_mult_taxo_gbnm(166762, 'tusked goby').
ncbi_mult_taxo_gbnm(166764, 'walking goby').
ncbi_mult_taxo_gbnm(166768, 'blind goby').
ncbi_mult_taxo_gbnm(166770, 'pugjaw wormfish').
ncbi_mult_taxo_gbnm(166773, 'pink wormfish').
ncbi_mult_taxo_gbnm(166774, 'Sandwich Island sleeper').
ncbi_mult_taxo_gbnm(166776, 'emerald sleeper').
ncbi_mult_taxo_gbnm(166777, 'golden gudgeon').
ncbi_mult_taxo_gbnm(166778, 'western carp gudgeon').
ncbi_mult_taxo_gbnm(166779, 'blue gudgeon').
ncbi_mult_taxo_gbnm(166783, 'Schindler\'s fish').
ncbi_mult_taxo_gbnm(166784, 'freshwater sleepers').
ncbi_mult_taxo_gbnm(166789, 'Japanese giant salamander').
ncbi_mult_taxo_gbnm(166899, 'sabal weevil').
ncbi_mult_taxo_gbnm(167096, 'range caterpillar').
ncbi_mult_taxo_gbnm(167130, 'red-eared guenon').
ncbi_mult_taxo_gbnm(167187, 'lilacine bushbrown').
ncbi_mult_taxo_gbnm(167337, vetiver).
ncbi_mult_taxo_gbnm(167447, 'dash goby').
ncbi_mult_taxo_gbnm(167567, 'white bat flower').
ncbi_mult_taxo_gbnm(167584, 'bitter yam').
ncbi_mult_taxo_gbnm(167791, 'mountain ebony').
ncbi_mult_taxo_gbnm(167804, 'Aldabra giant tortoise').
ncbi_mult_taxo_gbnm(167917, 'golden dewdrops').
ncbi_mult_taxo_gbnm(167922, 'bleeding glory-bower').
ncbi_mult_taxo_gbnm(167929, 'Kariba tilapia').
ncbi_mult_taxo_gbnm(167930, 'Kangting sucker frog').
ncbi_mult_taxo_gbnm(167933, 'Chinese tree toad').
ncbi_mult_taxo_gbnm(167934, 'Malaysian narrowmouth toad').
ncbi_mult_taxo_gbnm(167935, 'Yunnanfu frog').
ncbi_mult_taxo_gbnm(167949, 'pearl of Likoma').
ncbi_mult_taxo_gbnm(167953, 'Napo spiny rat').
ncbi_mult_taxo_gbnm(168092, 'Cunene dwarf happy').
ncbi_mult_taxo_gbnm(168096, wobbegons).
ncbi_mult_taxo_gbnm(168098, 'spotted wobbegong').
ncbi_mult_taxo_gbnm(168100, 'Iberian frog').
ncbi_mult_taxo_gbnm(168377, 'bullseye puffer').
ncbi_mult_taxo_gbnm(168631, 'striped riceborer').
ncbi_mult_taxo_gbnm(168652, 'apple-grass aphid').
ncbi_mult_taxo_gbnm(168684, 'striped newt').
ncbi_mult_taxo_gbnm(168767, 'purplestriped jelly').
ncbi_mult_taxo_gbnm(168771, 'eggyolk jelly').
ncbi_mult_taxo_gbnm(168796, 'cannonball jelly').
ncbi_mult_taxo_gbnm(168802, 'goldeneye cichlid').
ncbi_mult_taxo_gbnm(168854, 'compost worm').
ncbi_mult_taxo_gbnm(168902, 'banded seabream').
ncbi_mult_taxo_gbnm(168903, 'Red Sea seabream').
ncbi_mult_taxo_gbnm(168904, 'two-banded seabream').
ncbi_mult_taxo_gbnm(168905, 'South American silver porgy').
ncbi_mult_taxo_gbnm(169069, 'basket-of-gold').
ncbi_mult_taxo_gbnm(169094, 'giant weta').
ncbi_mult_taxo_gbnm(169095, 'Hawkes Bay tree weta').
ncbi_mult_taxo_gbnm(169191, 'Brazilian peppertree').
ncbi_mult_taxo_gbnm(169217, 'bunny ears cactus').
ncbi_mult_taxo_gbnm(169288, 'white seabream').
ncbi_mult_taxo_gbnm(169289, 'sixbar distichodus').
ncbi_mult_taxo_gbnm(169291, hingemouth).
ncbi_mult_taxo_gbnm(169298, 'western wheat aphid').
ncbi_mult_taxo_gbnm(169304, 'ringed wormsnail').
ncbi_mult_taxo_gbnm(169375, 'hen and chicks fern').
ncbi_mult_taxo_gbnm(169440, 'seaweed flies').
ncbi_mult_taxo_gbnm(169447, 'marsh flies').
ncbi_mult_taxo_gbnm(169478, 'halfbridge flies').
ncbi_mult_taxo_gbnm(169668, 'Borneo forest dragon').
ncbi_mult_taxo_gbnm(169837, 'Dumeril monitor').
ncbi_mult_taxo_gbnm(169846, 'Banggai Island monitor').
ncbi_mult_taxo_gbnm(169851, 'roughneck monitor').
ncbi_mult_taxo_gbnm(169857, 'Yararanata').
ncbi_mult_taxo_gbnm(169861, 'Wagler\'s snake').
ncbi_mult_taxo_gbnm(170189, 'California slickhead').
ncbi_mult_taxo_gbnm(170193, 'eared blacksmelt').
ncbi_mult_taxo_gbnm(170194, argentines).
ncbi_mult_taxo_gbnm(170196, 'deepsea smelt').
ncbi_mult_taxo_gbnm(170200, tubeshoulders).
ncbi_mult_taxo_gbnm(170202, 'legless searsid').
ncbi_mult_taxo_gbnm(170203, cucumberfish).
ncbi_mult_taxo_gbnm(170204, barreleyes).
ncbi_mult_taxo_gbnm(170206, 'barrel-eye').
ncbi_mult_taxo_gbnm(170207, 'Simakobou').
ncbi_mult_taxo_gbnm(170217, 'New Britain naked-backed fruit bat').
ncbi_mult_taxo_gbnm(170234, 'Polynesian sheath-tailed bat').
ncbi_mult_taxo_gbnm(170405, 'Socotra cormorant').
ncbi_mult_taxo_gbnm(170811, 'deepwater catshark').
ncbi_mult_taxo_gbnm(170813, 'black dogfish').
ncbi_mult_taxo_gbnm(170815, 'roughskin dogfish').
ncbi_mult_taxo_gbnm(170817, 'kitefin shark').
ncbi_mult_taxo_gbnm(170820, 'epaulette shark').
ncbi_mult_taxo_gbnm(170821, 'ornate wobbegong').
ncbi_mult_taxo_gbnm(170822, 'porcupine river stingray').
ncbi_mult_taxo_gbnm(170823, 'longnose sawshark').
ncbi_mult_taxo_gbnm(170824, 'shovelnose guitarfish').
ncbi_mult_taxo_gbnm(170825, 'Pacific angelshark').
ncbi_mult_taxo_gbnm(170826, 'yellow stingray').
ncbi_mult_taxo_gbnm(170843, 'citrus mealybug').
ncbi_mult_taxo_gbnm(170859, bonytail).
ncbi_mult_taxo_gbnm(170862, 'collared inca').
ncbi_mult_taxo_gbnm(170922, 'fairy primrose').
ncbi_mult_taxo_gbnm(170924, 'poison primrose').
ncbi_mult_taxo_gbnm(170953, 'Peru water frog').
ncbi_mult_taxo_gbnm(170971, 'burrowing thick-tailed scorpions').
ncbi_mult_taxo_gbnm(170972, 'South African fattail scorpion').
ncbi_mult_taxo_gbnm(170974, 'fusedback mayflies').
ncbi_mult_taxo_gbnm(170989, 'Makrut lime').
ncbi_mult_taxo_gbnm(171122, 'stripe-headed round-eared bat').
ncbi_mult_taxo_gbnm(171126, 'Common ameiva').
ncbi_mult_taxo_gbnm(171127, 'four-lined Ameiva').
ncbi_mult_taxo_gbnm(171128, 'rainbow ameiva').
ncbi_mult_taxo_gbnm(171129, 'Canyon spotted whiptail').
ncbi_mult_taxo_gbnm(171131, 'Western Mexico whiptail').
ncbi_mult_taxo_gbnm(171134, 'blackbelly racerunner').
ncbi_mult_taxo_gbnm(171137, 'Bibron\'s whiptail').
ncbi_mult_taxo_gbnm(171139, 'longtail whiptail').
ncbi_mult_taxo_gbnm(171142, 'rusty-rumped whiptail').
ncbi_mult_taxo_gbnm(171154, 'Guyana Kentropyx').
ncbi_mult_taxo_gbnm(171196, 'Pacific barrelfish').
ncbi_mult_taxo_gbnm(171249, 'Rangpur lime').
ncbi_mult_taxo_gbnm(171251, citron).
ncbi_mult_taxo_gbnm(171252, 'Cleopatra mandarin').
ncbi_mult_taxo_gbnm(171265, 'dwarf sturgeon').
ncbi_mult_taxo_gbnm(171268, 'Far Eastern curlew').
ncbi_mult_taxo_gbnm(171269, 'Wood sandpiper').
ncbi_mult_taxo_gbnm(171275, 'Pied Avocet').
ncbi_mult_taxo_gbnm(171367, 'southern marbled newt').
ncbi_mult_taxo_gbnm(171406, 'purple swamphen').
ncbi_mult_taxo_gbnm(171407, 'redback poison frog').
ncbi_mult_taxo_gbnm(171414, 'large-tooth flounders').
ncbi_mult_taxo_gbnm(171416, 'cinnamon flounder').
ncbi_mult_taxo_gbnm(171570, 'fire-rim tortoiseshell').
ncbi_mult_taxo_gbnm(171571, 'African red admirals').
ncbi_mult_taxo_gbnm(171572, 'long tail admiral').
ncbi_mult_taxo_gbnm(171575, 'map butterfly').
ncbi_mult_taxo_gbnm(171585, 'European peacock').
ncbi_mult_taxo_gbnm(171587, 'Queen of Spain fritillary').
ncbi_mult_taxo_gbnm(171589, 'blue admiral').
ncbi_mult_taxo_gbnm(171592, 'mourning cloak').
ncbi_mult_taxo_gbnm(171593, 'California tortoiseshell').
ncbi_mult_taxo_gbnm(171594, 'blackleg tortoiseshell').
ncbi_mult_taxo_gbnm(171598, 'southern comma').
ncbi_mult_taxo_gbnm(171599, 'Faunus anglewing').
ncbi_mult_taxo_gbnm(171600, 'hoary comma').
ncbi_mult_taxo_gbnm(171601, 'gray comma').
ncbi_mult_taxo_gbnm(171602, 'satyr anglewing').
ncbi_mult_taxo_gbnm(171606, 'American painted lady').
ncbi_mult_taxo_gbnm(171645, 'Grumgrzimail\'s toadhead agama').
ncbi_mult_taxo_gbnm(171646, 'spotted toadhead agama').
ncbi_mult_taxo_gbnm(171647, 'sunwatcher toadhead agama').
ncbi_mult_taxo_gbnm(171650, 'Theobald\'s toad-headed agama').
ncbi_mult_taxo_gbnm(171652, 'Pylzow\'s toadhead agama').
ncbi_mult_taxo_gbnm(171732, 'rock cook').
ncbi_mult_taxo_gbnm(171735, 'goldsinny wrasse').
ncbi_mult_taxo_gbnm(171736, 'corkwing wrasse').
ncbi_mult_taxo_gbnm(171792, 'Bibron\'s giant soft-shelled turtle').
ncbi_mult_taxo_gbnm(171793, 'Cantor\'s giant softshell turtle').
ncbi_mult_taxo_gbnm(171802, 'silver-washed fritillary').
ncbi_mult_taxo_gbnm(171870, 'black-headed blenny').
ncbi_mult_taxo_gbnm(171871, 'tompot blenny').
ncbi_mult_taxo_gbnm(171872, 'rock-pool blenny').
ncbi_mult_taxo_gbnm(171873, 'Portugese blenny').
ncbi_mult_taxo_gbnm(171929, cashew).
ncbi_mult_taxo_gbnm(171938, 'kuwini mango').
ncbi_mult_taxo_gbnm(171959, 'Sudan grass').
ncbi_mult_taxo_gbnm(171973, 'organ pipe cactus').
ncbi_mult_taxo_gbnm(172114, telescopefishes).
ncbi_mult_taxo_gbnm(172116, gigantura).
ncbi_mult_taxo_gbnm(172117, telescopefish).
ncbi_mult_taxo_gbnm(172121, pearleyes).
ncbi_mult_taxo_gbnm(172126, waryfishes).
ncbi_mult_taxo_gbnm(172129, 'Gunther\'s lizard fish').
ncbi_mult_taxo_gbnm(172131, snakefish).
ncbi_mult_taxo_gbnm(172134, 'deepsea lizardfish').
ncbi_mult_taxo_gbnm(172138, barracudinas).
ncbi_mult_taxo_gbnm(172140, 'Atlantic barracudina').
ncbi_mult_taxo_gbnm(172142, daggertooth).
ncbi_mult_taxo_gbnm(172143, 'sabertooth fishes').
ncbi_mult_taxo_gbnm(172145, 'Indian sabertooth').
ncbi_mult_taxo_gbnm(172147, 'Atlantic sabertooth').
ncbi_mult_taxo_gbnm(172200, arjuna).
ncbi_mult_taxo_gbnm(172269, meagre).
ncbi_mult_taxo_gbnm(172404, 'Spotted nightingale-thrush').
ncbi_mult_taxo_gbnm(172413, 'eastern bluebird').
ncbi_mult_taxo_gbnm(172416, 'varied thrush').
ncbi_mult_taxo_gbnm(172515, 'small minnow mayflies').
ncbi_mult_taxo_gbnm(172518, 'flecked mayflies').
ncbi_mult_taxo_gbnm(172522, 'blue acara').
ncbi_mult_taxo_gbnm(172524, 'yellow belly cichlid').
ncbi_mult_taxo_gbnm(172526, 'Almoloya cichlid').
ncbi_mult_taxo_gbnm(172531, 'saddle cichlid').
ncbi_mult_taxo_gbnm(172532, 'emerald cichlid').
ncbi_mult_taxo_gbnm(172537, 'keyhole cichlid').
ncbi_mult_taxo_gbnm(172541, 'Angostura cichlid').
ncbi_mult_taxo_gbnm(172552, 'Chinese swimming scorpion').
ncbi_mult_taxo_gbnm(172644, 'paper mulberry').
ncbi_mult_taxo_gbnm(172659, 'English sole').
ncbi_mult_taxo_gbnm(172661, 'false cat sharks').
ncbi_mult_taxo_gbnm(172663, 'false catshark').
ncbi_mult_taxo_gbnm(172680, 'Houbara bustard').
ncbi_mult_taxo_gbnm(172699, 'Stanley bustard').
ncbi_mult_taxo_gbnm(172714, 'kelp bass').
ncbi_mult_taxo_gbnm(172907, 'mud carp').
ncbi_mult_taxo_gbnm(172933, 'white-striped Cape skink').
ncbi_mult_taxo_gbnm(173042, 'winter skate').
ncbi_mult_taxo_gbnm(173240, 'upland longjaw galaxias').
ncbi_mult_taxo_gbnm(173241, 'dwarf galaxias').
ncbi_mult_taxo_gbnm(173242, 'Formosan land-locked salmon').
ncbi_mult_taxo_gbnm(173244, roosterfish).
ncbi_mult_taxo_gbnm(173245, remoras).
ncbi_mult_taxo_gbnm(173247, 'live sharksucker').
ncbi_mult_taxo_gbnm(173249, 'Pierre\'s acraea').
ncbi_mult_taxo_gbnm(173251, 'Aurivillius\' acraea').
ncbi_mult_taxo_gbnm(173306, 'Pacific crevalle jack').
ncbi_mult_taxo_gbnm(173308, 'yellowfin jack').
ncbi_mult_taxo_gbnm(173309, 'blue runner').
ncbi_mult_taxo_gbnm(173311, 'yellowstripe scad').
ncbi_mult_taxo_gbnm(173312, 'crevalle jack').
ncbi_mult_taxo_gbnm(173313, 'green jack').
ncbi_mult_taxo_gbnm(173314, cocinero).
ncbi_mult_taxo_gbnm(173315, 'bar jack').
ncbi_mult_taxo_gbnm(173317, 'whitemouth jack').
ncbi_mult_taxo_gbnm(173318, 'yellow jack').
ncbi_mult_taxo_gbnm(173320, 'cleftbelly trevally').
ncbi_mult_taxo_gbnm(173321, 'Almaco jack').
ncbi_mult_taxo_gbnm(173322, 'round scad').
ncbi_mult_taxo_gbnm(173324, 'rainbow runner').
ncbi_mult_taxo_gbnm(173325, 'blackfin jack').
ncbi_mult_taxo_gbnm(173327, 'shrimp scad').
ncbi_mult_taxo_gbnm(173329, 'Atlantic bumper').
ncbi_mult_taxo_gbnm(173331, permit).
ncbi_mult_taxo_gbnm(173332, 'gafftopsail pompano').
ncbi_mult_taxo_gbnm(173333, palometa).
ncbi_mult_taxo_gbnm(173334, 'banded rudderfish').
ncbi_mult_taxo_gbnm(173335, 'shortfin pompano').
ncbi_mult_taxo_gbnm(173336, 'longfin pompano').
ncbi_mult_taxo_gbnm(173337, 'Guinean amberjack').
ncbi_mult_taxo_gbnm(173338, 'Pacific bumper').
ncbi_mult_taxo_gbnm(173339, derbio).
ncbi_mult_taxo_gbnm(173341, 'Talang queenfish').
ncbi_mult_taxo_gbnm(173342, 'Florida pompano').
ncbi_mult_taxo_gbnm(173344, leatherjack).
ncbi_mult_taxo_gbnm(173345, 'longjaw leatherjack').
ncbi_mult_taxo_gbnm(173346, 'bigeye trevally').
ncbi_mult_taxo_gbnm(173350, 'false scad').
ncbi_mult_taxo_gbnm(173351, 'Tasmanian mudfish').
ncbi_mult_taxo_gbnm(173519, 'roughear scad').
ncbi_mult_taxo_gbnm(173576, 'pistachio seed chalcid').
ncbi_mult_taxo_gbnm(173641, 'mompha moths').
ncbi_mult_taxo_gbnm(173644, 'casebearer moths').
ncbi_mult_taxo_gbnm(173647, 'cosmet moths').
ncbi_mult_taxo_gbnm(173649, 'scavenger moths').
ncbi_mult_taxo_gbnm(173679, 'green mirid').
ncbi_mult_taxo_gbnm(173775, 'thorny stick insect').
ncbi_mult_taxo_gbnm(173795, 'New Guinea walking stick').
ncbi_mult_taxo_gbnm(173836, 'lobed roachfly').
ncbi_mult_taxo_gbnm(173902, 'Small mouse-tailed bat').
ncbi_mult_taxo_gbnm(173903, 'Greater mouse-tailed bat').
ncbi_mult_taxo_gbnm(173936, 'Gilbert\'s potoroo').
ncbi_mult_taxo_gbnm(173968, 'Virginia roachfly').
ncbi_mult_taxo_gbnm(173988, 'Celebes rusa deer').
ncbi_mult_taxo_gbnm(174164, 'flaccid anemone').
ncbi_mult_taxo_gbnm(174217, tarovine).
ncbi_mult_taxo_gbnm(174218, 'Adanson\'s monstera').
ncbi_mult_taxo_gbnm(174263, 'spotted anole').
ncbi_mult_taxo_gbnm(174264, 'banded tree anole').
ncbi_mult_taxo_gbnm(174269, 'mottled beauty moth').
ncbi_mult_taxo_gbnm(174280, 'rough-scaled plated lizard').
ncbi_mult_taxo_gbnm(174297, 'White-lipped island pitviper').
ncbi_mult_taxo_gbnm(174298, 'Nepal pitviper').
ncbi_mult_taxo_gbnm(174397, 'common hermit crab').
ncbi_mult_taxo_gbnm(174398, 'hairy hermit crab').
ncbi_mult_taxo_gbnm(174445, 'golden buttons').
ncbi_mult_taxo_gbnm(174599, 'yellow-breasted capuchin').
ncbi_mult_taxo_gbnm(174621, 'pitcher-plant mosquito').
ncbi_mult_taxo_gbnm(174624, 'net-winged midges').
ncbi_mult_taxo_gbnm(174677, 'Siberian gull').
ncbi_mult_taxo_gbnm(174768, 'keel-bellied shade lizard').
ncbi_mult_taxo_gbnm(174770, 'drab shade lizard').
ncbi_mult_taxo_gbnm(174802, 'white-striped eyed lizard').
ncbi_mult_taxo_gbnm(174822, 'bertha armyworm').
ncbi_mult_taxo_gbnm(174914, 'pill beetles').
ncbi_mult_taxo_gbnm(175000, 'brown treecreeper').
ncbi_mult_taxo_gbnm(175002, 'Yellow-bellied flowerpecker').
ncbi_mult_taxo_gbnm(175006, 'red-backed fairy wren').
ncbi_mult_taxo_gbnm(175013, 'garden bulbul').
ncbi_mult_taxo_gbnm(175014, 'Asian desert warbler').
ncbi_mult_taxo_gbnm(175021, 'common iora').
ncbi_mult_taxo_gbnm(175113, 'creeping jenny').
ncbi_mult_taxo_gbnm(175120, 'fairy bluebird').
ncbi_mult_taxo_gbnm(175124, 'Black berrypecker').
ncbi_mult_taxo_gbnm(175133, 'Alpine accentor').
ncbi_mult_taxo_gbnm(175139, 'white-faced robin').
ncbi_mult_taxo_gbnm(175183, 'trailing black currant').
ncbi_mult_taxo_gbnm(175203, 'hairy-stem gooseberry').
ncbi_mult_taxo_gbnm(175205, 'northern black currant').
ncbi_mult_taxo_gbnm(175209, 'prickly currant').
ncbi_mult_taxo_gbnm(175226, 'skunk currant').
ncbi_mult_taxo_gbnm(175228, 'red currant').
ncbi_mult_taxo_gbnm(175233, 'wild red currant').
ncbi_mult_taxo_gbnm(175273, 'gray weakfish').
ncbi_mult_taxo_gbnm(175282, 'Okhostk atka mackerel').
ncbi_mult_taxo_gbnm(175337, 'ladybird spider').
ncbi_mult_taxo_gbnm(175428, 'barred spinefoot').
ncbi_mult_taxo_gbnm(175429, foxface).
ncbi_mult_taxo_gbnm(175430, 'elongate surgeonfish').
ncbi_mult_taxo_gbnm(175431, 'whitecheek surgeonfish').
ncbi_mult_taxo_gbnm(175432, 'bluelined surgeonfish').
ncbi_mult_taxo_gbnm(175433, 'chocolate surgeonfish').
ncbi_mult_taxo_gbnm(175434, 'Thompson\'s surgeonfish').
ncbi_mult_taxo_gbnm(175435, 'convict surgeonfish').
ncbi_mult_taxo_gbnm(175436, 'striated surgeonfish').
ncbi_mult_taxo_gbnm(175437, 'razor surgeonfish').
ncbi_mult_taxo_gbnm(175438, 'sixplate sawtail').
ncbi_mult_taxo_gbnm(175439, 'yellow tang').
ncbi_mult_taxo_gbnm(175441, 'humpback unicornfish').
ncbi_mult_taxo_gbnm(175442, 'sleek unicornfish').
ncbi_mult_taxo_gbnm(175443, 'humpnose unicornfish').
ncbi_mult_taxo_gbnm(175444, 'bluespine unicornfish').
ncbi_mult_taxo_gbnm(175451, 'Mali agama').
ncbi_mult_taxo_gbnm(175627, 'purple-necked rock-wallaby').
ncbi_mult_taxo_gbnm(175755, 'titan arum').
ncbi_mult_taxo_gbnm(175774, goonch).
ncbi_mult_taxo_gbnm(175787, 'Chinese longsnout catfish').
ncbi_mult_taxo_gbnm(175811, 'Northern Brushtail Possum').
ncbi_mult_taxo_gbnm(175817, 'black hornbill').
ncbi_mult_taxo_gbnm(175833, 'tarictic hornbills').
ncbi_mult_taxo_gbnm(175834, 'Visayan tarictic hornbill').
ncbi_mult_taxo_gbnm(175835, 'Rhinoceros hornbill').
ncbi_mult_taxo_gbnm(175843, 'silvery-cheeked hornbill').
ncbi_mult_taxo_gbnm(175928, 'black-capped siskin').
ncbi_mult_taxo_gbnm(175929, 'Antillean siskin').
ncbi_mult_taxo_gbnm(175930, 'Common rosefinch').
ncbi_mult_taxo_gbnm(175932, 'Dark-breasted rosefinch').
ncbi_mult_taxo_gbnm(175936, 'Yellow-throated Euphonia').
ncbi_mult_taxo_gbnm(175947, 'pine grosbeak').
ncbi_mult_taxo_gbnm(176013, 'red-and-green macaw').
ncbi_mult_taxo_gbnm(176014, 'Scarlet macaw').
ncbi_mult_taxo_gbnm(176015, 'sun parakeet').
ncbi_mult_taxo_gbnm(176018, 'Grey-cheeked parakeet').
ncbi_mult_taxo_gbnm(176022, 'Greater vasa parrot').
ncbi_mult_taxo_gbnm(176024, 'Eclectus parrot').
ncbi_mult_taxo_gbnm(176039, galah).
ncbi_mult_taxo_gbnm(176043, 'Kaka').
ncbi_mult_taxo_gbnm(176045, 'Senegal parrot').
ncbi_mult_taxo_gbnm(176047, 'Red-rumped parrot').
ncbi_mult_taxo_gbnm(176049, 'coconut lorikeet').
ncbi_mult_taxo_gbnm(176053, 'red-flanked lorikeet').
ncbi_mult_taxo_gbnm(176057, 'Kea').
ncbi_mult_taxo_gbnm(176064, 'Black-winged lory').
ncbi_mult_taxo_gbnm(176066, 'monk parakeet').
ncbi_mult_taxo_gbnm(176072, 'dusky lory').
ncbi_mult_taxo_gbnm(176075, 'Blue-streaked lory').
ncbi_mult_taxo_gbnm(176095, 'cloak anemone').
ncbi_mult_taxo_gbnm(176136, 'small-leaf bramble').
ncbi_mult_taxo_gbnm(176185, karasu).
ncbi_mult_taxo_gbnm(176186, nashifugu).
ncbi_mult_taxo_gbnm(176187, 'purple puffer').
ncbi_mult_taxo_gbnm(176188, 'finepatterned puffer').
ncbi_mult_taxo_gbnm(176192, 'three-banded box turtle').
ncbi_mult_taxo_gbnm(176193, 'Pan\'s box turtle').
ncbi_mult_taxo_gbnm(176194, 'Yunnan box turtle').
ncbi_mult_taxo_gbnm(176196, 'Japanese pond turtle').
ncbi_mult_taxo_gbnm(176197, 'Mediterranian turtle').
ncbi_mult_taxo_gbnm(176247, 'coastal dog-hobble').
ncbi_mult_taxo_gbnm(176248, pinesap).
ncbi_mult_taxo_gbnm(176252, 'sweet pinesap').
ncbi_mult_taxo_gbnm(176316, 'dune tiger beetle').
ncbi_mult_taxo_gbnm(176498, 'broad-headed spiny rat').
ncbi_mult_taxo_gbnm(176501, 'armored rat').
ncbi_mult_taxo_gbnm(176503, 'Atlantic bamboo rat').
ncbi_mult_taxo_gbnm(176505, 'tuft-tailed spiny tree rat').
ncbi_mult_taxo_gbnm(176508, 'Long-tailed armored tree-rat').
ncbi_mult_taxo_gbnm(176858, 'Japanese hornbeam').
ncbi_mult_taxo_gbnm(176865, 'European hop-hornbeam').
ncbi_mult_taxo_gbnm(176938, 'American pygmy kingfisher').
ncbi_mult_taxo_gbnm(176942, 'crested kingfisher').
ncbi_mult_taxo_gbnm(176946, 'Burmese python').
ncbi_mult_taxo_gbnm(177059, 'Lanza\'s fire salamander').
ncbi_mult_taxo_gbnm(177060, 'pear puffer').
ncbi_mult_taxo_gbnm(177089, 'hibiscus mealybug').
ncbi_mult_taxo_gbnm(177111, 'pollen beetles').
ncbi_mult_taxo_gbnm(177143, 'ashy wood-pigeon').
ncbi_mult_taxo_gbnm(177145, 'Philippine cuckoo-dove').
ncbi_mult_taxo_gbnm(177147, 'Eurasian collared-dove').
ncbi_mult_taxo_gbnm(177152, 'African collared-dove').
ncbi_mult_taxo_gbnm(177160, 'Gray\'s long-tongued bat').
ncbi_mult_taxo_gbnm(177182, 'Beatrix\'s bat').
ncbi_mult_taxo_gbnm(177185, 'Round-eared tube-nosed bat').
ncbi_mult_taxo_gbnm(177615, 'orange-fin labeo').
ncbi_mult_taxo_gbnm(178044, 'plasterer bees').
ncbi_mult_taxo_gbnm(178187, 'golden penda').
ncbi_mult_taxo_gbnm(178225, racehorses).
ncbi_mult_taxo_gbnm(178226, 'Australian prowlfishes').
ncbi_mult_taxo_gbnm(178227, velvetfishes).
ncbi_mult_taxo_gbnm(178230, 'deepwater flatheads').
ncbi_mult_taxo_gbnm(178231, 'armored gurnards').
ncbi_mult_taxo_gbnm(178293, 'embossed stonefly').
ncbi_mult_taxo_gbnm(178295, 'flatheaded mayflies').
ncbi_mult_taxo_gbnm(178300, 'Snyder\'s angel insect').
ncbi_mult_taxo_gbnm(178382, 'African wall gecko').
ncbi_mult_taxo_gbnm(178384, 'helmethead gecko').
ncbi_mult_taxo_gbnm(178514, 'erect rope sponge').
ncbi_mult_taxo_gbnm(178539, 'azure vase sponge').
ncbi_mult_taxo_gbnm(178552, 'giant barrel sponge').
ncbi_mult_taxo_gbnm(178571, 'central greenside darter').
ncbi_mult_taxo_gbnm(178572, 'highlands greenside darter').
ncbi_mult_taxo_gbnm(178573, 'Sequatchie blenny darter').
ncbi_mult_taxo_gbnm(178614, 'perpetual kale').
ncbi_mult_taxo_gbnm(178616, 'Brussels sprouts').
ncbi_mult_taxo_gbnm(178766, 'banded tetra').
ncbi_mult_taxo_gbnm(178767, 'twospot astyanax').
ncbi_mult_taxo_gbnm(178769, 'goldenrod gall fly').
ncbi_mult_taxo_gbnm(178805, 'Amur peppervine').
ncbi_mult_taxo_gbnm(178820, 'Cyren\'s rock lizard').
ncbi_mult_taxo_gbnm(178821, 'Iberian mountain lizard').
ncbi_mult_taxo_gbnm(178879, 'gray bichir').
ncbi_mult_taxo_gbnm(178882, 'Indigo macaw').
ncbi_mult_taxo_gbnm(178883, 'chestnut-fronted macaw').
ncbi_mult_taxo_gbnm(178884, 'cactus parakeet').
ncbi_mult_taxo_gbnm(178885, 'white-eyed parakeet').
ncbi_mult_taxo_gbnm(178886, 'canary-winged parakeet').
ncbi_mult_taxo_gbnm(178890, 'Red-bellied macaw').
ncbi_mult_taxo_gbnm(178892, 'yellow-collared macaw').
ncbi_mult_taxo_gbnm(178893, 'blue-headed macaw').
ncbi_mult_taxo_gbnm(178894, 'blue-winged macaw').
ncbi_mult_taxo_gbnm(178897, 'red spider mite').
ncbi_mult_taxo_gbnm(178948, 'broom psyllid').
ncbi_mult_taxo_gbnm(179152, 'ungulate lice').
ncbi_mult_taxo_gbnm(179155, 'hawk lice').
ncbi_mult_taxo_gbnm(179177, 'large duck louse').
ncbi_mult_taxo_gbnm(179263, 'striped lava lizard').
ncbi_mult_taxo_gbnm(179265, 'tree runner').
ncbi_mult_taxo_gbnm(179359, 'African pompano').
ncbi_mult_taxo_gbnm(179362, 'threadfin jack').
ncbi_mult_taxo_gbnm(179364, 'Mexican lookdown').
ncbi_mult_taxo_gbnm(179365, 'Caribbean moonfish').
ncbi_mult_taxo_gbnm(179366, 'African moonfish').
ncbi_mult_taxo_gbnm(179368, 'Pacific moonfish').
ncbi_mult_taxo_gbnm(179369, 'Atlantic moonfish').
ncbi_mult_taxo_gbnm(179370, lookdown).
ncbi_mult_taxo_gbnm(179371, 'rough scad').
ncbi_mult_taxo_gbnm(179372, 'fourspotted megrim').
ncbi_mult_taxo_gbnm(179409, 'Beautiful rosefinch').
ncbi_mult_taxo_gbnm(179529, 'Blue Ridge mountain salamander').
ncbi_mult_taxo_gbnm(179530, 'Ocoee salamander').
ncbi_mult_taxo_gbnm(179531, 'Blue Ridge dusky salamander').
ncbi_mult_taxo_gbnm(179534, 'dogtooth grouper').
ncbi_mult_taxo_gbnm(179535, 'dusky grouper').
ncbi_mult_taxo_gbnm(179536, 'white grouper').
ncbi_mult_taxo_gbnm(179537, 'Haifa grouper').
ncbi_mult_taxo_gbnm(179646, 'purple dye murex').
ncbi_mult_taxo_gbnm(179666, 'cinnabar moth').
ncbi_mult_taxo_gbnm(179674, 'burnished brass moth').
ncbi_mult_taxo_gbnm(179809, 'Scandinavian herring gull').
ncbi_mult_taxo_gbnm(179871, 'ear mite').
ncbi_mult_taxo_gbnm(179874, 'Trinidad chevron tarantula').
ncbi_mult_taxo_gbnm(179890, 'Southern dwarf chameleon').
ncbi_mult_taxo_gbnm(179893, 'elongate leaf chameleon').
ncbi_mult_taxo_gbnm(179897, 'Domergue\'s leaf chameleon').
ncbi_mult_taxo_gbnm(179898, 'Mount d\'Ambre leaf chameleon').
ncbi_mult_taxo_gbnm(179908, 'veiled chameleon').
ncbi_mult_taxo_gbnm(179915, 'Meller\'s chameleon').
ncbi_mult_taxo_gbnm(179919, 'Bocage\'s chameleon').
ncbi_mult_taxo_gbnm(179926, 'carpet chameleon').
ncbi_mult_taxo_gbnm(179927, 'Oustalet\'s chamelion').
ncbi_mult_taxo_gbnm(179978, 'whiteface hagfish').
ncbi_mult_taxo_gbnm(179983, 'Formosa hagfish').
ncbi_mult_taxo_gbnm(179985, 'orbicular velvetfishes').
ncbi_mult_taxo_gbnm(179994, sapele).
ncbi_mult_taxo_gbnm(180010, 'woolly hedgenettle').
ncbi_mult_taxo_gbnm(180093, 'western dock').
ncbi_mult_taxo_gbnm(180174, 'Mauritius giant domed tortoise').
ncbi_mult_taxo_gbnm(180175, 'Reunion giant tortoise').
ncbi_mult_taxo_gbnm(180176, 'Rodrigues domed tortoise').
ncbi_mult_taxo_gbnm(180177, 'Mauritius giant flat-shelled tortoise').
ncbi_mult_taxo_gbnm(180178, 'Rodrigues giant saddleback tortoise').
ncbi_mult_taxo_gbnm(180179, 'star tortoise').
ncbi_mult_taxo_gbnm(180214, 'Rocky Mountain grasshopper').
ncbi_mult_taxo_gbnm(180264, 'pallid emperor moth').
ncbi_mult_taxo_gbnm(180268, 'imperial moth').
ncbi_mult_taxo_gbnm(180445, 'African pied wagtail').
ncbi_mult_taxo_gbnm(180447, 'mountain wagtail').
ncbi_mult_taxo_gbnm(180519, 'Alvord chub').
ncbi_mult_taxo_gbnm(180520, 'Borax Lake chub').
ncbi_mult_taxo_gbnm(180581, 'Indian rennet').
ncbi_mult_taxo_gbnm(180675, 'bonfire salvia').
ncbi_mult_taxo_gbnm(180757, 'Andean blueberry').
ncbi_mult_taxo_gbnm(180763, 'common bilberry').
ncbi_mult_taxo_gbnm(180772, lingonberry).
ncbi_mult_taxo_gbnm(180811, 'Corsican fire salamander').
ncbi_mult_taxo_gbnm(180953, 'rock elm').
ncbi_mult_taxo_gbnm(181024, 'Hispaniolan lizard-cuckoo').
ncbi_mult_taxo_gbnm(181025, 'Jamaican lizard-cuckoo').
ncbi_mult_taxo_gbnm(181026, 'Mangrove cuckoo').
ncbi_mult_taxo_gbnm(181081, 'Puerto Rican lizard-cuckoo').
ncbi_mult_taxo_gbnm(181090, 'Flaming sunbird').
ncbi_mult_taxo_gbnm(181092, 'Yellow-bellied greenbul').
ncbi_mult_taxo_gbnm(181096, 'hooded crow').
ncbi_mult_taxo_gbnm(181098, balicassiao).
ncbi_mult_taxo_gbnm(181099, 'Eurasian golden-oriole').
ncbi_mult_taxo_gbnm(181103, 'Southern masked weaver').
ncbi_mult_taxo_gbnm(181119, 'Tibetan ground-tit').
ncbi_mult_taxo_gbnm(181124, 'fairy-ring Marasmius').
ncbi_mult_taxo_gbnm(181181, 'corn gromwell').
ncbi_mult_taxo_gbnm(181185, 'Assyrian plum').
ncbi_mult_taxo_gbnm(181330, 'cedar tip moth').
ncbi_mult_taxo_gbnm(181391, pearlfishes).
ncbi_mult_taxo_gbnm(181397, 'cusk-eel').
ncbi_mult_taxo_gbnm(181399, 'golden cusk').
ncbi_mult_taxo_gbnm(181401, 'viviparous brotulas').
ncbi_mult_taxo_gbnm(181404, 'rubynose brotula').
ncbi_mult_taxo_gbnm(181408, 'Japanese codling').
ncbi_mult_taxo_gbnm(181410, arrowtail).
ncbi_mult_taxo_gbnm(181412, 'smallscale codlet').
ncbi_mult_taxo_gbnm(181415, 'sea toads').
ncbi_mult_taxo_gbnm(181420, fanfins).
ncbi_mult_taxo_gbnm(181422, 'fanfin anglerfish').
ncbi_mult_taxo_gbnm(181423, 'black seadevils').
ncbi_mult_taxo_gbnm(181425, 'Murray\'s abyssal anglerfish').
ncbi_mult_taxo_gbnm(181433, 'splitfin flashlightfish').
ncbi_mult_taxo_gbnm(181437, 'Japanese soldierfish').
ncbi_mult_taxo_gbnm(181438, redcoat).
ncbi_mult_taxo_gbnm(181440, parazen).
ncbi_mult_taxo_gbnm(181443, 'Japanese dory').
ncbi_mult_taxo_gbnm(181445, 'black oreo').
ncbi_mult_taxo_gbnm(181447, 'spiky oreo').
ncbi_mult_taxo_gbnm(181450, 'armoured stickleback').
ncbi_mult_taxo_gbnm(181452, 'marbled swamp eel').
ncbi_mult_taxo_gbnm(181453, 'plain helmet gurnard').
ncbi_mult_taxo_gbnm(181459, 'smooth lumpsucker').
ncbi_mult_taxo_gbnm(181461, 'bluefin trevally').
ncbi_mult_taxo_gbnm(181462, rovers).
ncbi_mult_taxo_gbnm(181466, 'dark-banded fusilier').
ncbi_mult_taxo_gbnm(181472, 'jewelled blenny').
ncbi_mult_taxo_gbnm(181478, 'masked triggerfish').
ncbi_mult_taxo_gbnm(181539, 'Rock cavy').
ncbi_mult_taxo_gbnm(181607, 'brassy minnow').
ncbi_mult_taxo_gbnm(181609, 'virgin spinedace').
ncbi_mult_taxo_gbnm(181611, 'White River spinedace').
ncbi_mult_taxo_gbnm(181613, 'Moapa dace').
ncbi_mult_taxo_gbnm(181614, 'river chub').
ncbi_mult_taxo_gbnm(181616, woundfin).
ncbi_mult_taxo_gbnm(181631, 'rufous-capped babbler').
ncbi_mult_taxo_gbnm(181671, 'spotted butterfly lizard').
ncbi_mult_taxo_gbnm(181836, 'Magnificent riflebird').
ncbi_mult_taxo_gbnm(182070, 'creeping saxifrage').
ncbi_mult_taxo_gbnm(182105, 'weeping fig').
ncbi_mult_taxo_gbnm(182112, 'rubber plant').
ncbi_mult_taxo_gbnm(182125, 'Port Jackson fig').
ncbi_mult_taxo_gbnm(182129, 'sycamore fig').
ncbi_mult_taxo_gbnm(182134, 'bean spider mite').
ncbi_mult_taxo_gbnm(182221, 'worm eels').
ncbi_mult_taxo_gbnm(182223, 'Japanese smelt').
ncbi_mult_taxo_gbnm(182225, 'Stokell\'s smelt').
ncbi_mult_taxo_gbnm(182227, 'Australian grayling').
ncbi_mult_taxo_gbnm(182228, 'Australian smelt').
ncbi_mult_taxo_gbnm(182234, icefishes).
ncbi_mult_taxo_gbnm(182256, 'howler monkey').
ncbi_mult_taxo_gbnm(182351, 'Burmese glass lizard').
ncbi_mult_taxo_gbnm(182417, 'key worm eel').
ncbi_mult_taxo_gbnm(182419, 'broadnose worm eel').
ncbi_mult_taxo_gbnm(182420, 'speckled worm eel').
ncbi_mult_taxo_gbnm(182421, 'bandtooth conger').
ncbi_mult_taxo_gbnm(182423, 'seagrass eel').
ncbi_mult_taxo_gbnm(182426, 'collared eel').
ncbi_mult_taxo_gbnm(182427, 'Pacific ladyfish').
ncbi_mult_taxo_gbnm(182429, 'dogface witch-eel').
ncbi_mult_taxo_gbnm(182431, 'spotted pike-conger').
ncbi_mult_taxo_gbnm(182433, 'surf eel').
ncbi_mult_taxo_gbnm(182435, 'sharptail eel').
ncbi_mult_taxo_gbnm(182436, 'palespotted eel').
ncbi_mult_taxo_gbnm(182437, 'chestnut moray').
ncbi_mult_taxo_gbnm(182438, 'spotted moray').
ncbi_mult_taxo_gbnm(182440, 'Bean\'s sawtoothed eel').
ncbi_mult_taxo_gbnm(182642, 'goldlined seabream').
ncbi_mult_taxo_gbnm(182645, 'forktail large-eye bream').
ncbi_mult_taxo_gbnm(182646, 'blue-lined large-eye bream').
ncbi_mult_taxo_gbnm(182647, 'grey large-eye bream').
ncbi_mult_taxo_gbnm(182648, 'Pacific yellowtail emperor').
ncbi_mult_taxo_gbnm(182649, 'Atlantic emperor').
ncbi_mult_taxo_gbnm(182650, 'snubnose emperor').
ncbi_mult_taxo_gbnm(182651, 'orange-spotted emperor').
ncbi_mult_taxo_gbnm(182652, 'longfin emperor').
ncbi_mult_taxo_gbnm(182653, 'longspine emperor').
ncbi_mult_taxo_gbnm(182654, 'thumbprint emperor').
ncbi_mult_taxo_gbnm(182655, 'grass emperor').
ncbi_mult_taxo_gbnm(182656, 'pink ear emperor').
ncbi_mult_taxo_gbnm(182657, 'smalltooth emperor').
ncbi_mult_taxo_gbnm(182658, 'spangled emperor').
ncbi_mult_taxo_gbnm(182659, 'orange striped emperor').
ncbi_mult_taxo_gbnm(182660, 'longface emperor').
ncbi_mult_taxo_gbnm(182661, 'red snout emperor').
ncbi_mult_taxo_gbnm(182662, 'black blotch emperor').
ncbi_mult_taxo_gbnm(182664, 'Mozambique large-eye bream').
ncbi_mult_taxo_gbnm(182665, 'blue and gold fusilier').
ncbi_mult_taxo_gbnm(182667, 'mottled fusilier').
ncbi_mult_taxo_gbnm(182669, 'gracile shrew mole').
ncbi_mult_taxo_gbnm(182780, alfonsino).
ncbi_mult_taxo_gbnm(182801, 'fringed-lipped peninsula carp').
ncbi_mult_taxo_gbnm(182802, 'pigmouth carp').
ncbi_mult_taxo_gbnm(182852, 'starry ray').
ncbi_mult_taxo_gbnm(182853, 'brown ray').
ncbi_mult_taxo_gbnm(182854, 'longnosed skate').
ncbi_mult_taxo_gbnm(182855, 'undulate ray').
ncbi_mult_taxo_gbnm(182879, 'puff-throated bulbul').
ncbi_mult_taxo_gbnm(182880, 'Common bristlebill').
ncbi_mult_taxo_gbnm(182881, 'bearded bulbul').
ncbi_mult_taxo_gbnm(182882, 'scrub bulbul').
ncbi_mult_taxo_gbnm(182883, 'red-tailed bulbul').
ncbi_mult_taxo_gbnm(182884, 'white-throated bulbul').
ncbi_mult_taxo_gbnm(182885, 'white-bearded bulbul').
ncbi_mult_taxo_gbnm(182886, 'ochraceous bulbul').
ncbi_mult_taxo_gbnm(182887, 'yellow-bearded bulbul').
ncbi_mult_taxo_gbnm(182888, 'yellow-bellied bulbul').
ncbi_mult_taxo_gbnm(182890, 'Asian black bulbul').
ncbi_mult_taxo_gbnm(182891, 'Mountain bulbul').
ncbi_mult_taxo_gbnm(182896, 'stripe-throated bulbul').
ncbi_mult_taxo_gbnm(182897, 'red-whiskered bulbul').
ncbi_mult_taxo_gbnm(182907, 'pine warbler').
ncbi_mult_taxo_gbnm(182909, 'Kentucky warbler').
ncbi_mult_taxo_gbnm(182910, 'Canada warbler').
ncbi_mult_taxo_gbnm(182921, 'whistling warbler').
ncbi_mult_taxo_gbnm(182925, 'red warbler').
ncbi_mult_taxo_gbnm(182932, 'worm-eating warbler').
ncbi_mult_taxo_gbnm(182936, 'black-and-white warbler').
ncbi_mult_taxo_gbnm(182938, 'brown-capped redstart').
ncbi_mult_taxo_gbnm(182944, 'Prothonotary warbler').
ncbi_mult_taxo_gbnm(182946, ovenbird).
ncbi_mult_taxo_gbnm(182947, 'northern waterthrush').
ncbi_mult_taxo_gbnm(182955, 'Wrenthrush').
ncbi_mult_taxo_gbnm(183150, 'Chinese medaka').
ncbi_mult_taxo_gbnm(183151, 'Candidius goby').
ncbi_mult_taxo_gbnm(183153, 'Cactus canastero').
ncbi_mult_taxo_gbnm(183154, 'rufous-capped spinetail').
ncbi_mult_taxo_gbnm(183155, 'Spillman\'s tapaculo').
ncbi_mult_taxo_gbnm(183177, 'great rufous woodcreeper').
ncbi_mult_taxo_gbnm(183179, 'plain-brown woodcreeper').
ncbi_mult_taxo_gbnm(183220, aibika).
ncbi_mult_taxo_gbnm(183260, roselle).
ncbi_mult_taxo_gbnm(183267, 'sea hibiscus').
ncbi_mult_taxo_gbnm(183268, 'flower-of-an-hour').
ncbi_mult_taxo_gbnm(183298, 'Chinese hibiscus').
ncbi_mult_taxo_gbnm(183318, 'dwarf gorse').
ncbi_mult_taxo_gbnm(183418, 'Himalayan honeybee').
ncbi_mult_taxo_gbnm(183510, hardhead).
ncbi_mult_taxo_gbnm(183522, 'western wood-pewee').
ncbi_mult_taxo_gbnm(183525, 'Pacific-slope flycatcher').
ncbi_mult_taxo_gbnm(183598, 'Kosempo keelback').
ncbi_mult_taxo_gbnm(183602, 'Striped crayfish snake').
ncbi_mult_taxo_gbnm(183606, 'Rough earth snake').
ncbi_mult_taxo_gbnm(183609, 'Harters water snake').
ncbi_mult_taxo_gbnm(183611, 'Graham\'s crayfish snake').
ncbi_mult_taxo_gbnm(183612, 'Crayfish snake').
ncbi_mult_taxo_gbnm(183651, 'American fourspot flounder').
ncbi_mult_taxo_gbnm(183653, 'American butterfish').
ncbi_mult_taxo_gbnm(183654, windowpane).
ncbi_mult_taxo_gbnm(183656, 'red hake').
ncbi_mult_taxo_gbnm(183657, 'white hake').
ncbi_mult_taxo_gbnm(183658, 'southern short-tailed shrew').
ncbi_mult_taxo_gbnm(183659, 'Elliot\'s short-tailed shrew').
ncbi_mult_taxo_gbnm(183661, 'least shrew').
ncbi_mult_taxo_gbnm(183663, 'red-toothed shrews').
ncbi_mult_taxo_gbnm(183715, snailfishes).
ncbi_mult_taxo_gbnm(183721, 'Asian lesser white-toothed shrew').
ncbi_mult_taxo_gbnm(183821, 'Dunn\'s white gum').
ncbi_mult_taxo_gbnm(183822, mallalie).
ncbi_mult_taxo_gbnm(183904, 'Kanawha darter').
ncbi_mult_taxo_gbnm(183906, 'Nepalese snowtrout').
ncbi_mult_taxo_gbnm(183908, 'Dinnawah snowtrout').
ncbi_mult_taxo_gbnm(183910, 'snow trout').
ncbi_mult_taxo_gbnm(184086, 'African giant black millipede').
ncbi_mult_taxo_gbnm(184136, 'buffalo gourd').
ncbi_mult_taxo_gbnm(184140, chayote).
ncbi_mult_taxo_gbnm(184141, 'pattypan squash').
ncbi_mult_taxo_gbnm(184156, 'Japanese coral snake').
ncbi_mult_taxo_gbnm(184164, 'Montpellier snake').
ncbi_mult_taxo_gbnm(184165, 'Moila snake').
ncbi_mult_taxo_gbnm(184213, 'brownbanded moon jelly').
ncbi_mult_taxo_gbnm(184215, 'American sand lance').
ncbi_mult_taxo_gbnm(184234, 'Johnstone river crocodile').
ncbi_mult_taxo_gbnm(184236, 'Philippine crocodile').
ncbi_mult_taxo_gbnm(184237, 'Morelet\'s crocodile').
ncbi_mult_taxo_gbnm(184238, 'marsh crocodile').
ncbi_mult_taxo_gbnm(184239, 'Cuban crocodile').
ncbi_mult_taxo_gbnm(184240, 'Orinoco crocodile').
ncbi_mult_taxo_gbnm(184242, 'dwarf crocodile').
ncbi_mult_taxo_gbnm(184245, 'false gharial').
ncbi_mult_taxo_gbnm(184396, 'Spinifex hopping mouse').
ncbi_mult_taxo_gbnm(184433, 'Graery threadfin seabass').
ncbi_mult_taxo_gbnm(184434, 'blue hamlet').
ncbi_mult_taxo_gbnm(184435, camotillo).
ncbi_mult_taxo_gbnm(184436, 'parrot sand bass').
ncbi_mult_taxo_gbnm(184437, 'goldspotted sand bass').
ncbi_mult_taxo_gbnm(184438, vieja).
ncbi_mult_taxo_gbnm(184440, 'black sea bass').
ncbi_mult_taxo_gbnm(184441, 'lantern bass').
ncbi_mult_taxo_gbnm(184442, 'Peruvian rock seabass').
ncbi_mult_taxo_gbnm(184444, 'inshore sand perch').
ncbi_mult_taxo_gbnm(184445, 'southern rock bass').
ncbi_mult_taxo_gbnm(184447, 'popeye catalufa').
ncbi_mult_taxo_gbnm(184449, 'giant sea bass').
ncbi_mult_taxo_gbnm(184451, 'chain pickerel').
ncbi_mult_taxo_gbnm(184539, 'spotted asparagus beetle').
ncbi_mult_taxo_gbnm(184545, 'Uracoan rattlesnake').
ncbi_mult_taxo_gbnm(184585, 'European anchovy').
ncbi_mult_taxo_gbnm(184711, 'barnacle goose').
ncbi_mult_taxo_gbnm(184780, 'African slender-snouted crocodile').
ncbi_mult_taxo_gbnm(184783, 'betel palm').
ncbi_mult_taxo_gbnm(184920, 'Giant Hawaiian goose').
ncbi_mult_taxo_gbnm(184935, 'gravel ghost').
ncbi_mult_taxo_gbnm(184942, 'sagebrush false dandelion').
ncbi_mult_taxo_gbnm(184946, brightwhite).
ncbi_mult_taxo_gbnm(184985, 'pygmy-flower rock-jasmine').
ncbi_mult_taxo_gbnm(185002, 'blond plantain').
ncbi_mult_taxo_gbnm(185004, 'knotted thread hydroid').
ncbi_mult_taxo_gbnm(185048, honeyvine).
ncbi_mult_taxo_gbnm(185215, 'lesser roundleaf bat').
ncbi_mult_taxo_gbnm(185238, 'greater periwinkle').
ncbi_mult_taxo_gbnm(185354, 'warty thick-toed gecko').
ncbi_mult_taxo_gbnm(185430, 'grass pickerel').
ncbi_mult_taxo_gbnm(185453, 'Cape golden mole').
ncbi_mult_taxo_gbnm(185454, 'Stuhlmann\'s golden mole').
ncbi_mult_taxo_gbnm(185474, 'Gravenhorst\'s mabuya').
ncbi_mult_taxo_gbnm(185477, 'Boettger\'s mabuya').
ncbi_mult_taxo_gbnm(185536, 'myrtle dahoon').
ncbi_mult_taxo_gbnm(185542, 'yerba mate').
ncbi_mult_taxo_gbnm(185559, winterberry).
ncbi_mult_taxo_gbnm(185586, 'corn crake').
ncbi_mult_taxo_gbnm(185689, 'blackish oystercatcher').
ncbi_mult_taxo_gbnm(185716, 'threeleaf derris').
ncbi_mult_taxo_gbnm(185732, 'arrow goby').
ncbi_mult_taxo_gbnm(185734, 'East Siberian cod').
ncbi_mult_taxo_gbnm(185735, 'Arctic cod').
ncbi_mult_taxo_gbnm(185737, 'silvery cod').
ncbi_mult_taxo_gbnm(185738, 'blue ling').
ncbi_mult_taxo_gbnm(185739, pollack).
ncbi_mult_taxo_gbnm(185744, 'cheekspot goby').
ncbi_mult_taxo_gbnm(185746, 'bay goby').
ncbi_mult_taxo_gbnm(185748, 'American shadow goby').
ncbi_mult_taxo_gbnm(185815, 'primitive burrowing mayflies').
ncbi_mult_taxo_gbnm(185816, 'burrowing mayflies').
ncbi_mult_taxo_gbnm(185876, 'water ladybird').
ncbi_mult_taxo_gbnm(185877, 'scarce seven-spotted ladybird').
ncbi_mult_taxo_gbnm(185878, 'eleven-spotted ladybird').
ncbi_mult_taxo_gbnm(185882, 'broadbarred firefish').
ncbi_mult_taxo_gbnm(185883, 'devil firefish').
ncbi_mult_taxo_gbnm(185884, 'frillfin turkeyfish').
ncbi_mult_taxo_gbnm(185885, 'radial firefish').
ncbi_mult_taxo_gbnm(185886, 'red lionfish').
ncbi_mult_taxo_gbnm(185887, 'shortfin turkeyfish').
ncbi_mult_taxo_gbnm(186067, 'red flat bark beetle').
ncbi_mult_taxo_gbnm(186087, 'checkered beetles').
ncbi_mult_taxo_gbnm(186093, 'soft-winged flower beetles').
ncbi_mult_taxo_gbnm(186110, carpenterworm).
ncbi_mult_taxo_gbnm(186143, 'common true katydid').
ncbi_mult_taxo_gbnm(186148, 'porphyrina blow fly').
ncbi_mult_taxo_gbnm(186169, 'Cunningham\'s skink').
ncbi_mult_taxo_gbnm(186201, 'guinea pig lice').
ncbi_mult_taxo_gbnm(186210, 'brown chicken louse').
ncbi_mult_taxo_gbnm(186211, 'giant chicken louse').
ncbi_mult_taxo_gbnm(186214, 'sheep biting louse').
ncbi_mult_taxo_gbnm(186218, 'pale lice').
ncbi_mult_taxo_gbnm(186376, 'leaf-footed bugs').
ncbi_mult_taxo_gbnm(186378, 'golden egg bug').
ncbi_mult_taxo_gbnm(186474, 'great gerbil').
ncbi_mult_taxo_gbnm(186543, 'red-black striped snake').
ncbi_mult_taxo_gbnm(186552, 'ornate wolf snake').
ncbi_mult_taxo_gbnm(186554, 'false smooth snake').
ncbi_mult_taxo_gbnm(186574, 'buff striped keelback').
ncbi_mult_taxo_gbnm(186578, 'red-tailed pipe snake').
ncbi_mult_taxo_gbnm(186589, 'Guenther\'s kukri snake').
ncbi_mult_taxo_gbnm(186600, 'Rhinoceros ratsnake').
ncbi_mult_taxo_gbnm(186602, 'Variable ground snake').
ncbi_mult_taxo_gbnm(186605, 'Florida crowned snake').
ncbi_mult_taxo_gbnm(186611, 'black tree snake').
ncbi_mult_taxo_gbnm(186613, 'Fischer\'s cat snake').
ncbi_mult_taxo_gbnm(186615, 'Phillipps\' earth snake').
ncbi_mult_taxo_gbnm(186833, 'Lidwill\'s dwarfgoby').
ncbi_mult_taxo_gbnm(186836, 'drain mangrovegoby').
ncbi_mult_taxo_gbnm(186980, 'riffle beetles').
ncbi_mult_taxo_gbnm(186990, 'great roundleaf bat').
ncbi_mult_taxo_gbnm(186994, 'Old World leaf-nosed bats').
ncbi_mult_taxo_gbnm(187002, 'East Asian tailless leaf-nosed bat').
ncbi_mult_taxo_gbnm(187003, 'black-bearded tomb bat').
ncbi_mult_taxo_gbnm(187007, 'Japanese long-fingered bat').
ncbi_mult_taxo_gbnm(187009, 'Eastern barbastelle').
ncbi_mult_taxo_gbnm(187016, 'Flores tube-nosed bat').
ncbi_mult_taxo_gbnm(187017, 'Greater tube-nosed bat').
ncbi_mult_taxo_gbnm(187018, 'Taiwanese tube-nosed bat').
ncbi_mult_taxo_gbnm(187019, 'Ryukyu tube-nosed bat').
ncbi_mult_taxo_gbnm(187021, 'Ussurian tube-nosed bat').
ncbi_mult_taxo_gbnm(187106, 'Nicobar pigeon').
ncbi_mult_taxo_gbnm(187109, 'croaking ground-dove').
ncbi_mult_taxo_gbnm(187118, 'passenger pigeon').
ncbi_mult_taxo_gbnm(187124, 'Victoria crowned-pigeon').
ncbi_mult_taxo_gbnm(187126, 'pink pigeon').
ncbi_mult_taxo_gbnm(187128, 'crested pigeon').
ncbi_mult_taxo_gbnm(187135, 'Dodo').
ncbi_mult_taxo_gbnm(187138, 'black-naped fruit-dove').
ncbi_mult_taxo_gbnm(187143, 'blue-spotted wood-dove').
ncbi_mult_taxo_gbnm(187268, 'plains mouse').
ncbi_mult_taxo_gbnm(187287, 'Bocono rocket frog').
ncbi_mult_taxo_gbnm(187288, 'fingered poison frogs').
ncbi_mult_taxo_gbnm(187289, 'collared poison frog').
ncbi_mult_taxo_gbnm(187290, 'Hermina\'s poison frog').
ncbi_mult_taxo_gbnm(187292, 'Las Playitas rocket frog').
ncbi_mult_taxo_gbnm(187318, 'pumpkin fruit fly').
ncbi_mult_taxo_gbnm(187331, 'stone loach').
ncbi_mult_taxo_gbnm(187382, 'Macqueen\'s bustard').
ncbi_mult_taxo_gbnm(187398, 'Broom Hare').
ncbi_mult_taxo_gbnm(187415, 'grosbeak weaver').
ncbi_mult_taxo_gbnm(187442, 'bush Petronia').
ncbi_mult_taxo_gbnm(187443, 'spectacled weaver').
ncbi_mult_taxo_gbnm(187445, 'red-billed quelea').
ncbi_mult_taxo_gbnm(187451, 'Pin-tailed whydah').
ncbi_mult_taxo_gbnm(187462, 'Taiwan yellow cedar').
ncbi_mult_taxo_gbnm(187463, 'Atlantic white cedar').
ncbi_mult_taxo_gbnm(187484, 'gray-eyed frogs').
ncbi_mult_taxo_gbnm(187485, 'gray-eyed frog').
ncbi_mult_taxo_gbnm(187802, 'corrugated ribbon worm').
ncbi_mult_taxo_gbnm(187859, 'black woodpecker').
ncbi_mult_taxo_gbnm(187924, 'minute leaf chameleon').
ncbi_mult_taxo_gbnm(187945, 'Senegal chameleon').
ncbi_mult_taxo_gbnm(187952, 'black jumping salamander').
ncbi_mult_taxo_gbnm(187954, 'Townsend\'s dwarf salamander').
ncbi_mult_taxo_gbnm(187955, 'Anita\'s false brook salamander').
ncbi_mult_taxo_gbnm(187956, 'Bell\'s false brook salamander').
ncbi_mult_taxo_gbnm(187957, 'brown false brook salamander').
ncbi_mult_taxo_gbnm(187958, 'chunky false brook salamander').
ncbi_mult_taxo_gbnm(187959, 'Conant\'s false brook salamander').
ncbi_mult_taxo_gbnm(187960, 'Jalpa false brook salamander').
ncbi_mult_taxo_gbnm(187961, 'Gadow\'s false brook salamander').
ncbi_mult_taxo_gbnm(187962, 'Galaena false brook salamander').
ncbi_mult_taxo_gbnm(187963, 'Goebel\'s false brook salamander').
ncbi_mult_taxo_gbnm(187964, 'black false brook salamander').
ncbi_mult_taxo_gbnm(187965, 'black-spotted false salamander').
ncbi_mult_taxo_gbnm(187966, 'royal false brook salamander').
ncbi_mult_taxo_gbnm(187967, 'Tamaulipan false brook salamander').
ncbi_mult_taxo_gbnm(187968, 'Guerreran mushroomtongue salamander').
ncbi_mult_taxo_gbnm(187969, 'Oaxacan mushroomtongue salamander').
ncbi_mult_taxo_gbnm(187970, 'Rilett\'s mushroomtongue salamander').
ncbi_mult_taxo_gbnm(188085, 'bignose galaxias').
ncbi_mult_taxo_gbnm(188103, 'midnight parrotfish').
ncbi_mult_taxo_gbnm(188104, 'rainbow parrotfish').
ncbi_mult_taxo_gbnm(188105, 'yellowfin parrotfish').
ncbi_mult_taxo_gbnm(188107, 'bicolor parrotfish').
ncbi_mult_taxo_gbnm(188108, 'knothead parrotfish').
ncbi_mult_taxo_gbnm(188110, 'green humphead parrotfish').
ncbi_mult_taxo_gbnm(188112, 'Caroline\'s parrotfish').
ncbi_mult_taxo_gbnm(188114, 'Pacific longnose parrotfish').
ncbi_mult_taxo_gbnm(188117, 'harlequin tuskfish').
ncbi_mult_taxo_gbnm(188119, 'chiseltooth wrasse').
ncbi_mult_taxo_gbnm(188122, 'golden livebearer').
ncbi_mult_taxo_gbnm(188123, 'Balsas livebearer').
ncbi_mult_taxo_gbnm(188124, 'Catemaco livebearer').
ncbi_mult_taxo_gbnm(188125, 'elongate toothcarp').
ncbi_mult_taxo_gbnm(188126, 'San Jeronimo livebearer').
ncbi_mult_taxo_gbnm(188127, 'Upper Grijalva livebearer').
ncbi_mult_taxo_gbnm(188128, 'Lerma livebearer').
ncbi_mult_taxo_gbnm(188129, 'lowland livebearer').
ncbi_mult_taxo_gbnm(188131, 'Sinaloa livebearer').
ncbi_mult_taxo_gbnm(188132, 'blackstripe livebearer').
ncbi_mult_taxo_gbnm(188134, 'Michoacan livebearer').
ncbi_mult_taxo_gbnm(188135, 'blackspotted livebearer').
ncbi_mult_taxo_gbnm(188137, 'chubby livebearer').
ncbi_mult_taxo_gbnm(188138, 'Yaqui topminnow').
ncbi_mult_taxo_gbnm(188338, 'European roller').
ncbi_mult_taxo_gbnm(188340, 'broad-billed roller').
ncbi_mult_taxo_gbnm(188344, 'cuckoo roller').
ncbi_mult_taxo_gbnm(188375, 'Chinese pond heron').
ncbi_mult_taxo_gbnm(188379, 'little egret').
ncbi_mult_taxo_gbnm(188380, 'cinnamon bittern').
ncbi_mult_taxo_gbnm(188477, 'eastern emerald elysia').
ncbi_mult_taxo_gbnm(188493, 'torch ginger').
ncbi_mult_taxo_gbnm(188535, 'giant false brook salamander').
ncbi_mult_taxo_gbnm(188536, 'Japanese wolf').
ncbi_mult_taxo_gbnm(188543, 'follicle mites').
ncbi_mult_taxo_gbnm(188545, 'dog follicle mite').
ncbi_mult_taxo_gbnm(188568, 'Stoliczka\'s trident bat').
ncbi_mult_taxo_gbnm(188569, 'Pratt\'s roundleaf bat').
ncbi_mult_taxo_gbnm(188736, 'wombat tick').
ncbi_mult_taxo_gbnm(188755, 'American black flour beetle').
ncbi_mult_taxo_gbnm(188756, 'large flour beetle').
ncbi_mult_taxo_gbnm(188763, 'Chimpanzee cytomegalovirus').
ncbi_mult_taxo_gbnm(188791, 'blotched snakehead').
ncbi_mult_taxo_gbnm(188929, 'small snakehead').
ncbi_mult_taxo_gbnm(188934, 'pond pine').
ncbi_mult_taxo_gbnm(189294, 'Chinese warty newt').
ncbi_mult_taxo_gbnm(189295, 'Wanggao warty newt').
ncbi_mult_taxo_gbnm(189314, 'kite swallowtails').
ncbi_mult_taxo_gbnm(189315, 'fluted swallowtails').
ncbi_mult_taxo_gbnm(189338, 'Acadian hermit crab').
ncbi_mult_taxo_gbnm(189339, 'Alaskan hermit crab').
ncbi_mult_taxo_gbnm(189388, 'Mediterranean horse mackerel').
ncbi_mult_taxo_gbnm(189389, 'blue jack mackerel').
ncbi_mult_taxo_gbnm(189481, 'flat-nosed xenocongrid eel').
ncbi_mult_taxo_gbnm(189482, 'arrowtooth eels').
ncbi_mult_taxo_gbnm(189484, 'shortbelly eel').
ncbi_mult_taxo_gbnm(189485, 'garden eels').
ncbi_mult_taxo_gbnm(189490, 'Taiwan sardinella').
ncbi_mult_taxo_gbnm(189491, 'snubnosed parasitic eel').
ncbi_mult_taxo_gbnm(189493, 'snubnosed eel').
ncbi_mult_taxo_gbnm(189496, 'tidepool snake moray').
ncbi_mult_taxo_gbnm(189499, tenpounder).
ncbi_mult_taxo_gbnm(189503, 'shorttail pike conger').
ncbi_mult_taxo_gbnm(189504, 'bighead beaked sandfish').
ncbi_mult_taxo_gbnm(189506, 'duckbill oceanic eel').
ncbi_mult_taxo_gbnm(189510, 'longfin snake-eel').
ncbi_mult_taxo_gbnm(189526, 'Eurasian wryneck').
ncbi_mult_taxo_gbnm(189533, 'lesser scaup').
ncbi_mult_taxo_gbnm(189534, 'greater scaup').
ncbi_mult_taxo_gbnm(189535, 'ring-necked duck').
ncbi_mult_taxo_gbnm(189654, 'rock-dwelling leaf-eared mouse').
ncbi_mult_taxo_gbnm(189786, 'Athel tamarisk').
ncbi_mult_taxo_gbnm(189920, 'spring peeper').
ncbi_mult_taxo_gbnm(189922, 'blacktail buckbill eel').
ncbi_mult_taxo_gbnm(189923, 'grey cutthroat').
ncbi_mult_taxo_gbnm(189925, 'slender conger').
ncbi_mult_taxo_gbnm(189976, 'marama bean').
ncbi_mult_taxo_gbnm(189979, 'St. Mark\'s fly').
ncbi_mult_taxo_gbnm(190106, 'blackedge conger').
ncbi_mult_taxo_gbnm(190107, 'silvery conger').
ncbi_mult_taxo_gbnm(190111, 'lesser thick-tailed scorpions').
ncbi_mult_taxo_gbnm(190112, 'pygmy thick-tailed scorpions').
ncbi_mult_taxo_gbnm(190152, 'Cape parrot').
ncbi_mult_taxo_gbnm(190224, 'northern dewberry').
ncbi_mult_taxo_gbnm(190226, 'Andean raspberry').
ncbi_mult_taxo_gbnm(190243, 'Chinese parasol-tree').
ncbi_mult_taxo_gbnm(190274, 'mink frog').
ncbi_mult_taxo_gbnm(190275, 'Florida bog frog').
ncbi_mult_taxo_gbnm(190276, 'river frog').
ncbi_mult_taxo_gbnm(190277, 'pig frog').
ncbi_mult_taxo_gbnm(190278, 'carpenter frog').
ncbi_mult_taxo_gbnm(190284, 'ocellated woodcreeper').
ncbi_mult_taxo_gbnm(190287, 'Cocoa woodcreeper').
ncbi_mult_taxo_gbnm(190289, 'Amazonian barred-woodcreeper').
ncbi_mult_taxo_gbnm(190301, 'Cinnamon-throated woodcreeper').
ncbi_mult_taxo_gbnm(190303, 'red-billed scythebill').
ncbi_mult_taxo_gbnm(190330, 'triangle orache').
ncbi_mult_taxo_gbnm(190331, 'dotted border').
ncbi_mult_taxo_gbnm(190333, 'yellow belle').
ncbi_mult_taxo_gbnm(190335, 'clouded magpie').
ncbi_mult_taxo_gbnm(190336, pugs).
ncbi_mult_taxo_gbnm(190337, 'V-pug').
ncbi_mult_taxo_gbnm(190347, 'common carpet').
ncbi_mult_taxo_gbnm(190354, 'small dusty wave').
ncbi_mult_taxo_gbnm(190356, 'willow beauty').
ncbi_mult_taxo_gbnm(190361, 'tawny wave').
ncbi_mult_taxo_gbnm(190364, 'black-veined moth').
ncbi_mult_taxo_gbnm(190369, 'dark-barred twin-spot carpet').
ncbi_mult_taxo_gbnm(190403, 'Greater Antillean elaenia').
ncbi_mult_taxo_gbnm(190472, 'highland punare').
ncbi_mult_taxo_gbnm(190473, 'Parguayan punare').
ncbi_mult_taxo_gbnm(190476, 'Broad-snouted caiman').
ncbi_mult_taxo_gbnm(190508, 'Goldman\'s nectar bat').
ncbi_mult_taxo_gbnm(190515, 'monk fruit').
ncbi_mult_taxo_gbnm(190548, 'bog bilberry').
ncbi_mult_taxo_gbnm(190632, birnengitterrost).
ncbi_mult_taxo_gbnm(190671, 'Virginia\'s warbler').
ncbi_mult_taxo_gbnm(190756, 'great leadtree').
ncbi_mult_taxo_gbnm(190757, 'goldenball leadtree').
ncbi_mult_taxo_gbnm(190794, machaca).
ncbi_mult_taxo_gbnm(190797, 'carp headstander').
ncbi_mult_taxo_gbnm(190802, spiderwisp).
ncbi_mult_taxo_gbnm(190804, 'Asian spiderflower').
ncbi_mult_taxo_gbnm(190814, 'Galapagos opuntia weevil').
ncbi_mult_taxo_gbnm(190870, 'plateau fence lizard').
ncbi_mult_taxo_gbnm(190875, 'White Sands prairie lizard').
ncbi_mult_taxo_gbnm(190884, 'wild candytuft').
ncbi_mult_taxo_gbnm(190903, 'Queensland bottletree').
ncbi_mult_taxo_gbnm(191002, 'tropical blueberry').
ncbi_mult_taxo_gbnm(191034, 'Japanese badger').
ncbi_mult_taxo_gbnm(191066, 'black crowberry').
ncbi_mult_taxo_gbnm(191075, 'northern yellow boxwood').
ncbi_mult_taxo_gbnm(191197, 'Buerger\'s frog').
ncbi_mult_taxo_gbnm(191198, 'red-headed flying frog').
ncbi_mult_taxo_gbnm(191199, 'Vietnam bubble-nest frog').
ncbi_mult_taxo_gbnm(191200, 'Doria\'s Asian treefrog').
ncbi_mult_taxo_gbnm(191201, 'spiny Indonesian treefrog').
ncbi_mult_taxo_gbnm(191202, 'Philippine bubble-nest frog').
ncbi_mult_taxo_gbnm(191203, 'Luzon bubble-nest frog').
ncbi_mult_taxo_gbnm(191204, 'Annam flying frog').
ncbi_mult_taxo_gbnm(191205, 'Himalaya flying frog').
ncbi_mult_taxo_gbnm(191206, 'hill garden bug-eyed frog').
ncbi_mult_taxo_gbnm(191247, 'Fraser\'s clawed frog').
ncbi_mult_taxo_gbnm(191316, 'black bean aphid').
ncbi_mult_taxo_gbnm(191382, 'Golan Heights blind mole rat').
ncbi_mult_taxo_gbnm(191398, 'silver meadow fritillary').
ncbi_mult_taxo_gbnm(191418, 'meadow brown').
ncbi_mult_taxo_gbnm(191420, 'Ferentina calico').
ncbi_mult_taxo_gbnm(191427, 'one-spotted prepona').
ncbi_mult_taxo_gbnm(191447, 'New Zealand owlet-nightjar').
ncbi_mult_taxo_gbnm(191473, 'Corsican painted frog').
ncbi_mult_taxo_gbnm(191474, 'Tyrrhenian painted frog').
ncbi_mult_taxo_gbnm(191476, 'Caucasus parsley frog').
ncbi_mult_taxo_gbnm(191477, 'common spadefoot toad').
ncbi_mult_taxo_gbnm(191480, 'Carvalho\'s Surinam toad').
ncbi_mult_taxo_gbnm(191528, 'great rhododendron').
ncbi_mult_taxo_gbnm(191529, 'shiny blueberry').
ncbi_mult_taxo_gbnm(191607, 'Transcaspian urial').
ncbi_mult_taxo_gbnm(191615, 'Ruwenzori reed frog').
ncbi_mult_taxo_gbnm(191616, 'cinnamon-bellied reed frog').
ncbi_mult_taxo_gbnm(191617, 'Munsenene reed frog').
ncbi_mult_taxo_gbnm(191618, 'golden-eyed reed frog').
ncbi_mult_taxo_gbnm(191619, 'white-snouted reed frog').
ncbi_mult_taxo_gbnm(191620, 'dotted reed frog').
ncbi_mult_taxo_gbnm(191622, 'water lily reed frog').
ncbi_mult_taxo_gbnm(191664, sacahuista).
ncbi_mult_taxo_gbnm(191669, 'salt sandspurry').
ncbi_mult_taxo_gbnm(191678, 'black-bellied angler').
ncbi_mult_taxo_gbnm(191705, 'uglynest caterpillar').
ncbi_mult_taxo_gbnm(191709, 'black shield leafroller').
ncbi_mult_taxo_gbnm(191712, 'dusty-back leafroller').
ncbi_mult_taxo_gbnm(191716, 'European leafroller').
ncbi_mult_taxo_gbnm(191717, 'oak leafroller').
ncbi_mult_taxo_gbnm(191724, 'grey wrasse').
ncbi_mult_taxo_gbnm(191725, 'Baillon\'s wrasse').
ncbi_mult_taxo_gbnm(191726, 'five-spotted wrasse').
ncbi_mult_taxo_gbnm(191813, 'Greenland sleeper shark').
ncbi_mult_taxo_gbnm(191816, 'Spanish lynx').
ncbi_mult_taxo_gbnm(191870, 'Agile Gracile Mouse Opossum').
ncbi_mult_taxo_gbnm(191871, 'elegant fat-tailed opossum').
ncbi_mult_taxo_gbnm(191872, 'long-tailed fat-tailed opossum').
ncbi_mult_taxo_gbnm(191873, 'Common fat-tailed mouse opossum').
ncbi_mult_taxo_gbnm(191875, 'ant blues').
ncbi_mult_taxo_gbnm(191876, 'arcana ant blue').
ncbi_mult_taxo_gbnm(191891, 'yellow bird-of-paradise shrub').
ncbi_mult_taxo_gbnm(191921, 'yeheb bush').
ncbi_mult_taxo_gbnm(191959, 'golden ant blue').
ncbi_mult_taxo_gbnm(191962, 'large ant blue').
ncbi_mult_taxo_gbnm(191963, 'cuprea ant blue').
ncbi_mult_taxo_gbnm(191964, 'hirtipes ant blue').
ncbi_mult_taxo_gbnm(191965, 'Illidge\'s ant blue').
ncbi_mult_taxo_gbnm(191966, 'black ant blue').
ncbi_mult_taxo_gbnm(191968, 'small ant blue').
ncbi_mult_taxo_gbnm(191970, 'small copper').
ncbi_mult_taxo_gbnm(191976, 'dull copper').
ncbi_mult_taxo_gbnm(191978, 'cephenes blue').
ncbi_mult_taxo_gbnm(191980, 'fiery jewel').
ncbi_mult_taxo_gbnm(191984, 'amaryllis azure').
ncbi_mult_taxo_gbnm(191986, oakblues).
ncbi_mult_taxo_gbnm(191987, 'acacia blues').
ncbi_mult_taxo_gbnm(192012, 'bitter vine').
ncbi_mult_taxo_gbnm(192173, 'Chinese green snake').
ncbi_mult_taxo_gbnm(192186, 'scarce heath').
ncbi_mult_taxo_gbnm(192188, 'oriental fruit moth').
ncbi_mult_taxo_gbnm(192191, 'apple brown tortrix').
ncbi_mult_taxo_gbnm(192200, 'Fowler\'s toad').
ncbi_mult_taxo_gbnm(192207, 'South Island kokako').
ncbi_mult_taxo_gbnm(192211, huia).
ncbi_mult_taxo_gbnm(192213, saddleback).
ncbi_mult_taxo_gbnm(192328, 'Russian comfrey').
ncbi_mult_taxo_gbnm(192375, 'masked greenling').
ncbi_mult_taxo_gbnm(192376, 'spotbelly greenling').
ncbi_mult_taxo_gbnm(192377, 'rock greenling').
ncbi_mult_taxo_gbnm(192378, 'whitespotted greenling').
ncbi_mult_taxo_gbnm(192379, 'Atka mackerel').
ncbi_mult_taxo_gbnm(192382, 'Japanese pine sawyer').
ncbi_mult_taxo_gbnm(192413, heelwalkers).
ncbi_mult_taxo_gbnm(192464, 'potato tuberworm').
ncbi_mult_taxo_gbnm(192526, 'Boettger\'s lizard').
ncbi_mult_taxo_gbnm(192529, 'Tenerife speckled lizard').
ncbi_mult_taxo_gbnm(192588, 'Bocourts mud snake').
ncbi_mult_taxo_gbnm(192589, 'Chinese water snake').
ncbi_mult_taxo_gbnm(192590, 'Boulenger\'s water snake').
ncbi_mult_taxo_gbnm(192591, 'Blackwater mud snake').
ncbi_mult_taxo_gbnm(192593, 'tentacle snake').
ncbi_mult_taxo_gbnm(192602, 'Inca scad').
ncbi_mult_taxo_gbnm(192603, 'Chapman\'s zebra').
ncbi_mult_taxo_gbnm(192736, 'snouted treefrogs').
ncbi_mult_taxo_gbnm(192739, 'Spix\'s snouted treefrog').
ncbi_mult_taxo_gbnm(192740, 'red snouted treefrog').
ncbi_mult_taxo_gbnm(192744, 'glass frogs').
ncbi_mult_taxo_gbnm(192745, 'Taylor\'s glass frog').
ncbi_mult_taxo_gbnm(192750, 'Chaco treefrog').
ncbi_mult_taxo_gbnm(192751, 'oophagous slender-legged treefrog').
ncbi_mult_taxo_gbnm(192753, 'Amazon River frog').
ncbi_mult_taxo_gbnm(192870, 'blackspot sergeant').
ncbi_mult_taxo_gbnm(192871, 'Indo-Pacific sergeant').
ncbi_mult_taxo_gbnm(193005, 'steppe eagle').
ncbi_mult_taxo_gbnm(193059, 'azure-winged magpie').
ncbi_mult_taxo_gbnm(193151, 'four-toed terrapin').
ncbi_mult_taxo_gbnm(193163, kapoktree).
ncbi_mult_taxo_gbnm(193308, 'oriental photinia').
ncbi_mult_taxo_gbnm(193512, 'robust tuskfish').
ncbi_mult_taxo_gbnm(193513, 'Azurio tuskfish').
ncbi_mult_taxo_gbnm(193516, 'sea-buckthorn').
ncbi_mult_taxo_gbnm(194198, 'western chorus frog').
ncbi_mult_taxo_gbnm(194199, 'little grass frog').
ncbi_mult_taxo_gbnm(194331, 'Gould\'s razor shell').
ncbi_mult_taxo_gbnm(194338, 'burrowing owl').
ncbi_mult_taxo_gbnm(194365, humpback).
ncbi_mult_taxo_gbnm(194366, 'topmouth culter').
ncbi_mult_taxo_gbnm(194402, 'Kannan caecilian').
ncbi_mult_taxo_gbnm(194403, 'marbled caecilian').
ncbi_mult_taxo_gbnm(194408, 'two-lined caecilian').
ncbi_mult_taxo_gbnm(194415, 'Ceylon caecilian').
ncbi_mult_taxo_gbnm(194453, 'Strasburg\'s dascyllus').
ncbi_mult_taxo_gbnm(194526, 'Tenmalai caecilian').
ncbi_mult_taxo_gbnm(194527, 'three-colored caecilian').
ncbi_mult_taxo_gbnm(194548, 'dollar sunfish').
ncbi_mult_taxo_gbnm(194857, 'eye-bar goby').
ncbi_mult_taxo_gbnm(194917, 'mango fruit fly').
ncbi_mult_taxo_gbnm(194918, 'lesser pumpkin fly').
ncbi_mult_taxo_gbnm(194920, 'tomato fruit fly').
ncbi_mult_taxo_gbnm(194921, 'Alagoas curassow').
ncbi_mult_taxo_gbnm(194942, 'grey-bellied flowerpiercer').
ncbi_mult_taxo_gbnm(195075, 'butterfly blenny').
ncbi_mult_taxo_gbnm(195081, 'ringneck blenny').
ncbi_mult_taxo_gbnm(195084, 'molly miller').
ncbi_mult_taxo_gbnm(195086, 'hairy blenny').
ncbi_mult_taxo_gbnm(195146, 'American alpine speedwell').
ncbi_mult_taxo_gbnm(195165, 'hawthorn jewel beetle').
ncbi_mult_taxo_gbnm(195288, 'Borneo leg skate').
ncbi_mult_taxo_gbnm(195290, 'knifetooth sawfish').
ncbi_mult_taxo_gbnm(195299, 'pale-edged stingray').
ncbi_mult_taxo_gbnm(195307, 'honeycomb stingray').
ncbi_mult_taxo_gbnm(195309, spookfish).
ncbi_mult_taxo_gbnm(195316, 'blackspotted numbfish').
ncbi_mult_taxo_gbnm(195319, 'Chinese fanray').
ncbi_mult_taxo_gbnm(195326, 'Kwangtung skate').
ncbi_mult_taxo_gbnm(195327, 'bigtail skate').
ncbi_mult_taxo_gbnm(195329, 'Taiwan guitarfish').
ncbi_mult_taxo_gbnm(195330, 'yellow guitarfish').
ncbi_mult_taxo_gbnm(195332, 'Javanese cownose ray').
ncbi_mult_taxo_gbnm(195333, 'giant guitarfish').
ncbi_mult_taxo_gbnm(195334, 'great hammerhead').
ncbi_mult_taxo_gbnm(195335, 'smooth hammerhead').
ncbi_mult_taxo_gbnm(195337, 'trapezoid torpedo').
ncbi_mult_taxo_gbnm(195338, 'porcupine ray').
ncbi_mult_taxo_gbnm(195339, 'sepia stingray').
ncbi_mult_taxo_gbnm(195505, micrognathozoans).
ncbi_mult_taxo_gbnm(195596, 'milky spotted sole').
ncbi_mult_taxo_gbnm(195598, 'twospot flounder').
ncbi_mult_taxo_gbnm(195600, 'longfin sanddab').
ncbi_mult_taxo_gbnm(195602, 'twospot largescale flounder').
ncbi_mult_taxo_gbnm(195604, 'Kobe flounder').
ncbi_mult_taxo_gbnm(195609, 'Petrale sole').
ncbi_mult_taxo_gbnm(195612, 'Rex sole').
ncbi_mult_taxo_gbnm(195615, 'Pacific halibut').
ncbi_mult_taxo_gbnm(195617, 'butter sole').
ncbi_mult_taxo_gbnm(195623, 'rock sole').
ncbi_mult_taxo_gbnm(195624, 'yellowfin sole').
ncbi_mult_taxo_gbnm(195626, 'slender sole').
ncbi_mult_taxo_gbnm(195629, 'crested flounders').
ncbi_mult_taxo_gbnm(195632, 'starry flounder').
ncbi_mult_taxo_gbnm(195635, 'hornyhead turbot').
ncbi_mult_taxo_gbnm(195637, 'tile-colored righteye flounder').
ncbi_mult_taxo_gbnm(195639, 'Pacific sand sole').
ncbi_mult_taxo_gbnm(195640, 'Indian spiny turbot').
ncbi_mult_taxo_gbnm(195642, 'wavyband sole').
ncbi_mult_taxo_gbnm(195643, 'fivespot flounder').
ncbi_mult_taxo_gbnm(195645, 'Kamchatka flounder').
ncbi_mult_taxo_gbnm(195649, 'dusky flounder').
ncbi_mult_taxo_gbnm(195653, 'duskycheek tonguefish').
ncbi_mult_taxo_gbnm(195658, hogchoker).
ncbi_mult_taxo_gbnm(195821, 'largescale foureyes').
ncbi_mult_taxo_gbnm(195883, 'small brown planthopper').
ncbi_mult_taxo_gbnm(196038, 'Brown-crested flycatcher').
ncbi_mult_taxo_gbnm(196049, 'Common tody flycatcher').
ncbi_mult_taxo_gbnm(196071, 'round sardinella').
ncbi_mult_taxo_gbnm(196072, 'Madeiran sardinella').
ncbi_mult_taxo_gbnm(196075, 'European sprat').
ncbi_mult_taxo_gbnm(196127, 'swallow damsel').
ncbi_mult_taxo_gbnm(196128, 'Rolland\'s demoiselle').
ncbi_mult_taxo_gbnm(196130, 'white damsel').
ncbi_mult_taxo_gbnm(196131, 'regal demoiselle').
ncbi_mult_taxo_gbnm(196296, 'Little Japanese Horseshoe Bat').
ncbi_mult_taxo_gbnm(196297, 'Malagasy flying fox').
ncbi_mult_taxo_gbnm(196298, 'Frosted Myotis').
ncbi_mult_taxo_gbnm(196387, 'western bush wallaby').
ncbi_mult_taxo_gbnm(196454, 'Arizona brown spider').
ncbi_mult_taxo_gbnm(196473, 'Ambergris Cay dwarf boa').
ncbi_mult_taxo_gbnm(196477, 'Gray\'s earth snake').
ncbi_mult_taxo_gbnm(196514, 'alpine leafybract aster').
ncbi_mult_taxo_gbnm(196517, 'rayless tansyaster').
ncbi_mult_taxo_gbnm(196575, 'Galapagos caterpillar hunter').
ncbi_mult_taxo_gbnm(196579, 'bat leaved passion flower').
ncbi_mult_taxo_gbnm(196630, 'Alcorn\'s pocket gopher').
ncbi_mult_taxo_gbnm(196701, 'Brock\'s yellow-eared bat').
ncbi_mult_taxo_gbnm(196740, 'elk thistle').
ncbi_mult_taxo_gbnm(196748, 'Modoc sucker').
ncbi_mult_taxo_gbnm(196749, 'Sacramento sucker').
ncbi_mult_taxo_gbnm(196750, 'Tahoe sucker').
ncbi_mult_taxo_gbnm(196751, 'lake chubsucker').
ncbi_mult_taxo_gbnm(196752, 'sharpfin chubsucker').
ncbi_mult_taxo_gbnm(196753, 'Alabama hog sucker').
ncbi_mult_taxo_gbnm(196754, 'Roanoke hog sucker').
ncbi_mult_taxo_gbnm(196767, 'notchlip redhorse').
ncbi_mult_taxo_gbnm(196769, 'golden redhorse').
ncbi_mult_taxo_gbnm(196770, 'shorthead redhorse').
ncbi_mult_taxo_gbnm(196774, 'v-lip redhorse').
ncbi_mult_taxo_gbnm(196775, 'pealip redhorse').
ncbi_mult_taxo_gbnm(196778, 'greater redhorse').
ncbi_mult_taxo_gbnm(196781, 'Mexican redhorse').
ncbi_mult_taxo_gbnm(196797, 'greater jumprock').
ncbi_mult_taxo_gbnm(196801, 'Mascota jumprock').
ncbi_mult_taxo_gbnm(196802, 'striped jumprock').
ncbi_mult_taxo_gbnm(196805, 'brassy jumprock').
ncbi_mult_taxo_gbnm(196807, 'blackfin sucker').
ncbi_mult_taxo_gbnm(196889, 'Big-eared Horseshoe Bat').
ncbi_mult_taxo_gbnm(196921, 'black redhorse').
ncbi_mult_taxo_gbnm(196969, 'false skin beetles').
ncbi_mult_taxo_gbnm(196975, 'dry-fungus beetles').
ncbi_mult_taxo_gbnm(196977, 'palmetto beetles').
ncbi_mult_taxo_gbnm(196978, 'root-eating beetles').
ncbi_mult_taxo_gbnm(196982, 'silvanid flat bark beetles').
ncbi_mult_taxo_gbnm(196983, 'parasitic flat bark beetles').
ncbi_mult_taxo_gbnm(196984, 'lined flat bark beetles').
ncbi_mult_taxo_gbnm(196986, 'shining flower beetles').
ncbi_mult_taxo_gbnm(196989, 'silken fungus beetles').
ncbi_mult_taxo_gbnm(196992, 'pleasing fungus beetles').
ncbi_mult_taxo_gbnm(196993, 'dry bark beetles').
ncbi_mult_taxo_gbnm(196994, 'minute bark beetles').
ncbi_mult_taxo_gbnm(196997, 'handsome fungus beetles').
ncbi_mult_taxo_gbnm(196998, 'minute fungus beetles').
ncbi_mult_taxo_gbnm(196999, 'minute brown scavenger beetles').
ncbi_mult_taxo_gbnm(197040, 'Okinawa kimuragumo').
ncbi_mult_taxo_gbnm(197043, 'glassy-winged sharpshooter').
ncbi_mult_taxo_gbnm(197114, 'hacklegill mayflies').
ncbi_mult_taxo_gbnm(197156, 'downy emerald').
ncbi_mult_taxo_gbnm(197158, 'red-eyed damselfly').
ncbi_mult_taxo_gbnm(197171, 'large red damselfly').
ncbi_mult_taxo_gbnm(197175, 'black darter').
ncbi_mult_taxo_gbnm(197179, 'sweet potato weevil').
ncbi_mult_taxo_gbnm(197217, 'Kramer\'s pit viper').
ncbi_mult_taxo_gbnm(197219, 'Vogel\'s pit viper').
ncbi_mult_taxo_gbnm(197344, 'churchyard beetle').
ncbi_mult_taxo_gbnm(197464, 'red-eyed leaf frog').
ncbi_mult_taxo_gbnm(197497, 'Ivory Coast wart frog').
ncbi_mult_taxo_gbnm(197521, 'white-tailed alethe').
ncbi_mult_taxo_gbnm(197541, 'slender lizardfish').
ncbi_mult_taxo_gbnm(197542, 'red lizard fish').
ncbi_mult_taxo_gbnm(197543, 'blackear lizardfish').
ncbi_mult_taxo_gbnm(197572, 'yellowfin scad').
ncbi_mult_taxo_gbnm(197574, 'oxeye scad').
ncbi_mult_taxo_gbnm(197604, 'chenille plant').
ncbi_mult_taxo_gbnm(197794, 'branched plantain').
ncbi_mult_taxo_gbnm(197809, 'sea plantain').
ncbi_mult_taxo_gbnm(197881, 'slim minnow').
ncbi_mult_taxo_gbnm(197887, 'scissortail damselfish').
ncbi_mult_taxo_gbnm(197888, 'brown chromis').
ncbi_mult_taxo_gbnm(197941, 'long-tailed duck').
ncbi_mult_taxo_gbnm(198027, 'European common scoter').
ncbi_mult_taxo_gbnm(198266, 'Siberian elm').
ncbi_mult_taxo_gbnm(198323, 'cypress pine aphid').
ncbi_mult_taxo_gbnm(198352, 'Papaloapan chub').
ncbi_mult_taxo_gbnm(198353, 'Aztec shiner').
ncbi_mult_taxo_gbnm(198356, 'sardina blanca').
ncbi_mult_taxo_gbnm(198433, 'celery leafminer').
ncbi_mult_taxo_gbnm(198469, 'plumbeous seedeater').
ncbi_mult_taxo_gbnm(198470, 'pale-breasted thrush').
ncbi_mult_taxo_gbnm(198471, 'small-billed tinamou').
ncbi_mult_taxo_gbnm(198472, 'lesser elaenia').
ncbi_mult_taxo_gbnm(198510, 'barred baril').
ncbi_mult_taxo_gbnm(198537, 'red deepsea crab').
ncbi_mult_taxo_gbnm(198635, 'drone fly').
ncbi_mult_taxo_gbnm(198655, 'cedar-apple rust').
ncbi_mult_taxo_gbnm(198700, 'scarce vapourer').
ncbi_mult_taxo_gbnm(198733, kalabans).
ncbi_mult_taxo_gbnm(198766, 'false mangosteen').
ncbi_mult_taxo_gbnm(198777, 'mammee apple').
ncbi_mult_taxo_gbnm(198806, ruff).
ncbi_mult_taxo_gbnm(198935, 'LeConte\'s sparrow').
ncbi_mult_taxo_gbnm(198938, 'sage sparrow').
ncbi_mult_taxo_gbnm(198958, 'hawthorn red midget moth').
ncbi_mult_taxo_gbnm(198959, 'spotted tentiform leafminer').
ncbi_mult_taxo_gbnm(199062, 'apple leafminer').
ncbi_mult_taxo_gbnm(199152, 'viscote negro').
ncbi_mult_taxo_gbnm(199623, 'lesser galangal').
ncbi_mult_taxo_gbnm(199869, 'Unthanks cave snail').
ncbi_mult_taxo_gbnm(200043, 'king begonia').
ncbi_mult_taxo_gbnm(200160, 'rusty-collared seedeater').
ncbi_mult_taxo_gbnm(200161, 'dark-throated seedeater').
ncbi_mult_taxo_gbnm(200163, 'Blue-and-yellow tanager').
ncbi_mult_taxo_gbnm(200371, 'Elfin-woods warbler').
ncbi_mult_taxo_gbnm(200373, 'forest thrush').
ncbi_mult_taxo_gbnm(200375, 'blue-headed hummingbird').
ncbi_mult_taxo_gbnm(200406, 'Anatolan honeybee').
ncbi_mult_taxo_gbnm(200407, 'Caucasian honeybee').
ncbi_mult_taxo_gbnm(200409, 'Iberian honeybee').
ncbi_mult_taxo_gbnm(200541, 'Tahiti lime').
ncbi_mult_taxo_gbnm(200682, 'darkfin sculpin').
ncbi_mult_taxo_gbnm(200787, 'Brown\'s leopard frog').
ncbi_mult_taxo_gbnm(200788, 'Forrer\'s grass frog').
ncbi_mult_taxo_gbnm(200789, 'northwest Mexico leopard frog').
ncbi_mult_taxo_gbnm(200790, 'transverse volcanic leopard frog').
ncbi_mult_taxo_gbnm(200791, 'showy leopard frog').
ncbi_mult_taxo_gbnm(200795, 'GNS bacteria').
ncbi_mult_taxo_gbnm(200865, 'coastal mugwort').
ncbi_mult_taxo_gbnm(200915, 'elm leaf beetle').
ncbi_mult_taxo_gbnm(200925, 'Brazil-nut poison frog').
ncbi_mult_taxo_gbnm(200927, 'Rio Madeira poison frog').
ncbi_mult_taxo_gbnm(200942, 'red arboreal rice rat').
ncbi_mult_taxo_gbnm(200943, 'Guianan oecomys').
ncbi_mult_taxo_gbnm(200944, 'Brazilian arboreal rice rat').
ncbi_mult_taxo_gbnm(200947, 'shamrock pea').
ncbi_mult_taxo_gbnm(200951, 'small melilot').
ncbi_mult_taxo_gbnm(200960, 'cow clover').
ncbi_mult_taxo_gbnm(200993, 'common fumitory').
ncbi_mult_taxo_gbnm(201014, 'chittagong wood').
ncbi_mult_taxo_gbnm(201017, langsat).
ncbi_mult_taxo_gbnm(201174, actinobacteria).
ncbi_mult_taxo_gbnm(201297, 'hoary-throated barwing').
ncbi_mult_taxo_gbnm(201298, 'rufous-winged fulvetta').
ncbi_mult_taxo_gbnm(201299, 'golden-breasted fulvetta').
ncbi_mult_taxo_gbnm(201300, 'streak-throated fulvetta').
ncbi_mult_taxo_gbnm(201304, 'yellow-eyed babbler').
ncbi_mult_taxo_gbnm(201306, cutia).
ncbi_mult_taxo_gbnm(201308, 'white-hooded babbler').
ncbi_mult_taxo_gbnm(201310, 'chestnut-crowned laughingthrush').
ncbi_mult_taxo_gbnm(201311, 'spotted laughingthrush').
ncbi_mult_taxo_gbnm(201312, 'white-browed laughingthrush').
ncbi_mult_taxo_gbnm(201313, 'blue-winged laughingthrush').
ncbi_mult_taxo_gbnm(201314, 'scaly laughingthrush').
ncbi_mult_taxo_gbnm(201315, 'variegated laughingthrush').
ncbi_mult_taxo_gbnm(201326, 'rufous sibia').
ncbi_mult_taxo_gbnm(201327, 'black-headed sibia').
ncbi_mult_taxo_gbnm(201329, 'blackcap illadopsis').
ncbi_mult_taxo_gbnm(201330, 'brown illadopsis').
ncbi_mult_taxo_gbnm(201334, 'gray-chested illadopsis').
ncbi_mult_taxo_gbnm(201335, 'silver-eared mesia').
ncbi_mult_taxo_gbnm(201338, 'red-faced liocichla').
ncbi_mult_taxo_gbnm(201339, 'Steere\'s liocichla').
ncbi_mult_taxo_gbnm(201341, 'Abbott\'s babbler').
ncbi_mult_taxo_gbnm(201343, 'scaly-crowned babbler').
ncbi_mult_taxo_gbnm(201345, 'striped wren-babbler').
ncbi_mult_taxo_gbnm(201347, 'blue-winged minla').
ncbi_mult_taxo_gbnm(201348, 'red-tailed minla').
ncbi_mult_taxo_gbnm(201358, 'eyebrowed wren-babbler').
ncbi_mult_taxo_gbnm(201359, 'white-browed scimitar-babbler').
ncbi_mult_taxo_gbnm(201360, 'buff-breatsed babbler').
ncbi_mult_taxo_gbnm(201362, 'black-headed shrike-babbler').
ncbi_mult_taxo_gbnm(201363, 'green shrike-babbler').
ncbi_mult_taxo_gbnm(201367, 'chestnut-capped babbler').
ncbi_mult_taxo_gbnm(201369, 'slender-billed scimitar-babbler').
ncbi_mult_taxo_gbnm(201371, 'David\'s parrotbill').
ncbi_mult_taxo_gbnm(201373, 'spot-breasted parrotbill').
ncbi_mult_taxo_gbnm(201377, 'Mongolian grayling').
ncbi_mult_taxo_gbnm(201378, 'Amur grayling').
ncbi_mult_taxo_gbnm(201383, 'striped whipsnake').
ncbi_mult_taxo_gbnm(201429, 'Pere David\'s rat snake').
ncbi_mult_taxo_gbnm(201438, 'Transcaucasian rat snake').
ncbi_mult_taxo_gbnm(201439, 'aesculapean snake').
ncbi_mult_taxo_gbnm(201440, 'striped aesculapian rat snake').
ncbi_mult_taxo_gbnm(201441, 'Persian rat snake').
ncbi_mult_taxo_gbnm(201442, 'leopard snake').
ncbi_mult_taxo_gbnm(201455, 'Japanese woodsnake').
ncbi_mult_taxo_gbnm(201498, taimen).
ncbi_mult_taxo_gbnm(201501, 'autumnal moth').
ncbi_mult_taxo_gbnm(201642, 'ghost orchid').
ncbi_mult_taxo_gbnm(201688, 'redbreast sunfish').
ncbi_mult_taxo_gbnm(201691, 'green sunfish').
ncbi_mult_taxo_gbnm(201701, 'Sacramento perch').
ncbi_mult_taxo_gbnm(201707, treefish).
ncbi_mult_taxo_gbnm(201717, 'Balearic islands cave goat').
ncbi_mult_taxo_gbnm(201758, 'apple weevil').
ncbi_mult_taxo_gbnm(201759, 'strawberry blossom weevil').
ncbi_mult_taxo_gbnm(201766, 'hazel leaf roller').
ncbi_mult_taxo_gbnm(201781, 'Eastern trinket snake').
ncbi_mult_taxo_gbnm(201858, 'cabbage stem weevil').
ncbi_mult_taxo_gbnm(201878, 'sluggish weevil').
ncbi_mult_taxo_gbnm(201897, 'poplar-and-willow borer').
ncbi_mult_taxo_gbnm(201899, 'acorn weevil').
ncbi_mult_taxo_gbnm(201991, 'Spotted owl').
ncbi_mult_taxo_gbnm(201992, 'Mexican spotted owl').
ncbi_mult_taxo_gbnm(201993, 'California spotted owl').
ncbi_mult_taxo_gbnm(201999, 'large pine weevil').
ncbi_mult_taxo_gbnm(202006, 'Lodgepole chipmunk').
ncbi_mult_taxo_gbnm(202061, 'South Georgia spiny plunderfish').
ncbi_mult_taxo_gbnm(202062, 'Kerguelen spiny plunderfish').
ncbi_mult_taxo_gbnm(202063, 'yellowbelly rockcod').
ncbi_mult_taxo_gbnm(202066, 'marbled plunderfish').
ncbi_mult_taxo_gbnm(202087, 'holarctic clam shrimp').
ncbi_mult_taxo_gbnm(202184, 'strawberry root weevil').
ncbi_mult_taxo_gbnm(202235, 'long-tailed wren-babbler').
ncbi_mult_taxo_gbnm(202280, 'harpy eagle').
ncbi_mult_taxo_gbnm(202362, 'Alabama stripetail').
ncbi_mult_taxo_gbnm(202428, 'Jerusalem cricket').
ncbi_mult_taxo_gbnm(202447, 'Children\'s stick insect').
ncbi_mult_taxo_gbnm(202456, 'potato aphid').
ncbi_mult_taxo_gbnm(202457, 'coppery titi').
ncbi_mult_taxo_gbnm(202477, 'ivy-leaved speedwell').
ncbi_mult_taxo_gbnm(202583, 'scale-rayed wrasse').
ncbi_mult_taxo_gbnm(202585, 'redbreast wrasse').
ncbi_mult_taxo_gbnm(202587, 'brown wrasse').
ncbi_mult_taxo_gbnm(202590, hogfish).
ncbi_mult_taxo_gbnm(202596, 'cryptic wrasse').
ncbi_mult_taxo_gbnm(202609, 'silky shark').
ncbi_mult_taxo_gbnm(202615, 'yellow mignonette').
ncbi_mult_taxo_gbnm(202634, 'sacred garlic pear').
ncbi_mult_taxo_gbnm(202662, 'jackass clover').
ncbi_mult_taxo_gbnm(202792, 'King arboreal rice rat').
ncbi_mult_taxo_gbnm(202796, 'golden kaiserihind').
ncbi_mult_taxo_gbnm(202802, 'green-spotted swallowtail').
ncbi_mult_taxo_gbnm(202805, 'Macleay\'s swallowtail').
ncbi_mult_taxo_gbnm(202839, 'Wahlberg\'s Kalahari gecko').
ncbi_mult_taxo_gbnm(202849, 'large-scaled gecko').
ncbi_mult_taxo_gbnm(202869, 'Ozark madtom').
ncbi_mult_taxo_gbnm(202874, stonecat).
ncbi_mult_taxo_gbnm(202906, 'dead horse arum').
ncbi_mult_taxo_gbnm(203114, 'sucker head').
ncbi_mult_taxo_gbnm(203116, 'Sattar snowtrout').
ncbi_mult_taxo_gbnm(203118, 'Deccan mahseer').
ncbi_mult_taxo_gbnm(203261, 'duskytail grouper').
ncbi_mult_taxo_gbnm(203262, 'greasy grouper').
ncbi_mult_taxo_gbnm(203277, 'scaly goby').
ncbi_mult_taxo_gbnm(203283, 'white-eye goby').
ncbi_mult_taxo_gbnm(203285, 'ragged goby').
ncbi_mult_taxo_gbnm(203286, 'apostrophe goby').
ncbi_mult_taxo_gbnm(203290, 'shortstripe goby').
ncbi_mult_taxo_gbnm(203296, 'neon goby').
ncbi_mult_taxo_gbnm(203309, 'knobchin goby').
ncbi_mult_taxo_gbnm(203310, 'paradox goby').
ncbi_mult_taxo_gbnm(203311, 'code goby').
ncbi_mult_taxo_gbnm(203314, 'naked goby').
ncbi_mult_taxo_gbnm(203318, 'fin-joined goby').
ncbi_mult_taxo_gbnm(203320, 'Balboa goby').
ncbi_mult_taxo_gbnm(203321, 'Seminole goby').
ncbi_mult_taxo_gbnm(203322, 'emblem goby').
ncbi_mult_taxo_gbnm(203323, 'erect goby').
ncbi_mult_taxo_gbnm(203324, 'clown goby').
ncbi_mult_taxo_gbnm(203325, 'banner goby').
ncbi_mult_taxo_gbnm(203326, 'green goby').
ncbi_mult_taxo_gbnm(203439, 'King Eider').
ncbi_mult_taxo_gbnm(203558, 'Clay-colored Robin').
ncbi_mult_taxo_gbnm(203680, 'Red-legged short-tailed Opossum').
ncbi_mult_taxo_gbnm(203681, 'Pygmy short-tailed Opossum').
ncbi_mult_taxo_gbnm(203696, 'Rickett\'s big-footed Myotis').
ncbi_mult_taxo_gbnm(203712, 'hog\'s-fennel').
ncbi_mult_taxo_gbnm(203773, 'Alcon blue').
ncbi_mult_taxo_gbnm(203775, 'mountain alcon blue').
ncbi_mult_taxo_gbnm(203779, 'large blue').
ncbi_mult_taxo_gbnm(203781, 'green-underside blue').
ncbi_mult_taxo_gbnm(203782, 'holly blue').
ncbi_mult_taxo_gbnm(203787, 'Cinnamon bracken-warbler').
ncbi_mult_taxo_gbnm(204053, 'Mediterranean slipper lobster').
ncbi_mult_taxo_gbnm(204141, 'American basil').
ncbi_mult_taxo_gbnm(204215, 'simpleleaf chastetree').
ncbi_mult_taxo_gbnm(204219, 'wild thyme').
ncbi_mult_taxo_gbnm(204232, 'colonial bentgrass').
ncbi_mult_taxo_gbnm(204233, 'purple-stem cat\'s-tail').
ncbi_mult_taxo_gbnm(204263, 'Tayra').
ncbi_mult_taxo_gbnm(204265, 'Greater grison').
ncbi_mult_taxo_gbnm(204267, 'Chinese ferret-badger').
ncbi_mult_taxo_gbnm(204382, 'common hedgehyssop').
ncbi_mult_taxo_gbnm(204490, 'Cape Fear shiner').
ncbi_mult_taxo_gbnm(204496, annulet).
ncbi_mult_taxo_gbnm(204505, 'Scotch annulet').
ncbi_mult_taxo_gbnm(204518, 'yellow bauhinia').
ncbi_mult_taxo_gbnm(204714, 'Griet bush frog').
ncbi_mult_taxo_gbnm(204814, 'lunartail puffer').
ncbi_mult_taxo_gbnm(204816, 'lattice blaasop').
ncbi_mult_taxo_gbnm(204817, 'brown-backed toadfish').
ncbi_mult_taxo_gbnm(204818, 'brown-backed toadfish').
ncbi_mult_taxo_gbnm(204884, 'black-browed fulvetta').
ncbi_mult_taxo_gbnm(204896, 'Northern barsided skink').
ncbi_mult_taxo_gbnm(204897, 'stout barsided skink').
ncbi_mult_taxo_gbnm(204898, 'warm-temperate water-skink').
ncbi_mult_taxo_gbnm(204900, 'orange-speckled forest-skink').
ncbi_mult_taxo_gbnm(204901, 'dark barsided skink').
ncbi_mult_taxo_gbnm(204902, 'blue-speckled forest-skink').
ncbi_mult_taxo_gbnm(204905, 'bar-sided forest-skink').
ncbi_mult_taxo_gbnm(204942, 'Beal\'s-eyed turtle').
ncbi_mult_taxo_gbnm(204956, 'Zhou\'s box turtle').
ncbi_mult_taxo_gbnm(204961, 'Annam leaf turtle').
ncbi_mult_taxo_gbnm(204965, 'Chinese box turtle').
ncbi_mult_taxo_gbnm(204966, 'Ryukyu yellow-margined box turtle').
ncbi_mult_taxo_gbnm(204968, 'flowerback box turtle').
ncbi_mult_taxo_gbnm(205120, 'Asiatic glassfishes').
ncbi_mult_taxo_gbnm(205123, 'great snakehead').
ncbi_mult_taxo_gbnm(205124, 'Deccan white carp').
ncbi_mult_taxo_gbnm(205130, 'zig-zag eel').
ncbi_mult_taxo_gbnm(205132, 'Gangetic mystus').
ncbi_mult_taxo_gbnm(205134, 'pool barb').
ncbi_mult_taxo_gbnm(205135, 'Ticto barb').
ncbi_mult_taxo_gbnm(205468, 'sugi bark borer').
ncbi_mult_taxo_gbnm(205478, 'Andean yam bean').
ncbi_mult_taxo_gbnm(205481, 'Amazonian yam bean').
ncbi_mult_taxo_gbnm(205486, 'afra cichlid').
ncbi_mult_taxo_gbnm(205524, 'Ethiopian eggplant').
ncbi_mult_taxo_gbnm(205536, 'cockroach berry').
ncbi_mult_taxo_gbnm(205537, tzimbalo).
ncbi_mult_taxo_gbnm(205567, 'pepino dulce').
ncbi_mult_taxo_gbnm(205579, 'Hawai\'i horsenettle').
ncbi_mult_taxo_gbnm(205595, 'panther genet').
ncbi_mult_taxo_gbnm(205599, 'White-tailed mongoose').
ncbi_mult_taxo_gbnm(205797, 'crested jay').
ncbi_mult_taxo_gbnm(206089, 'goiter blacksmelt').
ncbi_mult_taxo_gbnm(206092, spiderfish).
ncbi_mult_taxo_gbnm(206094, 'southern opah').
ncbi_mult_taxo_gbnm(206100, boarfish).
ncbi_mult_taxo_gbnm(206108, 'Kroyer\'s deep sea angler fish').
ncbi_mult_taxo_gbnm(206112, 'Madagascar rainbowfish').
ncbi_mult_taxo_gbnm(206115, 'common triplefin').
ncbi_mult_taxo_gbnm(206118, 'fire eel').
ncbi_mult_taxo_gbnm(206124, 'longspine snipefish').
ncbi_mult_taxo_gbnm(206126, 'sea stickleback').
ncbi_mult_taxo_gbnm(206127, 'imperial scaldfish').
ncbi_mult_taxo_gbnm(206128, 'smooth puffer').
ncbi_mult_taxo_gbnm(206132, 'ornate scorpionfish').
ncbi_mult_taxo_gbnm(206133, 'Ghanean comber').
ncbi_mult_taxo_gbnm(206136, 'longspine stargazer').
ncbi_mult_taxo_gbnm(206143, 'silver pomfret').
ncbi_mult_taxo_gbnm(206148, 'Guinean parrotfish').
ncbi_mult_taxo_gbnm(206149, 'African sicklefish').
ncbi_mult_taxo_gbnm(206154, 'red cornetfish').
ncbi_mult_taxo_gbnm(206155, 'goldtail demoiselle').
ncbi_mult_taxo_gbnm(206227, 'porcelain flower').
ncbi_mult_taxo_gbnm(206307, 'sesbania pea').
ncbi_mult_taxo_gbnm(206309, 'vegetable hummingbird').
ncbi_mult_taxo_gbnm(206310, 'Oahu riverhemp').
ncbi_mult_taxo_gbnm(206311, 'pink disease fungus').
ncbi_mult_taxo_gbnm(206427, 'tamarind weevil').
ncbi_mult_taxo_gbnm(206438, 'palm weevil borer').
ncbi_mult_taxo_gbnm(206442, 'South American palm weevil').
ncbi_mult_taxo_gbnm(206448, 'common glasswort').
ncbi_mult_taxo_gbnm(206456, 'true big-scale tetra').
ncbi_mult_taxo_gbnm(206459, 'silky cane weevil').
ncbi_mult_taxo_gbnm(206485, 'long-fin tetra').
ncbi_mult_taxo_gbnm(206492, 'banana borer').
ncbi_mult_taxo_gbnm(206495, 'Mexican bromeliad weevil').
ncbi_mult_taxo_gbnm(206497, 'New Guinea sugarcane weevil').
ncbi_mult_taxo_gbnm(206503, 'African palm weevil').
ncbi_mult_taxo_gbnm(206504, 'agave weevil').
ncbi_mult_taxo_gbnm(206507, 'bearded weevil').
ncbi_mult_taxo_gbnm(206540, 'China nawab').
ncbi_mult_taxo_gbnm(206593, 'Boyd\'s forest dragon').
ncbi_mult_taxo_gbnm(206594, 'modest forest dragon').
ncbi_mult_taxo_gbnm(206597, 'Southern forest dragon').
ncbi_mult_taxo_gbnm(206598, 'Gilbert\'s lashtail').
ncbi_mult_taxo_gbnm(206611, 'Houston\'s earless dragon').
ncbi_mult_taxo_gbnm(207115, 'small pocket gopher scarab').
ncbi_mult_taxo_gbnm(207342, 'Ross seal').
ncbi_mult_taxo_gbnm(207578, 'marble-faced Delma').
ncbi_mult_taxo_gbnm(207618, 'blacktip soldierfish').
ncbi_mult_taxo_gbnm(207619, 'wrestling halfbeak').
ncbi_mult_taxo_gbnm(207699, 'Volcano Swiftlet').
ncbi_mult_taxo_gbnm(207714, 'tortuous mesquite').
ncbi_mult_taxo_gbnm(207719, 'velvet mesquite').
ncbi_mult_taxo_gbnm(207748, 'Chestnut-mandibled toucan').
ncbi_mult_taxo_gbnm(207784, 'ram\'s-horn gallwasp').
ncbi_mult_taxo_gbnm(207841, 'intermediate wood fern').
ncbi_mult_taxo_gbnm(207912, 'Taymyr gull').
ncbi_mult_taxo_gbnm(208016, 'pine processionary moth').
ncbi_mult_taxo_gbnm(208054, 'helmeted manakin').
ncbi_mult_taxo_gbnm(208056, 'pin-tailed manakin').
ncbi_mult_taxo_gbnm(208057, 'mouse-colored penduline-tit').
ncbi_mult_taxo_gbnm(208059, 'tit-hylia').
ncbi_mult_taxo_gbnm(208060, 'Petit\'s sawwing').
ncbi_mult_taxo_gbnm(208061, 'singing cisticola').
ncbi_mult_taxo_gbnm(208062, 'tawny-flanked prinia').
ncbi_mult_taxo_gbnm(208064, 'Sierra Leone prinia').
ncbi_mult_taxo_gbnm(208065, 'white-chinned prinia').
ncbi_mult_taxo_gbnm(208067, 'yellow-breasted apalis').
ncbi_mult_taxo_gbnm(208069, 'Green crombec').
ncbi_mult_taxo_gbnm(208070, 'brown babbler').
ncbi_mult_taxo_gbnm(208071, 'Eastern subalpine warbler').
ncbi_mult_taxo_gbnm(208073, 'green hylia').
ncbi_mult_taxo_gbnm(208076, 'variable sunbird').
ncbi_mult_taxo_gbnm(208083, 'african golden-oriole').
ncbi_mult_taxo_gbnm(208091, 'Kinda baboon').
ncbi_mult_taxo_gbnm(208267, 'Japanese lovegrass').
ncbi_mult_taxo_gbnm(208272, 'gophertail lovegrass').
ncbi_mult_taxo_gbnm(208313, 'bulldog goodeid').
ncbi_mult_taxo_gbnm(208351, 'Balsas splitfin').
ncbi_mult_taxo_gbnm(208352, 'Limones splitfin').
ncbi_mult_taxo_gbnm(208353, 'golden skiffia').
ncbi_mult_taxo_gbnm(208354, 'olive skiffia').
ncbi_mult_taxo_gbnm(208451, 'crested serpent eagle').
ncbi_mult_taxo_gbnm(208453, 'mountain scops owl').
ncbi_mult_taxo_gbnm(208459, 'fig tree blues').
ncbi_mult_taxo_gbnm(208465, 'black splitfin').
ncbi_mult_taxo_gbnm(208483, 'European herring gull').
ncbi_mult_taxo_gbnm(208494, 'eastern prickly gooseberry').
ncbi_mult_taxo_gbnm(208502, 'stink currant').
ncbi_mult_taxo_gbnm(208529, scaldfish).
ncbi_mult_taxo_gbnm(208530, 'Lusitanian sole').
ncbi_mult_taxo_gbnm(208663, 'ground crickets').
ncbi_mult_taxo_gbnm(208677, 'mole crickets').
ncbi_mult_taxo_gbnm(208679, 'seven-spurred mole crickets').
ncbi_mult_taxo_gbnm(208681, 'white tree crickets').
ncbi_mult_taxo_gbnm(208683, 'black-horned tree cricket').
ncbi_mult_taxo_gbnm(208710, 'two-clawed mole crickets').
ncbi_mult_taxo_gbnm(208761, 'ground wetas').
ncbi_mult_taxo_gbnm(208763, 'mountain stone weta').
ncbi_mult_taxo_gbnm(208881, 'dune crickets').
ncbi_mult_taxo_gbnm(208972, 'hog-nosed bat').
ncbi_mult_taxo_gbnm(209010, 'band-legged ground cricket').
ncbi_mult_taxo_gbnm(209042, 'Japanese burrowing cricket').
ncbi_mult_taxo_gbnm(209070, 'collared scops owl').
ncbi_mult_taxo_gbnm(209114, 'giant river-catfish').
ncbi_mult_taxo_gbnm(209118, 'Hamilton\'s barila').
ncbi_mult_taxo_gbnm(209166, 'butter catfish').
ncbi_mult_taxo_gbnm(209169, 'olive barb').
ncbi_mult_taxo_gbnm(209173, 'sword-tailed crickets').
ncbi_mult_taxo_gbnm(209174, 'brown sword-tailed crickets').
ncbi_mult_taxo_gbnm(209197, 'Apache trout').
ncbi_mult_taxo_gbnm(209199, kolus).
ncbi_mult_taxo_gbnm(209204, 'giant betta').
ncbi_mult_taxo_gbnm(209215, 'dusky betta').
ncbi_mult_taxo_gbnm(209216, 'crescent betta').
ncbi_mult_taxo_gbnm(209217, 'spotfin betta').
ncbi_mult_taxo_gbnm(209222, 'spotted betta').
ncbi_mult_taxo_gbnm(209228, 'blue betta').
ncbi_mult_taxo_gbnm(209231, 'Howong betta').
ncbi_mult_taxo_gbnm(209235, 'spotted gourami').
ncbi_mult_taxo_gbnm(209237, 'licorice gourami').
ncbi_mult_taxo_gbnm(209240, 'spiketail paradisefish').
ncbi_mult_taxo_gbnm(209242, 'croaking gourami').
ncbi_mult_taxo_gbnm(209478, 'southwestern bubble-nest frog').
ncbi_mult_taxo_gbnm(209479, 'Java bubble-nest frog').
ncbi_mult_taxo_gbnm(209480, 'Boulenger\'s bubble-nest frog').
ncbi_mult_taxo_gbnm(209536, 'creeping bellflower').
ncbi_mult_taxo_gbnm(209618, 'alder flycatcher').
ncbi_mult_taxo_gbnm(209660, 'Rio Grande tree toad').
ncbi_mult_taxo_gbnm(209665, 'ornate tree toad').
ncbi_mult_taxo_gbnm(209666, 'Humboldt\'s tree toad').
ncbi_mult_taxo_gbnm(209670, 'Rio big-tooth frog').
ncbi_mult_taxo_gbnm(209672, 'Boraceia button frog').
ncbi_mult_taxo_gbnm(209674, 'spiny-chest frogs').
ncbi_mult_taxo_gbnm(209675, 'Island spiny-chest frog').
ncbi_mult_taxo_gbnm(209679, 'Bioe\'s frog').
ncbi_mult_taxo_gbnm(209681, 'Chiloe Island ground frog').
ncbi_mult_taxo_gbnm(209687, 'dark-winged fungus gnat').
ncbi_mult_taxo_gbnm(209944, 'mouselike barklice').
ncbi_mult_taxo_gbnm(209949, 'middle barklice').
ncbi_mult_taxo_gbnm(209953, 'leaf litter barklice').
ncbi_mult_taxo_gbnm(209957, 'elliptical barklice').
ncbi_mult_taxo_gbnm(209963, 'tropical barklice').
ncbi_mult_taxo_gbnm(209974, 'granary booklice').
ncbi_mult_taxo_gbnm(209977, 'cave barklice').
ncbi_mult_taxo_gbnm(209986, 'gutta bug').
ncbi_mult_taxo_gbnm(209990, 'thick barklice').
ncbi_mult_taxo_gbnm(209993, 'narrow barklice').
ncbi_mult_taxo_gbnm(209996, 'loving barklice').
ncbi_mult_taxo_gbnm(210000, 'sac spiders').
ncbi_mult_taxo_gbnm(210003, 'small red scorpionfish').
ncbi_mult_taxo_gbnm(210004, 'red scorpionfish').
ncbi_mult_taxo_gbnm(210005, stargazer).
ncbi_mult_taxo_gbnm(210029, 'two-spotted clingfish').
ncbi_mult_taxo_gbnm(210129, 'blacknose shiner').
ncbi_mult_taxo_gbnm(210130, 'blackchin shiner').
ncbi_mult_taxo_gbnm(210137, 'pugnose shiner').
ncbi_mult_taxo_gbnm(210139, 'Indian salmon').
ncbi_mult_taxo_gbnm(210166, 'black titi').
ncbi_mult_taxo_gbnm(210202, 'Japanese gliding frog').
ncbi_mult_taxo_gbnm(210225, 'pocket water lily').
ncbi_mult_taxo_gbnm(210350, 'Chinese black-olive').
ncbi_mult_taxo_gbnm(210376, 'governor\'s plum').
ncbi_mult_taxo_gbnm(210409, 'swimming crab').
ncbi_mult_taxo_gbnm(210423, 'Daiyun torrent frog').
ncbi_mult_taxo_gbnm(210573, lightfishes).
ncbi_mult_taxo_gbnm(210630, 'Day\'s mystus').
ncbi_mult_taxo_gbnm(210632, 'Indian glassy fish').
ncbi_mult_taxo_gbnm(210633, 'Jerdon\'s carp').
ncbi_mult_taxo_gbnm(210636, 'Boopis razorbelly minnow').
ncbi_mult_taxo_gbnm(210638, 'golden mahseer').
ncbi_mult_taxo_gbnm(210639, 'spadenose shark').
ncbi_mult_taxo_gbnm(210640, 'copper redhorse').
ncbi_mult_taxo_gbnm(210642, 'marsh mongoose').
ncbi_mult_taxo_gbnm(210643, 'Alexander\'s cusimanse').
ncbi_mult_taxo_gbnm(210644, 'slender mongoose').
ncbi_mult_taxo_gbnm(210646, 'desert dwarf mongoose').
ncbi_mult_taxo_gbnm(210647, 'dwarf mongoose').
ncbi_mult_taxo_gbnm(210650, 'liberian mongoose').
ncbi_mult_taxo_gbnm(210652, 'banded mongoose').
ncbi_mult_taxo_gbnm(210654, 'Meller\'s mongoose').
ncbi_mult_taxo_gbnm(210726, 'Shortridge\'s mouse').
ncbi_mult_taxo_gbnm(210762, 'Salvin\'s curassow').
ncbi_mult_taxo_gbnm(210763, 'horned curassow').
ncbi_mult_taxo_gbnm(210810, 'lesser ghost bat').
ncbi_mult_taxo_gbnm(210840, 'belt jellyfish').
ncbi_mult_taxo_gbnm(210844, 'crested goshawk').
ncbi_mult_taxo_gbnm(210850, 'Balkhash perch').
ncbi_mult_taxo_gbnm(210855, zingel).
ncbi_mult_taxo_gbnm(210920, 'Appalachian roachfly').
ncbi_mult_taxo_gbnm(211228, 'wheat stem sawfly').
ncbi_mult_taxo_gbnm(211418, 'African pipit').
ncbi_mult_taxo_gbnm(211419, 'short-tailed pipit').
ncbi_mult_taxo_gbnm(211420, 'cape wagtail').
ncbi_mult_taxo_gbnm(211421, 'Madagascar wagtail').
ncbi_mult_taxo_gbnm(211422, 'whitebrowed wagtail').
ncbi_mult_taxo_gbnm(211488, 'tetraploid hybrids of red crucian carp and common carp').
ncbi_mult_taxo_gbnm(211491, 'triploid hybrids of tetraploid and Japanese crucian carp').
ncbi_mult_taxo_gbnm(211510, 'Blue-crowned parakeet').
ncbi_mult_taxo_gbnm(211511, 'maroon-bellied parakeet').
ncbi_mult_taxo_gbnm(211598, 'Eurasian sparrowhawk').
ncbi_mult_taxo_gbnm(211599, 'eurasian dotterel').
ncbi_mult_taxo_gbnm(211600, 'acorn woodpecker').
ncbi_mult_taxo_gbnm(211601, 'Cape file snake').
ncbi_mult_taxo_gbnm(211636, 'south american spiny mouse').
ncbi_mult_taxo_gbnm(211648, 'Keeled slug snake').
ncbi_mult_taxo_gbnm(211651, 'cloudy snail-eating snake').
ncbi_mult_taxo_gbnm(211674, 'chestnut-bellied guan').
ncbi_mult_taxo_gbnm(211675, 'crested guan').
ncbi_mult_taxo_gbnm(211677, 'red-throated piping guan').
ncbi_mult_taxo_gbnm(211678, 'blue-throated piping guan').
ncbi_mult_taxo_gbnm(211679, 'Trinidad piping guan').
ncbi_mult_taxo_gbnm(211798, 'Ucayali spiny mouse').
ncbi_mult_taxo_gbnm(211833, 'star snapper').
ncbi_mult_taxo_gbnm(211834, 'mangrove red snapper').
ncbi_mult_taxo_gbnm(211835, 'crimson snapper').
ncbi_mult_taxo_gbnm(211877, 'barred parakeet').
ncbi_mult_taxo_gbnm(211879, 'Galapagos hawk').
ncbi_mult_taxo_gbnm(211915, 'Franklin\'s grouse').
ncbi_mult_taxo_gbnm(211926, 'African tulip tree').
ncbi_mult_taxo_gbnm(211964, 'rufous-winged Illadopsis').
ncbi_mult_taxo_gbnm(211967, 'Gunnison sage-grouse').
ncbi_mult_taxo_gbnm(211979, 'brown basilisk').
ncbi_mult_taxo_gbnm(211984, 'Haitian curlytail lizard').
ncbi_mult_taxo_gbnm(212130, 'brown legged grain mite').
ncbi_mult_taxo_gbnm(212319, kuduberry).
ncbi_mult_taxo_gbnm(212358, 'white-banded tree frog').
ncbi_mult_taxo_gbnm(212385, 'common blue apollo').
ncbi_mult_taxo_gbnm(212527, 'African honeybee').
ncbi_mult_taxo_gbnm(212681, 'chikku chikku').
ncbi_mult_taxo_gbnm(212708, 'Japanese spindletree').
ncbi_mult_taxo_gbnm(212737, 'gulper shark').
ncbi_mult_taxo_gbnm(212740, 'sharpnose sevengill shark').
ncbi_mult_taxo_gbnm(212759, 'pheasant\'s-eye').
ncbi_mult_taxo_gbnm(212792, 'greater sooty-owl').
ncbi_mult_taxo_gbnm(212793, 'Lesser sooty-owl').
ncbi_mult_taxo_gbnm(212794, 'African grass-owl').
ncbi_mult_taxo_gbnm(212795, 'Hawaiian grouper').
ncbi_mult_taxo_gbnm(212810, 'perennial peanut').
ncbi_mult_taxo_gbnm(213043, 'Azores grayling').
ncbi_mult_taxo_gbnm(213044, 'Cretan greyling').
ncbi_mult_taxo_gbnm(213085, 'rice leaf beetle').
ncbi_mult_taxo_gbnm(213156, 'blue nawab').
ncbi_mult_taxo_gbnm(213159, 'bengal weaver').
ncbi_mult_taxo_gbnm(213384, 'sandy ray').
ncbi_mult_taxo_gbnm(213385, 'black mudalia').
ncbi_mult_taxo_gbnm(213425, 'Asian drill').
ncbi_mult_taxo_gbnm(213494, 'oriental mole cricket').
ncbi_mult_taxo_gbnm(213498, 'false zokor').
ncbi_mult_taxo_gbnm(213557, 'southern pygmy mouse').
ncbi_mult_taxo_gbnm(213639, 'zigzag coral').
ncbi_mult_taxo_gbnm(213803, 'veined treefrog').
ncbi_mult_taxo_gbnm(213851, 'Lake Urmia newt').
ncbi_mult_taxo_gbnm(213852, 'Anatolia newt').
ncbi_mult_taxo_gbnm(213856, 'Luristan newt').
ncbi_mult_taxo_gbnm(213857, 'southern smooth newt').
ncbi_mult_taxo_gbnm(213858, 'Sarmatian rat snake').
ncbi_mult_taxo_gbnm(213896, 'false apollo').
ncbi_mult_taxo_gbnm(213898, 'desert apollo').
ncbi_mult_taxo_gbnm(213929, 'regal apollo').
ncbi_mult_taxo_gbnm(213934, 'common red apollo').
ncbi_mult_taxo_gbnm(213953, 'clouded apollo').
ncbi_mult_taxo_gbnm(214017, 'alder dagger moth').
ncbi_mult_taxo_gbnm(214018, 'cherry dagger moth').
ncbi_mult_taxo_gbnm(214019, 'cottonwood dagger moth').
ncbi_mult_taxo_gbnm(214020, 'ochre dagger moth').
ncbi_mult_taxo_gbnm(214022, 'unspotted looper').
ncbi_mult_taxo_gbnm(214023, 'willow dagger moth').
ncbi_mult_taxo_gbnm(214026, 'feeble grass moth').
ncbi_mult_taxo_gbnm(214030, 'green arches').
ncbi_mult_taxo_gbnm(214032, 'common gray').
ncbi_mult_taxo_gbnm(214035, chigger).
ncbi_mult_taxo_gbnm(214064, 'glassy cutworm').
ncbi_mult_taxo_gbnm(214069, 'many-dotted appleworm').
ncbi_mult_taxo_gbnm(214075, 'gray spruce looper').
ncbi_mult_taxo_gbnm(214076, 'hawthorn underwing').
ncbi_mult_taxo_gbnm(214077, 'praeclara underwing moth').
ncbi_mult_taxo_gbnm(214081, 'waved sphinx').
ncbi_mult_taxo_gbnm(214083, 'tufted bird-dropping moth').
ncbi_mult_taxo_gbnm(214085, 'blackberry looper').
ncbi_mult_taxo_gbnm(214090, 'rustylined leaftier').
ncbi_mult_taxo_gbnm(214091, 'redmarked tentmaker').
ncbi_mult_taxo_gbnm(214105, 'climbing cherry cutworm').
ncbi_mult_taxo_gbnm(214107, 'goldenrod cutworm').
ncbi_mult_taxo_gbnm(214110, 'delicate cyncia').
ncbi_mult_taxo_gbnm(214111, 'Oregon cyncia').
ncbi_mult_taxo_gbnm(214117, 'lettered sphinx').
ncbi_mult_taxo_gbnm(214120, 'bad-wing').
ncbi_mult_taxo_gbnm(214127, 'linden prominent').
ncbi_mult_taxo_gbnm(214129, 'maple spanworm').
ncbi_mult_taxo_gbnm(214131, 'milkweed tussock moth').
ncbi_mult_taxo_gbnm(214133, 'lesser grapevine looper').
ncbi_mult_taxo_gbnm(214136, 'brown bordered geometer').
ncbi_mult_taxo_gbnm(214139, 'currant pug').
ncbi_mult_taxo_gbnm(214140, 'spruce cone looper').
ncbi_mult_taxo_gbnm(214143, 'satyr pug').
ncbi_mult_taxo_gbnm(214145, 'fleece-winged dart').
ncbi_mult_taxo_gbnm(214147, 'wheat-head armyworm').
ncbi_mult_taxo_gbnm(214151, 'white furcula').
ncbi_mult_taxo_gbnm(214155, 'arge moth').
ncbi_mult_taxo_gbnm(214156, 'little virgin tiger moth').
ncbi_mult_taxo_gbnm(214157, 'virgin tiger moth').
ncbi_mult_taxo_gbnm(214159, 'banded tussock moth').
ncbi_mult_taxo_gbnm(214161, 'confused haploa').
ncbi_mult_taxo_gbnm(214164, 'saddled prominent').
ncbi_mult_taxo_gbnm(214171, 'rosy rustic').
ncbi_mult_taxo_gbnm(214174, 'painted lichen moth').
ncbi_mult_taxo_gbnm(214176, 'cranberry cutworm').
ncbi_mult_taxo_gbnm(214180, 'lesser maple spanworm').
ncbi_mult_taxo_gbnm(214181, 'common swift moth').
ncbi_mult_taxo_gbnm(214183, 'northern pine sphinx').
ncbi_mult_taxo_gbnm(214186, 'false wainscot').
ncbi_mult_taxo_gbnm(214188, 'innominate pinion').
ncbi_mult_taxo_gbnm(214190, 'twolined aspen looper').
ncbi_mult_taxo_gbnm(214192, 'variable oakleaf caterpillar').
ncbi_mult_taxo_gbnm(214194, 'white spring moth').
ncbi_mult_taxo_gbnm(214196, 'spotted tussock moth').
ncbi_mult_taxo_gbnm(214198, 'common lyrostris').
ncbi_mult_taxo_gbnm(214200, 'dark marathyssa').
ncbi_mult_taxo_gbnm(214240, 'hitched arches').
ncbi_mult_taxo_gbnm(214243, 'variable redmarked looper').
ncbi_mult_taxo_gbnm(214244, 'signate melanolophia').
ncbi_mult_taxo_gbnm(214246, 'pale metanema').
ncbi_mult_taxo_gbnm(214250, 'confused woodgrain').
ncbi_mult_taxo_gbnm(214251, 'bicolored woodgrain').
ncbi_mult_taxo_gbnm(214255, 'yellowlined caterpillar').
ncbi_mult_taxo_gbnm(214270, 'flanged looper').
ncbi_mult_taxo_gbnm(214272, 'red-fronted emerald').
ncbi_mult_taxo_gbnm(214277, 'large yellow underwing').
ncbi_mult_taxo_gbnm(214283, 'flame-shouldered dart').
ncbi_mult_taxo_gbnm(214285, 'elegant prominent').
ncbi_mult_taxo_gbnm(214288, 'cynical quaker').
ncbi_mult_taxo_gbnm(214292, 'speckled green fruitworm').
ncbi_mult_taxo_gbnm(214293, 'rusty whitesided caterpillar').
ncbi_mult_taxo_gbnm(214294, 'ruby quaker').
ncbi_mult_taxo_gbnm(214296, 'spring cankerworm').
ncbi_mult_taxo_gbnm(214302, 'oval-based prominent').
ncbi_mult_taxo_gbnm(214307, 'black-banded owlet').
ncbi_mult_taxo_gbnm(214309, 'false hornworm').
ncbi_mult_taxo_gbnm(214311, 'ruby tiger moth').
ncbi_mult_taxo_gbnm(214312, 'straight-lined plagodis').
ncbi_mult_taxo_gbnm(214317, 'large maple spanworm').
ncbi_mult_taxo_gbnm(214320, 'lesser migratory grasshopper').
ncbi_mult_taxo_gbnm(214328, 'small brown quaker').
ncbi_mult_taxo_gbnm(214332, 'woolly bear').
ncbi_mult_taxo_gbnm(214338, 'spotted grass moth').
ncbi_mult_taxo_gbnm(214339, 'primrose moth').
ncbi_mult_taxo_gbnm(214341, 'unicorn caterpillar').
ncbi_mult_taxo_gbnm(214342, 'soft-lined wave').
ncbi_mult_taxo_gbnm(214362, 'twin-spot sphinx').
ncbi_mult_taxo_gbnm(214363, 'Canadian sphinx').
ncbi_mult_taxo_gbnm(214364, 'apple sphinx').
ncbi_mult_taxo_gbnm(214366, 'Virginian tiger moth').
ncbi_mult_taxo_gbnm(214367, 'agreeable tiger moth').
ncbi_mult_taxo_gbnm(214370, 'wavy-lined emerald').
ncbi_mult_taxo_gbnm(214371, 'small bird-dropping moth').
ncbi_mult_taxo_gbnm(214375, 'white slant-line').
ncbi_mult_taxo_gbnm(214377, 'white-striped black').
ncbi_mult_taxo_gbnm(214381, 'toothed brown carpet').
ncbi_mult_taxo_gbnm(214382, 'red carpet').
ncbi_mult_taxo_gbnm(214383, 'false crocus geometer').
ncbi_mult_taxo_gbnm(214385, 'swordgrass moth').
ncbi_mult_taxo_gbnm(214386, 'pine false looper').
ncbi_mult_taxo_gbnm(214431, 'barcoo grunter').
ncbi_mult_taxo_gbnm(214436, 'eastern marsh-harrier').
ncbi_mult_taxo_gbnm(214438, 'mountain hawk-eagle').
ncbi_mult_taxo_gbnm(214440, 'Dent\'s shrew').
ncbi_mult_taxo_gbnm(214441, 'Doucet\'s musk shrew').
ncbi_mult_taxo_gbnm(214442, 'greater red musk shrew').
ncbi_mult_taxo_gbnm(214443, 'tiny musk shrew').
ncbi_mult_taxo_gbnm(214444, 'lesser red musk shrew').
ncbi_mult_taxo_gbnm(214445, 'Butiaba naked-tailed shrew').
ncbi_mult_taxo_gbnm(214446, 'Mauritanian shrew').
ncbi_mult_taxo_gbnm(214447, 'dark shrew').
ncbi_mult_taxo_gbnm(214448, 'nigerian shrew').
ncbi_mult_taxo_gbnm(214449, 'Olivier\'s shrew').
ncbi_mult_taxo_gbnm(214450, 'Fraser\'s musk shrew').
ncbi_mult_taxo_gbnm(214451, 'tumultuous shrew').
ncbi_mult_taxo_gbnm(214452, 'savanna path shrew').
ncbi_mult_taxo_gbnm(214455, 'Fox\'s shrew').
ncbi_mult_taxo_gbnm(214464, 'Bates\' shrew').
ncbi_mult_taxo_gbnm(214465, 'Bottego\'s shrew').
ncbi_mult_taxo_gbnm(214466, 'Buettikofer\'s shrew').
ncbi_mult_taxo_gbnm(214485, 'rougheye rockfish').
ncbi_mult_taxo_gbnm(214486, 'Schlegel\'s black rockfish').
ncbi_mult_taxo_gbnm(214502, 'Iberian midwife toad').
ncbi_mult_taxo_gbnm(214514, 'Pacific pocket mouse').
ncbi_mult_taxo_gbnm(214657, opaleye).
ncbi_mult_taxo_gbnm(214658, 'black drummer').
ncbi_mult_taxo_gbnm(214659, luderick).
ncbi_mult_taxo_gbnm(214661, 'tooth-billed hummingbird').
ncbi_mult_taxo_gbnm(214663, 'sparkling violet-ear').
ncbi_mult_taxo_gbnm(214665, 'green-fronted lancebill').
ncbi_mult_taxo_gbnm(214667, 'white-whiskered hermit').
ncbi_mult_taxo_gbnm(214669, 'saw-billed hermit').
ncbi_mult_taxo_gbnm(214671, 'band-tailed barbthroat').
ncbi_mult_taxo_gbnm(214672, 'green-breasted mango').
ncbi_mult_taxo_gbnm(214687, 'wild Malaysian banana').
ncbi_mult_taxo_gbnm(214697, 'dessert banana').
ncbi_mult_taxo_gbnm(214812, 'big-eye mandarin fish').
ncbi_mult_taxo_gbnm(214820, 'common green darner').
ncbi_mult_taxo_gbnm(214836, 'rosy apple aphid').
ncbi_mult_taxo_gbnm(214892, 'vesta crescentspot').
ncbi_mult_taxo_gbnm(214914, 'coastrange sculpin').
ncbi_mult_taxo_gbnm(214916, 'prickly sculpin').
ncbi_mult_taxo_gbnm(214919, 'Blue Ridge sculpin').
ncbi_mult_taxo_gbnm(214920, 'reticulate sculpin').
ncbi_mult_taxo_gbnm(214921, 'torrent sculpin').
ncbi_mult_taxo_gbnm(214925, 'Pacific staghorn sculpin').
ncbi_mult_taxo_gbnm(214928, 'largelip killifish').
ncbi_mult_taxo_gbnm(214933, 'Sichuan field mouse').
ncbi_mult_taxo_gbnm(214934, 'Ward\'s field mouse').
ncbi_mult_taxo_gbnm(214982, 'spiny flower coral').
ncbi_mult_taxo_gbnm(214988, 'lesser starlet coral').
ncbi_mult_taxo_gbnm(215152, 'marbled wood frog').
ncbi_mult_taxo_gbnm(215153, 'gray wood frog').
ncbi_mult_taxo_gbnm(215154, 'Nibaldo\'s wood frog').
ncbi_mult_taxo_gbnm(215155, 'banded wood frog').
ncbi_mult_taxo_gbnm(215162, 'heart and dart moth').
ncbi_mult_taxo_gbnm(215237, 'Sonora tiger salamander').
ncbi_mult_taxo_gbnm(215240, 'blue-green citrus root weevil').
ncbi_mult_taxo_gbnm(215280, 'greater hoopoe-lark').
ncbi_mult_taxo_gbnm(215302, 'black-crowned sparrow-lark').
ncbi_mult_taxo_gbnm(215304, 'bar-tailed lark').
ncbi_mult_taxo_gbnm(215306, 'crested lark').
ncbi_mult_taxo_gbnm(215310, 'lesser short-toed lark').
ncbi_mult_taxo_gbnm(215312, 'Australian lark').
ncbi_mult_taxo_gbnm(215313, 'Temminck\'s lark').
ncbi_mult_taxo_gbnm(215315, 'wood lark').
ncbi_mult_taxo_gbnm(215317, 'pink-billed lark').
ncbi_mult_taxo_gbnm(215319, 'Stark\'s lark').
ncbi_mult_taxo_gbnm(215320, 'monotonous lark').
ncbi_mult_taxo_gbnm(215321, 'spike-heeled lark').
ncbi_mult_taxo_gbnm(215323, 'Gray\'s lark').
ncbi_mult_taxo_gbnm(215324, 'large-billed lark').
ncbi_mult_taxo_gbnm(215325, 'Sclater\'s lark').
ncbi_mult_taxo_gbnm(215326, 'Sabota lark').
ncbi_mult_taxo_gbnm(215327, batfishes).
ncbi_mult_taxo_gbnm(215329, batfish).
ncbi_mult_taxo_gbnm(215336, 'wide-banded hardyhead silverside').
ncbi_mult_taxo_gbnm(215339, 'short dragonfish').
ncbi_mult_taxo_gbnm(215342, 'longtail seamoth').
ncbi_mult_taxo_gbnm(215343, 'bluespotted cornetfish').
ncbi_mult_taxo_gbnm(215345, 'Japanese aucha perch').
ncbi_mult_taxo_gbnm(215346, 'honeycomb grouper').
ncbi_mult_taxo_gbnm(215347, 'Hong Kong grouper').
ncbi_mult_taxo_gbnm(215353, manefishes).
ncbi_mult_taxo_gbnm(215356, 'blubberlip snapper').
ncbi_mult_taxo_gbnm(215358, 'large yellow croaker').
ncbi_mult_taxo_gbnm(215360, 'Nibe croaker').
ncbi_mult_taxo_gbnm(215361, 'oriental butterflyfish').
ncbi_mult_taxo_gbnm(215362, 'false moorish idol').
ncbi_mult_taxo_gbnm(215363, 'bluestriped angelfish').
ncbi_mult_taxo_gbnm(215370, 'spotted hawkfish').
ncbi_mult_taxo_gbnm(215373, 'arc-eye hawkfish').
ncbi_mult_taxo_gbnm(215378, 'tail-spot wrasse').
ncbi_mult_taxo_gbnm(215381, 'cylindrical sandperch').
ncbi_mult_taxo_gbnm(215382, 'Pacific sandeel').
ncbi_mult_taxo_gbnm(215395, nurseryfish).
ncbi_mult_taxo_gbnm(215396, 'blotched foxface').
ncbi_mult_taxo_gbnm(215401, 'longfin fathead').
ncbi_mult_taxo_gbnm(215402, 'northern snakehead').
ncbi_mult_taxo_gbnm(215407, 'slender sunfish').
ncbi_mult_taxo_gbnm(215408, 'zebra fish').
ncbi_mult_taxo_gbnm(215414, 'Sar\'s wolf eel').
ncbi_mult_taxo_gbnm(215415, 'Newfoundland eelpout').
ncbi_mult_taxo_gbnm(215416, 'longear eelpout').
ncbi_mult_taxo_gbnm(215417, 'threespot eelpout').
ncbi_mult_taxo_gbnm(215418, 'Arctic eelpout').
ncbi_mult_taxo_gbnm(215420, 'pale eelpout').
ncbi_mult_taxo_gbnm(215421, 'Paamiut eelpout').
ncbi_mult_taxo_gbnm(215422, 'McAllister\'s eelpout').
ncbi_mult_taxo_gbnm(215423, 'Lutken\'s eelpout').
ncbi_mult_taxo_gbnm(215424, 'Vahl\'s eelpout').
ncbi_mult_taxo_gbnm(215425, 'wattled eelpout').
ncbi_mult_taxo_gbnm(215426, 'black eelpout').
ncbi_mult_taxo_gbnm(215428, 'Bering eelpout').
ncbi_mult_taxo_gbnm(215430, 'ebony eelpout').
ncbi_mult_taxo_gbnm(215431, 'Adolf\'s eelpout').
ncbi_mult_taxo_gbnm(215432, 'greater eelpout').
ncbi_mult_taxo_gbnm(215433, 'doublelone eelpout').
ncbi_mult_taxo_gbnm(215434, 'moray wolf eel').
ncbi_mult_taxo_gbnm(215440, 'Sloane\'s squid').
ncbi_mult_taxo_gbnm(215716, 'deceitful crayfish').
ncbi_mult_taxo_gbnm(215731, 'blue-headed wood-dove').
ncbi_mult_taxo_gbnm(215732, tonguesole).
ncbi_mult_taxo_gbnm(216036, 'cockspur hawthorn').
ncbi_mult_taxo_gbnm(216066, 'poet\'s ivy').
ncbi_mult_taxo_gbnm(216192, 'false potato beetle').
ncbi_mult_taxo_gbnm(216193, 'greater whitethroat').
ncbi_mult_taxo_gbnm(216195, 'ragweed leaf beetle').
ncbi_mult_taxo_gbnm(216196, 'Yemen warbler').
ncbi_mult_taxo_gbnm(216197, 'ragweed leaf beetle').
ncbi_mult_taxo_gbnm(216198, 'banded warbler').
ncbi_mult_taxo_gbnm(216213, 'Layard\'s warbler').
ncbi_mult_taxo_gbnm(216215, 'red sea warbler').
ncbi_mult_taxo_gbnm(216216, 'Dartford warbler').
ncbi_mult_taxo_gbnm(216219, 'Rueppell\'s warbler').
ncbi_mult_taxo_gbnm(216220, 'barred warbler').
ncbi_mult_taxo_gbnm(216225, 'orphean warbler').
ncbi_mult_taxo_gbnm(216227, 'Spectacled warbler').
ncbi_mult_taxo_gbnm(216257, 'scaly-foot gastropod').
ncbi_mult_taxo_gbnm(216277, 'black-and-white shiny spider').
ncbi_mult_taxo_gbnm(216359, 'marbled spinefoot').
ncbi_mult_taxo_gbnm(216460, 'great nawab').
ncbi_mult_taxo_gbnm(216498, 'calcareous tube worm').
ncbi_mult_taxo_gbnm(216825, 'Namaqua sandgrouse').
ncbi_mult_taxo_gbnm(216861, 'elm spanworm').
ncbi_mult_taxo_gbnm(216862, 'grey pug').
ncbi_mult_taxo_gbnm(216870, 'sharp-angled carpet').
ncbi_mult_taxo_gbnm(216979, 'swordsnout grenadier').
ncbi_mult_taxo_gbnm(216980, 'filamented rattail').
ncbi_mult_taxo_gbnm(216981, 'ghostly grenadier').
ncbi_mult_taxo_gbnm(216982, 'Mexican grenadier').
ncbi_mult_taxo_gbnm(216983, 'thickbeard grenadier').
ncbi_mult_taxo_gbnm(216989, 'gray birch').
ncbi_mult_taxo_gbnm(216990, 'alpine birch').
ncbi_mult_taxo_gbnm(216992, 'Erman\'s birch').
ncbi_mult_taxo_gbnm(216994, 'sweet birch').
ncbi_mult_taxo_gbnm(217132, 'rock sandpiper').
ncbi_mult_taxo_gbnm(217133, 'curlew sandpiper').
ncbi_mult_taxo_gbnm(217134, 'grey-crowned rosy-finch').
ncbi_mult_taxo_gbnm(217225, 'leafy spurge flea beetles').
ncbi_mult_taxo_gbnm(217258, 'golden scorpion').
ncbi_mult_taxo_gbnm(217259, 'giant burrowing scorpion').
ncbi_mult_taxo_gbnm(217261, 'Tanzanian red clawed scorpion').
ncbi_mult_taxo_gbnm(217264, 'cave clawed scorpion').
ncbi_mult_taxo_gbnm(217443, 'diamondback moth parasitoid').
ncbi_mult_taxo_gbnm(217494, 'Peruvian anchovy').
ncbi_mult_taxo_gbnm(217509, 'crucian carp').
ncbi_mult_taxo_gbnm(217614, 'hog-nosed bats').
ncbi_mult_taxo_gbnm(217634, 'Asian longhorned beetle').
ncbi_mult_taxo_gbnm(217689, 'common hen flea').
ncbi_mult_taxo_gbnm(217708, 'long-eared hedgehog').
ncbi_mult_taxo_gbnm(217850, 'yellow-edged moray').
ncbi_mult_taxo_gbnm(217851, 'mottled moray').
ncbi_mult_taxo_gbnm(217853, 'Chinese wrasse').
ncbi_mult_taxo_gbnm(217858, 'many-keeled grass skink').
ncbi_mult_taxo_gbnm(217859, 'Tytler\'s mabuya').
ncbi_mult_taxo_gbnm(217860, 'striped grass skink').
ncbi_mult_taxo_gbnm(217861, 'Brown\'s mabuya').
ncbi_mult_taxo_gbnm(217863, 'bronze grass skink').
ncbi_mult_taxo_gbnm(217864, 'rough-scaled sun skink').
ncbi_mult_taxo_gbnm(217868, 'many-lined sun skink').
ncbi_mult_taxo_gbnm(217869, 'beautiful mabuya').
ncbi_mult_taxo_gbnm(217870, 'Southern grass skink').
ncbi_mult_taxo_gbnm(218142, 'velvet bentgrass').
ncbi_mult_taxo_gbnm(218194, 'grassland sparrow').
ncbi_mult_taxo_gbnm(218195, 'yellow-browed sparrow').
ncbi_mult_taxo_gbnm(218281, 'broad-winged hawk').
ncbi_mult_taxo_gbnm(218388, 'woolly willow').
ncbi_mult_taxo_gbnm(218467, 'bark scorpion').
ncbi_mult_taxo_gbnm(218472, 'Loveridge\'s frog').
ncbi_mult_taxo_gbnm(218474, 'mountain frog').
ncbi_mult_taxo_gbnm(218476, 'sphagnum frog').
ncbi_mult_taxo_gbnm(218685, 'barker frog').
ncbi_mult_taxo_gbnm(218701, 'Nazca booby').
ncbi_mult_taxo_gbnm(218702, 'scrub hoppers').
ncbi_mult_taxo_gbnm(218706, 'straight swift').
ncbi_mult_taxo_gbnm(218710, policemen).
ncbi_mult_taxo_gbnm(218712, 'brown awl').
ncbi_mult_taxo_gbnm(218713, swifts).
ncbi_mult_taxo_gbnm(218714, 'rice swift').
ncbi_mult_taxo_gbnm(218720, 'Arctic skipper').
ncbi_mult_taxo_gbnm(218722, 'northern checquered skipper').
ncbi_mult_taxo_gbnm(218724, 'Indian awkling').
ncbi_mult_taxo_gbnm(218728, 'palm redeye').
ncbi_mult_taxo_gbnm(218730, 'common awl').
ncbi_mult_taxo_gbnm(218742, 'restricted demon').
ncbi_mult_taxo_gbnm(218744, 'woodland skipper').
ncbi_mult_taxo_gbnm(218750, 'small branded swift').
ncbi_mult_taxo_gbnm(218760, 'grizzled skipper').
ncbi_mult_taxo_gbnm(218763, 'Indian palm bob').
ncbi_mult_taxo_gbnm(218765, 'palm darts').
ncbi_mult_taxo_gbnm(218773, 'Essex skipper').
ncbi_mult_taxo_gbnm(218777, 'grass demon').
ncbi_mult_taxo_gbnm(218787, 'Chaco marsh rat').
ncbi_mult_taxo_gbnm(218793, 'dusky rice rat').
ncbi_mult_taxo_gbnm(218797, 'Malabar blood snapper').
ncbi_mult_taxo_gbnm(218798, 'narrow-barred Spanish mackerel').
ncbi_mult_taxo_gbnm(218800, 'Santiago Galapagos mouse').
ncbi_mult_taxo_gbnm(218802, 'decorated ponyfish').
ncbi_mult_taxo_gbnm(218803, 'slender ponyfish').
ncbi_mult_taxo_gbnm(218808, 'splendid ponyfish').
ncbi_mult_taxo_gbnm(218816, 'smalltoothed ponyfish').
ncbi_mult_taxo_gbnm(218817, 'unicolored arboreal rice rat').
ncbi_mult_taxo_gbnm(218818, 'ovoid toothpony').
ncbi_mult_taxo_gbnm(218819, toothpony).
ncbi_mult_taxo_gbnm(218820, 'Mamore arboreal rice rat').
ncbi_mult_taxo_gbnm(218824, 'yellow pygmy rice rat').
ncbi_mult_taxo_gbnm(218825, 'fulvous pygmy rice rat').
ncbi_mult_taxo_gbnm(218834, 'Brazilian false rice rat').
ncbi_mult_taxo_gbnm(218836, 'Goldman\'s water mouse').
ncbi_mult_taxo_gbnm(218838, 'Alfaro\'s rice water rat').
ncbi_mult_taxo_gbnm(218839, 'Peters\'s climbing rat').
ncbi_mult_taxo_gbnm(218842, 'Ucayali water rat').
ncbi_mult_taxo_gbnm(219105, 'brown-tailed mongoose').
ncbi_mult_taxo_gbnm(219107, falanouc).
ncbi_mult_taxo_gbnm(219214, 'Chinese grey shrike').
ncbi_mult_taxo_gbnm(219215, 'Southern grey shrike').
ncbi_mult_taxo_gbnm(219287, 'metalmark moths').
ncbi_mult_taxo_gbnm(219331, 'aspen carpenterworm').
ncbi_mult_taxo_gbnm(219333, 'spiny oak slug').
ncbi_mult_taxo_gbnm(219407, 'American carrion beetle').
ncbi_mult_taxo_gbnm(219430, 'tumbling flower beetles').
ncbi_mult_taxo_gbnm(219432, 'ironclad beetles').
ncbi_mult_taxo_gbnm(219437, 'jugular-horned beetles').
ncbi_mult_taxo_gbnm(219442, 'ant beetles').
ncbi_mult_taxo_gbnm(219522, 'lesser honeyguide').
ncbi_mult_taxo_gbnm(219525, 'forrest kingfisher').
ncbi_mult_taxo_gbnm(219529, 'grape leaf roller').
ncbi_mult_taxo_gbnm(219534, 'spotted bullhead').
ncbi_mult_taxo_gbnm(219535, 'flat bullhead').
ncbi_mult_taxo_gbnm(219540, 'snail bullhead').
ncbi_mult_taxo_gbnm(219542, 'bacon beetle').
ncbi_mult_taxo_gbnm(219545, 'black bullhead').
ncbi_mult_taxo_gbnm(219556, 'gladiator meadow katydid').
ncbi_mult_taxo_gbnm(219593, 'common pochard').
ncbi_mult_taxo_gbnm(219594, 'tufted duck').
ncbi_mult_taxo_gbnm(219595, 'common whooper').
ncbi_mult_taxo_gbnm(219617, 'giant plated lizard').
ncbi_mult_taxo_gbnm(219623, 'desert plated lizard').
ncbi_mult_taxo_gbnm(219625, 'dwarf plated lizard').
ncbi_mult_taxo_gbnm(219626, 'Western girdled lizard').
ncbi_mult_taxo_gbnm(219627, 'African whip lizard').
ncbi_mult_taxo_gbnm(219628, 'longtail whip lizard').
ncbi_mult_taxo_gbnm(219630, 'keeled plated lizard').
ncbi_mult_taxo_gbnm(219631, 'Kalahari plated lizard').
ncbi_mult_taxo_gbnm(219661, 'giant frond-aeolis').
ncbi_mult_taxo_gbnm(219677, 'Amur minnow').
ncbi_mult_taxo_gbnm(219678, 'lake minnow').
ncbi_mult_taxo_gbnm(219679, 'Czekanowski\'s minnow').
ncbi_mult_taxo_gbnm(219752, pejerrey).
ncbi_mult_taxo_gbnm(219868, clove).
ncbi_mult_taxo_gbnm(219892, 'Malay apple').
ncbi_mult_taxo_gbnm(220090, 'poplar petiole gall aphid').
ncbi_mult_taxo_gbnm(220101, 'large-spotted genet').
ncbi_mult_taxo_gbnm(220483, 'European searocket').
ncbi_mult_taxo_gbnm(220703, 'North African fire salamander').
ncbi_mult_taxo_gbnm(220712, 'chicken liver sponge').
ncbi_mult_taxo_gbnm(220785, 'lowlands earless skink').
ncbi_mult_taxo_gbnm(220788, 'ornate soil-crevice skink').
ncbi_mult_taxo_gbnm(221086, 'least long-fingered bat').
ncbi_mult_taxo_gbnm(221087, 'greater long-fingered bat').
ncbi_mult_taxo_gbnm(221088, 'great bent-winged bat').
ncbi_mult_taxo_gbnm(221089, 'large Melanesian bent-wing bat').
ncbi_mult_taxo_gbnm(221128, 'western pebble-mound mouse').
ncbi_mult_taxo_gbnm(221160, 'Ili pika').
ncbi_mult_taxo_gbnm(221188, 'orange hawkweed').
ncbi_mult_taxo_gbnm(221190, 'meadow hawkweed').
ncbi_mult_taxo_gbnm(221419, 'redtail catfish').
ncbi_mult_taxo_gbnm(221446, 'brown tent-making bat').
ncbi_mult_taxo_gbnm(221562, 'Yunnan dwarf gecko').
ncbi_mult_taxo_gbnm(221568, olm).
ncbi_mult_taxo_gbnm(221579, 'Brazilian arboreal mouse').
ncbi_mult_taxo_gbnm(221682, 'Lorrain dormouse').
ncbi_mult_taxo_gbnm(221694, 'Roach\'s mouse-tailed dormouse').
ncbi_mult_taxo_gbnm(221695, 'Asian garden dormouse').
ncbi_mult_taxo_gbnm(221696, 'woolly dormouse').
ncbi_mult_taxo_gbnm(221698, 'spectacled dormouse').
ncbi_mult_taxo_gbnm(221699, 'rock dormouse').
ncbi_mult_taxo_gbnm(221700, 'small-eared dormouse').
ncbi_mult_taxo_gbnm(221716, 'Bloody Bay poison frog').
ncbi_mult_taxo_gbnm(221718, 'Trinidad poison frog').
ncbi_mult_taxo_gbnm(221764, silverhead).
ncbi_mult_taxo_gbnm(221863, 'Dorab wolf-herring').
ncbi_mult_taxo_gbnm(221866, 'dwarf round herring').
ncbi_mult_taxo_gbnm(221902, 'face fly').
ncbi_mult_taxo_gbnm(221905, 'black dump fly').
ncbi_mult_taxo_gbnm(221912, 'western chestnut mouse').
ncbi_mult_taxo_gbnm(221913, 'sandy inland mouse').
ncbi_mult_taxo_gbnm(221914, 'brown desert mouse').
ncbi_mult_taxo_gbnm(221924, 'Longman\'s beaked whale').
ncbi_mult_taxo_gbnm(221964, 'fasciated wren').
ncbi_mult_taxo_gbnm(221966, 'Rufous rock-jumper').
ncbi_mult_taxo_gbnm(221968, 'red-faced crimson-wing').
ncbi_mult_taxo_gbnm(221969, 'red-striped flowerpecker').
ncbi_mult_taxo_gbnm(221971, 'wedge-tailed grass-finch').
ncbi_mult_taxo_gbnm(221972, 'purple-throated Euphonia').
ncbi_mult_taxo_gbnm(221973, 'long-tailed widowbird').
ncbi_mult_taxo_gbnm(221976, 'rufous-necked snowfinch').
ncbi_mult_taxo_gbnm(221977, 'masked gnatcatcher').
ncbi_mult_taxo_gbnm(221979, 'green-headed Tanager').
ncbi_mult_taxo_gbnm(221980, 'Indian Kiang').
ncbi_mult_taxo_gbnm(221981, 'Persian onager').
ncbi_mult_taxo_gbnm(222416, 'Javan langur').
ncbi_mult_taxo_gbnm(222432, 'corn hopper').
ncbi_mult_taxo_gbnm(222595, 'splendid fairywren').
ncbi_mult_taxo_gbnm(222784, 'elm sawfly').
ncbi_mult_taxo_gbnm(222809, 'pigeon tremex').
ncbi_mult_taxo_gbnm(222834, 'indigo hamlet').
ncbi_mult_taxo_gbnm(222835, 'golden hamlet').
ncbi_mult_taxo_gbnm(222863, 'woolly rhinoceros').
ncbi_mult_taxo_gbnm(223139, 'Hawaiian whitespotted toby').
ncbi_mult_taxo_gbnm(223141, 'striped burrfish').
ncbi_mult_taxo_gbnm(223143, 'pelagic porcupinefish').
ncbi_mult_taxo_gbnm(223145, 'spot-fin porcupinefish').
ncbi_mult_taxo_gbnm(223152, 'Valentinni\'s sharpnose puffer').
ncbi_mult_taxo_gbnm(223164, 'Black-cowled oriole').
ncbi_mult_taxo_gbnm(223211, 'sharptail mola').
ncbi_mult_taxo_gbnm(223228, 'striped mealybug').
ncbi_mult_taxo_gbnm(223243, 'Taiwan giant cricket').
ncbi_mult_taxo_gbnm(223369, 'banded astyanax').
ncbi_mult_taxo_gbnm(223394, 'southern dampwood termite').
ncbi_mult_taxo_gbnm(223437, 'jackal buzzard').
ncbi_mult_taxo_gbnm(223438, 'red-necked buzzard').
ncbi_mult_taxo_gbnm(223440, 'rough-legged buzzard').
ncbi_mult_taxo_gbnm(223441, 'ferruginous hawk').
ncbi_mult_taxo_gbnm(223443, 'rufous-tailed hawk').
ncbi_mult_taxo_gbnm(223445, 'white-throated hawk').
ncbi_mult_taxo_gbnm(223459, 'prune mite').
ncbi_mult_taxo_gbnm(223473, 'zone-tailed hawk').
ncbi_mult_taxo_gbnm(223475, 'red-shouldered hawk').
ncbi_mult_taxo_gbnm(223485, 'white-tailed hawk').
ncbi_mult_taxo_gbnm(223490, 'white-rumped hawk').
ncbi_mult_taxo_gbnm(223492, 'Harris\'s hawk').
ncbi_mult_taxo_gbnm(223496, 'savanna hawk').
ncbi_mult_taxo_gbnm(223497, 'great black-hawk').
ncbi_mult_taxo_gbnm(223503, 'augur buzzard').
ncbi_mult_taxo_gbnm(223567, 'desert rat kangaroo').
ncbi_mult_taxo_gbnm(223568, 'Tasmanian bettong').
ncbi_mult_taxo_gbnm(223647, 'smallhead hairtail').
ncbi_mult_taxo_gbnm(223748, 'glacier ice worm').
ncbi_mult_taxo_gbnm(223770, 'Madagascar buzzard').
ncbi_mult_taxo_gbnm(223771, 'Himalayan buzzard').
ncbi_mult_taxo_gbnm(223773, 'black-chested buzzard-eagle').
ncbi_mult_taxo_gbnm(223777, 'black-collared hawk').
ncbi_mult_taxo_gbnm(223780, 'lizard buzzard').
ncbi_mult_taxo_gbnm(223795, 'blackthroat seaperch').
ncbi_mult_taxo_gbnm(223803, 'silverbelly seaperch').
ncbi_mult_taxo_gbnm(223805, 'blackmouth cardinalfish').
ncbi_mult_taxo_gbnm(223808, 'Japanese perchlet').
ncbi_mult_taxo_gbnm(223847, 'lowland tree kangaroo').
ncbi_mult_taxo_gbnm(223850, 'Ridgway\'s hawk').
ncbi_mult_taxo_gbnm(223852, 'brown citrus aphid').
ncbi_mult_taxo_gbnm(223853, 'short-tailed hawk').
ncbi_mult_taxo_gbnm(223855, 'Hawaiian hawk').
ncbi_mult_taxo_gbnm(223857, 'Archer\'s buzzard').
ncbi_mult_taxo_gbnm(223860, 'rough ray').
ncbi_mult_taxo_gbnm(223861, 'speckled ray').
ncbi_mult_taxo_gbnm(223862, 'blonde ray').
ncbi_mult_taxo_gbnm(223863, 'small-eyed ray').
ncbi_mult_taxo_gbnm(223870, 'Japanese mugwort').
ncbi_mult_taxo_gbnm(223888, 'cuckoo ray').
ncbi_mult_taxo_gbnm(223889, 'shagreen ray').
ncbi_mult_taxo_gbnm(223890, 'Maltese ray').
ncbi_mult_taxo_gbnm(223980, 'southern orange-lined cardinal fish').
ncbi_mult_taxo_gbnm(223981, 'yellowstriped cardinalfish').
ncbi_mult_taxo_gbnm(223995, 'mustard aphid').
ncbi_mult_taxo_gbnm(223998, 'Hokkaido sika deer').
ncbi_mult_taxo_gbnm(224100, 'Ansorge\'s danaid').
ncbi_mult_taxo_gbnm(224105, 'map butterflies').
ncbi_mult_taxo_gbnm(224106, 'common map butterfly').
ncbi_mult_taxo_gbnm(224122, 'brown tree nymph').
ncbi_mult_taxo_gbnm(224129, 'emerald ash borer').
ncbi_mult_taxo_gbnm(224195, 'Mixe swordtail').
ncbi_mult_taxo_gbnm(224270, 'sand perch').
ncbi_mult_taxo_gbnm(224313, 'New World quails').
ncbi_mult_taxo_gbnm(224315, 'black-breasted wood quail').
ncbi_mult_taxo_gbnm(224329, 'Gray snub-nosed monkey').
ncbi_mult_taxo_gbnm(224340, 'Cameroon clawed frog').
ncbi_mult_taxo_gbnm(224534, 'tropical fowl mites').
ncbi_mult_taxo_gbnm(224536, 'northern fowl mite').
ncbi_mult_taxo_gbnm(224668, 'rufous crab-hawk').
ncbi_mult_taxo_gbnm(224703, 'blueback shad').
ncbi_mult_taxo_gbnm(224705, 'scaled sardine').
ncbi_mult_taxo_gbnm(224707, 'Gulf menhaden').
ncbi_mult_taxo_gbnm(224708, 'Atlantic menhaden').
ncbi_mult_taxo_gbnm(224711, 'Atlantic thread herring').
ncbi_mult_taxo_gbnm(224713, 'threadfin shad').
ncbi_mult_taxo_gbnm(224716, 'red-eye round herring').
ncbi_mult_taxo_gbnm(224718, 'bay anchovy').
ncbi_mult_taxo_gbnm(224866, 'red ucuuba').
ncbi_mult_taxo_gbnm(225060, 'spotted bass').
ncbi_mult_taxo_gbnm(225061, 'redeye bass').
ncbi_mult_taxo_gbnm(225063, 'locust gall midge').
ncbi_mult_taxo_gbnm(225112, 'parrot\'s beak').
ncbi_mult_taxo_gbnm(225117, 'Chinese white pear').
ncbi_mult_taxo_gbnm(225159, 'California fingered limpet').
ncbi_mult_taxo_gbnm(225164, 'owl limpet').
ncbi_mult_taxo_gbnm(225199, 'Wolffsohn\'s Viscacha').
ncbi_mult_taxo_gbnm(225337, 'blind click beetle').
ncbi_mult_taxo_gbnm(225365, 'Anderson\'s mouse opossum').
ncbi_mult_taxo_gbnm(225389, 'freshwater drum').
ncbi_mult_taxo_gbnm(225390, 'redspotted sunfish').
ncbi_mult_taxo_gbnm(225391, 'Florida bass').
ncbi_mult_taxo_gbnm(225392, 'Guadalupe bass').
ncbi_mult_taxo_gbnm(225393, 'Suwannee bass').
ncbi_mult_taxo_gbnm(225394, 'shoal bass').
ncbi_mult_taxo_gbnm(225396, 'little ringed plover').
ncbi_mult_taxo_gbnm(225398, 'black-winged stilt').
ncbi_mult_taxo_gbnm(225399, 'large Myotis').
ncbi_mult_taxo_gbnm(225401, 'Hodgson\'s bat').
ncbi_mult_taxo_gbnm(225402, 'Mexican mouse opossum').
ncbi_mult_taxo_gbnm(225403, 'Theresa\'s short-tailed opossum').
ncbi_mult_taxo_gbnm(225404, 'gray slender mouse opossum').
ncbi_mult_taxo_gbnm(225405, 'Southeastern four-eyed oppossum').
ncbi_mult_taxo_gbnm(225729, 'Tate\'s woolly mouse opossum').
ncbi_mult_taxo_gbnm(225753, 'common goby').
ncbi_mult_taxo_gbnm(225755, 'streamlined spinefoot').
ncbi_mult_taxo_gbnm(225756, 'peppered spinefoot').
ncbi_mult_taxo_gbnm(225757, 'mottled spinefoot').
ncbi_mult_taxo_gbnm(225758, 'little spinefoot').
ncbi_mult_taxo_gbnm(225759, 'barhead spinefoot').
ncbi_mult_taxo_gbnm(225760, 'streaked spinefoot').
ncbi_mult_taxo_gbnm(225761, 'vermiculated spinefoot').
ncbi_mult_taxo_gbnm(225807, 'green slangkop').
ncbi_mult_taxo_gbnm(225904, 'crawfish frog').
ncbi_mult_taxo_gbnm(225969, 'sensitive partridge pea').
ncbi_mult_taxo_gbnm(226132, 'tumbu fly').
ncbi_mult_taxo_gbnm(226135, 'camouflaged flesh fly').
ncbi_mult_taxo_gbnm(226172, 'aspen hoverfly').
ncbi_mult_taxo_gbnm(226208, 'redroot sage').
ncbi_mult_taxo_gbnm(226546, 'Asian red-cheeked squirrel').
ncbi_mult_taxo_gbnm(226548, 'Philippine pygmy squirrel').
ncbi_mult_taxo_gbnm(226549, 'least pygmy squirrel').
ncbi_mult_taxo_gbnm(226551, 'sculptor squirrel').
ncbi_mult_taxo_gbnm(226555, 'montane long-nosed squirrel').
ncbi_mult_taxo_gbnm(226558, 'three-striped ground squirrel').
ncbi_mult_taxo_gbnm(226563, 'black-eared squirrel').
ncbi_mult_taxo_gbnm(226567, 'Celebes dwarf squirrel').
ncbi_mult_taxo_gbnm(226571, 'shrew-faced squirrel').
ncbi_mult_taxo_gbnm(226573, 'Sulawesi giant squirrel').
ncbi_mult_taxo_gbnm(226574, 'Sunda squirrels').
ncbi_mult_taxo_gbnm(226575, 'Brooke\'s squirrel').
ncbi_mult_taxo_gbnm(226677, 'oilcloth-flower').
ncbi_mult_taxo_gbnm(226678, 'Indian palm squirrel').
ncbi_mult_taxo_gbnm(226679, 'rope squirrels').
ncbi_mult_taxo_gbnm(226680, 'fire-footed rope squirrel').
ncbi_mult_taxo_gbnm(226681, 'Alexander\'s bush squirrel').
ncbi_mult_taxo_gbnm(226683, 'Biafran palm squirrel').
ncbi_mult_taxo_gbnm(226684, 'sun squirrels').
ncbi_mult_taxo_gbnm(226685, 'Ruwenzori sun squirrel').
ncbi_mult_taxo_gbnm(226687, 'African pygmy squirrel').
ncbi_mult_taxo_gbnm(226692, 'forest giant squirrel').
ncbi_mult_taxo_gbnm(226695, 'North Chinese flying squirrel').
ncbi_mult_taxo_gbnm(226697, 'black flying squirrel').
ncbi_mult_taxo_gbnm(226699, 'woolly flying squirrel').
ncbi_mult_taxo_gbnm(226811, 'Kashmir flying squirrel').
ncbi_mult_taxo_gbnm(226813, 'Javanese flying squirrel').
ncbi_mult_taxo_gbnm(226815, 'Selangor pygmy flying squirrel').
ncbi_mult_taxo_gbnm(226817, 'smoky flying squirrel').
ncbi_mult_taxo_gbnm(226819, 'complex-toothed flying squirrel').
ncbi_mult_taxo_gbnm(226821, 'pale giant squirrel').
ncbi_mult_taxo_gbnm(226822, 'black giant squirrel').
ncbi_mult_taxo_gbnm(226835, 'tufted ground squirrel').
ncbi_mult_taxo_gbnm(226841, 'Bangs\'s mountain squirrel').
ncbi_mult_taxo_gbnm(226849, 'Pere David\'s rock squirrel').
ncbi_mult_taxo_gbnm(226855, 'Barbary ground squirrel').
ncbi_mult_taxo_gbnm(226859, 'African ground squirrels').
ncbi_mult_taxo_gbnm(226860, 'unstriped ground squirrel').
ncbi_mult_taxo_gbnm(226865, 'Central American dwarf squirrel').
ncbi_mult_taxo_gbnm(226870, 'red-tailed squirrel').
ncbi_mult_taxo_gbnm(226872, 'Bolivian squirrel').
ncbi_mult_taxo_gbnm(226875, 'variegated squirrel').
ncbi_mult_taxo_gbnm(226888, 'banded salamander').
ncbi_mult_taxo_gbnm(226889, 'Algerian ribbed newt').
ncbi_mult_taxo_gbnm(226931, 'common bully').
ncbi_mult_taxo_gbnm(226939, 'dusky spinefoot').
ncbi_mult_taxo_gbnm(227087, 'Maned three-toed sloth').
ncbi_mult_taxo_gbnm(227091, 'Mediterranean worm lizard').
ncbi_mult_taxo_gbnm(227166, 'Irish elk').
ncbi_mult_taxo_gbnm(227169, 'black-bellied sandgrouse').
ncbi_mult_taxo_gbnm(227172, 'water thick-knee').
ncbi_mult_taxo_gbnm(227173, 'red knot').
ncbi_mult_taxo_gbnm(227175, 'Wilson\'s phalarope').
ncbi_mult_taxo_gbnm(227177, 'Temminck\'s courser').
ncbi_mult_taxo_gbnm(227179, 'diademed sandpiper-plover').
ncbi_mult_taxo_gbnm(227182, 'black-faced sheathbill').
ncbi_mult_taxo_gbnm(227184, 'black skimmer').
ncbi_mult_taxo_gbnm(227186, 'South American tern').
ncbi_mult_taxo_gbnm(227192, 'plains-wanderer').
ncbi_mult_taxo_gbnm(227228, 'magellanic plover').
ncbi_mult_taxo_gbnm(227231, 'black-necked stilt').
ncbi_mult_taxo_gbnm(227233, 'rufous-bellied seedsnipe').
ncbi_mult_taxo_gbnm(227234, 'spotted thick-knee').
ncbi_mult_taxo_gbnm(227235, 'rock pratincole').
ncbi_mult_taxo_gbnm(227236, 'American avocet').
ncbi_mult_taxo_gbnm(227275, 'beardless barb').
ncbi_mult_taxo_gbnm(227283, 'Hampala barb').
ncbi_mult_taxo_gbnm(227286, 'river carp').
ncbi_mult_taxo_gbnm(227288, 'silver sharkminnow').
ncbi_mult_taxo_gbnm(227354, 'yellow-spined bamboo locust').
ncbi_mult_taxo_gbnm(227459, 'Euphrates soft-shelled turtle').
ncbi_mult_taxo_gbnm(227460, 'Gulf Coast spiny softshell').
ncbi_mult_taxo_gbnm(227466, 'Burmese flap-shelled turtle').
ncbi_mult_taxo_gbnm(227480, 'willow leaf beetle').
ncbi_mult_taxo_gbnm(227481, 'heather beetle').
ncbi_mult_taxo_gbnm(227496, 'green dragon').
ncbi_mult_taxo_gbnm(227508, 'two-toed sloths').
ncbi_mult_taxo_gbnm(227532, 'orange tip').
ncbi_mult_taxo_gbnm(227535, 'poplar admiral').
ncbi_mult_taxo_gbnm(227548, 'giant harlequin beetle').
ncbi_mult_taxo_gbnm(227614, lilliput).
ncbi_mult_taxo_gbnm(227725, naranjilla).
ncbi_mult_taxo_gbnm(227743, 'Norse grayling').
ncbi_mult_taxo_gbnm(227871, 'yellow-spotted Amazon River turtle').
ncbi_mult_taxo_gbnm(227875, 'rufous-crested tanager').
ncbi_mult_taxo_gbnm(227876, 'short-billed honeycreeper').
ncbi_mult_taxo_gbnm(227887, 'Himalayan water shrew').
ncbi_mult_taxo_gbnm(227976, 'sea trout').
ncbi_mult_taxo_gbnm(227978, 'yellow mouth salmon').
ncbi_mult_taxo_gbnm(227980, 'corrugated darter').
ncbi_mult_taxo_gbnm(227981, 'stone darter').
ncbi_mult_taxo_gbnm(228011, 'pea blue').
ncbi_mult_taxo_gbnm(228027, 'Cumberland monkeyface').
ncbi_mult_taxo_gbnm(228028, 'Appalachian monkeyface').
ncbi_mult_taxo_gbnm(228029, 'Coosa orb').
ncbi_mult_taxo_gbnm(228080, 'western fanshell').
ncbi_mult_taxo_gbnm(228082, 'dromedary pearlymussel').
ncbi_mult_taxo_gbnm(228084, 'cracking pearlymussel').
ncbi_mult_taxo_gbnm(228086, pistolgrip).
ncbi_mult_taxo_gbnm(228089, 'purple wartyback').
ncbi_mult_taxo_gbnm(228163, 'Himalayan birch').
ncbi_mult_taxo_gbnm(228181, 'hairy banana').
ncbi_mult_taxo_gbnm(228183, 'Manila hemp').
ncbi_mult_taxo_gbnm(228248, 'Chinese monal').
ncbi_mult_taxo_gbnm(228249, 'Sclater\'s monal').
ncbi_mult_taxo_gbnm(228252, 'leopard mandarin fish').
ncbi_mult_taxo_gbnm(228279, 'yellow-throated longclaw').
ncbi_mult_taxo_gbnm(228295, 'sooty flycatcher').
ncbi_mult_taxo_gbnm(228300, 'Ceylon blue glassy tiger').
ncbi_mult_taxo_gbnm(228303, 'ashy alseonax').
ncbi_mult_taxo_gbnm(228306, 'siberian blue robbin').
ncbi_mult_taxo_gbnm(228307, 'blue-fronted redstart').
ncbi_mult_taxo_gbnm(228309, 'fire-crested alethe').
ncbi_mult_taxo_gbnm(228314, 'Archer\'s robin-chat').
ncbi_mult_taxo_gbnm(228315, 'blue-shouldered robin-chat').
ncbi_mult_taxo_gbnm(228316, 'snowy-crowned robin-chat').
ncbi_mult_taxo_gbnm(228317, 'cape robin-chat').
ncbi_mult_taxo_gbnm(228318, 'chorister robin-chat').
ncbi_mult_taxo_gbnm(228319, 'grey-winged robin-chat').
ncbi_mult_taxo_gbnm(228321, 'white-starred robin').
ncbi_mult_taxo_gbnm(228322, 'white-winged redstart').
ncbi_mult_taxo_gbnm(228324, 'Swynnerton\'s robin').
ncbi_mult_taxo_gbnm(228326, 'white-winged fairy-wren').
ncbi_mult_taxo_gbnm(228331, 'red-backed scrub-robbin').
ncbi_mult_taxo_gbnm(228332, 'gabelia akalat').
ncbi_mult_taxo_gbnm(228334, 'white-bellied robin-chat').
ncbi_mult_taxo_gbnm(228337, 'Bocage\'s akalat').
ncbi_mult_taxo_gbnm(228338, 'olive-flanked robin-chat').
ncbi_mult_taxo_gbnm(228339, 'mountain robin-chat').
ncbi_mult_taxo_gbnm(228352, 'variegated fairywren').
ncbi_mult_taxo_gbnm(228395, 'red spider lily').
ncbi_mult_taxo_gbnm(228401, 'eastern Canadian wolf').
ncbi_mult_taxo_gbnm(228417, 'Senegal thick-knee').
ncbi_mult_taxo_gbnm(228418, 'white-bellied green-pigeon').
ncbi_mult_taxo_gbnm(228420, 'black-backed frog').
ncbi_mult_taxo_gbnm(228422, 'pygmy robber frog').
ncbi_mult_taxo_gbnm(228423, 'leopard robber frog').
ncbi_mult_taxo_gbnm(228425, 'western yellow-bellied robber frog').
ncbi_mult_taxo_gbnm(228426, 'whistling chirping frog').
ncbi_mult_taxo_gbnm(228428, 'Ford\'s robber frog').
ncbi_mult_taxo_gbnm(228429, 'barking frog').
ncbi_mult_taxo_gbnm(228430, 'Bocourt\'s robber frog').
ncbi_mult_taxo_gbnm(228433, 'slim-fingered rain frog').
ncbi_mult_taxo_gbnm(228434, 'long-snouted whistling frog').
ncbi_mult_taxo_gbnm(228435, 'Fitzinger\'s robber frog').
ncbi_mult_taxo_gbnm(228436, 'Mexican robber frog').
ncbi_mult_taxo_gbnm(228437, 'pygmy free-fingered frog').
ncbi_mult_taxo_gbnm(228438, 'Chiapas dwarf robber frog').
ncbi_mult_taxo_gbnm(228440, 'evergreen robber frog').
ncbi_mult_taxo_gbnm(228441, 'Tilaran robber frog').
ncbi_mult_taxo_gbnm(228442, 'montane robber frog').
ncbi_mult_taxo_gbnm(228443, 'Noble\'s robber frog').
ncbi_mult_taxo_gbnm(228444, 'broad-headed rainfrog').
ncbi_mult_taxo_gbnm(228445, 'Chac\'s rainfrog').
ncbi_mult_taxo_gbnm(228446, 'polymorphic robber frog').
ncbi_mult_taxo_gbnm(228447, 'common leaf-litter frog').
ncbi_mult_taxo_gbnm(228448, 'Cerro Utyum robber frog').
ncbi_mult_taxo_gbnm(228449, 'Stejneger\'s rainfrog').
ncbi_mult_taxo_gbnm(228452, 'Bransford\'s litter frog').
ncbi_mult_taxo_gbnm(228541, 'flat-headed goby').
ncbi_mult_taxo_gbnm(228564, 'Chatham Islands robin').
ncbi_mult_taxo_gbnm(228608, 'Cape clawed frog').
ncbi_mult_taxo_gbnm(228609, 'steppe pika').
ncbi_mult_taxo_gbnm(228653, 'longfin codling').
ncbi_mult_taxo_gbnm(228670, 'western spadefoot toad').
ncbi_mult_taxo_gbnm(228971, 'Peruvian boll weevil').
ncbi_mult_taxo_gbnm(228974, 'five-ribbed thyme').
ncbi_mult_taxo_gbnm(229052, 'lesser long-tailed shrew tenrec').
ncbi_mult_taxo_gbnm(229053, 'greater long-tailed shrew tenrec').
ncbi_mult_taxo_gbnm(229054, 'least shrew tenrec').
ncbi_mult_taxo_gbnm(229056, 'smooth blaasop').
ncbi_mult_taxo_gbnm(229057, 'silver-cheeked toadfish').
ncbi_mult_taxo_gbnm(229058, 'yellow boxfish').
ncbi_mult_taxo_gbnm(229059, 'blunthead puffer').
ncbi_mult_taxo_gbnm(229060, gomafugu).
ncbi_mult_taxo_gbnm(229061, 'starry toadfish').
ncbi_mult_taxo_gbnm(229062, 'long-spine porcupinefish').
ncbi_mult_taxo_gbnm(229067, 'skunk clownfish').
ncbi_mult_taxo_gbnm(229068, 'barrier reef anemonefish').
ncbi_mult_taxo_gbnm(229069, 'twobar anemonefish').
ncbi_mult_taxo_gbnm(229070, 'Mauritian anemonefish').
ncbi_mult_taxo_gbnm(229071, 'orangefin anemonefish').
ncbi_mult_taxo_gbnm(229072, 'fire clownfish').
ncbi_mult_taxo_gbnm(229073, 'Maldive anemonefish').
ncbi_mult_taxo_gbnm(229074, 'Oman anemonefish').
ncbi_mult_taxo_gbnm(229075, 'Sebae anemonefish').
ncbi_mult_taxo_gbnm(229077, 'Ambon chromis').
ncbi_mult_taxo_gbnm(229078, 'black-axil chromis').
ncbi_mult_taxo_gbnm(229079, 'dark-fin chromis').
ncbi_mult_taxo_gbnm(229080, 'stout chromis').
ncbi_mult_taxo_gbnm(229081, 'yellow-spotted chromis').
ncbi_mult_taxo_gbnm(229082, 'bicolor chromis').
ncbi_mult_taxo_gbnm(229083, 'barrier reef chromis').
ncbi_mult_taxo_gbnm(229084, 'black-bar chromis').
ncbi_mult_taxo_gbnm(229085, 'Weber\'s chromis').
ncbi_mult_taxo_gbnm(229086, 'yellowfin chromis').
ncbi_mult_taxo_gbnm(229087, 'green damselfish').
ncbi_mult_taxo_gbnm(229088, 'Bengal sergeant').
ncbi_mult_taxo_gbnm(229089, 'black-tail sergeant').
ncbi_mult_taxo_gbnm(229090, 'pearly sergeant').
ncbi_mult_taxo_gbnm(229091, 'yellowtail sergeant').
ncbi_mult_taxo_gbnm(229092, 'banded sergeant').
ncbi_mult_taxo_gbnm(229093, 'false-eye sergeant').
ncbi_mult_taxo_gbnm(229096, 'yellowbelly damselfish').
ncbi_mult_taxo_gbnm(229097, 'yellow-crowned bishop').
ncbi_mult_taxo_gbnm(229098, 'red bishop').
ncbi_mult_taxo_gbnm(229099, 'footballer demoiselle').
ncbi_mult_taxo_gbnm(229100, 'Siberian rubythroat').
ncbi_mult_taxo_gbnm(229101, 'canary demoiselle').
ncbi_mult_taxo_gbnm(229119, 'grey demoiselle').
ncbi_mult_taxo_gbnm(229120, 'azure demoiselle').
ncbi_mult_taxo_gbnm(229121, 'Talbot\'s demoiselle').
ncbi_mult_taxo_gbnm(229122, 'southseas devil').
ncbi_mult_taxo_gbnm(229123, 'black-vent damsel').
ncbi_mult_taxo_gbnm(229125, 'lagoon damselfish').
ncbi_mult_taxo_gbnm(229126, 'brown demoiselle').
ncbi_mult_taxo_gbnm(229127, 'Miry\'s demoiselle').
ncbi_mult_taxo_gbnm(229128, 'coral demoiselle').
ncbi_mult_taxo_gbnm(229129, 'Arabian demoiselle').
ncbi_mult_taxo_gbnm(229130, 'obscure damsel').
ncbi_mult_taxo_gbnm(229131, 'Australian damsel').
ncbi_mult_taxo_gbnm(229132, 'bluespot damsel').
ncbi_mult_taxo_gbnm(229133, 'scaly damsel').
ncbi_mult_taxo_gbnm(229134, 'slender damsel').
ncbi_mult_taxo_gbnm(229136, 'Nagasaki damsel').
ncbi_mult_taxo_gbnm(229137, 'goldback damsel').
ncbi_mult_taxo_gbnm(229138, 'Philippine damsel').
ncbi_mult_taxo_gbnm(229139, 'Reid\'s damsel').
ncbi_mult_taxo_gbnm(229140, 'Smith\'s damsel').
ncbi_mult_taxo_gbnm(229141, 'threeline damsel').
ncbi_mult_taxo_gbnm(229143, 'Tahitian reef-damsel').
ncbi_mult_taxo_gbnm(229144, 'striped seaperch').
ncbi_mult_taxo_gbnm(229201, sparkleberry).
ncbi_mult_taxo_gbnm(229290, sablefish).
ncbi_mult_taxo_gbnm(229291, 'bluestreak damselfish').
ncbi_mult_taxo_gbnm(229469, 'little brown bustard').
ncbi_mult_taxo_gbnm(229479, 'southern damselfly').
ncbi_mult_taxo_gbnm(229552, 'red-crowned parrot').
ncbi_mult_taxo_gbnm(229553, 'yellow-shouldered parrot').
ncbi_mult_taxo_gbnm(229618, 'Hawaiian shoulderspot goby').
ncbi_mult_taxo_gbnm(229908, 'Crimean scorpion').
ncbi_mult_taxo_gbnm(229990, 'Oriental migratory locust').
ncbi_mult_taxo_gbnm(230079, 'Thomas\'s giant deer mouse').
ncbi_mult_taxo_gbnm(230081, 'Mexican volcano mouse').
ncbi_mult_taxo_gbnm(230082, 'Chiapan deer mouse').
ncbi_mult_taxo_gbnm(230084, 'Kemp\'s akodont').
ncbi_mult_taxo_gbnm(230113, 'Parana akodont').
ncbi_mult_taxo_gbnm(230148, 'Tanaka\'s snailfish').
ncbi_mult_taxo_gbnm(230186, 'Colombian grass mouse').
ncbi_mult_taxo_gbnm(230187, 'Spegazzini\'s grass mouse').
ncbi_mult_taxo_gbnm(230234, 'eastern mouse spider').
ncbi_mult_taxo_gbnm(230469, 'hognose lancehead').
ncbi_mult_taxo_gbnm(230552, nieva).
ncbi_mult_taxo_gbnm(230572, 'heath spotted orchid').
ncbi_mult_taxo_gbnm(230653, 'Mentawai macaque').
ncbi_mult_taxo_gbnm(230655, 'canary chat').
ncbi_mult_taxo_gbnm(230656, 'common stonechat').
ncbi_mult_taxo_gbnm(230657, 'Siberian stonechat').
ncbi_mult_taxo_gbnm(230659, 'European stonechat').
ncbi_mult_taxo_gbnm(230833, 'Bolivian titi').
ncbi_mult_taxo_gbnm(230843, 'Bojer\'s skink').
ncbi_mult_taxo_gbnm(230844, 'prairie deer mouse').
ncbi_mult_taxo_gbnm(230980, 'little coastal moa').
ncbi_mult_taxo_gbnm(231021, 'emerald glass frog').
ncbi_mult_taxo_gbnm(231027, 'Jandaya parakeet').
ncbi_mult_taxo_gbnm(231030, 'male bamboo').
ncbi_mult_taxo_gbnm(231223, 'lettuce slug').
ncbi_mult_taxo_gbnm(231224, 'southern chorus frog').
ncbi_mult_taxo_gbnm(231225, 'Strecker\'s chorus frog').
ncbi_mult_taxo_gbnm(231230, 'Fort Randolph robber frog').
ncbi_mult_taxo_gbnm(231231, 'Xucaneb robber frog').
ncbi_mult_taxo_gbnm(231263, 'Madagascar hissing cockroach').
ncbi_mult_taxo_gbnm(231456, 'blue-axil chromis').
ncbi_mult_taxo_gbnm(231457, blacksmith).
ncbi_mult_taxo_gbnm(231458, 'yellow-axil chromis').
ncbi_mult_taxo_gbnm(231559, 'Lucy\'s warbler').
ncbi_mult_taxo_gbnm(231560, 'Colima warbler').
ncbi_mult_taxo_gbnm(231561, 'Golden-winged warbler').
ncbi_mult_taxo_gbnm(231563, 'white-fronted redstart').
ncbi_mult_taxo_gbnm(231565, 'vitelline warbler').
ncbi_mult_taxo_gbnm(231566, 'black-throated blue warbler').
ncbi_mult_taxo_gbnm(231567, 'palm warbler').
ncbi_mult_taxo_gbnm(231568, 'bay-breasted warbler').
ncbi_mult_taxo_gbnm(231569, 'black-polled yellow-throat').
ncbi_mult_taxo_gbnm(231570, 'Connecticut warbler').
ncbi_mult_taxo_gbnm(231571, 'Lousiana waterthrush').
ncbi_mult_taxo_gbnm(231573, 'white-faced redstart').
ncbi_mult_taxo_gbnm(231578, 'Hispaniolan blue-tailed ameiva').
ncbi_mult_taxo_gbnm(231579, 'Pigmy blue-tailed ameiva').
ncbi_mult_taxo_gbnm(231663, 'sweet autumn clematis').
ncbi_mult_taxo_gbnm(231664, 'scarlet leather flower').
ncbi_mult_taxo_gbnm(231675, 'three-lined catfish').
ncbi_mult_taxo_gbnm(231996, solenogasters).
ncbi_mult_taxo_gbnm(232192, 'emperor red snapper').
ncbi_mult_taxo_gbnm(232193, 'Russell\'s snapper').
ncbi_mult_taxo_gbnm(232276, 'torpedo scad').
ncbi_mult_taxo_gbnm(232281, 'beautiful pitviper').
ncbi_mult_taxo_gbnm(232296, 'striped day gecko').
ncbi_mult_taxo_gbnm(232308, 'ornate day gecko').
ncbi_mult_taxo_gbnm(232317, 'Namaqua day gecko').
ncbi_mult_taxo_gbnm(232343, 'Rapa shearwater').
ncbi_mult_taxo_gbnm(232371, 'tropical shearwater').
ncbi_mult_taxo_gbnm(232374, 'Newell\'s shearwater').
ncbi_mult_taxo_gbnm(232417, 'convict grouper').
ncbi_mult_taxo_gbnm(232419, 'blotchy swell shark').
ncbi_mult_taxo_gbnm(232620, 'slaty-headed parakeet').
ncbi_mult_taxo_gbnm(232633, 'long-tailed parakeet').
ncbi_mult_taxo_gbnm(232635, 'red-breasted parakeet').
ncbi_mult_taxo_gbnm(232641, 'Blossom-headed parakeet').
ncbi_mult_taxo_gbnm(232642, 'Malabar parakeet').
ncbi_mult_taxo_gbnm(232645, 'Plum-headed parakeet').
ncbi_mult_taxo_gbnm(232653, 'Mauritius parakeet').
ncbi_mult_taxo_gbnm(232655, 'Alexandrine parakeet').
ncbi_mult_taxo_gbnm(232803, 'yellow-faced bees').
ncbi_mult_taxo_gbnm(232804, 'yellow-faced bees').
ncbi_mult_taxo_gbnm(232977, 'bluefin killifish').
ncbi_mult_taxo_gbnm(232989, 'lantern minnow').
ncbi_mult_taxo_gbnm(232990, 'chubsucker minnow').
ncbi_mult_taxo_gbnm(232992, 'eastern silvery minnow').
ncbi_mult_taxo_gbnm(232994, 'redeye chub').
ncbi_mult_taxo_gbnm(232995, 'Tennessee shiner').
ncbi_mult_taxo_gbnm(232996, 'taillight shiner').
ncbi_mult_taxo_gbnm(232998, 'Colorado pikeminnow').
ncbi_mult_taxo_gbnm(233182, 'great jerboa').
ncbi_mult_taxo_gbnm(233254, 'Cape Verde buzzard').
ncbi_mult_taxo_gbnm(233488, 'Hawaiian happy face spider').
ncbi_mult_taxo_gbnm(233684, 'Indian-buttertree').
ncbi_mult_taxo_gbnm(233737, canistel).
ncbi_mult_taxo_gbnm(233744, 'mamey sapote').
ncbi_mult_taxo_gbnm(233765, 'Cape hairy bat').
ncbi_mult_taxo_gbnm(233766, 'fish-eating bat').
ncbi_mult_taxo_gbnm(233775, 'Kakhien Hills spadefoot toad').
ncbi_mult_taxo_gbnm(233776, 'eastern spadefoot toad').
ncbi_mult_taxo_gbnm(233777, 'Moroccan spadefoot toad').
ncbi_mult_taxo_gbnm(233778, 'Hurter\'s solitary spadefoot').
ncbi_mult_taxo_gbnm(233779, 'plains spadefoot toad').
ncbi_mult_taxo_gbnm(233780, 'Great Basin spadefoot toad').
ncbi_mult_taxo_gbnm(233781, 'Iberian parsley frog').
ncbi_mult_taxo_gbnm(233782, 'Rocky Mountain tailed frog').
ncbi_mult_taxo_gbnm(233785, 'apo sunbird').
ncbi_mult_taxo_gbnm(233786, 'scarlet-tufted sunbird').
ncbi_mult_taxo_gbnm(233787, 'plain-throated sunbird').
ncbi_mult_taxo_gbnm(233788, 'Kenya violet-backed sunbird').
ncbi_mult_taxo_gbnm(233794, 'olive-backed sunbird').
ncbi_mult_taxo_gbnm(233798, 'bronze sunbird').
ncbi_mult_taxo_gbnm(233842, 'large red-belted clearwing').
ncbi_mult_taxo_gbnm(233843, 'white-barred clearwing').
ncbi_mult_taxo_gbnm(234070, 'Black file snake').
ncbi_mult_taxo_gbnm(234071, 'black house snake').
ncbi_mult_taxo_gbnm(234095, 'Madagascar sunbird').
ncbi_mult_taxo_gbnm(234623, 'Steller\'s eider').
ncbi_mult_taxo_gbnm(234626, 'Mongolian five-toed jerboa').
ncbi_mult_taxo_gbnm(234629, 'Brant\'s climbing mouse').
ncbi_mult_taxo_gbnm(234634, 'Perny\'s long-nosed squirrel').
ncbi_mult_taxo_gbnm(234638, 'Carruther\'s mountain squirrel').
ncbi_mult_taxo_gbnm(234639, 'Zanj sun squirrel').
ncbi_mult_taxo_gbnm(234670, 'ochre bush squirrel').
ncbi_mult_taxo_gbnm(234679, 'Svynnerton\'s bush squirrel').
ncbi_mult_taxo_gbnm(234689, 'Philippine tree squirrel').
ncbi_mult_taxo_gbnm(234690, 'South African ground squirrel').
ncbi_mult_taxo_gbnm(234792, 'Chinese lizard gudgeon').
ncbi_mult_taxo_gbnm(234793, 'Lake Ohrid brown trout').
ncbi_mult_taxo_gbnm(234859, 'western yampah').
ncbi_mult_taxo_gbnm(234933, 'gray shrews').
ncbi_mult_taxo_gbnm(235072, 'flathead flounder').
ncbi_mult_taxo_gbnm(235141, 'flathead trout').
ncbi_mult_taxo_gbnm(235200, 'Angolan genet').
ncbi_mult_taxo_gbnm(235202, 'giant genet').
ncbi_mult_taxo_gbnm(235204, 'West African genet').
ncbi_mult_taxo_gbnm(235211, 'largehead hairtail').
ncbi_mult_taxo_gbnm(235293, 'Dominican giant anole').
ncbi_mult_taxo_gbnm(235299, 'Northern Hispaniolan green anole').
ncbi_mult_taxo_gbnm(235321, 'Peninsula anole').
ncbi_mult_taxo_gbnm(235326, 'pale-rumped warbler').
ncbi_mult_taxo_gbnm(235354, 'Compton tortoiseshell').
ncbi_mult_taxo_gbnm(235387, 'honey blue-eye').
ncbi_mult_taxo_gbnm(235388, 'delicate blue-eye').
ncbi_mult_taxo_gbnm(235389, 'spotted blue-eye').
ncbi_mult_taxo_gbnm(235402, 'mountain grass lizard').
ncbi_mult_taxo_gbnm(235420, 'Stolzmann\'s pacific iguana').
ncbi_mult_taxo_gbnm(235497, pauraque).
ncbi_mult_taxo_gbnm(235532, 'western North American destroying angel').
ncbi_mult_taxo_gbnm(235600, 'tropical African latrine blowfly').
ncbi_mult_taxo_gbnm(235649, 'hispid hare').
ncbi_mult_taxo_gbnm(235651, 'Annamite striped rabbit').
ncbi_mult_taxo_gbnm(235996, 'Arabian burnet moth').
ncbi_mult_taxo_gbnm(236053, 'olive thrush').
ncbi_mult_taxo_gbnm(236055, 'Northern olive thrush').
ncbi_mult_taxo_gbnm(236056, 'karoo thrush').
ncbi_mult_taxo_gbnm(236272, 'Simmons\' mouse lemur').
ncbi_mult_taxo_gbnm(236275, 'Jolly\'s mouse lemur').
ncbi_mult_taxo_gbnm(236322, 'flat bugs').
ncbi_mult_taxo_gbnm(236323, 'termite bugs').
ncbi_mult_taxo_gbnm(236375, 'burrower bugs').
ncbi_mult_taxo_gbnm(236388, 'stilt bugs').
ncbi_mult_taxo_gbnm(236403, 'water scorpions').
ncbi_mult_taxo_gbnm(236404, 'velvety shore bugs').
ncbi_mult_taxo_gbnm(236406, 'water creepers').
ncbi_mult_taxo_gbnm(236409, 'pygmy backswimmers').
ncbi_mult_taxo_gbnm(236421, 'squash bug').
ncbi_mult_taxo_gbnm(236428, 'spiny shorebugs').
ncbi_mult_taxo_gbnm(236479, 'Bedriaga\'s rock lizard').
ncbi_mult_taxo_gbnm(236481, 'Northern viscacha').
ncbi_mult_taxo_gbnm(236520, 'glossy ibis head louse').
ncbi_mult_taxo_gbnm(236590, 'smoky madtom').
ncbi_mult_taxo_gbnm(236591, 'elegant madtom').
ncbi_mult_taxo_gbnm(236593, 'mountain madtom').
ncbi_mult_taxo_gbnm(236594, 'checkered madtom').
ncbi_mult_taxo_gbnm(236595, 'Carolina madtom').
ncbi_mult_taxo_gbnm(236596, 'brindled madtom').
ncbi_mult_taxo_gbnm(236597, 'frecklebelly madtom').
ncbi_mult_taxo_gbnm(236598, 'northern madtom').
ncbi_mult_taxo_gbnm(236681, 'swallow bug').
ncbi_mult_taxo_gbnm(236728, 'rice earhead bug').
ncbi_mult_taxo_gbnm(236742, 'Yemeni spiny-tailed lizard').
ncbi_mult_taxo_gbnm(236747, 'Vaillants strange agama').
ncbi_mult_taxo_gbnm(236776, 'African sugarcane borer').
ncbi_mult_taxo_gbnm(236793, 'spotted sugarcane borer').
ncbi_mult_taxo_gbnm(236795, 'plassey borer').
ncbi_mult_taxo_gbnm(236805, 'Mediterranean corn borer').
ncbi_mult_taxo_gbnm(236831, 'unique-headed bug').
ncbi_mult_taxo_gbnm(236875, 'Pandelleana protuberans').
ncbi_mult_taxo_gbnm(237097, 'cotton plant bug').
ncbi_mult_taxo_gbnm(237172, 'ambush bugs').
ncbi_mult_taxo_gbnm(237411, 'Adriatic trout').
ncbi_mult_taxo_gbnm(237415, 'little spiderhunter').
ncbi_mult_taxo_gbnm(237439, 'northern rough-winged swallow').
ncbi_mult_taxo_gbnm(237440, 'Lemon-bellied crombec').
ncbi_mult_taxo_gbnm(237562, 'barred serrano').
ncbi_mult_taxo_gbnm(237563, 'chalk bass').
ncbi_mult_taxo_gbnm(237566, 'mottled soapfish').
ncbi_mult_taxo_gbnm(237618, tattler).
ncbi_mult_taxo_gbnm(237658, 'North African sengi').
ncbi_mult_taxo_gbnm(237897, 'orange birdsfoot').
ncbi_mult_taxo_gbnm(237934, squashberry).
ncbi_mult_taxo_gbnm(237945, 'wayfaring-tree').
ncbi_mult_taxo_gbnm(237956, 'rusty blackhaw').
ncbi_mult_taxo_gbnm(237965, 'slender bush moa').
ncbi_mult_taxo_gbnm(237971, 'Marquesan monarch').
ncbi_mult_taxo_gbnm(237972, 'Rarotonga monarch').
ncbi_mult_taxo_gbnm(237977, 'Fatuhiva monarch').
ncbi_mult_taxo_gbnm(237978, 'Tahiti monarch').
ncbi_mult_taxo_gbnm(237995, 'Isarog shrew-mouse').
ncbi_mult_taxo_gbnm(237998, 'Isarog striped shrew-rat').
ncbi_mult_taxo_gbnm(238000, 'Isarog shrew-rat').
ncbi_mult_taxo_gbnm(238003, 'large Mindoro forest mouse').
ncbi_mult_taxo_gbnm(238004, 'Mindanao mossy forest mouse').
ncbi_mult_taxo_gbnm(238005, 'Mindanao montane forest mouse').
ncbi_mult_taxo_gbnm(238006, 'Small Luzon forest mouse').
ncbi_mult_taxo_gbnm(238007, 'Least Philippine forest mouse').
ncbi_mult_taxo_gbnm(238031, 'yellowcheek carp').
ncbi_mult_taxo_gbnm(238049, 'scalpel sawtail').
ncbi_mult_taxo_gbnm(238050, 'ringtail surgeonfish').
ncbi_mult_taxo_gbnm(238051, 'eyestripe surgeonfish').
ncbi_mult_taxo_gbnm(238052, 'bluelined surgeon').
ncbi_mult_taxo_gbnm(238053, 'orangespot surgeonfish').
ncbi_mult_taxo_gbnm(238054, 'whitemargin unicornfish').
ncbi_mult_taxo_gbnm(238055, 'spotted unicornfish').
ncbi_mult_taxo_gbnm(238057, 'gray unicornfish').
ncbi_mult_taxo_gbnm(238058, 'elegant unicornfish').
ncbi_mult_taxo_gbnm(238059, 'horseface unicornfish').
ncbi_mult_taxo_gbnm(238060, 'elongate unicornfish').
ncbi_mult_taxo_gbnm(238062, 'squarenose unicornfish').
ncbi_mult_taxo_gbnm(238063, 'slender unicorn').
ncbi_mult_taxo_gbnm(238065, 'oneknife unicornfish').
ncbi_mult_taxo_gbnm(238066, 'bulbnose unicornfish').
ncbi_mult_taxo_gbnm(238067, 'bignose unicornfish').
ncbi_mult_taxo_gbnm(238107, 'Degranville\'s rocket frog').
ncbi_mult_taxo_gbnm(238108, 'palm rocket frog').
ncbi_mult_taxo_gbnm(238110, 'Stephen\'s rocket frog').
ncbi_mult_taxo_gbnm(238111, 'Bogota rocket frog').
ncbi_mult_taxo_gbnm(238112, 'sanguine poison frog').
ncbi_mult_taxo_gbnm(238116, 'splash-backed poison frog').
ncbi_mult_taxo_gbnm(238117, 'demonic poison frog').
ncbi_mult_taxo_gbnm(238119, 'rufous frog').
ncbi_mult_taxo_gbnm(238136, 'Sucre water frog').
ncbi_mult_taxo_gbnm(238220, 'katria cichlid').
ncbi_mult_taxo_gbnm(238227, 'pin stripe damba').
ncbi_mult_taxo_gbnm(238233, 'banded cichlid').
ncbi_mult_taxo_gbnm(238284, 'birdcage evening primrose').
ncbi_mult_taxo_gbnm(238553, 'highwaterman catfish').
ncbi_mult_taxo_gbnm(238572, 'masson pine moth').
ncbi_mult_taxo_gbnm(238584, 'ripsaw catfish').
ncbi_mult_taxo_gbnm(238645, 'chocolate talking catfish').
ncbi_mult_taxo_gbnm(238692, 'Madagascar rainbowfish').
ncbi_mult_taxo_gbnm(238695, 'Asiatic migratory locust').
ncbi_mult_taxo_gbnm(238696, 'Tibetan migratory locust').
ncbi_mult_taxo_gbnm(238708, 'flower of the wave').
ncbi_mult_taxo_gbnm(238709, 'Mediterranean sand smelt').
ncbi_mult_taxo_gbnm(238728, 'hazelnut beetle').
ncbi_mult_taxo_gbnm(238736, 'dwarf rainbowfish').
ncbi_mult_taxo_gbnm(238738, 'Cairns rainbowfish').
ncbi_mult_taxo_gbnm(238741, 'topsmelt silverside').
ncbi_mult_taxo_gbnm(238744, 'Atlantic silverside').
ncbi_mult_taxo_gbnm(238835, 'Chinese giant flying squirrel').
ncbi_mult_taxo_gbnm(238840, 'blackfin flounder').
ncbi_mult_taxo_gbnm(238855, 'Chinese hwamei').
ncbi_mult_taxo_gbnm(238859, 'rusty laughingthrush').
ncbi_mult_taxo_gbnm(238860, 'streamside salamander').
ncbi_mult_taxo_gbnm(238866, 'speckled earless lizard').
ncbi_mult_taxo_gbnm(238880, 'Dumeril\'s striped frog').
ncbi_mult_taxo_gbnm(238885, 'gray-striped frog').
ncbi_mult_taxo_gbnm(238984, 'rufous flycatcher').
ncbi_mult_taxo_gbnm(238985, 'Yucatan flycatcher').
ncbi_mult_taxo_gbnm(238986, 'Venezuelan flycatcher').
ncbi_mult_taxo_gbnm(238987, 'great crested flycatcher').
ncbi_mult_taxo_gbnm(238988, 'stolid flycatcher').
ncbi_mult_taxo_gbnm(238989, 'La Sagra\'s flycatcher').
ncbi_mult_taxo_gbnm(238990, 'rufous-tailed flycatcher').
ncbi_mult_taxo_gbnm(239038, 'rock wrasse').
ncbi_mult_taxo_gbnm(239039, 'blunt-headed wrasse').
ncbi_mult_taxo_gbnm(239087, 'thickhead chub').
ncbi_mult_taxo_gbnm(239095, 'garden pea leafminer').
ncbi_mult_taxo_gbnm(239232, 'hairy-winged barklice').
ncbi_mult_taxo_gbnm(239234, 'stout barklice').
ncbi_mult_taxo_gbnm(239368, 'northern anchovy').
ncbi_mult_taxo_gbnm(239371, 'broad-billed sapayoa').
ncbi_mult_taxo_gbnm(239374, 'black-and-red broadbill').
ncbi_mult_taxo_gbnm(239378, 'black-and-yellow broadbill').
ncbi_mult_taxo_gbnm(239386, 'silver-breasted broadbill').
ncbi_mult_taxo_gbnm(239401, 'southern harebell').
ncbi_mult_taxo_gbnm(239416, 'peach-leaved bellflower').
ncbi_mult_taxo_gbnm(239422, 'common harebell').
ncbi_mult_taxo_gbnm(239728, 'Malayan black rat').
ncbi_mult_taxo_gbnm(239743, 'Steller\'s sculpin').
ncbi_mult_taxo_gbnm(239746, 'Northern death adder').
ncbi_mult_taxo_gbnm(239969, 'crested moa').
ncbi_mult_taxo_gbnm(239970, 'Mappin\'s moa').
ncbi_mult_taxo_gbnm(240000, 'ampelopsis fruit midge').
ncbi_mult_taxo_gbnm(240004, 'Thompson\'s pygmy shrew').
ncbi_mult_taxo_gbnm(240028, 'Mediterranean saltbush').
ncbi_mult_taxo_gbnm(240152, 'tube-snout').
ncbi_mult_taxo_gbnm(240154, 'fourspine stickleback').
ncbi_mult_taxo_gbnm(240156, 'brook stickleback').
ncbi_mult_taxo_gbnm(240159, 'big head croaker').
ncbi_mult_taxo_gbnm(240160, 'bighead croaker').
ncbi_mult_taxo_gbnm(240162, 'Mi-iuy croaker').
ncbi_mult_taxo_gbnm(240163, 'white flower croaker').
ncbi_mult_taxo_gbnm(240165, 'Belanger\'s croaker').
ncbi_mult_taxo_gbnm(240171, 'Guerreran peeping frog').
ncbi_mult_taxo_gbnm(240172, 'Almirante robber frog').
ncbi_mult_taxo_gbnm(240173, 'Guerreran robber frog').
ncbi_mult_taxo_gbnm(240202, 'pectoral sandpiper').
ncbi_mult_taxo_gbnm(240204, 'red-necked phalarope').
ncbi_mult_taxo_gbnm(240205, 'American golden-plover').
ncbi_mult_taxo_gbnm(240206, 'yellow-throated sandgrouse').
ncbi_mult_taxo_gbnm(240209, 'double-banded courser').
ncbi_mult_taxo_gbnm(240219, 'Allen\'s woodrat').
ncbi_mult_taxo_gbnm(240288, 'felt scales').
ncbi_mult_taxo_gbnm(240363, 'Gumprechts green pitviper').
ncbi_mult_taxo_gbnm(240394, 'Kisenyi forest treefrog').
ncbi_mult_taxo_gbnm(240395, 'Northeast China rough-skinned frog').
ncbi_mult_taxo_gbnm(240399, 'Kiau Borneo frog').
ncbi_mult_taxo_gbnm(240404, 'yellow-spotted frog').
ncbi_mult_taxo_gbnm(240406, 'Sabah splash frog').
ncbi_mult_taxo_gbnm(240448, 'palisade grass').
ncbi_mult_taxo_gbnm(240496, 'Japanese acorn barnacle').
ncbi_mult_taxo_gbnm(240584, 'Dolorous grass mouse').
ncbi_mult_taxo_gbnm(240585, 'Temchuk\'s bolo mouse').
ncbi_mult_taxo_gbnm(240587, 'Cerrado mouse').
ncbi_mult_taxo_gbnm(240588, 'intelligent grass mouse').
ncbi_mult_taxo_gbnm(240591, 'Blackburnian warbler').
ncbi_mult_taxo_gbnm(240657, 'Dhiho\'s seahorse').
ncbi_mult_taxo_gbnm(240658, 'sea pony').
ncbi_mult_taxo_gbnm(240659, 'narrow-bellied seahorse').
ncbi_mult_taxo_gbnm(240696, 'Fisher\'s seahorse').
ncbi_mult_taxo_gbnm(240697, 'longsnout pipefish').
ncbi_mult_taxo_gbnm(240700, 'green-throated mountain-gem').
ncbi_mult_taxo_gbnm(240701, 'plain-capped startthroat').
ncbi_mult_taxo_gbnm(240704, 'broad-tailed hummingbird').
ncbi_mult_taxo_gbnm(240707, 'beautiful hummingbird').
ncbi_mult_taxo_gbnm(240712, 'brown barbet').
ncbi_mult_taxo_gbnm(240714, 'black-browed barbet').
ncbi_mult_taxo_gbnm(240719, 'naked-faced barbet').
ncbi_mult_taxo_gbnm(240720, 'white-eared barbet').
ncbi_mult_taxo_gbnm(240721, 'Whyte\'s barbet').
ncbi_mult_taxo_gbnm(240722, 'Yellow-fronted tinkerbird').
ncbi_mult_taxo_gbnm(240723, 'Speckled tinkerbird').
ncbi_mult_taxo_gbnm(240724, 'Red-rumped tinkerbird').
ncbi_mult_taxo_gbnm(240727, 'Red-fronted barbet').
ncbi_mult_taxo_gbnm(240728, 'hairy-breasted barbet').
ncbi_mult_taxo_gbnm(240729, 'pied barbet').
ncbi_mult_taxo_gbnm(240730, 'spot-flanked barbet').
ncbi_mult_taxo_gbnm(240733, 'yellow-spotted barbet').
ncbi_mult_taxo_gbnm(240734, 'Bearded barbet').
ncbi_mult_taxo_gbnm(240735, 'Brown-breasted barbet').
ncbi_mult_taxo_gbnm(240736, 'Vieillot\'s barbet').
ncbi_mult_taxo_gbnm(240737, 'Black-collared barbet').
ncbi_mult_taxo_gbnm(240738, 'yellow-billed barbet').
ncbi_mult_taxo_gbnm(240740, 'red-and-yellow barbet').
ncbi_mult_taxo_gbnm(240741, 'Ariel toucan').
ncbi_mult_taxo_gbnm(240742, 'hooded mountain-toucan').
ncbi_mult_taxo_gbnm(240743, 'golden-collared toucanet').
ncbi_mult_taxo_gbnm(240832, eulachon).
ncbi_mult_taxo_gbnm(240837, 'ghost shiner').
ncbi_mult_taxo_gbnm(240838, 'pygmy seahorse').
ncbi_mult_taxo_gbnm(241069, 'Scotch spearmint').
ncbi_mult_taxo_gbnm(241101, 'Chaco crimson-nosed rat').
ncbi_mult_taxo_gbnm(241102, 'large-lipped crimson-nosed rat').
ncbi_mult_taxo_gbnm(241142, 'Jelski\'s South American field mouse').
ncbi_mult_taxo_gbnm(241144, 'Patagonian chinchilla mouse').
ncbi_mult_taxo_gbnm(241146, 'water rat').
ncbi_mult_taxo_gbnm(241152, 'Magellanic pygmy rice rat').
ncbi_mult_taxo_gbnm(241154, 'European prickly cockle').
ncbi_mult_taxo_gbnm(241259, 'lagoon damsel').
ncbi_mult_taxo_gbnm(241263, 'bluespotted wrasse').
ncbi_mult_taxo_gbnm(241264, 'New Guinea wrasse').
ncbi_mult_taxo_gbnm(241268, 'splitlevel hogfish').
ncbi_mult_taxo_gbnm(241269, 'Spanish hogfish').
ncbi_mult_taxo_gbnm(241270, 'snooty wrasse').
ncbi_mult_taxo_gbnm(241271, 'humphead wrasse').
ncbi_mult_taxo_gbnm(241274, 'orange-dotted tuskfish').
ncbi_mult_taxo_gbnm(241275, 'blackspot tuskfish').
ncbi_mult_taxo_gbnm(241277, 'Lubbock\'s wrasse').
ncbi_mult_taxo_gbnm(241280, 'clown coris').
ncbi_mult_taxo_gbnm(241281, 'yellowtail coris').
ncbi_mult_taxo_gbnm(241282, 'Batu coris').
ncbi_mult_taxo_gbnm(241289, 'slingjaw wrasse').
ncbi_mult_taxo_gbnm(241290, 'argus wrasse').
ncbi_mult_taxo_gbnm(241291, 'slippery dick').
ncbi_mult_taxo_gbnm(241292, 'Hartzfeld\'s wrasse').
ncbi_mult_taxo_gbnm(241293, 'checkerboard wrasse').
ncbi_mult_taxo_gbnm(241294, 'pink-belly wrasse').
ncbi_mult_taxo_gbnm(241295, 'dusky wrasse').
ncbi_mult_taxo_gbnm(241296, 'circle-cheek wrasse').
ncbi_mult_taxo_gbnm(241297, 'spinster wrasse').
ncbi_mult_taxo_gbnm(241298, 'banded wrasse').
ncbi_mult_taxo_gbnm(241299, 'puddingwife wrasse').
ncbi_mult_taxo_gbnm(241300, 'zigzag wrasse').
ncbi_mult_taxo_gbnm(241301, 'seagrass wrasse').
ncbi_mult_taxo_gbnm(241308, 'bicolor cleaner wrasse').
ncbi_mult_taxo_gbnm(241309, 'bluestreak cleaner wrasse').
ncbi_mult_taxo_gbnm(241310, 'redlip cleaner wrasse').
ncbi_mult_taxo_gbnm(241312, 'southern tubelip').
ncbi_mult_taxo_gbnm(241318, 'Geoffroy\'s wrasse').
ncbi_mult_taxo_gbnm(241319, 'blackspotted wrasse').
ncbi_mult_taxo_gbnm(241325, 'Maori wrasse').
ncbi_mult_taxo_gbnm(241327, 'two-spot wrasse').
ncbi_mult_taxo_gbnm(241328, 'Celebes wrasse').
ncbi_mult_taxo_gbnm(241329, 'ringtail Maori wrasse').
ncbi_mult_taxo_gbnm(241335, 'eight-lined wrasse').
ncbi_mult_taxo_gbnm(241337, 'redspot wrasse').
ncbi_mult_taxo_gbnm(241339, 'Polynesian wrasse').
ncbi_mult_taxo_gbnm(241340, 'smalltail pencil wrasse').
ncbi_mult_taxo_gbnm(241344, 'yellowbarred parrotfish').
ncbi_mult_taxo_gbnm(241348, 'red shoulder wrasse').
ncbi_mult_taxo_gbnm(241349, 'three-lined rainbowfish').
ncbi_mult_taxo_gbnm(241354, 'yellowblotch razorfish').
ncbi_mult_taxo_gbnm(241357, 'blue weed whiting').
ncbi_mult_taxo_gbnm(241362, 'bluefinned butterfish').
ncbi_mult_taxo_gbnm(241364, greenbone).
ncbi_mult_taxo_gbnm(241367, tubemouth).
ncbi_mult_taxo_gbnm(241399, 'Hoge\'s toadhead turtle').
ncbi_mult_taxo_gbnm(241403, 'black spine-necked swamp turtle').
ncbi_mult_taxo_gbnm(241410, 'Arizona tiger salamander').
ncbi_mult_taxo_gbnm(241437, 'McCord\'s box turtle').
ncbi_mult_taxo_gbnm(241440, 'Vietnamese box turtle').
ncbi_mult_taxo_gbnm(241441, 'Bourret\'s box turtle').
ncbi_mult_taxo_gbnm(241472, 'Taiwan sucker').
ncbi_mult_taxo_gbnm(241494, 'least cisco').
ncbi_mult_taxo_gbnm(241498, 'green wrasse').
ncbi_mult_taxo_gbnm(241504, 'necklace fern').
ncbi_mult_taxo_gbnm(241505, 'drooping spleenwort').
ncbi_mult_taxo_gbnm(241512, 'sickle spleenwort').
ncbi_mult_taxo_gbnm(241527, 'grey-barred wren').
ncbi_mult_taxo_gbnm(241529, 'canyon wren').
ncbi_mult_taxo_gbnm(241533, 'Peruvian wren').
ncbi_mult_taxo_gbnm(241536, 'Bewick\'s wren').
ncbi_mult_taxo_gbnm(241539, 'buff-breasted wren').
ncbi_mult_taxo_gbnm(241540, 'spot-breasted wren').
ncbi_mult_taxo_gbnm(241542, 'slender-billed wren').
ncbi_mult_taxo_gbnm(241545, 'southern nightingale-wren').
ncbi_mult_taxo_gbnm(241547, 'tooth-billed wren').
ncbi_mult_taxo_gbnm(241549, 'rock wren').
ncbi_mult_taxo_gbnm(241551, 'musician wren').
ncbi_mult_taxo_gbnm(241562, 'cuban parrot').
ncbi_mult_taxo_gbnm(241563, 'red-necked parrot').
ncbi_mult_taxo_gbnm(241569, 'white-fronted parrot').
ncbi_mult_taxo_gbnm(241570, 'blue-cheeked parrot').
ncbi_mult_taxo_gbnm(241577, 'imperial parrot').
ncbi_mult_taxo_gbnm(241578, 'lilac-crowned parrot').
ncbi_mult_taxo_gbnm(241584, 'St. Lucia parrot').
ncbi_mult_taxo_gbnm(241585, 'Puerto Rican parrot').
ncbi_mult_taxo_gbnm(241586, 'black-billed parrot').
ncbi_mult_taxo_gbnm(241587, 'yellow-billed parrot').
ncbi_mult_taxo_gbnm(241588, 'red-fronted parrot').
ncbi_mult_taxo_gbnm(241699, 'bridled burrfish').
ncbi_mult_taxo_gbnm(241745, 'finch-billed myna').
ncbi_mult_taxo_gbnm(241747, 'collared finchbill').
ncbi_mult_taxo_gbnm(241750, 'orange-billed sparrow').
ncbi_mult_taxo_gbnm(241757, 'mejiro-hozuki').
ncbi_mult_taxo_gbnm(241763, 'white-headed buffalo-weaver').
ncbi_mult_taxo_gbnm(241766, 'black-capped bulbul').
ncbi_mult_taxo_gbnm(241771, 'Baglafecht weaver').
ncbi_mult_taxo_gbnm(241774, 'Iris glossy-starling').
ncbi_mult_taxo_gbnm(241776, 'wattled starling').
ncbi_mult_taxo_gbnm(241820, 'striated frogfish').
ncbi_mult_taxo_gbnm(241821, 'Mediterranean seahorse').
ncbi_mult_taxo_gbnm(241822, 'parrot grunt').
ncbi_mult_taxo_gbnm(241823, 'gelatinous snailfish').
ncbi_mult_taxo_gbnm(241824, 'bluecheek butterflyfish').
ncbi_mult_taxo_gbnm(241828, 'spottail spiny turbot').
ncbi_mult_taxo_gbnm(241831, 'channel flounder').
ncbi_mult_taxo_gbnm(241836, 'roughnose grenadier').
ncbi_mult_taxo_gbnm(241857, 'upas tree').
ncbi_mult_taxo_gbnm(241868, 'Guiana brosimum').
ncbi_mult_taxo_gbnm(241870, 'bloodwood cacique').
ncbi_mult_taxo_gbnm(242051, 'Schultze\'s pit viper').
ncbi_mult_taxo_gbnm(242052, 'green bamboo leaf pit viper').
ncbi_mult_taxo_gbnm(242053, 'Anderson\'s pitviper').
ncbi_mult_taxo_gbnm(242054, mamushi).
ncbi_mult_taxo_gbnm(242120, 'red-capped robin').
ncbi_mult_taxo_gbnm(242256, 'de Prunner\'s ringlet').
ncbi_mult_taxo_gbnm(242257, 'mountain ringlet').
ncbi_mult_taxo_gbnm(242258, 'dewy ringlet').
ncbi_mult_taxo_gbnm(242259, 'bright-eyed ringlet').
ncbi_mult_taxo_gbnm(242260, 'silky ringlet').
ncbi_mult_taxo_gbnm(242287, 'Mexican lampfish').
ncbi_mult_taxo_gbnm(242384, 'little free-tailed bat').
ncbi_mult_taxo_gbnm(242522, 'Tibetan eared-pheasant').
ncbi_mult_taxo_gbnm(242525, 'Himalayan wolf').
ncbi_mult_taxo_gbnm(242534, 'clustered dock').
ncbi_mult_taxo_gbnm(242562, 'boreal chorus frog').
ncbi_mult_taxo_gbnm(242564, 'southeastern chorus frog').
ncbi_mult_taxo_gbnm(242566, 'spotted chorus frog').
ncbi_mult_taxo_gbnm(242568, 'Brimley\'s chorus frog').
ncbi_mult_taxo_gbnm(242570, 'mountain chorus frog').
ncbi_mult_taxo_gbnm(242574, 'ornate chorus frog').
ncbi_mult_taxo_gbnm(242578, 'New Jersey chorus frog').
ncbi_mult_taxo_gbnm(242581, 'California treefrog').
ncbi_mult_taxo_gbnm(242584, 'Madrean treefrog').
ncbi_mult_taxo_gbnm(242587, 'pine barrens treefrog').
ncbi_mult_taxo_gbnm(242801, 'Japanese parrotfish').
ncbi_mult_taxo_gbnm(242802, 'Forsten\'s parrotfish').
ncbi_mult_taxo_gbnm(242806, 'blue-barred parrotfish').
ncbi_mult_taxo_gbnm(242807, 'dusky parrotfish').
ncbi_mult_taxo_gbnm(242808, 'dark capped parrotfish').
ncbi_mult_taxo_gbnm(242809, 'axilspot hogfish').
ncbi_mult_taxo_gbnm(242810, 'threadfin wrasse').
ncbi_mult_taxo_gbnm(242813, 'cutribbon wrasse').
ncbi_mult_taxo_gbnm(242819, 'yellow acara').
ncbi_mult_taxo_gbnm(242820, 'green terror').
ncbi_mult_taxo_gbnm(242822, 'banded acara').
ncbi_mult_taxo_gbnm(242929, 'Hawaiian flagtail').
ncbi_mult_taxo_gbnm(242961, 'prickly footballfish').
ncbi_mult_taxo_gbnm(242962, 'humpback anglerfish').
ncbi_mult_taxo_gbnm(242967, 'pink frogmouth').
ncbi_mult_taxo_gbnm(242969, 'Butler\'s frogfish').
ncbi_mult_taxo_gbnm(242972, 'four-armed frogfish').
ncbi_mult_taxo_gbnm(242976, 'Atlantic batfish').
ncbi_mult_taxo_gbnm(242981, sargassumfish).
ncbi_mult_taxo_gbnm(242984, 'twoline skiffia').
ncbi_mult_taxo_gbnm(243055, 'citreoline trogon').
ncbi_mult_taxo_gbnm(243059, 'rufous bristle-bird').
ncbi_mult_taxo_gbnm(243068, 'Brukkaros pygmy rock mouse').
ncbi_mult_taxo_gbnm(243113, 'Sitka valerian').
ncbi_mult_taxo_gbnm(243214, 'small-toothed harvest mouse').
ncbi_mult_taxo_gbnm(243215, 'slender harvest mouse').
ncbi_mult_taxo_gbnm(243218, 'variable indigobird').
ncbi_mult_taxo_gbnm(243220, 'dusky indigobird').
ncbi_mult_taxo_gbnm(243221, 'Jambandu indigobird').
ncbi_mult_taxo_gbnm(243222, 'pale-winged indigobird').
ncbi_mult_taxo_gbnm(243223, 'straw-tailed whydah').
ncbi_mult_taxo_gbnm(243224, 'queen whydah').
ncbi_mult_taxo_gbnm(243225, 'twinspot Indigobird').
ncbi_mult_taxo_gbnm(243226, 'Cameroon indigobird').
ncbi_mult_taxo_gbnm(243227, 'Jos plateau indigobird').
ncbi_mult_taxo_gbnm(243228, 'quailfinch indigobird').
ncbi_mult_taxo_gbnm(243229, 'Baka indigobird').
ncbi_mult_taxo_gbnm(243280, 'Sikkim cucumber').
ncbi_mult_taxo_gbnm(243501, 'running crab spiders').
ncbi_mult_taxo_gbnm(243556, 'McGregor\'s pitviper').
ncbi_mult_taxo_gbnm(243557, 'Malcom\'s pitviper').
ncbi_mult_taxo_gbnm(243558, 'Sumatra pit viper').
ncbi_mult_taxo_gbnm(243562, 'striped eel catfish').
ncbi_mult_taxo_gbnm(243708, 'kissing gourami').
ncbi_mult_taxo_gbnm(243720, 'red sea catfish').
ncbi_mult_taxo_gbnm(243721, 'Chilhuil sea catfish').
ncbi_mult_taxo_gbnm(243724, 'New Granada sea catfish').
ncbi_mult_taxo_gbnm(243726, 'Tete sea catfish').
ncbi_mult_taxo_gbnm(243731, 'southern sand octopus').
ncbi_mult_taxo_gbnm(243888, 'American herring gull').
ncbi_mult_taxo_gbnm(243926, 'gafftopsail sea catfish').
ncbi_mult_taxo_gbnm(244025, 'blue flax-lily').
ncbi_mult_taxo_gbnm(244027, 'large flowered barrenwort').
ncbi_mult_taxo_gbnm(244070, 'red-tailed parrot').
ncbi_mult_taxo_gbnm(244075, 'festive parrot').
ncbi_mult_taxo_gbnm(244077, 'Kawall\'s parrot').
ncbi_mult_taxo_gbnm(244081, 'red-spectacled parrot').
ncbi_mult_taxo_gbnm(244082, 'red-browed parrot').
ncbi_mult_taxo_gbnm(244083, 'Tucuman parrot').
ncbi_mult_taxo_gbnm(244084, 'vinaceous parrot').
ncbi_mult_taxo_gbnm(244087, 'short-tailed parrot').
ncbi_mult_taxo_gbnm(244131, 'Cauvery rasbora').
ncbi_mult_taxo_gbnm(244132, 'Wilpita rasbora').
ncbi_mult_taxo_gbnm(244133, 'slender rasbora').
ncbi_mult_taxo_gbnm(244134, 'pearly rasbora').
ncbi_mult_taxo_gbnm(244216, 'Amji salamander').
ncbi_mult_taxo_gbnm(244218, 'black-striped weasel').
ncbi_mult_taxo_gbnm(244255, 'Siberut macaque').
ncbi_mult_taxo_gbnm(244290, 'pearly underwing').
ncbi_mult_taxo_gbnm(244444, 'Christmas frigatebird').
ncbi_mult_taxo_gbnm(244445, 'Ascension frigatebird').
ncbi_mult_taxo_gbnm(244446, 'lesser frigatebird').
ncbi_mult_taxo_gbnm(244447, 'tongue sole').
ncbi_mult_taxo_gbnm(244449, sohachi).
ncbi_mult_taxo_gbnm(244450, 'shotted halibut').
ncbi_mult_taxo_gbnm(244452, 'littlemouth flounder').
ncbi_mult_taxo_gbnm(244454, 'zebra sole').
ncbi_mult_taxo_gbnm(244455, 'ridged-eye flounder').
ncbi_mult_taxo_gbnm(244518, 'threadfin cichlid').
ncbi_mult_taxo_gbnm(244585, 'island gray fox').
ncbi_mult_taxo_gbnm(244699, 'grey-breasted wood-wren').
ncbi_mult_taxo_gbnm(244700, 'wing-banded wren').
ncbi_mult_taxo_gbnm(244702, 'bar-winged wood-wren').
ncbi_mult_taxo_gbnm(244728, 'East African scorpion').
ncbi_mult_taxo_gbnm(244772, 'bridgelip sucker').
ncbi_mult_taxo_gbnm(244773, 'mountain sucker').
ncbi_mult_taxo_gbnm(244776, 'Warner sucker').
ncbi_mult_taxo_gbnm(244777, quillback).
ncbi_mult_taxo_gbnm(245038, 'jungle myna').
ncbi_mult_taxo_gbnm(245040, 'golden myna').
ncbi_mult_taxo_gbnm(245041, 'splendid glossy-starling').
ncbi_mult_taxo_gbnm(245044, 'golden-crested myna').
ncbi_mult_taxo_gbnm(245046, 'Asian glossy starling').
ncbi_mult_taxo_gbnm(245048, 'red-billed oxpecker').
ncbi_mult_taxo_gbnm(245049, 'brown dipper').
ncbi_mult_taxo_gbnm(245051, 'Sharpe\'s starling').
ncbi_mult_taxo_gbnm(245053, 'white-gorgeted flycatcher').
ncbi_mult_taxo_gbnm(245056, 'pale flycatcher').
ncbi_mult_taxo_gbnm(245060, 'desert wheatear').
ncbi_mult_taxo_gbnm(245067, coleto).
ncbi_mult_taxo_gbnm(245074, 'Pacific lamprey').
ncbi_mult_taxo_gbnm(245147, 'Tsinpa salamander').
ncbi_mult_taxo_gbnm(245546, 'Mongolian poplar').
ncbi_mult_taxo_gbnm(245564, 'mourning warbler').
ncbi_mult_taxo_gbnm(245590, 'yellow-browed tit').
ncbi_mult_taxo_gbnm(245595, 'Three-clawed worm-skink').
ncbi_mult_taxo_gbnm(245599, 'Voeltzkow\'s snake-eyed skink').
ncbi_mult_taxo_gbnm(245602, 'narrow-banded sand swimmer').
ncbi_mult_taxo_gbnm(245618, 'pink-tongued skink').
ncbi_mult_taxo_gbnm(245631, 'Rwanda five-toed skink').
ncbi_mult_taxo_gbnm(245643, 'Striped writhing skink').
ncbi_mult_taxo_gbnm(245646, 'Managua skink').
ncbi_mult_taxo_gbnm(245657, 'Travancore ground skink').
ncbi_mult_taxo_gbnm(245683, 'elegant scops-owl').
ncbi_mult_taxo_gbnm(245691, 'dusky squirrelfish').
ncbi_mult_taxo_gbnm(245694, 'armored searobin').
ncbi_mult_taxo_gbnm(245701, 'red spikefish').
ncbi_mult_taxo_gbnm(245703, 'blacktip tripodfish').
ncbi_mult_taxo_gbnm(245705, 'blackbar triggerfish').
ncbi_mult_taxo_gbnm(245707, 'broom filefish').
ncbi_mult_taxo_gbnm(245709, 'triangular boxfish').
ncbi_mult_taxo_gbnm(245710, 'marbled puffer').
ncbi_mult_taxo_gbnm(245759, 'sailfin corydoras').
ncbi_mult_taxo_gbnm(245761, 'banded corydoras').
ncbi_mult_taxo_gbnm(245764, 'emerald catfish').
ncbi_mult_taxo_gbnm(245766, 'false network catfish').
ncbi_mult_taxo_gbnm(245768, 'masked corydoras').
ncbi_mult_taxo_gbnm(245769, 'bronze corydoras').
ncbi_mult_taxo_gbnm(245771, 'blue corydoras').
ncbi_mult_taxo_gbnm(245775, cascarudo).
ncbi_mult_taxo_gbnm(245776, 'flagtail catfish').
ncbi_mult_taxo_gbnm(245787, 'hairy-eared Cerrado mouse').
ncbi_mult_taxo_gbnm(245845, 'Chilean mocking-bird').
ncbi_mult_taxo_gbnm(245847, 'Charles mockingbird').
ncbi_mult_taxo_gbnm(245849, 'Galapagos mockingbird').
ncbi_mult_taxo_gbnm(245850, 'hood mockingbird').
ncbi_mult_taxo_gbnm(245851, 'San Cristobal mockingbird').
ncbi_mult_taxo_gbnm(245875, 'marbled flounder').
ncbi_mult_taxo_gbnm(245877, 'Cayenne tern').
ncbi_mult_taxo_gbnm(245975, 'Kikuchi\'s minnow').
ncbi_mult_taxo_gbnm(246115, 'Hunan softshell turtle').
ncbi_mult_taxo_gbnm(246190, 'Western serpentiform skink').
ncbi_mult_taxo_gbnm(246350, 'Java almond').
ncbi_mult_taxo_gbnm(246392, 'plateau mouse').
ncbi_mult_taxo_gbnm(246401, 'Morgan\'s sphinx moth').
ncbi_mult_taxo_gbnm(246408, 'Luzon wart frog').
ncbi_mult_taxo_gbnm(246411, 'Indonesian wart frog').
ncbi_mult_taxo_gbnm(246412, 'giant river frog').
ncbi_mult_taxo_gbnm(246415, 'Bunawan wart frog').
ncbi_mult_taxo_gbnm(246417, 'Woodworth\'s wart frog').
ncbi_mult_taxo_gbnm(246418, 'Luzon fanged frog').
ncbi_mult_taxo_gbnm(246419, 'Philippine wart frog').
ncbi_mult_taxo_gbnm(246422, 'Moluccas wart frog').
ncbi_mult_taxo_gbnm(246426, 'Djikoro wart frog').
ncbi_mult_taxo_gbnm(246436, 'long-footed tree shrew').
ncbi_mult_taxo_gbnm(246437, 'Chinese tree shrew').
ncbi_mult_taxo_gbnm(246517, 'Spanish elm').
ncbi_mult_taxo_gbnm(246553, 'Bornean smooth-tailed tree shrew').
ncbi_mult_taxo_gbnm(246814, 'soprano pipistrelle').
ncbi_mult_taxo_gbnm(246881, 'Mongolian wolf').
ncbi_mult_taxo_gbnm(246882, 'Indian wolf').
ncbi_mult_taxo_gbnm(247091, 'Sabana Surinam toad').
ncbi_mult_taxo_gbnm(247094, 'Congo dwarf clawed frog').
ncbi_mult_taxo_gbnm(247145, 'sharp-nosed reed frog').
ncbi_mult_taxo_gbnm(247146, 'South Cameroon reed frog').
ncbi_mult_taxo_gbnm(247147, 'rainforest reed frog').
ncbi_mult_taxo_gbnm(247271, 'childers canegrub').
ncbi_mult_taxo_gbnm(247400, 'Sarabia cichlid').
ncbi_mult_taxo_gbnm(247401, 'San Domingo cichlid').
ncbi_mult_taxo_gbnm(247407, 'yellow cichlid').
ncbi_mult_taxo_gbnm(247410, 'Amatitlan cichlid').
ncbi_mult_taxo_gbnm(247411, 'three spot cichlid').
ncbi_mult_taxo_gbnm(247431, 'Reunion seahorse').
ncbi_mult_taxo_gbnm(247438, 'sea peach').
ncbi_mult_taxo_gbnm(247512, 'black-bellied firefinch').
ncbi_mult_taxo_gbnm(247513, 'black-throated firefinch').
ncbi_mult_taxo_gbnm(247514, 'African firefinch').
ncbi_mult_taxo_gbnm(247515, 'Jameson\'s firefinch').
ncbi_mult_taxo_gbnm(247516, 'Mali firefinch').
ncbi_mult_taxo_gbnm(247522, 'bar-breasted firefinch').
ncbi_mult_taxo_gbnm(247524, 'brown firefinch').
ncbi_mult_taxo_gbnm(247526, 'brown twinspot').
ncbi_mult_taxo_gbnm(247528, 'green-winged Pytilia').
ncbi_mult_taxo_gbnm(247529, 'red-faced Pytilia').
ncbi_mult_taxo_gbnm(247530, 'red-winged Pytilia').
ncbi_mult_taxo_gbnm(247531, 'lineated Pytilia').
ncbi_mult_taxo_gbnm(247532, 'orange-winged Pytilia').
ncbi_mult_taxo_gbnm(247533, 'pink-throated twinspot').
ncbi_mult_taxo_gbnm(247535, 'Dybowski\'s twinspot').
ncbi_mult_taxo_gbnm(247537, 'purple grenadier').
ncbi_mult_taxo_gbnm(247538, 'Violet-eared waxbill').
ncbi_mult_taxo_gbnm(247539, 'fawn-breasted waxbill').
ncbi_mult_taxo_gbnm(247541, 'black-rumped waxbill').
ncbi_mult_taxo_gbnm(247542, 'orange-cheeked waxbill').
ncbi_mult_taxo_gbnm(247543, 'crimson-rumped waxbill').
ncbi_mult_taxo_gbnm(247544, 'black-cheeked waxbill').
ncbi_mult_taxo_gbnm(247547, 'reef-flat cardinalfish').
ncbi_mult_taxo_gbnm(247548, 'Cook\'s cardinalfish').
ncbi_mult_taxo_gbnm(247617, 'dwarf spiders').
ncbi_mult_taxo_gbnm(247620, 'chameleon parrotfish').
ncbi_mult_taxo_gbnm(247621, 'festive parrotfish').
ncbi_mult_taxo_gbnm(247622, 'globehead parrotfish').
ncbi_mult_taxo_gbnm(247623, 'knobsnout parrotfish').
ncbi_mult_taxo_gbnm(247624, 'Singapore parrotfish').
ncbi_mult_taxo_gbnm(247625, 'common parrotfish').
ncbi_mult_taxo_gbnm(247626, 'Quoy\'s parrotfish').
ncbi_mult_taxo_gbnm(247627, 'rivulated parrotfish').
ncbi_mult_taxo_gbnm(247628, 'ember parrotfish').
ncbi_mult_taxo_gbnm(247629, 'yellowband parrotfish').
ncbi_mult_taxo_gbnm(247647, 'Panama hake').
ncbi_mult_taxo_gbnm(247660, 'yellow-bellied waxbill').
ncbi_mult_taxo_gbnm(247661, 'swee waxbill').
ncbi_mult_taxo_gbnm(247662, 'long-tailed paradise-whydah').
ncbi_mult_taxo_gbnm(247663, 'broad-tailed paradise-whydah').
ncbi_mult_taxo_gbnm(247664, 'Northern paradise-whydah').
ncbi_mult_taxo_gbnm(247666, 'sociable weaver').
ncbi_mult_taxo_gbnm(247667, 'red-collared widowbird').
ncbi_mult_taxo_gbnm(247668, 'black-winged bishop').
ncbi_mult_taxo_gbnm(247669, 'Reichenow\'s firefinch').
ncbi_mult_taxo_gbnm(247670, 'dusky twinspot').
ncbi_mult_taxo_gbnm(247671, 'blue-capped cordonbleu').
ncbi_mult_taxo_gbnm(247672, 'blue-breasted cordonbleu').
ncbi_mult_taxo_gbnm(247673, 'red-cheeked cordonbleu').
ncbi_mult_taxo_gbnm(247675, 'Western bluebill').
ncbi_mult_taxo_gbnm(247712, 'black-bellied seedcracker').
ncbi_mult_taxo_gbnm(247713, 'black-crowned waxbill').
ncbi_mult_taxo_gbnm(247714, 'black-headed waxbill').
ncbi_mult_taxo_gbnm(247715, 'lavender waxbill').
ncbi_mult_taxo_gbnm(247716, 'black-tailed waxbill').
ncbi_mult_taxo_gbnm(247718, 'green-backed twinspot').
ncbi_mult_taxo_gbnm(247720, 'Shelley\'s crimson-wing').
ncbi_mult_taxo_gbnm(247721, 'chestnut-breasted negrofinch').
ncbi_mult_taxo_gbnm(247725, 'Fernando Po olive-back').
ncbi_mult_taxo_gbnm(247727, cutthroat).
ncbi_mult_taxo_gbnm(247728, 'red-headed finch').
ncbi_mult_taxo_gbnm(247729, 'red avadavat').
ncbi_mult_taxo_gbnm(247730, 'green avadavat').
ncbi_mult_taxo_gbnm(247731, 'blue-faced parrotfinch').
ncbi_mult_taxo_gbnm(247735, 'red-browed firetail').
ncbi_mult_taxo_gbnm(247736, 'crimson finch').
ncbi_mult_taxo_gbnm(247737, 'star finch').
ncbi_mult_taxo_gbnm(247740, 'Diamond firetail').
ncbi_mult_taxo_gbnm(247741, 'black-throated finch').
ncbi_mult_taxo_gbnm(247745, 'painted firetail').
ncbi_mult_taxo_gbnm(247775, 'double-barred finch').
ncbi_mult_taxo_gbnm(247806, 'chestnut-breasted munia').
ncbi_mult_taxo_gbnm(247807, 'Grey-headed silverbill').
ncbi_mult_taxo_gbnm(247810, 'pictorella munia').
ncbi_mult_taxo_gbnm(247811, 'African silverbill').
ncbi_mult_taxo_gbnm(247812, 'white-throated silverbill').
ncbi_mult_taxo_gbnm(247947, 'pale November moth').
ncbi_mult_taxo_gbnm(247948, 'Contulmo ground frog').
ncbi_mult_taxo_gbnm(247950, 'Mocha Island ground frog').
ncbi_mult_taxo_gbnm(247964, 'Nahuelbuta ground frog').
ncbi_mult_taxo_gbnm(247965, 'rosy ground frog').
ncbi_mult_taxo_gbnm(247966, 'Valdivia ground frog').
ncbi_mult_taxo_gbnm(247968, 'emerald forest frog').
ncbi_mult_taxo_gbnm(247969, 'Santa Cruz jay').
ncbi_mult_taxo_gbnm(247970, 'Sumichrast\'s scrub-Jay').
ncbi_mult_taxo_gbnm(247972, 'Woodhouse\'s scrub-Jay').
ncbi_mult_taxo_gbnm(247975, 'azure-hooded jay').
ncbi_mult_taxo_gbnm(247978, 'Plum-headed finch').
ncbi_mult_taxo_gbnm(248064, 'blue-throated wrasse').
ncbi_mult_taxo_gbnm(248078, 'Mexican jay').
ncbi_mult_taxo_gbnm(248133, 'marsh deer').
ncbi_mult_taxo_gbnm(248135, 'longtail shad').
ncbi_mult_taxo_gbnm(248136, 'Queensland school mackerel').
ncbi_mult_taxo_gbnm(248137, 'Australian spotted mackerel').
ncbi_mult_taxo_gbnm(248138, 'broadbarred king mackerel').
ncbi_mult_taxo_gbnm(248140, 'shark mackerel').
ncbi_mult_taxo_gbnm(248142, 'leaping bonito').
ncbi_mult_taxo_gbnm(248148, 'red-billed buffalo-weaver').
ncbi_mult_taxo_gbnm(248150, 'little forktail').
ncbi_mult_taxo_gbnm(248151, 'red-shouldered glossy-starling').
ncbi_mult_taxo_gbnm(248152, 'Mariqua flycatcher').
ncbi_mult_taxo_gbnm(248153, 'dusky alseonax').
ncbi_mult_taxo_gbnm(248154, 'black-throated accentor').
ncbi_mult_taxo_gbnm(248161, 'plumbeous water-redstart').
ncbi_mult_taxo_gbnm(248174, 'Chiguanco thrush').
ncbi_mult_taxo_gbnm(248175, 'Southern pied-babbler').
ncbi_mult_taxo_gbnm(248254, 'Mediterranean monk seal').
ncbi_mult_taxo_gbnm(248297, 'Indian heliotrope').
ncbi_mult_taxo_gbnm(248495, 'Saimaa ringed seal').
ncbi_mult_taxo_gbnm(248764, 'blue grenadier').
ncbi_mult_taxo_gbnm(248773, 'misfit leaf frog').
ncbi_mult_taxo_gbnm(248777, 'Krefft\'s secret frog').
ncbi_mult_taxo_gbnm(248779, 'Surinam horned frog').
ncbi_mult_taxo_gbnm(248782, 'Chimbo rocket frog').
ncbi_mult_taxo_gbnm(248786, 'green robber frog').
ncbi_mult_taxo_gbnm(248787, 'Duellman\'s robber frog').
ncbi_mult_taxo_gbnm(248789, 'El Carmelo robber frog').
ncbi_mult_taxo_gbnm(248790, 'Thymelen robber frog').
ncbi_mult_taxo_gbnm(248791, 'Zurucuchu robber frog').
ncbi_mult_taxo_gbnm(248792, 'western narrow-mouthed toad').
ncbi_mult_taxo_gbnm(248793, 'Nyika climbing mouse').
ncbi_mult_taxo_gbnm(248794, 'Macmillan\'s thicket rat').
ncbi_mult_taxo_gbnm(248795, 'San Lucas marsupial frog').
ncbi_mult_taxo_gbnm(248796, 'montane wood mouse').
ncbi_mult_taxo_gbnm(248799, 'crested rat').
ncbi_mult_taxo_gbnm(248806, 'Morona-Santiago treefrog').
ncbi_mult_taxo_gbnm(248808, 'Philippine narrowmouth toad').
ncbi_mult_taxo_gbnm(248811, 'Chinese white-bellied rat').
ncbi_mult_taxo_gbnm(248813, 'Southern Luzon giant cloud rat').
ncbi_mult_taxo_gbnm(248816, 'Arfakiana treefrog').
ncbi_mult_taxo_gbnm(248820, 'sandy big-eyed treefrog').
ncbi_mult_taxo_gbnm(248839, 'yellow poppywort').
ncbi_mult_taxo_gbnm(248862, 'Manaus slender-legged treefrog').
ncbi_mult_taxo_gbnm(248866, 'Andes frogs').
ncbi_mult_taxo_gbnm(248868, 'tiger-striped leaf frog').
ncbi_mult_taxo_gbnm(248869, 'Cuyaba dwarf frog').
ncbi_mult_taxo_gbnm(248870, 'Rio Grande dwarf frog').
ncbi_mult_taxo_gbnm(248874, 'Loka flying frog').
ncbi_mult_taxo_gbnm(248875, 'Madre de Dios treefrogs').
ncbi_mult_taxo_gbnm(248876, 'Madre de Dios treefrog').
ncbi_mult_taxo_gbnm(248877, 'Eirunepe snouted treefrog').
ncbi_mult_taxo_gbnm(248878, 'black water frog').
ncbi_mult_taxo_gbnm(248879, 'Vellard\'s water frog').
ncbi_mult_taxo_gbnm(248881, 'Jordan\'s casque-headed treefrog').
ncbi_mult_taxo_gbnm(248943, 'tropical bullfrogs').
ncbi_mult_taxo_gbnm(248945, 'Patagonian toad').
ncbi_mult_taxo_gbnm(248948, 'Loja rocket frog').
ncbi_mult_taxo_gbnm(248949, 'Pastaza rocket frog').
ncbi_mult_taxo_gbnm(248954, 'spotted rocket frog').
ncbi_mult_taxo_gbnm(248955, 'Los Tayos rocket frog').
ncbi_mult_taxo_gbnm(248956, 'Espada\'s rocket frog').
ncbi_mult_taxo_gbnm(248961, 'Santa Cecilia rocket frog').
ncbi_mult_taxo_gbnm(248983, 'Boulenger\'s rocket frog').
ncbi_mult_taxo_gbnm(249000, 'southern longfin goby').
ncbi_mult_taxo_gbnm(249002, 'Swan River goby').
ncbi_mult_taxo_gbnm(249003, 'lesser long-tailed bat').
ncbi_mult_taxo_gbnm(249006, 'Orinoco sword-nosed bat').
ncbi_mult_taxo_gbnm(249009, 'Short-headed broad-nosed bat').
ncbi_mult_taxo_gbnm(249010, 'gray sac-winged rat').
ncbi_mult_taxo_gbnm(249012, 'chestnut sac-winged bat').
ncbi_mult_taxo_gbnm(249014, 'greater dog-like bat').
ncbi_mult_taxo_gbnm(249015, 'lesser dog-like bat').
ncbi_mult_taxo_gbnm(249017, 'proboscis bat').
ncbi_mult_taxo_gbnm(249018, 'lesser sac-winged bat').
ncbi_mult_taxo_gbnm(249019, 'naked-rumped tomb bat').
ncbi_mult_taxo_gbnm(249020, 'Aba roundleaf bat').
ncbi_mult_taxo_gbnm(249021, 'cyclops roundleaf bat').
ncbi_mult_taxo_gbnm(249022, 'Argentine anchovy').
ncbi_mult_taxo_gbnm(249024, 'Halcyon horseshoe bat').
ncbi_mult_taxo_gbnm(249028, 'Bate\'s slit-faced bat').
ncbi_mult_taxo_gbnm(249033, 'Van Gelder\'s bat').
ncbi_mult_taxo_gbnm(249034, 'White-bellied yellow bat').
ncbi_mult_taxo_gbnm(249164, 'Crimean barbel').
ncbi_mult_taxo_gbnm(249166, 'Kuban barbel').
ncbi_mult_taxo_gbnm(249172, 'jungle bush-quail').
ncbi_mult_taxo_gbnm(249182, 'giant pocket gopher').
ncbi_mult_taxo_gbnm(249417, 'grass scales').
ncbi_mult_taxo_gbnm(249422, 'ornate pit scales').
ncbi_mult_taxo_gbnm(249429, 'gall-like scales').
ncbi_mult_taxo_gbnm(249430, 'lac scales').
ncbi_mult_taxo_gbnm(249433, 'false pit scales').
ncbi_mult_taxo_gbnm(249435, 'ensign scales').
ncbi_mult_taxo_gbnm(249437, 'date scales').
ncbi_mult_taxo_gbnm(249440, 'Black-striped skink').
ncbi_mult_taxo_gbnm(249442, 'Spotted skink').
ncbi_mult_taxo_gbnm(249444, 'Gray skink').
ncbi_mult_taxo_gbnm(249511, 'garrya mealybug').
ncbi_mult_taxo_gbnm(249558, 'Solanum mealybug').
ncbi_mult_taxo_gbnm(249559, 'Mexican mealybug').
ncbi_mult_taxo_gbnm(249562, 'vine mealybug').
ncbi_mult_taxo_gbnm(249563, 'obscure mealybug').
ncbi_mult_taxo_gbnm(251094, 'Tilo island dwarf elephant').
ncbi_mult_taxo_gbnm(251233, 'southern midwife toad').
ncbi_mult_taxo_gbnm(251274, 'red tree vole').
ncbi_mult_taxo_gbnm(251276, 'white-footed mole').
ncbi_mult_taxo_gbnm(251277, 'Sonoma tree vole').
ncbi_mult_taxo_gbnm(251311, 'white-bellied grass mouse').
ncbi_mult_taxo_gbnm(251381, 'iguana tick').
ncbi_mult_taxo_gbnm(251502, 'southern banded newt').
ncbi_mult_taxo_gbnm(251754, 'pig-nosed frog').
ncbi_mult_taxo_gbnm(251756, 'turtle frog').
ncbi_mult_taxo_gbnm(251759, 'coffee bean weevil').
ncbi_mult_taxo_gbnm(252269, 'white-lined Madagascar frog').
ncbi_mult_taxo_gbnm(252281, 'Ida\'s bright-eyed frog').
ncbi_mult_taxo_gbnm(252286, 'Victoria night frog').
ncbi_mult_taxo_gbnm(252291, 'Hida salamander').
ncbi_mult_taxo_gbnm(252529, colocynth).
ncbi_mult_taxo_gbnm(252533, 'prickly cucumber').
ncbi_mult_taxo_gbnm(252534, 'coastal manroot').
ncbi_mult_taxo_gbnm(252558, tinda).
ncbi_mult_taxo_gbnm(252580, 'mouse ear snail').
ncbi_mult_taxo_gbnm(252582, 'giant Atlantic pyram').
ncbi_mult_taxo_gbnm(252596, 'spotted knifefish').
ncbi_mult_taxo_gbnm(252599, 'white-blotched grouper').
ncbi_mult_taxo_gbnm(252781, 'African tawny-eagle').
ncbi_mult_taxo_gbnm(252782, 'Verreaux\'s eagle').
ncbi_mult_taxo_gbnm(252783, 'Ayres\'s hawk-eagle').
ncbi_mult_taxo_gbnm(252785, 'little eagle').
ncbi_mult_taxo_gbnm(252787, 'Wahlberg\'s eagle').
ncbi_mult_taxo_gbnm(252789, 'crested eagle').
ncbi_mult_taxo_gbnm(252794, 'martial eagle').
ncbi_mult_taxo_gbnm(252795, 'changeable hawk-eagle').
ncbi_mult_taxo_gbnm(252796, 'ornate hawk-eagle').
ncbi_mult_taxo_gbnm(252797, 'Philippine hawk-eagle').
ncbi_mult_taxo_gbnm(252798, 'black hawk-eagle').
ncbi_mult_taxo_gbnm(252802, 'crowned hawk-eagle').
ncbi_mult_taxo_gbnm(252867, 'cao guo').
ncbi_mult_taxo_gbnm(252964, 'commercial sponge').
ncbi_mult_taxo_gbnm(253247, 'Kaiser\'s rock rat').
ncbi_mult_taxo_gbnm(253253, 'water lily aphid').
ncbi_mult_taxo_gbnm(253258, 'Amoy tiger').
ncbi_mult_taxo_gbnm(253281, 'ocellated wedge sole').
ncbi_mult_taxo_gbnm(253472, 'kangaroo soft tick').
ncbi_mult_taxo_gbnm(253859, 'eyed flounder').
ncbi_mult_taxo_gbnm(253861, 'spotted whiff').
ncbi_mult_taxo_gbnm(253862, 'Patagonian flounder').
ncbi_mult_taxo_gbnm(253863, 'largetooth flounder').
ncbi_mult_taxo_gbnm(253925, 'Bengal tongue sole').
ncbi_mult_taxo_gbnm(253926, 'Censky\'s ameiva').
ncbi_mult_taxo_gbnm(253927, 'Jamaica ameiva').
ncbi_mult_taxo_gbnm(253928, 'St. Christopher ameiva').
ncbi_mult_taxo_gbnm(253929, 'Common Puerto Rican ameiva').
ncbi_mult_taxo_gbnm(253931, 'Dominican ameiva').
ncbi_mult_taxo_gbnm(253932, 'Griswold\'s ameiva').
ncbi_mult_taxo_gbnm(253933, 'Great Inagua ameiva').
ncbi_mult_taxo_gbnm(253934, 'Anguilla Bank ameiva').
ncbi_mult_taxo_gbnm(253935, 'Montiserrat ameiva').
ncbi_mult_taxo_gbnm(253936, 'Puerto Rican blue-tailed ameiva').
ncbi_mult_taxo_gbnm(253938, 'lined sole').
ncbi_mult_taxo_gbnm(253939, 'slipper sole').
ncbi_mult_taxo_gbnm(254044, 'hemlock water-dropwort').
ncbi_mult_taxo_gbnm(254121, 'California brome').
ncbi_mult_taxo_gbnm(254138, 'mountain brome').
ncbi_mult_taxo_gbnm(254154, 'hoary brome').
ncbi_mult_taxo_gbnm(254296, 'spottail shiner').
ncbi_mult_taxo_gbnm(254363, 'silver Y moth').
ncbi_mult_taxo_gbnm(254365, 'dark spectacle').
ncbi_mult_taxo_gbnm(254382, 'rice looper').
ncbi_mult_taxo_gbnm(254401, 'eroded hingeback tortoise').
ncbi_mult_taxo_gbnm(254441, 'dapple-throat').
ncbi_mult_taxo_gbnm(254442, 'dusky wood-swallow').
ncbi_mult_taxo_gbnm(254444, 'short-tailed Batis').
ncbi_mult_taxo_gbnm(254446, 'pygmy drongo').
ncbi_mult_taxo_gbnm(254448, 'Loria\'s bird-of-paradise').
ncbi_mult_taxo_gbnm(254449, 'grey shrike-thrush').
ncbi_mult_taxo_gbnm(254450, 'slaty gnateater').
ncbi_mult_taxo_gbnm(254452, 'black-faced cuckoo-shrike').
ncbi_mult_taxo_gbnm(254453, 'white-throated treecreeper').
ncbi_mult_taxo_gbnm(254520, 'Torresian crow').
ncbi_mult_taxo_gbnm(254525, 'Black butcherbird').
ncbi_mult_taxo_gbnm(254526, whistlers).
ncbi_mult_taxo_gbnm(254528, 'varied sittella').
ncbi_mult_taxo_gbnm(254529, 'midget flowerpecker').
ncbi_mult_taxo_gbnm(254530, 'hair-crested drongo').
ncbi_mult_taxo_gbnm(254531, 'black-backed puffback').
ncbi_mult_taxo_gbnm(254533, 'crimson chat').
ncbi_mult_taxo_gbnm(254536, 'garnet robin').
ncbi_mult_taxo_gbnm(254539, 'Eastern shriketit').
ncbi_mult_taxo_gbnm(254542, 'rufous-crowned greenlet').
ncbi_mult_taxo_gbnm(254544, 'South American silver croaker').
ncbi_mult_taxo_gbnm(254546, 'varied triller').
ncbi_mult_taxo_gbnm(254549, 'glossy-mantled manucode').
ncbi_mult_taxo_gbnm(254550, 'crinkle-collared manucode').
ncbi_mult_taxo_gbnm(254551, 'lesser Melampitta').
ncbi_mult_taxo_gbnm(254552, 'Fan-tailed berrypecker').
ncbi_mult_taxo_gbnm(254554, 'hooded robin').
ncbi_mult_taxo_gbnm(254556, 'canary flyrobin').
ncbi_mult_taxo_gbnm(254557, 'McConnell\'s flycatcher').
ncbi_mult_taxo_gbnm(254559, 'spot-throat').
ncbi_mult_taxo_gbnm(254560, 'golden monarch').
ncbi_mult_taxo_gbnm(254561, 'ferruginous flycatcher').
ncbi_mult_taxo_gbnm(254563, 'wattled asity').
ncbi_mult_taxo_gbnm(254566, 'crested bellbird').
ncbi_mult_taxo_gbnm(254571, 'white-eyed robin').
ncbi_mult_taxo_gbnm(254574, 'crested berrypecker').
ncbi_mult_taxo_gbnm(254575, 'spotted pardalote').
ncbi_mult_taxo_gbnm(254640, 'white-rumped robin').
ncbi_mult_taxo_gbnm(254642, 'long-tailed minivet').
ncbi_mult_taxo_gbnm(254643, 'Crested Pitohui').
ncbi_mult_taxo_gbnm(254645, 'white helmetshrike').
ncbi_mult_taxo_gbnm(254652, 'Cape sugarbird').
ncbi_mult_taxo_gbnm(254654, 'grey silky-flycatcher').
ncbi_mult_taxo_gbnm(254657, 'blue jewel-babbler').
ncbi_mult_taxo_gbnm(254661, 'green figbird').
ncbi_mult_taxo_gbnm(254663, 'pied currawong').
ncbi_mult_taxo_gbnm(254664, 'Doherty\'s bushshrike').
ncbi_mult_taxo_gbnm(254665, 'masked Tityra').
ncbi_mult_taxo_gbnm(254704, 'Earth-colored mouse').
ncbi_mult_taxo_gbnm(254705, 'particolored flying squirrel').
ncbi_mult_taxo_gbnm(254706, 'gray-cheeked flying squirrel').
ncbi_mult_taxo_gbnm(254707, 'Palawan flying squirrel').
ncbi_mult_taxo_gbnm(254708, 'red-cheeked flying squirrel').
ncbi_mult_taxo_gbnm(254779, 'meadow pea').
ncbi_mult_taxo_gbnm(255174, 'Goldfields spiny-tailed gecko').
ncbi_mult_taxo_gbnm(255176, 'Southern spiny-tailed gecko').
ncbi_mult_taxo_gbnm(255180, 'phasmid striped gecko').
ncbi_mult_taxo_gbnm(255183, 'short-tailed striped gecko').
ncbi_mult_taxo_gbnm(255188, 'marbled velvet gecko').
ncbi_mult_taxo_gbnm(255217, 'Omura\'s baleen whale').
ncbi_mult_taxo_gbnm(255237, 'agile mangabey').
ncbi_mult_taxo_gbnm(255309, 'Peruvian golden scorpion').
ncbi_mult_taxo_gbnm(255346, 'woolly beachheather').
ncbi_mult_taxo_gbnm(255355, 'bird-of-paradise').
ncbi_mult_taxo_gbnm(255365, 'Bryde\'s whale').
ncbi_mult_taxo_gbnm(255366, 'short-tailed antthrush').
ncbi_mult_taxo_gbnm(255368, 'ochre-breasted antpitta').
ncbi_mult_taxo_gbnm(255369, 'elusive antpitta').
ncbi_mult_taxo_gbnm(255370, 'brown-breasted antpitta').
ncbi_mult_taxo_gbnm(255371, 'Amazonian antpitta').
ncbi_mult_taxo_gbnm(255373, 'rufous-crowned antpitta').
ncbi_mult_taxo_gbnm(255374, 'black-crowned antpitta').
ncbi_mult_taxo_gbnm(255377, 'rusty-belted tapaculo').
ncbi_mult_taxo_gbnm(255379, 'black-spotted bare-eye').
ncbi_mult_taxo_gbnm(255383, 'wing-banded antbird').
ncbi_mult_taxo_gbnm(255386, 'plain xenops').
ncbi_mult_taxo_gbnm(255387, 'bare-throated bellbird').
ncbi_mult_taxo_gbnm(255458, 'naked sand darter').
ncbi_mult_taxo_gbnm(255460, 'mud darter').
ncbi_mult_taxo_gbnm(255461, 'orangefin darter').
ncbi_mult_taxo_gbnm(255462, 'brook darter').
ncbi_mult_taxo_gbnm(255464, 'cypress darter').
ncbi_mult_taxo_gbnm(255465, 'stippled darter').
ncbi_mult_taxo_gbnm(255468, 'orangespotted sunfish').
ncbi_mult_taxo_gbnm(255533, tokubire).
ncbi_mult_taxo_gbnm(255539, 'longnose poacher').
ncbi_mult_taxo_gbnm(255558, 'dusky sole').
ncbi_mult_taxo_gbnm(255560, 'roughscale sole').
ncbi_mult_taxo_gbnm(255564, 'roughskin skate').
ncbi_mult_taxo_gbnm(255566, 'phantom blindcat').
ncbi_mult_taxo_gbnm(255567, 'Mexican blindcat').
ncbi_mult_taxo_gbnm(255571, 'ghost catfish').
ncbi_mult_taxo_gbnm(255572, 'Pictus cat').
ncbi_mult_taxo_gbnm(255574, 'bumblebee catfishes').
ncbi_mult_taxo_gbnm(255717, 'Atlantic seasnail').
ncbi_mult_taxo_gbnm(255718, 'variegated snailfish').
ncbi_mult_taxo_gbnm(255923, 'zigzag salamander').
ncbi_mult_taxo_gbnm(255924, 'northern ravine salamander').
ncbi_mult_taxo_gbnm(255925, 'Cheat Mountain salamander').
ncbi_mult_taxo_gbnm(255926, 'white-spotted salamander').
ncbi_mult_taxo_gbnm(255927, 'Shenandoah mountain salamander').
ncbi_mult_taxo_gbnm(255929, 'Webster\'s salamander').
ncbi_mult_taxo_gbnm(256038, 'New Zealand robin').
ncbi_mult_taxo_gbnm(256109, 'Slender racer').
ncbi_mult_taxo_gbnm(256123, 'Roth\'s dwarf racer').
ncbi_mult_taxo_gbnm(256136, 'giant squid').
ncbi_mult_taxo_gbnm(256421, 'glistening-green tanager').
ncbi_mult_taxo_gbnm(256424, 'Amur pike').
ncbi_mult_taxo_gbnm(256425, 'palmate newt').
ncbi_mult_taxo_gbnm(256450, 'green-capped tanager').
ncbi_mult_taxo_gbnm(256452, 'beryl-spangled tanager').
ncbi_mult_taxo_gbnm(256454, 'flame-faced tanager').
ncbi_mult_taxo_gbnm(256458, 'green-and-gold tanager').
ncbi_mult_taxo_gbnm(256460, 'blue-and-black tanager').
ncbi_mult_taxo_gbnm(256461, 'opal-rumped tanager').
ncbi_mult_taxo_gbnm(256464, 'saffron-crowned tanager').
ncbi_mult_taxo_gbnm(256688, 'capped seedeater').
ncbi_mult_taxo_gbnm(256689, 'double-collared seedeater').
ncbi_mult_taxo_gbnm(256690, 'chestnut seedeater').
ncbi_mult_taxo_gbnm(256691, 'Temminck\'s seedeater').
ncbi_mult_taxo_gbnm(256692, 'grey-and-chestnut seedeater').
ncbi_mult_taxo_gbnm(256693, 'tawny-bellied seedeater').
ncbi_mult_taxo_gbnm(256694, 'white-bellied seedeater').
ncbi_mult_taxo_gbnm(256695, 'black-and-white seedeater').
ncbi_mult_taxo_gbnm(256696, 'black-bellied seedeater').
ncbi_mult_taxo_gbnm(256697, 'ruddy-breasted seedeater').
ncbi_mult_taxo_gbnm(256698, 'marsh seedeater').
ncbi_mult_taxo_gbnm(256699, 'chestnut-throated seedeater').
ncbi_mult_taxo_gbnm(256700, 'Narosky\'s seedeater').
ncbi_mult_taxo_gbnm(256733, 'red-legged widow').
ncbi_mult_taxo_gbnm(256736, 'redback spider').
ncbi_mult_taxo_gbnm(256737, 'western black widow').
ncbi_mult_taxo_gbnm(256738, 'true katipo').
ncbi_mult_taxo_gbnm(256748, 'northern black widow').
ncbi_mult_taxo_gbnm(257447, 'lesser Taiwanese shrew').
ncbi_mult_taxo_gbnm(257448, 'Mexican small-eared shrew').
ncbi_mult_taxo_gbnm(257483, 'rufous-naped wren').
ncbi_mult_taxo_gbnm(257485, 'band-backed wren').
ncbi_mult_taxo_gbnm(257537, 'painted goby').
ncbi_mult_taxo_gbnm(257538, 'Norway goby').
ncbi_mult_taxo_gbnm(257725, 'Western Greece goby').
ncbi_mult_taxo_gbnm(257756, 'coffin ray').
ncbi_mult_taxo_gbnm(257757, 'Tasmanian numbfish').
ncbi_mult_taxo_gbnm(257818, 'Oriental scops-owl').
ncbi_mult_taxo_gbnm(257819, 'Japanese scops-owl').
ncbi_mult_taxo_gbnm(257846, 'Mongolian ground-jay').
ncbi_mult_taxo_gbnm(257847, 'Xinjiang ground-jay').
ncbi_mult_taxo_gbnm(257849, 'Stresemann\'s bush-crow').
ncbi_mult_taxo_gbnm(257851, 'racket-tailed treepie').
ncbi_mult_taxo_gbnm(257853, 'grey treepie').
ncbi_mult_taxo_gbnm(257854, 'Sichuan jay').
ncbi_mult_taxo_gbnm(257856, 'black magpie').
ncbi_mult_taxo_gbnm(257858, 'ratchet-tailed treepie').
ncbi_mult_taxo_gbnm(257867, 'Eurasian spoonbill').
ncbi_mult_taxo_gbnm(257879, 'hoary bat').
ncbi_mult_taxo_gbnm(257881, 'Keen\'s myotis').
ncbi_mult_taxo_gbnm(257882, 'California Myotis').
ncbi_mult_taxo_gbnm(257883, 'long-eared Myotis').
ncbi_mult_taxo_gbnm(257884, 'western small-footed bat').
ncbi_mult_taxo_gbnm(257887, 'slender armorhead').
ncbi_mult_taxo_gbnm(257889, 'Japanese armorhead').
ncbi_mult_taxo_gbnm(258147, 'American barberry').
ncbi_mult_taxo_gbnm(258188, 'cascade Oregon-grape').
ncbi_mult_taxo_gbnm(258209, 'European barberry').
ncbi_mult_taxo_gbnm(258242, 'Korean hare').
ncbi_mult_taxo_gbnm(258338, 'brown sailor spider').
ncbi_mult_taxo_gbnm(258452, beaugregory).
ncbi_mult_taxo_gbnm(258530, 'Japanese sparrowhawk').
ncbi_mult_taxo_gbnm(258722, 'white anchovy').
ncbi_mult_taxo_gbnm(258775, 'Hampton\'s slug snake').
ncbi_mult_taxo_gbnm(258777, 'Asian slug snake').
ncbi_mult_taxo_gbnm(258779, 'Sumatra slug snake').
ncbi_mult_taxo_gbnm(258802, 'Oriental honey-buzzard').
ncbi_mult_taxo_gbnm(258803, 'barred honey-buzzard').
ncbi_mult_taxo_gbnm(258817, 'long-tailed honey-buzzard').
ncbi_mult_taxo_gbnm(258819, 'African baza').
ncbi_mult_taxo_gbnm(258857, 'Klemmer\'s Madagascar frog').
ncbi_mult_taxo_gbnm(258858, 'Tsarafidy Madagascar frog').
ncbi_mult_taxo_gbnm(258860, 'Folohy Madagascar frog').
ncbi_mult_taxo_gbnm(258861, 'Ivohimanita Madagascar frog').
ncbi_mult_taxo_gbnm(258863, 'Angolan free-tailed bat').
ncbi_mult_taxo_gbnm(258865, 'pocketed free-tailed bat').
ncbi_mult_taxo_gbnm(258867, 'large-eared free-tailed bat').
ncbi_mult_taxo_gbnm(258869, 'Roberts\'s flat-headed bat').
ncbi_mult_taxo_gbnm(258889, 'Gould\'s wattled bat').
ncbi_mult_taxo_gbnm(258909, 'Abo bat').
ncbi_mult_taxo_gbnm(258919, 'big-eared brown bat').
ncbi_mult_taxo_gbnm(258925, 'clear-winged woolly bat').
ncbi_mult_taxo_gbnm(258927, 'Namib long-eared bat').
ncbi_mult_taxo_gbnm(258928, 'Southern yellow bat').
ncbi_mult_taxo_gbnm(258929, 'Seminole bat').
ncbi_mult_taxo_gbnm(258930, 'red bat').
ncbi_mult_taxo_gbnm(258931, 'Handley\'s red bat').
ncbi_mult_taxo_gbnm(258932, 'Western red bat').
ncbi_mult_taxo_gbnm(258933, 'lesser long-fingered bat').
ncbi_mult_taxo_gbnm(258934, 'small bent-winged bat').
ncbi_mult_taxo_gbnm(258935, 'Hutton\'s tube-nosed bat').
ncbi_mult_taxo_gbnm(258936, 'Southeastern Myotis').
ncbi_mult_taxo_gbnm(258937, 'elegant Myotis').
ncbi_mult_taxo_gbnm(258938, 'cinnamon myotis').
ncbi_mult_taxo_gbnm(258939, 'Ridley\'s bat').
ncbi_mult_taxo_gbnm(258940, 'Himalayan whiskered bat').
ncbi_mult_taxo_gbnm(258941, 'Northern long-eared myotis').
ncbi_mult_taxo_gbnm(258942, 'little forest bat').
ncbi_mult_taxo_gbnm(258943, 'Rendall\'s serotine').
ncbi_mult_taxo_gbnm(258944, 'Somali serotine').
ncbi_mult_taxo_gbnm(258945, 'lesser long-eared bat').
ncbi_mult_taxo_gbnm(258946, 'Indian pipistrelle').
ncbi_mult_taxo_gbnm(258947, 'Javan pipistrelle').
ncbi_mult_taxo_gbnm(258948, 'least pipistrelle').
ncbi_mult_taxo_gbnm(258949, 'least yellow bat').
ncbi_mult_taxo_gbnm(258951, 'Reunion house bat').
ncbi_mult_taxo_gbnm(258952, 'Yellow-bellied house bat').
ncbi_mult_taxo_gbnm(258953, 'Nut-colored yellow bat').
ncbi_mult_taxo_gbnm(258955, 'dark-winged lesser house bat').
ncbi_mult_taxo_gbnm(258957, 'harlequin bat').
ncbi_mult_taxo_gbnm(258959, 'lesser bamboo bat').
ncbi_mult_taxo_gbnm(259068, 'pignose frog').
ncbi_mult_taxo_gbnm(259256, 'long-tailed finch').
ncbi_mult_taxo_gbnm(259338, 'mulberry leaf roller').
ncbi_mult_taxo_gbnm(259381, ackee).
ncbi_mult_taxo_gbnm(259533, 'barley stem gall midge').
ncbi_mult_taxo_gbnm(259651, 'Rio Grande sucker').
ncbi_mult_taxo_gbnm(259703, 'white weakfish').
ncbi_mult_taxo_gbnm(259844, 'marine fireworm').
ncbi_mult_taxo_gbnm(259859, 'Capeweed').
ncbi_mult_taxo_gbnm(259913, 'black-faced spoonbill').
ncbi_mult_taxo_gbnm(259920, 'whale shark').
ncbi_mult_taxo_gbnm(259987, 'Pacific thread herring').
ncbi_mult_taxo_gbnm(260104, 'lanceolated warbler').
ncbi_mult_taxo_gbnm(260105, 'grasshopper warbler').
ncbi_mult_taxo_gbnm(260106, 'Little grassbird').
ncbi_mult_taxo_gbnm(260108, 'Asian stubtail').
ncbi_mult_taxo_gbnm(260130, 'pineapple guava').
ncbi_mult_taxo_gbnm(260139, 'bay rum tree').
ncbi_mult_taxo_gbnm(260140, 'Brazilian guava').
ncbi_mult_taxo_gbnm(260142, 'Java plum').
ncbi_mult_taxo_gbnm(260143, 'wax apple').
ncbi_mult_taxo_gbnm(260370, 'Appenine yellow-bellied toad').
ncbi_mult_taxo_gbnm(260371, 'evergreen forest warbler').
ncbi_mult_taxo_gbnm(260500, 'black katipo').
ncbi_mult_taxo_gbnm(260503, 'shrimp eel').
ncbi_mult_taxo_gbnm(260506, 'yellowfin river pellona').
ncbi_mult_taxo_gbnm(260508, 'longfin smelt').
ncbi_mult_taxo_gbnm(260512, 'Pacific argentine').
ncbi_mult_taxo_gbnm(260524, 'blacktail snapper').
ncbi_mult_taxo_gbnm(260525, 'dory snapper').
ncbi_mult_taxo_gbnm(260531, 'Madagascar fish-eagle').
ncbi_mult_taxo_gbnm(260533, 'Goliath birdeating spider').
ncbi_mult_taxo_gbnm(260615, 'Reeves\'s turtle').
ncbi_mult_taxo_gbnm(260618, 'stripeneck leaf turtle').
ncbi_mult_taxo_gbnm(260622, 'Chinese broad-headed pond turtle').
ncbi_mult_taxo_gbnm(260624, 'Yellow-headed temple turtle').
ncbi_mult_taxo_gbnm(260627, 'keeled box turtle').
ncbi_mult_taxo_gbnm(260630, 'Chinese striped-necked turtle').
ncbi_mult_taxo_gbnm(260631, 'black-bridged leaf turtle').
ncbi_mult_taxo_gbnm(260642, 'Indian roofed turtle').
ncbi_mult_taxo_gbnm(260649, 'painted wood turtle').
ncbi_mult_taxo_gbnm(260718, 'Tahitian gooseberry tree').
ncbi_mult_taxo_gbnm(260767, 'white-finned gudgeon').
ncbi_mult_taxo_gbnm(260896, 'northern barred frog').
ncbi_mult_taxo_gbnm(260902, 'meadow bunting').
ncbi_mult_taxo_gbnm(260973, 'Croatian dace').
ncbi_mult_taxo_gbnm(260983, 'Usambara bluish-gray caecilian').
ncbi_mult_taxo_gbnm(260995, 'Gabon caecilian').
ncbi_mult_taxo_gbnm(261002, 'Ansell\'s mole-rat').
ncbi_mult_taxo_gbnm(261003, 'Kafue mole-rat').
ncbi_mult_taxo_gbnm(261004, 'Nigerian mole-rat').
ncbi_mult_taxo_gbnm(261005, 'Ochre mole-rat').
ncbi_mult_taxo_gbnm(261076, 'variegated lizardfish').
ncbi_mult_taxo_gbnm(261169, 'Miyako toad').
ncbi_mult_taxo_gbnm(261172, 'Japanese stream toad').
ncbi_mult_taxo_gbnm(261198, 'Cooper\'s hawk').
ncbi_mult_taxo_gbnm(261200, sora).
ncbi_mult_taxo_gbnm(261486, 'king\'s worm lizard').
ncbi_mult_taxo_gbnm(261488, 'Barbour\'s worm lizard').
ncbi_mult_taxo_gbnm(261504, 'Turkish worm lizard').
ncbi_mult_taxo_gbnm(261506, 'checkerboard worm lizard').
ncbi_mult_taxo_gbnm(261519, grubfish).
ncbi_mult_taxo_gbnm(261520, 'gold-birdled sandsmelt').
ncbi_mult_taxo_gbnm(261670, 'snouted grassland frog').
ncbi_mult_taxo_gbnm(261671, 'Medine grassland frog').
ncbi_mult_taxo_gbnm(261707, 'prong-snouted blind snake').
ncbi_mult_taxo_gbnm(261708, 'pale-headed blind snake').
ncbi_mult_taxo_gbnm(261710, 'long-beaked blind snake').
ncbi_mult_taxo_gbnm(261712, 'claw-snouted blind snake').
ncbi_mult_taxo_gbnm(261714, 'beaked blind snake').
ncbi_mult_taxo_gbnm(261731, 'Gabon bushbaby').
ncbi_mult_taxo_gbnm(261734, 'fork-marked lemur').
ncbi_mult_taxo_gbnm(261736, 'western needle-clawed galago').
ncbi_mult_taxo_gbnm(261739, 'calabar angwantibo').
ncbi_mult_taxo_gbnm(261741, 'Bengal slow loris').
ncbi_mult_taxo_gbnm(261754, 'mid-day jird').
ncbi_mult_taxo_gbnm(261944, 'unadorned desert-skink').
ncbi_mult_taxo_gbnm(261947, 'Flinder\'s Ranges rock-skink').
ncbi_mult_taxo_gbnm(261953, 'southwestern rock-skink').
ncbi_mult_taxo_gbnm(261958, 'Dawson\'s burrowing bee').
ncbi_mult_taxo_gbnm(261959, 'white-breasted waterhen').
ncbi_mult_taxo_gbnm(261960, 'green sandpiper').
ncbi_mult_taxo_gbnm(261961, 'grey-headed lapwing').
ncbi_mult_taxo_gbnm(261967, watercock).
ncbi_mult_taxo_gbnm(261968, 'yellow-legged buttonquail').
ncbi_mult_taxo_gbnm(261969, 'black drongo').
ncbi_mult_taxo_gbnm(262081, 'King\'s bullhead').
ncbi_mult_taxo_gbnm(262111, 'Manchurian black bear').
ncbi_mult_taxo_gbnm(262114, 'white-faced quail-dove').
ncbi_mult_taxo_gbnm(262115, 'rufous-reasted quail-dove').
ncbi_mult_taxo_gbnm(262116, 'buff-fronted quail-dove').
ncbi_mult_taxo_gbnm(262117, 'grey-chested dove').
ncbi_mult_taxo_gbnm(262118, 'Rarotongan fruit-dove').
ncbi_mult_taxo_gbnm(262119, 'silver-capped fruit-dove').
ncbi_mult_taxo_gbnm(262121, 'Papuan mountain-pigeon').
ncbi_mult_taxo_gbnm(262124, 'New Zealand pigeon').
ncbi_mult_taxo_gbnm(262125, 'Pacific imperial-pigeon').
ncbi_mult_taxo_gbnm(262126, 'red-knobbed imperial-pigeon').
ncbi_mult_taxo_gbnm(262127, 'island imperial-pigeon').
ncbi_mult_taxo_gbnm(262128, 'emerald-spotted wood-dove').
ncbi_mult_taxo_gbnm(262129, 'Stephan\'s dove').
ncbi_mult_taxo_gbnm(262130, 'African green-pigeon').
ncbi_mult_taxo_gbnm(262136, 'bare-eyed ground-dove').
ncbi_mult_taxo_gbnm(262424, 'Amak Island song sparrow').
ncbi_mult_taxo_gbnm(262425, 'white turtlehead').
ncbi_mult_taxo_gbnm(262426, 'elephant\'s-head lousewort').
ncbi_mult_taxo_gbnm(262431, 'grass miner moths').
ncbi_mult_taxo_gbnm(262452, 'Spanish stopper').
ncbi_mult_taxo_gbnm(262454, 'cherry of the Rio Grande').
ncbi_mult_taxo_gbnm(262619, 'Shumard oak').
ncbi_mult_taxo_gbnm(262624, 'swamp chestnut oak').
ncbi_mult_taxo_gbnm(262649, 'broad-banded swallowtail').
ncbi_mult_taxo_gbnm(262651, 'citrus butterfly').
ncbi_mult_taxo_gbnm(262659, 'noble swallowtail').
ncbi_mult_taxo_gbnm(262661, 'Paris peacock swallowtail').
ncbi_mult_taxo_gbnm(262662, 'regal swallowtail').
ncbi_mult_taxo_gbnm(262664, 'king swallowtail').
ncbi_mult_taxo_gbnm(262753, 'California wax myrtle').
ncbi_mult_taxo_gbnm(262757, 'Chinese bayberry').
ncbi_mult_taxo_gbnm(262770, 'three-spined frogfish').
ncbi_mult_taxo_gbnm(262771, 'specklefin midshipman').
ncbi_mult_taxo_gbnm(262775, 'Desert hedgehog').
ncbi_mult_taxo_gbnm(263140, 'orange wheat blossom midge').
ncbi_mult_taxo_gbnm(263164, 'collared falconet').
ncbi_mult_taxo_gbnm(263372, 'dogbane pyralid moth').
ncbi_mult_taxo_gbnm(263448, 'Wolf\'s monkey').
ncbi_mult_taxo_gbnm(263514, 'white-browed wren').
ncbi_mult_taxo_gbnm(263515, 'Yellow River scaleless carp').
ncbi_mult_taxo_gbnm(263537, 'scaly osman').
ncbi_mult_taxo_gbnm(263653, 'showy sunflax').
ncbi_mult_taxo_gbnm(263669, 'Tellico salamander').
ncbi_mult_taxo_gbnm(263670, 'Chattahoochee slimy salamander').
ncbi_mult_taxo_gbnm(263671, 'red-legged salamander').
ncbi_mult_taxo_gbnm(263672, 'Cheoah bald salamander').
ncbi_mult_taxo_gbnm(263673, 'Kentucky salamander').
ncbi_mult_taxo_gbnm(263674, 'South Mountain gray-cheeked salamander').
ncbi_mult_taxo_gbnm(263684, 'grey reef shark').
ncbi_mult_taxo_gbnm(263685, 'spinner shark').
ncbi_mult_taxo_gbnm(263686, 'blacktip reef shark').
ncbi_mult_taxo_gbnm(263687, 'sickefin lemon shark').
ncbi_mult_taxo_gbnm(263690, 'Japanese catshark').
ncbi_mult_taxo_gbnm(263691, 'longnose catshark').
ncbi_mult_taxo_gbnm(263692, 'longhead catshark').
ncbi_mult_taxo_gbnm(263693, 'black roughscale catshark').
ncbi_mult_taxo_gbnm(263709, 'gecko catshark').
ncbi_mult_taxo_gbnm(263710, 'blacktip sawtail catshark').
ncbi_mult_taxo_gbnm(263716, 'graceful catshark').
ncbi_mult_taxo_gbnm(263718, angelshark).
ncbi_mult_taxo_gbnm(263719, 'little sleeper shark').
ncbi_mult_taxo_gbnm(263737, 'Angolan cobra').
ncbi_mult_taxo_gbnm(263870, redfin).
ncbi_mult_taxo_gbnm(263928, 'willow ermine moth').
ncbi_mult_taxo_gbnm(264149, 'starry toado').
ncbi_mult_taxo_gbnm(264150, 'crowned puffer').
ncbi_mult_taxo_gbnm(264151, 'brown-lined puffer').
ncbi_mult_taxo_gbnm(264210, 'sharptooth jobfish').
ncbi_mult_taxo_gbnm(264213, 'humphead snapper').
ncbi_mult_taxo_gbnm(264216, 'pinjalo snapper').
ncbi_mult_taxo_gbnm(264364, 'emerald coral goby').
ncbi_mult_taxo_gbnm(264485, 'yellow-spotted night lizard').
ncbi_mult_taxo_gbnm(264534, jalap).
ncbi_mult_taxo_gbnm(264540, arracacha).
ncbi_mult_taxo_gbnm(264545, 'Rio Grande silvery minnow').
ncbi_mult_taxo_gbnm(264551, 'Luther\'s spiny loach').
ncbi_mult_taxo_gbnm(264981, 'Christ\'s thorn jujube').
ncbi_mult_taxo_gbnm(265032, 'Shaping frog').
ncbi_mult_taxo_gbnm(265033, 'Nankiang horned toad').
ncbi_mult_taxo_gbnm(265035, 'Xizang alpine toad').
ncbi_mult_taxo_gbnm(265036, 'tiny spadefoot toad').
ncbi_mult_taxo_gbnm(265040, 'Emei moustache toad').
ncbi_mult_taxo_gbnm(265041, 'Chong\'an moustache toad').
ncbi_mult_taxo_gbnm(265042, 'Chinting alpine toad').
ncbi_mult_taxo_gbnm(265044, 'Baoxing toothed toad').
ncbi_mult_taxo_gbnm(265045, 'red-spotted toothed toad').
ncbi_mult_taxo_gbnm(265046, 'Lichuan lazy toad').
ncbi_mult_taxo_gbnm(265360, 'lesser fiery copper').
ncbi_mult_taxo_gbnm(265384, 'turquoise blue').
ncbi_mult_taxo_gbnm(265385, 'false Eros blue').
ncbi_mult_taxo_gbnm(265386, 'common blue').
ncbi_mult_taxo_gbnm(265388, 'Chapman\'s blue').
ncbi_mult_taxo_gbnm(265456, 'onion fly').
ncbi_mult_taxo_gbnm(265457, 'pea midge').
ncbi_mult_taxo_gbnm(265458, 'swede midge').
ncbi_mult_taxo_gbnm(265493, 'Haitian catalpa').
ncbi_mult_taxo_gbnm(265498, 'Ijima copper pheasant').
ncbi_mult_taxo_gbnm(265611, 'European bee-eater').
ncbi_mult_taxo_gbnm(265620, 'cardinal Myzomela').
ncbi_mult_taxo_gbnm(265623, 'white-crested Elaenia').
ncbi_mult_taxo_gbnm(265625, 'pearly-vented tody-tyrant').
ncbi_mult_taxo_gbnm(265627, 'cinereous mourner').
ncbi_mult_taxo_gbnm(265628, 'club-winged manakin').
ncbi_mult_taxo_gbnm(265630, 'dwarf tyrant-manakin').
ncbi_mult_taxo_gbnm(265631, 'chestnut-crowned foliage-gleaner').
ncbi_mult_taxo_gbnm(265632, 'tawny-throated leaftosser').
ncbi_mult_taxo_gbnm(265634, 'common miner').
ncbi_mult_taxo_gbnm(265635, 'grey-bellied spinetail').
ncbi_mult_taxo_gbnm(265636, 'ruddy tree-runner').
ncbi_mult_taxo_gbnm(265638, 'black-throated antshrike').
ncbi_mult_taxo_gbnm(265639, 'white-shouldered fire-eye').
ncbi_mult_taxo_gbnm(265642, 'white-plumed antbird').
ncbi_mult_taxo_gbnm(265643, 'slate-crowned antpitta').
ncbi_mult_taxo_gbnm(265644, 'collared crescent-chest').
ncbi_mult_taxo_gbnm(265717, 'slender chub').
ncbi_mult_taxo_gbnm(265722, 'blotched chub').
ncbi_mult_taxo_gbnm(265731, 'Lesueur\'s wing-gland bat').
ncbi_mult_taxo_gbnm(265733, 'Hairy faced bat').
ncbi_mult_taxo_gbnm(266315, 'Yellow honeyeater').
ncbi_mult_taxo_gbnm(266326, 'Silver-crowned friarbird').
ncbi_mult_taxo_gbnm(266327, 'Helmeted friarbird').
ncbi_mult_taxo_gbnm(266328, 'Little Friarbird').
ncbi_mult_taxo_gbnm(266329, 'Meyer\'s friarbird').
ncbi_mult_taxo_gbnm(266351, 'white-fronted chat').
ncbi_mult_taxo_gbnm(266353, 'yellow chat').
ncbi_mult_taxo_gbnm(266356, 'wattled honeyeater').
ncbi_mult_taxo_gbnm(266365, 'Long-billed honeyeater').
ncbi_mult_taxo_gbnm(266417, 'white-cheeked honeyeater').
ncbi_mult_taxo_gbnm(266418, 'New Holland honeyeater').
ncbi_mult_taxo_gbnm(266498, 'Alvarado\'s salamander').
ncbi_mult_taxo_gbnm(266503, 'Conant\'s mushroomtongue salamander').
ncbi_mult_taxo_gbnm(266506, 'Dunn\'s mushroomtongue salamander').
ncbi_mult_taxo_gbnm(266507, 'yellow-legged mushroomtongue salamander').
ncbi_mult_taxo_gbnm(266509, 'Lincoln\'s mushroomtongue salamander').
ncbi_mult_taxo_gbnm(266515, 'Peru mushroomtongue salamander').
ncbi_mult_taxo_gbnm(266517, 'longnose mushroomtongue salamander').
ncbi_mult_taxo_gbnm(266780, 'Eastern coachwhip').
ncbi_mult_taxo_gbnm(266796, 'Jullien\'s golden carp').
ncbi_mult_taxo_gbnm(266836, 'Thomas\'s pine vole').
ncbi_mult_taxo_gbnm(266946, 'geranium bronze').
ncbi_mult_taxo_gbnm(267067, 'giant Pacific octopus').
ncbi_mult_taxo_gbnm(267130, 'javeline goby').
ncbi_mult_taxo_gbnm(267426, 'Altai snowcock').
ncbi_mult_taxo_gbnm(267427, 'Tibetan snowcock').
ncbi_mult_taxo_gbnm(267835, 'acacia whitefly').
ncbi_mult_taxo_gbnm(267836, 'mulberry whitefly').
ncbi_mult_taxo_gbnm(267839, 'Malabar wart frog').
ncbi_mult_taxo_gbnm(267840, 'Pegu wart frog').
ncbi_mult_taxo_gbnm(267844, 'Malabar fungoid frog').
ncbi_mult_taxo_gbnm(267845, 'small wood frog').
ncbi_mult_taxo_gbnm(267972, 'Crimson seedcracker').
ncbi_mult_taxo_gbnm(267977, 'Pale-headed munia').
ncbi_mult_taxo_gbnm(267978, 'Lesser masked weaver').
ncbi_mult_taxo_gbnm(267979, 'Chestnut bunting').
ncbi_mult_taxo_gbnm(267980, 'Tristram\'s bunting').
ncbi_mult_taxo_gbnm(268283, 'bleeding tooth fungus').
ncbi_mult_taxo_gbnm(268291, 'steppe bison').
ncbi_mult_taxo_gbnm(268476, 'cardinal tetra').
ncbi_mult_taxo_gbnm(268477, 'oneline pencilfish').
ncbi_mult_taxo_gbnm(268490, 'salmon pink birdeater').
ncbi_mult_taxo_gbnm(268499, 'grass moths').
ncbi_mult_taxo_gbnm(268502, 'teak defoliator').
ncbi_mult_taxo_gbnm(268716, 'Amanda\'s blue').
ncbi_mult_taxo_gbnm(268723, 'African finger millet').
ncbi_mult_taxo_gbnm(268751, 'Anderson\'s shrew').
ncbi_mult_taxo_gbnm(268754, 'Horsfield\'s shrew').
ncbi_mult_taxo_gbnm(268755, 'Amami shrew').
ncbi_mult_taxo_gbnm(268758, 'Elegant water shrew').
ncbi_mult_taxo_gbnm(268759, 'Lowe\'s shrew').
ncbi_mult_taxo_gbnm(268760, 'Long-tailed mountain shrew').
ncbi_mult_taxo_gbnm(268767, 'Stripe-backed shrew').
ncbi_mult_taxo_gbnm(268769, 'Saussure\'s shrew').
ncbi_mult_taxo_gbnm(268771, 'Big small-eared shrew').
ncbi_mult_taxo_gbnm(268773, 'Desert shrew').
ncbi_mult_taxo_gbnm(268775, 'Mexican shrew').
ncbi_mult_taxo_gbnm(268857, 'Doederlein\'s cardinalfish').
ncbi_mult_taxo_gbnm(268865, 'black scabbardfish').
ncbi_mult_taxo_gbnm(268869, 'gray pine').
ncbi_mult_taxo_gbnm(268937, 'white-toothed woodrat').
ncbi_mult_taxo_gbnm(269057, 'inland silverside').
ncbi_mult_taxo_gbnm(269058, 'redfin pickerel').
ncbi_mult_taxo_gbnm(269079, 'garden campion').
ncbi_mult_taxo_gbnm(269180, 'red-bellied grackle').
ncbi_mult_taxo_gbnm(269189, 'clawed salamanders').
ncbi_mult_taxo_gbnm(269190, 'crimson rosella').
ncbi_mult_taxo_gbnm(269193, 'Mexican pygmy salamanders').
ncbi_mult_taxo_gbnm(269194, 'arboreal splayfoot salamander').
ncbi_mult_taxo_gbnm(269195, 'gristle-headed splayfoot salamander').
ncbi_mult_taxo_gbnm(269196, 'graceful splayfoot salamander').
ncbi_mult_taxo_gbnm(269197, 'dwarf splayfoot salamander').
ncbi_mult_taxo_gbnm(269198, 'pigmy splayfoot salamander').
ncbi_mult_taxo_gbnm(269199, 'bigfoot splayfoot salamander').
ncbi_mult_taxo_gbnm(269200, 'toothy splayfoot salamander').
ncbi_mult_taxo_gbnm(269202, 'primeval splayfoot salamander').
ncbi_mult_taxo_gbnm(269211, 'terrestrial splayfoot salamander').
ncbi_mult_taxo_gbnm(269271, 'Van Sung\'s shrew').
ncbi_mult_taxo_gbnm(269403, 'lettuce aphid').
ncbi_mult_taxo_gbnm(269412, 'elegant woodcreeper').
ncbi_mult_taxo_gbnm(269452, 'C-O sole').
ncbi_mult_taxo_gbnm(269649, 'European snow vole').
ncbi_mult_taxo_gbnm(269650, 'Robert\'s snow vole').
ncbi_mult_taxo_gbnm(269651, 'Daghestan pine vole').
ncbi_mult_taxo_gbnm(269653, 'Felten\'s vole').
ncbi_mult_taxo_gbnm(269654, 'Gerbe\'s vole').
ncbi_mult_taxo_gbnm(269658, 'social vole').
ncbi_mult_taxo_gbnm(269710, 'red ring nematode').
ncbi_mult_taxo_gbnm(269733, 'big-scaled neusticurus').
ncbi_mult_taxo_gbnm(269744, 'Kizorian\'s lightbulb lizard').
ncbi_mult_taxo_gbnm(270086, 'Georgia satyr').
ncbi_mult_taxo_gbnm(270110, 'scurvy-grass').
ncbi_mult_taxo_gbnm(270252, 'Suwannee river cooter').
ncbi_mult_taxo_gbnm(270329, 'pumpkinseed sunfish').
ncbi_mult_taxo_gbnm(270332, 'spotted sunfish').
ncbi_mult_taxo_gbnm(270333, 'bantam sunfish').
ncbi_mult_taxo_gbnm(270336, 'Coeur d\'Alene salamander').
ncbi_mult_taxo_gbnm(270431, 'tree heath').
ncbi_mult_taxo_gbnm(270432, 'bell-heather').
ncbi_mult_taxo_gbnm(270454, 'common grass blue').
ncbi_mult_taxo_gbnm(270463, 'Asian admiral').
ncbi_mult_taxo_gbnm(270470, 'common five-ring').
ncbi_mult_taxo_gbnm(270475, 'olive-winged bulbul').
ncbi_mult_taxo_gbnm(270476, 'red-eyed bulbul').
ncbi_mult_taxo_gbnm(270477, 'puff-backed bulbul').
ncbi_mult_taxo_gbnm(270500, 'Sierra night lizard').
ncbi_mult_taxo_gbnm(270527, 'ghost pipefish').
ncbi_mult_taxo_gbnm(270530, mandarinfish).
ncbi_mult_taxo_gbnm(270531, 'vermiculated synodontis').
ncbi_mult_taxo_gbnm(270534, 'Celebes rainbow').
ncbi_mult_taxo_gbnm(270537, 'largescale archerfish').
ncbi_mult_taxo_gbnm(270541, 'oceanic lightfish').
ncbi_mult_taxo_gbnm(270544, 'Australian salmon').
ncbi_mult_taxo_gbnm(270546, razorfish).
ncbi_mult_taxo_gbnm(270552, 'pencil cardinal').
ncbi_mult_taxo_gbnm(270556, 'slender hemiodus').
ncbi_mult_taxo_gbnm(270562, 'red tilefish').
ncbi_mult_taxo_gbnm(270568, 'bartail flathead').
ncbi_mult_taxo_gbnm(270572, 'red bigeye').
ncbi_mult_taxo_gbnm(270574, 'fire-tail devil').
ncbi_mult_taxo_gbnm(270578, 'sea goldie').
ncbi_mult_taxo_gbnm(270580, 'flathead sillago').
ncbi_mult_taxo_gbnm(270582, 'longnosed stargazer').
ncbi_mult_taxo_gbnm(270585, 'sharpbeak terapon').
ncbi_mult_taxo_gbnm(270597, 'red-spotted bandfish').
ncbi_mult_taxo_gbnm(270600, 'barred sand burrower').
ncbi_mult_taxo_gbnm(270604, 'giant gourami').
ncbi_mult_taxo_gbnm(270609, 'brownspotted flathead').
ncbi_mult_taxo_gbnm(270661, 'long-rayed sand-diver').
ncbi_mult_taxo_gbnm(270698, 'ashy roundleaf bat').
ncbi_mult_taxo_gbnm(270735, 'fierce roundleaf bat').
ncbi_mult_taxo_gbnm(270764, 'heart-nosed bat').
ncbi_mult_taxo_gbnm(270766, 'hairy slit-faced bat').
ncbi_mult_taxo_gbnm(270768, 'hairless bat').
ncbi_mult_taxo_gbnm(270771, 'black mastiff bat').
ncbi_mult_taxo_gbnm(270772, 'Cuban fig-eating bat').
ncbi_mult_taxo_gbnm(270775, 'hoary wattled bat').
ncbi_mult_taxo_gbnm(270776, 'velvety Myotis').
ncbi_mult_taxo_gbnm(270777, 'Northern long-eared bat').
ncbi_mult_taxo_gbnm(270782, 'Manado fruit bat').
ncbi_mult_taxo_gbnm(270783, 'broad-striped tube-nosed fruit bat').
ncbi_mult_taxo_gbnm(270785, 'unstriped tube-nosed bat').
ncbi_mult_taxo_gbnm(270786, 'Orange leaf-nosed bat').
ncbi_mult_taxo_gbnm(270849, 'Mann\'s ant cricket').
ncbi_mult_taxo_gbnm(270899, 'prey-luring glowworm').
ncbi_mult_taxo_gbnm(271024, 'marbled water frog').
ncbi_mult_taxo_gbnm(271166, pikehead).
ncbi_mult_taxo_gbnm(271171, 'horse gram').
ncbi_mult_taxo_gbnm(271175, 'Oklahoma salamander').
ncbi_mult_taxo_gbnm(271217, 'northern armyworm').
ncbi_mult_taxo_gbnm(271260, 'Indochinese lutung').
ncbi_mult_taxo_gbnm(271451, 'Slowinski\'s corn snake').
ncbi_mult_taxo_gbnm(271501, 'brown Irish lord').
ncbi_mult_taxo_gbnm(271503, 'monkeyface prickleback').
ncbi_mult_taxo_gbnm(271505, 'painted notie').
ncbi_mult_taxo_gbnm(271506, 'yellowfin notothen').
ncbi_mult_taxo_gbnm(271507, 'longtail southern cod').
ncbi_mult_taxo_gbnm(271601, 'Isthmian alligator lizard').
ncbi_mult_taxo_gbnm(271646, 'Sunda water shrew').
ncbi_mult_taxo_gbnm(271939, 'Cape horse mackerel').
ncbi_mult_taxo_gbnm(271940, 'Pacific jack mackerel').
ncbi_mult_taxo_gbnm(271941, 'greenback horse mackerel').
ncbi_mult_taxo_gbnm(271942, 'yellowtail horse mackerel').
ncbi_mult_taxo_gbnm(272001, 'white-necked raven').
ncbi_mult_taxo_gbnm(272047, 'rufous-necked stint').
ncbi_mult_taxo_gbnm(272050, 'spotted redshank').
ncbi_mult_taxo_gbnm(272059, 'black phantom tetra').
ncbi_mult_taxo_gbnm(272066, 'emperor tetra').
ncbi_mult_taxo_gbnm(272067, 'bleeding-heart tetra').
ncbi_mult_taxo_gbnm(272069, 'redeye tetra').
ncbi_mult_taxo_gbnm(272071, 'brown cockchafer').
ncbi_mult_taxo_gbnm(272187, 'tomato frog').
ncbi_mult_taxo_gbnm(272190, 'corrugated water frog').
ncbi_mult_taxo_gbnm(272192, 'Mediterranean treefrog').
ncbi_mult_taxo_gbnm(272214, 'Ginkgo-toothed beaked whale').
ncbi_mult_taxo_gbnm(272250, 'Marshall\'s stumptail chameleon').
ncbi_mult_taxo_gbnm(272253, 'Boulengers pygmy chameleon').
ncbi_mult_taxo_gbnm(272254, 'Mount Mulanje pygmy chameleon').
ncbi_mult_taxo_gbnm(272255, 'Chapmans pygmy chameleon').
ncbi_mult_taxo_gbnm(272460, 'yellow-bellied weasel').
ncbi_mult_taxo_gbnm(272540, 'peak tree iguana').
ncbi_mult_taxo_gbnm(272619, 'Rory Cooper\'s false Antechinus').
ncbi_mult_taxo_gbnm(272628, 'small skipper').
ncbi_mult_taxo_gbnm(272722, 'golden julie').
ncbi_mult_taxo_gbnm(272752, 'Brazilian Amazonian armed spider').
ncbi_mult_taxo_gbnm(272785, 'vermiculated angelfish').
ncbi_mult_taxo_gbnm(272786, 'French angelfish').
ncbi_mult_taxo_gbnm(272787, 'arabian angelfish').
ncbi_mult_taxo_gbnm(272788, 'king angelfish').
ncbi_mult_taxo_gbnm(272790, 'eastern footballer').
ncbi_mult_taxo_gbnm(272792, 'Lord Howe Island butterflyfish').
ncbi_mult_taxo_gbnm(272797, 'rock beauty').
ncbi_mult_taxo_gbnm(272798, 'Bermuda blue angelfish').
ncbi_mult_taxo_gbnm(272799, 'Gaisler\'s long-eared bat').
ncbi_mult_taxo_gbnm(272801, 'Cortez angelfish').
ncbi_mult_taxo_gbnm(272804, 'Fernando Po batis').
ncbi_mult_taxo_gbnm(272806, 'black-and-white shrike-flycatcher').
ncbi_mult_taxo_gbnm(272816, 'sulphur-breasted bushshrike').
ncbi_mult_taxo_gbnm(272818, 'black-fronted bushshrike').
ncbi_mult_taxo_gbnm(272821, 'marsh tchagra').
ncbi_mult_taxo_gbnm(272830, 'black-necked wattle-eye').
ncbi_mult_taxo_gbnm(272832, 'slate-colored boubou').
ncbi_mult_taxo_gbnm(272835, chatshrike).
ncbi_mult_taxo_gbnm(272836, 'grey-headed bushshrike').
ncbi_mult_taxo_gbnm(272837, 'African shrike-flycatcher').
ncbi_mult_taxo_gbnm(272839, brubru).
ncbi_mult_taxo_gbnm(272840, 'Retz\'s helmet-shrike').
ncbi_mult_taxo_gbnm(272841, 'chestnut-fronted helmet-shrike').
ncbi_mult_taxo_gbnm(272848, 'Ward\'s shrike-flycatcher').
ncbi_mult_taxo_gbnm(272849, 'brown-crowned tchagra').
ncbi_mult_taxo_gbnm(272850, 'black-crowned tchagra').
ncbi_mult_taxo_gbnm(272867, 'Bokmakierie bushshrike').
ncbi_mult_taxo_gbnm(272902, 'rosy-patched bushshrike').
ncbi_mult_taxo_gbnm(273455, 'John\'s snapper').
ncbi_mult_taxo_gbnm(273489, 'red siskin').
ncbi_mult_taxo_gbnm(273589, 'queen sugarbush').
ncbi_mult_taxo_gbnm(273620, boradllo).
ncbi_mult_taxo_gbnm(273650, 'rice root aphid').
ncbi_mult_taxo_gbnm(273653, 'Alpine Punjab skink').
ncbi_mult_taxo_gbnm(273679, 'spotted spreadwing').
ncbi_mult_taxo_gbnm(273748, 'blue king crab').
ncbi_mult_taxo_gbnm(273761, 'red-bellied marsupial shrew').
ncbi_mult_taxo_gbnm(273789, 'Celebes wild boar').
ncbi_mult_taxo_gbnm(273791, 'red river hog').
ncbi_mult_taxo_gbnm(273792, bushpig).
ncbi_mult_taxo_gbnm(273921, 'desert pygmy mouse').
ncbi_mult_taxo_gbnm(273922, 'Hausa mouse').
ncbi_mult_taxo_gbnm(274059, 'olive-headed lorikeet').
ncbi_mult_taxo_gbnm(274060, 'red lory').
ncbi_mult_taxo_gbnm(274061, 'violet-necked lori').
ncbi_mult_taxo_gbnm(274062, 'black-capped lory').
ncbi_mult_taxo_gbnm(274063, 'yellow-throated hanging-parrot').
ncbi_mult_taxo_gbnm(274064, 'yellow-streked lory').
ncbi_mult_taxo_gbnm(274065, 'black lory').
ncbi_mult_taxo_gbnm(274066, 'Duivenbode\'s lory').
ncbi_mult_taxo_gbnm(274068, 'red-winged parrot').
ncbi_mult_taxo_gbnm(274070, 'large fig-parrot').
ncbi_mult_taxo_gbnm(274071, 'Edward\'s fig-parrot').
ncbi_mult_taxo_gbnm(274073, 'blue-backed parrot').
ncbi_mult_taxo_gbnm(274074, 'little corella').
ncbi_mult_taxo_gbnm(274332, 'Java speedwell').
ncbi_mult_taxo_gbnm(274454, 'golden ponyfish').
ncbi_mult_taxo_gbnm(274455, 'orangefin ponyfish').
ncbi_mult_taxo_gbnm(274456, 'striped ponyfish').
ncbi_mult_taxo_gbnm(274457, 'Jones\' pony fish').
ncbi_mult_taxo_gbnm(274459, 'whipfin ponyfish').
ncbi_mult_taxo_gbnm(274460, 'Panay ponyfish').
ncbi_mult_taxo_gbnm(274461, 'splendid ponyfish').
ncbi_mult_taxo_gbnm(274463, mojarras).
ncbi_mult_taxo_gbnm(274467, 'whipfin silverbiddy').
ncbi_mult_taxo_gbnm(274469, 'whitefin trevally').
ncbi_mult_taxo_gbnm(274521, 'Tanzania banana frog').
ncbi_mult_taxo_gbnm(274522, 'African banana frog').
ncbi_mult_taxo_gbnm(274524, 'African striped frog').
ncbi_mult_taxo_gbnm(274527, 'Usambara big-fingered frog').
ncbi_mult_taxo_gbnm(274528, 'Uluguru big-fingered frog').
ncbi_mult_taxo_gbnm(274597, 'Bombay locust').
ncbi_mult_taxo_gbnm(274602, 'Sunda warbler').
ncbi_mult_taxo_gbnm(274603, 'white-spectacled warbler').
ncbi_mult_taxo_gbnm(274604, 'yellow-vented warbler').
ncbi_mult_taxo_gbnm(274605, 'sulphur-breasted warbler').
ncbi_mult_taxo_gbnm(274606, 'Carolina locust').
ncbi_mult_taxo_gbnm(274609, 'birdwing grasshopper').
ncbi_mult_taxo_gbnm(274611, 'green bird grasshopper').
ncbi_mult_taxo_gbnm(274613, 'Central American locust').
ncbi_mult_taxo_gbnm(274614, 'South American locust').
ncbi_mult_taxo_gbnm(274616, 'rosemary grasshopper').
ncbi_mult_taxo_gbnm(274617, 'painted locust').
ncbi_mult_taxo_gbnm(274618, 'small painted locust').
ncbi_mult_taxo_gbnm(274621, 'yellow-streaked warbler').
ncbi_mult_taxo_gbnm(274622, 'Whistler\'s warbler').
ncbi_mult_taxo_gbnm(274623, 'Bianchi\'s warbler').
ncbi_mult_taxo_gbnm(274624, 'grey-crowned warbler').
ncbi_mult_taxo_gbnm(274628, 'Emei Shan warbler').
ncbi_mult_taxo_gbnm(274629, 'plain-tailed warbler').
ncbi_mult_taxo_gbnm(274630, 'chestnut-crowned warbler').
ncbi_mult_taxo_gbnm(274642, 'Japanese swamp shrimp').
ncbi_mult_taxo_gbnm(274686, 'Hainan hare').
ncbi_mult_taxo_gbnm(274688, 'spotted cusk-eel').
ncbi_mult_taxo_gbnm(274695, 'Atlantic thornyhead').
ncbi_mult_taxo_gbnm(274699, barbfish).
ncbi_mult_taxo_gbnm(274700, 'spotted scorpionfish').
ncbi_mult_taxo_gbnm(274702, 'pygmy scorpionfish').
ncbi_mult_taxo_gbnm(274714, 'channeled rockfish').
ncbi_mult_taxo_gbnm(274724, horsefish).
ncbi_mult_taxo_gbnm(274728, 'spotted coral croucher').
ncbi_mult_taxo_gbnm(274731, 'Pacific reef bass').
ncbi_mult_taxo_gbnm(274732, 'slender searobin').
ncbi_mult_taxo_gbnm(274736, 'red flathead').
ncbi_mult_taxo_gbnm(274738, 'dwarf flathead').
ncbi_mult_taxo_gbnm(274739, 'sand flathead').
ncbi_mult_taxo_gbnm(274740, 'lemon ghost flathead').
ncbi_mult_taxo_gbnm(274741, 'kelp greenling').
ncbi_mult_taxo_gbnm(274743, 'shortspine combfish').
ncbi_mult_taxo_gbnm(274758, 'padded sculpin').
ncbi_mult_taxo_gbnm(274759, 'yellow Irish lord').
ncbi_mult_taxo_gbnm(274760, 'longfin Irish lord').
ncbi_mult_taxo_gbnm(274762, 'threadfin sculpin').
ncbi_mult_taxo_gbnm(274768, 'slim sculpin').
ncbi_mult_taxo_gbnm(274770, 'spectacled sculpin').
ncbi_mult_taxo_gbnm(274772, 'eyeshade sculpin').
ncbi_mult_taxo_gbnm(274777, 'sawback poacher').
ncbi_mult_taxo_gbnm(274781, 'pallid sculpin').
ncbi_mult_taxo_gbnm(274783, 'spinyhead sculpin').
ncbi_mult_taxo_gbnm(274785, 'blacktail snailfish').
ncbi_mult_taxo_gbnm(274786, 'slimy snailfish').
ncbi_mult_taxo_gbnm(274791, 'longtail bass').
ncbi_mult_taxo_gbnm(274792, 'eastern flower porgy').
ncbi_mult_taxo_gbnm(274800, 'royal gramma').
ncbi_mult_taxo_gbnm(274802, 'purple sand tilefish').
ncbi_mult_taxo_gbnm(274803, 'rock flagtail').
ncbi_mult_taxo_gbnm(274804, 'giant hawkfish').
ncbi_mult_taxo_gbnm(274808, searcher).
ncbi_mult_taxo_gbnm(274811, 'spotted grubfish').
ncbi_mult_taxo_gbnm(274812, 'porehead blenny').
ncbi_mult_taxo_gbnm(274817, 'Penang betta').
ncbi_mult_taxo_gbnm(274825, 'spine-tailed seasnake').
ncbi_mult_taxo_gbnm(276759, 'masked shrike').
ncbi_mult_taxo_gbnm(276763, 'long-tailed shrike').
ncbi_mult_taxo_gbnm(276764, 'rufous-tailed shrike').
ncbi_mult_taxo_gbnm(277992, mushifugu).
ncbi_mult_taxo_gbnm(277993, 'shosai-fugu').
ncbi_mult_taxo_gbnm(278031, 'Carolina wolf spider').
ncbi_mult_taxo_gbnm(278110, celeriac).
ncbi_mult_taxo_gbnm(278164, 'allis shad').
ncbi_mult_taxo_gbnm(278165, 'twaite shad').
ncbi_mult_taxo_gbnm(278166, 'golden Chinese loach').
ncbi_mult_taxo_gbnm(278186, 'white-lined gecko').
ncbi_mult_taxo_gbnm(278672, 'common comfrey').
ncbi_mult_taxo_gbnm(278729, 'whitemouth croaker').
ncbi_mult_taxo_gbnm(278734, 'southern kingcroaker').
ncbi_mult_taxo_gbnm(278736, 'Gulf kingcroaker').
ncbi_mult_taxo_gbnm(278766, 'acoupa weakfish').
ncbi_mult_taxo_gbnm(278767, 'green weakfish').
ncbi_mult_taxo_gbnm(278768, 'smallscale weakfish').
ncbi_mult_taxo_gbnm(278770, 'smooth weakfish').
ncbi_mult_taxo_gbnm(278773, 'rake stardrum').
ncbi_mult_taxo_gbnm(278774, 'smalleye stardrum').
ncbi_mult_taxo_gbnm(278775, 'little croaker').
ncbi_mult_taxo_gbnm(278853, 'flameback angelfish').
ncbi_mult_taxo_gbnm(278971, 'red sand frog').
ncbi_mult_taxo_gbnm(279083, 'deepsea squid').
ncbi_mult_taxo_gbnm(279094, 'Japanese spineless cuttlefish').
ncbi_mult_taxo_gbnm(279181, 'Ridley\'s roundleaf bat').
ncbi_mult_taxo_gbnm(279182, 'Dayak roundleaf bat').
ncbi_mult_taxo_gbnm(279183, 'Cox\'s roundleaf bat').
ncbi_mult_taxo_gbnm(279184, 'dusky roundleaf bat').
ncbi_mult_taxo_gbnm(279219, birdflower).
ncbi_mult_taxo_gbnm(279220, 'Brazilian tulipwood').
ncbi_mult_taxo_gbnm(279438, spongeflies).
ncbi_mult_taxo_gbnm(279441, dustywings).
ncbi_mult_taxo_gbnm(279467, 'pleasing lacewings').
ncbi_mult_taxo_gbnm(279482, spoonwings).
ncbi_mult_taxo_gbnm(279537, 'dwarf blackbelly salamander').
ncbi_mult_taxo_gbnm(279541, 'chicli spinetail').
ncbi_mult_taxo_gbnm(279543, 'blackish Cinclodes').
ncbi_mult_taxo_gbnm(279544, 'royal Cinclodes').
ncbi_mult_taxo_gbnm(279545, 'white-winged Cinclodes').
ncbi_mult_taxo_gbnm(279546, 'Cordoba Cinclodes').
ncbi_mult_taxo_gbnm(279547, 'stout-billed Cinclodes').
ncbi_mult_taxo_gbnm(279548, 'bar-winged Cinclodes').
ncbi_mult_taxo_gbnm(279549, 'seaside Cinclodes').
ncbi_mult_taxo_gbnm(279550, 'Olrogi\'s Cinclodes').
ncbi_mult_taxo_gbnm(279551, 'grey-flanked Cinclodes').
ncbi_mult_taxo_gbnm(279552, 'long-tailed Cinclodes').
ncbi_mult_taxo_gbnm(279553, 'white-bellied Cinclodes').
ncbi_mult_taxo_gbnm(279554, 'dark-bellied Cinclodes').
ncbi_mult_taxo_gbnm(279555, 'surf Cinclodes').
ncbi_mult_taxo_gbnm(279557, 'buff-breasted earthcreeper').
ncbi_mult_taxo_gbnm(279927, 'common myna').
ncbi_mult_taxo_gbnm(279928, 'American pipit').
ncbi_mult_taxo_gbnm(279931, 'black turnstone').
ncbi_mult_taxo_gbnm(279933, 'upland sandpiper').
ncbi_mult_taxo_gbnm(279934, bufflehead).
ncbi_mult_taxo_gbnm(279935, 'least sandpiper').
ncbi_mult_taxo_gbnm(279937, 'Baird\'s sandpiper').
ncbi_mult_taxo_gbnm(279938, 'stilt sandpiper').
ncbi_mult_taxo_gbnm(279940, 'white-rumped sandpiper').
ncbi_mult_taxo_gbnm(279941, 'western sandpiper').
ncbi_mult_taxo_gbnm(279942, 'piping plover').
ncbi_mult_taxo_gbnm(279943, 'Wilson\'s plover').
ncbi_mult_taxo_gbnm(279945, 'black tern').
ncbi_mult_taxo_gbnm(279948, 'black oystercatcher').
ncbi_mult_taxo_gbnm(279949, 'shortbilled dowitcher').
ncbi_mult_taxo_gbnm(279952, 'red phalarope').
ncbi_mult_taxo_gbnm(279953, 'arctic tern').
ncbi_mult_taxo_gbnm(279954, 'solitary sandpiper').
ncbi_mult_taxo_gbnm(279957, 'long-billed curlew').
ncbi_mult_taxo_gbnm(279958, 'black-crested titmouse').
ncbi_mult_taxo_gbnm(279959, 'king rail').
ncbi_mult_taxo_gbnm(279960, 'American oystercatcher').
ncbi_mult_taxo_gbnm(279961, 'semipalmated sandpiper').
ncbi_mult_taxo_gbnm(279962, 'red-headed woodpecker').
ncbi_mult_taxo_gbnm(279964, 'prairie falcon').
ncbi_mult_taxo_gbnm(279965, 'chuck-will\'s-widow').
ncbi_mult_taxo_gbnm(279966, 'Northern wheatear').
ncbi_mult_taxo_gbnm(279967, 'Northwestern crow').
ncbi_mult_taxo_gbnm(279969, 'American three-toed woodpecker').
ncbi_mult_taxo_gbnm(279976, 'Cyprian honeybee').
ncbi_mult_taxo_gbnm(279977, 'Syrian honeybee').
ncbi_mult_taxo_gbnm(279978, 'mountain brook frogs').
ncbi_mult_taxo_gbnm(279980, 'Cayenne slender-legged treefrog').
ncbi_mult_taxo_gbnm(279982, 'Mexican treefrog').
ncbi_mult_taxo_gbnm(279983, 'lime treefrogs').
ncbi_mult_taxo_gbnm(279984, 'Orinoco lime treefrog').
ncbi_mult_taxo_gbnm(279985, 'spotted treefrog').
ncbi_mult_taxo_gbnm(279987, 'armed treefrog').
ncbi_mult_taxo_gbnm(279988, 'Paranapiacaba treefrog').
ncbi_mult_taxo_gbnm(279989, 'Yungas treefrog').
ncbi_mult_taxo_gbnm(279990, 'Bischoff\'s treefrog').
ncbi_mult_taxo_gbnm(279992, 'Espirito Santo treefrog').
ncbi_mult_taxo_gbnm(279995, 'blacksmith treefrog').
ncbi_mult_taxo_gbnm(279996, 'Gunther\'s banded treefrog').
ncbi_mult_taxo_gbnm(279999, 'Atlantic forest treefrog').
ncbi_mult_taxo_gbnm(280002, 'Mundo Novo treefrog').
ncbi_mult_taxo_gbnm(280003, 'dwarf treefrog').
ncbi_mult_taxo_gbnm(280005, 'Montevideo treefrog').
ncbi_mult_taxo_gbnm(280008, 'speckled treefrog').
ncbi_mult_taxo_gbnm(280046, 'Syrian serin').
ncbi_mult_taxo_gbnm(280090, 'common shorebug').
ncbi_mult_taxo_gbnm(280160, 'Uta Hick\'s bearded saki').
ncbi_mult_taxo_gbnm(280234, 'mountain spadefoot toad').
ncbi_mult_taxo_gbnm(280462, 'grey-headed social-weaver').
ncbi_mult_taxo_gbnm(280486, 'European beewolf').
ncbi_mult_taxo_gbnm(280597, 'Indian moon moth').
ncbi_mult_taxo_gbnm(280670, 'Australian blacktip shark').
ncbi_mult_taxo_gbnm(280671, 'spottail shark').
ncbi_mult_taxo_gbnm(280673, 'brown dottyback').
ncbi_mult_taxo_gbnm(280674, 'Marshall Islands dottyback').
ncbi_mult_taxo_gbnm(280777, 'spot-tail').
ncbi_mult_taxo_gbnm(280779, 'striped robber').
ncbi_mult_taxo_gbnm(280780, 'Okavango robber').
ncbi_mult_taxo_gbnm(281253, 'arrow cichlid').
ncbi_mult_taxo_gbnm(281410, 'Caucasian Agama').
ncbi_mult_taxo_gbnm(281676, 'mailed butterflyfish').
ncbi_mult_taxo_gbnm(281677, 'oval butterflyfish').
ncbi_mult_taxo_gbnm(281678, 'Tahiti butterflyfish').
ncbi_mult_taxo_gbnm(281679, 'teardrop butterflyfish').
ncbi_mult_taxo_gbnm(281732, 'orange puffball sponge').
ncbi_mult_taxo_gbnm(281914, 'Lesser vasa parrot').
ncbi_mult_taxo_gbnm(281916, 'Meyer\'s parrot').
ncbi_mult_taxo_gbnm(282008, 'Spanish chalk-hill blue').
ncbi_mult_taxo_gbnm(282043, 'Escher\'s blue').
ncbi_mult_taxo_gbnm(282068, 'Gansu leaf warbler').
ncbi_mult_taxo_gbnm(282069, 'La Touche\'s leaf-warbler').
ncbi_mult_taxo_gbnm(282254, 'multicolored dottyback').
ncbi_mult_taxo_gbnm(282260, 'Anderson\'s salamander').
ncbi_mult_taxo_gbnm(282261, 'Lake Patzcuaro salamander').
ncbi_mult_taxo_gbnm(282282, 'sixgill stingray').
ncbi_mult_taxo_gbnm(282316, 'African grass blue').
ncbi_mult_taxo_gbnm(282318, 'Lang\'s short-tailed blue').
ncbi_mult_taxo_gbnm(282319, 'false ilex hairstreak').
ncbi_mult_taxo_gbnm(282341, 'Clarke\'s vole').
ncbi_mult_taxo_gbnm(282342, 'yellow-bellied glider').
ncbi_mult_taxo_gbnm(282377, 'purple-shot copper').
ncbi_mult_taxo_gbnm(282380, 'false baton blue').
ncbi_mult_taxo_gbnm(282382, 'Osiris blue').
ncbi_mult_taxo_gbnm(282384, 'odd-spot blue').
ncbi_mult_taxo_gbnm(282386, 'grass jewel').
ncbi_mult_taxo_gbnm(282391, 'common copper').
ncbi_mult_taxo_gbnm(282395, 'scarce copper').
ncbi_mult_taxo_gbnm(282396, 'fiery copper').
ncbi_mult_taxo_gbnm(282397, 'Eros blue').
ncbi_mult_taxo_gbnm(282497, 'Loveridge\'s sunbird').
ncbi_mult_taxo_gbnm(282498, 'Eastern double-collared sunbird').
ncbi_mult_taxo_gbnm(282499, 'Moreau\'s sunbird').
ncbi_mult_taxo_gbnm(282500, 'greater double-collared sunbird').
ncbi_mult_taxo_gbnm(282501, 'Southern double-collared sunbird').
ncbi_mult_taxo_gbnm(282503, 'Cameroon double-collared sunbird').
ncbi_mult_taxo_gbnm(283024, 'black prickleback').
ncbi_mult_taxo_gbnm(283027, 'tidepool gunnel').
ncbi_mult_taxo_gbnm(283028, 'saddleback gunnel').
ncbi_mult_taxo_gbnm(283029, 'striped gunnel').
ncbi_mult_taxo_gbnm(283031, 'rock stickleback').
ncbi_mult_taxo_gbnm(283034, sauger).
ncbi_mult_taxo_gbnm(283035, pikeperch).
ncbi_mult_taxo_gbnm(283036, walleye).
ncbi_mult_taxo_gbnm(283133, katuk).
ncbi_mult_taxo_gbnm(283159, 'black-necked aracari').
ncbi_mult_taxo_gbnm(283160, 'red-necked aracari').
ncbi_mult_taxo_gbnm(283161, 'collared aracari').
ncbi_mult_taxo_gbnm(283162, 'yellow-ridged toucan').
ncbi_mult_taxo_gbnm(283213, 'Java spadefoot toad').
ncbi_mult_taxo_gbnm(283215, 'Mount Omei spadefoot toad').
ncbi_mult_taxo_gbnm(283217, 'narrow-mouthed horned toad').
ncbi_mult_taxo_gbnm(283348, 'Chernov\'s skink').
ncbi_mult_taxo_gbnm(283367, 'crescent gunnel').
ncbi_mult_taxo_gbnm(283372, 'spineless cuttlefish').
ncbi_mult_taxo_gbnm(283373, 'Japanese flyingfish').
ncbi_mult_taxo_gbnm(283379, 'white-ear scalyfin').
ncbi_mult_taxo_gbnm(283491, 'large fruit-eating bat').
ncbi_mult_taxo_gbnm(283497, 'green finger sponge').
ncbi_mult_taxo_gbnm(283616, 'rock greenling').
ncbi_mult_taxo_gbnm(283624, 'coralline sculpin').
ncbi_mult_taxo_gbnm(283633, 'bald sculpin').
ncbi_mult_taxo_gbnm(283636, 'grunt sculpin').
ncbi_mult_taxo_gbnm(283834, 'elephant hawk-moth').
ncbi_mult_taxo_gbnm(283837, 'small verdant hawk').
ncbi_mult_taxo_gbnm(283843, 'bedstraw hawk-moth').
ncbi_mult_taxo_gbnm(283844, 'striped hawk-moth').
ncbi_mult_taxo_gbnm(283846, 'Mediterranean hawk-moth').
ncbi_mult_taxo_gbnm(283849, 'seathorn hawk-moth').
ncbi_mult_taxo_gbnm(283855, 'spurge hawk-moth').
ncbi_mult_taxo_gbnm(283869, 'common striped hawk').
ncbi_mult_taxo_gbnm(283870, 'silver-striped hawk-moth').
ncbi_mult_taxo_gbnm(283925, 'longhorn cactus beetle').
ncbi_mult_taxo_gbnm(284021, 'hairy-necked tiger beetle').
ncbi_mult_taxo_gbnm(284022, 'Formosan salamander').
ncbi_mult_taxo_gbnm(284147, 'Macquarie parakeet').
ncbi_mult_taxo_gbnm(284148, 'buff-faced pygmy parrot').
ncbi_mult_taxo_gbnm(284149, 'little lorikeet').
ncbi_mult_taxo_gbnm(284363, 'Himalayan rhubarb').
ncbi_mult_taxo_gbnm(284379, 'strawberry rootworm').
ncbi_mult_taxo_gbnm(284439, 'Bunyoro rabbit').
ncbi_mult_taxo_gbnm(284517, 'Tete veld rat').
ncbi_mult_taxo_gbnm(284573, 'Moller\'s gulf frog').
ncbi_mult_taxo_gbnm(284576, 'palm forest treefrog').
ncbi_mult_taxo_gbnm(284583, 'Chinese sleeper').
ncbi_mult_taxo_gbnm(284669, 'Northern smooth-tailed tree shrew').
ncbi_mult_taxo_gbnm(284671, 'desert kangaroo rat').
ncbi_mult_taxo_gbnm(284674, 'bog birch').
ncbi_mult_taxo_gbnm(284732, 'redstriped eartheater').
ncbi_mult_taxo_gbnm(284753, 'threespot eartheater').
ncbi_mult_taxo_gbnm(284754, 'pantanal eartheater').
ncbi_mult_taxo_gbnm(285003, 'pale-mandibled aracari').
ncbi_mult_taxo_gbnm(285008, 'brown-mandibled aracari').
ncbi_mult_taxo_gbnm(285009, 'many-banded aracari').
ncbi_mult_taxo_gbnm(285010, 'stripe-billed aracari').
ncbi_mult_taxo_gbnm(285011, 'green aracari').
ncbi_mult_taxo_gbnm(285027, 'Gobi khulan').
ncbi_mult_taxo_gbnm(285092, 'Andringitra bright-eyed frog').
ncbi_mult_taxo_gbnm(285093, 'Andringitra Madagascar frog').
ncbi_mult_taxo_gbnm(285098, 'elegant Madagascar frog').
ncbi_mult_taxo_gbnm(285223, 'orchid beetle').
ncbi_mult_taxo_gbnm(285227, 'fulvous-vented Euphonia').
ncbi_mult_taxo_gbnm(285229, 'Vulturine parrot').
ncbi_mult_taxo_gbnm(285230, 'Orange-cheeked parrot').
ncbi_mult_taxo_gbnm(285231, 'Caica parrot').
ncbi_mult_taxo_gbnm(285233, 'Pileated parrot').
ncbi_mult_taxo_gbnm(285234, 'Rose-faced parrot').
ncbi_mult_taxo_gbnm(285239, 'olivaceous siskin').
ncbi_mult_taxo_gbnm(285242, 'Lawrence\'s goldfinch').
ncbi_mult_taxo_gbnm(285259, 'pollack louse').
ncbi_mult_taxo_gbnm(285953, 'ebony salmonfly').
ncbi_mult_taxo_gbnm(285987, 'armored pricklenape').
ncbi_mult_taxo_gbnm(285992, 'Speckled padloper').
ncbi_mult_taxo_gbnm(285996, 'common padloper').
ncbi_mult_taxo_gbnm(285997, 'Donner-weer tortoise').
ncbi_mult_taxo_gbnm(285998, 'Karroo tortoise').
ncbi_mult_taxo_gbnm(286002, 'Mexican gopher tortoise').
ncbi_mult_taxo_gbnm(286003, 'Texas gopher tortoise').
ncbi_mult_taxo_gbnm(286004, 'Bells hingeback tortoise').
ncbi_mult_taxo_gbnm(286005, 'Homes hingeback tortoise').
ncbi_mult_taxo_gbnm(286013, 'geometric tortoise').
ncbi_mult_taxo_gbnm(286014, 'tent tortoise').
ncbi_mult_taxo_gbnm(286016, 'Nama padloper').
ncbi_mult_taxo_gbnm(286019, 'Burmese star tortoise').
ncbi_mult_taxo_gbnm(286023, 'serrated tortoise').
ncbi_mult_taxo_gbnm(286024, 'Speks hinged-back tortoise').
ncbi_mult_taxo_gbnm(286025, 'Natal hingeback tortoise').
ncbi_mult_taxo_gbnm(286090, 'Andreas\' racer').
ncbi_mult_taxo_gbnm(286097, 'warty toad').
ncbi_mult_taxo_gbnm(286129, 'Mulga parrot').
ncbi_mult_taxo_gbnm(286131, 'Himalayan Mole').
ncbi_mult_taxo_gbnm(286419, dingo).
ncbi_mult_taxo_gbnm(286459, 'marmalade hoverfly').
ncbi_mult_taxo_gbnm(286537, 'Osbeck\'s grenadier anchovy').
ncbi_mult_taxo_gbnm(286572, 'flavescent peacock cichlid').
ncbi_mult_taxo_gbnm(286583, 'royal blue hap').
ncbi_mult_taxo_gbnm(286692, palila).
ncbi_mult_taxo_gbnm(286706, 'brown marmorated stink bug').
ncbi_mult_taxo_gbnm(286707, 'shield bug').
ncbi_mult_taxo_gbnm(286717, 'Bolle\'s pigeon').
ncbi_mult_taxo_gbnm(286718, 'white-tailed laurel pigeon').
ncbi_mult_taxo_gbnm(286724, 'Mallee ringneck').
ncbi_mult_taxo_gbnm(286788, 'gilled lungfish').
ncbi_mult_taxo_gbnm(287016, 'brown-hooded gull').
ncbi_mult_taxo_gbnm(287017, 'African grey-headed gull').
ncbi_mult_taxo_gbnm(287038, 'juniper titmouse').
ncbi_mult_taxo_gbnm(287131, 'flannel moths').
ncbi_mult_taxo_gbnm(287132, 'Mediterranean burnet moths').
ncbi_mult_taxo_gbnm(287134, 'Mediterranean flannel moths').
ncbi_mult_taxo_gbnm(287164, 'long-tailed burnet moths').
ncbi_mult_taxo_gbnm(287168, 'mountain leaf warbler').
ncbi_mult_taxo_gbnm(287171, 'Emei leaf-Warbler').
ncbi_mult_taxo_gbnm(287172, 'Goodsoni warbler').
ncbi_mult_taxo_gbnm(287173, 'island leaf warbler').
ncbi_mult_taxo_gbnm(287174, 'Hainan leaf-warbler').
ncbi_mult_taxo_gbnm(287175, 'Timor leaf warbler').
ncbi_mult_taxo_gbnm(287176, 'Sulawesi leaf-warbler').
ncbi_mult_taxo_gbnm(287182, 'tropical burnet moths').
ncbi_mult_taxo_gbnm(287704, 'sculptured sea catfish').
ncbi_mult_taxo_gbnm(287705, 'flathead sea catfish').
ncbi_mult_taxo_gbnm(287709, 'softhead sea catfish').
ncbi_mult_taxo_gbnm(287710, 'Chili sea catfish').
ncbi_mult_taxo_gbnm(287712, 'Thomas sea catfish').
ncbi_mult_taxo_gbnm(287713, 'Coco sea catfish').
ncbi_mult_taxo_gbnm(287714, 'threadfin sea catfish').
ncbi_mult_taxo_gbnm(287979, 'salamander-tree').
ncbi_mult_taxo_gbnm(288045, 'Checker-throated antwren').
ncbi_mult_taxo_gbnm(288050, 'tufted antshrike').
ncbi_mult_taxo_gbnm(288100, 'spot-winged antbird').
ncbi_mult_taxo_gbnm(288138, 'yellowcheek wrasse').
ncbi_mult_taxo_gbnm(288313, 'Chinese salamander').
ncbi_mult_taxo_gbnm(288315, 'Siberian salamander').
ncbi_mult_taxo_gbnm(288317, 'Shangcheng stout salamander').
ncbi_mult_taxo_gbnm(288420, 'Spiny-tailed gecko').
ncbi_mult_taxo_gbnm(288444, balku).
ncbi_mult_taxo_gbnm(288514, 'savannah clawed frog').
ncbi_mult_taxo_gbnm(288517, 'Bouchia clawed frog').
ncbi_mult_taxo_gbnm(288519, 'Andre\'s clawed frog').
ncbi_mult_taxo_gbnm(288522, 'Witte\'s clawed frog').
ncbi_mult_taxo_gbnm(288534, 'upland clawed frog').
ncbi_mult_taxo_gbnm(288535, 'false Fraser\'s clawed frog').
ncbi_mult_taxo_gbnm(288550, 'Mawa clawed frog').
ncbi_mult_taxo_gbnm(288555, 'Peter\'s clawed frog').
ncbi_mult_taxo_gbnm(288556, 'Lake Victoria clawed frog').
ncbi_mult_taxo_gbnm(288646, 'Hawaiian reef lobster').
ncbi_mult_taxo_gbnm(288788, 'cannibal frogs').
ncbi_mult_taxo_gbnm(288796, 'Puerto Hondo stream salamander').
ncbi_mult_taxo_gbnm(288797, 'Japanese clawed salamander').
ncbi_mult_taxo_gbnm(289056, 'ruddy copper').
ncbi_mult_taxo_gbnm(289186, 'resplendent quetzal').
ncbi_mult_taxo_gbnm(289189, 'olivaceous bulbul').
ncbi_mult_taxo_gbnm(289190, 'Seychelles bulbul').
ncbi_mult_taxo_gbnm(289191, 'Comoro bulbul').
ncbi_mult_taxo_gbnm(289198, 'Xavier\'s greenbul').
ncbi_mult_taxo_gbnm(289199, 'yellow-wattled bulbul').
ncbi_mult_taxo_gbnm(289200, 'Mauritius bulbul').
ncbi_mult_taxo_gbnm(289202, 'Boulenger\'s climbing frog').
ncbi_mult_taxo_gbnm(289203, 'whistling treefrogs').
ncbi_mult_taxo_gbnm(289204, 'burrowing frogs').
ncbi_mult_taxo_gbnm(289205, 'Nosy Be burrowing frog').
ncbi_mult_taxo_gbnm(289217, 'ocellated digging frog').
ncbi_mult_taxo_gbnm(289218, 'Betampona digging frog').
ncbi_mult_taxo_gbnm(289219, 'Betsileo digging frog').
ncbi_mult_taxo_gbnm(289220, 'interior digging frog').
ncbi_mult_taxo_gbnm(289221, 'Malagasy climbing rain frog').
ncbi_mult_taxo_gbnm(289222, 'Boulenger\'s digging frog').
ncbi_mult_taxo_gbnm(289226, 'Madagascar stump-toed frog').
ncbi_mult_taxo_gbnm(289227, 'Andoany stump-toed frog').
ncbi_mult_taxo_gbnm(289228, 'Benavony stump-toed frog').
ncbi_mult_taxo_gbnm(289242, 'flat-footed fly').
ncbi_mult_taxo_gbnm(289281, 'garden tiger moth').
ncbi_mult_taxo_gbnm(289381, 'poison toadfishes').
ncbi_mult_taxo_gbnm(289398, 'row pore rope sponge').
ncbi_mult_taxo_gbnm(289401, 'scattered pore rope sponge').
ncbi_mult_taxo_gbnm(289491, 'Bear Lodge meadow jumping mouse').
ncbi_mult_taxo_gbnm(289774, 'poison sumac').
ncbi_mult_taxo_gbnm(290102, 'sawtooth eel').
ncbi_mult_taxo_gbnm(290104, 'geographic wrasse').
ncbi_mult_taxo_gbnm(290105, 'floral wrasse').
ncbi_mult_taxo_gbnm(290113, 'tripletail wrasse').
ncbi_mult_taxo_gbnm(290115, 'bluelined wrasse').
ncbi_mult_taxo_gbnm(290155, 'potato/tomato psyllid').
ncbi_mult_taxo_gbnm(290247, 'Pacific red snapper').
ncbi_mult_taxo_gbnm(290412, 'common hover fly').
ncbi_mult_taxo_gbnm(290501, 'northern red-legged frog').
ncbi_mult_taxo_gbnm(290503, 'California red-legged frog').
ncbi_mult_taxo_gbnm(290511, 'blotched tiger salamander').
ncbi_mult_taxo_gbnm(290562, 'Hispaniolan funnel-eared bat').
ncbi_mult_taxo_gbnm(290563, 'Jamaican funnel-eared bat').
ncbi_mult_taxo_gbnm(290564, 'Mexican funnel-eared bat').
ncbi_mult_taxo_gbnm(290597, 'silvery-brown bare-face tamarin').
ncbi_mult_taxo_gbnm(290627, 'Sakhalin sculpin').
ncbi_mult_taxo_gbnm(290630, 'roughskin sculpin').
ncbi_mult_taxo_gbnm(290669, 'red-breasted carrion beetle').
ncbi_mult_taxo_gbnm(290737, 'imbricate alligator lizard').
ncbi_mult_taxo_gbnm(290741, 'Oaxaca alligator lizard').
ncbi_mult_taxo_gbnm(290923, 'showy balloonvine').
ncbi_mult_taxo_gbnm(291113, 'Day\'s grass mouse').
ncbi_mult_taxo_gbnm(291114, 'Budin\'s grass mouse').
ncbi_mult_taxo_gbnm(291115, 'smoky grass mouse').
ncbi_mult_taxo_gbnm(291251, 'Asiatic hard clam').
ncbi_mult_taxo_gbnm(291259, 'Crossley\'s dwarf lemur').
ncbi_mult_taxo_gbnm(291263, 'many-lined salamander').
ncbi_mult_taxo_gbnm(291264, 'southern torrent salamander').
ncbi_mult_taxo_gbnm(291265, 'four-toed salamander').
ncbi_mult_taxo_gbnm(291285, elepaio).
ncbi_mult_taxo_gbnm(291301, 'Manavi long-fingered bat').
ncbi_mult_taxo_gbnm(291354, 'Schomburgk\'s deer').
ncbi_mult_taxo_gbnm(291362, 'yellow finned medaka').
ncbi_mult_taxo_gbnm(291688, 'common branded skipper').
ncbi_mult_taxo_gbnm(291689, 'jagged-border skipper').
ncbi_mult_taxo_gbnm(291690, 'lost-egg skipper').
ncbi_mult_taxo_gbnm(291691, 'Nevada skipper').
ncbi_mult_taxo_gbnm(291693, 'Columbia skipper').
ncbi_mult_taxo_gbnm(291695, 'sandhill skipper').
ncbi_mult_taxo_gbnm(291814, 'spotted steed').
ncbi_mult_taxo_gbnm(291815, 'Siberian dace').
ncbi_mult_taxo_gbnm(291816, 'Mongolian redfin').
ncbi_mult_taxo_gbnm(291939, 'fragile wart frog').
ncbi_mult_taxo_gbnm(291940, 'wild jack').
ncbi_mult_taxo_gbnm(291970, 'black-and-chestnut eagle').
ncbi_mult_taxo_gbnm(291982, 'queen conch').
ncbi_mult_taxo_gbnm(292051, 'Sarato\'s goby').
ncbi_mult_taxo_gbnm(292130, 'red-chested buttonquail').
ncbi_mult_taxo_gbnm(292133, 'barred buttonquail').
ncbi_mult_taxo_gbnm(292210, 'black-hooded oriole').
ncbi_mult_taxo_gbnm(292223, 'Scott Bar salamander').
ncbi_mult_taxo_gbnm(292239, 'corn mint').
ncbi_mult_taxo_gbnm(292309, 'Argentine stem weevil').
ncbi_mult_taxo_gbnm(292385, 'shea tree').
ncbi_mult_taxo_gbnm(292417, 'blackmouth angler').
ncbi_mult_taxo_gbnm(292500, 'transparent lantern fish').
ncbi_mult_taxo_gbnm(292503, 'bamboo worm').
ncbi_mult_taxo_gbnm(292571, 'burnet companion').
ncbi_mult_taxo_gbnm(292710, 'Key thatch palm').
ncbi_mult_taxo_gbnm(292815, 'Tibetan juniper').
ncbi_mult_taxo_gbnm(292820, 'scale-backed antbird').
ncbi_mult_taxo_gbnm(292826, 'Santarem antbird').
ncbi_mult_taxo_gbnm(292832, 'Smith\'s African water snake').
ncbi_mult_taxo_gbnm(292838, 'Hallowell\'s house snake').
ncbi_mult_taxo_gbnm(292841, 'St. Johann\'s tree snake').
ncbi_mult_taxo_gbnm(292850, 'Small-eyed file snake').
ncbi_mult_taxo_gbnm(292851, 'Cape wolf snake').
ncbi_mult_taxo_gbnm(292863, 'Eastern Montpellier snake').
ncbi_mult_taxo_gbnm(292866, 'Blandings tree snake').
ncbi_mult_taxo_gbnm(292868, 'olive house snake').
ncbi_mult_taxo_gbnm(292869, 'Western forest file snake').
ncbi_mult_taxo_gbnm(292892, 'yellow-bellied house snake').
ncbi_mult_taxo_gbnm(292903, 'Black-headed ground snake').
ncbi_mult_taxo_gbnm(292905, 'Guenther\'s black snake').
ncbi_mult_taxo_gbnm(292919, dodders).
ncbi_mult_taxo_gbnm(293146, 'white cheek goby').
ncbi_mult_taxo_gbnm(293341, 'lesser appleworm').
ncbi_mult_taxo_gbnm(293345, 'cherry fruitworm').
ncbi_mult_taxo_gbnm(293688, 'Egyptian honeybee').
ncbi_mult_taxo_gbnm(293692, 'Cape honeybee').
ncbi_mult_taxo_gbnm(293818, 'little Celebes cuscus').
ncbi_mult_taxo_gbnm(293821, 'brown-marbled grouper').
ncbi_mult_taxo_gbnm(293823, 'highfin grouper').
ncbi_mult_taxo_gbnm(293900, 'Buffon\'s river-garfish').
ncbi_mult_taxo_gbnm(293902, 'bigwing halfbeak').
ncbi_mult_taxo_gbnm(293903, 'banded flyingfish').
ncbi_mult_taxo_gbnm(293905, 'tringa flyingfish').
ncbi_mult_taxo_gbnm(293907, 'babel flyingish').
ncbi_mult_taxo_gbnm(293909, 'blackspot flyingfish').
ncbi_mult_taxo_gbnm(293911, 'sharpchin flyingfish').
ncbi_mult_taxo_gbnm(293913, 'ribbon halfbeak').
ncbi_mult_taxo_gbnm(293914, 'stained flyingfish').
ncbi_mult_taxo_gbnm(293916, 'Cape needlefish').
ncbi_mult_taxo_gbnm(293917, 'Japanese halfbeak').
ncbi_mult_taxo_gbnm(293919, saury).
ncbi_mult_taxo_gbnm(293920, 'blackbarred halfbeak').
ncbi_mult_taxo_gbnm(293957, 'Persian wonder Gecko').
ncbi_mult_taxo_gbnm(293978, 'Iranian firefly').
ncbi_mult_taxo_gbnm(294359, 'Coban mushroomtongue salamander').
ncbi_mult_taxo_gbnm(294360, 'garden slender salamander').
ncbi_mult_taxo_gbnm(294361, 'one-toed salamander').
ncbi_mult_taxo_gbnm(294362, 'Columbia torrent salamander').
ncbi_mult_taxo_gbnm(294366, 'dwarf sirens').
ncbi_mult_taxo_gbnm(294368, 'clouded salamander').
ncbi_mult_taxo_gbnm(294372, 'whistling treefrog').
ncbi_mult_taxo_gbnm(294374, 'Ambatoharanana giant treefrog').
ncbi_mult_taxo_gbnm(294377, 'Japanese photinia').
ncbi_mult_taxo_gbnm(294648, 'Scott\'s mouse-eared bat').
ncbi_mult_taxo_gbnm(294649, 'Mandelli\'s mouse-eared bat').
ncbi_mult_taxo_gbnm(294650, 'de Winton\'s long-eared bat').
ncbi_mult_taxo_gbnm(294733, 'Canada mint').
ncbi_mult_taxo_gbnm(294741, 'native pennyroyal').
ncbi_mult_taxo_gbnm(294742, 'cerulean warbler').
ncbi_mult_taxo_gbnm(294743, 'Grace\'s warbler').
ncbi_mult_taxo_gbnm(294758, 'Idaho giant salamander').
ncbi_mult_taxo_gbnm(294783, 'spined oak borer').
ncbi_mult_taxo_gbnm(295201, 'alder spittlebug').
ncbi_mult_taxo_gbnm(295202, 'pine spittlebug').
ncbi_mult_taxo_gbnm(295203, 'diamond-backed spittlebug').
ncbi_mult_taxo_gbnm(295286, 'hairy cicada').
ncbi_mult_taxo_gbnm(295399, bata).
ncbi_mult_taxo_gbnm(295400, 'Kuria labeo').
ncbi_mult_taxo_gbnm(295546, 'patent leather beetle').
ncbi_mult_taxo_gbnm(295656, 'drugstore beetle').
ncbi_mult_taxo_gbnm(295660, 'cigarette beetle').
ncbi_mult_taxo_gbnm(295669, 'variegated carpet beetle').
ncbi_mult_taxo_gbnm(295809, 'short-wingedflower beetles').
ncbi_mult_taxo_gbnm(295813, 'hieroglyphic ladybird').
ncbi_mult_taxo_gbnm(295815, '24-pointed ladybird beetle').
ncbi_mult_taxo_gbnm(295918, 'root-eating beetles').
ncbi_mult_taxo_gbnm(295945, 'ship timber beetles').
ncbi_mult_taxo_gbnm(295947, 'large timberworm').
ncbi_mult_taxo_gbnm(296036, emblic).
ncbi_mult_taxo_gbnm(296129, 'reticulated velvet gecko').
ncbi_mult_taxo_gbnm(296133, 'giant wood-rail').
ncbi_mult_taxo_gbnm(296138, 'brown moray').
ncbi_mult_taxo_gbnm(296553, keppi).
ncbi_mult_taxo_gbnm(296554, fissi).
ncbi_mult_taxo_gbnm(296555, 'blackfin tilapia').
ncbi_mult_taxo_gbnm(296559, mongo).
ncbi_mult_taxo_gbnm(296719, 'red pineapple').
ncbi_mult_taxo_gbnm(296741, 'lance-tailed manakin').
ncbi_mult_taxo_gbnm(297253, 'Azores noctule').
ncbi_mult_taxo_gbnm(297284, beefalo).
ncbi_mult_taxo_gbnm(297387, 'Greater guinea pig').
ncbi_mult_taxo_gbnm(297513, 'Kosogol grayling').
ncbi_mult_taxo_gbnm(297527, shadeskink).
ncbi_mult_taxo_gbnm(297528, 'weasel skink').
ncbi_mult_taxo_gbnm(297709, 'orange-bellied trogon').
ncbi_mult_taxo_gbnm(297710, 'slaty-tailed trogon').
ncbi_mult_taxo_gbnm(297711, 'Suruca trogon').
ncbi_mult_taxo_gbnm(297712, 'scarlet-rumped trogon').
ncbi_mult_taxo_gbnm(297714, 'cinnamon-rumped trogon').
ncbi_mult_taxo_gbnm(297715, 'red-headed trogon').
ncbi_mult_taxo_gbnm(297716, 'Hisspaniolan trogon').
ncbi_mult_taxo_gbnm(297798, 'Bonga shad').
ncbi_mult_taxo_gbnm(297802, 'brown noddy').
ncbi_mult_taxo_gbnm(297803, 'lesser noddy').
ncbi_mult_taxo_gbnm(297805, 'whiskered tern').
ncbi_mult_taxo_gbnm(297806, 'white-winged tern').
ncbi_mult_taxo_gbnm(297809, 'common white-tern').
ncbi_mult_taxo_gbnm(297811, 'Inca tern').
ncbi_mult_taxo_gbnm(297813, 'large-billed tern').
ncbi_mult_taxo_gbnm(297814, 'black-fronted tern').
ncbi_mult_taxo_gbnm(297817, 'Elegant tern').
ncbi_mult_taxo_gbnm(297819, 'Forster\'s tern').
ncbi_mult_taxo_gbnm(297824, 'white-fronted tern').
ncbi_mult_taxo_gbnm(297825, 'black-naped tern').
ncbi_mult_taxo_gbnm(297827, 'snowy-crowned tern').
ncbi_mult_taxo_gbnm(297828, 'Antarctic tern').
ncbi_mult_taxo_gbnm(298109, 'Horsfield\'s fruit bat').
ncbi_mult_taxo_gbnm(298110, 'Temminck\'s tailless fruit bat').
ncbi_mult_taxo_gbnm(298326, 'black noddy').
ncbi_mult_taxo_gbnm(298345, 'Japanese black-footed albatross').
ncbi_mult_taxo_gbnm(298348, 'Eaton\'s skate').
ncbi_mult_taxo_gbnm(298395, 'pickerel frog').
ncbi_mult_taxo_gbnm(298404, 'citrus whitefly').
ncbi_mult_taxo_gbnm(298411, 'striped hog-nosed skunk').
ncbi_mult_taxo_gbnm(298412, 'Beddard\'s olingo').
ncbi_mult_taxo_gbnm(298644, azarole).
ncbi_mult_taxo_gbnm(298661, 'Sicilian sumac').
ncbi_mult_taxo_gbnm(298662, 'smooth sumac').
ncbi_mult_taxo_gbnm(298678, 'African sumac').
ncbi_mult_taxo_gbnm(298703, 'carinate pillsnail').
ncbi_mult_taxo_gbnm(298831, 'Kirtland\'s warbler').
ncbi_mult_taxo_gbnm(298880, 'lesser Egyptian gerbil').
ncbi_mult_taxo_gbnm(298881, 'Baluchistan gerbil').
ncbi_mult_taxo_gbnm(298882, 'greater Egyptian gerbil').
ncbi_mult_taxo_gbnm(298884, 'bushy-tailed jird').
ncbi_mult_taxo_gbnm(298885, 'king jird').
ncbi_mult_taxo_gbnm(298886, 'Libyan jird').
ncbi_mult_taxo_gbnm(298887, 'Sundeval\'s jird').
ncbi_mult_taxo_gbnm(298888, 'Sahel gerbil').
ncbi_mult_taxo_gbnm(298889, 'Senegal gerbil').
ncbi_mult_taxo_gbnm(298890, 'slender gerbil').
ncbi_mult_taxo_gbnm(298892, 'pouched gerbil').
ncbi_mult_taxo_gbnm(298894, 'fat-tailed gerbil').
ncbi_mult_taxo_gbnm(298896, 'Cape short-eared gerbil').
ncbi_mult_taxo_gbnm(298983, 'brown woodland-warbler').
ncbi_mult_taxo_gbnm(298994, 'grey-cheeked warbler').
ncbi_mult_taxo_gbnm(298996, 'gray-hooded warbler').
ncbi_mult_taxo_gbnm(298999, 'Ijima\'s leaf-warbler').
ncbi_mult_taxo_gbnm(299120, 'red tilapia').
ncbi_mult_taxo_gbnm(299240, 'main tree iguana').
ncbi_mult_taxo_gbnm(299252, 'tea seed bug').
ncbi_mult_taxo_gbnm(299257, 'bean plataspid').
ncbi_mult_taxo_gbnm(299317, 'naked shellear').
ncbi_mult_taxo_gbnm(299321, 'denticle herring').
ncbi_mult_taxo_gbnm(299642, 'giant wood spider').
ncbi_mult_taxo_gbnm(299648, 'highland frog').
ncbi_mult_taxo_gbnm(299649, 'Rancho Redondo frog').
ncbi_mult_taxo_gbnm(299651, 'Rio Chipillico frog').
ncbi_mult_taxo_gbnm(299662, 'Vaillant\'s frog').
ncbi_mult_taxo_gbnm(299663, 'Maya Mountains frog').
ncbi_mult_taxo_gbnm(299666, 'Tarahumara frog').
ncbi_mult_taxo_gbnm(299667, 'Zweifel\'s frog').
ncbi_mult_taxo_gbnm(299668, 'Mexican Cascade frog').
ncbi_mult_taxo_gbnm(299679, 'Patzcuaro frog').
ncbi_mult_taxo_gbnm(299680, 'Montezuma leopard frog').
ncbi_mult_taxo_gbnm(299683, 'dusky gopher frog').
ncbi_mult_taxo_gbnm(299684, 'Florida gopher frog').
ncbi_mult_taxo_gbnm(299685, 'Tlaloc\'s leopard frog').
ncbi_mult_taxo_gbnm(299686, 'Guerreran leopard frog').
ncbi_mult_taxo_gbnm(299688, 'Guatemala plateau frog').
ncbi_mult_taxo_gbnm(299689, 'Peralta frog').
ncbi_mult_taxo_gbnm(299715, 'Hora danio').
ncbi_mult_taxo_gbnm(299716, 'Hikari danio').
ncbi_mult_taxo_gbnm(299721, 'French honeysuckle').
ncbi_mult_taxo_gbnm(299727, 'Dahl\'s olive treefrog').
ncbi_mult_taxo_gbnm(299895, 'desert ant').
ncbi_mult_taxo_gbnm(299898, 'desert ant').
ncbi_mult_taxo_gbnm(300161, 'golden angwantibo').
ncbi_mult_taxo_gbnm(300163, 'gray slender loris').
ncbi_mult_taxo_gbnm(300212, 'black dhup').
ncbi_mult_taxo_gbnm(300214, 'incense tree').
ncbi_mult_taxo_gbnm(300221, 'white-spotted puffer').
ncbi_mult_taxo_gbnm(300222, 'narrow-lined puffer').
ncbi_mult_taxo_gbnm(300223, 'map puffer').
ncbi_mult_taxo_gbnm(300224, 'blackspotted puffer').
ncbi_mult_taxo_gbnm(300227, 'threetooth puffer').
ncbi_mult_taxo_gbnm(300230, 'milkspotted puffer').
ncbi_mult_taxo_gbnm(300243, 'highland rain frog').
ncbi_mult_taxo_gbnm(300298, 'Bleher\'s rainbowfish').
ncbi_mult_taxo_gbnm(300299, 'estuarine hardyhead').
ncbi_mult_taxo_gbnm(300302, 'Panama silverside').
ncbi_mult_taxo_gbnm(300304, 'brook silverside').
ncbi_mult_taxo_gbnm(300354, 'hairy groundcherry').
ncbi_mult_taxo_gbnm(300413, 'kelp grouper').
ncbi_mult_taxo_gbnm(300415, 'yellow-edged lyretail').
ncbi_mult_taxo_gbnm(300417, 'alligator pipefish').
ncbi_mult_taxo_gbnm(300539, 'mata lembu').
ncbi_mult_taxo_gbnm(300627, 'marbled polecat').
ncbi_mult_taxo_gbnm(300741, 'upland bully').
ncbi_mult_taxo_gbnm(300877, 'Amur leopard cat').
ncbi_mult_taxo_gbnm(300940, 'Sichuan leaf-warbler').
ncbi_mult_taxo_gbnm(301031, 'raspberry clearwing').
ncbi_mult_taxo_gbnm(301036, 'red-tipped clearwing').
ncbi_mult_taxo_gbnm(301037, 'six-belted clearwing').
ncbi_mult_taxo_gbnm(301041, 'fiery clearwing').
ncbi_mult_taxo_gbnm(301146, 'Yarkand hare').
ncbi_mult_taxo_gbnm(301158, 'Philippine pygmy fruit bat').
ncbi_mult_taxo_gbnm(301161, 'Bavius blue').
ncbi_mult_taxo_gbnm(301164, 'dotted blue').
ncbi_mult_taxo_gbnm(301165, 'silvery blue').
ncbi_mult_taxo_gbnm(301166, 'square-spotted blue').
ncbi_mult_taxo_gbnm(301168, 'Iolas blue').
ncbi_mult_taxo_gbnm(301169, 'baton blue').
ncbi_mult_taxo_gbnm(301177, 'chequered blue').
ncbi_mult_taxo_gbnm(301270, 'obscure pufferfish').
ncbi_mult_taxo_gbnm(301284, 'Glencoe tandan').
ncbi_mult_taxo_gbnm(301299, 'Atacama toad').
ncbi_mult_taxo_gbnm(301481, 'redstem stork\'s bill').
ncbi_mult_taxo_gbnm(301542, 'Darwin\'s rhea').
ncbi_mult_taxo_gbnm(301543, 'mistle thrush').
ncbi_mult_taxo_gbnm(301547, 'Bismarck giant rat').
ncbi_mult_taxo_gbnm(301601, 'little chachalaca').
ncbi_mult_taxo_gbnm(301602, 'white-bellied chachalaca').
ncbi_mult_taxo_gbnm(301603, 'chestnut-winged chachalaca').
ncbi_mult_taxo_gbnm(301604, 'rufous-vented chachalaca').
ncbi_mult_taxo_gbnm(301607, 'black guan').
ncbi_mult_taxo_gbnm(301609, 'Andean guan').
ncbi_mult_taxo_gbnm(301610, 'band-tailed guan').
ncbi_mult_taxo_gbnm(301693, sweetsop).
ncbi_mult_taxo_gbnm(301699, biriba).
ncbi_mult_taxo_gbnm(301701, 'West mexican chachalaca').
ncbi_mult_taxo_gbnm(301703, 'pond apple').
ncbi_mult_taxo_gbnm(301819, 'California smoothtongue').
ncbi_mult_taxo_gbnm(301840, 'tiny scaled gecko').
ncbi_mult_taxo_gbnm(301843, 'Cape dwarf gecko').
ncbi_mult_taxo_gbnm(301862, 'bullock\'s heart').
ncbi_mult_taxo_gbnm(301915, 'apricot angel\'s trumpet').
ncbi_mult_taxo_gbnm(301986, 'Iberian magpie').
ncbi_mult_taxo_gbnm(301992, 'bay woodpecker').
ncbi_mult_taxo_gbnm(302014, 'Big Hachet woodland snail').
ncbi_mult_taxo_gbnm(302046, 'rough pomfret').
ncbi_mult_taxo_gbnm(302047, 'yellowtail amberjack').
ncbi_mult_taxo_gbnm(302049, 'oceanic whitetip shark').
ncbi_mult_taxo_gbnm(302051, medusafish).
ncbi_mult_taxo_gbnm(302054, 'orangethroat pikeblenny').
ncbi_mult_taxo_gbnm(302055, 'Pacific viperfish').
ncbi_mult_taxo_gbnm(302092, 'dark bush-cricket').
ncbi_mult_taxo_gbnm(302098, 'North Pacific right whale').
ncbi_mult_taxo_gbnm(302395, 'Mauritian tomb bat').
ncbi_mult_taxo_gbnm(302397, 'flower-faced bat').
ncbi_mult_taxo_gbnm(302400, 'Percival\'s trident bat').
ncbi_mult_taxo_gbnm(302402, 'Sundevall\'s roundleaf bat').
ncbi_mult_taxo_gbnm(302404, 'Javan slit-faced bat').
ncbi_mult_taxo_gbnm(302407, 'Little epauletted fruit-bat').
ncbi_mult_taxo_gbnm(302408, 'Cape horseshoe bat').
ncbi_mult_taxo_gbnm(302410, 'Rueppell\'s horseshoe bat').
ncbi_mult_taxo_gbnm(302411, 'Hildebrandt\'s horseshoe bat').
ncbi_mult_taxo_gbnm(302412, 'Egyptian free-tailed bat').
ncbi_mult_taxo_gbnm(302413, 'LaVal\'s disk-winged bat').
ncbi_mult_taxo_gbnm(302418, 'ground pangolin').
ncbi_mult_taxo_gbnm(302422, 'Colorado hairstreak').
ncbi_mult_taxo_gbnm(302525, 'double-banded sandgrouse').
ncbi_mult_taxo_gbnm(302527, 'Pallas\'s sandgrouse').
ncbi_mult_taxo_gbnm(302528, 'Eastern yellow-billed hornbill').
ncbi_mult_taxo_gbnm(302529, 'yellow-tailed black-cockatoo').
ncbi_mult_taxo_gbnm(302531, 'crocodile bird').
ncbi_mult_taxo_gbnm(302532, 'Andean lapwing').
ncbi_mult_taxo_gbnm(302533, 'white-faced ibis').
ncbi_mult_taxo_gbnm(302535, 'yellow rail').
ncbi_mult_taxo_gbnm(302536, 'dark-winged trumpeter').
ncbi_mult_taxo_gbnm(302537, 'Wyoming toad').
ncbi_mult_taxo_gbnm(302538, 'Houston toad').
ncbi_mult_taxo_gbnm(302539, 'East Texas toad').
ncbi_mult_taxo_gbnm(302540, 'Canadian toad').
ncbi_mult_taxo_gbnm(302541, 'arroyo toad').
ncbi_mult_taxo_gbnm(302542, 'Amargosa toad').
ncbi_mult_taxo_gbnm(302543, 'Jalapa toad').
ncbi_mult_taxo_gbnm(302544, 'marbled toad').
ncbi_mult_taxo_gbnm(302545, 'dwarf toad').
ncbi_mult_taxo_gbnm(302546, 'dark green toad').
ncbi_mult_taxo_gbnm(302547, 'pine toad').
ncbi_mult_taxo_gbnm(302548, 'striped toad').
ncbi_mult_taxo_gbnm(302550, 'graceful dwarf frog').
ncbi_mult_taxo_gbnm(302765, 'sheepshead porgy').
ncbi_mult_taxo_gbnm(302767, comet).
ncbi_mult_taxo_gbnm(302768, 'spotted ctenopoma').
ncbi_mult_taxo_gbnm(302777, 'Malayan leaffish').
ncbi_mult_taxo_gbnm(303001, 'swamp barb').
ncbi_mult_taxo_gbnm(303005, 'Bandula barb').
ncbi_mult_taxo_gbnm(303008, 'black ruby barb').
ncbi_mult_taxo_gbnm(303010, 'two spot barb').
ncbi_mult_taxo_gbnm(303022, 'long snouted barb').
ncbi_mult_taxo_gbnm(303025, 'blackspot barb').
ncbi_mult_taxo_gbnm(303027, 'Martenstyn\'s barb').
ncbi_mult_taxo_gbnm(303028, 'black lined barb').
ncbi_mult_taxo_gbnm(303032, 'blotched filamented barb').
ncbi_mult_taxo_gbnm(303038, 'greenstripe barb').
ncbi_mult_taxo_gbnm(303126, 'common Atlantic grenadier').
ncbi_mult_taxo_gbnm(303127, 'smalltooth grenadier').
ncbi_mult_taxo_gbnm(303186, joturo).
ncbi_mult_taxo_gbnm(303235, 'plains minnow').
ncbi_mult_taxo_gbnm(303304, 'Blue-throated macaw').
ncbi_mult_taxo_gbnm(303307, 'brown dog-faced bat').
ncbi_mult_taxo_gbnm(303348, 'Bald parrot').
ncbi_mult_taxo_gbnm(303350, 'Saffron-headed parrot').
ncbi_mult_taxo_gbnm(303353, 'Brown-hooded parrot').
ncbi_mult_taxo_gbnm(303588, 'Campbell\'s monkey').
ncbi_mult_taxo_gbnm(303685, 'grey triggerfish').
ncbi_mult_taxo_gbnm(303686, 'finescale triggerfish').
ncbi_mult_taxo_gbnm(303687, 'queen triggerfish').
ncbi_mult_taxo_gbnm(303689, 'clown triggerfish').
ncbi_mult_taxo_gbnm(303691, 'spotted oceanic triggerfish').
ncbi_mult_taxo_gbnm(303695, 'yellow-spotted triggerfish').
ncbi_mult_taxo_gbnm(303696, 'Picasso triggerfish').
ncbi_mult_taxo_gbnm(303701, 'guilded triggerfish').
ncbi_mult_taxo_gbnm(303704, 'boomerang triggerfish').
ncbi_mult_taxo_gbnm(303705, 'titan triggerfish').
ncbi_mult_taxo_gbnm(303708, 'deepwater burrfish').
ncbi_mult_taxo_gbnm(303710, 'scrawled filefish').
ncbi_mult_taxo_gbnm(303712, 'whitespotted filefish').
ncbi_mult_taxo_gbnm(303713, 'orangespotted filefish').
ncbi_mult_taxo_gbnm(303715, 'fringed filefish').
ncbi_mult_taxo_gbnm(303718, 'blacksaddle filefish').
ncbi_mult_taxo_gbnm(303720, 'pigmy leatherjacket').
ncbi_mult_taxo_gbnm(303724, 'harlequin filefish').
ncbi_mult_taxo_gbnm(303726, 'Chinaman-leatherjacket').
ncbi_mult_taxo_gbnm(303728, 'spotted trunkfish').
ncbi_mult_taxo_gbnm(303729, 'honeycomb cowfish').
ncbi_mult_taxo_gbnm(303734, 'eastern smooth boxfish').
ncbi_mult_taxo_gbnm(303739, 'ornate cowfish').
ncbi_mult_taxo_gbnm(303740, 'Caribbean sharpnose-puffer').
ncbi_mult_taxo_gbnm(303741, 'bandtail puffer').
ncbi_mult_taxo_gbnm(303742, 'spider-eye puffer').
ncbi_mult_taxo_gbnm(303743, 'spotted sharpnose').
ncbi_mult_taxo_gbnm(303744, 'Bennett\'s sharpnose puffer').
ncbi_mult_taxo_gbnm(303746, 'smooth toadfish').
ncbi_mult_taxo_gbnm(303748, 'weeping toado').
ncbi_mult_taxo_gbnm(303751, 'Darwin toadfish').
ncbi_mult_taxo_gbnm(303755, 'honeycomb toby').
ncbi_mult_taxo_gbnm(303874, 'thick-billed seedeater').
ncbi_mult_taxo_gbnm(303877, 'Florida woods cockroach').
ncbi_mult_taxo_gbnm(303921, 'sand smelt').
ncbi_mult_taxo_gbnm(303926, 'black-clawed brush-furred rat').
ncbi_mult_taxo_gbnm(303930, 'giant eland').
ncbi_mult_taxo_gbnm(303931, 'bigeye sixgill shark').
ncbi_mult_taxo_gbnm(303932, 'blacknose shark').
ncbi_mult_taxo_gbnm(303933, 'bignose shark').
ncbi_mult_taxo_gbnm(303934, 'finetooth shark').
ncbi_mult_taxo_gbnm(303935, 'Caribbean reef shark').
ncbi_mult_taxo_gbnm(303943, 'night shark').
ncbi_mult_taxo_gbnm(303944, 'narrowfin smooth-hound').
ncbi_mult_taxo_gbnm(303945, 'Atlantic sharpnose shark').
ncbi_mult_taxo_gbnm(303946, 'sand devil').
ncbi_mult_taxo_gbnm(303960, 'web-foot frog').
ncbi_mult_taxo_gbnm(303964, 'Antsouhy tomato frog').
ncbi_mult_taxo_gbnm(303967, 'striped headstander').
ncbi_mult_taxo_gbnm(303968, 'smallscale pike characins').
ncbi_mult_taxo_gbnm(303973, silversides).
ncbi_mult_taxo_gbnm(303978, 'Niger tetra').
ncbi_mult_taxo_gbnm(303981, 'nurse tetra').
ncbi_mult_taxo_gbnm(303991, 'moon fish').
ncbi_mult_taxo_gbnm(303992, 'Tucan fish').
ncbi_mult_taxo_gbnm(303993, 'darter characin').
ncbi_mult_taxo_gbnm(303996, 'spotted headstander').
ncbi_mult_taxo_gbnm(304002, 'sharktail distichodus').
ncbi_mult_taxo_gbnm(304003, 'longsnout distichodus').
ncbi_mult_taxo_gbnm(304005, 'bucktooth tetra').
ncbi_mult_taxo_gbnm(304009, 'tiger-fish').
ncbi_mult_taxo_gbnm(304011, 'yellowtail tetra').
ncbi_mult_taxo_gbnm(304017, 'jewel tetra').
ncbi_mult_taxo_gbnm(304018, 'glowlight tetra').
ncbi_mult_taxo_gbnm(304019, 'elongate tigerfish').
ncbi_mult_taxo_gbnm(304020, 'giant tigerfish').
ncbi_mult_taxo_gbnm(304042, 'royal tetra').
ncbi_mult_taxo_gbnm(304065, 'golden pencilfish').
ncbi_mult_taxo_gbnm(304070, 'barred pencilfish').
ncbi_mult_taxo_gbnm(304217, tigerfish).
ncbi_mult_taxo_gbnm(304257, 'black-blotched porcupinefish').
ncbi_mult_taxo_gbnm(304258, 'woolly sculpin').
ncbi_mult_taxo_gbnm(304259, 'rough sculpin').
ncbi_mult_taxo_gbnm(304265, 'Paiute sculpin').
ncbi_mult_taxo_gbnm(304271, 'shorthead sculpin').
ncbi_mult_taxo_gbnm(304272, 'Bear Lake sculpin').
ncbi_mult_taxo_gbnm(304274, 'Potomac sculpin').
ncbi_mult_taxo_gbnm(304276, 'riffle sculpin').
ncbi_mult_taxo_gbnm(304278, 'marbled sculpin').
ncbi_mult_taxo_gbnm(304282, 'Wood River sculpin').
ncbi_mult_taxo_gbnm(304283, 'margined sculpin').
ncbi_mult_taxo_gbnm(304284, 'pygmy sculpin').
ncbi_mult_taxo_gbnm(304285, 'pit sculpin').
ncbi_mult_taxo_gbnm(304287, 'Klamath Lake sculpin').
ncbi_mult_taxo_gbnm(304288, 'spoonhead sculpin').
ncbi_mult_taxo_gbnm(304292, 'deepwater sculpin').
ncbi_mult_taxo_gbnm(304335, 'ancient bison').
ncbi_mult_taxo_gbnm(304401, 'Arizona shrew').
ncbi_mult_taxo_gbnm(304452, 'rainbow snakehead').
ncbi_mult_taxo_gbnm(304454, 'Barca snakehead').
ncbi_mult_taxo_gbnm(304456, 'spotted snakehead').
ncbi_mult_taxo_gbnm(304457, 'Burmese snakehead').
ncbi_mult_taxo_gbnm(304459, 'humpback grouper').
ncbi_mult_taxo_gbnm(304626, 'antlered flies').
ncbi_mult_taxo_gbnm(304692, 'purple-bibbed whitetip').
ncbi_mult_taxo_gbnm(304879, 'harlequin cockroach').
ncbi_mult_taxo_gbnm(305437, 'cactus longhorn').
ncbi_mult_taxo_gbnm(305495, 'gorse shieldbug').
ncbi_mult_taxo_gbnm(305503, 'leatherside chub').
ncbi_mult_taxo_gbnm(305505, 'bonehead sculpin').
ncbi_mult_taxo_gbnm(305506, 'dusky sculpin').
ncbi_mult_taxo_gbnm(305508, 'pit-head sculpin').
ncbi_mult_taxo_gbnm(305509, 'frogmouth sculpin').
ncbi_mult_taxo_gbnm(305510, 'yellowchin sculpin').
ncbi_mult_taxo_gbnm(305513, 'California tonguefish').
ncbi_mult_taxo_gbnm(305516, 'Pacific sleeper shark').
ncbi_mult_taxo_gbnm(305562, beelouse).
ncbi_mult_taxo_gbnm(305598, 'sorghum shoot fly').
ncbi_mult_taxo_gbnm(305631, 'common remora').
ncbi_mult_taxo_gbnm(305662, 'spruce coneworm').
ncbi_mult_taxo_gbnm(305783, 'spotfin surfperch').
ncbi_mult_taxo_gbnm(305784, 'sharpnose seaperch').
ncbi_mult_taxo_gbnm(305819, 'white-nosed bush frog').
ncbi_mult_taxo_gbnm(305821, 'blue-eyed yellow bush frog').
ncbi_mult_taxo_gbnm(305967, 'ornate elysia').
ncbi_mult_taxo_gbnm(305979, 'spectacled salamander').
ncbi_mult_taxo_gbnm(306045, 'Apache pocket mouse').
ncbi_mult_taxo_gbnm(306084, 'brownbelly leaf frog').
ncbi_mult_taxo_gbnm(306268, 'Uluguru bushshrike').
ncbi_mult_taxo_gbnm(306578, 'brownspotted grouper').
ncbi_mult_taxo_gbnm(306579, 'spinycheek grouper').
ncbi_mult_taxo_gbnm(306583, 'striped grouper').
ncbi_mult_taxo_gbnm(306584, 'longspine grouper').
ncbi_mult_taxo_gbnm(306590, 'ornate frog').
ncbi_mult_taxo_gbnm(306639, noodlefish).
ncbi_mult_taxo_gbnm(306894, 'oak gall wasp').
ncbi_mult_taxo_gbnm(307031, 'California bay shrimp').
ncbi_mult_taxo_gbnm(307096, 'tailless bushblue').
ncbi_mult_taxo_gbnm(307098, 'pale grass blue').
ncbi_mult_taxo_gbnm(307105, 'Howell\'s Forest Shrew').
ncbi_mult_taxo_gbnm(307106, 'Moon Forest Shrew').
ncbi_mult_taxo_gbnm(307107, 'Grant\'s Forest Shrew').
ncbi_mult_taxo_gbnm(307108, 'Kihaule\'s Mouse Shrew').
ncbi_mult_taxo_gbnm(307116, 'Cascade torrent salamander').
ncbi_mult_taxo_gbnm(307117, 'nimble long-limbed salamander').
ncbi_mult_taxo_gbnm(307118, 'Cope\'s giant salamander').
ncbi_mult_taxo_gbnm(307165, 'blue spikemoss').
ncbi_mult_taxo_gbnm(307205, 'little house fly').
ncbi_mult_taxo_gbnm(307441, 'Blyth\'s hawk-eagle').
ncbi_mult_taxo_gbnm(307491, 'soybean aphid').
ncbi_mult_taxo_gbnm(307492, 'cowpea aphid').
ncbi_mult_taxo_gbnm(307589, 'deep body anchovy').
ncbi_mult_taxo_gbnm(307590, 'Bennett\'s flyingfish').
ncbi_mult_taxo_gbnm(307630, alemow).
ncbi_mult_taxo_gbnm(307640, 'black eagle').
ncbi_mult_taxo_gbnm(307641, 'New Zealand giant eagle').
ncbi_mult_taxo_gbnm(307658, 'pharaoh ant').
ncbi_mult_taxo_gbnm(307943, 'small eye golden-line fish').
ncbi_mult_taxo_gbnm(307949, 'duck-billed golden-line fish').
ncbi_mult_taxo_gbnm(307950, 'crossed-fork back golden-line fish').
ncbi_mult_taxo_gbnm(307955, 'eyeless golden-line fish').
ncbi_mult_taxo_gbnm(307960, 'hyaline fish').
ncbi_mult_taxo_gbnm(307972, 'Japanese sea cucumber').
ncbi_mult_taxo_gbnm(307977, 'greater siren').
ncbi_mult_taxo_gbnm(307978, 'slender dwarf siren').
ncbi_mult_taxo_gbnm(307979, 'narrow-striped dwarf siren').
ncbi_mult_taxo_gbnm(308060, 'Okarito brown kiwi').
ncbi_mult_taxo_gbnm(308069, flamefish).
ncbi_mult_taxo_gbnm(308070, 'blackstripe cardinalfish').
ncbi_mult_taxo_gbnm(308072, 'Pacific sleeper').
ncbi_mult_taxo_gbnm(308076, 'bigmouth sleeper').
ncbi_mult_taxo_gbnm(308077, 'spotted sleeper').
ncbi_mult_taxo_gbnm(308078, 'large-scaled spinycheek sleeper').
ncbi_mult_taxo_gbnm(308080, 'sleepy cod').
ncbi_mult_taxo_gbnm(308081, 'Cox\'s gudgeon').
ncbi_mult_taxo_gbnm(308086, 'spinycheek sleeper').
ncbi_mult_taxo_gbnm(308089, 'giant gudgeon').
ncbi_mult_taxo_gbnm(308090, 'flathead sleeper').
ncbi_mult_taxo_gbnm(308092, 'cave gudgeon').
ncbi_mult_taxo_gbnm(308097, 'sawcheek cardinalfish').
ncbi_mult_taxo_gbnm(308099, 'Pacific guavina').
ncbi_mult_taxo_gbnm(308100, 'poreless gudgeon').
ncbi_mult_taxo_gbnm(308442, 'large aspen tortrix').
ncbi_mult_taxo_gbnm(308517, 'pit scales').
ncbi_mult_taxo_gbnm(308558, 'narrow-leaved purple coneflower').
ncbi_mult_taxo_gbnm(308560, 'foursaddle grouper').
ncbi_mult_taxo_gbnm(308562, 'threespot grouper').
ncbi_mult_taxo_gbnm(308563, 'snubnose grouper').
ncbi_mult_taxo_gbnm(308564, 'longfin grouper').
ncbi_mult_taxo_gbnm(308565, 'specked blue grouper').
ncbi_mult_taxo_gbnm(308688, 'Qinghai spruce').
ncbi_mult_taxo_gbnm(308847, 'silver seatrout').
ncbi_mult_taxo_gbnm(308863, 'rice water weevil').
ncbi_mult_taxo_gbnm(309118, 'Siberian brook lamprey').
ncbi_mult_taxo_gbnm(309130, bonete).
ncbi_mult_taxo_gbnm(309176, 'Greeffs giant gecko').
ncbi_mult_taxo_gbnm(309270, 'council-tree').
ncbi_mult_taxo_gbnm(309271, 'Indian banyan').
ncbi_mult_taxo_gbnm(309312, 'fiddle-leaf fig').
ncbi_mult_taxo_gbnm(309349, 'Ussurian pear').
ncbi_mult_taxo_gbnm(309536, 'Turkestan tit').
ncbi_mult_taxo_gbnm(309541, mefugu).
ncbi_mult_taxo_gbnm(309632, 'goldblotch grouper').
ncbi_mult_taxo_gbnm(309695, 'rockmaster damselfly').
ncbi_mult_taxo_gbnm(309699, 'coastal flatwing damselfly').
ncbi_mult_taxo_gbnm(309841, 'thick-billed parrot').
ncbi_mult_taxo_gbnm(309844, 'Pacific parrotlet').
ncbi_mult_taxo_gbnm(309851, 'grey-hooded parakeet').
ncbi_mult_taxo_gbnm(309852, 'blue-naped parrot').
ncbi_mult_taxo_gbnm(309856, 'Moluccan hanging parrot').
ncbi_mult_taxo_gbnm(309859, 'Port Lincoln ringneck').
ncbi_mult_taxo_gbnm(309862, 'burrowing parakeet').
ncbi_mult_taxo_gbnm(309863, 'crimson-bellied parakeet').
ncbi_mult_taxo_gbnm(309866, 'black-headed parrot').
ncbi_mult_taxo_gbnm(309870, 'Moluccan king-parrot').
ncbi_mult_taxo_gbnm(309873, 'golden-mantled racquet-tail').
ncbi_mult_taxo_gbnm(309878, 'Bourke\'s parrot').
ncbi_mult_taxo_gbnm(309911, 'spotted shovelnose').
ncbi_mult_taxo_gbnm(309922, 'dotted grouper').
ncbi_mult_taxo_gbnm(309925, 'camoflage grouper').
ncbi_mult_taxo_gbnm(309926, 'sixbar grouper').
ncbi_mult_taxo_gbnm(309930, 'peacock hind').
ncbi_mult_taxo_gbnm(309978, 'Korean lawngrass').
ncbi_mult_taxo_gbnm(310278, 'oriental chestnut gall wasp').
ncbi_mult_taxo_gbnm(310352, 'Black-shanked douc langur').
ncbi_mult_taxo_gbnm(310364, 'sharphead darter').
ncbi_mult_taxo_gbnm(310366, 'lipstick darter').
ncbi_mult_taxo_gbnm(310367, 'Tuskaloossa darter').
ncbi_mult_taxo_gbnm(310368, 'Etowah darter').
ncbi_mult_taxo_gbnm(310369, 'greenbreast darter').
ncbi_mult_taxo_gbnm(310370, 'spotted darter').
ncbi_mult_taxo_gbnm(310372, 'smallscale darter').
ncbi_mult_taxo_gbnm(310376, 'bloodfin darter').
ncbi_mult_taxo_gbnm(310377, 'wounded darter').
ncbi_mult_taxo_gbnm(310380, 'boulder darter').
ncbi_mult_taxo_gbnm(310442, 'maiden\'s blush').
ncbi_mult_taxo_gbnm(310464, 'marmalade-bush').
ncbi_mult_taxo_gbnm(310513, 'eastern saltmarsh mosquito').
ncbi_mult_taxo_gbnm(310571, 'giant grouper').
ncbi_mult_taxo_gbnm(310659, 'Ishikawa\'s frog').
ncbi_mult_taxo_gbnm(310664, 'brown-backed odorous frog').
ncbi_mult_taxo_gbnm(310666, 'Mount Dulit frog').
ncbi_mult_taxo_gbnm(310668, 'Assam Hills frog').
ncbi_mult_taxo_gbnm(310671, 'swelled vent frog').
ncbi_mult_taxo_gbnm(310713, 'northern white rhinoceros').
ncbi_mult_taxo_gbnm(310786, 'Mexican silverspot').
ncbi_mult_taxo_gbnm(310804, 'Peruvian longwing').
ncbi_mult_taxo_gbnm(310840, loriciferans).
ncbi_mult_taxo_gbnm(310869, 'blunt-headed burrowing frog').
ncbi_mult_taxo_gbnm(310870, 'balloon frogs').
ncbi_mult_taxo_gbnm(310871, 'red narrow-mouthed frog').
ncbi_mult_taxo_gbnm(310914, 'glass catfish').
ncbi_mult_taxo_gbnm(310915, 'striped catfish').
ncbi_mult_taxo_gbnm(310932, 'Philippine slow loris').
ncbi_mult_taxo_gbnm(310934, 'Javan slow loris').
ncbi_mult_taxo_gbnm(310954, 'Escherich\'s killifish').
ncbi_mult_taxo_gbnm(311011, 'California sister').
ncbi_mult_taxo_gbnm(311025, 'variable eggfly').
ncbi_mult_taxo_gbnm(311027, 'red spot diadem').
ncbi_mult_taxo_gbnm(311037, 'orange oakleaf').
ncbi_mult_taxo_gbnm(311040, 'spotless anglewing').
ncbi_mult_taxo_gbnm(311043, 'darker commodore').
ncbi_mult_taxo_gbnm(311186, 'Chinese roe deer').
ncbi_mult_taxo_gbnm(311328, 'green oak leaf roller').
ncbi_mult_taxo_gbnm(311344, 'long-tailed thrush').
ncbi_mult_taxo_gbnm(311345, 'Sunda thrush').
ncbi_mult_taxo_gbnm(311346, 'New Britain thrush').
ncbi_mult_taxo_gbnm(311347, 'russet-tailed thrush').
ncbi_mult_taxo_gbnm(311348, 'dark-sided thrush').
ncbi_mult_taxo_gbnm(311350, 'orange ground-thrush').
ncbi_mult_taxo_gbnm(311354, 'great thrush').
ncbi_mult_taxo_gbnm(311356, 'rufous-bellied thrush').
ncbi_mult_taxo_gbnm(311358, 'Aztec thrush').
ncbi_mult_taxo_gbnm(311360, 'green cochoa').
ncbi_mult_taxo_gbnm(311363, 'black solitaire').
ncbi_mult_taxo_gbnm(311366, 'babbling starling').
ncbi_mult_taxo_gbnm(311368, 'Tristan thrush').
ncbi_mult_taxo_gbnm(311369, 'mountain bluebird').
ncbi_mult_taxo_gbnm(311372, 'groundscraper thrush').
ncbi_mult_taxo_gbnm(311401, 'northern spotted owl').
ncbi_mult_taxo_gbnm(311405, 'bitter ginger').
ncbi_mult_taxo_gbnm(311489, 'Orissa frog').
ncbi_mult_taxo_gbnm(311508, 'thinface cichlid').
ncbi_mult_taxo_gbnm(311523, 'humpback largemouth').
ncbi_mult_taxo_gbnm(311526, 'elephantnose cichlid').
ncbi_mult_taxo_gbnm(311527, 'California clingfish').
ncbi_mult_taxo_gbnm(311557, 'Sunda stink badger').
ncbi_mult_taxo_gbnm(311560, 'Selous\'s mongoose').
ncbi_mult_taxo_gbnm(311562, 'African striped weasel').
ncbi_mult_taxo_gbnm(311577, 'Karin Hills bushfrog').
ncbi_mult_taxo_gbnm(311779, 'big-thumbed treefrog').
ncbi_mult_taxo_gbnm(311815, 'Inger\'s bubble-nest frog').
ncbi_mult_taxo_gbnm(311820, 'Sri Lanka bug-eyed frog').
ncbi_mult_taxo_gbnm(311822, 'small tree frog').
ncbi_mult_taxo_gbnm(311883, 'Red-crowned parakeet').
ncbi_mult_taxo_gbnm(311886, 'Azuero parakeet').
ncbi_mult_taxo_gbnm(311887, 'Santarem parakeet').
ncbi_mult_taxo_gbnm(311889, 'Emma\'s parakeet').
ncbi_mult_taxo_gbnm(311890, 'Gray-breasted parakeet').
ncbi_mult_taxo_gbnm(311891, 'Maroon-faced parakeet').
ncbi_mult_taxo_gbnm(311894, 'white-necked parakeet').
ncbi_mult_taxo_gbnm(311895, 'Green-cheeked parakeet').
ncbi_mult_taxo_gbnm(311896, 'Pearly parakeet').
ncbi_mult_taxo_gbnm(311898, 'Maroon-tailed parakeet').
ncbi_mult_taxo_gbnm(311899, 'Sulphur-winged parakeet').
ncbi_mult_taxo_gbnm(311900, 'black-capped parakeet').
ncbi_mult_taxo_gbnm(311901, 'Blue-throated parakeet').
ncbi_mult_taxo_gbnm(312068, 'black-throated Tit').
ncbi_mult_taxo_gbnm(312069, 'greenish yellow bat').
ncbi_mult_taxo_gbnm(312111, 'Northern white-crowned tapaculo').
ncbi_mult_taxo_gbnm(312113, 'long-tailed tapaculo').
ncbi_mult_taxo_gbnm(312115, 'Matorral tapaculo').
ncbi_mult_taxo_gbnm(312121, 'blackish tapaculo').
ncbi_mult_taxo_gbnm(312721, 'muscular salamander').
ncbi_mult_taxo_gbnm(312722, 'ridge-tailed salamander').
ncbi_mult_taxo_gbnm(312725, 'Dominican leaf-toed gecko').
ncbi_mult_taxo_gbnm(312726, 'Haiti leaf-toed gecko').
ncbi_mult_taxo_gbnm(312791, 'Newfoundland dwarf birch').
ncbi_mult_taxo_gbnm(313159, 'ocellated labyrinth fish').
ncbi_mult_taxo_gbnm(313161, 'eyespot ctenopoma').
ncbi_mult_taxo_gbnm(313163, 'twospot climbing perch').
ncbi_mult_taxo_gbnm(313182, 'thick lipped gourami').
ncbi_mult_taxo_gbnm(313184, 'frail gourami').
ncbi_mult_taxo_gbnm(313188, 'eyespot gourami').
ncbi_mult_taxo_gbnm(313234, 'chocolate gourami').
ncbi_mult_taxo_gbnm(313237, 'moonlight gourami').
ncbi_mult_taxo_gbnm(313238, 'snakeskin gourami').
ncbi_mult_taxo_gbnm(313244, 'threestripe gourami').
ncbi_mult_taxo_gbnm(313246, 'elephant ear gourami').
ncbi_mult_taxo_gbnm(313355, 'Cano toadfish').
ncbi_mult_taxo_gbnm(313441, 'banded gourami').
ncbi_mult_taxo_gbnm(313444, 'Thekla lark').
ncbi_mult_taxo_gbnm(313992, 'night aulonocara').
ncbi_mult_taxo_gbnm(314000, 'California salema').
ncbi_mult_taxo_gbnm(314002, 'xantic sargo').
ncbi_mult_taxo_gbnm(314003, 'bluebanded goby').
ncbi_mult_taxo_gbnm(314015, 'frillfin goby').
ncbi_mult_taxo_gbnm(314147, 'Rodents and rabbits').
ncbi_mult_taxo_gbnm(314228, 'slender-billed black-cockatoo').
ncbi_mult_taxo_gbnm(314234, 'Pacific footballfish').
ncbi_mult_taxo_gbnm(314247, 'Pacific tripletail').
ncbi_mult_taxo_gbnm(314249, 'spottedtail angler').
ncbi_mult_taxo_gbnm(314295, apes).
ncbi_mult_taxo_gbnm(314331, 'emerald ash borer parasitic wasp').
ncbi_mult_taxo_gbnm(314334, 'bird-voiced treefrog').
ncbi_mult_taxo_gbnm(314391, 'feather finger grass').
ncbi_mult_taxo_gbnm(314582, 'pine woods treefrog').
ncbi_mult_taxo_gbnm(314609, 'Lonicera fly').
ncbi_mult_taxo_gbnm(315208, 'swamp beacon').
ncbi_mult_taxo_gbnm(315322, 'Arctic skate').
ncbi_mult_taxo_gbnm(315323, 'Waneso lizardfish').
ncbi_mult_taxo_gbnm(315360, 'green-backed woodpecker').
ncbi_mult_taxo_gbnm(315362, 'chestnut woodpecker').
ncbi_mult_taxo_gbnm(315363, 'cream-colored woodpecker').
ncbi_mult_taxo_gbnm(315365, 'greater flameback').
ncbi_mult_taxo_gbnm(315366, 'banded woodpecker').
ncbi_mult_taxo_gbnm(315367, 'crimson-crested woodpecker').
ncbi_mult_taxo_gbnm(315369, 'ground woodpecker').
ncbi_mult_taxo_gbnm(315371, 'rufous piculet').
ncbi_mult_taxo_gbnm(315373, 'buff-necked woodpecker').
ncbi_mult_taxo_gbnm(315375, 'sooty woodpecker').
ncbi_mult_taxo_gbnm(315376, 'Philippine warty pig').
ncbi_mult_taxo_gbnm(315377, 'Visayan warty pig').
ncbi_mult_taxo_gbnm(315379, 'golden-green woodpecker').
ncbi_mult_taxo_gbnm(315380, 'yellow-throated woodpecker').
ncbi_mult_taxo_gbnm(315381, 'Rufous-winged woodpecker').
ncbi_mult_taxo_gbnm(315382, 'red-stained woodpecker').
ncbi_mult_taxo_gbnm(315383, 'golden-collared woodpecker').
ncbi_mult_taxo_gbnm(315384, 'Choco woodpecker').
ncbi_mult_taxo_gbnm(315385, 'yellow-vented woodpecker').
ncbi_mult_taxo_gbnm(315386, 'dot-fronted woodpecker').
ncbi_mult_taxo_gbnm(315387, 'Smoky-brown woodpecker').
ncbi_mult_taxo_gbnm(315388, 'red-rumped woodpecker').
ncbi_mult_taxo_gbnm(315389, 'little woodpecker').
ncbi_mult_taxo_gbnm(315390, 'white-spotted woodpecker').
ncbi_mult_taxo_gbnm(315413, 'southern zigzag salamander').
ncbi_mult_taxo_gbnm(315414, 'southern gray-cheeked salamander').
ncbi_mult_taxo_gbnm(315415, 'white-spotted slimy salamander').
ncbi_mult_taxo_gbnm(315416, 'Blue Ridge gray-cheeked salamander').
ncbi_mult_taxo_gbnm(315417, 'savannah slimy salamander').
ncbi_mult_taxo_gbnm(315418, 'northern gray-cheeked salamander').
ncbi_mult_taxo_gbnm(315419, 'Mississippi slimy salamander').
ncbi_mult_taxo_gbnm(315430, 'purple-bellied lory').
ncbi_mult_taxo_gbnm(315492, 'spotted sea bass').
ncbi_mult_taxo_gbnm(315534, 'African bush-warbler').
ncbi_mult_taxo_gbnm(315536, 'African srub-warbler').
ncbi_mult_taxo_gbnm(315540, 'Damara rock-jumper').
ncbi_mult_taxo_gbnm(315541, 'Gosling\'s apalis').
ncbi_mult_taxo_gbnm(315542, 'green-backed Camaroptera').
ncbi_mult_taxo_gbnm(315544, 'kopje warbler').
ncbi_mult_taxo_gbnm(315546, 'Herero chat').
ncbi_mult_taxo_gbnm(315549, 'fan-tailed grassbird').
ncbi_mult_taxo_gbnm(315551, 'Cape grass-warbler').
ncbi_mult_taxo_gbnm(316104, 'rufous-winged Philentoma').
ncbi_mult_taxo_gbnm(316105, 'maroon-breasted Philentoma').
ncbi_mult_taxo_gbnm(316125, ariommid).
ncbi_mult_taxo_gbnm(316130, blackfish).
ncbi_mult_taxo_gbnm(316132, 'imperial barrelfish').
ncbi_mult_taxo_gbnm(316134, 'white warehou').
ncbi_mult_taxo_gbnm(316135, 'common warehou').
ncbi_mult_taxo_gbnm(316136, 'silver warehou').
ncbi_mult_taxo_gbnm(316137, 'longfin cigarfish').
ncbi_mult_taxo_gbnm(316138, 'Indian driftfish').
ncbi_mult_taxo_gbnm(316141, 'silver driftfish').
ncbi_mult_taxo_gbnm(316142, 'banded driftfish').
ncbi_mult_taxo_gbnm(316143, 'freckled driftfish').
ncbi_mult_taxo_gbnm(316144, 'bluefin driftfish').
ncbi_mult_taxo_gbnm(316146, 'Pacific harvestfish').
ncbi_mult_taxo_gbnm(316160, 'Maluti redfin').
ncbi_mult_taxo_gbnm(316161, 'gizzard shads').
ncbi_mult_taxo_gbnm(316163, 'Australian river gizzard shad').
ncbi_mult_taxo_gbnm(316343, 'transparent cardinalfish').
ncbi_mult_taxo_gbnm(316344, 'Hawaiian ruby cardinalfish').
ncbi_mult_taxo_gbnm(316345, 'ghost cardinalfish').
ncbi_mult_taxo_gbnm(316346, 'oblique-banded cardinalfish').
ncbi_mult_taxo_gbnm(316347, 'narrowstripe cardinalfish').
ncbi_mult_taxo_gbnm(316348, 'bridled cardinalfish').
ncbi_mult_taxo_gbnm(316349, 'iridescent cardinalfish').
ncbi_mult_taxo_gbnm(316350, 'redfin cardinalfish').
ncbi_mult_taxo_gbnm(316351, 'three-spot cardinalfish').
ncbi_mult_taxo_gbnm(316355, 'broadstriped cardinalfish').
ncbi_mult_taxo_gbnm(316356, 'short-tooth cardinal').
ncbi_mult_taxo_gbnm(316357, 'ring-tailed cardinalfish').
ncbi_mult_taxo_gbnm(316358, 'ocellate cardinalfish').
ncbi_mult_taxo_gbnm(316360, 'ochre-striped cardinalfish').
ncbi_mult_taxo_gbnm(316361, 'flag-in cardinal-fish').
ncbi_mult_taxo_gbnm(316362, 'candystripe cardinalfish').
ncbi_mult_taxo_gbnm(316363, 'Guam cardinalfish').
ncbi_mult_taxo_gbnm(316365, 'rifle cardinal').
ncbi_mult_taxo_gbnm(316366, 'Indian perch').
ncbi_mult_taxo_gbnm(316367, 'black cardinalfish').
ncbi_mult_taxo_gbnm(316369, 'spotnape cardinalfish').
ncbi_mult_taxo_gbnm(316370, 'sevenstriped cardinalfish').
ncbi_mult_taxo_gbnm(316371, 'twostripe cardinal').
ncbi_mult_taxo_gbnm(316372, 'Sangi cardinalfish').
ncbi_mult_taxo_gbnm(316373, 'Samoan cardinalfish').
ncbi_mult_taxo_gbnm(316374, 'meteor cardinalfish').
ncbi_mult_taxo_gbnm(316380, 'variegated cardinalfish').
ncbi_mult_taxo_gbnm(316388, 'Brazilian wrasse').
ncbi_mult_taxo_gbnm(316389, 'blackear wrasse').
ncbi_mult_taxo_gbnm(316406, 'Malawi thick lip').
ncbi_mult_taxo_gbnm(316436, 'shiny-palmed shinning-skink').
ncbi_mult_taxo_gbnm(316456, 'Mormon cricket').
ncbi_mult_taxo_gbnm(317033, 'spangled perch').
ncbi_mult_taxo_gbnm(317034, 'Fortescue grunter').
ncbi_mult_taxo_gbnm(317118, 'brown-chested martin').
ncbi_mult_taxo_gbnm(317167, 'square-tailed saw-wing').
ncbi_mult_taxo_gbnm(317168, 'mountain saw-wing').
ncbi_mult_taxo_gbnm(317169, 'white-headed saw-wing').
ncbi_mult_taxo_gbnm(317170, 'Eastern saw-wing').
ncbi_mult_taxo_gbnm(317171, 'Fanti saw-wing').
ncbi_mult_taxo_gbnm(317174, 'blue saw-wing').
ncbi_mult_taxo_gbnm(317192, 'bladder dock').
ncbi_mult_taxo_gbnm(317248, 'tiger goby').
ncbi_mult_taxo_gbnm(317254, 'Sonora goby').
ncbi_mult_taxo_gbnm(317300, 'northern cricket frog').
ncbi_mult_taxo_gbnm(317301, 'Florida cricket frog').
ncbi_mult_taxo_gbnm(317303, 'gliding leaf frog').
ncbi_mult_taxo_gbnm(317307, 'Peru stubfoot toad').
ncbi_mult_taxo_gbnm(317308, 'West Indian treefrogs').
ncbi_mult_taxo_gbnm(317311, 'Boulenger\'s backpack frog').
ncbi_mult_taxo_gbnm(317312, 'water-holding frogs').
ncbi_mult_taxo_gbnm(317313, 'savannah water-holding frog').
ncbi_mult_taxo_gbnm(317314, 'bleating water-holding frog').
ncbi_mult_taxo_gbnm(317315, 'Copan brook frog').
ncbi_mult_taxo_gbnm(317316, 'Intac robber frog').
ncbi_mult_taxo_gbnm(317318, 'Mount Tucutche treefrog').
ncbi_mult_taxo_gbnm(317319, 'common marsupial frog').
ncbi_mult_taxo_gbnm(317320, 'mountain marsupial frog').
ncbi_mult_taxo_gbnm(317321, 'horned treefrogs').
ncbi_mult_taxo_gbnm(317322, 'Sumaco horned treefrog').
ncbi_mult_taxo_gbnm(317323, 'plantation glass frog').
ncbi_mult_taxo_gbnm(317324, 'white-fronted treefrog').
ncbi_mult_taxo_gbnm(317325, 'Assam treefrog').
ncbi_mult_taxo_gbnm(317326, 'Balzapata treefrog').
ncbi_mult_taxo_gbnm(317327, 'rusty treefrog').
ncbi_mult_taxo_gbnm(317328, 'bromeliad treefrog').
ncbi_mult_taxo_gbnm(317329, 'La Loma treefrog').
ncbi_mult_taxo_gbnm(317332, 'Koechlin\'s treefrog').
ncbi_mult_taxo_gbnm(317333, 'Leal\'s treefrog').
ncbi_mult_taxo_gbnm(317334, 'Guinle treefrog').
ncbi_mult_taxo_gbnm(317335, 'mahogany treefrog').
ncbi_mult_taxo_gbnm(317336, 'black-eyed treefrog').
ncbi_mult_taxo_gbnm(317338, 'Palmer\'s treefrog').
ncbi_mult_taxo_gbnm(317339, 'Betania treefrog').
ncbi_mult_taxo_gbnm(317340, 'mourning treefrog').
ncbi_mult_taxo_gbnm(317341, 'Cope\'s eastern Paraguay treefrog').
ncbi_mult_taxo_gbnm(317342, 'Gunter\'s Costa Rican treefrog').
ncbi_mult_taxo_gbnm(317343, 'common treefrog').
ncbi_mult_taxo_gbnm(317344, 'Cinchona Plantation treefrog').
ncbi_mult_taxo_gbnm(317345, 'Mertens\' yellow treefrog').
ncbi_mult_taxo_gbnm(317347, 'Canal Zone treefrog').
ncbi_mult_taxo_gbnm(317348, 'Tayor\'s yellow treefrog').
ncbi_mult_taxo_gbnm(317350, 'Simmons\' treefrog').
ncbi_mult_taxo_gbnm(317351, 'dwarf Mexican treefrog').
ncbi_mult_taxo_gbnm(317352, 'squirrel treefrog').
ncbi_mult_taxo_gbnm(317353, 'Sumichrast\'s treefrog').
ncbi_mult_taxo_gbnm(317354, 'porthole treefrog').
ncbi_mult_taxo_gbnm(317355, 'Starrett\'s treefrog').
ncbi_mult_taxo_gbnm(317357, 'Zetek\'s treefrog').
ncbi_mult_taxo_gbnm(317363, 'emerald-spotted treefrog').
ncbi_mult_taxo_gbnm(317367, 'crucifix toad').
ncbi_mult_taxo_gbnm(317368, 'Cheesman\'s big-eyed treefrog').
ncbi_mult_taxo_gbnm(317369, 'Kaironk big-eyed treefrog').
ncbi_mult_taxo_gbnm(317371, 'ocellated treefrog').
ncbi_mult_taxo_gbnm(317372, 'Dominican treefrog').
ncbi_mult_taxo_gbnm(317373, 'Cuban treefrog').
ncbi_mult_taxo_gbnm(317374, 'colored leaf frogs').
ncbi_mult_taxo_gbnm(317375, 'bi-colored leaf frog').
ncbi_mult_taxo_gbnm(317376, 'Canchaque Andes frog').
ncbi_mult_taxo_gbnm(317378, 'heart-tongued frogs').
ncbi_mult_taxo_gbnm(317381, 'orange-legged leaf frog').
ncbi_mult_taxo_gbnm(317382, 'lemur leaf frog').
ncbi_mult_taxo_gbnm(317384, 'spikethumb frogs').
ncbi_mult_taxo_gbnm(317388, 'lowland burrowing treefrog').
ncbi_mult_taxo_gbnm(317389, 'mountain stream frogs').
ncbi_mult_taxo_gbnm(317390, 'Copan stream frog').
ncbi_mult_taxo_gbnm(317391, 'Guerreran stream frog').
ncbi_mult_taxo_gbnm(317393, 'Tarauaca snouted treefrog').
ncbi_mult_taxo_gbnm(317394, 'Catharina snouted treefrog').
ncbi_mult_taxo_gbnm(317395, 'Campo Belo snouted treefrog').
ncbi_mult_taxo_gbnm(317396, 'Sipurio snouted treefrog').
ncbi_mult_taxo_gbnm(317397, 'Quevedo snouted treefrog').
ncbi_mult_taxo_gbnm(317398, 'blue-spotted treefrog').
ncbi_mult_taxo_gbnm(317400, 'Groete Creek treefrog').
ncbi_mult_taxo_gbnm(317401, 'Trueb\'s water frog').
ncbi_mult_taxo_gbnm(317402, 'shovel-headed treefrogs').
ncbi_mult_taxo_gbnm(317403, 'Yucatecan shovel-headed treefrog').
ncbi_mult_taxo_gbnm(317404, 'Littlejohn\'s toadlet').
ncbi_mult_taxo_gbnm(317406, 'Japanese andromeda').
ncbi_mult_taxo_gbnm(317474, 'yellowbreasted wrasse').
ncbi_mult_taxo_gbnm(317475, 'chameleon wrasse').
ncbi_mult_taxo_gbnm(317477, 'rainbow wrasse').
ncbi_mult_taxo_gbnm(317478, 'torpedo wrasse').
ncbi_mult_taxo_gbnm(317479, 'comb wrasse').
ncbi_mult_taxo_gbnm(317480, 'pale-barred coris').
ncbi_mult_taxo_gbnm(317481, 'yellowstripe coris').
ncbi_mult_taxo_gbnm(317483, 'yellowspotted wrasse').
ncbi_mult_taxo_gbnm(317484, 'Choat\'s wrasse').
ncbi_mult_taxo_gbnm(317485, 'twotone wrasse').
ncbi_mult_taxo_gbnm(317486, 'goldlined coris').
ncbi_mult_taxo_gbnm(317487, 'blackstripe wrasse').
ncbi_mult_taxo_gbnm(317490, 'greyhead wrasse').
ncbi_mult_taxo_gbnm(317491, 'Richmond\'s wrasse').
ncbi_mult_taxo_gbnm(317492, 'cheekspot wrasse').
ncbi_mult_taxo_gbnm(317493, 'ornamented wrasse').
ncbi_mult_taxo_gbnm(317494, 'red-lined wrasse').
ncbi_mult_taxo_gbnm(317495, 'bubblefin wrasse').
ncbi_mult_taxo_gbnm(317496, 'axil spot wrasse').
ncbi_mult_taxo_gbnm(317497, 'nebulous wrasse').
ncbi_mult_taxo_gbnm(317498, 'Brownfields wrasse').
ncbi_mult_taxo_gbnm(317499, 'pastel-green wrasse').
ncbi_mult_taxo_gbnm(317583, 'pear sawfly').
ncbi_mult_taxo_gbnm(317791, 'Australian pelican').
ncbi_mult_taxo_gbnm(317792, 'African darter').
ncbi_mult_taxo_gbnm(317856, mahua).
ncbi_mult_taxo_gbnm(317884, 'Mostar minnow').
ncbi_mult_taxo_gbnm(317898, 'Italian bleak').
ncbi_mult_taxo_gbnm(317899, 'Danilewski\'s dace').
ncbi_mult_taxo_gbnm(317919, 'Jadova minnow').
ncbi_mult_taxo_gbnm(317921, 'Popovo minnow').
ncbi_mult_taxo_gbnm(317922, 'Krbava minnow').
ncbi_mult_taxo_gbnm(317926, ningu).
ncbi_mult_taxo_gbnm(317943, 'micro frog').
ncbi_mult_taxo_gbnm(317946, 'dwarf dainty frog').
ncbi_mult_taxo_gbnm(317981, 'Caspian shrew').
ncbi_mult_taxo_gbnm(318061, 'red caustic-creeper').
ncbi_mult_taxo_gbnm(318094, 'bubblegum coral').
ncbi_mult_taxo_gbnm(318249, 'splendid leaf frog').
ncbi_mult_taxo_gbnm(318250, 'Tonchek spiny-chest frog').
ncbi_mult_taxo_gbnm(318251, 'casque-headed frogs').
ncbi_mult_taxo_gbnm(318254, 'Bruno\'s casque-headed frog').
ncbi_mult_taxo_gbnm(318255, 'canebrake treefrogs').
ncbi_mult_taxo_gbnm(318256, 'canebreak treefrog').
ncbi_mult_taxo_gbnm(318259, 'canebreak treefrog').
ncbi_mult_taxo_gbnm(318262, 'Argentina frogs').
ncbi_mult_taxo_gbnm(318263, 'red-spotted Argentina frog').
ncbi_mult_taxo_gbnm(318266, 'Patagonia frogs').
ncbi_mult_taxo_gbnm(318267, 'Patagonia frog').
ncbi_mult_taxo_gbnm(318268, 'Cranwell\'s horned frog').
ncbi_mult_taxo_gbnm(318273, 'Greening\'s frog').
ncbi_mult_taxo_gbnm(318274, 'Schmidt\'s spinythumb frog').
ncbi_mult_taxo_gbnm(318278, 'Perez\'s snouted frog').
ncbi_mult_taxo_gbnm(318296, 'horned marsupial frog').
ncbi_mult_taxo_gbnm(318298, 'Igaracu marsupial frog').
ncbi_mult_taxo_gbnm(318300, 'Rio glass frog').
ncbi_mult_taxo_gbnm(318302, 'Lutz\'s treefrog').
ncbi_mult_taxo_gbnm(318303, 'Estrella treefrog').
ncbi_mult_taxo_gbnm(318305, 'Teresopolis treefrog').
ncbi_mult_taxo_gbnm(318306, 'Benitez\'s treefrog').
ncbi_mult_taxo_gbnm(318307, 'Bertha\'s treefrog').
ncbi_mult_taxo_gbnm(318308, 'two-spotted treefrog').
ncbi_mult_taxo_gbnm(318310, 'Crump treefrog').
ncbi_mult_taxo_gbnm(318314, 'Cruz\'s treefrog').
ncbi_mult_taxo_gbnm(318315, 'Martin\'s treefrog').
ncbi_mult_taxo_gbnm(318316, 'Charazani treefrog').
ncbi_mult_taxo_gbnm(318320, 'southern highland treefrog').
ncbi_mult_taxo_gbnm(318321, 'Giesler\'s treefrog').
ncbi_mult_taxo_gbnm(318322, 'barking treefrog').
ncbi_mult_taxo_gbnm(318323, 'Los Bracitos treefrog').
ncbi_mult_taxo_gbnm(318325, 'Lema treefrog').
ncbi_mult_taxo_gbnm(318328, 'smallskin treefrog').
ncbi_mult_taxo_gbnm(318329, 'Cope\'s brown treefrog').
ncbi_mult_taxo_gbnm(318330, 'Mixe treefrog').
ncbi_mult_taxo_gbnm(318331, 'Hosteria La Selva treefrog').
ncbi_mult_taxo_gbnm(318334, 'leopard treefrog').
ncbi_mult_taxo_gbnm(318335, 'Perkins\' treefrog').
ncbi_mult_taxo_gbnm(318336, 'painted treefrog').
ncbi_mult_taxo_gbnm(318337, 'red-skirted treefrog').
ncbi_mult_taxo_gbnm(318338, 'Hoogmoed\'s treefrog').
ncbi_mult_taxo_gbnm(318339, 'Lagoa Santa treefrog').
ncbi_mult_taxo_gbnm(318340, 'Sanborn\'s treefrog').
ncbi_mult_taxo_gbnm(318341, 'Savingny\'s treefrog').
ncbi_mult_taxo_gbnm(318343, 'Corcovado treefrog').
ncbi_mult_taxo_gbnm(318357, 'Schmidt\'s Uruguay treefrog').
ncbi_mult_taxo_gbnm(318359, 'Walker\'s treefrog').
ncbi_mult_taxo_gbnm(318360, 'Weygoldt\'s treefrog').
ncbi_mult_taxo_gbnm(318363, 'granular leaf frog').
ncbi_mult_taxo_gbnm(318364, 'rapids frogs').
ncbi_mult_taxo_gbnm(318365, 'rapids frog').
ncbi_mult_taxo_gbnm(318366, 'Freycinet\'s treefrog').
ncbi_mult_taxo_gbnm(318367, 'Australian cross-banded treefrog').
ncbi_mult_taxo_gbnm(318368, 'Guyana harlequin frog').
ncbi_mult_taxo_gbnm(318369, 'Uruguay harlequin frog').
ncbi_mult_taxo_gbnm(318371, 'common big-eyed treefrog').
ncbi_mult_taxo_gbnm(318373, 'Hispaniola treefrog').
ncbi_mult_taxo_gbnm(318374, 'New River treefrog').
ncbi_mult_taxo_gbnm(318375, 'Porto Alegre golden-eyed treefrog').
ncbi_mult_taxo_gbnm(318376, 'mission golden-eyed treefrog').
ncbi_mult_taxo_gbnm(318378, 'yellow heart-tongued frog').
ncbi_mult_taxo_gbnm(318380, 'hidden walking leaf frog').
ncbi_mult_taxo_gbnm(318381, 'forest spikethumb frog').
ncbi_mult_taxo_gbnm(318382, 'Matuda\'s spikethumb frog').
ncbi_mult_taxo_gbnm(318383, 'lesser swimming frog').
ncbi_mult_taxo_gbnm(318384, 'brown toadlet').
ncbi_mult_taxo_gbnm(318385, 'cloud forest stream frog').
ncbi_mult_taxo_gbnm(318386, 'Schultze\'s stream frog').
ncbi_mult_taxo_gbnm(318389, 'Mato Grosso snouted treefrog').
ncbi_mult_taxo_gbnm(318390, 'dwarf snouted treefrog').
ncbi_mult_taxo_gbnm(318391, 'Boulenger\'s snouted treefrog').
ncbi_mult_taxo_gbnm(318393, 'snouted treefrog').
ncbi_mult_taxo_gbnm(318394, 'lesser snouted treefrog').
ncbi_mult_taxo_gbnm(318395, 'striped snouted treefrog').
ncbi_mult_taxo_gbnm(318396, 'Stauffer\'s longnosed treefrog').
ncbi_mult_taxo_gbnm(318397, 'Nicaragua cross-banded treefrog').
ncbi_mult_taxo_gbnm(318398, 'Doris\' lime treefrog').
ncbi_mult_taxo_gbnm(318401, 'black-spotted casque-headed treefrog').
ncbi_mult_taxo_gbnm(318402, 'brown-eyed treefrogs').
ncbi_mult_taxo_gbnm(318403, 'brown-eyed treefrog').
ncbi_mult_taxo_gbnm(318404, 'spurred big-eyed treefrog').
ncbi_mult_taxo_gbnm(318406, 'chocolatefoot leaf frog').
ncbi_mult_taxo_gbnm(318407, 'spotted leaf frog').
ncbi_mult_taxo_gbnm(318408, 'four-eyed frogs').
ncbi_mult_taxo_gbnm(318409, 'Colombian four-eyed frog').
ncbi_mult_taxo_gbnm(318410, 'swamp frogs').
ncbi_mult_taxo_gbnm(318411, 'Hensel\'s swamp frog').
ncbi_mult_taxo_gbnm(318412, 'Amazon treefrogs').
ncbi_mult_taxo_gbnm(318413, 'white-lipped bog-frog').
ncbi_mult_taxo_gbnm(318415, 'Izecksohn\'s Brazilian treefrog').
ncbi_mult_taxo_gbnm(318479, 'Guinea worm').
ncbi_mult_taxo_gbnm(318551, 'rufous-spotted torrent frog').
ncbi_mult_taxo_gbnm(318672, 'brown coscarob').
ncbi_mult_taxo_gbnm(318676, 'chameleon cichlid').
ncbi_mult_taxo_gbnm(318677, 'Haitian cichlid').
ncbi_mult_taxo_gbnm(318703, 'steelblue blowfly').
ncbi_mult_taxo_gbnm(318730, 'freckled cichlid').
ncbi_mult_taxo_gbnm(318736, 'white cichlid').
ncbi_mult_taxo_gbnm(318738, 'redhead cichlid').
ncbi_mult_taxo_gbnm(318739, 'Montecristo cichlid').
ncbi_mult_taxo_gbnm(318743, 'Mayan cichlid').
ncbi_mult_taxo_gbnm(318747, 'southern checkmark cichlid').
ncbi_mult_taxo_gbnm(319226, 'Sakhalin lake minnow').
ncbi_mult_taxo_gbnm(319321, 'Snyder\'s barb').
ncbi_mult_taxo_gbnm(319323, 'Chinese barb').
ncbi_mult_taxo_gbnm(319348, 'sleeping chironomid').
ncbi_mult_taxo_gbnm(319430, 'threadfin angler').
ncbi_mult_taxo_gbnm(319431, 'yellow snapper').
ncbi_mult_taxo_gbnm(319433, 'shoulderspot grenadier').
ncbi_mult_taxo_gbnm(319436, 'bighead tilefish').
ncbi_mult_taxo_gbnm(319437, 'ocean whitefish').
ncbi_mult_taxo_gbnm(319440, 'shiny loosejaw').
ncbi_mult_taxo_gbnm(319444, 'highsnout bigscale').
ncbi_mult_taxo_gbnm(319445, 'twospine bigscale').
ncbi_mult_taxo_gbnm(319449, 'highfin dragonfish').
ncbi_mult_taxo_gbnm(319451, 'longfin dragonfish').
ncbi_mult_taxo_gbnm(319453, 'slender codling').
ncbi_mult_taxo_gbnm(319455, 'sunbeam lanternfish').
ncbi_mult_taxo_gbnm(319462, 'Chiriqui harvest mouse').
ncbi_mult_taxo_gbnm(319463, 'Cozumel harvest mouse').
ncbi_mult_taxo_gbnm(319465, 'Narrow-nosed harvest mouse').
ncbi_mult_taxo_gbnm(319466, 'volcano harvest mouse').
ncbi_mult_taxo_gbnm(319467, 'hairy harvest mouse').
ncbi_mult_taxo_gbnm(319527, 'Woodford\'s fruit bat').
ncbi_mult_taxo_gbnm(319541, 'broadfin lampfish').
ncbi_mult_taxo_gbnm(319543, 'bat eagle ray').
ncbi_mult_taxo_gbnm(319624, 'Sri Lanka wild mango').
ncbi_mult_taxo_gbnm(319699, mule).
ncbi_mult_taxo_gbnm(319749, 'black fathead').
ncbi_mult_taxo_gbnm(319750, 'scaly paperbone').
ncbi_mult_taxo_gbnm(319751, 'yellow snake-eel').
ncbi_mult_taxo_gbnm(319755, 'basketweave cusk-eel').
ncbi_mult_taxo_gbnm(319757, 'roundbelly cowfish').
ncbi_mult_taxo_gbnm(319759, 'slender barracudina').
ncbi_mult_taxo_gbnm(319761, 'bag-shelter moth').
ncbi_mult_taxo_gbnm(319763, 'black barracudina').
ncbi_mult_taxo_gbnm(319769, 'duckbill barracudina').
ncbi_mult_taxo_gbnm(319772, 'sharpchin barracudina').
ncbi_mult_taxo_gbnm(319774, 'Pacific sanddab').
ncbi_mult_taxo_gbnm(319775, 'speckled sanddab').
ncbi_mult_taxo_gbnm(319776, 'California flounder').
ncbi_mult_taxo_gbnm(319782, 'shining tubeshoulder').
ncbi_mult_taxo_gbnm(319813, 'lowland streaked tenrec').
ncbi_mult_taxo_gbnm(319815, 'aquatic tenrec').
ncbi_mult_taxo_gbnm(319816, 'short-tailed shrew tenrec').
ncbi_mult_taxo_gbnm(319817, 'Hova rice tenrec').
ncbi_mult_taxo_gbnm(319819, 'greater hedgehog tenrec').
ncbi_mult_taxo_gbnm(319944, 'Pacific worm eel').
ncbi_mult_taxo_gbnm(320146, 'Japanese quince').
ncbi_mult_taxo_gbnm(320164, 'southern giant salamander').
ncbi_mult_taxo_gbnm(320184, 'common wanderer').
ncbi_mult_taxo_gbnm(320196, 'African small white').
ncbi_mult_taxo_gbnm(320221, 'giant white').
ncbi_mult_taxo_gbnm(320256, 'Morocco orange tip').
ncbi_mult_taxo_gbnm(320267, 'lemon migrant').
ncbi_mult_taxo_gbnm(320294, 'tailed orange').
ncbi_mult_taxo_gbnm(320297, 'great blackvein').
ncbi_mult_taxo_gbnm(320322, 'fe\'i banana').
ncbi_mult_taxo_gbnm(320331, 'sharktooth moray').
ncbi_mult_taxo_gbnm(320332, 'dark moray').
ncbi_mult_taxo_gbnm(320333, 'honeycomb moray').
ncbi_mult_taxo_gbnm(320338, 'pen-tailed tree shrew').
ncbi_mult_taxo_gbnm(320340, 'Madras tree shrew').
ncbi_mult_taxo_gbnm(320341, 'striped tree shrew').
ncbi_mult_taxo_gbnm(320342, 'slender tree shrew').
ncbi_mult_taxo_gbnm(320343, 'Javan tree shrew').
ncbi_mult_taxo_gbnm(320358, 'Nicobar tree shrew').
ncbi_mult_taxo_gbnm(320359, 'Palawan tree shrew').
ncbi_mult_taxo_gbnm(320362, 'ruddy tree shrew').
ncbi_mult_taxo_gbnm(320379, 'curlfin sole').
ncbi_mult_taxo_gbnm(320380, 'spotted turbot').
ncbi_mult_taxo_gbnm(320383, 'oval damselfish').
ncbi_mult_taxo_gbnm(320385, 'blob sculpin').
ncbi_mult_taxo_gbnm(320392, 'black croaker').
ncbi_mult_taxo_gbnm(320393, 'shortfin weakfish').
ncbi_mult_taxo_gbnm(320395, 'white croaker').
ncbi_mult_taxo_gbnm(320396, 'California kingcroaker').
ncbi_mult_taxo_gbnm(320399, 'yellowfin drum').
ncbi_mult_taxo_gbnm(320400, 'rainbow scorpionfish').
ncbi_mult_taxo_gbnm(320403, 'broomtail grouper').
ncbi_mult_taxo_gbnm(320404, 'highlight hatchetfish').
ncbi_mult_taxo_gbnm(320408, 'six-spot prickleback').
ncbi_mult_taxo_gbnm(320412, 'Pacific pompano').
ncbi_mult_taxo_gbnm(320416, 'king-of-the-salmon').
ncbi_mult_taxo_gbnm(320430, 'destructive pygmy rice rat').
ncbi_mult_taxo_gbnm(320431, 'acuminate horseshoe bat').
ncbi_mult_taxo_gbnm(320457, 'slender tuna').
ncbi_mult_taxo_gbnm(320472, 'Sonoran false brook salamander').
ncbi_mult_taxo_gbnm(320473, 'Oaxacan false brook salamander').
ncbi_mult_taxo_gbnm(320550, 'Emilia\'s gracile mouse opossum').
ncbi_mult_taxo_gbnm(320551, 'Aceramarca gracile mouse opossum').
ncbi_mult_taxo_gbnm(320562, 'monkey goby').
ncbi_mult_taxo_gbnm(320563, 'ratan goby').
ncbi_mult_taxo_gbnm(320564, 'syrman goby').
ncbi_mult_taxo_gbnm(320565, 'bighead goby').
ncbi_mult_taxo_gbnm(320567, 'racer goby').
ncbi_mult_taxo_gbnm(320568, 'halfbanded rockfish').
ncbi_mult_taxo_gbnm(320584, 'ant-hunting spiders').
ncbi_mult_taxo_gbnm(320586, 'razorback scabbardfish').
ncbi_mult_taxo_gbnm(320588, 'lumptail searobin').
ncbi_mult_taxo_gbnm(320591, 'snakehead eelpout').
ncbi_mult_taxo_gbnm(320605, 'silver mojarra').
ncbi_mult_taxo_gbnm(320607, 'roughcheek sculpin').
ncbi_mult_taxo_gbnm(320609, 'Pacific cubera snapper').
ncbi_mult_taxo_gbnm(320610, 'zebra goby').
ncbi_mult_taxo_gbnm(320611, 'fringed sculpin').
ncbi_mult_taxo_gbnm(320612, 'sturgeon poacher').
ncbi_mult_taxo_gbnm(320615, 'decorated warbonnet').
ncbi_mult_taxo_gbnm(320617, 'buffalo sculpin').
ncbi_mult_taxo_gbnm(320618, 'tidepool snailfish').
ncbi_mult_taxo_gbnm(320620, 'pygmy poacher').
ncbi_mult_taxo_gbnm(320621, 'Pacific porgy').
ncbi_mult_taxo_gbnm(320623, 'high cockscomb').
ncbi_mult_taxo_gbnm(320636, 'golden-rumped elephant shrew').
ncbi_mult_taxo_gbnm(320637, 'black and rufous elephant shrew').
ncbi_mult_taxo_gbnm(320667, 'pointed gourd').
ncbi_mult_taxo_gbnm(320701, 'sooty gull').
ncbi_mult_taxo_gbnm(320702, 'common sandpiper').
ncbi_mult_taxo_gbnm(320741, 'Cofre de Perote salamander').
ncbi_mult_taxo_gbnm(320797, 'false pak-choi').
ncbi_mult_taxo_gbnm(320950, 'Caddo Mountain salamander').
ncbi_mult_taxo_gbnm(320951, 'white-throated slimy salamander').
ncbi_mult_taxo_gbnm(320952, 'Central Georgia slimy salamander').
ncbi_mult_taxo_gbnm(320953, 'South Carolina slimy salamander').
ncbi_mult_taxo_gbnm(321043, 'koki`o ula').
ncbi_mult_taxo_gbnm(321052, 'ma`o hau hele').
ncbi_mult_taxo_gbnm(321084, 'black-chested snake-eagle').
ncbi_mult_taxo_gbnm(321093, 'white hawk').
ncbi_mult_taxo_gbnm(321096, 'African marsh-harrier').
ncbi_mult_taxo_gbnm(321111, 'long-crested eagle').
ncbi_mult_taxo_gbnm(321164, 'Japanese Spanish mackerel').
ncbi_mult_taxo_gbnm(321263, 'Southwestern Myotis').
ncbi_mult_taxo_gbnm(321387, 'French heartworm').
ncbi_mult_taxo_gbnm(321389, 'cat lungworm').
ncbi_mult_taxo_gbnm(321398, 'blue-crowned manakin').
ncbi_mult_taxo_gbnm(321399, 'opal-crowned manakin').
ncbi_mult_taxo_gbnm(321400, 'White-fronted manakin').
ncbi_mult_taxo_gbnm(321403, 'Beira killifish').
ncbi_mult_taxo_gbnm(321593, 'Korean blackberry').
ncbi_mult_taxo_gbnm(321805, 'southern roundgland toad').
ncbi_mult_taxo_gbnm(321806, 'northern rough-gland toad').
ncbi_mult_taxo_gbnm(321821, 'avocado thrips').
ncbi_mult_taxo_gbnm(322010, 'Madeira firecrest').
ncbi_mult_taxo_gbnm(322013, 'Korean crevice salamander').
ncbi_mult_taxo_gbnm(322040, 'yellow buckeye').
ncbi_mult_taxo_gbnm(322041, 'painted buckeye').
ncbi_mult_taxo_gbnm(322105, 'Gangetic loach').
ncbi_mult_taxo_gbnm(322108, 'Almorha loach').
ncbi_mult_taxo_gbnm(322109, 'reticulate loach').
ncbi_mult_taxo_gbnm(322110, 'zebra loach').
ncbi_mult_taxo_gbnm(322112, 'sun loach').
ncbi_mult_taxo_gbnm(322113, 'skunk botia').
ncbi_mult_taxo_gbnm(322115, 'redtail botia').
ncbi_mult_taxo_gbnm(322116, 'silver loach').
ncbi_mult_taxo_gbnm(322118, 'chameleon loach').
ncbi_mult_taxo_gbnm(322121, 'Blyth\'s loach').
ncbi_mult_taxo_gbnm(322122, 'tiger botia').
ncbi_mult_taxo_gbnm(322124, 'tiger loach').
ncbi_mult_taxo_gbnm(322131, 'clown loach').
ncbi_mult_taxo_gbnm(322133, 'Bengal loach').
ncbi_mult_taxo_gbnm(322144, 'Balkan\'s warbler').
ncbi_mult_taxo_gbnm(322465, 'pine cone beetle').
ncbi_mult_taxo_gbnm(322499, 'Tokba river frog').
ncbi_mult_taxo_gbnm(322501, 'coast river frog').
ncbi_mult_taxo_gbnm(322503, 'Macenta river frog').
ncbi_mult_taxo_gbnm(322504, 'Sierra Leone water frog').
ncbi_mult_taxo_gbnm(322563, 'tubenose goby').
ncbi_mult_taxo_gbnm(322683, 'smoothhead sculpin').
ncbi_mult_taxo_gbnm(322708, 'marsh mouse').
ncbi_mult_taxo_gbnm(322709, 'brown deer mouse').
ncbi_mult_taxo_gbnm(322711, 'slender-tailed deer mouse').
ncbi_mult_taxo_gbnm(323045, 'grassland croton').
ncbi_mult_taxo_gbnm(323096, 'Buddha belly bamboo').
ncbi_mult_taxo_gbnm(323362, 'thin sand rat').
ncbi_mult_taxo_gbnm(323367, 'Desmarest\'s spiny pocket mouse').
ncbi_mult_taxo_gbnm(323369, 'painted spiny pocket mouse').
ncbi_mult_taxo_gbnm(323370, 'Mexican spiny pocket mouse').
ncbi_mult_taxo_gbnm(323371, 'pale kangaroo mouse').
ncbi_mult_taxo_gbnm(323373, 'San Jose Island kangaroo rat').
ncbi_mult_taxo_gbnm(323374, 'Fresno kangaroo rat').
ncbi_mult_taxo_gbnm(323375, 'narrow-faced kangaroo rat').
ncbi_mult_taxo_gbnm(323376, 'big-eared kangaroo rat').
ncbi_mult_taxo_gbnm(323377, 'San Quintin kangaroo rat').
ncbi_mult_taxo_gbnm(323378, 'Gulf coast kangaroo rat').
ncbi_mult_taxo_gbnm(323379, 'Stephens\'s kangaroo rat').
ncbi_mult_taxo_gbnm(323380, 'white-eared pocket mouse').
ncbi_mult_taxo_gbnm(323382, 'Dulzura kangaroo rat').
ncbi_mult_taxo_gbnm(323442, 'Costa Rican spinner dolphin').
ncbi_mult_taxo_gbnm(323527, 'basin white-lipped frog').
ncbi_mult_taxo_gbnm(323567, 'water anole').
ncbi_mult_taxo_gbnm(323568, 'grass anole').
ncbi_mult_taxo_gbnm(323581, 'bridled anole').
ncbi_mult_taxo_gbnm(323603, 'silky anole').
ncbi_mult_taxo_gbnm(323619, 'cooloola monsters').
ncbi_mult_taxo_gbnm(323638, 'meadow katydids').
ncbi_mult_taxo_gbnm(323665, 'lesser yam').
ncbi_mult_taxo_gbnm(323675, 'three-spot grass yellow').
ncbi_mult_taxo_gbnm(323738, 'Short-necked skink').
ncbi_mult_taxo_gbnm(323754, 'Carpathian newt').
ncbi_mult_taxo_gbnm(323755, 'South Italian newt').
ncbi_mult_taxo_gbnm(323757, 'Bosca\'s newt').
ncbi_mult_taxo_gbnm(323764, bream).
ncbi_mult_taxo_gbnm(323791, 'one-and-a-half-stripe hap').
ncbi_mult_taxo_gbnm(323800, 'snail-crusher hap').
ncbi_mult_taxo_gbnm(323802, 'longtooth grouper').
ncbi_mult_taxo_gbnm(323803, 'oblique-banded grouper').
ncbi_mult_taxo_gbnm(323804, 'shorthead catfish').
ncbi_mult_taxo_gbnm(324337, 'Ochikura swamp salamander').
ncbi_mult_taxo_gbnm(324339, 'Sendai salamander').
ncbi_mult_taxo_gbnm(324340, 'Oki salamander').
ncbi_mult_taxo_gbnm(324341, 'Taichu salamander').
ncbi_mult_taxo_gbnm(324342, 'amber-colored salamander').
ncbi_mult_taxo_gbnm(324343, 'Honshu salamander').
ncbi_mult_taxo_gbnm(324344, 'Tokyo salamander').
ncbi_mult_taxo_gbnm(324346, 'Gulf Coast waterdog').
ncbi_mult_taxo_gbnm(324348, 'Persian mountain salamander').
ncbi_mult_taxo_gbnm(324349, 'mud salamander').
ncbi_mult_taxo_gbnm(324813, 'red-spotted purple').
ncbi_mult_taxo_gbnm(325342, 'Abyssinian roller').
ncbi_mult_taxo_gbnm(325347, 'collared kingfisher').
ncbi_mult_taxo_gbnm(325525, 'loose silky-bent').
ncbi_mult_taxo_gbnm(325554, 'Taiwan groove-toed frog').
ncbi_mult_taxo_gbnm(325555, 'Gunther\'s Borneo frog').
ncbi_mult_taxo_gbnm(325556, 'Chungan torrent frog').
ncbi_mult_taxo_gbnm(325557, 'granular torrent frog').
ncbi_mult_taxo_gbnm(325558, 'Lifan torrent frog').
ncbi_mult_taxo_gbnm(325560, 'Larut sucker frog').
ncbi_mult_taxo_gbnm(325561, 'marbled sucker frog').
ncbi_mult_taxo_gbnm(325564, 'Sabah Borneo frog').
ncbi_mult_taxo_gbnm(325565, 'Sabah huia frog').
ncbi_mult_taxo_gbnm(325567, 'Sumatra huia frog').
ncbi_mult_taxo_gbnm(325615, 'threelined potato beetle').
ncbi_mult_taxo_gbnm(325629, 'black scraper').
ncbi_mult_taxo_gbnm(325638, 'prickly stick-insect').
ncbi_mult_taxo_gbnm(325639, 'unarmed stick insect').
ncbi_mult_taxo_gbnm(325643, 'smooth stick-insect').
ncbi_mult_taxo_gbnm(325904, 'large fig hornworm').
ncbi_mult_taxo_gbnm(326081, 'Dyak fruit bat').
ncbi_mult_taxo_gbnm(326151, 'Lucas\'s short-nosed fruit bat').
ncbi_mult_taxo_gbnm(326183, 'Vanzolini\'s Amazon frog').
ncbi_mult_taxo_gbnm(326184, 'Napo tropical bullfrog').
ncbi_mult_taxo_gbnm(326186, 'Rivero\'s white-lipped frog').
ncbi_mult_taxo_gbnm(326187, 'Honduras white-lipped frog').
ncbi_mult_taxo_gbnm(326188, 'Vizcacheras\' white-lipped frog').
ncbi_mult_taxo_gbnm(326189, 'Cei\'s white-lipped frog').
ncbi_mult_taxo_gbnm(326190, 'San Miguel Island frog').
ncbi_mult_taxo_gbnm(326576, 'bushy-tailed mongoose').
ncbi_mult_taxo_gbnm(326577, 'black-footed mongoose').
ncbi_mult_taxo_gbnm(326593, 'Knudsen\'s thin-toed frog').
ncbi_mult_taxo_gbnm(326724, 'golden trevally').
ncbi_mult_taxo_gbnm(326940, 'bamboo leaf odorous frog').
ncbi_mult_taxo_gbnm(326968, 'common jujube').
ncbi_mult_taxo_gbnm(326975, 'grainy frogs').
ncbi_mult_taxo_gbnm(326982, 'Chiriqui robber frog').
ncbi_mult_taxo_gbnm(326987, 'stuttering frog').
ncbi_mult_taxo_gbnm(326991, 'yellow-throated Papua frogs').
ncbi_mult_taxo_gbnm(327405, 'Japanese chub').
ncbi_mult_taxo_gbnm(327501, 'gerbil leaf-eared mouse').
ncbi_mult_taxo_gbnm(327506, 'Damara ground squirrel').
ncbi_mult_taxo_gbnm(327507, 'striped ground squirrel').
ncbi_mult_taxo_gbnm(327683, 'Kessler\'s gudgeon').
ncbi_mult_taxo_gbnm(327685, 'Danubian longbarbel gudgeon').
ncbi_mult_taxo_gbnm(327690, 'roving coralgrouper').
ncbi_mult_taxo_gbnm(327698, 'common marinka').
ncbi_mult_taxo_gbnm(327704, 'Kunar snowtrout').
ncbi_mult_taxo_gbnm(327713, 'bromeliad robber frog').
ncbi_mult_taxo_gbnm(327714, 'DeVille\'s robber frog').
ncbi_mult_taxo_gbnm(327715, 'Apurimac robber frog').
ncbi_mult_taxo_gbnm(327731, 'cloud forest robber frog').
ncbi_mult_taxo_gbnm(327732, 'striped robber frog').
ncbi_mult_taxo_gbnm(327762, 'torrent stone carp').
ncbi_mult_taxo_gbnm(327769, 'tenspine grouper').
ncbi_mult_taxo_gbnm(327770, 'potato grouper').
ncbi_mult_taxo_gbnm(327771, 'leopard hind').
ncbi_mult_taxo_gbnm(327773, 'whitespotted grouper').
ncbi_mult_taxo_gbnm(327774, 'eightbar grouper').
ncbi_mult_taxo_gbnm(327777, 'white-streaked grouper').
ncbi_mult_taxo_gbnm(327779, 'coral grouper').
ncbi_mult_taxo_gbnm(327781, 'foureye basslet').
ncbi_mult_taxo_gbnm(327782, 'honeycomb podge').
ncbi_mult_taxo_gbnm(327785, 'tiger grouper').
ncbi_mult_taxo_gbnm(327786, 'blackfin soapfish').
ncbi_mult_taxo_gbnm(327790, 'candy basslet').
ncbi_mult_taxo_gbnm(327793, 'wrasse bass').
ncbi_mult_taxo_gbnm(327796, 'masked grouper').
ncbi_mult_taxo_gbnm(327797, 'sawtail grouper').
ncbi_mult_taxo_gbnm(327799, 'halfmoon grouper').
ncbi_mult_taxo_gbnm(327800, 'mottled grouper').
ncbi_mult_taxo_gbnm(327802, 'white-edged grouper').
ncbi_mult_taxo_gbnm(327803, 'comb grouper').
ncbi_mult_taxo_gbnm(327804, 'catface grouper').
ncbi_mult_taxo_gbnm(327806, 'island grouper').
ncbi_mult_taxo_gbnm(327807, 'garish hind').
ncbi_mult_taxo_gbnm(327810, 'Niger hind').
ncbi_mult_taxo_gbnm(327812, 'sevenbar grouper').
ncbi_mult_taxo_gbnm(327813, 'blue and yellow grouper').
ncbi_mult_taxo_gbnm(327814, 'splittail bass').
ncbi_mult_taxo_gbnm(327816, 'eastern wirrah').
ncbi_mult_taxo_gbnm(327818, 'squaretail coralgrouper').
ncbi_mult_taxo_gbnm(327819, 'highfin coralgrouper').
ncbi_mult_taxo_gbnm(327821, 'swallowtail seaperch').
ncbi_mult_taxo_gbnm(327826, 'blacksaddle grouper').
ncbi_mult_taxo_gbnm(327827, 'Dungat grouper').
ncbi_mult_taxo_gbnm(327828, 'rock grouper').
ncbi_mult_taxo_gbnm(327829, 'red-tipped grouper').
ncbi_mult_taxo_gbnm(327831, 'harlequin hind').
ncbi_mult_taxo_gbnm(327832, 'comet grouper').
ncbi_mult_taxo_gbnm(327941, 'yellowmouth grouper').
ncbi_mult_taxo_gbnm(327942, 'one-blotch grouper').
ncbi_mult_taxo_gbnm(327943, 'netfin grouper').
ncbi_mult_taxo_gbnm(327944, 'saddletail grouper').
ncbi_mult_taxo_gbnm(327945, 'Maori grouper').
ncbi_mult_taxo_gbnm(327957, 'African manatee').
ncbi_mult_taxo_gbnm(327958, 'Angola river frog').
ncbi_mult_taxo_gbnm(327960, 'Hainan sucker frog').
ncbi_mult_taxo_gbnm(327962, 'Abo slippery frog').
ncbi_mult_taxo_gbnm(327965, 'Natal puddle frog').
ncbi_mult_taxo_gbnm(328019, 'Dolphin gull').
ncbi_mult_taxo_gbnm(328043, 'white-eyed gull').
ncbi_mult_taxo_gbnm(328046, 'relict gull').
ncbi_mult_taxo_gbnm(328047, 'Lava gull').
ncbi_mult_taxo_gbnm(328185, 'poultry shaft louse').
ncbi_mult_taxo_gbnm(328267, 'current saddled darter').
ncbi_mult_taxo_gbnm(328269, 'candy darter').
ncbi_mult_taxo_gbnm(328270, 'Niangua darter').
ncbi_mult_taxo_gbnm(328271, 'Kentucky arrow darter').
ncbi_mult_taxo_gbnm(328363, 'western water shrew').
ncbi_mult_taxo_gbnm(328410, 'tidepool sculpin').
ncbi_mult_taxo_gbnm(328518, 'rainbow gudgeon').
ncbi_mult_taxo_gbnm(328524, 'barbel steed').
ncbi_mult_taxo_gbnm(328535, 'Amur white gudgeon').
ncbi_mult_taxo_gbnm(328536, 'Siberian gudgeon').
ncbi_mult_taxo_gbnm(328543, 'long-nosed gudgeon').
ncbi_mult_taxo_gbnm(328639, bester).
ncbi_mult_taxo_gbnm(328699, 'crab-eating mongoose').
ncbi_mult_taxo_gbnm(328804, 'spectacled flying fox').
ncbi_mult_taxo_gbnm(328808, 'ringneck dove').
ncbi_mult_taxo_gbnm(328815, 'golden-collared manakin').
ncbi_mult_taxo_gbnm(328878, 'Behr\'s hairstreak').
ncbi_mult_taxo_gbnm(328891, 'Duke of Burgundy fritillary').
ncbi_mult_taxo_gbnm(328961, 'lesser musky fruit bat').
ncbi_mult_taxo_gbnm(328968, 'Luzon fruit bat').
ncbi_mult_taxo_gbnm(329022, 'finescale menhaden').
ncbi_mult_taxo_gbnm(329023, 'yellowfin menhaden').
ncbi_mult_taxo_gbnm(329027, kawakawa).
ncbi_mult_taxo_gbnm(329116, 'Thai mahseer').
ncbi_mult_taxo_gbnm(329145, 'big-headed amazon river turtle').
ncbi_mult_taxo_gbnm(329257, 'glandular frog').
ncbi_mult_taxo_gbnm(329258, 'masked rough-sided frog').
ncbi_mult_taxo_gbnm(329337, biajaca).
ncbi_mult_taxo_gbnm(329382, 'long-tailed shrew').
ncbi_mult_taxo_gbnm(329383, 'Gaspe shrew').
ncbi_mult_taxo_gbnm(329431, 'black drum').
ncbi_mult_taxo_gbnm(329433, 'banded drum').
ncbi_mult_taxo_gbnm(329465, 'Mexican flounder').
ncbi_mult_taxo_gbnm(329467, 'plainfin sole').
ncbi_mult_taxo_gbnm(329504, 'rusty-winged barbtail').
ncbi_mult_taxo_gbnm(329620, 'Northern mole vole').
ncbi_mult_taxo_gbnm(329621, 'Ciscaucasian hamster').
ncbi_mult_taxo_gbnm(329624, 'Romanian hamster').
ncbi_mult_taxo_gbnm(329627, 'greater long-tailed hamster').
ncbi_mult_taxo_gbnm(329629, 'striped dwarf hamster').
ncbi_mult_taxo_gbnm(329634, 'Eversmann\'s hamster').
ncbi_mult_taxo_gbnm(329637, 'Sokolov\'s dwarf hamster').
ncbi_mult_taxo_gbnm(329675, 'winter daphne').
ncbi_mult_taxo_gbnm(329863, 'Cowan\'s shrew tenrec').
ncbi_mult_taxo_gbnm(329870, 'Persian trident bat').
ncbi_mult_taxo_gbnm(329872, 'Grandidier\'s trident bat').
ncbi_mult_taxo_gbnm(329888, 'Olive Montane mouse').
ncbi_mult_taxo_gbnm(329899, 'bowl and doily spider').
ncbi_mult_taxo_gbnm(329904, 'orchard orbweaver').
ncbi_mult_taxo_gbnm(329967, 'south torrent catfish').
ncbi_mult_taxo_gbnm(330149, 'Yucatan wren').
ncbi_mult_taxo_gbnm(330163, 'Mexican tea').
ncbi_mult_taxo_gbnm(330174, seedbox).
ncbi_mult_taxo_gbnm(330311, 'little false apollo').
ncbi_mult_taxo_gbnm(330353, 'keeled apollo').
ncbi_mult_taxo_gbnm(330452, 'leafcurl plum aphid').
ncbi_mult_taxo_gbnm(330458, 'lupin aphid').
ncbi_mult_taxo_gbnm(330460, 'sowthistle aphid').
ncbi_mult_taxo_gbnm(330465, 'Arabian tahr').
ncbi_mult_taxo_gbnm(330481, 'Seychelles white-eye').
ncbi_mult_taxo_gbnm(330682, 'masked flowerpiercer').
ncbi_mult_taxo_gbnm(330684, 'Sardinian meadow brown').
ncbi_mult_taxo_gbnm(330758, 'red-winged warbler').
ncbi_mult_taxo_gbnm(330761, 'Red-faced crombec').
ncbi_mult_taxo_gbnm(330826, 'Quito stubfoot toad').
ncbi_mult_taxo_gbnm(330828, 'Pebas stubfoot toad').
ncbi_mult_taxo_gbnm(330829, 'central coast stubfoot toad').
ncbi_mult_taxo_gbnm(330831, 'Cayenne stubfoot toad').
ncbi_mult_taxo_gbnm(330947, 'great barred frog').
ncbi_mult_taxo_gbnm(331036, dzo).
ncbi_mult_taxo_gbnm(331275, 'Djeddah snapping shrimp').
ncbi_mult_taxo_gbnm(331510, 'coconut mite').
ncbi_mult_taxo_gbnm(331523, 'silver perch').
ncbi_mult_taxo_gbnm(331524, 'American stardrum').
ncbi_mult_taxo_gbnm(332089, 'Cochin Forest cane turtle').
ncbi_mult_taxo_gbnm(332092, 'Trinidad leaf frog').
ncbi_mult_taxo_gbnm(332176, 'Yakushima sika deer').
ncbi_mult_taxo_gbnm(332417, 'strong spined silver-biddy').
ncbi_mult_taxo_gbnm(332418, 'flagfin mojarra').
ncbi_mult_taxo_gbnm(332423, 'tadpole whiptail').
ncbi_mult_taxo_gbnm(332544, 'Griswold\'s marsupial frog').
ncbi_mult_taxo_gbnm(332545, 'Peru white-lipped frog').
ncbi_mult_taxo_gbnm(332552, 'Junin Andes frog').
ncbi_mult_taxo_gbnm(332565, 'marbled four-eyed frog').
ncbi_mult_taxo_gbnm(332573, 'Gabilan Mountains slender salamander').
ncbi_mult_taxo_gbnm(332574, 'brown-backed salamander').
ncbi_mult_taxo_gbnm(332575, 'southern two-lined salamander').
ncbi_mult_taxo_gbnm(332576, 'three-lined salamander').
ncbi_mult_taxo_gbnm(332577, 'Junaluska salamander').
ncbi_mult_taxo_gbnm(332578, 'Ozark salamander').
ncbi_mult_taxo_gbnm(332579, 'Kiamichi slimy salamander').
ncbi_mult_taxo_gbnm(332580, 'Louisiana slimy salamander').
ncbi_mult_taxo_gbnm(332581, 'Sequoyah slimy salamander').
ncbi_mult_taxo_gbnm(332626, 'Great Basin rattlesnake').
ncbi_mult_taxo_gbnm(332661, 'squirrel-toothed rat').
ncbi_mult_taxo_gbnm(332664, 'Millard\'s rat').
ncbi_mult_taxo_gbnm(332665, 'Bartels\'s spiny rat').
ncbi_mult_taxo_gbnm(332666, 'Oldfield white-bellied rat').
ncbi_mult_taxo_gbnm(332668, 'rufous-nosed rat').
ncbi_mult_taxo_gbnm(332670, 'Sagami grenadier').
ncbi_mult_taxo_gbnm(332673, 'Acacia rat').
ncbi_mult_taxo_gbnm(332922, 'slough anchovy').
ncbi_mult_taxo_gbnm(332930, 'large emperor moth').
ncbi_mult_taxo_gbnm(332931, 'emperor moth').
ncbi_mult_taxo_gbnm(333344, mizuna).
ncbi_mult_taxo_gbnm(333388, 'Edward\'s swamp rat').
ncbi_mult_taxo_gbnm(333390, 'Cutch rat').
ncbi_mult_taxo_gbnm(333423, 'latticed sandperch').
ncbi_mult_taxo_gbnm(333424, 'pinhead pearlfish').
ncbi_mult_taxo_gbnm(333676, 'white-lipped frog').
ncbi_mult_taxo_gbnm(333677, 'common squeaker').
ncbi_mult_taxo_gbnm(333678, 'Tanzania screeching frog').
ncbi_mult_taxo_gbnm(333679, 'Cape dainty frog').
ncbi_mult_taxo_gbnm(333681, 'Rio Benito long-fingered frog').
ncbi_mult_taxo_gbnm(333683, 'Cameroon water frog').
ncbi_mult_taxo_gbnm(333684, 'Usambara torrent frog').
ncbi_mult_taxo_gbnm(333685, 'Newton\'s water frog').
ncbi_mult_taxo_gbnm(333686, 'Zanzibar puddle frog').
ncbi_mult_taxo_gbnm(333687, 'African swamp frog').
ncbi_mult_taxo_gbnm(333688, 'eared river frog').
ncbi_mult_taxo_gbnm(333690, 'Nkongsamba river frog').
ncbi_mult_taxo_gbnm(333691, 'Krefft\'s river frog').
ncbi_mult_taxo_gbnm(333692, 'edible bullfrog').
ncbi_mult_taxo_gbnm(333694, 'Gray\'s stream frog').
ncbi_mult_taxo_gbnm(333697, 'southern night frog').
ncbi_mult_taxo_gbnm(333698, 'hook frogs').
ncbi_mult_taxo_gbnm(333699, 'Kogelberg Reserve frog').
ncbi_mult_taxo_gbnm(334015, 'Korean hairstreak').
ncbi_mult_taxo_gbnm(334198, 'Spurred roundleaf bat').
ncbi_mult_taxo_gbnm(334201, 'Pomona leaf-nosed bat').
ncbi_mult_taxo_gbnm(334371, 'blackrim cusk-eel').
ncbi_mult_taxo_gbnm(334374, 'dusky brotulid').
ncbi_mult_taxo_gbnm(334378, 'roughbar frogfish').
ncbi_mult_taxo_gbnm(334379, 'doublespotted queenfish').
ncbi_mult_taxo_gbnm(334382, 'red bandfish').
ncbi_mult_taxo_gbnm(334385, 'Irish mojarra').
ncbi_mult_taxo_gbnm(334393, 'scaled belly toothpony').
ncbi_mult_taxo_gbnm(334402, 'goldstripe ponyfish').
ncbi_mult_taxo_gbnm(334483, 'rose-apple').
ncbi_mult_taxo_gbnm(334583, 'Sicilian pond turtle').
ncbi_mult_taxo_gbnm(334657, 'ridged treefrog').
ncbi_mult_taxo_gbnm(334658, 'Annam treefrog').
ncbi_mult_taxo_gbnm(334659, 'wallum froglet').
ncbi_mult_taxo_gbnm(334689, 'Indian spurgetree').
ncbi_mult_taxo_gbnm(334711, 'Ganzi River scaleless carp').
ncbi_mult_taxo_gbnm(334713, 'ornate ponyfish').
ncbi_mult_taxo_gbnm(334752, 'Italian locust').
ncbi_mult_taxo_gbnm(334873, 'Chinese silver pomfret').
ncbi_mult_taxo_gbnm(334875, 'Antarctic butterfish').
ncbi_mult_taxo_gbnm(334877, 'Tasmanian ruffe').
ncbi_mult_taxo_gbnm(334878, 'short mackerel').
ncbi_mult_taxo_gbnm(334879, 'Australian bonito').
ncbi_mult_taxo_gbnm(334880, knifejaw).
ncbi_mult_taxo_gbnm(334881, 'sailfin armourhead').
ncbi_mult_taxo_gbnm(334885, 'pelagic armorhead').
ncbi_mult_taxo_gbnm(334887, 'bigspined boarfish').
ncbi_mult_taxo_gbnm(334891, 'Tiera batfish').
ncbi_mult_taxo_gbnm(334892, 'Australian mado').
ncbi_mult_taxo_gbnm(334893, 'humpback batfish').
ncbi_mult_taxo_gbnm(334894, 'sea sweep').
ncbi_mult_taxo_gbnm(334896, 'silver moony').
ncbi_mult_taxo_gbnm(334902, 'southern goatfish').
ncbi_mult_taxo_gbnm(334903, 'Madagascar meagre').
ncbi_mult_taxo_gbnm(334904, 'Indian goatfish').
ncbi_mult_taxo_gbnm(334905, 'sharpnose hammer croaker').
ncbi_mult_taxo_gbnm(334908, 'yellow croaker').
ncbi_mult_taxo_gbnm(334909, 'geelbeck croaker').
ncbi_mult_taxo_gbnm(334914, 'coral hind').
ncbi_mult_taxo_gbnm(334915, 'white-edged lyretail').
ncbi_mult_taxo_gbnm(334916, 'marbled flathead').
ncbi_mult_taxo_gbnm(334922, 'yank flathead').
ncbi_mult_taxo_gbnm(334924, 'long-spined flathead').
ncbi_mult_taxo_gbnm(334926, 'dusky flathead').
ncbi_mult_taxo_gbnm(334927, 'bar-tailed flathead').
ncbi_mult_taxo_gbnm(334928, 'northern sand flathead').
ncbi_mult_taxo_gbnm(334929, 'blue-spotted flathead').
ncbi_mult_taxo_gbnm(334931, 'fringe-eyed flathead').
ncbi_mult_taxo_gbnm(334934, 'toothy flathead').
ncbi_mult_taxo_gbnm(334936, 'rough-snouted grunard').
ncbi_mult_taxo_gbnm(334937, 'butterfly gurnard').
ncbi_mult_taxo_gbnm(334939, 'yellow spotted gurnard').
ncbi_mult_taxo_gbnm(334940, latchet).
ncbi_mult_taxo_gbnm(334942, 'bluefin gurnard').
ncbi_mult_taxo_gbnm(334977, 'red rock cod').
ncbi_mult_taxo_gbnm(334984, 'Darwin\'s slimehead').
ncbi_mult_taxo_gbnm(334985, 'giant sawbelly').
ncbi_mult_taxo_gbnm(334986, 'Ogilby\'s ghostshark').
ncbi_mult_taxo_gbnm(334987, 'blackfin ghostshark').
ncbi_mult_taxo_gbnm(334988, 'dark ghost shark').
ncbi_mult_taxo_gbnm(334989, 'Australian bull ray').
ncbi_mult_taxo_gbnm(334990, 'mottled eagle ray').
ncbi_mult_taxo_gbnm(334991, 'Australian cownose ray').
ncbi_mult_taxo_gbnm(334992, 'brown stingaree').
ncbi_mult_taxo_gbnm(334993, 'crossback stingaree').
ncbi_mult_taxo_gbnm(334994, 'sparsely-spotted stingaree').
ncbi_mult_taxo_gbnm(334995, 'Australian butterfly ray').
ncbi_mult_taxo_gbnm(334997, 'whitenose whip ray').
ncbi_mult_taxo_gbnm(334998, 'honeycomb whipray').
ncbi_mult_taxo_gbnm(334999, 'Jenkins\' whipray').
ncbi_mult_taxo_gbnm(335000, 'painted maskray').
ncbi_mult_taxo_gbnm(335001, 'pink whipray').
ncbi_mult_taxo_gbnm(335002, 'wedgenose skate').
ncbi_mult_taxo_gbnm(335004, 'Sydney skate').
ncbi_mult_taxo_gbnm(335005, 'white-spotted skate').
ncbi_mult_taxo_gbnm(335006, 'whitespotted wedgefish').
ncbi_mult_taxo_gbnm(335007, 'Australian angelshark').
ncbi_mult_taxo_gbnm(335008, 'ornate angelshark').
ncbi_mult_taxo_gbnm(335010, 'velvet dogfish').
ncbi_mult_taxo_gbnm(335012, 'southern lanternshark').
ncbi_mult_taxo_gbnm(335024, 'Mandarin dogfish').
ncbi_mult_taxo_gbnm(335025, 'birdbeak dogfish').
ncbi_mult_taxo_gbnm(335026, 'smallfin gulper shark').
ncbi_mult_taxo_gbnm(335027, 'leafscale gulper shark').
ncbi_mult_taxo_gbnm(335028, 'longnose velvet dogfish').
ncbi_mult_taxo_gbnm(335034, 'spotted estuary smooth-hound').
ncbi_mult_taxo_gbnm(335035, 'whitecheek shark').
ncbi_mult_taxo_gbnm(335037, 'whiskery shark').
ncbi_mult_taxo_gbnm(335038, 'Australian swellshark').
ncbi_mult_taxo_gbnm(335061, 'Taiwan gulper shark').
ncbi_mult_taxo_gbnm(335106, 'Spot-tailed nightjar').
ncbi_mult_taxo_gbnm(335108, 'white-winged nightjar').
ncbi_mult_taxo_gbnm(335115, 'Sickle-winged nightjar').
ncbi_mult_taxo_gbnm(335117, 'Scissor-tailed nightjar').
ncbi_mult_taxo_gbnm(335207, 'Grey-faced buzzard').
ncbi_mult_taxo_gbnm(335392, 'wood turtle').
ncbi_mult_taxo_gbnm(335393, 'bog turtle').
ncbi_mult_taxo_gbnm(335395, 'Northwestern pond turtle').
ncbi_mult_taxo_gbnm(335468, 'rosy gypsy moth').
ncbi_mult_taxo_gbnm(335469, 'rusty tussock moth').
ncbi_mult_taxo_gbnm(335473, 'white-spotted tussock moth').
ncbi_mult_taxo_gbnm(335474, 'western tussock moth').
ncbi_mult_taxo_gbnm(335684, 'Sanderson\'s hook frog').
ncbi_mult_taxo_gbnm(335690, 'Rio Grande cutthroat trout').
ncbi_mult_taxo_gbnm(335985, 'Singing honeyeater').
ncbi_mult_taxo_gbnm(335999, 'tomato hornworm').
ncbi_mult_taxo_gbnm(336004, 'summer fishfly').
ncbi_mult_taxo_gbnm(336072, 'pygmy rocketfrog').
ncbi_mult_taxo_gbnm(336074, 'rust-eyed treefrog').
ncbi_mult_taxo_gbnm(336075, 'northern dwarf treefrog').
ncbi_mult_taxo_gbnm(336076, 'black-shinned rocketfrog').
ncbi_mult_taxo_gbnm(336077, 'Australian rocketfrog').
ncbi_mult_taxo_gbnm(336078, 'bumpy rocketfrog').
ncbi_mult_taxo_gbnm(336079, 'peach-sided rocketfrog').
ncbi_mult_taxo_gbnm(336080, 'Copland\'s rock frog').
ncbi_mult_taxo_gbnm(336081, 'giant rocketfrog').
ncbi_mult_taxo_gbnm(336083, 'green-striped burrowing frog').
ncbi_mult_taxo_gbnm(336110, 'triangle cactus').
ncbi_mult_taxo_gbnm(336182, 'rosy-base top shell').
ncbi_mult_taxo_gbnm(336204, 'wandering salamander').
ncbi_mult_taxo_gbnm(336262, 'American gizzard shad').
ncbi_mult_taxo_gbnm(336359, 'small ridged frog').
ncbi_mult_taxo_gbnm(336387, 'red-capped parrot').
ncbi_mult_taxo_gbnm(336389, 'cocaine tussock moth').
ncbi_mult_taxo_gbnm(336939, malbau).
ncbi_mult_taxo_gbnm(337183, 'Himalayan mandrake').
ncbi_mult_taxo_gbnm(337212, 'silvery greater Galago').
ncbi_mult_taxo_gbnm(337228, 'Black-footed Mesembriomys').
ncbi_mult_taxo_gbnm(337444, 'Japanese wood-pigeon').
ncbi_mult_taxo_gbnm(337452, 'Bornean horseshoe bat').
ncbi_mult_taxo_gbnm(337453, 'Woolly horseshoe bat').
ncbi_mult_taxo_gbnm(337508, 'latania scale').
ncbi_mult_taxo_gbnm(337510, 'oleander scale').
ncbi_mult_taxo_gbnm(337514, 'Japanese snake-eyed skink').
ncbi_mult_taxo_gbnm(337539, 'striped dwarf catfish').
ncbi_mult_taxo_gbnm(337541, 'porthole catfish').
ncbi_mult_taxo_gbnm(337575, 'East-African snake-eyed skink').
ncbi_mult_taxo_gbnm(337577, 'Black snake-eyed skink').
ncbi_mult_taxo_gbnm(337582, 'Beaded wood mouse').
ncbi_mult_taxo_gbnm(337583, 'Baer\'s wood mouse').
ncbi_mult_taxo_gbnm(337630, 'electric catfish').
ncbi_mult_taxo_gbnm(337632, 'zebra catfish').
ncbi_mult_taxo_gbnm(337634, 'Indian torrent catfish').
ncbi_mult_taxo_gbnm(337635, 'twospot catfish').
ncbi_mult_taxo_gbnm(337642, 'long-whiskered catfish').
ncbi_mult_taxo_gbnm(337643, 'squarehead catfish').
ncbi_mult_taxo_gbnm(337654, 'hognosed brochis').
ncbi_mult_taxo_gbnm(337658, 'firewood catfish').
ncbi_mult_taxo_gbnm(337667, 'whiptailed loricaria').
ncbi_mult_taxo_gbnm(337678, 'common driftwood catfish').
ncbi_mult_taxo_gbnm(337680, 'whiptail catfish').
ncbi_mult_taxo_gbnm(337699, 'blotched upsidedown catfish').
ncbi_mult_taxo_gbnm(337703, 'sailfin catfish').
ncbi_mult_taxo_gbnm(337715, 'long-barbel sheatfish').
ncbi_mult_taxo_gbnm(337725, 'gray eel-catfish').
ncbi_mult_taxo_gbnm(337739, 'Gunther\'s catfish').
ncbi_mult_taxo_gbnm(337748, 'flying squirrels').
ncbi_mult_taxo_gbnm(337754, 'clown panaque').
ncbi_mult_taxo_gbnm(337757, 'royal panaque').
ncbi_mult_taxo_gbnm(337771, 'largespot squeaker').
ncbi_mult_taxo_gbnm(337775, 'striped glass catfish').
ncbi_mult_taxo_gbnm(337777, 'bigmouth sea catfish').
ncbi_mult_taxo_gbnm(337881, 'largetooth sawfish').
ncbi_mult_taxo_gbnm(337882, 'giant shovelnose ray').
ncbi_mult_taxo_gbnm(337883, 'eastern fiddler').
ncbi_mult_taxo_gbnm(337885, 'redfin waspfish').
ncbi_mult_taxo_gbnm(337887, 'slender walking catfish').
ncbi_mult_taxo_gbnm(338092, 'teta catfish').
ncbi_mult_taxo_gbnm(338093, 'rhino pleco').
ncbi_mult_taxo_gbnm(338161, 'yellow jezebel').
ncbi_mult_taxo_gbnm(338205, 'fire shrimp').
ncbi_mult_taxo_gbnm(338314, 'yellowmouth barracuda').
ncbi_mult_taxo_gbnm(338315, 'Atlantic chub mackerel').
ncbi_mult_taxo_gbnm(338348, 'Beccari\'s keeled skink').
ncbi_mult_taxo_gbnm(338355, 'Bavi water skink').
ncbi_mult_taxo_gbnm(338447, 'shining flycatcher').
ncbi_mult_taxo_gbnm(338457, 'spot-winged monarch').
ncbi_mult_taxo_gbnm(338458, 'Makira monarch').
ncbi_mult_taxo_gbnm(338461, 'black-and-white monarch').
ncbi_mult_taxo_gbnm(338469, 'black-bibbed monarch').
ncbi_mult_taxo_gbnm(338472, 'white-eared monarch').
ncbi_mult_taxo_gbnm(338537, 'South Australian grey mallee').
ncbi_mult_taxo_gbnm(338544, 'flooded gum').
ncbi_mult_taxo_gbnm(338551, 'Beraduccis pygmy chameleon').
ncbi_mult_taxo_gbnm(338552, 'Nguru pygmy chameleon').
ncbi_mult_taxo_gbnm(338556, 'bearded pygmy chameleon').
ncbi_mult_taxo_gbnm(338578, 'hippo grass').
ncbi_mult_taxo_gbnm(338729, 'Guyana river dolphin').
ncbi_mult_taxo_gbnm(338839, 'Macleay\'s water snake').
ncbi_mult_taxo_gbnm(338887, 'black scorpionfish').
ncbi_mult_taxo_gbnm(338888, 'Messina rockfish').
ncbi_mult_taxo_gbnm(338899, 'Tennessee darter').
ncbi_mult_taxo_gbnm(338900, 'duck darter').
ncbi_mult_taxo_gbnm(338901, 'Westrim darter').
ncbi_mult_taxo_gbnm(338902, 'Eastrim darter').
ncbi_mult_taxo_gbnm(339609, 'Greater saber-toothed cat').
ncbi_mult_taxo_gbnm(339612, 'American cheetah-like cat').
ncbi_mult_taxo_gbnm(339614, 'Scimitar-toothed cat').
ncbi_mult_taxo_gbnm(339615, 'baldhip rose').
ncbi_mult_taxo_gbnm(339616, 'cluster rose').
ncbi_mult_taxo_gbnm(339843, 'mulberry looper').
ncbi_mult_taxo_gbnm(340020, 'Aphips chub').
ncbi_mult_taxo_gbnm(340076, 'Screaming hairy armadillo').
ncbi_mult_taxo_gbnm(340180, 'Laotian rock rat').
ncbi_mult_taxo_gbnm(340426, 'miniature melo').
ncbi_mult_taxo_gbnm(340444, gurjan).
ncbi_mult_taxo_gbnm(340692, 'Amur whitefish').
ncbi_mult_taxo_gbnm(340913, 'western brown snake').
ncbi_mult_taxo_gbnm(340988, 'longnose dace').
ncbi_mult_taxo_gbnm(341051, 'bean fly').
ncbi_mult_taxo_gbnm(341052, 'cabbage leafminer').
ncbi_mult_taxo_gbnm(341088, 'Amoy croaker').
ncbi_mult_taxo_gbnm(341122, 'plateau loaches').
ncbi_mult_taxo_gbnm(341242, 'deepsea skate').
ncbi_mult_taxo_gbnm(341243, 'Aleutian skate').
ncbi_mult_taxo_gbnm(341244, 'sandpaper skate').
ncbi_mult_taxo_gbnm(341245, 'cmmander skate').
ncbi_mult_taxo_gbnm(341246, 'white-blotched skate').
ncbi_mult_taxo_gbnm(341248, 'smallthorn skate').
ncbi_mult_taxo_gbnm(341249, 'Alaska skate').
ncbi_mult_taxo_gbnm(341250, 'mud skate').
ncbi_mult_taxo_gbnm(341251, 'roughtail skate').
ncbi_mult_taxo_gbnm(341461, 'European wood-sorrel').
ncbi_mult_taxo_gbnm(341641, 'Chatham mudfish').
ncbi_mult_taxo_gbnm(341642, 'Northland mudfish').
ncbi_mult_taxo_gbnm(341643, 'brown mudfish').
ncbi_mult_taxo_gbnm(341674, 'Alaskan moose').
ncbi_mult_taxo_gbnm(341683, 'purple mombin').
ncbi_mult_taxo_gbnm(341696, 'black-banded trinket snake').
ncbi_mult_taxo_gbnm(341728, 'three-lined tongue sole').
ncbi_mult_taxo_gbnm(341733, 'black cow-tongue').
ncbi_mult_taxo_gbnm(341934, 'Australian round lime').
ncbi_mult_taxo_gbnm(342359, 'dwarf kingfisher').
ncbi_mult_taxo_gbnm(342363, 'Banded kingfisher').
ncbi_mult_taxo_gbnm(342365, 'Stork-billed kingfisher').
ncbi_mult_taxo_gbnm(342375, 'rufous-collared kingfisher').
ncbi_mult_taxo_gbnm(342376, 'spotted kingfisher').
ncbi_mult_taxo_gbnm(342380, 'sacred kingfisher').
ncbi_mult_taxo_gbnm(342385, 'Yellow-billed kingfisher').
ncbi_mult_taxo_gbnm(342387, 'Common paradise-kingfisher').
ncbi_mult_taxo_gbnm(342388, 'rufous-bellied kookaburra').
ncbi_mult_taxo_gbnm(342390, 'blue-winged kookaburra').
ncbi_mult_taxo_gbnm(342402, 'Japanese common plataspid stinkbug').
ncbi_mult_taxo_gbnm(342437, 'guineafowl puffer').
ncbi_mult_taxo_gbnm(342438, 'coral hawkfish').
ncbi_mult_taxo_gbnm(342439, 'striped-fin surgeonfish').
ncbi_mult_taxo_gbnm(342441, glasseye).
ncbi_mult_taxo_gbnm(342443, 'yellowfin goatfish').
ncbi_mult_taxo_gbnm(342444, 'whitespotted boxfish').
ncbi_mult_taxo_gbnm(342569, 'European brook newts').
ncbi_mult_taxo_gbnm(342570, 'Montseny brook newt').
ncbi_mult_taxo_gbnm(342582, 'Taiwan fir').
ncbi_mult_taxo_gbnm(342585, 'Kalinowski\'s opossum').
ncbi_mult_taxo_gbnm(342679, 'Weidemeyer\'s admiral').
ncbi_mult_taxo_gbnm(342690, 'Australasian grebe').
ncbi_mult_taxo_gbnm(342753, 'indigo dropwing').
ncbi_mult_taxo_gbnm(342765, 'dawn dropwing').
ncbi_mult_taxo_gbnm(342811, 'spot-bellied plateau frog').
ncbi_mult_taxo_gbnm(342812, 'Arnold\'s paa frog').
ncbi_mult_taxo_gbnm(342813, 'Chayu spiny frog').
ncbi_mult_taxo_gbnm(342814, 'Cona spiny frog').
ncbi_mult_taxo_gbnm(342815, 'Hong Kong spiny frog').
ncbi_mult_taxo_gbnm(342816, 'Jiulong spiny frog').
ncbi_mult_taxo_gbnm(342817, 'spiny-armed frog').
ncbi_mult_taxo_gbnm(342819, 'piebald spiny frog').
ncbi_mult_taxo_gbnm(342820, 'Medog spiny frog').
ncbi_mult_taxo_gbnm(342821, 'spiny-flanked frog').
ncbi_mult_taxo_gbnm(342822, 'Ye\'s spiny-vented frog').
ncbi_mult_taxo_gbnm(342860, 'Cadorna\'s pipistrelle').
ncbi_mult_taxo_gbnm(342862, 'Mehely\'s horseshoe bat').
ncbi_mult_taxo_gbnm(342863, 'false yellowjacket cichlid').
ncbi_mult_taxo_gbnm(342872, 'Sabah bamboo pitviper').
ncbi_mult_taxo_gbnm(342873, 'banded pit viper').
ncbi_mult_taxo_gbnm(343691, 'black soldier fly').
ncbi_mult_taxo_gbnm(343908, 'Goodman\'s mouse lemur').
ncbi_mult_taxo_gbnm(343929, 'Oriental magpie-robin').
ncbi_mult_taxo_gbnm(343930, 'white-tailed crested-flycatcher').
ncbi_mult_taxo_gbnm(343935, 'Northern crombec').
ncbi_mult_taxo_gbnm(344003, 'Tibetan pit viper').
ncbi_mult_taxo_gbnm(344069, 'lambstongue ragwort').
ncbi_mult_taxo_gbnm(344226, 'South Asian carrion crow').
ncbi_mult_taxo_gbnm(344228, 'Japanese skylark').
ncbi_mult_taxo_gbnm(344243, 'pencil pine moth').
ncbi_mult_taxo_gbnm(344276, 'autumn gum moth').
ncbi_mult_taxo_gbnm(344680, 'Japanese mustard spinach').
ncbi_mult_taxo_gbnm(344755, 'monkey banana').
ncbi_mult_taxo_gbnm(345155, 'lanner falcon').
ncbi_mult_taxo_gbnm(345164, 'Saker falcon').
ncbi_mult_taxo_gbnm(345190, 'slender-billed parakeet').
ncbi_mult_taxo_gbnm(345251, 'Snares penguin').
ncbi_mult_taxo_gbnm(345252, 'freckled blenny').
ncbi_mult_taxo_gbnm(345254, 'orangespotted blenny').
ncbi_mult_taxo_gbnm(345255, 'pearl blenny').
ncbi_mult_taxo_gbnm(345258, 'White-flippered penguin').
ncbi_mult_taxo_gbnm(345260, 'lambchop rasbora').
ncbi_mult_taxo_gbnm(345513, 'broadstripe topminnow').
ncbi_mult_taxo_gbnm(345573, 'great crested grebe').
ncbi_mult_taxo_gbnm(345712, 'mustard white').
ncbi_mult_taxo_gbnm(345714, 'margined white').
ncbi_mult_taxo_gbnm(345718, 'West Virginia white').
ncbi_mult_taxo_gbnm(345719, 'western white').
ncbi_mult_taxo_gbnm(345721, 'sagebrush white').
ncbi_mult_taxo_gbnm(345722, 'small bath white').
ncbi_mult_taxo_gbnm(345724, 'gray marble').
ncbi_mult_taxo_gbnm(345725, 'Olympia marblewing').
ncbi_mult_taxo_gbnm(345734, 'African piculet').
ncbi_mult_taxo_gbnm(345745, 'slate-colored hawk').
ncbi_mult_taxo_gbnm(345749, 'grey-backed hawk').
ncbi_mult_taxo_gbnm(345880, 'painted apple moth').
ncbi_mult_taxo_gbnm(345912, 'annual rabbitsfoot grass').
ncbi_mult_taxo_gbnm(345915, 'spike bentgrass').
ncbi_mult_taxo_gbnm(345916, redtop).
ncbi_mult_taxo_gbnm(346097, 'regal pond cruiser').
ncbi_mult_taxo_gbnm(346249, 'jumbo flying squid').
ncbi_mult_taxo_gbnm(346251, 'scarletfin blenny').
ncbi_mult_taxo_gbnm(346434, 'Rio Chili toad').
ncbi_mult_taxo_gbnm(346437, 'Para toad').
ncbi_mult_taxo_gbnm(346444, 'Paramo toad').
ncbi_mult_taxo_gbnm(346445, 'Bom Jardim toad').
ncbi_mult_taxo_gbnm(346446, 'Cundinamarca toad').
ncbi_mult_taxo_gbnm(346447, 'French Congo toad').
ncbi_mult_taxo_gbnm(346448, 'smooth-sided toad').
ncbi_mult_taxo_gbnm(346449, 'Rivero\'s toad').
ncbi_mult_taxo_gbnm(346450, 'yellow cururu toad').
ncbi_mult_taxo_gbnm(346451, 'Sungei Tawan toad').
ncbi_mult_taxo_gbnm(346452, 'Peru coast toad').
ncbi_mult_taxo_gbnm(346453, 'big-eared toad').
ncbi_mult_taxo_gbnm(346454, 'Werner\'s toad').
ncbi_mult_taxo_gbnm(346455, 'Laguna toad').
ncbi_mult_taxo_gbnm(346456, 'ocellated toad').
ncbi_mult_taxo_gbnm(346457, 'gray toad').
ncbi_mult_taxo_gbnm(346461, 'Alto Maranon toad').
ncbi_mult_taxo_gbnm(346462, 'Veragua toad').
ncbi_mult_taxo_gbnm(346781, 'cream-streaked ladybird beetle').
ncbi_mult_taxo_gbnm(346951, 'rambling senna').
ncbi_mult_taxo_gbnm(347359, 'orange ladybird').
ncbi_mult_taxo_gbnm(347441, 'lesser thorn-tipped longhorn beetle').
ncbi_mult_taxo_gbnm(347529, 'yellow star-thistle').
ncbi_mult_taxo_gbnm(347538, 'Marine Group III').
ncbi_mult_taxo_gbnm(347678, 'beech scale').
ncbi_mult_taxo_gbnm(347681, 'maple scale').
ncbi_mult_taxo_gbnm(347722, 'rare wrasse').
ncbi_mult_taxo_gbnm(347724, 'black leopard wrasse').
ncbi_mult_taxo_gbnm(347725, 'ornate leopard wrasse').
ncbi_mult_taxo_gbnm(347726, 'spotted wrasse').
ncbi_mult_taxo_gbnm(347727, 'jewelled wrasse').
ncbi_mult_taxo_gbnm(347728, 'whitebelly wrasse').
ncbi_mult_taxo_gbnm(347729, 'belted wrasse').
ncbi_mult_taxo_gbnm(347733, 'sweet clover root borer').
ncbi_mult_taxo_gbnm(347744, 'flower moths').
ncbi_mult_taxo_gbnm(347979, 'ant damsel bug').
ncbi_mult_taxo_gbnm(348057, 'three-bearded rockling').
ncbi_mult_taxo_gbnm(348150, 'saddled bichir').
ncbi_mult_taxo_gbnm(348153, 'Caribbean spiny pocket mouse').
ncbi_mult_taxo_gbnm(348154, 'Panamanian spiny pocket mouse').
ncbi_mult_taxo_gbnm(348155, 'Salvin\'s spiny pocket mouse').
ncbi_mult_taxo_gbnm(348295, 'Altai wapiti').
ncbi_mult_taxo_gbnm(348362, 'Jaliscan spiny pocket mouse').
ncbi_mult_taxo_gbnm(348390, 'Sonoran horned lizard').
ncbi_mult_taxo_gbnm(348443, 'fivebeard rockling').
ncbi_mult_taxo_gbnm(348444, 'threadfin rockling').
ncbi_mult_taxo_gbnm(348533, 'Italian tree frog').
ncbi_mult_taxo_gbnm(348696, 'round whitefish').
ncbi_mult_taxo_gbnm(348703, 'dogwood borer').
ncbi_mult_taxo_gbnm(348706, 'squash vine borer').
ncbi_mult_taxo_gbnm(348707, 'broad whitefish').
ncbi_mult_taxo_gbnm(348708, houting).
ncbi_mult_taxo_gbnm(348710, muksun).
ncbi_mult_taxo_gbnm(348718, 'woodland brown').
ncbi_mult_taxo_gbnm(348719, 'canary speckled wood').
ncbi_mult_taxo_gbnm(349162, 'big-eared woodrat').
ncbi_mult_taxo_gbnm(349311, 'Australian anchovy').
ncbi_mult_taxo_gbnm(349369, 'Bhutan glory').
ncbi_mult_taxo_gbnm(349509, 'Japanese bigleaf magnolia').
ncbi_mult_taxo_gbnm(349640, 'African striped grunt').
ncbi_mult_taxo_gbnm(349642, 'rubberlip grunt').
ncbi_mult_taxo_gbnm(349646, 'hard-tail jack').
ncbi_mult_taxo_gbnm(349649, 'bullet tuna').
ncbi_mult_taxo_gbnm(349650, 'barred hogfish').
ncbi_mult_taxo_gbnm(349651, 'Atlantic pomfret').
ncbi_mult_taxo_gbnm(349652, 'Angola dentex').
ncbi_mult_taxo_gbnm(349654, 'black cardinal fish').
ncbi_mult_taxo_gbnm(349656, 'bastard grunt').
ncbi_mult_taxo_gbnm(349657, 'law croaker').
ncbi_mult_taxo_gbnm(349658, 'longneck croaker').
ncbi_mult_taxo_gbnm(349660, 'blacktail comber').
ncbi_mult_taxo_gbnm(349661, 'painted comber').
ncbi_mult_taxo_gbnm(349662, 'starry weever').
ncbi_mult_taxo_gbnm(349663, 'longfin gurnard').
ncbi_mult_taxo_gbnm(349664, 'Nigerian tonguesole').
ncbi_mult_taxo_gbnm(349667, 'Madeira rockfish').
ncbi_mult_taxo_gbnm(349669, 'polygon moray').
ncbi_mult_taxo_gbnm(349709, 'large white-bellied rat').
ncbi_mult_taxo_gbnm(349710, 'montane bornean Niviventer').
ncbi_mult_taxo_gbnm(349711, 'Large New Guinea spiny rat').
ncbi_mult_taxo_gbnm(349956, 'American searocket').
ncbi_mult_taxo_gbnm(349996, 'Canelos robber frog').
ncbi_mult_taxo_gbnm(349997, 'Amazon robber frog').
ncbi_mult_taxo_gbnm(349998, 'Santander robber frog').
ncbi_mult_taxo_gbnm(349999, 'Bogota robber frog').
ncbi_mult_taxo_gbnm(350000, 'Boulenger\'s robber frog').
ncbi_mult_taxo_gbnm(350002, 'Carvalho\'s robber frog').
ncbi_mult_taxo_gbnm(350003, 'Santa Cecilia robber frog').
ncbi_mult_taxo_gbnm(350005, 'elegant robber frog').
ncbi_mult_taxo_gbnm(350006, 'Rio Jatuntianhua robber frog').
ncbi_mult_taxo_gbnm(350007, 'Meta robber frog').
ncbi_mult_taxo_gbnm(350008, 'Johnstone\'s robber frog').
ncbi_mult_taxo_gbnm(350010, 'Rio Luisito robber frog').
ncbi_mult_taxo_gbnm(350011, 'Lynch\'s robber frog').
ncbi_mult_taxo_gbnm(350012, 'Bogotacito robber frog').
ncbi_mult_taxo_gbnm(350013, 'Miyata\'s robber frog').
ncbi_mult_taxo_gbnm(350014, 'Niceforo\'s robber frog').
ncbi_mult_taxo_gbnm(350016, 'Peru robber frog').
ncbi_mult_taxo_gbnm(350019, 'Pyburn\'s robber frog').
ncbi_mult_taxo_gbnm(350020, 'Albania robber frog').
ncbi_mult_taxo_gbnm(350021, 'banded robber frog').
ncbi_mult_taxo_gbnm(350022, 'Caldas robber frog').
ncbi_mult_taxo_gbnm(350043, 'barcheek pipefish').
ncbi_mult_taxo_gbnm(350085, 'dusky wireworm').
ncbi_mult_taxo_gbnm(350576, leechbrush).
ncbi_mult_taxo_gbnm(350805, 'Volcano shrew').
ncbi_mult_taxo_gbnm(350806, 'Madagascan Pygmy Shrew').
ncbi_mult_taxo_gbnm(351061, 'aucuba fruit midge').
ncbi_mult_taxo_gbnm(351162, 'Krishna peacock').
ncbi_mult_taxo_gbnm(351163, 'blue peacock').
ncbi_mult_taxo_gbnm(351164, 'common peacock').
ncbi_mult_taxo_gbnm(351240, 'Korean doty barbel').
ncbi_mult_taxo_gbnm(351417, 'staff sergeant').
ncbi_mult_taxo_gbnm(351464, 'Chilean red cricket').
ncbi_mult_taxo_gbnm(351694, 'dusky farmerfish').
ncbi_mult_taxo_gbnm(351695, 'freshwater demoiselle').
ncbi_mult_taxo_gbnm(352243, 'scale-eye plaice').
ncbi_mult_taxo_gbnm(352245, sohachi).
ncbi_mult_taxo_gbnm(352469, 'Yellow-bellied tit').
ncbi_mult_taxo_gbnm(352831, 'White-nosed coati').
ncbi_mult_taxo_gbnm(352911, 'Flinders Ranges mogurnda').
ncbi_mult_taxo_gbnm(352912, 'desert mogurnda').
ncbi_mult_taxo_gbnm(352913, 'Dalhousie mogurnda').
ncbi_mult_taxo_gbnm(353225, 'rayed bean').
ncbi_mult_taxo_gbnm(353259, 'striped flying barb').
ncbi_mult_taxo_gbnm(353267, 'central Spanish fire salamander').
ncbi_mult_taxo_gbnm(353268, 'Spanish fire salamander').
ncbi_mult_taxo_gbnm(353270, 'Pyrenean fire salamander').
ncbi_mult_taxo_gbnm(353271, 'Italian fire salamander').
ncbi_mult_taxo_gbnm(354114, 'long-nosed barbel').
ncbi_mult_taxo_gbnm(354116, 'Korean splendid dace').
ncbi_mult_taxo_gbnm(354122, 'larch budmoth').
ncbi_mult_taxo_gbnm(354123, 'mountain stream siredon').
ncbi_mult_taxo_gbnm(354125, 'yellow-peppered salamander').
ncbi_mult_taxo_gbnm(354126, 'granular salamander').
ncbi_mult_taxo_gbnm(354127, 'Lake Lerma salamander').
ncbi_mult_taxo_gbnm(354128, 'Taylor\'s salamander').
ncbi_mult_taxo_gbnm(354129, 'Michoacan stream salamander').
ncbi_mult_taxo_gbnm(354136, 'scarlet shiner').
ncbi_mult_taxo_gbnm(354189, 'Rueppel\'s fox').
ncbi_mult_taxo_gbnm(354190, 'Blandford\'s fox').
ncbi_mult_taxo_gbnm(354191, 'Darwin\'s zorro').
ncbi_mult_taxo_gbnm(354222, 'banded peacock').
ncbi_mult_taxo_gbnm(354431, 'banana stem weevil').
ncbi_mult_taxo_gbnm(354433, 'small banana weevil').
ncbi_mult_taxo_gbnm(354439, 'red palm weevil').
ncbi_mult_taxo_gbnm(354526, 'common pricklyash').
ncbi_mult_taxo_gbnm(354529, 'Japanese pepper').
ncbi_mult_taxo_gbnm(354530, 'mastic-leaf prickly ash').
ncbi_mult_taxo_gbnm(354751, 'sickle-winged skipper').
ncbi_mult_taxo_gbnm(354758, 'gold-spot aguna').
ncbi_mult_taxo_gbnm(354781, 'starred skipper').
ncbi_mult_taxo_gbnm(354785, 'yellow-tipped flasher').
ncbi_mult_taxo_gbnm(354791, 'small-spotted flasher').
ncbi_mult_taxo_gbnm(354801, 'sheep skipper').
ncbi_mult_taxo_gbnm(354849, 'white-striped longtail').
ncbi_mult_taxo_gbnm(354851, 'Zilpa longtail').
ncbi_mult_taxo_gbnm(354867, 'white-crescent longtail').
ncbi_mult_taxo_gbnm(354871, 'mimosa skipper').
ncbi_mult_taxo_gbnm(354875, 'hidden-ray skipper').
ncbi_mult_taxo_gbnm(354877, 'redundant skipper').
ncbi_mult_taxo_gbnm(354944, 'blue-banded skipper').
ncbi_mult_taxo_gbnm(354948, 'variegated skipper').
ncbi_mult_taxo_gbnm(354951, 'hermit skipper').
ncbi_mult_taxo_gbnm(355023, 'violet-banded skipper').
ncbi_mult_taxo_gbnm(355044, 'purple-washed skipper').
ncbi_mult_taxo_gbnm(355053, 'glazed pellicia').
ncbi_mult_taxo_gbnm(355054, 'morning glory pellicia').
ncbi_mult_taxo_gbnm(355066, 'Marshall\'s ghost skipper').
ncbi_mult_taxo_gbnm(355077, 'mangrove skipper').
ncbi_mult_taxo_gbnm(355083, 'hammock skipper').
ncbi_mult_taxo_gbnm(355091, 'eight-spotted longtail').
ncbi_mult_taxo_gbnm(355098, 'mercurial skipper').
ncbi_mult_taxo_gbnm(355113, 'Mexican mellana').
ncbi_mult_taxo_gbnm(355144, 'blue-studded skipper').
ncbi_mult_taxo_gbnm(355148, 'falcate skipper').
ncbi_mult_taxo_gbnm(355157, 'faceted skipper').
ncbi_mult_taxo_gbnm(355230, 'glassy-winged skipper').
ncbi_mult_taxo_gbnm(355514, 'California grunion').
ncbi_mult_taxo_gbnm(355529, 'winter cherry bug').
ncbi_mult_taxo_gbnm(355632, 'Semper\'s warbler').
ncbi_mult_taxo_gbnm(355654, 'African striped mabuya').
ncbi_mult_taxo_gbnm(355656, 'Wahlberg\'s striped skink').
ncbi_mult_taxo_gbnm(355677, 'Stokes\'s seasnake').
ncbi_mult_taxo_gbnm(355678, 'turtle-headed seasnake').
ncbi_mult_taxo_gbnm(355681, 'elegant seasnake').
ncbi_mult_taxo_gbnm(355682, 'McDowells seasnake').
ncbi_mult_taxo_gbnm(355683, 'Pacific seasnake').
ncbi_mult_taxo_gbnm(355684, 'yellow sea snake').
ncbi_mult_taxo_gbnm(355685, 'Shaw\'s sea snake').
ncbi_mult_taxo_gbnm(355687, 'fine-spined seasnake').
ncbi_mult_taxo_gbnm(355692, 'King\'s seasnake').
ncbi_mult_taxo_gbnm(355693, 'olive-headed seasnake').
ncbi_mult_taxo_gbnm(355915, 'goldenrod stem gall moth').
ncbi_mult_taxo_gbnm(355937, 'prickly Russian thistle').
ncbi_mult_taxo_gbnm(356175, 'Alfred\'s rain frog').
ncbi_mult_taxo_gbnm(356176, 'clay robber frog').
ncbi_mult_taxo_gbnm(356177, 'rusty robber frog').
ncbi_mult_taxo_gbnm(356178, 'Souzas robber frog').
ncbi_mult_taxo_gbnm(356179, 'cliff chirping frog').
ncbi_mult_taxo_gbnm(356180, 'greenhouse frog').
ncbi_mult_taxo_gbnm(356181, 'Bob\'s robber frog').
ncbi_mult_taxo_gbnm(356190, 'southern torrent frog').
ncbi_mult_taxo_gbnm(356193, 'Hubei firebelly toad').
ncbi_mult_taxo_gbnm(356194, 'Uluguru pink caecilian').
ncbi_mult_taxo_gbnm(356195, 'Cochabamba toad').
ncbi_mult_taxo_gbnm(356200, 'Ongot long-fingered frog').
ncbi_mult_taxo_gbnm(356203, 'Cameroon slippery frog').
ncbi_mult_taxo_gbnm(356204, 'Morobe rainforest frog').
ncbi_mult_taxo_gbnm(356208, 'elegant narrowmouth toad').
ncbi_mult_taxo_gbnm(356210, 'northern glassfrog').
ncbi_mult_taxo_gbnm(356214, 'temple treefrog').
ncbi_mult_taxo_gbnm(356215, 'Fletchers frog').
ncbi_mult_taxo_gbnm(356218, 'Bocage\'s burrowing frog').
ncbi_mult_taxo_gbnm(356224, 'Bates\' tree toad').
ncbi_mult_taxo_gbnm(356228, 'Balu oriental frog').
ncbi_mult_taxo_gbnm(356231, 'gazelle cross frog').
ncbi_mult_taxo_gbnm(356233, 'Efulen water frog').
ncbi_mult_taxo_gbnm(356234, 'Chinese bubble-nest frog').
ncbi_mult_taxo_gbnm(356236, 'Boutry River frog').
ncbi_mult_taxo_gbnm(356237, 'Medje River frog').
ncbi_mult_taxo_gbnm(356238, 'Peters\' river frog').
ncbi_mult_taxo_gbnm(356242, 'red-backed toadlet').
ncbi_mult_taxo_gbnm(356243, 'dark-bellied grass frog').
ncbi_mult_taxo_gbnm(356244, 'Vietnam flying frog').
ncbi_mult_taxo_gbnm(356246, 'striped screeching frog').
ncbi_mult_taxo_gbnm(356248, 'Borneo splash frog').
ncbi_mult_taxo_gbnm(356259, 'Scratchley Guinea frog').
ncbi_mult_taxo_gbnm(356263, 'Savage\'s Goias frog').
ncbi_mult_taxo_gbnm(356265, 'orange burrowing frog').
ncbi_mult_taxo_gbnm(356292, 'Cameroon caecilians').
ncbi_mult_taxo_gbnm(356295, 'brown egg frog').
ncbi_mult_taxo_gbnm(356299, 'Victoria ground froglet').
ncbi_mult_taxo_gbnm(356301, 'giant burrowing frog').
ncbi_mult_taxo_gbnm(356307, 'Nicholl\'s toadlet').
ncbi_mult_taxo_gbnm(356314, 'Australian wood frog').
ncbi_mult_taxo_gbnm(356316, 'Haswell\'s frog').
ncbi_mult_taxo_gbnm(356321, 'olive striped frog').
ncbi_mult_taxo_gbnm(356328, 'Banhado frog').
ncbi_mult_taxo_gbnm(356330, 'Seychelles frog').
ncbi_mult_taxo_gbnm(356334, 'Miranda\'s disc frog').
ncbi_mult_taxo_gbnm(356336, 'Mertens\' smalltongue toad').
ncbi_mult_taxo_gbnm(356337, 'Cameroon Wolterstorff Toad').
ncbi_mult_taxo_gbnm(356342, 'Rio Mutum frog').
ncbi_mult_taxo_gbnm(356344, 'Fauro sticky-toed frog').
ncbi_mult_taxo_gbnm(356345, 'shiny peeping frog').
ncbi_mult_taxo_gbnm(356346, 'Sonoran lyre snake').
ncbi_mult_taxo_gbnm(356589, 'Cape three-lined skink').
ncbi_mult_taxo_gbnm(356598, 'Hoesch\'s mabuya').
ncbi_mult_taxo_gbnm(356599, 'Malagasy mabuya').
ncbi_mult_taxo_gbnm(356601, 'Cuming\'s mabuya').
ncbi_mult_taxo_gbnm(356665, 'black-handed tamarin').
ncbi_mult_taxo_gbnm(356666, 'Martin\'s tamarin').
ncbi_mult_taxo_gbnm(356848, 'goldenrod bunch gall').
ncbi_mult_taxo_gbnm(356903, 'white-winged snowfinch').
ncbi_mult_taxo_gbnm(356906, 'black-winged snowfinch').
ncbi_mult_taxo_gbnm(356909, 'white-rumped snowfinch').
ncbi_mult_taxo_gbnm(357119, 'pine shoot moth').
ncbi_mult_taxo_gbnm(357229, 'Japanese ant').
ncbi_mult_taxo_gbnm(357281, 'longnose loach').
ncbi_mult_taxo_gbnm(357282, 'Siberian stone loach').
ncbi_mult_taxo_gbnm(357337, 'modest day gecko').
ncbi_mult_taxo_gbnm(357352, 'Coxing\'s white-bellied rat').
ncbi_mult_taxo_gbnm(357502, 'hemlock woolly adelgid').
ncbi_mult_taxo_gbnm(357505, 'flat dainty frog').
ncbi_mult_taxo_gbnm(357695, 'red-headed bunting').
ncbi_mult_taxo_gbnm(357734, 'White-collared seedeater').
ncbi_mult_taxo_gbnm(357811, cardinalfish).
ncbi_mult_taxo_gbnm(357812, 'brown comber').
ncbi_mult_taxo_gbnm(357863, 'yellow-winged tanager').
ncbi_mult_taxo_gbnm(357873, 'threadfin bonefish').
ncbi_mult_taxo_gbnm(357961, 'honeydew melon').
ncbi_mult_taxo_gbnm(357983, 'tufted tyrant ant').
ncbi_mult_taxo_gbnm(358128, 'Tree pangolin').
ncbi_mult_taxo_gbnm(358129, 'Southern tree hyrax').
ncbi_mult_taxo_gbnm(358217, 'Ceres thick-toed gecko').
ncbi_mult_taxo_gbnm(358420, 'linden borer').
ncbi_mult_taxo_gbnm(358446, 'deep-sea limpets').
ncbi_mult_taxo_gbnm(358767, 'bluestriped butterflyfish').
ncbi_mult_taxo_gbnm(358814, 'Daurian redstart').
ncbi_mult_taxo_gbnm(358815, 'black redstart').
ncbi_mult_taxo_gbnm(358818, 'white-capped water-redstart').
ncbi_mult_taxo_gbnm(358819, 'Isabelline wheatear').
ncbi_mult_taxo_gbnm(359533, 'long-snouted treefrog').
ncbi_mult_taxo_gbnm(359535, 'Philippine flying frog').
ncbi_mult_taxo_gbnm(359536, 'belly-spotted frog').
ncbi_mult_taxo_gbnm(359537, 'Bana bubble-nest frog').
ncbi_mult_taxo_gbnm(359538, 'green-limbed tree frog').
ncbi_mult_taxo_gbnm(359651, 'Palau bush-warbler').
ncbi_mult_taxo_gbnm(359668, 'gland-shanked pond frog').
ncbi_mult_taxo_gbnm(359804, 'spotted seahorse').
ncbi_mult_taxo_gbnm(359809, 'warrior shiner').
ncbi_mult_taxo_gbnm(359810, 'pinewoods shiner').
ncbi_mult_taxo_gbnm(360502, 'trout sweetlips').
ncbi_mult_taxo_gbnm(360503, 'striped sweetlips').
ncbi_mult_taxo_gbnm(360505, 'broadbanded velvetchin').
ncbi_mult_taxo_gbnm(360507, 'chicken grunt').
ncbi_mult_taxo_gbnm(360508, 'javelin grunt').
ncbi_mult_taxo_gbnm(360509, 'crescent sweetlips').
ncbi_mult_taxo_gbnm(360510, 'yellowbanded sweetlips').
ncbi_mult_taxo_gbnm(360624, 'blackwing hatchetfish').
ncbi_mult_taxo_gbnm(360643, 'montane speckled skink').
ncbi_mult_taxo_gbnm(360967, 'Great evening bat').
ncbi_mult_taxo_gbnm(361172, 'Alderslade\'s carrot coral').
ncbi_mult_taxo_gbnm(361227, 'Australian wood cockroach').
ncbi_mult_taxo_gbnm(361442, 'Chinese chaste tree').
ncbi_mult_taxo_gbnm(361456, 'Savanna shrew').
ncbi_mult_taxo_gbnm(361457, 'Therese\'s shrew').
ncbi_mult_taxo_gbnm(361560, 'rabbitfoot clover').
ncbi_mult_taxo_gbnm(361594, 'horse-shoe crab beetles').
ncbi_mult_taxo_gbnm(361629, 'March\'s palm-pitviper').
ncbi_mult_taxo_gbnm(361683, 'pea weevil').
ncbi_mult_taxo_gbnm(362074, 'Large long-clawed mouse').
ncbi_mult_taxo_gbnm(362087, 'gooseberry sawfly').
ncbi_mult_taxo_gbnm(362161, 'greenheaded spruce sawfly').
ncbi_mult_taxo_gbnm(362162, 'spruce sawfly').
ncbi_mult_taxo_gbnm(362335, 'Dark-footed forest shrew').
ncbi_mult_taxo_gbnm(362336, 'Lesser dwarf shrew').
ncbi_mult_taxo_gbnm(362380, 'barred pipefish').
ncbi_mult_taxo_gbnm(362608, 'willow beaked gall midge').
ncbi_mult_taxo_gbnm(362611, 'castor bean whitefly').
ncbi_mult_taxo_gbnm(362823, 'Thomas\'s broad-nosed bat').
ncbi_mult_taxo_gbnm(362825, 'Melissa\'s yellow-eared bat').
ncbi_mult_taxo_gbnm(362977, 'sand dollar cactus').
ncbi_mult_taxo_gbnm(363172, 'spinycheek lanternfish').
ncbi_mult_taxo_gbnm(363190, 'Gray\'s grenadier anchovy').
ncbi_mult_taxo_gbnm(363229, 'Small-footed shrew').
ncbi_mult_taxo_gbnm(363230, 'Sclater\'s tiny mouse shrew').
ncbi_mult_taxo_gbnm(363549, 'grazing goby').
ncbi_mult_taxo_gbnm(364065, 'largescale stoneroller').
ncbi_mult_taxo_gbnm(364066, 'bluefin stoneroller').
ncbi_mult_taxo_gbnm(364067, 'Panuco minnow').
ncbi_mult_taxo_gbnm(364070, 'roundnose minnow').
ncbi_mult_taxo_gbnm(364071, 'Nueces roundnose minnow').
ncbi_mult_taxo_gbnm(364075, 'Devils River minnow').
ncbi_mult_taxo_gbnm(364079, 'spottail chub').
ncbi_mult_taxo_gbnm(364093, 'largemouth shiner').
ncbi_mult_taxo_gbnm(364094, 'gibbous shiner').
ncbi_mult_taxo_gbnm(364095, 'Cuatro Cienegas shiner').
ncbi_mult_taxo_gbnm(364155, 'Southern bog lemming').
ncbi_mult_taxo_gbnm(364245, 'Northern shrew tenrec').
ncbi_mult_taxo_gbnm(364246, 'Taiva shrew tenrec').
ncbi_mult_taxo_gbnm(364258, 'Turuchan pika').
ncbi_mult_taxo_gbnm(364535, 'domed ancylid').
ncbi_mult_taxo_gbnm(364576, 'white-breasted white-eye').
ncbi_mult_taxo_gbnm(364583, 'Cape white-eye').
ncbi_mult_taxo_gbnm(364765, 'Menwig frog').
ncbi_mult_taxo_gbnm(364766, 'Bocaina dwarf frog').
ncbi_mult_taxo_gbnm(364767, 'weeping frog').
ncbi_mult_taxo_gbnm(364768, 'Girard\'s dwarf frog').
ncbi_mult_taxo_gbnm(365045, 'dotted paropsine leaf beetle').
ncbi_mult_taxo_gbnm(365050, 'Japanese sardinella').
ncbi_mult_taxo_gbnm(365052, 'silver-stripe round herring').
ncbi_mult_taxo_gbnm(365054, 'elongate ilisha').
ncbi_mult_taxo_gbnm(365056, 'Konoshiro gizzard shad').
ncbi_mult_taxo_gbnm(365059, 'Japanese grenadier anchovy').
ncbi_mult_taxo_gbnm(365061, 'round herrings').
ncbi_mult_taxo_gbnm(365149, 'brush rabbit').
ncbi_mult_taxo_gbnm(365333, 'Sorocaba dwarf frog').
ncbi_mult_taxo_gbnm(365580, 'spot pangasius').
ncbi_mult_taxo_gbnm(365581, 'giant pangasius').
ncbi_mult_taxo_gbnm(365643, 'Cuatro Cienegas slider').
ncbi_mult_taxo_gbnm(365646, 'Yaqui slider').
ncbi_mult_taxo_gbnm(366056, 'common palmfly').
ncbi_mult_taxo_gbnm(366057, 'false dewy ringlet').
ncbi_mult_taxo_gbnm(366462, 'root mustard').
ncbi_mult_taxo_gbnm(366500, 'Southern river otter').
ncbi_mult_taxo_gbnm(366638, 'silky dogwood').
ncbi_mult_taxo_gbnm(366891, 'dwarf lefteye flounder').
ncbi_mult_taxo_gbnm(366892, 'many-spotted lefteye flounder').
ncbi_mult_taxo_gbnm(366894, 'Indo-Pacific oval flounder').
ncbi_mult_taxo_gbnm(366904, 'Bloch\'s tonguesole').
ncbi_mult_taxo_gbnm(366905, 'leopard flounder').
ncbi_mult_taxo_gbnm(366906, 'drab flounder').
ncbi_mult_taxo_gbnm(366907, 'blue flounder').
ncbi_mult_taxo_gbnm(366923, 'red tonguesole').
ncbi_mult_taxo_gbnm(366930, 'blackbelly tonguesole').
ncbi_mult_taxo_gbnm(366931, 'deep-body righteye flounder').
ncbi_mult_taxo_gbnm(366934, 'cockatoo righteye flounder').
ncbi_mult_taxo_gbnm(366936, 'Gulf of Mexico fringed sole').
ncbi_mult_taxo_gbnm(367072, 'orangeback angelfish').
ncbi_mult_taxo_gbnm(367073, cherubfish).
ncbi_mult_taxo_gbnm(367074, 'resplendent angelfish').
ncbi_mult_taxo_gbnm(367075, 'orange angelfish').
ncbi_mult_taxo_gbnm(367194, 'fringefin zebra sole').
ncbi_mult_taxo_gbnm(367195, 'carpet sole').
ncbi_mult_taxo_gbnm(367196, 'Kai sole').
ncbi_mult_taxo_gbnm(367197, 'ocellated flounder').
ncbi_mult_taxo_gbnm(367198, 'roughscale flounder').
ncbi_mult_taxo_gbnm(367269, 'twoband anemonefish').
ncbi_mult_taxo_gbnm(367270, 'Chagos anemonefish').
ncbi_mult_taxo_gbnm(367274, 'whitebonnet anemonefish').
ncbi_mult_taxo_gbnm(367275, 'whitesnout anemonefish').
ncbi_mult_taxo_gbnm(367277, 'red anemonefish').
ncbi_mult_taxo_gbnm(367278, 'wide-band anemonefish').
ncbi_mult_taxo_gbnm(367368, 'West African mud turtle').
ncbi_mult_taxo_gbnm(367402, 'Montane thick-toed gecko').
ncbi_mult_taxo_gbnm(367642, 'brown banana frog').
ncbi_mult_taxo_gbnm(367647, 'common oval frog').
ncbi_mult_taxo_gbnm(367660, 'Dumeril\'s wrinkled ground frog').
ncbi_mult_taxo_gbnm(367661, 'Hazel\'s wrinkled ground frog').
ncbi_mult_taxo_gbnm(367664, 'Papua wrinkled ground frog').
ncbi_mult_taxo_gbnm(367668, 'Mindanao splash frog').
ncbi_mult_taxo_gbnm(367669, 'banded stream frog').
ncbi_mult_taxo_gbnm(367674, 'Shortland Island webbed frog').
ncbi_mult_taxo_gbnm(367679, 'Luzon frog').
ncbi_mult_taxo_gbnm(367680, 'Calamianes frog').
ncbi_mult_taxo_gbnm(367835, 'Ecuador mushroomtongue salamander').
ncbi_mult_taxo_gbnm(367866, 'rock carp').
ncbi_mult_taxo_gbnm(367950, 'Grey-capped woodpecker').
ncbi_mult_taxo_gbnm(368404, 'woodchip morel').
ncbi_mult_taxo_gbnm(368947, 'Puntarenas robber frog').
ncbi_mult_taxo_gbnm(368974, 'Carabaya robber frog').
ncbi_mult_taxo_gbnm(369345, 'Utah sucker').
ncbi_mult_taxo_gbnm(369450, 'azalea lace bug').
ncbi_mult_taxo_gbnm(369451, 'sycamore lace bug').
ncbi_mult_taxo_gbnm(369483, 'Norfolk robin').
ncbi_mult_taxo_gbnm(369490, 'North Island robin').
ncbi_mult_taxo_gbnm(369498, 'lantana lace bug').
ncbi_mult_taxo_gbnm(369509, 'Weining groove-toed frog').
ncbi_mult_taxo_gbnm(369511, 'Yunnan pond frog').
ncbi_mult_taxo_gbnm(369514, 'golden crossband frog').
ncbi_mult_taxo_gbnm(369515, 'fine-spined frog').
ncbi_mult_taxo_gbnm(369588, 'Tawny-winged woodcreeper').
ncbi_mult_taxo_gbnm(369612, 'thrush-like Schiffornis').
ncbi_mult_taxo_gbnm(369617, 'screaming piha').
ncbi_mult_taxo_gbnm(369627, 'tricolor sharkminnow').
ncbi_mult_taxo_gbnm(369634, 'silver flying fox').
ncbi_mult_taxo_gbnm(369685, 'lined lesser-bream').
ncbi_mult_taxo_gbnm(369771, 'yellowish-bellied bush-warbler').
ncbi_mult_taxo_gbnm(369772, 'Hume\'s bush-warbler').
ncbi_mult_taxo_gbnm(369902, 'Chinese short-tailed hairtail').
ncbi_mult_taxo_gbnm(369906, 'broad skate').
ncbi_mult_taxo_gbnm(369968, 'southern blue whiting').
ncbi_mult_taxo_gbnm(369970, 'yellow-rumped flycatcher').
ncbi_mult_taxo_gbnm(370040, 'so-iny mullet').
ncbi_mult_taxo_gbnm(370357, 'copper masheer').
ncbi_mult_taxo_gbnm(370359, 'lemon-fin barb').
ncbi_mult_taxo_gbnm(370448, 'Cape Verde shearwater').
ncbi_mult_taxo_gbnm(370606, 'maranon poison frog').
ncbi_mult_taxo_gbnm(370608, 'Duellman\'s poison dart frog').
ncbi_mult_taxo_gbnm(370629, 'shortfin silverside').
ncbi_mult_taxo_gbnm(370630, 'blacknose silverside').
ncbi_mult_taxo_gbnm(370631, 'longjaw silverside').
ncbi_mult_taxo_gbnm(370634, 'rough silverside').
ncbi_mult_taxo_gbnm(371028, 'mile-a-minute weed').
ncbi_mult_taxo_gbnm(371035, 'Peruvian guemal').
ncbi_mult_taxo_gbnm(371039, 'Highland mangabey').
ncbi_mult_taxo_gbnm(371081, 'Malayan snail-eating turtle').
ncbi_mult_taxo_gbnm(371200, 'pepper fruit fly').
ncbi_mult_taxo_gbnm(371464, 'brown-legged spurge flea beetle').
ncbi_mult_taxo_gbnm(371672, 'blackbar soldierfish').
ncbi_mult_taxo_gbnm(371673, 'longjaw squirrelfish').
ncbi_mult_taxo_gbnm(371699, 'Tabor treefrog').
ncbi_mult_taxo_gbnm(371700, 'Linda\'s treefrog').
ncbi_mult_taxo_gbnm(371701, 'Rivero\'s tiny treefrog').
ncbi_mult_taxo_gbnm(371702, 'Roque treefrog').
ncbi_mult_taxo_gbnm(371703, 'Rivero\'s Amazon treeffrog').
ncbi_mult_taxo_gbnm(371704, 'Schubart\'s Rondonia treefrog').
ncbi_mult_taxo_gbnm(371707, 'Ecuador slender-legged treefrog').
ncbi_mult_taxo_gbnm(371708, 'Savanna-la-Mar treefrog').
ncbi_mult_taxo_gbnm(371709, 'yellow bromeliad frog').
ncbi_mult_taxo_gbnm(371710, 'Wilder\'s treefrog').
ncbi_mult_taxo_gbnm(371711, 'Surinam golden-eyed treefrog').
ncbi_mult_taxo_gbnm(371712, 'Lutz\'s lime treefrog').
ncbi_mult_taxo_gbnm(371747, 'sananna strobe ant').
ncbi_mult_taxo_gbnm(371748, 'savanna spiny ant').
ncbi_mult_taxo_gbnm(371819, 'chucky madtom').
ncbi_mult_taxo_gbnm(371820, 'pygmy madtom').
ncbi_mult_taxo_gbnm(371826, 'Black-tailed tree rat').
ncbi_mult_taxo_gbnm(371827, 'Loring\'s rat').
ncbi_mult_taxo_gbnm(371860, 'cackling goose').
ncbi_mult_taxo_gbnm(371863, 'surf scoter').
ncbi_mult_taxo_gbnm(371864, 'velvet scoter').
ncbi_mult_taxo_gbnm(371886, 'brown dot leafy spurge flea beetle').
ncbi_mult_taxo_gbnm(371888, 'black leafy spurge flea beetle').
ncbi_mult_taxo_gbnm(371891, 'black dot leafy spurge flea beetle').
ncbi_mult_taxo_gbnm(371892, 'copper leafy spurge flea beetle').
ncbi_mult_taxo_gbnm(371906, 'black-chinned hummingbird').
ncbi_mult_taxo_gbnm(371907, 'Snowy owl').
ncbi_mult_taxo_gbnm(371910, pyrrhuloxia).
ncbi_mult_taxo_gbnm(371911, 'Common ringed plover').
ncbi_mult_taxo_gbnm(371916, 'Golden-fronted woodpecker').
ncbi_mult_taxo_gbnm(371922, 'Pacific golden plover').
ncbi_mult_taxo_gbnm(371923, 'Siberian tit').
ncbi_mult_taxo_gbnm(371933, 'Vermilion flycatcher').
ncbi_mult_taxo_gbnm(371937, 'white piranha').
ncbi_mult_taxo_gbnm(371938, 'slender piranha').
ncbi_mult_taxo_gbnm(371946, 'serrated piranha').
ncbi_mult_taxo_gbnm(372076, 'Rusty pipistrelle').
ncbi_mult_taxo_gbnm(372077, 'Gambian epauletted fruit bat').
ncbi_mult_taxo_gbnm(372289, 'Cassin\'s finch').
ncbi_mult_taxo_gbnm(372306, 'Yucatan woodpecker').
ncbi_mult_taxo_gbnm(372308, 'Hoffmann\'s woodpecker').
ncbi_mult_taxo_gbnm(372311, 'white-crowned pigeon').
ncbi_mult_taxo_gbnm(372312, 'scaly-naped pigeon').
ncbi_mult_taxo_gbnm(372313, 'scaled pigeon').
ncbi_mult_taxo_gbnm(372321, 'band-tailed pigeon').
ncbi_mult_taxo_gbnm(372344, 'Peruvian pigeon').
ncbi_mult_taxo_gbnm(372349, 'plumbeous pigeon').
ncbi_mult_taxo_gbnm(372355, 'ruddy pigeon').
ncbi_mult_taxo_gbnm(372372, 'Cassin\'s kingbird').
ncbi_mult_taxo_gbnm(372551, brazilwood).
ncbi_mult_taxo_gbnm(372557, 'cabbage centre grub').
ncbi_mult_taxo_gbnm(372560, 'Osgood\'s short-tailed opossum').
ncbi_mult_taxo_gbnm(372561, 'Handley\'s slender mouse opossum').
ncbi_mult_taxo_gbnm(372791, 'northern sennet').
ncbi_mult_taxo_gbnm(372796, 'striped escolar').
ncbi_mult_taxo_gbnm(372798, 'black gemfish').
ncbi_mult_taxo_gbnm(372800, 'black snake mackerel').
ncbi_mult_taxo_gbnm(372801, 'double-lined mackerel').
ncbi_mult_taxo_gbnm(372805, 'dogtooth tuna').
ncbi_mult_taxo_gbnm(372806, 'Juan Fernandez trevally').
ncbi_mult_taxo_gbnm(373033, 'olive colobus').
ncbi_mult_taxo_gbnm(373077, okoume).
ncbi_mult_taxo_gbnm(373080, 'Godman\'s treefrog').
ncbi_mult_taxo_gbnm(373081, 'Guatemala treefrog').
ncbi_mult_taxo_gbnm(373082, 'emerald treefrog').
ncbi_mult_taxo_gbnm(373083, 'Panama cross-banded treefrog').
ncbi_mult_taxo_gbnm(373084, 'Veragua cross-banded treefrog').
ncbi_mult_taxo_gbnm(373085, 'Mexican shovel-headed treefrog').
ncbi_mult_taxo_gbnm(373086, 'Costa Rica brook frog').
ncbi_mult_taxo_gbnm(373087, 'voiceless treefrog').
ncbi_mult_taxo_gbnm(373117, 'jasmine moth').
ncbi_mult_taxo_gbnm(373177, 'Japanese lancelet').
ncbi_mult_taxo_gbnm(373196, 'Lancaster\'s treefrog').
ncbi_mult_taxo_gbnm(373249, 'West African ilisha').
ncbi_mult_taxo_gbnm(373251, 'delicate round herring').
ncbi_mult_taxo_gbnm(373515, 'Bukharan markhor').
ncbi_mult_taxo_gbnm(373516, 'straight-horned markhor').
ncbi_mult_taxo_gbnm(373956, 'Hawaiian volcano shrimp').
ncbi_mult_taxo_gbnm(373995, 'Hilsa shad').
ncbi_mult_taxo_gbnm(374040, 'golden angel\'s trumpet').
ncbi_mult_taxo_gbnm(374419, 'Javan tailless fruit bat').
ncbi_mult_taxo_gbnm(374457, 'red oak borer').
ncbi_mult_taxo_gbnm(374458, 'big-eyed click beetle').
ncbi_mult_taxo_gbnm(374459, 'flatheaded appletree borer').
ncbi_mult_taxo_gbnm(374600, 'Glandon blue').
ncbi_mult_taxo_gbnm(374616, 'Ansorge\'s greenbul').
ncbi_mult_taxo_gbnm(374617, 'Grey greenbul').
ncbi_mult_taxo_gbnm(374622, 'green-backed bulbul').
ncbi_mult_taxo_gbnm(374636, 'Himalayan bulbul').
ncbi_mult_taxo_gbnm(374644, 'buff-vented bulbul').
ncbi_mult_taxo_gbnm(374645, 'sulphur-bellied bulbul').
ncbi_mult_taxo_gbnm(374647, 'Green-winged bulbul').
ncbi_mult_taxo_gbnm(374649, 'brown-eared bulbul').
ncbi_mult_taxo_gbnm(374653, 'Streaked bulbul').
ncbi_mult_taxo_gbnm(374654, 'Philippine bulbul').
ncbi_mult_taxo_gbnm(374660, 'long-billed greenbul').
ncbi_mult_taxo_gbnm(374665, 'Spectacled tetraka').
ncbi_mult_taxo_gbnm(374983, 'red-veined dropwing').
ncbi_mult_taxo_gbnm(375087, 'water spider').
ncbi_mult_taxo_gbnm(375204, 'intermediate scabbardfish').
ncbi_mult_taxo_gbnm(375272, allspice).
ncbi_mult_taxo_gbnm(375434, 'mountain chicken frog').
ncbi_mult_taxo_gbnm(375442, 'Gunther\'s white-lipped frog').
ncbi_mult_taxo_gbnm(375764, 'orbiculate cardinalfish').
ncbi_mult_taxo_gbnm(376230, 'red-headed ash borer').
ncbi_mult_taxo_gbnm(376233, 'white oak borer').
ncbi_mult_taxo_gbnm(376236, 'tupelo borer').
ncbi_mult_taxo_gbnm(376244, 'mulberry borer').
ncbi_mult_taxo_gbnm(376345, 'White-bellied wren').
ncbi_mult_taxo_gbnm(376632, 'bigeye houndshark').
ncbi_mult_taxo_gbnm(376633, 'Japanese topeshark').
ncbi_mult_taxo_gbnm(376634, 'leopard catshark').
ncbi_mult_taxo_gbnm(376635, 'flathead catshark').
ncbi_mult_taxo_gbnm(376637, 'slender smooth-hound').
ncbi_mult_taxo_gbnm(376643, 'weasel sharks').
ncbi_mult_taxo_gbnm(376645, 'hooktooth shark').
ncbi_mult_taxo_gbnm(376647, 'sicklefin weasel shark').
ncbi_mult_taxo_gbnm(376653, 'blacktip tope').
ncbi_mult_taxo_gbnm(376654, 'sharptooth houndshark').
ncbi_mult_taxo_gbnm(376656, 'flapnose houndshark').
ncbi_mult_taxo_gbnm(376657, 'narrownose smooth-hound').
ncbi_mult_taxo_gbnm(376658, 'brown smooth-hound').
ncbi_mult_taxo_gbnm(376659, 'Arabian smooth-hound').
ncbi_mult_taxo_gbnm(376739, 'robust mangrove goby').
ncbi_mult_taxo_gbnm(376881, 'Tamar River goby').
ncbi_mult_taxo_gbnm(376882, 'exquisite sand-goby').
ncbi_mult_taxo_gbnm(376891, 'half-bridled goby').
ncbi_mult_taxo_gbnm(376892, 'bridled goby').
ncbi_mult_taxo_gbnm(376893, 'striped sandgoby').
ncbi_mult_taxo_gbnm(376894, 'tropical sand goby').
ncbi_mult_taxo_gbnm(376895, 'giant trevally').
ncbi_mult_taxo_gbnm(376911, prosimians).
ncbi_mult_taxo_gbnm(377249, 'Boraceia tree toad').
ncbi_mult_taxo_gbnm(377250, 'Weber\'s wrinkled ground frog').
ncbi_mult_taxo_gbnm(377252, 'smooth toadlet').
ncbi_mult_taxo_gbnm(377253, 'long-fingered stream toad').
ncbi_mult_taxo_gbnm(377254, 'Malayan horned frog').
ncbi_mult_taxo_gbnm(377263, 'brown thorny frog').
ncbi_mult_taxo_gbnm(377264, 'Arfak Mountains frog').
ncbi_mult_taxo_gbnm(377266, 'sharp-snouted torrent frog').
ncbi_mult_taxo_gbnm(377296, 'mountain egg frog').
ncbi_mult_taxo_gbnm(377299, 'black-spotted stout newt').
ncbi_mult_taxo_gbnm(377301, 'Avelino\'s smooth horned frog').
ncbi_mult_taxo_gbnm(377307, 'pouched frog').
ncbi_mult_taxo_gbnm(377316, 'golden arrow poison frog').
ncbi_mult_taxo_gbnm(377348, 'rock river frog').
ncbi_mult_taxo_gbnm(377353, 'Chaco horned frog').
ncbi_mult_taxo_gbnm(377473, 'great pignut').
ncbi_mult_taxo_gbnm(377832, 'harvester termites').
ncbi_mult_taxo_gbnm(378215, 'chimpanzee pinworm').
ncbi_mult_taxo_gbnm(378216, 'Nusatenggara short-nosed fruit bat').
ncbi_mult_taxo_gbnm(378224, 'wild Himalayan cherry').
ncbi_mult_taxo_gbnm(378228, 'Oshima cherry').
ncbi_mult_taxo_gbnm(378243, 'notched cowpea').
ncbi_mult_taxo_gbnm(378289, 'Oldham\'s leaf turtle').
ncbi_mult_taxo_gbnm(378291, 'Eastern black-bridged leaf turtle').
ncbi_mult_taxo_gbnm(378387, 'white albatross butterfly').
ncbi_mult_taxo_gbnm(378388, 'mottled emigrant').
ncbi_mult_taxo_gbnm(378391, 'angled red forester').
ncbi_mult_taxo_gbnm(378461, 'white quandong').
ncbi_mult_taxo_gbnm(378752, 'croton caterpillar').
ncbi_mult_taxo_gbnm(378754, 'Japanese black bear').
ncbi_mult_taxo_gbnm(378799, 'fire ant decapitating flies').
ncbi_mult_taxo_gbnm(379402, 'brownstripe red snapper').
ncbi_mult_taxo_gbnm(379532, 'Coquerel\'s sifaka').
ncbi_mult_taxo_gbnm(379582, 'red panda family').
ncbi_mult_taxo_gbnm(379588, 'African palm civet family').
ncbi_mult_taxo_gbnm(379589, 'falanouc, Malagasy civet, ring-tailed mongoose and others').
ncbi_mult_taxo_gbnm(379796, 'coral jewel').
ncbi_mult_taxo_gbnm(379797, 'inland hairstreak').
ncbi_mult_taxo_gbnm(379798, 'turquoise hairstreak').
ncbi_mult_taxo_gbnm(379799, 'emerald hairstreak').
ncbi_mult_taxo_gbnm(379800, 'northern hairstreak').
ncbi_mult_taxo_gbnm(379801, 'amethyst hairstreak').
ncbi_mult_taxo_gbnm(379802, 'stencilled hairstreak').
ncbi_mult_taxo_gbnm(379803, 'varied hairstreak').
ncbi_mult_taxo_gbnm(379804, 'varied hairstreak').
ncbi_mult_taxo_gbnm(379805, 'varied hairstreak').
ncbi_mult_taxo_gbnm(379806, 'Waterhouse\'s hairstreak').
ncbi_mult_taxo_gbnm(379811, 'Macqueen\'s hairstreak').
ncbi_mult_taxo_gbnm(379812, 'large bronze azure').
ncbi_mult_taxo_gbnm(379818, 'Pontic shad').
ncbi_mult_taxo_gbnm(379819, 'Caspian shad').
ncbi_mult_taxo_gbnm(379822, 'hairy line-blue').
ncbi_mult_taxo_gbnm(379824, 'marbled line-blue').
ncbi_mult_taxo_gbnm(379825, 'fringed heath-blue').
ncbi_mult_taxo_gbnm(379826, 'fringed heath-blue').
ncbi_mult_taxo_gbnm(379827, 'fringed heath-blue').
ncbi_mult_taxo_gbnm(379829, 'montane heath-blue').
ncbi_mult_taxo_gbnm(379830, 'dull heath-blue').
ncbi_mult_taxo_gbnm(379831, 'silky hairstreak').
ncbi_mult_taxo_gbnm(379832, 'silky hairstreak').
ncbi_mult_taxo_gbnm(379833, 'silky hairstreak').
ncbi_mult_taxo_gbnm(379834, 'glistening line-blue').
ncbi_mult_taxo_gbnm(379835, 'bitter-bush blue').
ncbi_mult_taxo_gbnm(379836, 'western bitter-bush blue').
ncbi_mult_taxo_gbnm(379837, 'western bitter-bush blue').
ncbi_mult_taxo_gbnm(379838, 'western bitter-bush blue').
ncbi_mult_taxo_gbnm(379839, 'wattle blue').
ncbi_mult_taxo_gbnm(379840, 'wattle blue').
ncbi_mult_taxo_gbnm(379841, 'wattle blue').
ncbi_mult_taxo_gbnm(379842, 'cycad blue').
ncbi_mult_taxo_gbnm(379843, 'cycad blue').
ncbi_mult_taxo_gbnm(379844, 'cycad blue').
ncbi_mult_taxo_gbnm(379845, 'saltbush blue').
ncbi_mult_taxo_gbnm(379846, 'saltbush blue').
ncbi_mult_taxo_gbnm(379847, 'saltbush blue').
ncbi_mult_taxo_gbnm(379848, 'samphire blue').
ncbi_mult_taxo_gbnm(379849, redspot).
ncbi_mult_taxo_gbnm(379850, 'Macedonia shad').
ncbi_mult_taxo_gbnm(379991, 'strigate parrotfish').
ncbi_mult_taxo_gbnm(380077, 'giant hogweed').
ncbi_mult_taxo_gbnm(380166, 'thin-shell littleneck').
ncbi_mult_taxo_gbnm(380177, 'Burma banteng').
ncbi_mult_taxo_gbnm(380359, 'Giant house bat').
ncbi_mult_taxo_gbnm(380373, 'white-eared ground-sparrow').
ncbi_mult_taxo_gbnm(380378, 'maritime pine scale').
ncbi_mult_taxo_gbnm(380495, 'varied solitaire').
ncbi_mult_taxo_gbnm(380556, 'papillose elysia').
ncbi_mult_taxo_gbnm(380561, 'Caribbean seagrass elysia').
ncbi_mult_taxo_gbnm(381022, 'White-bellied cuckooshrike').
ncbi_mult_taxo_gbnm(381024, mistletoebird).
ncbi_mult_taxo_gbnm(381028, 'white-capped monarch').
ncbi_mult_taxo_gbnm(381030, 'steel-blue flycatcher').
ncbi_mult_taxo_gbnm(381036, 'black-tailed whistler').
ncbi_mult_taxo_gbnm(381038, 'white-winged fantail').
ncbi_mult_taxo_gbnm(381040, 'chestnut-bellied fantail').
ncbi_mult_taxo_gbnm(381109, 'stripe-sided rhabdornis').
ncbi_mult_taxo_gbnm(381110, 'black-collared starling').
ncbi_mult_taxo_gbnm(381111, 'White-shouldered starling').
ncbi_mult_taxo_gbnm(381124, maize).
ncbi_mult_taxo_gbnm(381279, 'red shining-parrot').
ncbi_mult_taxo_gbnm(381290, 'Mayan sea catfish').
ncbi_mult_taxo_gbnm(381433, 'red-crested cotinga').
ncbi_mult_taxo_gbnm(381436, 'olivaceous piha').
ncbi_mult_taxo_gbnm(381437, 'grey-tailed piha').
ncbi_mult_taxo_gbnm(381442, 'white-cheeked cotinga').
ncbi_mult_taxo_gbnm(381535, 'black-faced solitaire').
ncbi_mult_taxo_gbnm(381746, 'hawthorn spider mite').
ncbi_mult_taxo_gbnm(381879, 'Sao Tome canary').
ncbi_mult_taxo_gbnm(382306, 'Savanna nightjar').
ncbi_mult_taxo_gbnm(382309, 'Ladder-tailed nightjar').
ncbi_mult_taxo_gbnm(382523, 'lobe-liped notothen').
ncbi_mult_taxo_gbnm(382524, 'orange notothen').
ncbi_mult_taxo_gbnm(382736, 'Fisk\'s house snake').
ncbi_mult_taxo_gbnm(382737, 'Swaziland house snake').
ncbi_mult_taxo_gbnm(382770, 'dusky-bellied water snake').
ncbi_mult_taxo_gbnm(382772, 'striped Ethiopian snake').
ncbi_mult_taxo_gbnm(382950, 'Far Eastern smooth flounder').
ncbi_mult_taxo_gbnm(382952, 'cresthead flounder').
ncbi_mult_taxo_gbnm(382953, 'Bering flounder').
ncbi_mult_taxo_gbnm(383689, nightingale).
ncbi_mult_taxo_gbnm(383821, 'Southern crevice spiny lizard').
ncbi_mult_taxo_gbnm(383824, 'rough-scaled lizard').
ncbi_mult_taxo_gbnm(383841, 'Uzungwe ridged frog').
ncbi_mult_taxo_gbnm(383850, 'Newton\'s grassland frog').
ncbi_mult_taxo_gbnm(383914, 'arroyo cichlid').
ncbi_mult_taxo_gbnm(383915, 'Nautla cichlid').
ncbi_mult_taxo_gbnm(383916, 'blackgullet cichlid').
ncbi_mult_taxo_gbnm(383918, 'Pantano cichlid').
ncbi_mult_taxo_gbnm(384065, 'speckled rattlesnake').
ncbi_mult_taxo_gbnm(384070, 'Panamint rattlesnake').
ncbi_mult_taxo_gbnm(384071, 'Cedros island rattlesnake').
ncbi_mult_taxo_gbnm(384371, 'Indo-Pacific blue marlin').
ncbi_mult_taxo_gbnm(384378, 'island mackerel').
ncbi_mult_taxo_gbnm(384382, 'Chinese seerfish').
ncbi_mult_taxo_gbnm(384591, 'humpnose big-eye bream').
ncbi_mult_taxo_gbnm(384593, trumpetsnout).
ncbi_mult_taxo_gbnm(384595, 'short-nosed tripodfish').
ncbi_mult_taxo_gbnm(384597, basketfish).
ncbi_mult_taxo_gbnm(384598, 'bluespotted boxfish').
ncbi_mult_taxo_gbnm(384633, 'Atacama myotis').
ncbi_mult_taxo_gbnm(384634, 'Chilean myotis').
ncbi_mult_taxo_gbnm(384635, 'gray myotis').
ncbi_mult_taxo_gbnm(384675, 'crescentmarked lily aphid').
ncbi_mult_taxo_gbnm(384679, 'toad notie').
ncbi_mult_taxo_gbnm(384849, 'Boquete rocket frog').
ncbi_mult_taxo_gbnm(384853, 'Beebe\'s rocket frog').
ncbi_mult_taxo_gbnm(384854, 'Chupada rocket frog').
ncbi_mult_taxo_gbnm(384859, 'rainforest rocket frog').
ncbi_mult_taxo_gbnm(384860, 'Santa Rita rocket frog').
ncbi_mult_taxo_gbnm(384862, 'Rivero\'s rocket frog').
ncbi_mult_taxo_gbnm(384863, 'Silverstone\'s rocket frog').
ncbi_mult_taxo_gbnm(384864, 'common rocket frog').
ncbi_mult_taxo_gbnm(384871, 'blue-breasted poison frog').
ncbi_mult_taxo_gbnm(384873, 'salty rocket frog').
ncbi_mult_taxo_gbnm(384892, 'forest rocket frog').
ncbi_mult_taxo_gbnm(384894, 'red-banded poison frog').
ncbi_mult_taxo_gbnm(384895, 'yellow-striped poison frog').
ncbi_mult_taxo_gbnm(384899, 'turquoise-bellied poison frog').
ncbi_mult_taxo_gbnm(384900, 'yellow-spotted frog').
ncbi_mult_taxo_gbnm(384901, 'Manu poison frog').
ncbi_mult_taxo_gbnm(384902, 'Peruvian poison frog').
ncbi_mult_taxo_gbnm(384923, 'skunk frogs').
ncbi_mult_taxo_gbnm(384924, 'skunk frog').
ncbi_mult_taxo_gbnm(384947, 'montane wattle').
ncbi_mult_taxo_gbnm(384949, 'forest siris').
ncbi_mult_taxo_gbnm(384952, coachwood).
ncbi_mult_taxo_gbnm(385035, 'Schwartz\'s myotis').
ncbi_mult_taxo_gbnm(385036, 'Indiana bat').
ncbi_mult_taxo_gbnm(385037, 'Taiwan broad-muzzled bat').
ncbi_mult_taxo_gbnm(385125, 'spot-celled siser').
ncbi_mult_taxo_gbnm(385126, 'orange-washed sister').
ncbi_mult_taxo_gbnm(385129, 'Mexican sister').
ncbi_mult_taxo_gbnm(385131, 'circle-spot sister').
ncbi_mult_taxo_gbnm(385132, 'rayed sister').
ncbi_mult_taxo_gbnm(385135, 'golden-banded sister').
ncbi_mult_taxo_gbnm(385136, 'brownish sister').
ncbi_mult_taxo_gbnm(385276, 'banjo catfish').
ncbi_mult_taxo_gbnm(385307, 'sucker throat catfish').
ncbi_mult_taxo_gbnm(385381, 'eastern orange tip').
ncbi_mult_taxo_gbnm(385388, 'tea-oil Camellia').
ncbi_mult_taxo_gbnm(385523, 'six-toothed spruce bark beetle').
ncbi_mult_taxo_gbnm(385555, 'tuberculate cockle').
ncbi_mult_taxo_gbnm(385652, 'mountain newts').
ncbi_mult_taxo_gbnm(385653, 'Ryukyu spiny newt').
ncbi_mult_taxo_gbnm(385654, 'Chinhai spiny newt').
ncbi_mult_taxo_gbnm(385657, 'black-spotted newt').
ncbi_mult_taxo_gbnm(385666, 'Spanish alpine newt').
ncbi_mult_taxo_gbnm(385668, 'Macedonian crested newt').
ncbi_mult_taxo_gbnm(385674, 'black knobby newt').
ncbi_mult_taxo_gbnm(385675, 'Hainan knobby newt').
ncbi_mult_taxo_gbnm(385676, 'red-tailed knobby newt').
ncbi_mult_taxo_gbnm(385678, 'Wenxian knobby newt').
ncbi_mult_taxo_gbnm(385971, 'Malabar mahseer').
ncbi_mult_taxo_gbnm(386281, 'purple stem mustard').
ncbi_mult_taxo_gbnm(386308, 'blue copper').
ncbi_mult_taxo_gbnm(386309, 'Nivalis copper').
ncbi_mult_taxo_gbnm(386521, 'Ivory-billed woodpecker').
ncbi_mult_taxo_gbnm(386524, 'Imperial woodpecker').
ncbi_mult_taxo_gbnm(386614, 'thorny skate').
ncbi_mult_taxo_gbnm(386629, 'bamboo borer').
ncbi_mult_taxo_gbnm(386762, 'Cainarachi poison frog').
ncbi_mult_taxo_gbnm(386774, 'Maghrebian Myotis').
ncbi_mult_taxo_gbnm(387440, 'bluntnose klipfish').
ncbi_mult_taxo_gbnm(387771, 'sloe bug').
ncbi_mult_taxo_gbnm(387787, 'Shikra').
ncbi_mult_taxo_gbnm(387800, 'black goshawk').
ncbi_mult_taxo_gbnm(387806, 'Chinese goshawk').
ncbi_mult_taxo_gbnm(387809, 'red-chested goshawk').
ncbi_mult_taxo_gbnm(387810, besra).
ncbi_mult_taxo_gbnm(387814, 'grey-lined hawk').
ncbi_mult_taxo_gbnm(387821, 'swamp harrier').
ncbi_mult_taxo_gbnm(387827, 'pied harrier').
ncbi_mult_taxo_gbnm(387845, 'Gabar goshawk').
ncbi_mult_taxo_gbnm(387911, 'Sicilian shrew').
ncbi_mult_taxo_gbnm(387912, 'Zimmermann\'s shrew').
ncbi_mult_taxo_gbnm(387933, 'Okinawa rice frog').
ncbi_mult_taxo_gbnm(387934, 'ornate chorus frog').
ncbi_mult_taxo_gbnm(387945, 'bird skin lice').
ncbi_mult_taxo_gbnm(388094, 'badwater snail').
ncbi_mult_taxo_gbnm(388627, 'white-barred boxfish').
ncbi_mult_taxo_gbnm(388628, 'spotfin burrfish').
ncbi_mult_taxo_gbnm(388879, 'Finca Chiblac salamander').
ncbi_mult_taxo_gbnm(388880, 'forest bromeliad salamander').
ncbi_mult_taxo_gbnm(388883, 'Firschein\'s false brook salamander').
ncbi_mult_taxo_gbnm(388884, 'Acultzingo pigmy salamander').
ncbi_mult_taxo_gbnm(388885, 'Oaxacan pigmy salamander').
ncbi_mult_taxo_gbnm(388886, 'Taylor\'s pigmy salamander').
ncbi_mult_taxo_gbnm(388999, 'Moorland francolin').
ncbi_mult_taxo_gbnm(389005, 'Nahan\'s partridge').
ncbi_mult_taxo_gbnm(389019, 'chestnut-naped francolin').
ncbi_mult_taxo_gbnm(389261, 'Cyrenaica shrew').
ncbi_mult_taxo_gbnm(389262, 'Neglected shrew').
ncbi_mult_taxo_gbnm(389263, 'Tiny white-toothed shrew').
ncbi_mult_taxo_gbnm(389264, 'Forest shrew').
ncbi_mult_taxo_gbnm(389287, 'Balearic toad').
ncbi_mult_taxo_gbnm(389288, 'African green toad').
ncbi_mult_taxo_gbnm(389293, 'Ladakh toad').
ncbi_mult_taxo_gbnm(389294, 'Lorestan toad').
ncbi_mult_taxo_gbnm(389298, 'Swat green toad').
ncbi_mult_taxo_gbnm(389299, 'Batura glacier toad').
ncbi_mult_taxo_gbnm(389303, 'Luristan toad').
ncbi_mult_taxo_gbnm(389304, 'Turan toad').
ncbi_mult_taxo_gbnm(389874, 'Kinabulu horned frog').
ncbi_mult_taxo_gbnm(390296, 'Japan surgeonfish').
ncbi_mult_taxo_gbnm(390298, 'fairy mullet').
ncbi_mult_taxo_gbnm(390299, 'common glassfishes').
ncbi_mult_taxo_gbnm(390300, 'longspine glassy').
ncbi_mult_taxo_gbnm(390302, 'redspotted hawkfish').
ncbi_mult_taxo_gbnm(390303, 'blacktip cardinalfish').
ncbi_mult_taxo_gbnm(390304, 'squaretail duckbill').
ncbi_mult_taxo_gbnm(390307, 'fortesque waspfish').
ncbi_mult_taxo_gbnm(390308, 'Suttkus sea toad').
ncbi_mult_taxo_gbnm(390314, 'longfinned bullseye').
ncbi_mult_taxo_gbnm(390316, 'oriental flying gurnard').
ncbi_mult_taxo_gbnm(390324, galjoen).
ncbi_mult_taxo_gbnm(390330, 'Atlantic rubyfish').
ncbi_mult_taxo_gbnm(390332, 'striped mojarra').
ncbi_mult_taxo_gbnm(390335, 'half-banded stargazer').
ncbi_mult_taxo_gbnm(390337, 'red velvetfish').
ncbi_mult_taxo_gbnm(390338, 'Clipperton angelfish').
ncbi_mult_taxo_gbnm(390340, 'pelagic basslet').
ncbi_mult_taxo_gbnm(390343, 'spotted ghoul').
ncbi_mult_taxo_gbnm(390349, 'great northern tilefish').
ncbi_mult_taxo_gbnm(390350, 'striped poison-fang blenny').
ncbi_mult_taxo_gbnm(390351, 'Canary fangblenny').
ncbi_mult_taxo_gbnm(390356, 'shortnose batfish').
ncbi_mult_taxo_gbnm(390358, 'yellowhead jawfish').
ncbi_mult_taxo_gbnm(390362, 'small-toothed whiptail').
ncbi_mult_taxo_gbnm(390363, 'star butterfish').
ncbi_mult_taxo_gbnm(390365, 'Guinean toadfish').
ncbi_mult_taxo_gbnm(390371, 'sunrise dottyback').
ncbi_mult_taxo_gbnm(390377, 'brownspotted spinefoot').
ncbi_mult_taxo_gbnm(390378, 'ocellated dragonet').
ncbi_mult_taxo_gbnm(390380, 'sailfin weever').
ncbi_mult_taxo_gbnm(390381, 'West African stargazer').
ncbi_mult_taxo_gbnm(390418, bubu).
ncbi_mult_taxo_gbnm(390428, 'African glass catfish').
ncbi_mult_taxo_gbnm(390435, 'Peruvian sea catfish').
ncbi_mult_taxo_gbnm(390465, semutundu).
ncbi_mult_taxo_gbnm(390484, 'narrowfoot tandan').
ncbi_mult_taxo_gbnm(390660, 'Steven\'s honeyeater').
ncbi_mult_taxo_gbnm(390672, 'pugnose ponyfish').
ncbi_mult_taxo_gbnm(390675, 'soft eelpout').
ncbi_mult_taxo_gbnm(390685, greeneye).
ncbi_mult_taxo_gbnm(390686, 'duckbill grenadier').
ncbi_mult_taxo_gbnm(390689, 'Japanese grenadier').
ncbi_mult_taxo_gbnm(390690, 'Kamohara grenadier').
ncbi_mult_taxo_gbnm(390691, 'spearnose grenadier').
ncbi_mult_taxo_gbnm(390693, 'Jordan\'s cod').
ncbi_mult_taxo_gbnm(390718, 'mountain Borneo frog').
ncbi_mult_taxo_gbnm(390719, 'Whitehead\'s Borneo frog').
ncbi_mult_taxo_gbnm(390721, 'southern silvery-kingfisher').
ncbi_mult_taxo_gbnm(390723, 'Indigo-banded kingfisher').
ncbi_mult_taxo_gbnm(390726, 'blue-eared kingfisher').
ncbi_mult_taxo_gbnm(390731, 'Rufous-backed kingfisher').
ncbi_mult_taxo_gbnm(390975, 'yellow-billed aracari').
ncbi_mult_taxo_gbnm(390977, 'cucumber moth').
ncbi_mult_taxo_gbnm(390985, 'European house borer').
ncbi_mult_taxo_gbnm(391180, 'northern sea otter').
ncbi_mult_taxo_gbnm(391182, 'muddy arrowtooth eel').
ncbi_mult_taxo_gbnm(391184, 'crocodile snake eel').
ncbi_mult_taxo_gbnm(391186, 'painted eel').
ncbi_mult_taxo_gbnm(391188, 'short-headed worm eel').
ncbi_mult_taxo_gbnm(391189, 'tiger snake eel').
ncbi_mult_taxo_gbnm(391192, 'narrownecked oceanic eel').
ncbi_mult_taxo_gbnm(391196, 'Guinea pike conger').
ncbi_mult_taxo_gbnm(391200, 'Guinean conger').
ncbi_mult_taxo_gbnm(391202, 'large-toothed conger').
ncbi_mult_taxo_gbnm(391203, 'little conger').
ncbi_mult_taxo_gbnm(391206, 'spotted garden-eel').
ncbi_mult_taxo_gbnm(391210, 'mottled conger').
ncbi_mult_taxo_gbnm(391214, 'blackfin sorcerer').
ncbi_mult_taxo_gbnm(391216, 'whipsnout sorcerer').
ncbi_mult_taxo_gbnm(391219, congro).
ncbi_mult_taxo_gbnm(391220, 'spotted snake moray').
ncbi_mult_taxo_gbnm(391222, 'ribbon moray').
ncbi_mult_taxo_gbnm(391223, 'Java spaghetti eel').
ncbi_mult_taxo_gbnm(391225, 'smallmouth spiny eel').
ncbi_mult_taxo_gbnm(391339, 'midland painted turtle').
ncbi_mult_taxo_gbnm(391344, 'Florida box turtle').
ncbi_mult_taxo_gbnm(391345, 'Eastern box turtle').
ncbi_mult_taxo_gbnm(391346, 'Gulf Coast box turtle').
ncbi_mult_taxo_gbnm(391643, 'Arisan salamander').
ncbi_mult_taxo_gbnm(391644, 'Taiwan lesser salamander').
ncbi_mult_taxo_gbnm(391645, 'Nanhu salamander').
ncbi_mult_taxo_gbnm(391700, 'white-tailed wheatear').
ncbi_mult_taxo_gbnm(391703, 'black wheatear').
ncbi_mult_taxo_gbnm(391706, 'Mourning wheatear').
ncbi_mult_taxo_gbnm(391707, 'Arabian wheatear').
ncbi_mult_taxo_gbnm(391710, 'variable wheatear').
ncbi_mult_taxo_gbnm(391724, 'Iranian mourning wheatear').
ncbi_mult_taxo_gbnm(391864, 'Peters\' Malaysian frog').
ncbi_mult_taxo_gbnm(391866, 'yellow stream frog').
ncbi_mult_taxo_gbnm(391871, 'American freshwater goby').
ncbi_mult_taxo_gbnm(392060, 'Tonkin frog').
ncbi_mult_taxo_gbnm(392063, 'Morafkai frog').
ncbi_mult_taxo_gbnm(392228, 'oriental spider mite').
ncbi_mult_taxo_gbnm(392230, 'date mite').
ncbi_mult_taxo_gbnm(392231, 'mango spider mite').
ncbi_mult_taxo_gbnm(392232, 'avocado spider mite').
ncbi_mult_taxo_gbnm(392237, 'asparagus spider mite').
ncbi_mult_taxo_gbnm(392295, 'boreal clubhook squid').
ncbi_mult_taxo_gbnm(392296, 'common clubhook squid').
ncbi_mult_taxo_gbnm(392301, 'Japanese hooked squid').
ncbi_mult_taxo_gbnm(392302, 'freckled goatish').
ncbi_mult_taxo_gbnm(392307, 'Bali sardinella').
ncbi_mult_taxo_gbnm(392425, 'Okhotsk skate').
ncbi_mult_taxo_gbnm(392506, 'Allen\'s olingo').
ncbi_mult_taxo_gbnm(392507, 'Cacomistle').
ncbi_mult_taxo_gbnm(392539, 'obtuse barracuda').
ncbi_mult_taxo_gbnm(392540, 'red barracuda').
ncbi_mult_taxo_gbnm(392542, 'sharpfin barracuda').
ncbi_mult_taxo_gbnm(392543, 'bigeye barracuda').
ncbi_mult_taxo_gbnm(392544, 'Heller\'s barracuda').
ncbi_mult_taxo_gbnm(392545, 'Japanese barracuda').
ncbi_mult_taxo_gbnm(392546, 'striped threadfin').
ncbi_mult_taxo_gbnm(392897, 'starry triggerfish').
ncbi_mult_taxo_gbnm(392899, 'orange-lined triggerfish').
ncbi_mult_taxo_gbnm(392900, 'pinktail triggerfish').
ncbi_mult_taxo_gbnm(392902, 'redtoothed triggerfish').
ncbi_mult_taxo_gbnm(392903, 'yellowmargin triggerfish').
ncbi_mult_taxo_gbnm(392908, 'spiny-tailed leatherjacket').
ncbi_mult_taxo_gbnm(392911, 'Japanese inflator filefish').
ncbi_mult_taxo_gbnm(392913, 'prickly leatherjacket').
ncbi_mult_taxo_gbnm(392919, 'mosaic leatherjacket').
ncbi_mult_taxo_gbnm(392920, 'horse-shoe leatherjacket').
ncbi_mult_taxo_gbnm(392921, 'fan-bellied leatherjacket').
ncbi_mult_taxo_gbnm(392923, 'pig faced leather jacket').
ncbi_mult_taxo_gbnm(392925, 'blackbar filefish').
ncbi_mult_taxo_gbnm(392927, 'pot-bellied leatherjacket').
ncbi_mult_taxo_gbnm(392929, 'rhino leatherjacket').
ncbi_mult_taxo_gbnm(392931, 'whitespotted pygmy filefish').
ncbi_mult_taxo_gbnm(392933, 'rough leatherjacket').
ncbi_mult_taxo_gbnm(392941, 'plain squeaker').
ncbi_mult_taxo_gbnm(392942, 'blackspotted squeaker').
ncbi_mult_taxo_gbnm(392943, 'featherfin squeaker').
ncbi_mult_taxo_gbnm(392948, 'cuckoo catfish').
ncbi_mult_taxo_gbnm(392955, 'Malawi squeaker').
ncbi_mult_taxo_gbnm(392956, 'Lake Victoria squeaker').
ncbi_mult_taxo_gbnm(392957, 'orongestriped squeaker').
ncbi_mult_taxo_gbnm(393319, 'Japanese peppered moth').
ncbi_mult_taxo_gbnm(393326, 'white-pinioned spotted').
ncbi_mult_taxo_gbnm(393602, 'Ambon damsel').
ncbi_mult_taxo_gbnm(393709, 'snowy-browed flycatcher').
ncbi_mult_taxo_gbnm(393717, 'cryptic flycatcher').
ncbi_mult_taxo_gbnm(393727, 'furtive flycatcher').
ncbi_mult_taxo_gbnm(393871, 'great windmill').
ncbi_mult_taxo_gbnm(394056, 'Schneider\'s roundleaf bat').
ncbi_mult_taxo_gbnm(394126, 'rainforest cool-skink').
ncbi_mult_taxo_gbnm(394140, 'Common dotted garden skink').
ncbi_mult_taxo_gbnm(394149, 'Lined firetail skink').
ncbi_mult_taxo_gbnm(394158, 'Highlands forest-skink').
ncbi_mult_taxo_gbnm(394299, 'Curmuca barb').
ncbi_mult_taxo_gbnm(394442, 'Puerto Cabello treefrog').
ncbi_mult_taxo_gbnm(394443, 'Popayan marsupial frog').
ncbi_mult_taxo_gbnm(394445, 'gold-spotted marsupial frog').
ncbi_mult_taxo_gbnm(394446, 'Christian\'s marsupial frog').
ncbi_mult_taxo_gbnm(394447, 'Salta marsupial frog').
ncbi_mult_taxo_gbnm(394448, 'Rio Calima marsupial frog').
ncbi_mult_taxo_gbnm(394449, 'Dunn\'s marsupial frog').
ncbi_mult_taxo_gbnm(394450, 'Abra Acanacu marsupial frog').
ncbi_mult_taxo_gbnm(394451, 'helmeted marsupial frog').
ncbi_mult_taxo_gbnm(394452, 'La Banderita marsupial frog').
ncbi_mult_taxo_gbnm(394453, 'Guenther\'s marsupial frog').
ncbi_mult_taxo_gbnm(394454, 'Helena\'s marsupial frog').
ncbi_mult_taxo_gbnm(394455, 'Azuay marsupial frog').
ncbi_mult_taxo_gbnm(394456, 'Pastaza marsupial frog').
ncbi_mult_taxo_gbnm(394457, 'Niceforo\'s marsupial frog').
ncbi_mult_taxo_gbnm(394458, 'Chilica marsupial frog').
ncbi_mult_taxo_gbnm(394459, 'Papallacta marsupial frog').
ncbi_mult_taxo_gbnm(394460, 'giant marsupial frog').
ncbi_mult_taxo_gbnm(394461, 'Peru marsupial frog').
ncbi_mult_taxo_gbnm(394462, 'silver marsupial frog').
ncbi_mult_taxo_gbnm(394463, 'ridge marsupial frog').
ncbi_mult_taxo_gbnm(394464, 'Ruiz\'s marsupial frog').
ncbi_mult_taxo_gbnm(394466, 'Cerro Munchique marsupial frog').
ncbi_mult_taxo_gbnm(394467, 'Walker\'s marsupial frog').
ncbi_mult_taxo_gbnm(394468, 'Weinland\'s marsupial frog').
ncbi_mult_taxo_gbnm(394470, 'Ecuador horned treefrog').
ncbi_mult_taxo_gbnm(394471, 'Spix\'s horned treefrog').
ncbi_mult_taxo_gbnm(394473, 'Tepuis treefrog').
ncbi_mult_taxo_gbnm(394530, 'plum psyllid').
ncbi_mult_taxo_gbnm(394588, 'Bryant\'s woodrat').
ncbi_mult_taxo_gbnm(394687, 'shortraker rockfish').
ncbi_mult_taxo_gbnm(394688, 'black-and-yellow rockfish').
ncbi_mult_taxo_gbnm(394689, 'Cortez rockfish').
ncbi_mult_taxo_gbnm(394690, 'calico rockfish').
ncbi_mult_taxo_gbnm(394691, 'Acadian redfish').
ncbi_mult_taxo_gbnm(394693, 'Mexican rockfish').
ncbi_mult_taxo_gbnm(394694, 'semaphore rockfish').
ncbi_mult_taxo_gbnm(394695, 'blackspotted rockfish').
ncbi_mult_taxo_gbnm(394696, 'deepwater redfish').
ncbi_mult_taxo_gbnm(394698, 'China rockfish').
ncbi_mult_taxo_gbnm(394699, 'golden redfish').
ncbi_mult_taxo_gbnm(394701, 'chameleon rockfish').
ncbi_mult_taxo_gbnm(394702, 'northern rockfish').
ncbi_mult_taxo_gbnm(394703, 'redstripe rockfish').
ncbi_mult_taxo_gbnm(394704, 'yellowmouth rockfish').
ncbi_mult_taxo_gbnm(394705, 'dwarf-red rockfish').
ncbi_mult_taxo_gbnm(394706, 'blackmouth rockfish').
ncbi_mult_taxo_gbnm(394708, 'Norway redfish').
ncbi_mult_taxo_gbnm(395009, 'Jerdon\'s palm civet').
ncbi_mult_taxo_gbnm(395025, 'Maritime shrew').
ncbi_mult_taxo_gbnm(395101, 'black rajah').
ncbi_mult_taxo_gbnm(395383, 'Akaishi salamander').
ncbi_mult_taxo_gbnm(395521, 'great yellow bumblebee').
ncbi_mult_taxo_gbnm(395839, 'Otter civet').
ncbi_mult_taxo_gbnm(395889, 'South polar skua').
ncbi_mult_taxo_gbnm(396041, 'yellow cardinalfish').
ncbi_mult_taxo_gbnm(396409, 'sickle-bearing bush cricket').
ncbi_mult_taxo_gbnm(396680, 'Guatemalan potato tuber moth').
ncbi_mult_taxo_gbnm(396706, 'Bhutan sargeant').
ncbi_mult_taxo_gbnm(396710, 'glassy tiger').
ncbi_mult_taxo_gbnm(396783, 'yellow-banded snapper').
ncbi_mult_taxo_gbnm(396784, 'two-spotted red snapper').
ncbi_mult_taxo_gbnm(396785, 'Spanish flag snapper').
ncbi_mult_taxo_gbnm(396786, 'humpback red snapper').
ncbi_mult_taxo_gbnm(396787, 'common bluestripe snapper').
ncbi_mult_taxo_gbnm(396788, 'onespot snapper').
ncbi_mult_taxo_gbnm(396789, 'five-lined snapper').
ncbi_mult_taxo_gbnm(396791, 'black and white snapper').
ncbi_mult_taxo_gbnm(396792, 'yellow-striped sweetlips').
ncbi_mult_taxo_gbnm(396793, 'Marr\'s fusilier').
ncbi_mult_taxo_gbnm(396794, 'banana fusilier').
ncbi_mult_taxo_gbnm(396798, chinamanfish).
ncbi_mult_taxo_gbnm(396892, 'gilded catfish').
ncbi_mult_taxo_gbnm(396893, 'Laulao catfish').
ncbi_mult_taxo_gbnm(397330, 'delicate mouse').
ncbi_mult_taxo_gbnm(397331, 'Thomas\'s pygmy mouse').
ncbi_mult_taxo_gbnm(397332, 'toad mouse').
ncbi_mult_taxo_gbnm(397410, 'spruce budworm').
ncbi_mult_taxo_gbnm(397595, 'Black River madtom').
ncbi_mult_taxo_gbnm(397598, 'sea urchin cardinalfish').
ncbi_mult_taxo_gbnm(397613, 'Pygmy brocket').
ncbi_mult_taxo_gbnm(397614, 'Chilean guemal').
ncbi_mult_taxo_gbnm(397615, 'Sao Paulo bororo').
ncbi_mult_taxo_gbnm(397748, 'Chinanteco deer mouse').
ncbi_mult_taxo_gbnm(397749, 'Ixtlan deermouse').
ncbi_mult_taxo_gbnm(397750, 'Jico deermouse').
ncbi_mult_taxo_gbnm(397751, 'Delicate deermouse').
ncbi_mult_taxo_gbnm(398258, 'crimson jobfish').
ncbi_mult_taxo_gbnm(398259, 'moontail bullseye').
ncbi_mult_taxo_gbnm(398260, 'pigeye shark').
ncbi_mult_taxo_gbnm(398265, 'golden-spot hogfish').
ncbi_mult_taxo_gbnm(398266, 'needlescaled queenfish').
ncbi_mult_taxo_gbnm(398430, 'colour sergeant').
ncbi_mult_taxo_gbnm(398601, 'great diving beetle').
ncbi_mult_taxo_gbnm(398651, 'magnificent snake eel').
ncbi_mult_taxo_gbnm(398656, 'yellowbar parrot').
ncbi_mult_taxo_gbnm(398657, 'fantail filefish').
ncbi_mult_taxo_gbnm(398658, 'shy filefish').
ncbi_mult_taxo_gbnm(398661, 'yellow-threaded goatfish').
ncbi_mult_taxo_gbnm(398662, 'Hawaiian bigeye').
ncbi_mult_taxo_gbnm(398665, 'Hawaiian cleaner wrasse').
ncbi_mult_taxo_gbnm(399147, 'Antarctic escolar').
ncbi_mult_taxo_gbnm(399150, 'spinycheek scorpionfish').
ncbi_mult_taxo_gbnm(399151, 'inshore lizardfish').
ncbi_mult_taxo_gbnm(399177, 'mahogany frog').
ncbi_mult_taxo_gbnm(399178, 'Patagonian panther').
ncbi_mult_taxo_gbnm(399189, 'southwestern white pine').
ncbi_mult_taxo_gbnm(399229, 'Bucharian vole').
ncbi_mult_taxo_gbnm(399230, 'Blyth\'s vole').
ncbi_mult_taxo_gbnm(399234, 'Mandarin vole').
ncbi_mult_taxo_gbnm(399272, 'hump-back bream').
ncbi_mult_taxo_gbnm(399283, 'soybean stalk weevil').
ncbi_mult_taxo_gbnm(399315, 'Forest grass mouse').
ncbi_mult_taxo_gbnm(399317, 'Dark-furred akodont').
ncbi_mult_taxo_gbnm(399386, 'Labrador duck').
ncbi_mult_taxo_gbnm(399407, 'blackbelt cichlid').
ncbi_mult_taxo_gbnm(399533, 'Bella rat snake').
ncbi_mult_taxo_gbnm(399535, 'Zagrosian lizard').
ncbi_mult_taxo_gbnm(399537, 'ocellated lizard').
ncbi_mult_taxo_gbnm(399589, 'cocoi heron').
ncbi_mult_taxo_gbnm(399782, 'Formosan sambar').
ncbi_mult_taxo_gbnm(399793, 'Maya mouse').
ncbi_mult_taxo_gbnm(400010, 'bihorned barbel').
ncbi_mult_taxo_gbnm(400054, 'Steppe field mouse').
ncbi_mult_taxo_gbnm(400067, 'crocodile catfish').
ncbi_mult_taxo_gbnm(400184, 'Silver mountain vole').
ncbi_mult_taxo_gbnm(400185, 'Gobi altai mountain vole').
ncbi_mult_taxo_gbnm(400406, 'slender bush katydid').
ncbi_mult_taxo_gbnm(400481, 'Agile antechinus').
ncbi_mult_taxo_gbnm(400502, 'autumn meadowhawk').
ncbi_mult_taxo_gbnm(400569, 'buckthorn aphid').
ncbi_mult_taxo_gbnm(400678, 'eastern snowfly').
ncbi_mult_taxo_gbnm(400679, 'narrow-lobed needlefly').
ncbi_mult_taxo_gbnm(400782, 'New World warblers').
ncbi_mult_taxo_gbnm(400783, tanagers).
ncbi_mult_taxo_gbnm(401044, 'four-banded Pacific iguana').
ncbi_mult_taxo_gbnm(401524, 'Malayan forest gecko').
ncbi_mult_taxo_gbnm(401547, 'banded leaf-toed gecko').
ncbi_mult_taxo_gbnm(401549, 'South American marked gecko').
ncbi_mult_taxo_gbnm(401564, 'Spotted bent-toed gecko').
ncbi_mult_taxo_gbnm(401699, 'roundscale spearfish').
ncbi_mult_taxo_gbnm(402025, 'tufted jay').
ncbi_mult_taxo_gbnm(402026, 'Yucatan jay').
ncbi_mult_taxo_gbnm(402027, 'Cayenne jay').
ncbi_mult_taxo_gbnm(402239, 'Sambirano woolly lemur').
ncbi_mult_taxo_gbnm(402375, 'common flat-tail gecko').
ncbi_mult_taxo_gbnm(402403, 'fangtooth pellonulines').
ncbi_mult_taxo_gbnm(402404, 'Regan\'s fangtooth pellonuline').
ncbi_mult_taxo_gbnm(402406, 'smalltoothed pellonula').
ncbi_mult_taxo_gbnm(402710, 'Malabar mystus').
ncbi_mult_taxo_gbnm(402888, 'Arunachal macaque').
ncbi_mult_taxo_gbnm(402889, 'American cave lion').
ncbi_mult_taxo_gbnm(403224, 'Chinese gizzard shad').
ncbi_mult_taxo_gbnm(403504, 'Abu mullet').
ncbi_mult_taxo_gbnm(403789, 'Marbled whiptail').
ncbi_mult_taxo_gbnm(403993, 'Indian day gecko').
ncbi_mult_taxo_gbnm(403997, 'Cabreria spiny-chest frog').
ncbi_mult_taxo_gbnm(403998, 'black spiny-chest frog').
ncbi_mult_taxo_gbnm(404000, 'La Parva spiny-chest frog').
ncbi_mult_taxo_gbnm(404002, 'Chile four-eyed frog').
ncbi_mult_taxo_gbnm(404336, 'Oaxaca giant deer mouse').
ncbi_mult_taxo_gbnm(404363, 'Spanish fly').
ncbi_mult_taxo_gbnm(404964, 'bugeye squeaker').
ncbi_mult_taxo_gbnm(404965, 'clown squeaker').
ncbi_mult_taxo_gbnm(404967, 'Congo squeaker').
ncbi_mult_taxo_gbnm(404971, 'Fischer\'s Victoria squeaker').
ncbi_mult_taxo_gbnm(404976, 'Japanese brown frog').
ncbi_mult_taxo_gbnm(405009, 'high brown fritillary').
ncbi_mult_taxo_gbnm(405010, 'dark green fritillary').
ncbi_mult_taxo_gbnm(405012, 'large silverstripe').
ncbi_mult_taxo_gbnm(405014, 'Indian fritillary').
ncbi_mult_taxo_gbnm(405015, 'common silverstripe').
ncbi_mult_taxo_gbnm(405016, 'eastern silverstripe').
ncbi_mult_taxo_gbnm(405017, 'Niobe fritillary').
ncbi_mult_taxo_gbnm(405018, 'cardinal fritillary').
ncbi_mult_taxo_gbnm(405021, 'cranberry fritillary').
ncbi_mult_taxo_gbnm(405022, 'bog fritillary').
ncbi_mult_taxo_gbnm(405023, 'pearl-bordered fritillary').
ncbi_mult_taxo_gbnm(405024, 'shepherd\'s fritillary').
ncbi_mult_taxo_gbnm(405029, 'Hannington\'s fritillary').
ncbi_mult_taxo_gbnm(405032, 'marbled fritillary').
ncbi_mult_taxo_gbnm(405033, 'twin-spot fritillary').
ncbi_mult_taxo_gbnm(405034, 'lesser marbled fritillary').
ncbi_mult_taxo_gbnm(405069, 'Black-collared forest warbler').
ncbi_mult_taxo_gbnm(405071, 'Collared forest warbler').
ncbi_mult_taxo_gbnm(405084, 'Mrs. Moreau\'s warbler').
ncbi_mult_taxo_gbnm(405088, 'Cape crombec').
ncbi_mult_taxo_gbnm(405139, 'Malabar leaffish').
ncbi_mult_taxo_gbnm(405184, 'two-clawed worm-skink').
ncbi_mult_taxo_gbnm(405186, 'slender mulch-skink').
ncbi_mult_taxo_gbnm(405189, 'grey-tailed skink').
ncbi_mult_taxo_gbnm(405190, 'Atherton tableland skink').
ncbi_mult_taxo_gbnm(405192, 'dwarf mulch-skink').
ncbi_mult_taxo_gbnm(405193, 'fine-spotted mulch-skink').
ncbi_mult_taxo_gbnm(405194, 'southwestern earless skink').
ncbi_mult_taxo_gbnm(405196, 'short-limbed snake-skink').
ncbi_mult_taxo_gbnm(405651, 'Amur weatherfish').
ncbi_mult_taxo_gbnm(405916, 'larch engraver beetle').
ncbi_mult_taxo_gbnm(405945, 'Siberian motherwort').
ncbi_mult_taxo_gbnm(406260, 'Bombay caecilian').
ncbi_mult_taxo_gbnm(406282, 'sixbar panchax').
ncbi_mult_taxo_gbnm(406531, 'masked spinefoot').
ncbi_mult_taxo_gbnm(406532, 'goldspotted spinefoot').
ncbi_mult_taxo_gbnm(406533, 'bicolored foxface').
ncbi_mult_taxo_gbnm(406534, 'magnificent rabbitfish').
ncbi_mult_taxo_gbnm(406535, 'golden-lined spinefoot').
ncbi_mult_taxo_gbnm(406536, 'blue-spotted spinefoot').
ncbi_mult_taxo_gbnm(406553, 'Gardiner\'s Seychelles frog').
ncbi_mult_taxo_gbnm(406587, 'spiny flower mantis').
ncbi_mult_taxo_gbnm(406589, 'Chinese praying mantis').
ncbi_mult_taxo_gbnm(406788, 'Cross River gorilla').
ncbi_mult_taxo_gbnm(407057, 'flat-headed salamander').
ncbi_mult_taxo_gbnm(407093, 'western blacknose dace').
ncbi_mult_taxo_gbnm(407094, 'leopard dace').
ncbi_mult_taxo_gbnm(407121, 'Korean horse cicada').
ncbi_mult_taxo_gbnm(407171, 'Brandt\'s vole').
ncbi_mult_taxo_gbnm(407982, 'night parrot').
ncbi_mult_taxo_gbnm(408208, 'Ceylon earth snake').
ncbi_mult_taxo_gbnm(408244, 'Cyprus processionary caterpillar').
ncbi_mult_taxo_gbnm(408596, 'brown mirid').
ncbi_mult_taxo_gbnm(408721, 'Thomas\'s Thamnomys').
ncbi_mult_taxo_gbnm(408872, 'Kashmir red deer').
ncbi_mult_taxo_gbnm(408873, 'Scottish red deer').
ncbi_mult_taxo_gbnm(409016, 'Broad-toothed tailless bat').
ncbi_mult_taxo_gbnm(409017, 'Bogota fruit-eating bat').
ncbi_mult_taxo_gbnm(409018, 'Southern dog-faced bat').
ncbi_mult_taxo_gbnm(409020, 'Short-eared bat').
ncbi_mult_taxo_gbnm(409021, 'Isabelle\'s ghost bat').
ncbi_mult_taxo_gbnm(409023, 'Naked-eared deermouse').
ncbi_mult_taxo_gbnm(409024, 'Guatemalan deermouse').
ncbi_mult_taxo_gbnm(409025, 'Black-wristed deermouse').
ncbi_mult_taxo_gbnm(409027, 'Sanborn\'s bonneted bat').
ncbi_mult_taxo_gbnm(409029, 'Tricolored bat').
ncbi_mult_taxo_gbnm(409030, 'Uncommon sword-nosed bat').
ncbi_mult_taxo_gbnm(409031, 'Pygmy round-eared bat').
ncbi_mult_taxo_gbnm(409032, 'Carriker\'s round-eared bat').
ncbi_mult_taxo_gbnm(409033, 'Schulz\'s round-eared bat').
ncbi_mult_taxo_gbnm(409036, 'Rufous dog-faced bat').
ncbi_mult_taxo_gbnm(409046, 'White-winged dog-like bat').
ncbi_mult_taxo_gbnm(409049, 'Eldorado borad-nosed bat').
ncbi_mult_taxo_gbnm(409053, 'Frosted sac-winged bat').
ncbi_mult_taxo_gbnm(409054, 'Amazonian sac-winged bat').
ncbi_mult_taxo_gbnm(409288, 'black-naped oriole').
ncbi_mult_taxo_gbnm(409372, 'Glen\'s long-fingered bat').
ncbi_mult_taxo_gbnm(409373, 'Major\'s long-fingered bat').
ncbi_mult_taxo_gbnm(409884, 'Atlantic sawtail cat shark').
ncbi_mult_taxo_gbnm(409885, 'Temminck\'s Asian trident bat').
ncbi_mult_taxo_gbnm(409921, 'water lily leaf beetle').
ncbi_mult_taxo_gbnm(409996, 'tube-eye').
ncbi_mult_taxo_gbnm(410269, 'black-horned sawfly').
ncbi_mult_taxo_gbnm(410299, 'Highveld gerbil').
ncbi_mult_taxo_gbnm(410300, 'Guinean gerbil').
ncbi_mult_taxo_gbnm(410301, 'Northern savanna gerbil').
ncbi_mult_taxo_gbnm(410302, 'Bushveld gerbil').
ncbi_mult_taxo_gbnm(410303, 'Fringe-tailed gerbil').
ncbi_mult_taxo_gbnm(410305, 'Black-tailed gerbil').
ncbi_mult_taxo_gbnm(410306, 'Southern savanna gerbil').
ncbi_mult_taxo_gbnm(410735, 'Chu\'s croaker').
ncbi_mult_taxo_gbnm(410822, 'Oriental tea tortrix').
ncbi_mult_taxo_gbnm(410827, 'Ruwenzori Hybomys').
ncbi_mult_taxo_gbnm(410828, 'Woosnam\'s brush-furred rat').
ncbi_mult_taxo_gbnm(410851, 'Southern golden bat').
ncbi_mult_taxo_gbnm(410852, 'White-lined broad-nosed bat').
ncbi_mult_taxo_gbnm(411517, 'Kurrichane thrush').
ncbi_mult_taxo_gbnm(411541, 'Black-billed thrush').
ncbi_mult_taxo_gbnm(411548, 'white-throated thrush').
ncbi_mult_taxo_gbnm(411569, 'scaly hairfin anchovy').
ncbi_mult_taxo_gbnm(411571, 'Amazon pellona').
ncbi_mult_taxo_gbnm(411572, 'broad-striped anchovy').
ncbi_mult_taxo_gbnm(411573, 'skipjack shad').
ncbi_mult_taxo_gbnm(411574, 'Bermuda anchovy').
ncbi_mult_taxo_gbnm(411575, 'shortfinger anchovy').
ncbi_mult_taxo_gbnm(411576, 'silver anchovy').
ncbi_mult_taxo_gbnm(411606, 'Cinnamon-colored Thomasomys').
ncbi_mult_taxo_gbnm(411607, 'Ladew\'s Thomasomys').
ncbi_mult_taxo_gbnm(411673, 'three spot swimming crab').
ncbi_mult_taxo_gbnm(411875, 'Formosan black bear').
ncbi_mult_taxo_gbnm(411919, 'Yangtse grenadier anchovy').
ncbi_mult_taxo_gbnm(411963, 'pinion-streaked snout moth').
ncbi_mult_taxo_gbnm(412038, 'black whip snake').
ncbi_mult_taxo_gbnm(412089, 'Rueppell\'s pipistrelle').
ncbi_mult_taxo_gbnm(412090, 'Hanaki\'s dwarf bat').
ncbi_mult_taxo_gbnm(412094, 'Fairy pipistrelle').
ncbi_mult_taxo_gbnm(412095, 'Monticelli\'s Myotis').
ncbi_mult_taxo_gbnm(412143, 'blackvein sargeant').
ncbi_mult_taxo_gbnm(412656, footballfish).
ncbi_mult_taxo_gbnm(412657, 'Atlantic footballfish').
ncbi_mult_taxo_gbnm(412659, 'triplewart seadevil').
ncbi_mult_taxo_gbnm(412660, 'stargazing seadevil').
ncbi_mult_taxo_gbnm(412846, 'many-banded pipefish').
ncbi_mult_taxo_gbnm(412987, 'carrot weevil').
ncbi_mult_taxo_gbnm(413029, 'spotted crow eggfly').
ncbi_mult_taxo_gbnm(413580, 'North African white-toothed shrew').
ncbi_mult_taxo_gbnm(413581, 'Saharan shrew').
ncbi_mult_taxo_gbnm(413582, 'Parma wallaby').
ncbi_mult_taxo_gbnm(413946, 'pygmy cormorant').
ncbi_mult_taxo_gbnm(414294, 'grass sheathminer').
ncbi_mult_taxo_gbnm(414351, 'large-spined bell toad').
ncbi_mult_taxo_gbnm(414352, 'Lichuan bell toad').
ncbi_mult_taxo_gbnm(414442, 'El Carrizo deermouse').
ncbi_mult_taxo_gbnm(414443, 'Stirton\'s deermouse').
ncbi_mult_taxo_gbnm(414444, 'Hooper\'s deermouse').
ncbi_mult_taxo_gbnm(414451, 'Reclusive laucha').
ncbi_mult_taxo_gbnm(414524, 'White-collared fruit bat').
ncbi_mult_taxo_gbnm(414886, lobisomem).
ncbi_mult_taxo_gbnm(414887, dealfish).
ncbi_mult_taxo_gbnm(414892, 'scaly-breasted munia').
ncbi_mult_taxo_gbnm(414895, 'Baya weaver').
ncbi_mult_taxo_gbnm(414917, 'Japanese giant looper').
ncbi_mult_taxo_gbnm(414978, 'Fischer\'s chameleon').
ncbi_mult_taxo_gbnm(414984, 'Matschie\'s dwarf chameleon').
ncbi_mult_taxo_gbnm(415023, 'White-collared manakin').
ncbi_mult_taxo_gbnm(415028, 'White-ruffed manakin').
ncbi_mult_taxo_gbnm(415030, 'jet manakin').
ncbi_mult_taxo_gbnm(415100, 'great silver water beetle').
ncbi_mult_taxo_gbnm(415194, 'double-striped cockroach').
ncbi_mult_taxo_gbnm(415263, 'hippo fly').
ncbi_mult_taxo_gbnm(415323, 'greenish black-tip').
ncbi_mult_taxo_gbnm(415325, 'Lesse\'s greenish black tip').
ncbi_mult_taxo_gbnm(415331, 'dappled white').
ncbi_mult_taxo_gbnm(415332, 'eastern dappled white').
ncbi_mult_taxo_gbnm(415341, 'Portugese dappled white').
ncbi_mult_taxo_gbnm(415757, 'Claire\'s mouse lemur').
ncbi_mult_taxo_gbnm(416366, 'Dwarf fat-tailed mouse opossum').
ncbi_mult_taxo_gbnm(416405, 'red palm mite').
ncbi_mult_taxo_gbnm(416407, 'phalaenopsis mite').
ncbi_mult_taxo_gbnm(416546, 'tronchuda cabbage').
ncbi_mult_taxo_gbnm(416556, 'Chinese pine moth').
ncbi_mult_taxo_gbnm(417023, 'crevice salamander').
ncbi_mult_taxo_gbnm(417024, 'Balsam Mountains salamander').
ncbi_mult_taxo_gbnm(417068, 'gray willow leaf beetle').
ncbi_mult_taxo_gbnm(417462, 'barred killifish').
ncbi_mult_taxo_gbnm(417467, 'barred livebearer').
ncbi_mult_taxo_gbnm(417472, 'creole topminnow').
ncbi_mult_taxo_gbnm(417912, 'estuarine perch').
ncbi_mult_taxo_gbnm(417913, 'redspot darter').
ncbi_mult_taxo_gbnm(417914, 'Conchos darter').
ncbi_mult_taxo_gbnm(417915, 'Christmas darter').
ncbi_mult_taxo_gbnm(417916, 'Hannukkah darter').
ncbi_mult_taxo_gbnm(417917, 'buffalo darter').
ncbi_mult_taxo_gbnm(417918, 'slackwater darter').
ncbi_mult_taxo_gbnm(417920, 'Carolina darter').
ncbi_mult_taxo_gbnm(417921, 'Arkansas darter').
ncbi_mult_taxo_gbnm(417922, 'coldwater darter').
ncbi_mult_taxo_gbnm(417923, 'strawberry darter').
ncbi_mult_taxo_gbnm(417924, 'Savannah darter').
ncbi_mult_taxo_gbnm(417925, 'Rio Grande darter').
ncbi_mult_taxo_gbnm(417927, 'blueside darter').
ncbi_mult_taxo_gbnm(417928, 'highland rim darter').
ncbi_mult_taxo_gbnm(417929, 'headwater darter').
ncbi_mult_taxo_gbnm(417930, 'tufa darter').
ncbi_mult_taxo_gbnm(417931, 'least darter').
ncbi_mult_taxo_gbnm(417932, 'watercress darter').
ncbi_mult_taxo_gbnm(417933, 'Okaloosa darter').
ncbi_mult_taxo_gbnm(417934, 'tessallated darter').
ncbi_mult_taxo_gbnm(417935, 'Chihuahua darter').
ncbi_mult_taxo_gbnm(417937, 'Rio Salado darter').
ncbi_mult_taxo_gbnm(417939, 'Gulf darter').
ncbi_mult_taxo_gbnm(417940, 'Shawnee darter').
ncbi_mult_taxo_gbnm(417941, 'trispot darter').
ncbi_mult_taxo_gbnm(417942, 'current darter').
ncbi_mult_taxo_gbnm(417945, 'goatsbeard brotula').
ncbi_mult_taxo_gbnm(417950, 'blackchin guitarfish').
ncbi_mult_taxo_gbnm(417954, 'blue ray').
ncbi_mult_taxo_gbnm(417955, 'sharpspine skate').
ncbi_mult_taxo_gbnm(417956, 'round ray').
ncbi_mult_taxo_gbnm(417957, 'Mid-Atlantic skate').
ncbi_mult_taxo_gbnm(418108, 'longfinned hagfish').
ncbi_mult_taxo_gbnm(418109, 'black hagfish').
ncbi_mult_taxo_gbnm(418111, 'Strickrott\'s hagfish').
ncbi_mult_taxo_gbnm(418130, 'clipper barb').
ncbi_mult_taxo_gbnm(418132, 'gray redhorse').
ncbi_mult_taxo_gbnm(418454, 'clearhead icefish').
ncbi_mult_taxo_gbnm(418655, 'Balkan snow vole').
ncbi_mult_taxo_gbnm(418657, 'short-haired marsupial mouse').
ncbi_mult_taxo_gbnm(418659, 'Long-nosed dasyure').
ncbi_mult_taxo_gbnm(418663, 'Black-tailed dasyure').
ncbi_mult_taxo_gbnm(418664, 'Habbema dasyure').
ncbi_mult_taxo_gbnm(419013, 'Galapagos sea lion').
ncbi_mult_taxo_gbnm(419077, 'eastern spruce gall adelgid').
ncbi_mult_taxo_gbnm(419089, 'spruce gall adelgid').
ncbi_mult_taxo_gbnm(419090, 'pine bark adelgid').
ncbi_mult_taxo_gbnm(419130, 'Malayan tiger').
ncbi_mult_taxo_gbnm(419132, 'Eastern pine processionary').
ncbi_mult_taxo_gbnm(419327, 'estuarine sea catfish').
ncbi_mult_taxo_gbnm(419329, 'big-bellied sea catfish').
ncbi_mult_taxo_gbnm(419330, 'Congo sea catfish').
ncbi_mult_taxo_gbnm(419331, 'gloomy sea catfish').
ncbi_mult_taxo_gbnm(419332, 'box sea catfish').
ncbi_mult_taxo_gbnm(419333, 'Madamango sea catfish').
ncbi_mult_taxo_gbnm(419334, 'Steindachner\'s sea catfish').
ncbi_mult_taxo_gbnm(419336, 'Besudo sea catfish').
ncbi_mult_taxo_gbnm(419338, 'Couma sea catfish').
ncbi_mult_taxo_gbnm(419339, 'brown sea catfish').
ncbi_mult_taxo_gbnm(419340, 'Pemecou sea catfish').
ncbi_mult_taxo_gbnm(419342, 'Passany sea catfish').
ncbi_mult_taxo_gbnm(419343, 'crucifix sea catfish').
ncbi_mult_taxo_gbnm(419344, 'blue sea catfish').
ncbi_mult_taxo_gbnm(419349, 'Lacandon sea catfish').
ncbi_mult_taxo_gbnm(419612, 'Wild Bactrian camel').
ncbi_mult_taxo_gbnm(419643, 'Malaysian grainy frog').
ncbi_mult_taxo_gbnm(419644, 'Sarawak grainy frog').
ncbi_mult_taxo_gbnm(419645, 'Borneo rice frog').
ncbi_mult_taxo_gbnm(419646, 'termite nest frog').
ncbi_mult_taxo_gbnm(419649, 'red mawatta frog').
ncbi_mult_taxo_gbnm(419653, 'Kerala Hills frog').
ncbi_mult_taxo_gbnm(419660, 'Borneo treefrogs').
ncbi_mult_taxo_gbnm(419661, 'Borneo treefrog').
ncbi_mult_taxo_gbnm(419663, 'balloon frogs').
ncbi_mult_taxo_gbnm(419702, 'fat fanged frog').
ncbi_mult_taxo_gbnm(419720, 'swamp metalmark').
ncbi_mult_taxo_gbnm(419956, 'cream-spotted lady beetle').
ncbi_mult_taxo_gbnm(419959, 'transverse ladybird beetle').
ncbi_mult_taxo_gbnm(420103, 'twelve-spotted ladybird beetle').
ncbi_mult_taxo_gbnm(420184, 'sooty grouse').
ncbi_mult_taxo_gbnm(420257, 'chorioptic mange mite').
ncbi_mult_taxo_gbnm(420341, 'Siberian silk moth').
ncbi_mult_taxo_gbnm(420383, 'monarch chameleon').
ncbi_mult_taxo_gbnm(420384, 'Indian chameleon').
ncbi_mult_taxo_gbnm(420385, 'Arabian chameleon').
ncbi_mult_taxo_gbnm(420386, 'Awash chameleon').
ncbi_mult_taxo_gbnm(420422, 'dwarf waterdog').
ncbi_mult_taxo_gbnm(420440, 'Kelaart\'s toad').
ncbi_mult_taxo_gbnm(420444, 'Boven Mahakkam caecilian').
ncbi_mult_taxo_gbnm(420446, 'Java tree toad').
ncbi_mult_taxo_gbnm(420448, 'Loveridge\'s snouted toad').
ncbi_mult_taxo_gbnm(420456, 'bottlenosed skate').
ncbi_mult_taxo_gbnm(420457, 'Krefft\'s ray').
ncbi_mult_taxo_gbnm(420458, 'acutenose skate').
ncbi_mult_taxo_gbnm(420459, 'Norwegian skate').
ncbi_mult_taxo_gbnm(420460, 'blue skate').
ncbi_mult_taxo_gbnm(420543, 'Crocodile tegu').
ncbi_mult_taxo_gbnm(420590, 'Japanese hemlock caterpillar').
ncbi_mult_taxo_gbnm(420609, 'crinoid clingfish').
ncbi_mult_taxo_gbnm(420844, 'Chinese bush cricket').
ncbi_mult_taxo_gbnm(420948, 'longheaded eagle ray').
ncbi_mult_taxo_gbnm(420949, 'kelp snailfish').
ncbi_mult_taxo_gbnm(421224, 'redneck pond turtle').
ncbi_mult_taxo_gbnm(421442, 'Dame\'s rocket moth').
ncbi_mult_taxo_gbnm(422567, 'cave salamander').
ncbi_mult_taxo_gbnm(423060, 'Lesser cane rat').
ncbi_mult_taxo_gbnm(423244, 'Malagasy giant mastiff bat').
ncbi_mult_taxo_gbnm(423320, 'red underwing').
ncbi_mult_taxo_gbnm(423326, 'yellowbanded underwing').
ncbi_mult_taxo_gbnm(423327, 'white underwing').
ncbi_mult_taxo_gbnm(423334, 'Brazilian luminescent click beetle').
ncbi_mult_taxo_gbnm(423481, 'cocktail wrasse').
ncbi_mult_taxo_gbnm(423510, 'Clifden nonpareil').
ncbi_mult_taxo_gbnm(423607, 'Mechow\'s mole rat').
ncbi_mult_taxo_gbnm(423608, 'Zambian mole-rat').
ncbi_mult_taxo_gbnm(424249, 'Venezuela snouted treefrog').
ncbi_mult_taxo_gbnm(424355, 'Boeseman\'s snouted treefrog').
ncbi_mult_taxo_gbnm(424356, 'Gran Rio snouted treefrog').
ncbi_mult_taxo_gbnm(425032, 'Anderson\'s Niviventer').
ncbi_mult_taxo_gbnm(425033, 'Smoke-bellied Niviventer').
ncbi_mult_taxo_gbnm(425058, 'tawny coster').
ncbi_mult_taxo_gbnm(425181, 'Caucasian squirrel').
ncbi_mult_taxo_gbnm(425201, 'Pampas fox').
ncbi_mult_taxo_gbnm(425378, 'spotstripe snapper').
ncbi_mult_taxo_gbnm(425387, 'Azores chromis').
ncbi_mult_taxo_gbnm(425389, leerfish).
ncbi_mult_taxo_gbnm(425393, 'bigscale pomfret').
ncbi_mult_taxo_gbnm(425473, 'wattle apple-gall wasp').
ncbi_mult_taxo_gbnm(425479, 'Guntea loach').
ncbi_mult_taxo_gbnm(425481, 'Burmese loach').
ncbi_mult_taxo_gbnm(425483, 'Java loach').
ncbi_mult_taxo_gbnm(425484, 'Balitora minnow').
ncbi_mult_taxo_gbnm(425486, 'highfin carpsucker').
ncbi_mult_taxo_gbnm(425492, 'stonelapping minnow').
ncbi_mult_taxo_gbnm(425506, 'arrow loach').
ncbi_mult_taxo_gbnm(425510, 'mottled loach').
ncbi_mult_taxo_gbnm(425520, 'northern wolffish').
ncbi_mult_taxo_gbnm(425631, 'Subantarctic snipe').
ncbi_mult_taxo_gbnm(425635, 'Spoon-billed sandpiper').
ncbi_mult_taxo_gbnm(425641, 'Caspian tern').
ncbi_mult_taxo_gbnm(425648, 'sooty tern').
ncbi_mult_taxo_gbnm(425683, 'ornate treefrog').
ncbi_mult_taxo_gbnm(425688, 'Caracas snouted treefrog').
ncbi_mult_taxo_gbnm(425689, 'Sipaliwini robber frog').
ncbi_mult_taxo_gbnm(425709, 'Kuban long-barbelled gudgeon').
ncbi_mult_taxo_gbnm(425934, 'Iberian wolf').
ncbi_mult_taxo_gbnm(426020, 'plain sulphur').
ncbi_mult_taxo_gbnm(426021, 'tailed sulphur').
ncbi_mult_taxo_gbnm(426022, 'spotless grass yellow').
ncbi_mult_taxo_gbnm(426092, 'fangtooth moray').
ncbi_mult_taxo_gbnm(426094, 'red gurnard').
ncbi_mult_taxo_gbnm(426098, 'grey gurnard').
ncbi_mult_taxo_gbnm(426099, 'Mediterranean bigeye rockling').
ncbi_mult_taxo_gbnm(426100, 'shore rockling').
ncbi_mult_taxo_gbnm(426380, 'Baikal black grayling').
ncbi_mult_taxo_gbnm(426482, 'Hospe mullet').
ncbi_mult_taxo_gbnm(426483, 'Parassi mullet').
ncbi_mult_taxo_gbnm(426484, 'liza mullet').
ncbi_mult_taxo_gbnm(427547, 'scale-throated earthcreeper').
ncbi_mult_taxo_gbnm(427616, 'Sunda clouded leopard').
ncbi_mult_taxo_gbnm(427695, 'dark-sided flycatcher').
ncbi_mult_taxo_gbnm(427717, 'Great Basin nightsnake').
ncbi_mult_taxo_gbnm(427719, 'California nightsnake').
ncbi_mult_taxo_gbnm(427726, 'rainforest cat-eyed snake').
ncbi_mult_taxo_gbnm(427727, 'black-banded cat-eyed snake').
ncbi_mult_taxo_gbnm(427728, 'Western cat-eyed snake').
ncbi_mult_taxo_gbnm(427729, 'Northern cat-eyed snake').
ncbi_mult_taxo_gbnm(427732, 'splendid cat-eyed snake').
ncbi_mult_taxo_gbnm(427764, 'sweet fennel').
ncbi_mult_taxo_gbnm(427924, 'quagga mussel').
ncbi_mult_taxo_gbnm(427930, 'Doi Inthanon rock frog').
ncbi_mult_taxo_gbnm(428027, 'northern spearnose poacher').
ncbi_mult_taxo_gbnm(428032, 'sailfin sculpin').
ncbi_mult_taxo_gbnm(428034, 'arrowtooth flounder').
ncbi_mult_taxo_gbnm(428036, 'snake prickleback').
ncbi_mult_taxo_gbnm(428037, 'brown cat shark').
ncbi_mult_taxo_gbnm(428196, rampion).
ncbi_mult_taxo_gbnm(428316, 'Kadamaian stream toad').
ncbi_mult_taxo_gbnm(428380, 'Mato Verde harlequin frog').
ncbi_mult_taxo_gbnm(428427, 'square-spot fairy basslet').
ncbi_mult_taxo_gbnm(428428, 'parrot seaperch').
ncbi_mult_taxo_gbnm(428429, 'deepwater cardinalfish').
ncbi_mult_taxo_gbnm(428430, 'barred grubfish').
ncbi_mult_taxo_gbnm(428431, 'Atlantic bigeye').
ncbi_mult_taxo_gbnm(428432, 'clubfoot sillago').
ncbi_mult_taxo_gbnm(428446, 'four-banded tigerfish').
ncbi_mult_taxo_gbnm(428466, 'Yunnan mustache toad').
ncbi_mult_taxo_gbnm(428845, 'black-dotted grouper').
ncbi_mult_taxo_gbnm(429326, 'Assam roofed turtle').
ncbi_mult_taxo_gbnm(429466, 'North Pacific lightfish').
ncbi_mult_taxo_gbnm(429565, 'Mount Namuli pygmy chameleon').
ncbi_mult_taxo_gbnm(429752, 'White-throated rock-thrush').
ncbi_mult_taxo_gbnm(430039, 'leatherfin lumpsucker').
ncbi_mult_taxo_gbnm(430040, 'Atlantic spiny lumpsucker').
ncbi_mult_taxo_gbnm(430081, 'royal flagfin').
ncbi_mult_taxo_gbnm(430082, 'large-scaled gurnard').
ncbi_mult_taxo_gbnm(430083, 'Portuguese sole').
ncbi_mult_taxo_gbnm(430491, 'Lesser brown horseshoe bat').
ncbi_mult_taxo_gbnm(430492, 'Trefoil horseshoe bat').
ncbi_mult_taxo_gbnm(430564, 'Korean slender bitterling').
ncbi_mult_taxo_gbnm(430607, 'amaryllis azure').
ncbi_mult_taxo_gbnm(430609, 'satin azure').
ncbi_mult_taxo_gbnm(430669, 'ambermarked birch leafminer').
ncbi_mult_taxo_gbnm(430793, 'pigmy wrinkled frog').
ncbi_mult_taxo_gbnm(430794, 'miniature nightfrog').
ncbi_mult_taxo_gbnm(430795, 'Kerala night frog').
ncbi_mult_taxo_gbnm(430899, 'lucerne weevil').
ncbi_mult_taxo_gbnm(430900, 'Wellington akodont').
ncbi_mult_taxo_gbnm(430905, 'Andean blackback coral snake').
ncbi_mult_taxo_gbnm(430910, 'Barred coral snake').
ncbi_mult_taxo_gbnm(430913, 'Tehuantepec hare').
ncbi_mult_taxo_gbnm(430998, 'whiskey fungus').
ncbi_mult_taxo_gbnm(431669, 'black-eyed leaf frog').
ncbi_mult_taxo_gbnm(431936, 'odor frog').
ncbi_mult_taxo_gbnm(431941, 'megatympanum frog').
ncbi_mult_taxo_gbnm(432095, 'Cran\'s bully').
ncbi_mult_taxo_gbnm(432164, 'bearded brotula').
ncbi_mult_taxo_gbnm(432166, 'Cadenat\'s sole').
ncbi_mult_taxo_gbnm(432167, 'bobo croaker').
ncbi_mult_taxo_gbnm(432168, 'slender rockfish').
ncbi_mult_taxo_gbnm(432356, 'Namib round-eared sengi').
ncbi_mult_taxo_gbnm(432389, 'black-lobe algae eater').
ncbi_mult_taxo_gbnm(432395, 'Kalbar rasbora').
ncbi_mult_taxo_gbnm(432397, 'harlequin rasbora').
ncbi_mult_taxo_gbnm(432398, 'Borneo algae-eater').
ncbi_mult_taxo_gbnm(432399, 'clown rasbora').
ncbi_mult_taxo_gbnm(432404, 'dwarf rasbora').
ncbi_mult_taxo_gbnm(432411, 'golden rasbora').
ncbi_mult_taxo_gbnm(432528, 'Chilean rose tarantula').
ncbi_mult_taxo_gbnm(432798, 'ocellate spot skate').
ncbi_mult_taxo_gbnm(433045, 'four-spotted sap beetle').
ncbi_mult_taxo_gbnm(433251, 'red legged ham beetle').
ncbi_mult_taxo_gbnm(433272, 'cadelle beetle').
ncbi_mult_taxo_gbnm(433352, 'diplogonadic human tapeworm').
ncbi_mult_taxo_gbnm(433358, 'Genoway\'s yellow bat').
ncbi_mult_taxo_gbnm(433365, 'Yellow-sided oppossum').
ncbi_mult_taxo_gbnm(433379, 'giant wrymouth').
ncbi_mult_taxo_gbnm(433385, 'northern pearleye').
ncbi_mult_taxo_gbnm(433386, 'roughspine sculpin').
ncbi_mult_taxo_gbnm(433387, 'shortfin eelpout').
ncbi_mult_taxo_gbnm(433388, 'northern sculpin').
ncbi_mult_taxo_gbnm(433389, 'northern rock sole').
ncbi_mult_taxo_gbnm(433390, 'red Irish lord').
ncbi_mult_taxo_gbnm(433391, 'ribbed sculpin').
ncbi_mult_taxo_gbnm(433392, 'Pacific spiny lumpsucker').
ncbi_mult_taxo_gbnm(433393, 'whitebait smelt').
ncbi_mult_taxo_gbnm(433394, 'spotfin sculpin').
ncbi_mult_taxo_gbnm(433395, 'mosshead warbonnet').
ncbi_mult_taxo_gbnm(433396, 'blackfin sculpin').
ncbi_mult_taxo_gbnm(433399, 'scalyhead sculpin').
ncbi_mult_taxo_gbnm(433401, 'slipskin snailfish').
ncbi_mult_taxo_gbnm(433402, 'showy snailfish').
ncbi_mult_taxo_gbnm(433403, 'marbled snailfish').
ncbi_mult_taxo_gbnm(433405, 'wolf-eel').
ncbi_mult_taxo_gbnm(433407, 'bigeye poacher').
ncbi_mult_taxo_gbnm(433408, 'gray starsnout').
ncbi_mult_taxo_gbnm(433409, 'blackfin poacher').
ncbi_mult_taxo_gbnm(433411, 'blackmouth eelpout').
ncbi_mult_taxo_gbnm(433595, 'white-legged snake millipede').
ncbi_mult_taxo_gbnm(433628, 'green-backed heron').
ncbi_mult_taxo_gbnm(433629, 'Indian jungle nightjar').
ncbi_mult_taxo_gbnm(433632, 'yellow-breasted bunting').
ncbi_mult_taxo_gbnm(433633, 'pintail snipe').
ncbi_mult_taxo_gbnm(433634, 'ruddy kingfisher').
ncbi_mult_taxo_gbnm(433637, 'rufous-tailed robin').
ncbi_mult_taxo_gbnm(433639, 'Pacific leaf warbler').
ncbi_mult_taxo_gbnm(433684, sansaifugu).
ncbi_mult_taxo_gbnm(433688, 'komon-damashi').
ncbi_mult_taxo_gbnm(434038, 'Amami grenadier').
ncbi_mult_taxo_gbnm(434238, terebinth).
ncbi_mult_taxo_gbnm(434416, 'tailed copper').
ncbi_mult_taxo_gbnm(434417, 'lustrous copper').
ncbi_mult_taxo_gbnm(434419, 'great gray copper').
ncbi_mult_taxo_gbnm(435004, 'smooth-headed catfish').
ncbi_mult_taxo_gbnm(435128, 'giant seacatfish').
ncbi_mult_taxo_gbnm(435130, 'mud-bank filefish').
ncbi_mult_taxo_gbnm(435131, 'Sumatran silverside').
ncbi_mult_taxo_gbnm(435132, 'twobelt cardinal').
ncbi_mult_taxo_gbnm(435138, 'oriental sole').
ncbi_mult_taxo_gbnm(435143, 'cheeklined wrasse').
ncbi_mult_taxo_gbnm(435144, 'whitefin wolf-herring').
ncbi_mult_taxo_gbnm(435146, 'sharp-nosed sand goby').
ncbi_mult_taxo_gbnm(435148, 'speckled tonguesole').
ncbi_mult_taxo_gbnm(435149, 'rainbow sardine').
ncbi_mult_taxo_gbnm(435151, 'half-smooth golden pufferfish').
ncbi_mult_taxo_gbnm(435152, 'saddleback silver-biddy').
ncbi_mult_taxo_gbnm(435153, 'slender silverbiddy').
ncbi_mult_taxo_gbnm(435155, 'Bombay duck fish').
ncbi_mult_taxo_gbnm(435156, 'Dussumier\'s halfbeak').
ncbi_mult_taxo_gbnm(435159, 'shortnose ponyfish').
ncbi_mult_taxo_gbnm(435161, 'Savalani hairtail').
ncbi_mult_taxo_gbnm(435217, 'whitesaddle goatfish').
ncbi_mult_taxo_gbnm(435218, 'blackspot threadfin').
ncbi_mult_taxo_gbnm(435220, 'Mauritian sardinella').
ncbi_mult_taxo_gbnm(435221, 'Bleeker\'s blacktip sardinella').
ncbi_mult_taxo_gbnm(435224, 'trumpeter sillago').
ncbi_mult_taxo_gbnm(435225, 'northern whiting').
ncbi_mult_taxo_gbnm(435227, 'spiny flathead').
ncbi_mult_taxo_gbnm(435229, 'Hamilton\'s thryssa').
ncbi_mult_taxo_gbnm(435230, 'Kammal thryssa').
ncbi_mult_taxo_gbnm(435231, 'longjaw thryssa').
ncbi_mult_taxo_gbnm(435234, 'goatee croaker').
ncbi_mult_taxo_gbnm(435235, 'Bensasi goatfish').
ncbi_mult_taxo_gbnm(435238, 'sulphur goatfish').
ncbi_mult_taxo_gbnm(435255, 'Southern spiny pocket mouse').
ncbi_mult_taxo_gbnm(435256, 'Nelson\'s spiny pocket mouse').
ncbi_mult_taxo_gbnm(435268, 'duskyfin glassy perchlet').
ncbi_mult_taxo_gbnm(435272, 'black pomfret').
ncbi_mult_taxo_gbnm(435273, 'jenny mojarra').
ncbi_mult_taxo_gbnm(435274, 'yellow fin mojarra').
ncbi_mult_taxo_gbnm(435339, 'Tuamotu reed-warbler').
ncbi_mult_taxo_gbnm(435406, 'Hoffmann\'s Sulawesi rat').
ncbi_mult_taxo_gbnm(435638, 'Greater flamingo').
ncbi_mult_taxo_gbnm(435916, 'greenband wrasse').
ncbi_mult_taxo_gbnm(435917, 'Mardi Gras wrasse').
ncbi_mult_taxo_gbnm(435999, 'snubnose pompano').
ncbi_mult_taxo_gbnm(436002, 'razorbelly scad').
ncbi_mult_taxo_gbnm(436112, 'cabbage leaf miner').
ncbi_mult_taxo_gbnm(436157, 'unisexual mole salamanders').
ncbi_mult_taxo_gbnm(436393, 'smaller green leafhopper').
ncbi_mult_taxo_gbnm(436519, 'soybean thrips').
ncbi_mult_taxo_gbnm(436882, loosejaw).
ncbi_mult_taxo_gbnm(436885, 'short fin pearleye').
ncbi_mult_taxo_gbnm(436903, 'Wroughton\'s giant mastiff bat').
ncbi_mult_taxo_gbnm(437330, 'Yoma danio').
ncbi_mult_taxo_gbnm(437484, 'redbanded stink bug').
ncbi_mult_taxo_gbnm(437485, 'western bean cutworm').
ncbi_mult_taxo_gbnm(437488, 'rice leaffolder').
ncbi_mult_taxo_gbnm(437490, 'western bean cutworm').
ncbi_mult_taxo_gbnm(437493, 'neotropical brown stinkbug').
ncbi_mult_taxo_gbnm(437758, 'dwarf gudgeon').
ncbi_mult_taxo_gbnm(438425, 'sessile marshweed').
ncbi_mult_taxo_gbnm(438766, 'Western long-fingered bat').
ncbi_mult_taxo_gbnm(439323, 'Angolan giraffe').
ncbi_mult_taxo_gbnm(439324, 'Kordofan giraffe').
ncbi_mult_taxo_gbnm(439326, 'West African giraffe').
ncbi_mult_taxo_gbnm(439358, 'bean blossom thrips').
ncbi_mult_taxo_gbnm(439390, 'helmeted gecko').
ncbi_mult_taxo_gbnm(439391, 'Western stone gecko').
ncbi_mult_taxo_gbnm(439394, 'fine-faced gecko').
ncbi_mult_taxo_gbnm(439396, 'northern mauxia shrimp').
ncbi_mult_taxo_gbnm(439432, 'California toad').
ncbi_mult_taxo_gbnm(439461, 'Indian spotted chevrotain').
ncbi_mult_taxo_gbnm(439565, 'Brussels lace').
ncbi_mult_taxo_gbnm(439567, 'pale oak beauty').
ncbi_mult_taxo_gbnm(439696, 'hackberry emperor').
ncbi_mult_taxo_gbnm(439704, 'South Island takahe').
ncbi_mult_taxo_gbnm(439891, 'variegated spinefoot').
ncbi_mult_taxo_gbnm(439892, 'shoemaker spinefoot').
ncbi_mult_taxo_gbnm(439935, 'black-striped burrowing snake').
ncbi_mult_taxo_gbnm(440516, 'Greater snow goose').
ncbi_mult_taxo_gbnm(440631, 'Australian spider beetle').
ncbi_mult_taxo_gbnm(440689, 'clocker weevil').
ncbi_mult_taxo_gbnm(441319, 'yellow migrant').
ncbi_mult_taxo_gbnm(441320, 'common gull').
ncbi_mult_taxo_gbnm(441323, 'small grass yellow').
ncbi_mult_taxo_gbnm(441364, 'African long-fingered bat').
ncbi_mult_taxo_gbnm(441365, 'lappetlip clingfish').
ncbi_mult_taxo_gbnm(441366, 'blunt-snouted clingfish').
ncbi_mult_taxo_gbnm(441555, 'Mahe caecilian').
ncbi_mult_taxo_gbnm(441559, 'Kirk\'s caecilian').
ncbi_mult_taxo_gbnm(441641, 'fire-fronted bishop').
ncbi_mult_taxo_gbnm(441663, 'yellowjacket cichlid').
ncbi_mult_taxo_gbnm(441671, 'black bishop').
ncbi_mult_taxo_gbnm(441672, 'orange bishop').
ncbi_mult_taxo_gbnm(441673, 'Zanzibar bishop').
ncbi_mult_taxo_gbnm(441674, 'golden-backed bishop').
ncbi_mult_taxo_gbnm(441675, 'yellow bishop').
ncbi_mult_taxo_gbnm(441676, 'fan-tailed widowbird').
ncbi_mult_taxo_gbnm(441677, 'yellow-shouldered widowbird').
ncbi_mult_taxo_gbnm(441678, 'white-winged widowbird').
ncbi_mult_taxo_gbnm(441679, 'marsh windowbird').
ncbi_mult_taxo_gbnm(441680, 'buff-shouldered widowbird').
ncbi_mult_taxo_gbnm(441681, 'Jackson\'s widowbird').
ncbi_mult_taxo_gbnm(441683, 'Madagascar red fody').
ncbi_mult_taxo_gbnm(441686, 'Mauritius fody').
ncbi_mult_taxo_gbnm(441687, 'Seychelles fody').
ncbi_mult_taxo_gbnm(441712, 'Northern masked-weaver').
ncbi_mult_taxo_gbnm(441723, 'black-headed weaver').
ncbi_mult_taxo_gbnm(441739, 'Bar-winged weaver').
ncbi_mult_taxo_gbnm(441740, 'Sao Tome weaver').
ncbi_mult_taxo_gbnm(441897, 'red-mouthed goby').
ncbi_mult_taxo_gbnm(441899, 'transparent goby').
ncbi_mult_taxo_gbnm(441901, 'De Buen\'s goby').
ncbi_mult_taxo_gbnm(441903, 'crystal goby').
ncbi_mult_taxo_gbnm(441905, 'Fries\'s goby').
ncbi_mult_taxo_gbnm(441906, 'Lesuer\'s goby').
ncbi_mult_taxo_gbnm(441908, 'Ferrer\'s goby').
ncbi_mult_taxo_gbnm(441912, 'Abbott\'s sawfly').
ncbi_mult_taxo_gbnm(441918, 'blackheaded pine sawfly').
ncbi_mult_taxo_gbnm(441920, 'Hetrick\'s sawfly').
ncbi_mult_taxo_gbnm(441921, 'redheaded pine sawfly').
ncbi_mult_taxo_gbnm(441923, 'slash pine sawfly').
ncbi_mult_taxo_gbnm(441926, 'red pine sawfly').
ncbi_mult_taxo_gbnm(441929, 'white pine sawfly').
ncbi_mult_taxo_gbnm(441931, 'sand pine sawfly').
ncbi_mult_taxo_gbnm(441937, 'European pine sawfly').
ncbi_mult_taxo_gbnm(441941, 'loblolly pine sawfly').
ncbi_mult_taxo_gbnm(441951, 'Rio de la Plata onesided livebearer').
ncbi_mult_taxo_gbnm(441988, 'tiger palmfly').
ncbi_mult_taxo_gbnm(441995, 'dark-brand bushbrown').
ncbi_mult_taxo_gbnm(441997, 'white owl').
ncbi_mult_taxo_gbnm(442005, 'great satyr').
ncbi_mult_taxo_gbnm(442169, 'European argentine').
ncbi_mult_taxo_gbnm(442566, 'Lesser Chiruromys').
ncbi_mult_taxo_gbnm(442568, 'Ruemmler\'s Coccymys').
ncbi_mult_taxo_gbnm(442570, 'Earless New Guinea water rat').
ncbi_mult_taxo_gbnm(442572, 'Elegant Leptomys').
ncbi_mult_taxo_gbnm(442576, 'Long-footed tree mouse').
ncbi_mult_taxo_gbnm(442578, 'Greater Macruromys').
ncbi_mult_taxo_gbnm(442581, 'Rothschild\'s Mallomys').
ncbi_mult_taxo_gbnm(442583, 'Highland Mammelomys').
ncbi_mult_taxo_gbnm(442584, 'Lowland Mammelomys').
ncbi_mult_taxo_gbnm(442585, 'Cape York Melomys').
ncbi_mult_taxo_gbnm(442586, 'Bramble Cay Melomys').
ncbi_mult_taxo_gbnm(442587, 'Black-tailed Melomys').
ncbi_mult_taxo_gbnm(442588, 'Northern hopping mouse').
ncbi_mult_taxo_gbnm(442589, 'Fawn hopping mouse').
ncbi_mult_taxo_gbnm(442590, 'Mitchell\'s hopping mouse').
ncbi_mult_taxo_gbnm(442592, 'New Guinea waterside rat').
ncbi_mult_taxo_gbnm(442594, 'Papuan lowland Paramelomys').
ncbi_mult_taxo_gbnm(442595, 'Common lowland Paramelomys').
ncbi_mult_taxo_gbnm(442596, 'Mountain Paramelomys').
ncbi_mult_taxo_gbnm(442598, 'Shaw Mayer\'s Pogonomelomys').
ncbi_mult_taxo_gbnm(442600, 'Chestnut Pogonomys').
ncbi_mult_taxo_gbnm(442602, 'Shaw Mayer\'s shrew mouse').
ncbi_mult_taxo_gbnm(442603, 'Ash-gray Pseudomys').
ncbi_mult_taxo_gbnm(442604, 'Silky Pseudomys').
ncbi_mult_taxo_gbnm(442605, 'Bolam\'s Pseudomys').
ncbi_mult_taxo_gbnm(442606, 'Kakadu pebble-mound Pseudomys').
ncbi_mult_taxo_gbnm(442607, 'Delicate Pseudomys').
ncbi_mult_taxo_gbnm(442608, 'Shark Bay Pseudomys').
ncbi_mult_taxo_gbnm(442609, 'Smoky Pseudomys').
ncbi_mult_taxo_gbnm(442610, 'Eastern chestnut Pseudomys').
ncbi_mult_taxo_gbnm(442611, 'Long-tailed Pseudomys').
ncbi_mult_taxo_gbnm(442612, 'Central pebble-mound Pseudomys').
ncbi_mult_taxo_gbnm(442613, 'Kimberley Pseudomys').
ncbi_mult_taxo_gbnm(442614, 'New Holland Pseudomys').
ncbi_mult_taxo_gbnm(442615, 'Western Pseudomys').
ncbi_mult_taxo_gbnm(442616, 'Hastings river Pseudomys').
ncbi_mult_taxo_gbnm(442617, 'Eastern pebble-mound Pseudomys').
ncbi_mult_taxo_gbnm(442619, 'Heath Pseudomys').
ncbi_mult_taxo_gbnm(442621, 'Bougainville Island Solomys').
ncbi_mult_taxo_gbnm(442622, 'Black-tailed Uromys').
ncbi_mult_taxo_gbnm(442623, 'Arnhem land rock rat').
ncbi_mult_taxo_gbnm(442625, 'Central Australian rock rat').
ncbi_mult_taxo_gbnm(442626, 'Kimberley rock rat').
ncbi_mult_taxo_gbnm(442639, 'Volga undermouth').
ncbi_mult_taxo_gbnm(442640, 'Kura nase').
ncbi_mult_taxo_gbnm(442641, 'Colchic nase').
ncbi_mult_taxo_gbnm(442642, 'Kuban\'s nase').
ncbi_mult_taxo_gbnm(442659, 'Golden-backed Mesembriomys').
ncbi_mult_taxo_gbnm(442846, 'Borneo fruit bat').
ncbi_mult_taxo_gbnm(442964, 'Red-necked pademelon').
ncbi_mult_taxo_gbnm(443191, 'rhomboid pacu').
ncbi_mult_taxo_gbnm(443256, 'Eurasian wolf').
ncbi_mult_taxo_gbnm(443381, 'American blue vervain').
ncbi_mult_taxo_gbnm(443629, 'bicolor slickhead').
ncbi_mult_taxo_gbnm(443631, 'fangtooth smooth-head').
ncbi_mult_taxo_gbnm(443633, 'smallscale smooth-head').
ncbi_mult_taxo_gbnm(443636, 'Agassiz\' smooth-head').
ncbi_mult_taxo_gbnm(443640, 'Maul\'s searsid').
ncbi_mult_taxo_gbnm(443646, 'multipore searsid').
ncbi_mult_taxo_gbnm(443656, 'black blister beetle').
ncbi_mult_taxo_gbnm(443660, 'oil beetle').
ncbi_mult_taxo_gbnm(443676, 'rusty jobfish').
ncbi_mult_taxo_gbnm(443677, 'lesser salmon catfish').
ncbi_mult_taxo_gbnm(443678, 'shovel-nosed catfish').
ncbi_mult_taxo_gbnm(443679, 'Western Australian salmon').
ncbi_mult_taxo_gbnm(443680, 'red tailed tinfoil').
ncbi_mult_taxo_gbnm(443682, 'red pigfish').
ncbi_mult_taxo_gbnm(443684, 'bluespotted trevally').
ncbi_mult_taxo_gbnm(443685, 'smooth dreamer').
ncbi_mult_taxo_gbnm(443687, 'purple tuskfish').
ncbi_mult_taxo_gbnm(443688, 'baldchin grouper').
ncbi_mult_taxo_gbnm(443689, 'Venus tuskfish').
ncbi_mult_taxo_gbnm(443690, 'conger eel').
ncbi_mult_taxo_gbnm(443691, 'Cape conger').
ncbi_mult_taxo_gbnm(443692, redbait).
ncbi_mult_taxo_gbnm(443693, 'ruby snapper').
ncbi_mult_taxo_gbnm(443694, 'rock ling').
ncbi_mult_taxo_gbnm(443695, 'golden tank goby').
ncbi_mult_taxo_gbnm(443696, 'collared large-eye bream').
ncbi_mult_taxo_gbnm(443700, 'tropical halfbeak').
ncbi_mult_taxo_gbnm(443702, 'sky emperor').
ncbi_mult_taxo_gbnm(443703, 'yellowstreaked snapper').
ncbi_mult_taxo_gbnm(443704, 'peacock eel').
ncbi_mult_taxo_gbnm(443706, 'fork-tail threadfin bream').
ncbi_mult_taxo_gbnm(443707, 'ornate threadfin bream').
ncbi_mult_taxo_gbnm(443708, 'notchedfin threadfin bream').
ncbi_mult_taxo_gbnm(443710, 'New Zealand blue cod').
ncbi_mult_taxo_gbnm(443711, 'purple-spotted bigeye').
ncbi_mult_taxo_gbnm(443712, 'lavender jobfish').
ncbi_mult_taxo_gbnm(443713, 'Andriashev\'s lanternfish').
ncbi_mult_taxo_gbnm(443715, 'skipjack trevally').
ncbi_mult_taxo_gbnm(443717, 'monogrammed monocle bream').
ncbi_mult_taxo_gbnm(443718, 'lattice monocle bream').
ncbi_mult_taxo_gbnm(443719, 'Samson fish').
ncbi_mult_taxo_gbnm(443721, 'western school sillago').
ncbi_mult_taxo_gbnm(443722, 'sand whiting').
ncbi_mult_taxo_gbnm(443723, 'Flinders\' sillago').
ncbi_mult_taxo_gbnm(443724, 'bay sillago').
ncbi_mult_taxo_gbnm(443725, 'stout stillago').
ncbi_mult_taxo_gbnm(443726, 'sawtooth barracuda').
ncbi_mult_taxo_gbnm(443727, 'night smelt').
ncbi_mult_taxo_gbnm(443728, 'sickle pomfret').
ncbi_mult_taxo_gbnm(443729, 'oyster pompano').
ncbi_mult_taxo_gbnm(443730, 'smallspotted dart').
ncbi_mult_taxo_gbnm(443731, 'swallowtail dart').
ncbi_mult_taxo_gbnm(443748, 'yellow-eye mullet').
ncbi_mult_taxo_gbnm(443750, 'longsnout flounder').
ncbi_mult_taxo_gbnm(443752, 'Bidyan perch').
ncbi_mult_taxo_gbnm(443755, 'violet cuskeel').
ncbi_mult_taxo_gbnm(443756, 'graceful shark').
ncbi_mult_taxo_gbnm(443757, 'nervous shark').
ncbi_mult_taxo_gbnm(443758, 'creek whaler').
ncbi_mult_taxo_gbnm(443759, 'hardnose shark').
ncbi_mult_taxo_gbnm(443760, 'Hasselt\'s bambooshark').
ncbi_mult_taxo_gbnm(443761, 'slender bamboo shark').
ncbi_mult_taxo_gbnm(443763, 'roughnose stingray').
ncbi_mult_taxo_gbnm(443764, 'Australian sharpnose shark').
ncbi_mult_taxo_gbnm(443765, 'common stingaree').
ncbi_mult_taxo_gbnm(443766, 'sandyback stingaree').
ncbi_mult_taxo_gbnm(443767, 'wide stingaree').
ncbi_mult_taxo_gbnm(443768, 'patchwork stingaree').
ncbi_mult_taxo_gbnm(443770, 'yellowback stingaree').
ncbi_mult_taxo_gbnm(443771, 'greenback stingaree').
ncbi_mult_taxo_gbnm(443776, 'estuary catfish').
ncbi_mult_taxo_gbnm(443778, 'basketwork eel').
ncbi_mult_taxo_gbnm(443779, 'pearl perches').
ncbi_mult_taxo_gbnm(443781, 'deepsea jewfish').
ncbi_mult_taxo_gbnm(443782, 'Westralian jewfish').
ncbi_mult_taxo_gbnm(443783, 'threadfin pearl-perch').
ncbi_mult_taxo_gbnm(443784, 'pearl perch').
ncbi_mult_taxo_gbnm(443788, 'western sooty grunter').
ncbi_mult_taxo_gbnm(443790, 'giant cod').
ncbi_mult_taxo_gbnm(443792, 'rock cod').
ncbi_mult_taxo_gbnm(443800, 'sandpaper fish').
ncbi_mult_taxo_gbnm(443806, 'red codling').
ncbi_mult_taxo_gbnm(443808, 'prickley pomfret').
ncbi_mult_taxo_gbnm(443810, 'greenback flounder').
ncbi_mult_taxo_gbnm(443911, 'Papua New Guinea rat').
ncbi_mult_taxo_gbnm(444095, 'Smith\'s zokor').
ncbi_mult_taxo_gbnm(444102, 'divaricate short razor').
ncbi_mult_taxo_gbnm(444140, 'zebra dove').
ncbi_mult_taxo_gbnm(444154, 'amethyst brown-dove').
ncbi_mult_taxo_gbnm(444604, 'Berlin poplar').
ncbi_mult_taxo_gbnm(445150, 'Guyana humming frog').
ncbi_mult_taxo_gbnm(445151, 'Hudson\'s humming frog').
ncbi_mult_taxo_gbnm(445153, 'sheep frog').
ncbi_mult_taxo_gbnm(445358, 'Japanese threadfin bream').
ncbi_mult_taxo_gbnm(445359, 'mauvelip threadfin bream').
ncbi_mult_taxo_gbnm(445360, 'Indian pellona').
ncbi_mult_taxo_gbnm(445361, 'greater lizardfish').
ncbi_mult_taxo_gbnm(445362, 'pickhandle barracuda').
ncbi_mult_taxo_gbnm(445363, 'Toli shad').
ncbi_mult_taxo_gbnm(445365, 'sevenfinger threadfin').
ncbi_mult_taxo_gbnm(445388, 'false trevally').
ncbi_mult_taxo_gbnm(445390, 'Indian threadfin').
ncbi_mult_taxo_gbnm(445392, 'soldier catfish').
ncbi_mult_taxo_gbnm(445506, 'bumblebee mouthbrooder').
ncbi_mult_taxo_gbnm(445509, 'elongate mbuna').
ncbi_mult_taxo_gbnm(445558, 'giant haplochromis').
ncbi_mult_taxo_gbnm(445562, 'pointedbelly frog').
ncbi_mult_taxo_gbnm(445566, 'Wagner\'s white-lipped frog').
ncbi_mult_taxo_gbnm(445569, 'stick mantis').
ncbi_mult_taxo_gbnm(445771, 'Sichuan lazy toad').
ncbi_mult_taxo_gbnm(445772, 'Jingdong lazy toad').
ncbi_mult_taxo_gbnm(445773, 'Liangbei toothed toad').
ncbi_mult_taxo_gbnm(445774, 'common lazy toad').
ncbi_mult_taxo_gbnm(445775, 'dotted lazy toad').
ncbi_mult_taxo_gbnm(445776, 'Nanjiang toothed toad').
ncbi_mult_taxo_gbnm(445777, 'Omei lazy toad').
ncbi_mult_taxo_gbnm(445778, 'Chinese lazy toad').
ncbi_mult_taxo_gbnm(445779, 'warty toothed toad').
ncbi_mult_taxo_gbnm(445780, 'webless toothed toad').
ncbi_mult_taxo_gbnm(445782, 'Xiangcheng lazy toad').
ncbi_mult_taxo_gbnm(445783, 'chest gland cat-eyed toad').
ncbi_mult_taxo_gbnm(445784, 'chest spiny cat-eyed toad').
ncbi_mult_taxo_gbnm(445785, 'Muli cat-eyed toad').
ncbi_mult_taxo_gbnm(445786, 'round-tubercled cat-eyed toad').
ncbi_mult_taxo_gbnm(445787, 'Leishan spiny toad').
ncbi_mult_taxo_gbnm(445991, 'green panchax').
ncbi_mult_taxo_gbnm(445992, 'dwarf panchax').
ncbi_mult_taxo_gbnm(446084, 'chestnut phylloxera').
ncbi_mult_taxo_gbnm(446150, 'greater musk-mallow').
ncbi_mult_taxo_gbnm(446353, 'short-faced mole').
ncbi_mult_taxo_gbnm(446415, 'greater argentine').
ncbi_mult_taxo_gbnm(446418, 'Edea killifish').
ncbi_mult_taxo_gbnm(446420, 'goby killifish').
ncbi_mult_taxo_gbnm(446421, 'Heinemann\'s killifish').
ncbi_mult_taxo_gbnm(446439, 'western minnow').
ncbi_mult_taxo_gbnm(446489, 'Flinders Range froglet').
ncbi_mult_taxo_gbnm(446502, 'Nga lampeye').
ncbi_mult_taxo_gbnm(446505, 'common green colonel fly').
ncbi_mult_taxo_gbnm(446524, 'Antilles pinktoe tarantula').
ncbi_mult_taxo_gbnm(446789, 'sea tadpole').
ncbi_mult_taxo_gbnm(446791, 'inquiline snailfish').
ncbi_mult_taxo_gbnm(446792, 'striped seasnail').
ncbi_mult_taxo_gbnm(446793, 'Montagu\'s sea snail').
ncbi_mult_taxo_gbnm(446806, 'gulf damselfish').
ncbi_mult_taxo_gbnm(446808, 'So-iuy mullet').
ncbi_mult_taxo_gbnm(446810, 'blotched snailfish').
ncbi_mult_taxo_gbnm(446812, 'blackbelly snailfish').
ncbi_mult_taxo_gbnm(446815, 'tadpole snailfish').
ncbi_mult_taxo_gbnm(446822, 'black seasnail').
ncbi_mult_taxo_gbnm(446823, 'blacksnout seasnail').
ncbi_mult_taxo_gbnm(446824, 'pouty seasnail').
ncbi_mult_taxo_gbnm(446827, 'Greenland dwarf snailfish').
ncbi_mult_taxo_gbnm(446829, 'multipore dwarf snailfish').
ncbi_mult_taxo_gbnm(446835, 'threadfin seasnail').
ncbi_mult_taxo_gbnm(446837, 'longnose snailfish').
ncbi_mult_taxo_gbnm(446905, 'Coastal tomb bat').
ncbi_mult_taxo_gbnm(446906, 'Hill\'s tomb bat').
ncbi_mult_taxo_gbnm(446907, 'Beccari\'s sheath-tailed bat').
ncbi_mult_taxo_gbnm(446908, 'Raffray\'s sheath-tailed bat').
ncbi_mult_taxo_gbnm(446910, 'Yellow-bellied pouched bat').
ncbi_mult_taxo_gbnm(446950, 'sandhill frog').
ncbi_mult_taxo_gbnm(447135, 'Bank vole').
ncbi_mult_taxo_gbnm(447136, 'African clouded yellow').
ncbi_mult_taxo_gbnm(447167, 'dawn clouded yellow').
ncbi_mult_taxo_gbnm(447279, 'banded treebrown').
ncbi_mult_taxo_gbnm(447280, 'bamboo treebrown').
ncbi_mult_taxo_gbnm(447281, 'bamboo forester').
ncbi_mult_taxo_gbnm(447333, 'Madagascar giant day gecko').
ncbi_mult_taxo_gbnm(447619, 'Mexican bean beetle').
ncbi_mult_taxo_gbnm(447821, 'brindled darter').
ncbi_mult_taxo_gbnm(447822, 'bankhead darter').
ncbi_mult_taxo_gbnm(447823, 'muscadine darter').
ncbi_mult_taxo_gbnm(447833, 'Scotch argus').
ncbi_mult_taxo_gbnm(447842, 'northwest alpine').
ncbi_mult_taxo_gbnm(447844, 'Colorado alpine').
ncbi_mult_taxo_gbnm(447846, 'Theano alpine').
ncbi_mult_taxo_gbnm(447850, 'woodland ringlet').
ncbi_mult_taxo_gbnm(447920, 'Eastern mountain greenbul').
ncbi_mult_taxo_gbnm(447925, 'lesser bristlebill').
ncbi_mult_taxo_gbnm(447927, 'Cabani\'s greenbul').
ncbi_mult_taxo_gbnm(447930, 'Fischer\'s greenbul').
ncbi_mult_taxo_gbnm(448029, mulloway).
ncbi_mult_taxo_gbnm(448039, 'redhead goby').
ncbi_mult_taxo_gbnm(448077, 'Big-eared flying fox').
ncbi_mult_taxo_gbnm(448084, 'Hammer-headed fruit bat').
ncbi_mult_taxo_gbnm(448113, 'Dawei frog').
ncbi_mult_taxo_gbnm(448114, 'concave-eared torrent frog').
ncbi_mult_taxo_gbnm(448381, 'chevron skink').
ncbi_mult_taxo_gbnm(448382, 'striped skink').
ncbi_mult_taxo_gbnm(448417, 'El Yunque robber frog').
ncbi_mult_taxo_gbnm(448419, 'Cuban dwarf robber frog').
ncbi_mult_taxo_gbnm(448421, 'Lynn\'s robber frog').
ncbi_mult_taxo_gbnm(448422, 'Haitian robber frog').
ncbi_mult_taxo_gbnm(448423, 'Andrew\'s robber frog').
ncbi_mult_taxo_gbnm(448424, 'Apostates robber frog').
ncbi_mult_taxo_gbnm(448425, 'Armstrong\'s robber frog').
ncbi_mult_taxo_gbnm(448426, 'Atkin\'s robber frog').
ncbi_mult_taxo_gbnm(448428, 'Rio Yumuri robber frog').
ncbi_mult_taxo_gbnm(448429, 'shortsnout robber frog').
ncbi_mult_taxo_gbnm(448430, 'Caribbean robber frog').
ncbi_mult_taxo_gbnm(448432, 'Portland Cave robber frog').
ncbi_mult_taxo_gbnm(448433, 'Counou robber frog').
ncbi_mult_taxo_gbnm(448434, 'Cuban robber frog').
ncbi_mult_taxo_gbnm(448435, 'Cundall\'s robber frog').
ncbi_mult_taxo_gbnm(448437, 'Darlington\'s robber frog').
ncbi_mult_taxo_gbnm(448438, 'miniature robber frog').
ncbi_mult_taxo_gbnm(448439, 'Hedges\' robber frog').
ncbi_mult_taxo_gbnm(448440, 'Emilia\'s robber frog').
ncbi_mult_taxo_gbnm(448441, 'Etheridge\'s robber frog').
ncbi_mult_taxo_gbnm(448442, 'furcy robber frog').
ncbi_mult_taxo_gbnm(448443, 'brown robber frog').
ncbi_mult_taxo_gbnm(448444, 'Doris\' robber frog').
ncbi_mult_taxo_gbnm(448445, 'La Visite robber frog').
ncbi_mult_taxo_gbnm(448446, 'Southwest Haiti robber frog').
ncbi_mult_taxo_gbnm(448447, 'Portland Parish robber frog').
ncbi_mult_taxo_gbnm(448449, 'Spaldings robber frog').
ncbi_mult_taxo_gbnm(448450, 'Clarendon Parish robber frog').
ncbi_mult_taxo_gbnm(448451, 'Graham\'s robber frog').
ncbi_mult_taxo_gbnm(448452, 'Grey\'s robber frog').
ncbi_mult_taxo_gbnm(448453, 'Trelawny Parish robber frog').
ncbi_mult_taxo_gbnm(448454, 'Guanahacabibes robber frog').
ncbi_mult_taxo_gbnm(448455, 'Gundlach\'s robber frog').
ncbi_mult_taxo_gbnm(448456, 'Shreve\'s robber frog').
ncbi_mult_taxo_gbnm(448458, 'Pico Turquino robber frog').
ncbi_mult_taxo_gbnm(448459, 'Jamaica robber frog').
ncbi_mult_taxo_gbnm(448461, 'Mable\'s robber frog').
ncbi_mult_taxo_gbnm(448464, 'Klinikowski\'s robber frog').
ncbi_mult_taxo_gbnm(448465, 'Virgin Islands robber frog').
ncbi_mult_taxo_gbnm(448467, 'Habana robber frog').
ncbi_mult_taxo_gbnm(448469, 'light robber frog').
ncbi_mult_taxo_gbnm(448471, 'tiny robber frog').
ncbi_mult_taxo_gbnm(448472, 'Isla Mona robber frog').
ncbi_mult_taxo_gbnm(448473, 'Portland robber frog').
ncbi_mult_taxo_gbnm(448474, 'Arntully robber frog').
ncbi_mult_taxo_gbnm(448476, 'rednose robber frog').
ncbi_mult_taxo_gbnm(448477, 'Independencia robber frog').
ncbi_mult_taxo_gbnm(448478, 'Paulson\'s robber frog').
ncbi_mult_taxo_gbnm(448480, 'Miranda robber frog').
ncbi_mult_taxo_gbnm(448481, 'painted robber frog').
ncbi_mult_taxo_gbnm(448482, 'Isla de Pinos robber frog').
ncbi_mult_taxo_gbnm(448483, 'Yuma robber frog').
ncbi_mult_taxo_gbnm(448484, 'Rhodes\' robber frog').
ncbi_mult_taxo_gbnm(448485, 'Richmond\'s robber frog').
ncbi_mult_taxo_gbnm(448486, 'Ricordi\'s robber frog').
ncbi_mult_taxo_gbnm(448489, 'red-legged robber frog').
ncbi_mult_taxo_gbnm(448490, 'Schmidt\'s robber frog').
ncbi_mult_taxo_gbnm(448491, 'Sud robber frog').
ncbi_mult_taxo_gbnm(448494, 'Quick Step robber frog').
ncbi_mult_taxo_gbnm(448495, 'Symington\'s robber frog').
ncbi_mult_taxo_gbnm(448497, 'Thomas\' robber frog').
ncbi_mult_taxo_gbnm(448498, 'Morne Macay robber frog').
ncbi_mult_taxo_gbnm(448499, 'Yarey robber frog').
ncbi_mult_taxo_gbnm(448501, 'Turquino robber frog').
ncbi_mult_taxo_gbnm(448502, 'dull robber frog').
ncbi_mult_taxo_gbnm(448503, 'Varley\'s robber frog').
ncbi_mult_taxo_gbnm(448504, 'La Hotte robber frog').
ncbi_mult_taxo_gbnm(448506, 'Weinland\'s robber frog').
ncbi_mult_taxo_gbnm(448507, 'Zeus\' robber frog').
ncbi_mult_taxo_gbnm(448508, 'Zug\'s robber frog').
ncbi_mult_taxo_gbnm(448516, 'Ayacucho Andes frog').
ncbi_mult_taxo_gbnm(448520, 'Papallacta robber frog').
ncbi_mult_taxo_gbnm(448521, 'Cachabi robber frog').
ncbi_mult_taxo_gbnm(448523, 'lesser Pilalo robber frog').
ncbi_mult_taxo_gbnm(448539, 'Pacific robber frog').
ncbi_mult_taxo_gbnm(448562, 'Tamaulipan arboreal robber frog').
ncbi_mult_taxo_gbnm(448572, 'Rio robber frog').
ncbi_mult_taxo_gbnm(448574, 'Merida robber frog').
ncbi_mult_taxo_gbnm(448577, 'Buckley\'s robber frog').
ncbi_mult_taxo_gbnm(448581, 'Cajamarca robber frog').
ncbi_mult_taxo_gbnm(448583, 'San Antonio robber frog').
ncbi_mult_taxo_gbnm(448587, 'La Palma robber frog').
ncbi_mult_taxo_gbnm(448591, 'La Delicia robber frog').
ncbi_mult_taxo_gbnm(448594, 'Wild\'s robber frog').
ncbi_mult_taxo_gbnm(448595, 'valley robber frog').
ncbi_mult_taxo_gbnm(448597, 'Brownberg robber frog').
ncbi_mult_taxo_gbnm(448599, 'throated robber frog').
ncbi_mult_taxo_gbnm(448604, 'Condor robber frog').
ncbi_mult_taxo_gbnm(448605, 'chirping robber frog').
ncbi_mult_taxo_gbnm(448612, 'Rio Reventador robber frog').
ncbi_mult_taxo_gbnm(448613, 'spring robber frog').
ncbi_mult_taxo_gbnm(448617, 'La Paz robber frog').
ncbi_mult_taxo_gbnm(448618, 'San Vicente robber frog').
ncbi_mult_taxo_gbnm(448622, 'Cuzco robber frog').
ncbi_mult_taxo_gbnm(448629, 'Caretta robber frog').
ncbi_mult_taxo_gbnm(448631, 'Tucuman robber frog').
ncbi_mult_taxo_gbnm(448638, 'Cuyuja robber frog').
ncbi_mult_taxo_gbnm(448644, 'Soberbo robber frog').
ncbi_mult_taxo_gbnm(448645, 'Colombian robber frog').
ncbi_mult_taxo_gbnm(448655, 'Rio Mamore robber frog').
ncbi_mult_taxo_gbnm(448659, 'yellow-spotted Andes frog').
ncbi_mult_taxo_gbnm(448662, 'Cochamba robber frog').
ncbi_mult_taxo_gbnm(448667, 'Rangel robber frog').
ncbi_mult_taxo_gbnm(448670, 'Ecuador robber frog').
ncbi_mult_taxo_gbnm(448676, 'Steindachner\'s robber frog').
ncbi_mult_taxo_gbnm(448677, 'Esmeraldas robber frog').
ncbi_mult_taxo_gbnm(448687, 'Caceres robber frog').
ncbi_mult_taxo_gbnm(448688, 'Hoehn\'s robber frog').
ncbi_mult_taxo_gbnm(448689, 'Holt\'s robber frog').
ncbi_mult_taxo_gbnm(448692, 'Pico Blanco robber frog').
ncbi_mult_taxo_gbnm(448695, 'imitator robber frog').
ncbi_mult_taxo_gbnm(448703, 'barking robber frog').
ncbi_mult_taxo_gbnm(448720, 'Lancini\'s robber frog').
ncbi_mult_taxo_gbnm(448721, 'metallic robber frog').
ncbi_mult_taxo_gbnm(448726, 'disc robber frog').
ncbi_mult_taxo_gbnm(448730, 'Leon\'s robber frog').
ncbi_mult_taxo_gbnm(448744, 'white-striped robber frog').
ncbi_mult_taxo_gbnm(448745, 'Lyman\'s robber frog').
ncbi_mult_taxo_gbnm(448754, 'marbled robber frog').
ncbi_mult_taxo_gbnm(448784, 'Tandapi robber frog').
ncbi_mult_taxo_gbnm(448787, 'Carchi robber frog').
ncbi_mult_taxo_gbnm(448789, 'Espirito Santo robber frog').
ncbi_mult_taxo_gbnm(448791, 'Bolivar robber frog').
ncbi_mult_taxo_gbnm(448792, 'Urdaneta robber frog').
ncbi_mult_taxo_gbnm(448803, 'Pichincha robber frog').
ncbi_mult_taxo_gbnm(448817, 'Huambos robber frog').
ncbi_mult_taxo_gbnm(448820, 'Cotopaxi robber frog').
ncbi_mult_taxo_gbnm(448828, 'flat-fingered robber frog').
ncbi_mult_taxo_gbnm(448829, 'side-striped robber frog').
ncbi_mult_taxo_gbnm(448834, 'Puerto Rican robber frog').
ncbi_mult_taxo_gbnm(448846, 'thickskin robber frog').
ncbi_mult_taxo_gbnm(448847, 'Lynch\'s Pilalo robber frog').
ncbi_mult_taxo_gbnm(448849, 'Rio Coca robber frog').
ncbi_mult_taxo_gbnm(448851, 'Zapadores robber frog').
ncbi_mult_taxo_gbnm(448853, 'Paraiba robber frog').
ncbi_mult_taxo_gbnm(448861, 'Canchaque robber frog').
ncbi_mult_taxo_gbnm(448864, 'Despax\'s robber frog').
ncbi_mult_taxo_gbnm(448868, 'Roze\'s robber frog').
ncbi_mult_taxo_gbnm(448881, 'Schulte\'s robber frog').
ncbi_mult_taxo_gbnm(448891, 'Simon Bolivar\'s robber frog').
ncbi_mult_taxo_gbnm(448892, 'Paramo Andes frog').
ncbi_mult_taxo_gbnm(448897, 'Sao Paulo robber frog').
ncbi_mult_taxo_gbnm(448899, 'spiny robber frog').
ncbi_mult_taxo_gbnm(448904, 'Salidero robber frog').
ncbi_mult_taxo_gbnm(448916, 'greater Pilalo robber frog').
ncbi_mult_taxo_gbnm(448919, 'Pachitea robber frog').
ncbi_mult_taxo_gbnm(448928, 'Lesser Antilles robber frog').
ncbi_mult_taxo_gbnm(448929, 'La Marca\'s robber frog').
ncbi_mult_taxo_gbnm(448935, 'Zacualtipan robber frog').
ncbi_mult_taxo_gbnm(448937, 'Loja robber frog').
ncbi_mult_taxo_gbnm(448938, 'vertebral robber frog').
ncbi_mult_taxo_gbnm(448946, 'Agua Buena robber frog').
ncbi_mult_taxo_gbnm(448947, 'Walker\'s robber frog').
ncbi_mult_taxo_gbnm(448949, 'Wiens\' robber frog').
ncbi_mult_taxo_gbnm(449221, 'Sanderson\'s streamfrog').
ncbi_mult_taxo_gbnm(449224, 'Cuzco Andes frog').
ncbi_mult_taxo_gbnm(449225, 'Peracca\'s Andes frog').
ncbi_mult_taxo_gbnm(449226, 'Peru Andes frog').
ncbi_mult_taxo_gbnm(449229, 'highland frogs').
ncbi_mult_taxo_gbnm(449230, 'Itatiaia highland frog').
ncbi_mult_taxo_gbnm(449232, 'Choco robber frog').
ncbi_mult_taxo_gbnm(449233, 'Mindo robber frog').
ncbi_mult_taxo_gbnm(449234, 'Nauta robber frog').
ncbi_mult_taxo_gbnm(449236, 'common big-headed frog').
ncbi_mult_taxo_gbnm(449287, 'Inca stone fish').
ncbi_mult_taxo_gbnm(449354, 'Green oriole').
ncbi_mult_taxo_gbnm(449360, 'green-backed whistler').
ncbi_mult_taxo_gbnm(449363, 'rusty whistler').
ncbi_mult_taxo_gbnm(449367, 'yellow-belllied whistler').
ncbi_mult_taxo_gbnm(449373, 'New Caledonian whistler').
ncbi_mult_taxo_gbnm(449378, 'Golden-backed whistler').
ncbi_mult_taxo_gbnm(449380, 'Wallacean whistler').
ncbi_mult_taxo_gbnm(449382, 'white-bellied whistler').
ncbi_mult_taxo_gbnm(449501, 'Dian\'s tarsier').
ncbi_mult_taxo_gbnm(449652, 'needlespine coral goby').
ncbi_mult_taxo_gbnm(449743, 'Puerto Cabello robber frog').
ncbi_mult_taxo_gbnm(449802, 'Tarahumara barking frog').
ncbi_mult_taxo_gbnm(449988, 'green guapote').
ncbi_mult_taxo_gbnm(449991, 'bluemouth cichlid').
ncbi_mult_taxo_gbnm(450203, 'rough shiner').
ncbi_mult_taxo_gbnm(450205, 'oak scurfy scale').
ncbi_mult_taxo_gbnm(450213, 'avian vampire fly').
ncbi_mult_taxo_gbnm(450223, 'yellowbelly threadfin bream').
ncbi_mult_taxo_gbnm(450224, 'red gurnard').
ncbi_mult_taxo_gbnm(450225, 'golden threadfin bream').
ncbi_mult_taxo_gbnm(450267, 'Pink fairy armadillo').
ncbi_mult_taxo_gbnm(450944, 'Dark sheath-tailed bat').
ncbi_mult_taxo_gbnm(450945, 'Seri\'s sheath-tailed bat').
ncbi_mult_taxo_gbnm(451382, 'crested myna').
ncbi_mult_taxo_gbnm(451385, 'Javan myna').
ncbi_mult_taxo_gbnm(451401, 'Hildebrandt\'s starling').
ncbi_mult_taxo_gbnm(451408, 'golden-breasted starling').
ncbi_mult_taxo_gbnm(451424, 'Chestnut-tailed starling').
ncbi_mult_taxo_gbnm(451425, 'Brahminy starling').
ncbi_mult_taxo_gbnm(451443, 'Gabonese clawed frog').
ncbi_mult_taxo_gbnm(451444, 'Biafran clawed frog').
ncbi_mult_taxo_gbnm(451448, 'Fischberg\'s clawed frog').
ncbi_mult_taxo_gbnm(451678, 'least rasbora').
ncbi_mult_taxo_gbnm(451688, 'silver rasbora').
ncbi_mult_taxo_gbnm(451690, 'greater scissortail').
ncbi_mult_taxo_gbnm(451695, 'glowlight rasbora').
ncbi_mult_taxo_gbnm(451735, 'cardinal nothobrach').
ncbi_mult_taxo_gbnm(451738, 'redtail notho').
ncbi_mult_taxo_gbnm(451741, 'spotted killifish').
ncbi_mult_taxo_gbnm(451742, 'bluefin notho').
ncbi_mult_taxo_gbnm(451745, 'Rio pearlfish').
ncbi_mult_taxo_gbnm(451859, 'electric blue hap').
ncbi_mult_taxo_gbnm(451888, 'bank sea bass').
ncbi_mult_taxo_gbnm(451889, 'rock sea bass').
ncbi_mult_taxo_gbnm(451890, 'belted sandfish').
ncbi_mult_taxo_gbnm(451892, 'pygmy sea bass').
ncbi_mult_taxo_gbnm(451894, 'Thomas\' Ichthyomyine').
ncbi_mult_taxo_gbnm(451896, 'Izecksohn\'s toad').
ncbi_mult_taxo_gbnm(452070, 'orangespotted snakehead').
ncbi_mult_taxo_gbnm(452071, 'Baram snakehead').
ncbi_mult_taxo_gbnm(452074, 'red-tailed snakehead').
ncbi_mult_taxo_gbnm(452076, 'golden snakehead').
ncbi_mult_taxo_gbnm(452081, 'Malabar snakehead').
ncbi_mult_taxo_gbnm(452104, 'broad-ringed white-eye').
ncbi_mult_taxo_gbnm(452322, 'European elm leafcurl aphid').
ncbi_mult_taxo_gbnm(452348, 'pass stubfoot toad').
ncbi_mult_taxo_gbnm(452595, 'Midas\' free-tailed bat').
ncbi_mult_taxo_gbnm(452596, 'Malagasy white-bellied free-tailed bat').
ncbi_mult_taxo_gbnm(452597, 'Asian small-clawed otter').
ncbi_mult_taxo_gbnm(452641, 'Spotted-necked otter').
ncbi_mult_taxo_gbnm(452642, 'Hairy-nosed otter').
ncbi_mult_taxo_gbnm(452644, 'Smooth-coated otter').
ncbi_mult_taxo_gbnm(452646, 'American mink').
ncbi_mult_taxo_gbnm(452653, 'Fringed long-footed myotis').
ncbi_mult_taxo_gbnm(452654, 'Chinese water myotis').
ncbi_mult_taxo_gbnm(452670, 'Nelson\'s small-eared shrew').
ncbi_mult_taxo_gbnm(453035, 'sorghum plant bug').
ncbi_mult_taxo_gbnm(453076, 'desert quandong').
ncbi_mult_taxo_gbnm(453083, 'northern sandalwood').
ncbi_mult_taxo_gbnm(453367, 'smooth spangle gall wasp').
ncbi_mult_taxo_gbnm(453448, 'button snails').
ncbi_mult_taxo_gbnm(453858, 'beaded gecko').
ncbi_mult_taxo_gbnm(453861, 'Pilbara ground gecko').
ncbi_mult_taxo_gbnm(453862, 'Lake Disappointment ground gecko').
ncbi_mult_taxo_gbnm(453864, 'mottled ground gecko').
ncbi_mult_taxo_gbnm(453924, 'Colorado cutthroat trout').
ncbi_mult_taxo_gbnm(453925, 'Yellowstone cutthroat throat').
ncbi_mult_taxo_gbnm(453929, 'greenback cutthroat trout').
ncbi_mult_taxo_gbnm(454028, 'slender rainbow sardine').
ncbi_mult_taxo_gbnm(454032, 'white sardine').
ncbi_mult_taxo_gbnm(454033, 'blackbelly lanternshark').
ncbi_mult_taxo_gbnm(454040, 'highfin moray').
ncbi_mult_taxo_gbnm(454056, 'black wing flyingfish').
ncbi_mult_taxo_gbnm(454142, 'southern red snapper').
ncbi_mult_taxo_gbnm(454370, 'North Borneo stream toad').
ncbi_mult_taxo_gbnm(454372, 'Malaya stream toad').
ncbi_mult_taxo_gbnm(454375, 'black flathead toad').
ncbi_mult_taxo_gbnm(454565, 'black firefly').
ncbi_mult_taxo_gbnm(454594, 'agent of mango bacterial black spot').
ncbi_mult_taxo_gbnm(454641, 'sugarbeet root maggot').
ncbi_mult_taxo_gbnm(454644, 'Bosnian alpine newt').
ncbi_mult_taxo_gbnm(454645, 'Montenegrin alpine newt').
ncbi_mult_taxo_gbnm(454752, 'northern banded newt').
ncbi_mult_taxo_gbnm(454919, 'white grub beetle').
ncbi_mult_taxo_gbnm(454924, 'coastal trevally').
ncbi_mult_taxo_gbnm(454931, 'bellyache bush').
ncbi_mult_taxo_gbnm(454933, 'goutystalk nettlespurge').
ncbi_mult_taxo_gbnm(455035, 'edible Chinese black ant').
ncbi_mult_taxo_gbnm(455045, okra).
ncbi_mult_taxo_gbnm(455156, 'fine flounder').
ncbi_mult_taxo_gbnm(455296, 'Portuguese dogfish').
ncbi_mult_taxo_gbnm(455430, 'cotton rosemallow').
ncbi_mult_taxo_gbnm(455451, 'Red Sea goatfish').
ncbi_mult_taxo_gbnm(455453, orbfish).
ncbi_mult_taxo_gbnm(455469, 'blotched croaker').
ncbi_mult_taxo_gbnm(455471, 'Tade mullet').
ncbi_mult_taxo_gbnm(455473, 'yellowhead spruce sawfly').
ncbi_mult_taxo_gbnm(455474, 'birch sawfly').
ncbi_mult_taxo_gbnm(455479, 'spotted rose snapper').
ncbi_mult_taxo_gbnm(456366, 'tiger shovelnose catfish').
ncbi_mult_taxo_gbnm(456400, 'D\'Orbigny\'s chat-tyrant').
ncbi_mult_taxo_gbnm(456401, 'slaty-backed chat-tyrant').
ncbi_mult_taxo_gbnm(456434, 'Yellow-olive flycatcher').
ncbi_mult_taxo_gbnm(456438, 'paltry tyrannulet').
ncbi_mult_taxo_gbnm(456472, 'Greater bandicoot rat').
ncbi_mult_taxo_gbnm(456473, 'Savile\'s bandicoot rat').
ncbi_mult_taxo_gbnm(456971, 'Greater dwarf shrew').
ncbi_mult_taxo_gbnm(457089, 'almond seed wasp').
ncbi_mult_taxo_gbnm(457291, 'Black bee-eater').
ncbi_mult_taxo_gbnm(457343, 'southern carmine bee-eater').
ncbi_mult_taxo_gbnm(457478, 'gorse weevil').
ncbi_mult_taxo_gbnm(457492, 'common spiny loach').
ncbi_mult_taxo_gbnm(457510, 'Gongota loach').
ncbi_mult_taxo_gbnm(457511, 'Choi\'s spiny loach').
ncbi_mult_taxo_gbnm(457520, 'white nose loach').
ncbi_mult_taxo_gbnm(457521, 'Nakdong nose loach').
ncbi_mult_taxo_gbnm(457526, 'Goalpara loach').
ncbi_mult_taxo_gbnm(458026, mirrorbelly).
ncbi_mult_taxo_gbnm(458089, 'Chinese egret').
ncbi_mult_taxo_gbnm(458123, 'Brehm\'s tiger-parrot').
ncbi_mult_taxo_gbnm(458151, 'black-bellied slender salamander').
ncbi_mult_taxo_gbnm(458195, 'red-billed dwarf hornbill').
ncbi_mult_taxo_gbnm(458295, 'Crosse\'s shrew').
ncbi_mult_taxo_gbnm(458296, 'Reddish-gray musk shrew').
ncbi_mult_taxo_gbnm(458314, 'Luzon shrew').
ncbi_mult_taxo_gbnm(458316, 'Swamp musk shrew').
ncbi_mult_taxo_gbnm(458317, 'Penninsular shrew').
ncbi_mult_taxo_gbnm(458319, 'Negev shrew').
ncbi_mult_taxo_gbnm(458320, 'Lesser gray-brown musk shrew').
ncbi_mult_taxo_gbnm(458323, 'Guldenstadt\'s white-toothed shrew').
ncbi_mult_taxo_gbnm(458326, 'climbing shrew').
ncbi_mult_taxo_gbnm(458329, 'Piebald shrew').
ncbi_mult_taxo_gbnm(458416, 'Southern African wildcat').
ncbi_mult_taxo_gbnm(458417, 'Central Asian wildcat').
ncbi_mult_taxo_gbnm(458418, 'Chinese desert cat').
ncbi_mult_taxo_gbnm(458493, 'brown encrusting octopus sponge').
ncbi_mult_taxo_gbnm(458545, 'Argentine seabass').
ncbi_mult_taxo_gbnm(458547, 'southern thorny skate').
ncbi_mult_taxo_gbnm(458554, 'hairy conger').
ncbi_mult_taxo_gbnm(458555, 'white-dotted skate').
ncbi_mult_taxo_gbnm(458556, 'broadnose skate').
ncbi_mult_taxo_gbnm(458558, 'graytail skate').
ncbi_mult_taxo_gbnm(458559, 'Patagonian skate').
ncbi_mult_taxo_gbnm(458560, 'Magellan skate').
ncbi_mult_taxo_gbnm(458561, 'multispine skate').
ncbi_mult_taxo_gbnm(458562, 'cuphead skate').
ncbi_mult_taxo_gbnm(458563, 'Brazilian menhaden').
ncbi_mult_taxo_gbnm(458564, 'banded whiptail').
ncbi_mult_taxo_gbnm(458566, 'Marini\'s grenadier').
ncbi_mult_taxo_gbnm(458567, 'stripped weakfish').
ncbi_mult_taxo_gbnm(458575, 'apron ray').
ncbi_mult_taxo_gbnm(458580, 'tile fish').
ncbi_mult_taxo_gbnm(458582, 'Atlantic sabretooth anchovy').
ncbi_mult_taxo_gbnm(458583, 'bigeye grenadier').
ncbi_mult_taxo_gbnm(458585, 'southern eagle ray').
ncbi_mult_taxo_gbnm(458586, 'southern hagfish').
ncbi_mult_taxo_gbnm(458592, 'orange bellowsfish').
ncbi_mult_taxo_gbnm(458596, 'parona leatherjacket').
ncbi_mult_taxo_gbnm(458598, 'Brazilian sandperch').
ncbi_mult_taxo_gbnm(458599, 'freckled sand skate').
ncbi_mult_taxo_gbnm(458600, 'smallthorn sand skate').
ncbi_mult_taxo_gbnm(458603, blobfish).
ncbi_mult_taxo_gbnm(458605, 'banded cusk eel').
ncbi_mult_taxo_gbnm(458609, 'narrowmouthed catshark').
ncbi_mult_taxo_gbnm(458610, 'choicy ruff').
ncbi_mult_taxo_gbnm(458612, 'smallnose fanskate').
ncbi_mult_taxo_gbnm(458613, 'Gulf hake').
ncbi_mult_taxo_gbnm(458843, 'blotched picarel').
ncbi_mult_taxo_gbnm(458845, 'dwarf slingjaw wrasse').
ncbi_mult_taxo_gbnm(459045, 'sharpnose sculpin').
ncbi_mult_taxo_gbnm(459046, 'calico sculpin').
ncbi_mult_taxo_gbnm(459047, 'mosshead sculpin').
ncbi_mult_taxo_gbnm(459050, 'saddleback sculpin').
ncbi_mult_taxo_gbnm(459051, 'rosy sculpin').
ncbi_mult_taxo_gbnm(459052, 'fluffy sculpin').
ncbi_mult_taxo_gbnm(459165, 'West Indian mahogany').
ncbi_mult_taxo_gbnm(459284, 'sin croaker').
ncbi_mult_taxo_gbnm(459285, 'spindle croaker').
ncbi_mult_taxo_gbnm(459504, 'trout barb').
ncbi_mult_taxo_gbnm(459508, 'five-lined coral goby').
ncbi_mult_taxo_gbnm(459509, 'rippled coralgoby').
ncbi_mult_taxo_gbnm(459512, 'burgundy thin-toed frog').
ncbi_mult_taxo_gbnm(459671, 'Western cottonmouth').
ncbi_mult_taxo_gbnm(459856, 'rat-tail radish').
ncbi_mult_taxo_gbnm(459920, 'golden spadefish').
ncbi_mult_taxo_gbnm(459921, 'old woman angelfish').
ncbi_mult_taxo_gbnm(459955, 'pied butcherbird').
ncbi_mult_taxo_gbnm(460091, 'fat-tailed gecko').
ncbi_mult_taxo_gbnm(460093, 'speckled stone gecko').
ncbi_mult_taxo_gbnm(460095, 'Byrne\'s gecko').
ncbi_mult_taxo_gbnm(460096, 'pale-striped ground gecko').
ncbi_mult_taxo_gbnm(460097, 'box-patterned gecko').
ncbi_mult_taxo_gbnm(460153, 'largespot river stingray').
ncbi_mult_taxo_gbnm(460154, 'bigtooth river stingray').
ncbi_mult_taxo_gbnm(460155, 'white-blotched river stingray').
ncbi_mult_taxo_gbnm(460156, 'rosette river stingray').
ncbi_mult_taxo_gbnm(460157, 'raspy river stingray').
ncbi_mult_taxo_gbnm(460199, 'cinnamon-bellied flowerpiercer').
ncbi_mult_taxo_gbnm(460200, 'Corn bunting').
ncbi_mult_taxo_gbnm(460201, 'Godlewski\'s bunting').
ncbi_mult_taxo_gbnm(460205, 'red-throated ant-tanager').
ncbi_mult_taxo_gbnm(460209, 'Thick-billed seed finch').
ncbi_mult_taxo_gbnm(460215, 'Black-headed Saltator').
ncbi_mult_taxo_gbnm(460219, 'Buff-throated saltator').
ncbi_mult_taxo_gbnm(460228, 'racoon tick').
ncbi_mult_taxo_gbnm(460616, 'spotted Caribbean gecko').
ncbi_mult_taxo_gbnm(460621, tarantolino).
ncbi_mult_taxo_gbnm(460622, 'yellow-headed gecko').
ncbi_mult_taxo_gbnm(460623, 'annulated gecko').
ncbi_mult_taxo_gbnm(460624, 'shieldhead gecko').
ncbi_mult_taxo_gbnm(460631, 'Atlas day gecko').
ncbi_mult_taxo_gbnm(460675, malbrouck).
ncbi_mult_taxo_gbnm(460987, 'maize orange leafhopper').
ncbi_mult_taxo_gbnm(461127, 'lesser purple emperor').
ncbi_mult_taxo_gbnm(461128, 'tawny rajah').
ncbi_mult_taxo_gbnm(461129, 'tawny emperor').
ncbi_mult_taxo_gbnm(461131, courtesan).
ncbi_mult_taxo_gbnm(461133, 'Indian purple emperor').
ncbi_mult_taxo_gbnm(461134, 'sergeant emperor').
ncbi_mult_taxo_gbnm(461138, 'eastern courtier').
ncbi_mult_taxo_gbnm(461219, 'Australian brown flycatcher').
ncbi_mult_taxo_gbnm(461220, 'rufous-naped whistler').
ncbi_mult_taxo_gbnm(461222, 'rose robin').
ncbi_mult_taxo_gbnm(461230, 'Black pitohui').
ncbi_mult_taxo_gbnm(461231, 'Palau morningbird').
ncbi_mult_taxo_gbnm(461239, 'wattled ploughbill').
ncbi_mult_taxo_gbnm(461245, 'blue-capped ifrita').
ncbi_mult_taxo_gbnm(461246, 'eastern whipbird').
ncbi_mult_taxo_gbnm(461258, 'dwarf goatfish').
ncbi_mult_taxo_gbnm(461259, 'roughback batfish').
ncbi_mult_taxo_gbnm(461282, 'spadefoot toad').
ncbi_mult_taxo_gbnm(461283, 'Hainan pseudomoustache toad').
ncbi_mult_taxo_gbnm(461284, 'Fujian Asian toad').
ncbi_mult_taxo_gbnm(461324, 'pygmy python').
ncbi_mult_taxo_gbnm(461325, 'large-blotched python').
ncbi_mult_taxo_gbnm(461326, 'woma python').
ncbi_mult_taxo_gbnm(461327, 'centralian carpet python').
ncbi_mult_taxo_gbnm(461328, 'rough-scaled python').
ncbi_mult_taxo_gbnm(461329, 'Oenpelli rock python').
ncbi_mult_taxo_gbnm(461341, 'Bismarck ringed python').
ncbi_mult_taxo_gbnm(461398, 'shaggy bat').
ncbi_mult_taxo_gbnm(461399, 'Guianan white-eared opossum').
ncbi_mult_taxo_gbnm(461400, 'giant red bat').
ncbi_mult_taxo_gbnm(461409, 'Panama slendeer opossum').
ncbi_mult_taxo_gbnm(461413, 'Ecuadoran spiny rat').
ncbi_mult_taxo_gbnm(461414, 'Guyanan spiny-rat').
ncbi_mult_taxo_gbnm(461415, 'Steere\'s spiny-rat').
ncbi_mult_taxo_gbnm(461416, 'Mt. Pirri climbing mouse').
ncbi_mult_taxo_gbnm(461499, 'Old World silversides').
ncbi_mult_taxo_gbnm(461500, 'blackfin silverside').
ncbi_mult_taxo_gbnm(461502, 'Chimalapa silverside').
ncbi_mult_taxo_gbnm(461503, 'largetooth silverside').
ncbi_mult_taxo_gbnm(461504, 'slender silverside').
ncbi_mult_taxo_gbnm(461505, 'smallmouth silverside').
ncbi_mult_taxo_gbnm(461506, 'ranch silverside').
ncbi_mult_taxo_gbnm(461507, 'Ajijic silverside').
ncbi_mult_taxo_gbnm(461508, 'bigeye silverside').
ncbi_mult_taxo_gbnm(461509, charal).
ncbi_mult_taxo_gbnm(461510, 'sharpnose silverside').
ncbi_mult_taxo_gbnm(461512, 'Toluca silverside').
ncbi_mult_taxo_gbnm(461513, 'bigmouth silverside').
ncbi_mult_taxo_gbnm(461514, 'golden silverside').
ncbi_mult_taxo_gbnm(461515, 'key silverside').
ncbi_mult_taxo_gbnm(461516, 'Waccamaw silverside').
ncbi_mult_taxo_gbnm(461517, 'tidewater silverside').
ncbi_mult_taxo_gbnm(461519, 'Alchichica silverside').
ncbi_mult_taxo_gbnm(461520, 'Chignahuapan silverside').
ncbi_mult_taxo_gbnm(461521, 'La Preciosa silverside').
ncbi_mult_taxo_gbnm(461522, 'Quechulac silverside').
ncbi_mult_taxo_gbnm(461682, 'apple wood stainer').
ncbi_mult_taxo_gbnm(461684, 'Fea\'s petrel').
ncbi_mult_taxo_gbnm(461707, 'red-throated squirrel').
ncbi_mult_taxo_gbnm(461708, 'orange-bellied Himalayan squirrel').
ncbi_mult_taxo_gbnm(461709, 'red-hipped squirrel').
ncbi_mult_taxo_gbnm(461710, 'Himalayan striped squirrel').
ncbi_mult_taxo_gbnm(462277, 'brilliant South American gecko').
ncbi_mult_taxo_gbnm(462278, 'O\'Shaughnessy\'s gecko').
ncbi_mult_taxo_gbnm(462279, 'South American gecko').
ncbi_mult_taxo_gbnm(462280, 'eyespot gecko').
ncbi_mult_taxo_gbnm(462318, 'Jinxiu bubble-nest frog').
ncbi_mult_taxo_gbnm(462319, 'Romer\'s bubble-nest frog').
ncbi_mult_taxo_gbnm(462321, 'Sichuan whipping frog').
ncbi_mult_taxo_gbnm(462322, 'Thao whipping frog').
ncbi_mult_taxo_gbnm(462324, 'Nepal flying frog').
ncbi_mult_taxo_gbnm(462328, 'Omei tree frog').
ncbi_mult_taxo_gbnm(462329, 'Dubois\' whipping frog').
ncbi_mult_taxo_gbnm(462351, 'three-wattled bellbird').
ncbi_mult_taxo_gbnm(462753, 'slight skink').
ncbi_mult_taxo_gbnm(463145, 'whale tapeworm').
ncbi_mult_taxo_gbnm(463207, 'European wildcat').
ncbi_mult_taxo_gbnm(463310, 'coastal blackbutt').
ncbi_mult_taxo_gbnm(463513, 'shortnose skink').
ncbi_mult_taxo_gbnm(463525, 'southeastern five-lined skink').
ncbi_mult_taxo_gbnm(463532, 'Ryukyu five-lined skink').
ncbi_mult_taxo_gbnm(463545, 'western skink').
ncbi_mult_taxo_gbnm(463596, 'Atlantic tripletail').
ncbi_mult_taxo_gbnm(463597, 'common silver-biddy').
ncbi_mult_taxo_gbnm(463598, 'paradise threadfin').
ncbi_mult_taxo_gbnm(463600, 'black-stripe sweeper').
ncbi_mult_taxo_gbnm(463694, 'toad\'s herb').
ncbi_mult_taxo_gbnm(463801, 'Thomas\'s sac-winged bat').
ncbi_mult_taxo_gbnm(463802, 'Ecuadorian sac-winged bat').
ncbi_mult_taxo_gbnm(463803, 'Greater ghost bat').
ncbi_mult_taxo_gbnm(463804, 'Trinidad dog-like bat').
ncbi_mult_taxo_gbnm(463805, 'Thomas\'s shaggy bat').
ncbi_mult_taxo_gbnm(463807, 'Long-winged tomb bat').
ncbi_mult_taxo_gbnm(463808, 'Noack\'s leaf-nosed bat').
ncbi_mult_taxo_gbnm(464112, 'smooth hornsnail').
ncbi_mult_taxo_gbnm(464348, 'flying tiger').
ncbi_mult_taxo_gbnm(464352, 'Anna tiger moth').
ncbi_mult_taxo_gbnm(464354, 'Blake\'s tiger moth').
ncbi_mult_taxo_gbnm(464359, 'Doris tiger moth').
ncbi_mult_taxo_gbnm(464362, 'figured tiger moth').
ncbi_mult_taxo_gbnm(464366, 'Nevada tiger moth').
ncbi_mult_taxo_gbnm(464371, 'Achaia moth').
ncbi_mult_taxo_gbnm(464372, 'Parthenice tiger moth').
ncbi_mult_taxo_gbnm(464373, 'Phyllira tiger moth').
ncbi_mult_taxo_gbnm(464375, 'Labrador tiger moth').
ncbi_mult_taxo_gbnm(464377, 'Williams\' tiger moth').
ncbi_mult_taxo_gbnm(464379, 'Leconte\'s haploa').
ncbi_mult_taxo_gbnm(464380, 'large ruby tiger moth').
ncbi_mult_taxo_gbnm(464719, 'Nais tiger moth').
ncbi_mult_taxo_gbnm(464721, 'clouded buff').
ncbi_mult_taxo_gbnm(464731, 'Bean\'s tiger moth').
ncbi_mult_taxo_gbnm(464735, 'Yarrow\'s tiger moth').
ncbi_mult_taxo_gbnm(464737, 'St. Lawrence tiger moth').
ncbi_mult_taxo_gbnm(464741, 'painted arachnis').
ncbi_mult_taxo_gbnm(464742, 'Kerguelen sandpaper skate').
ncbi_mult_taxo_gbnm(464743, 'McCain\'s skate').
ncbi_mult_taxo_gbnm(464744, 'dark-belly skate').
ncbi_mult_taxo_gbnm(464745, 'Murray\'s skate').
ncbi_mult_taxo_gbnm(464748, 'Richardson\'s ray').
ncbi_mult_taxo_gbnm(464749, 'narrownose skate').
ncbi_mult_taxo_gbnm(464755, 'Tor mahseer').
ncbi_mult_taxo_gbnm(464926, 'black citrus aphid').
ncbi_mult_taxo_gbnm(465449, 'Yunnan bamboo pitviper').
ncbi_mult_taxo_gbnm(465520, 'grey sunflower seed weevil').
ncbi_mult_taxo_gbnm(465521, 'red sunflower seed weevil').
ncbi_mult_taxo_gbnm(465717, 'Delacour\'s langur').
ncbi_mult_taxo_gbnm(465718, 'Laotian langur').
ncbi_mult_taxo_gbnm(465719, 'White-headed langur').
ncbi_mult_taxo_gbnm(465739, 'dark grass blue').
ncbi_mult_taxo_gbnm(465833, 'vampire moth').
ncbi_mult_taxo_gbnm(466111, 'golden angelfish').
ncbi_mult_taxo_gbnm(466112, 'Philippine butterflyfish').
ncbi_mult_taxo_gbnm(466113, 'bluelashed butterflyfish').
ncbi_mult_taxo_gbnm(466114, 'Burgess\' butterflyfish').
ncbi_mult_taxo_gbnm(466115, 'African butterflyfish').
ncbi_mult_taxo_gbnm(466116, 'blackwedged butterflyfish').
ncbi_mult_taxo_gbnm(466117, 'diagonal butterflyfish').
ncbi_mult_taxo_gbnm(466118, 'crochet butterflyfish').
ncbi_mult_taxo_gbnm(466119, 'four-banded butterfly fish').
ncbi_mult_taxo_gbnm(466120, 'spotfin butterflyfish').
ncbi_mult_taxo_gbnm(466122, 'three-banded butterflyfish').
ncbi_mult_taxo_gbnm(466123, 'reef butterflyfish').
ncbi_mult_taxo_gbnm(466124, 'yellow-dotted butterflyfish').
ncbi_mult_taxo_gbnm(466125, 'dotted butterflyfish').
ncbi_mult_taxo_gbnm(466127, 'margined coralfish').
ncbi_mult_taxo_gbnm(466128, 'twospot coralfish').
ncbi_mult_taxo_gbnm(466130, 'longnose butterflyfish').
ncbi_mult_taxo_gbnm(466131, 'masked bannerfish').
ncbi_mult_taxo_gbnm(466146, 'truncate coralfish').
ncbi_mult_taxo_gbnm(466148, 'blacknosed butterflyfish').
ncbi_mult_taxo_gbnm(466151, 'bank butterflyfish').
ncbi_mult_taxo_gbnm(466157, 'Mantiqueira Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466158, 'Orange-brown Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466159, 'golden Atlantic tree rat').
ncbi_mult_taxo_gbnm(466160, 'Drab Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466161, 'Pallid Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466162, 'Lund\'s Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466163, 'Black-spined Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466164, 'Rusty-sided Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466165, 'Short-furred Atlantic tree-rat').
ncbi_mult_taxo_gbnm(466267, 'elegant long-fingered frog').
ncbi_mult_taxo_gbnm(466535, 'Malaysian fireback').
ncbi_mult_taxo_gbnm(466585, grouses).
ncbi_mult_taxo_gbnm(466960, 'longheaded flour beetle').
ncbi_mult_taxo_gbnm(466962, 'black warrior').
ncbi_mult_taxo_gbnm(466964, mooneye).
ncbi_mult_taxo_gbnm(467030, 'red-fronted macaw').
ncbi_mult_taxo_gbnm(467031, 'great green macaw').
ncbi_mult_taxo_gbnm(467321, 'Himalayan knotweed').
ncbi_mult_taxo_gbnm(467358, 'cabbage seed weevil').
ncbi_mult_taxo_gbnm(467361, 'cabbage leaf weevil').
ncbi_mult_taxo_gbnm(467362, 'Lundy cabbage leaf weevil').
ncbi_mult_taxo_gbnm(467384, 'lundy cabbage flea beetle').
ncbi_mult_taxo_gbnm(467702, 'Rutenberg\'s reed frog').
ncbi_mult_taxo_gbnm(467704, 'Andrakata reed frog').
ncbi_mult_taxo_gbnm(467706, 'Rio Santiago poison frog').
ncbi_mult_taxo_gbnm(467733, 'tiny river frog').
ncbi_mult_taxo_gbnm(467736, 'horned river frog').
ncbi_mult_taxo_gbnm(467738, 'Kenya river frog').
ncbi_mult_taxo_gbnm(467739, 'calm puddle frog').
ncbi_mult_taxo_gbnm(467740, 'dwarf puddle frog').
ncbi_mult_taxo_gbnm(467741, 'Rungwe puddle frog').
ncbi_mult_taxo_gbnm(467742, 'Ukinga river frog').
ncbi_mult_taxo_gbnm(467772, 'green neon tetra').
ncbi_mult_taxo_gbnm(467774, 'morning-glory plume moth').
ncbi_mult_taxo_gbnm(467775, 'black-ball sponge').
ncbi_mult_taxo_gbnm(467779, 'Freetown long-fingered frog').
ncbi_mult_taxo_gbnm(467780, 'black long-fingered frog').
ncbi_mult_taxo_gbnm(468173, 'Lorkovic\'s brassy ringlet').
ncbi_mult_taxo_gbnm(468178, 'Gavarnie ringlet').
ncbi_mult_taxo_gbnm(468183, 'Spanish brassy ringlet').
ncbi_mult_taxo_gbnm(468186, 'Mnestra\'s ringlet').
ncbi_mult_taxo_gbnm(468187, 'de Lesse\'s brassy ringlet').
ncbi_mult_taxo_gbnm(468188, 'Ottoman brassy ringlet').
ncbi_mult_taxo_gbnm(468190, 'Pyrenees brassy ringlet').
ncbi_mult_taxo_gbnm(468193, 'Swiss brassy ringlet').
ncbi_mult_taxo_gbnm(468196, 'house mouse louse').
ncbi_mult_taxo_gbnm(468197, 'spined rat louse').
ncbi_mult_taxo_gbnm(468258, 'shield-backed bugs').
ncbi_mult_taxo_gbnm(468264, 'spined predatory shield bug').
ncbi_mult_taxo_gbnm(468371, 'Cypriot mouse').
ncbi_mult_taxo_gbnm(468483, 'stipple-throated antwren').
ncbi_mult_taxo_gbnm(468485, 'Bicolored antbird').
ncbi_mult_taxo_gbnm(468493, 'ferruginous-backed antbird').
ncbi_mult_taxo_gbnm(468512, 'white-breasted antbird').
ncbi_mult_taxo_gbnm(468750, 'slender-footed robberfly').
ncbi_mult_taxo_gbnm(468939, 'crepe myrtle flea beetle').
ncbi_mult_taxo_gbnm(468976, 'compact brome').
ncbi_mult_taxo_gbnm(469459, 'electric daisy').
ncbi_mult_taxo_gbnm(469649, 'Japanese broadwinged katydid').
ncbi_mult_taxo_gbnm(469658, 'Alabama shad').
ncbi_mult_taxo_gbnm(469659, 'hickory shad').
ncbi_mult_taxo_gbnm(469768, 'Major\'s long-tailed shrew tenrec').
ncbi_mult_taxo_gbnm(469796, 'Asiatic mouflon').
ncbi_mult_taxo_gbnm(470139, 'Maximovicz\'s vole').
ncbi_mult_taxo_gbnm(470227, 'bigmouth sculpin').
ncbi_mult_taxo_gbnm(470265, commodore).
ncbi_mult_taxo_gbnm(470425, 'African black tail scorpion').
ncbi_mult_taxo_gbnm(470560, 'Saharan striped polecat').
ncbi_mult_taxo_gbnm(470561, 'Lesser grison').
ncbi_mult_taxo_gbnm(470562, 'Burmese ferret-badger').
ncbi_mult_taxo_gbnm(470729, tugun).
ncbi_mult_taxo_gbnm(471099, 'bearded catfish').
ncbi_mult_taxo_gbnm(471117, 'pear psyllid').
ncbi_mult_taxo_gbnm(471148, 'bluestem goldenrod').
ncbi_mult_taxo_gbnm(471149, 'gray goldenrod').
ncbi_mult_taxo_gbnm(471154, 'showy goldenrod').
ncbi_mult_taxo_gbnm(471577, 'black sharkminnow').
ncbi_mult_taxo_gbnm(471578, 'signal barb').
ncbi_mult_taxo_gbnm(471641, 'bonylip barb').
ncbi_mult_taxo_gbnm(471713, 'Major Mitchell\'s cockatoo').
ncbi_mult_taxo_gbnm(471862, 'Least Tern').
ncbi_mult_taxo_gbnm(471941, 'running-postman').
ncbi_mult_taxo_gbnm(472225, 'boot sponge').
ncbi_mult_taxo_gbnm(472238, 'Formosan woolly horseshoe bat').
ncbi_mult_taxo_gbnm(472295, 'Katanga lion').
ncbi_mult_taxo_gbnm(472297, 'Somalian cavefish').
ncbi_mult_taxo_gbnm(472302, 'Philippine wrinkled ground frog').
ncbi_mult_taxo_gbnm(472707, 'Namaqua Micaelamys').
ncbi_mult_taxo_gbnm(472709, 'Andrew\'s Bunomys').
ncbi_mult_taxo_gbnm(472710, 'Griselda\'s Lemniscomys').
ncbi_mult_taxo_gbnm(472711, 'Hellwald\'s Sulawesi Maxomys').
ncbi_mult_taxo_gbnm(472760, 'Australian swamp rat').
ncbi_mult_taxo_gbnm(472761, 'Eastern New Guinea rat').
ncbi_mult_taxo_gbnm(472762, 'Eastern New Guinea mountain rat').
ncbi_mult_taxo_gbnm(472763, 'Stein\'s New Guinea rat').
ncbi_mult_taxo_gbnm(472764, 'New Guinea slender rat').
ncbi_mult_taxo_gbnm(472765, 'Atlantic midshipman').
ncbi_mult_taxo_gbnm(472766, 'scaly dragonfis').
ncbi_mult_taxo_gbnm(472767, 'blackfin goosefish').
ncbi_mult_taxo_gbnm(472777, 'Cinnamon Hummingbird').
ncbi_mult_taxo_gbnm(472801, 'green thorntail').
ncbi_mult_taxo_gbnm(472812, 'bronzy hermit').
ncbi_mult_taxo_gbnm(472859, 'modest filefish').
ncbi_mult_taxo_gbnm(472903, 'straight-billed hermit').
ncbi_mult_taxo_gbnm(472904, 'long-billed hermit').
ncbi_mult_taxo_gbnm(472905, 'Little hermit').
ncbi_mult_taxo_gbnm(472914, 'calliope hummingbird').
ncbi_mult_taxo_gbnm(472989, 'Chinese francolin').
ncbi_mult_taxo_gbnm(473049, steeplebush).
ncbi_mult_taxo_gbnm(473130, 'common lac scale').
ncbi_mult_taxo_gbnm(473184, 'South African carnation tortrix').
ncbi_mult_taxo_gbnm(473189, 'oriental sugar cane thrips').
ncbi_mult_taxo_gbnm(473297, hatchetfish).
ncbi_mult_taxo_gbnm(473299, lanternfish).
ncbi_mult_taxo_gbnm(473303, 'carapine grenadier').
ncbi_mult_taxo_gbnm(473304, 'Guenther\'s grenadier').
ncbi_mult_taxo_gbnm(473305, 'Mediterranean grenadier').
ncbi_mult_taxo_gbnm(473306, driftfish).
ncbi_mult_taxo_gbnm(473308, 'headlight fish').
ncbi_mult_taxo_gbnm(473309, 'spothead lantern fish').
ncbi_mult_taxo_gbnm(473310, 'white-spotted lantern fish').
ncbi_mult_taxo_gbnm(473311, 'chubby flashlightfish').
ncbi_mult_taxo_gbnm(473318, 'mirror lanternfish').
ncbi_mult_taxo_gbnm(473319, 'onion-eye grenadier').
ncbi_mult_taxo_gbnm(473320, 'palegold searsid').
ncbi_mult_taxo_gbnm(473321, 'smallscale searsid').
ncbi_mult_taxo_gbnm(473322, 'lantern fish').
ncbi_mult_taxo_gbnm(473325, 'shortfin spiny eel').
ncbi_mult_taxo_gbnm(473327, 'longnose tapirfish').
ncbi_mult_taxo_gbnm(473330, 'Arctic telescope').
ncbi_mult_taxo_gbnm(473331, 'gulper eel').
ncbi_mult_taxo_gbnm(473334, 'short-tooth sawpalate').
ncbi_mult_taxo_gbnm(473335, 'large scale lantern fish').
ncbi_mult_taxo_gbnm(473336, 'Power\'s deep-water bristle-mouth fish').
ncbi_mult_taxo_gbnm(473342, pricklefishes).
ncbi_mult_taxo_gbnm(473344, pricklefish).
ncbi_mult_taxo_gbnm(473346, 'blue antimora').
ncbi_mult_taxo_gbnm(473348, 'ribbon barracudina').
ncbi_mult_taxo_gbnm(473350, 'javelin spookfish').
ncbi_mult_taxo_gbnm(473352, 'elongate frostfish').
ncbi_mult_taxo_gbnm(473354, 'large-eye snaggletooth').
ncbi_mult_taxo_gbnm(473356, 'snaggletooths & stareaters').
ncbi_mult_taxo_gbnm(473361, 'rough longnose dogfish').
ncbi_mult_taxo_gbnm(473364, 'great lanternshark').
ncbi_mult_taxo_gbnm(473369, 'abyssal halosaur').
ncbi_mult_taxo_gbnm(473371, 'bighead searsid').
ncbi_mult_taxo_gbnm(473372, 'bigeye searsid').
ncbi_mult_taxo_gbnm(473374, lightfish).
ncbi_mult_taxo_gbnm(473378, 'roundhead grenadier').
ncbi_mult_taxo_gbnm(473382, 'Bigelow\'s ray').
ncbi_mult_taxo_gbnm(473385, 'Koefoed\'s searsid').
ncbi_mult_taxo_gbnm(473387, 'swallow grenadier').
ncbi_mult_taxo_gbnm(473393, 'blotch-necked moray').
ncbi_mult_taxo_gbnm(473451, 'Y-patterned moray').
ncbi_mult_taxo_gbnm(473452, 'lipspot moray').
ncbi_mult_taxo_gbnm(473453, 'Abbott\'s moray eel').
ncbi_mult_taxo_gbnm(473454, 'laced moray').
ncbi_mult_taxo_gbnm(473455, 'fimbriated moray').
ncbi_mult_taxo_gbnm(473456, 'liver-colored moray eel').
ncbi_mult_taxo_gbnm(473457, 'giant moray').
ncbi_mult_taxo_gbnm(473458, 'turkey moray').
ncbi_mult_taxo_gbnm(473459, 'Reeve\'s moray').
ncbi_mult_taxo_gbnm(473461, 'undulated moray').
ncbi_mult_taxo_gbnm(473861, 'grey-bellied shrew opossum').
ncbi_mult_taxo_gbnm(473865, 'Gray-bellied mouse').
ncbi_mult_taxo_gbnm(473866, 'Southern red-backed vole').
ncbi_mult_taxo_gbnm(473867, 'checkered elephant shrew').
ncbi_mult_taxo_gbnm(473869, 'Kalinowski\'s Thomasomys').
ncbi_mult_taxo_gbnm(473950, 'wool carder bee').
ncbi_mult_taxo_gbnm(473951, 'common hide beetle').
ncbi_mult_taxo_gbnm(473952, 'orchard mason bee').
ncbi_mult_taxo_gbnm(473964, 'Galapagos flightless cormorant').
ncbi_mult_taxo_gbnm(474095, 'warty grain mite').
ncbi_mult_taxo_gbnm(474160, 'Krombein\'s hairy-footed mite').
ncbi_mult_taxo_gbnm(474431, 'Vanzolini\'s spiny-chest frog').
ncbi_mult_taxo_gbnm(474432, 'olive spiny-chest frog').
ncbi_mult_taxo_gbnm(474924, 'Kamchatka leaf warbler').
ncbi_mult_taxo_gbnm(475045, 'Cope\'s leopard lizard').
ncbi_mult_taxo_gbnm(475046, 'San Joaquin leopard lizard').
ncbi_mult_taxo_gbnm(475165, 'shovelnose sea catfish').
ncbi_mult_taxo_gbnm(475166, 'redaxil emperor').
ncbi_mult_taxo_gbnm(475167, 'bigeye snapper').
ncbi_mult_taxo_gbnm(475168, 'dash-and-dot goatfish').
ncbi_mult_taxo_gbnm(475169, 'dusky sweeper').
ncbi_mult_taxo_gbnm(475170, 'variable sabretooth blenny').
ncbi_mult_taxo_gbnm(475189, 'redtipped halfbeak').
ncbi_mult_taxo_gbnm(475239, 'Peigler\'s oakworm moth').
ncbi_mult_taxo_gbnm(475251, 'spiny oakworm moth').
ncbi_mult_taxo_gbnm(475290, 'Riley\'s lappet moth').
ncbi_mult_taxo_gbnm(475335, 'tropical American silkworm moths').
ncbi_mult_taxo_gbnm(475452, 'Heude\'s pig').
ncbi_mult_taxo_gbnm(475618, 'Van der Decken\'s Sifaka').
ncbi_mult_taxo_gbnm(475771, 'false hour-glass tree frog').
ncbi_mult_taxo_gbnm(475813, 'western balsam bark beele').
ncbi_mult_taxo_gbnm(475929, 'sticktight flea').
ncbi_mult_taxo_gbnm(475991, 'blue tuskfish').
ncbi_mult_taxo_gbnm(476017, 'marbled rush frog').
ncbi_mult_taxo_gbnm(476026, 'bone cave harvestman').
ncbi_mult_taxo_gbnm(476203, 'Karimi\'s fat-tailed mouse oppossum').
ncbi_mult_taxo_gbnm(476251, 'Schrenck\'s Siberian newt').
ncbi_mult_taxo_gbnm(476260, 'Japanese fox').
ncbi_mult_taxo_gbnm(476284, 'Pygmy hog').
ncbi_mult_taxo_gbnm(476434, 'rabbit flea').
ncbi_mult_taxo_gbnm(476463, 'Pondo rock gecko').
ncbi_mult_taxo_gbnm(476505, 'Bynoe\'s prickly gecko').
ncbi_mult_taxo_gbnm(476506, 'cave prickly gecko').
ncbi_mult_taxo_gbnm(476587, 'West African Praomys').
ncbi_mult_taxo_gbnm(476588, 'Marshall\'s horseshoe bat').
ncbi_mult_taxo_gbnm(476589, 'Thomas\'s horseshoe bat').
ncbi_mult_taxo_gbnm(476914, 'Pacific sand lance').
ncbi_mult_taxo_gbnm(476919, 'Arctic rainbow smelt').
ncbi_mult_taxo_gbnm(476922, 'Atlantic rainbow smelt').
ncbi_mult_taxo_gbnm(476926, 'southern flathead sculpin').
ncbi_mult_taxo_gbnm(477288, 'swollen-headed conger eel').
ncbi_mult_taxo_gbnm(477289, 'hairy conger').
ncbi_mult_taxo_gbnm(477864, culantro).
ncbi_mult_taxo_gbnm(477932, 'Mesopotamian crow').
ncbi_mult_taxo_gbnm(477933, 'Sardinian hooded crow').
ncbi_mult_taxo_gbnm(477941, 'purplish jay').
ncbi_mult_taxo_gbnm(478208, 'greater hornwrack').
ncbi_mult_taxo_gbnm(478375, 'honey bee tracheal mite').
ncbi_mult_taxo_gbnm(478562, 'yellowish rice rat').
ncbi_mult_taxo_gbnm(478565, 'Texas rice rat').
ncbi_mult_taxo_gbnm(478633, 'Boat-billed flycatcher').
ncbi_mult_taxo_gbnm(478675, 'Jerdon\'s snake eye').
ncbi_mult_taxo_gbnm(478957, akamefugu).
ncbi_mult_taxo_gbnm(478964, 'yellow-stripe toadfish').
ncbi_mult_taxo_gbnm(478982, 'Ferguson\'s toad').
ncbi_mult_taxo_gbnm(478987, 'carmine shiner').
ncbi_mult_taxo_gbnm(478988, 'highland shiner').
ncbi_mult_taxo_gbnm(479078, 'remote chub').
ncbi_mult_taxo_gbnm(479081, 'Tepehuan shiner').
ncbi_mult_taxo_gbnm(479082, 'Mexican red shiner').
ncbi_mult_taxo_gbnm(479084, 'Manantial roundnose minnow').
ncbi_mult_taxo_gbnm(479085, 'spotted minnow').
ncbi_mult_taxo_gbnm(479086, 'Guadalupe roundnose minnow').
ncbi_mult_taxo_gbnm(479124, 'flatjaw minnow').
ncbi_mult_taxo_gbnm(479306, 'red prawn').
ncbi_mult_taxo_gbnm(479442, 'pinktoe tarantula').
ncbi_mult_taxo_gbnm(479477, 'Bourret\'s horseshoe bat').
ncbi_mult_taxo_gbnm(479500, 'giant scales').
ncbi_mult_taxo_gbnm(479626, 'common dittany').
ncbi_mult_taxo_gbnm(479639, 'sheepswool sponge').
ncbi_mult_taxo_gbnm(479651, 'eastern keelback mullet').
ncbi_mult_taxo_gbnm(479705, 'Sandstone dibbler').
ncbi_mult_taxo_gbnm(479706, 'Alexandria false Antechinus').
ncbi_mult_taxo_gbnm(479722, 'Osgood\'s horseshoe bat').
ncbi_mult_taxo_gbnm(479723, 'Malayan slit-faced bat').
ncbi_mult_taxo_gbnm(479862, 'unicorn leatherjacket').
ncbi_mult_taxo_gbnm(479879, 'lowland tropical bullfrog').
ncbi_mult_taxo_gbnm(479894, 'longnose frog').
ncbi_mult_taxo_gbnm(479977, 'Indian cabbage white').
ncbi_mult_taxo_gbnm(479980, 'Bering wolffish').
ncbi_mult_taxo_gbnm(480037, 'Baw Baw frog').
ncbi_mult_taxo_gbnm(480039, 'Bering cisco').
ncbi_mult_taxo_gbnm(480040, 'humpback whitefish').
ncbi_mult_taxo_gbnm(480084, 'Navajo yucca').
ncbi_mult_taxo_gbnm(480179, 'Zweifel\'s Papua frogs').
ncbi_mult_taxo_gbnm(480180, 'Danowaria callulops frog').
ncbi_mult_taxo_gbnm(480182, 'robust frog').
ncbi_mult_taxo_gbnm(480184, 'Torricelli mountain frog').
ncbi_mult_taxo_gbnm(480198, 'Alotau land frog').
ncbi_mult_taxo_gbnm(480199, 'Wandolleck\'s land frog').
ncbi_mult_taxo_gbnm(480200, 'nestfern cross frog').
ncbi_mult_taxo_gbnm(480203, 'doppelganger cross frog').
ncbi_mult_taxo_gbnm(480209, 'Wandammen Albericus frog').
ncbi_mult_taxo_gbnm(480213, 'Papua land frog').
ncbi_mult_taxo_gbnm(480214, 'snouted frogs').
ncbi_mult_taxo_gbnm(480215, 'ocellated snouted frog').
ncbi_mult_taxo_gbnm(480219, 'Schlegel\'s snouted frog').
ncbi_mult_taxo_gbnm(480294, 'bluespotted triggerfish').
ncbi_mult_taxo_gbnm(480296, 'halfmoon picassofish').
ncbi_mult_taxo_gbnm(480297, 'wedge-tail triggerfish').
ncbi_mult_taxo_gbnm(480298, 'blackbelly triggerfish').
ncbi_mult_taxo_gbnm(480299, 'bluethroat triggerfish').
ncbi_mult_taxo_gbnm(480300, 'halfmoon triggerfish').
ncbi_mult_taxo_gbnm(480301, 'redtail triggerfish').
ncbi_mult_taxo_gbnm(480302, 'Sargassum triggerfish').
ncbi_mult_taxo_gbnm(480622, 'Pajapan tropical night lizard').
ncbi_mult_taxo_gbnm(480662, 'Bristle-spined rat').
ncbi_mult_taxo_gbnm(480707, 'summer fruit tortrix moth').
ncbi_mult_taxo_gbnm(480805, 'Hinchinbrook Ctenotus').
ncbi_mult_taxo_gbnm(480907, 'mountain thatch palm').
ncbi_mult_taxo_gbnm(481309, 'beet webworm').
ncbi_mult_taxo_gbnm(481312, 'Lenis woolly bat').
ncbi_mult_taxo_gbnm(481313, 'Small woolly bat').
ncbi_mult_taxo_gbnm(481314, 'Whitehead\'s woolly bat').
ncbi_mult_taxo_gbnm(481459, 'three-spined stickleback').
ncbi_mult_taxo_gbnm(481462, 'unarmored threespine stickleback').
ncbi_mult_taxo_gbnm(481524, 'Gaige\'s rapids frog').
ncbi_mult_taxo_gbnm(481525, 'San Andre rapids frog').
ncbi_mult_taxo_gbnm(481548, 'winged lime').
ncbi_mult_taxo_gbnm(481574, 'long-nosed mole').
ncbi_mult_taxo_gbnm(481575, 'Willughby\'s leaf-cutter bee').
ncbi_mult_taxo_gbnm(481700, 'Korean oily bitterling').
ncbi_mult_taxo_gbnm(481707, 'Grant\'s golden mole').
ncbi_mult_taxo_gbnm(481756, 'Reeve\'s shad').
ncbi_mult_taxo_gbnm(481850, 'water-primrose flea beetle').
ncbi_mult_taxo_gbnm(481899, 'White-plumed honeyeater').
ncbi_mult_taxo_gbnm(481944, 'late purple aster').
ncbi_mult_taxo_gbnm(482143, 'Strinati\'s cave salamander').
ncbi_mult_taxo_gbnm(482357, 'club beak').
ncbi_mult_taxo_gbnm(482363, 'pale babul blue').
ncbi_mult_taxo_gbnm(482368, 'common onyx').
ncbi_mult_taxo_gbnm(482370, 'scarce silverstreak').
ncbi_mult_taxo_gbnm(482375, 'large glasswing').
ncbi_mult_taxo_gbnm(482537, 'Sunda flying lemur').
ncbi_mult_taxo_gbnm(482914, 'whirligig mullet').
ncbi_mult_taxo_gbnm(482915, 'leopard searobin').
ncbi_mult_taxo_gbnm(482919, pigfish).
ncbi_mult_taxo_gbnm(482931, locustberry).
ncbi_mult_taxo_gbnm(482954, 'Carolina vetch').
ncbi_mult_taxo_gbnm(482974, 'Hotson\'s Calomyscus').
ncbi_mult_taxo_gbnm(483034, 'ground squirrel flea').
ncbi_mult_taxo_gbnm(483075, 'prairie dog flea').
ncbi_mult_taxo_gbnm(483143, sappanwood).
ncbi_mult_taxo_gbnm(483259, 'cassava mealybug').
ncbi_mult_taxo_gbnm(483260, 'Solenopsis mealybug').
ncbi_mult_taxo_gbnm(483362, 'lined surgeonfish').
ncbi_mult_taxo_gbnm(483426, 'Dusky-footed elephant shrew').
ncbi_mult_taxo_gbnm(483427, 'Dusky elephant shrew').
ncbi_mult_taxo_gbnm(483428, 'Somali elephant shrew').
ncbi_mult_taxo_gbnm(483429, 'antheap white').
ncbi_mult_taxo_gbnm(483436, 'pearleaf blister mite').
ncbi_mult_taxo_gbnm(483513, 'trilling tailorbird').
ncbi_mult_taxo_gbnm(483536, 'Hainan gymnure').
ncbi_mult_taxo_gbnm(483748, loganberry).
ncbi_mult_taxo_gbnm(483865, 'Tapeti').
ncbi_mult_taxo_gbnm(483880, 'Vincent\'s sillago').
ncbi_mult_taxo_gbnm(484165, 'Caspian kutum').
ncbi_mult_taxo_gbnm(484371, 'White-throated Akodont').
ncbi_mult_taxo_gbnm(484400, 'Canary large white').
ncbi_mult_taxo_gbnm(484477, 'elongate nothobranch').
ncbi_mult_taxo_gbnm(484903, 'Schelkovnikov\'s pine vole').
ncbi_mult_taxo_gbnm(484905, 'Round-tailed muskrat').
ncbi_mult_taxo_gbnm(485423, 'Common Bunomys').
ncbi_mult_taxo_gbnm(485425, 'Kollmannsperger\'s Mastomys').
ncbi_mult_taxo_gbnm(485426, 'Burmese Metad').
ncbi_mult_taxo_gbnm(485431, 'blacktip sardinella').
ncbi_mult_taxo_gbnm(485433, 'longnose anchovy').
ncbi_mult_taxo_gbnm(485437, 'Brockman\'s Myomyscus').
ncbi_mult_taxo_gbnm(485438, 'Verreaux\'s white-footed rat').
ncbi_mult_taxo_gbnm(485439, 'Yemen white-footed rat').
ncbi_mult_taxo_gbnm(485440, 'White-footed Stenocephalemys').
ncbi_mult_taxo_gbnm(485526, 'Bolivar giant glass frog').
ncbi_mult_taxo_gbnm(485528, 'Venezuela Cochran frog').
ncbi_mult_taxo_gbnm(485529, 'Zidok Cochran frog').
ncbi_mult_taxo_gbnm(485574, 'currant shoot borer').
ncbi_mult_taxo_gbnm(485635, 'showy emerald moth').
ncbi_mult_taxo_gbnm(485637, 'pistachio emerald moth').
ncbi_mult_taxo_gbnm(485638, 'bluish spring moth').
ncbi_mult_taxo_gbnm(485725, 'prickly sesban').
ncbi_mult_taxo_gbnm(485912, 'large potter wasp').
ncbi_mult_taxo_gbnm(486150, 'smallmouth argentine').
ncbi_mult_taxo_gbnm(486151, 'pearl-spot chromis').
ncbi_mult_taxo_gbnm(486220, 'Boulenger\'s wrinkled ground frog').
ncbi_mult_taxo_gbnm(486222, 'Formosan pale chub').
ncbi_mult_taxo_gbnm(486224, 'Kap-Ping chub').
ncbi_mult_taxo_gbnm(486284, 'Pingtung stripe dace').
ncbi_mult_taxo_gbnm(486960, 'James\' sportive lemur').
ncbi_mult_taxo_gbnm(487036, 'drooping juniper').
ncbi_mult_taxo_gbnm(487038, 'one-seed juniper').
ncbi_mult_taxo_gbnm(487200, 'pinyon sawfly').
ncbi_mult_taxo_gbnm(487202, 'lodgepole pine sawfly').
ncbi_mult_taxo_gbnm(487207, 'hemlock sawfly').
ncbi_mult_taxo_gbnm(487618, 'celestial pearl danio').
ncbi_mult_taxo_gbnm(487675, pithead).
ncbi_mult_taxo_gbnm(487677, 'marbled moray cod').
ncbi_mult_taxo_gbnm(487985, 'dwarf minke whale').
ncbi_mult_taxo_gbnm(488216, 'Japanese knotweed').
ncbi_mult_taxo_gbnm(488224, 'pearly tree frog').
ncbi_mult_taxo_gbnm(488246, 'Baram whipping frog').
ncbi_mult_taxo_gbnm(488250, 'Ghat tree frog').
ncbi_mult_taxo_gbnm(488252, 'green tree frog').
ncbi_mult_taxo_gbnm(488309, 'belted kingfisher').
ncbi_mult_taxo_gbnm(488312, 'semicollared puffbird').
ncbi_mult_taxo_gbnm(488313, 'Red-fronted tinkerbird').
ncbi_mult_taxo_gbnm(488573, 'Larger yellow ant').
ncbi_mult_taxo_gbnm(488666, 'Josephine\'s Moon Snail').
ncbi_mult_taxo_gbnm(488792, 'Southern River terrapin').
ncbi_mult_taxo_gbnm(488942, 'squash beetle').
ncbi_mult_taxo_gbnm(488969, 'lolly bush').
ncbi_mult_taxo_gbnm(489037, 'northern largemouth bass').
ncbi_mult_taxo_gbnm(489059, 'Manchurian turk\'s-cap lily').
ncbi_mult_taxo_gbnm(489441, 'margined flyingfish').
ncbi_mult_taxo_gbnm(489448, 'Northern birch mouse').
ncbi_mult_taxo_gbnm(489759, 'glass tetra').
ncbi_mult_taxo_gbnm(490064, 'Zimmermann\'s poison frog').
ncbi_mult_taxo_gbnm(490104, 'Western broad-toothed field mouse').
ncbi_mult_taxo_gbnm(490146, 'Pac-Man catfish').
ncbi_mult_taxo_gbnm(490243, 'sailfin glass perchlet').
ncbi_mult_taxo_gbnm(490244, 'Hector\'s goby').
ncbi_mult_taxo_gbnm(490245, porkfish).
ncbi_mult_taxo_gbnm(490246, 'silver-rag driftfish').
ncbi_mult_taxo_gbnm(490248, 'bigtooth pomfret').
ncbi_mult_taxo_gbnm(490249, 'zebra tilefish').
ncbi_mult_taxo_gbnm(490250, 'lunar fusilier').
ncbi_mult_taxo_gbnm(490251, 'saucereye porgy').
ncbi_mult_taxo_gbnm(490252, 'magnificent splendid perch').
ncbi_mult_taxo_gbnm(490254, 'grey tilefish').
ncbi_mult_taxo_gbnm(490257, 'Englishman seabream').
ncbi_mult_taxo_gbnm(490258, 'stocky hawkfish').
ncbi_mult_taxo_gbnm(490259, 'Peruvian mojarra').
ncbi_mult_taxo_gbnm(490264, 'Chinese emperor').
ncbi_mult_taxo_gbnm(490265, 'yellowlip emperor').
ncbi_mult_taxo_gbnm(490266, 'African brown snapper').
ncbi_mult_taxo_gbnm(490268, 'bronze sunbream').
ncbi_mult_taxo_gbnm(490270, 'silver sweeper').
ncbi_mult_taxo_gbnm(490271, 'white-shouldered whiptail').
ncbi_mult_taxo_gbnm(490272, 'butterfly whiptail').
ncbi_mult_taxo_gbnm(490273, 'biglip grunt').
ncbi_mult_taxo_gbnm(490275, 'king threadfin').
ncbi_mult_taxo_gbnm(490276, 'yellowbar angelfish').
ncbi_mult_taxo_gbnm(490277, 'double-striped dottyback').
ncbi_mult_taxo_gbnm(490279, 'luna lion fish').
ncbi_mult_taxo_gbnm(490280, whalesucker).
ncbi_mult_taxo_gbnm(490282, 'threespot squirrelfish').
ncbi_mult_taxo_gbnm(490283, 'Peters\' monocle bream').
ncbi_mult_taxo_gbnm(490285, 'whitecheek monocle bream').
ncbi_mult_taxo_gbnm(490287, 'oriental sillago').
ncbi_mult_taxo_gbnm(490288, 'blue butterfish').
ncbi_mult_taxo_gbnm(490289, 'primitive archerfish').
ncbi_mult_taxo_gbnm(490301, 'Montane bamboo rat').
ncbi_mult_taxo_gbnm(490302, 'Rio Negro brush-tailed rat').
ncbi_mult_taxo_gbnm(490306, 'Giant armored tree-rat').
ncbi_mult_taxo_gbnm(490311, 'bigeye grunt').
ncbi_mult_taxo_gbnm(490316, 'curled picarel').
ncbi_mult_taxo_gbnm(490318, 'large toothed cardinalfish').
ncbi_mult_taxo_gbnm(490320, pennyfish).
ncbi_mult_taxo_gbnm(490323, 'striped large-eye bream').
ncbi_mult_taxo_gbnm(490326, 'rough flathead').
ncbi_mult_taxo_gbnm(490328, 'slender fusilier').
ncbi_mult_taxo_gbnm(490337, 'stone-bream').
ncbi_mult_taxo_gbnm(490339, 'pigmy sweeper').
ncbi_mult_taxo_gbnm(490341, 'rosy dwarf monocle bream').
ncbi_mult_taxo_gbnm(490343, 'eastern pomfred').
ncbi_mult_taxo_gbnm(490345, 'bulldog dentex').
ncbi_mult_taxo_gbnm(490349, 'Smith\'s litter frog').
ncbi_mult_taxo_gbnm(490372, 'willowy flounder').
ncbi_mult_taxo_gbnm(490388, 'westslope cutthroat trout').
ncbi_mult_taxo_gbnm(490540, 'banded leporinus').
ncbi_mult_taxo_gbnm(490585, 'Andaman lobster').
ncbi_mult_taxo_gbnm(490586, 'Arafura lobster').
ncbi_mult_taxo_gbnm(490587, 'northwest lobster').
ncbi_mult_taxo_gbnm(490588, 'Caribbean lobsterette').
ncbi_mult_taxo_gbnm(490589, 'bight lobster').
ncbi_mult_taxo_gbnm(490590, 'New Zealand lobster').
ncbi_mult_taxo_gbnm(490591, 'Formosa lobster').
ncbi_mult_taxo_gbnm(490592, 'Japanese lobster').
ncbi_mult_taxo_gbnm(490593, 'Neptune lobster').
ncbi_mult_taxo_gbnm(490594, 'sculpted lobster').
ncbi_mult_taxo_gbnm(490595, 'Siboga lobster').
ncbi_mult_taxo_gbnm(490596, 'China lobster').
ncbi_mult_taxo_gbnm(490597, 'velvet lobster').
ncbi_mult_taxo_gbnm(490730, 'large sand catchfly').
ncbi_mult_taxo_gbnm(490835, 'Mexican ash').
ncbi_mult_taxo_gbnm(490837, 'Carolina ash').
ncbi_mult_taxo_gbnm(490840, 'Himalayan manna ash').
ncbi_mult_taxo_gbnm(490850, 'Siebold ash').
ncbi_mult_taxo_gbnm(490875, 'Japanese rubyfish').
ncbi_